import { ComponentRef, ViewContainerRef } from '@angular/core';
import { NgbModalBackdrop } from './modal-backdrop';
import { NgbModalWindow } from './modal-window';
/**
 * A reference to a newly opened modal.
 */
export declare class NgbModalRef {
    private _viewContainerRef;
    private _windowCmptRef;
    private _backdropCmptRef;
    private _resolve;
    private _reject;
    /**
     * A promise that is resolved when a modal is closed and rejected when a modal is dismissed.
     */
    result: Promise<any>;
    constructor(_viewContainerRef: ViewContainerRef, _windowCmptRef: ComponentRef<NgbModalWindow>, _backdropCmptRef?: ComponentRef<NgbModalBackdrop>);
    /**
     * Can be used to close a modal, passing an optional result.
     */
    close(result?: any): void;
    /**
     * Can be used to dismiss a modal, passing an optional reason.
     */
    dismiss(reason?: any): void;
    private _removeModalElements();
}
