import { OnInit, AfterViewChecked, OnDestroy, Injector, Renderer, ElementRef, TemplateRef, ViewContainerRef, ComponentFactoryResolver } from '@angular/core';
import { NgbPopoverConfig } from './popover-config';
export declare class NgbPopoverWindow {
    placement: 'top' | 'bottom' | 'left' | 'right';
    title: string;
}
/**
 * A lightweight, extensible directive for fancy popover creation.
 */
export declare class NgbPopover implements OnInit, AfterViewChecked, OnDestroy {
    private _elementRef;
    private _renderer;
    /**
     * Content to be displayed as popover.
     */
    ngbPopover: string | TemplateRef<any>;
    /**
     * Title of a popover.
     */
    title: string;
    /**
     * Placement of a popover. Accepts: "top", "bottom", "left", "right"
     */
    placement: 'top' | 'bottom' | 'left' | 'right';
    /**
     * Specifies events that should trigger. Supports a space separated list of event names.
     */
    triggers: string;
    private _popupService;
    private _positioning;
    private _windowRef;
    private _unregisterListenersFn;
    constructor(_elementRef: ElementRef, _renderer: Renderer, injector: Injector, componentFactoryResolver: ComponentFactoryResolver, viewContainerRef: ViewContainerRef, config: NgbPopoverConfig);
    /**
     * Opens an element’s popover. This is considered a “manual” triggering of the popover.
     */
    open(): void;
    /**
     * Closes an element’s popover. This is considered a “manual” triggering of the popover.
     */
    close(): void;
    /**
     * Toggles an element’s popover. This is considered a “manual” triggering of the popover.
     */
    toggle(): void;
    ngOnInit(): void;
    ngAfterViewChecked(): void;
    ngOnDestroy(): void;
}
export declare const NGB_POPOVER_DIRECTIVES: (typeof NgbPopoverWindow | typeof NgbPopover)[];
