"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var util_1 = require('../util/util');
var progressbar_config_1 = require('./progressbar-config');
/**
 * Directive that can be used to provide feedback on the progress of a workflow or an action.
 */
var NgbProgressbar = (function () {
    function NgbProgressbar(config) {
        /**
         * Current value to be displayed in the progressbar. Should be smaller or equal to "max" value.
         */
        this.value = 0;
        this.max = config.max;
        this.animated = config.animated;
        this.striped = config.striped;
        this.type = config.type;
    }
    NgbProgressbar.prototype.getValue = function () { return util_1.getValueInRange(this.value, this.max); };
    NgbProgressbar.prototype.getPercentValue = function () { return 100 * this.getValue() / this.max; };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Number)
    ], NgbProgressbar.prototype, "max", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], NgbProgressbar.prototype, "animated", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], NgbProgressbar.prototype, "striped", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbProgressbar.prototype, "type", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbProgressbar.prototype, "value", void 0);
    NgbProgressbar = __decorate([
        core_1.Component({
            selector: 'ngb-progressbar',
            changeDetection: core_1.ChangeDetectionStrategy.OnPush,
            template: "\n    <progress class=\"progress {{type ? 'progress-' + type : ''}}\" \n      [class.progress-animated]=\"animated\" \n      [class.progress-striped]=\"striped\"\n      [max]=\"max\" [value]=\"getValue()\">\n      <div class=\"progress\">\n        <span class=\"progress-bar\" [style.width.%]=\"getPercentValue()\"><ng-content></ng-content></span>\n      </div>\n    </progress>\n  "
        }), 
        __metadata('design:paramtypes', [progressbar_config_1.NgbProgressbarConfig])
    ], NgbProgressbar);
    return NgbProgressbar;
}());
exports.NgbProgressbar = NgbProgressbar;
exports.NGB_PROGRESSBAR_DIRECTIVES = [NgbProgressbar];

//# sourceMappingURL=progressbar.js.map
