"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var tabset_config_1 = require('./tabset-config');
var nextId = 0;
/**
 * This directive should be used to wrap tab titles that need to contain HTML markup or other directives.
 */
var NgbTabTitle = (function () {
    function NgbTabTitle(templateRef) {
        this.templateRef = templateRef;
    }
    NgbTabTitle = __decorate([
        core_1.Directive({ selector: 'template[ngbTabTitle]' }), 
        __metadata('design:paramtypes', [core_1.TemplateRef])
    ], NgbTabTitle);
    return NgbTabTitle;
}());
exports.NgbTabTitle = NgbTabTitle;
/**
 * This directive must be used to wrap content to be displayed in a tab.
 */
var NgbTabContent = (function () {
    function NgbTabContent(templateRef) {
        this.templateRef = templateRef;
    }
    NgbTabContent = __decorate([
        core_1.Directive({ selector: 'template[ngbTabContent]' }), 
        __metadata('design:paramtypes', [core_1.TemplateRef])
    ], NgbTabContent);
    return NgbTabContent;
}());
exports.NgbTabContent = NgbTabContent;
/**
 * A directive representing an individual tab.
 */
var NgbTab = (function () {
    function NgbTab() {
        /**
         * Unique tab identifier. Must be unique for the entire document for proper accessibility support.
         */
        this.id = "ngb-tab-" + nextId++;
        /**
         * Allows toggling disabled state of a given state. Disabled tabs can't be selected.
         */
        this.disabled = false;
    }
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbTab.prototype, "id", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbTab.prototype, "title", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbTab.prototype, "disabled", void 0);
    __decorate([
        core_1.ContentChild(NgbTabContent), 
        __metadata('design:type', NgbTabContent)
    ], NgbTab.prototype, "contentTpl", void 0);
    __decorate([
        core_1.ContentChild(NgbTabTitle), 
        __metadata('design:type', NgbTabTitle)
    ], NgbTab.prototype, "titleTpl", void 0);
    NgbTab = __decorate([
        core_1.Directive({ selector: 'ngb-tab' }), 
        __metadata('design:paramtypes', [])
    ], NgbTab);
    return NgbTab;
}());
exports.NgbTab = NgbTab;
/**
 * A component that makes it easy to create tabbed interface.
 */
var NgbTabset = (function () {
    function NgbTabset(config) {
        /**
         * A tab change event fired right before the tab selection happens. See NgbTabChangeEvent for payload details
         */
        this.change = new core_1.EventEmitter();
        this.type = config.type;
    }
    /**
     * Selects the tab with the given id and shows its associated pane.
     * Any other tab that was previously selected becomes unselected and its associated pane is hidden.
     */
    NgbTabset.prototype.select = function (tabId) {
        var selectedTab = this._getTabById(tabId);
        if (selectedTab && !selectedTab.disabled && this.activeId !== selectedTab.id) {
            var defaultPrevented_1 = false;
            this.change.emit({ activeId: this.activeId, nextId: selectedTab.id, preventDefault: function () { defaultPrevented_1 = true; } });
            if (!defaultPrevented_1) {
                this.activeId = selectedTab.id;
            }
        }
    };
    NgbTabset.prototype.ngAfterContentChecked = function () {
        // auto-correct activeId that might have been set incorrectly as input
        var activeTab = this._getTabById(this.activeId);
        this.activeId = activeTab ? activeTab.id : (this.tabs.length ? this.tabs.first.id : null);
    };
    NgbTabset.prototype._getTabById = function (id) {
        var tabsWithId = this.tabs.filter(function (tab) { return tab.id === id; });
        return tabsWithId.length ? tabsWithId[0] : null;
    };
    __decorate([
        core_1.ContentChildren(NgbTab), 
        __metadata('design:type', core_1.QueryList)
    ], NgbTabset.prototype, "tabs", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbTabset.prototype, "activeId", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbTabset.prototype, "type", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', Object)
    ], NgbTabset.prototype, "change", void 0);
    NgbTabset = __decorate([
        core_1.Component({
            selector: 'ngb-tabset',
            exportAs: 'ngbTabset',
            template: "\n    <ul [class]=\"'nav nav-' + type\" role=\"tablist\">\n      <li class=\"nav-item\" *ngFor=\"let tab of tabs\">\n        <a [id]=\"tab.id\" class=\"nav-link\" [class.active]=\"tab.id === activeId\" [class.disabled]=\"tab.disabled\" \n          href (click)=\"!!select(tab.id)\">\n          {{tab.title}}<template [ngTemplateOutlet]=\"tab.titleTpl?.templateRef\"></template>\n        </a>\n      </li>\n    </ul>\n    <div class=\"tab-content\">\n      <template ngFor let-tab [ngForOf]=\"tabs\">\n        <div class=\"tab-pane active\" *ngIf=\"tab.id === activeId\" role=\"tabpanel\" [attr.aria-labelledby]=\"tab.id\">\n          <template [ngTemplateOutlet]=\"tab.contentTpl.templateRef\"></template>\n        </div>\n      </template>\n    </div>\n  "
        }), 
        __metadata('design:paramtypes', [tabset_config_1.NgbTabsetConfig])
    ], NgbTabset);
    return NgbTabset;
}());
exports.NgbTabset = NgbTabset;
exports.NGB_TABSET_DIRECTIVES = [NgbTabset, NgbTab, NgbTabContent, NgbTabTitle];

//# sourceMappingURL=tabset.js.map
