"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var util_1 = require('../util/util');
var NgbHighlight = (function () {
    function NgbHighlight() {
        this.highlightClass = 'ngb-highlight';
    }
    NgbHighlight.prototype.ngOnChanges = function () {
        var resultStr = util_1.toString(this.result);
        var resultLC = resultStr.toLowerCase();
        var termLC = util_1.toString(this.term).toLowerCase();
        var currentIdx = 0;
        if (termLC.length > 0) {
            this.parts = resultLC.split(new RegExp("(" + util_1.regExpEscape(termLC) + ")")).map(function (part) {
                var originalPart = resultStr.substr(currentIdx, part.length);
                currentIdx += part.length;
                return originalPart;
            });
        }
        else {
            this.parts = [resultStr];
        }
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbHighlight.prototype, "highlightClass", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbHighlight.prototype, "result", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], NgbHighlight.prototype, "term", void 0);
    NgbHighlight = __decorate([
        core_1.Component({
            selector: 'ngb-highlight',
            changeDetection: core_1.ChangeDetectionStrategy.OnPush,
            template: "<template ngFor [ngForOf]=\"parts\" let-part let-isOdd=\"odd\">" +
                "<span *ngIf=\"isOdd\" class=\"{{highlightClass}}\">{{part}}</span><template [ngIf]=\"!isOdd\">{{part}}</template>" +
                "</template>",
            styles: ["\n    .ngb-highlight {\n      font-weight: bold;\n    }\n  "]
        }), 
        __metadata('design:paramtypes', [])
    ], NgbHighlight);
    return NgbHighlight;
}());
exports.NgbHighlight = NgbHighlight;

//# sourceMappingURL=highlight.js.map
