"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('@angular/core');
var forms_1 = require('@angular/forms');
var Rx_1 = require('rxjs/Rx');
require('rxjs/add/operator/do');
require('rxjs/add/operator/let');
var positioning_1 = require('../util/positioning');
var typeahead_window_1 = require('./typeahead-window');
var popup_1 = require('../util/popup');
var util_1 = require('../util/util');
var Key;
(function (Key) {
    Key[Key["Tab"] = 9] = "Tab";
    Key[Key["Enter"] = 13] = "Enter";
    Key[Key["Escape"] = 27] = "Escape";
    Key[Key["ArrowUp"] = 38] = "ArrowUp";
    Key[Key["ArrowDown"] = 40] = "ArrowDown";
})(Key || (Key = {}));
var NGB_TYPEAHEAD_VALUE_ACCESSOR = {
    provide: forms_1.NG_VALUE_ACCESSOR,
    useExisting: core_1.forwardRef(function () { return NgbTypeahead; }),
    multi: true
};
/**
 * NgbTypeahead directive provides a simple way of creating powerful typeaheads from any text input
 */
var NgbTypeahead = (function () {
    function NgbTypeahead(_elementRef, _viewContainerRef, _renderer, _injector, componentFactoryResolver) {
        var _this = this;
        this._elementRef = _elementRef;
        this._viewContainerRef = _viewContainerRef;
        this._renderer = _renderer;
        this._injector = _injector;
        this._positioning = new positioning_1.Positioning();
        this._valueChanges = new Rx_1.Subject();
        /**
         * Show hint when an option in the result list matches.
         */
        this.showHint = false;
        /**
         * An event emitted when a match is selected. Event payload is equal to the selected item.
         */
        this.selectItem = new core_1.EventEmitter();
        this.onChange = function (value) {
            _this._onChangeNoEmit(value);
            _this._valueChanges.next(value);
        };
        this.onTouched = function () { };
        this._popupService = new popup_1.PopupService(typeahead_window_1.NgbTypeaheadWindow, _injector, _viewContainerRef, _renderer, componentFactoryResolver);
        this._onChangeNoEmit = function (_) { };
    }
    NgbTypeahead.prototype.ngAfterViewChecked = function () {
        if (this._windowRef) {
            var targetPosition = this._positioning.positionElements(this._elementRef.nativeElement, this._windowRef.location.nativeElement, 'bottom-left', false);
            var targetStyle = this._windowRef.location.nativeElement.style;
            targetStyle.top = targetPosition.top + "px";
            targetStyle.left = targetPosition.left + "px";
        }
    };
    NgbTypeahead.prototype.ngOnDestroy = function () { this._subscription.unsubscribe(); };
    NgbTypeahead.prototype.ngOnInit = function () {
        var _this = this;
        this._subscription =
            this._valueChanges.do(function (value) { return _this._userInput = value; }).let(this.ngbTypeahead).subscribe(function (results) {
                if (!results || results.length === 0) {
                    _this._closePopup();
                }
                else {
                    _this._openPopup();
                    _this._windowRef.instance.results = results;
                    _this._windowRef.instance.term = _this._elementRef.nativeElement.value;
                    if (_this.resultFormatter) {
                        _this._windowRef.instance.formatter = _this.resultFormatter;
                    }
                    if (_this.resultTemplate) {
                        _this._windowRef.instance.resultTemplate = _this.resultTemplate;
                    }
                    _this._showHint();
                }
            });
    };
    NgbTypeahead.prototype.registerOnChange = function (fn) { this._onChangeNoEmit = fn; };
    NgbTypeahead.prototype.registerOnTouched = function (fn) { this.onTouched = fn; };
    NgbTypeahead.prototype.writeValue = function (value) { this._writeInputValue(this._formatItemForInput(value)); };
    /**
     * @internal
     */
    NgbTypeahead.prototype.dismissPopup = function () {
        if (this.isPopupOpen()) {
            this._closePopup();
            this._writeInputValue(this._userInput);
        }
    };
    /**
     * @internal
     */
    NgbTypeahead.prototype.isPopupOpen = function () { return this._windowRef != null; };
    /**
     * @internal
     */
    NgbTypeahead.prototype.handleKeyDown = function (event) {
        if (!this._windowRef) {
            return;
        }
        if (Key[util_1.toString(event.which)]) {
            event.preventDefault();
            switch (event.which) {
                case Key.ArrowDown:
                    this._windowRef.instance.next();
                    this._showHint();
                    break;
                case Key.ArrowUp:
                    this._windowRef.instance.prev();
                    this._showHint();
                    break;
                case Key.Enter:
                case Key.Tab:
                    var result = this._windowRef.instance.getActive();
                    this._selectResult(result);
                    break;
                case Key.Escape:
                    this.dismissPopup();
                    break;
            }
        }
    };
    NgbTypeahead.prototype._openPopup = function () {
        var _this = this;
        if (!this._windowRef) {
            this._windowRef = this._popupService.open();
            this._windowRef.instance.selectEvent.subscribe(function (result) { return _this._selectResult(result); });
        }
    };
    NgbTypeahead.prototype._closePopup = function () {
        this._popupService.close();
        this._windowRef = null;
    };
    NgbTypeahead.prototype._selectResult = function (result) {
        this.writeValue(result);
        this._onChangeNoEmit(result);
        this.selectItem.emit(result);
        this._closePopup();
    };
    NgbTypeahead.prototype._showHint = function () {
        if (this.showHint) {
            var userInputLowerCase = this._userInput.toLowerCase();
            var formattedVal = this._formatItemForInput(this._windowRef.instance.getActive());
            if (userInputLowerCase === formattedVal.substr(0, this._userInput.length).toLowerCase()) {
                this._writeInputValue(this._userInput + formattedVal.substr(this._userInput.length));
                this._renderer.invokeElementMethod(this._elementRef.nativeElement, 'setSelectionRange', [this._userInput.length, formattedVal.length]);
            }
            else {
                this.writeValue(this._windowRef.instance.getActive());
            }
        }
    };
    NgbTypeahead.prototype._formatItemForInput = function (item) {
        return item && this.inputFormatter ? this.inputFormatter(item) : util_1.toString(item);
    };
    NgbTypeahead.prototype._writeInputValue = function (value) {
        this._renderer.setElementProperty(this._elementRef.nativeElement, 'value', value);
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Function)
    ], NgbTypeahead.prototype, "inputFormatter", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Function)
    ], NgbTypeahead.prototype, "ngbTypeahead", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Function)
    ], NgbTypeahead.prototype, "resultFormatter", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', core_1.TemplateRef)
    ], NgbTypeahead.prototype, "resultTemplate", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Object)
    ], NgbTypeahead.prototype, "showHint", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', Object)
    ], NgbTypeahead.prototype, "selectItem", void 0);
    NgbTypeahead = __decorate([
        core_1.Directive({
            selector: 'input[ngbTypeahead]',
            host: {
                '(blur)': 'onTouched()',
                '[class.open]': 'isPopupOpen()',
                '(document:click)': 'dismissPopup()',
                '(input)': 'onChange($event.target.value)',
                '(keydown)': 'handleKeyDown($event)',
                'autocomplete': 'off',
                'autocapitalize': 'off',
                'autocorrect': 'off'
            },
            providers: [NGB_TYPEAHEAD_VALUE_ACCESSOR]
        }), 
        __metadata('design:paramtypes', [core_1.ElementRef, core_1.ViewContainerRef, core_1.Renderer, core_1.Injector, core_1.ComponentFactoryResolver])
    ], NgbTypeahead);
    return NgbTypeahead;
}());
exports.NgbTypeahead = NgbTypeahead;
exports.NGB_TYPEAHEAD_DIRECTIVES = [NgbTypeahead];

//# sourceMappingURL=typeahead.js.map
