import { Component, Directive, Input, Output, EventEmitter, ChangeDetectionStrategy, ViewContainerRef, Injector, ComponentFactoryResolver, Renderer, TemplateRef } from '@angular/core';
import { PopupService } from '../util/popup';
import { NgbAlertConfig, NgbSelfClosingAlertConfig } from './alert-config';
/**
 * Alerts can be used to provide feedback messages.
 */
export var NgbAlert = (function () {
    function NgbAlert(config) {
        /**
         * An event emitted when the close button is clicked. This event has no payload. Only relevant for dismissible alerts.
         */
        this.close = new EventEmitter();
        this.dismissible = config.dismissible;
        this.type = config.type;
    }
    NgbAlert.prototype.closeHandler = function () { this.close.emit(null); };
    NgbAlert.decorators = [
        { type: Component, args: [{
                    selector: 'ngb-alert',
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    template: "\n    <div [class]=\"'alert alert-' + type\" role=\"alert\">\n      <button *ngIf=\"dismissible\" type=\"button\" class=\"close\" aria-label=\"Close\" (click)=\"closeHandler()\">\n            <span aria-hidden=\"true\">&times;</span>\n      </button>\n      <ng-content></ng-content>\n    </div>\n    "
                },] },
    ];
    /** @nocollapse */
    NgbAlert.ctorParameters = [
        { type: NgbAlertConfig, },
    ];
    NgbAlert.propDecorators = {
        'dismissible': [{ type: Input },],
        'type': [{ type: Input },],
        'close': [{ type: Output },],
    };
    return NgbAlert;
}());
/**
 * Alerts that can be dismissed without any additional code.
 */
export var NgbSelfClosingAlert = (function () {
    function NgbSelfClosingAlert(_templateRef, viewContainerRef, injector, componentFactoryResolver, renderer, config) {
        this._templateRef = _templateRef;
        /**
         * An event emitted when the close button is clicked.
         */
        this.closeEvent = new EventEmitter();
        this._popupService =
            new PopupService(NgbAlert, injector, viewContainerRef, renderer, componentFactoryResolver);
        this.dismissible = config.dismissible;
        this.type = config.type;
        this.dismissOnTimeout = config.dismissOnTimeout;
    }
    NgbSelfClosingAlert.prototype.close = function () { this._popupService.close(); };
    NgbSelfClosingAlert.prototype.ngOnInit = function () {
        var _this = this;
        var windowRef = this._popupService.open(this._templateRef);
        windowRef.instance.type = this.type;
        windowRef.instance.dismissible = this.dismissible;
        windowRef.instance.close.subscribe(function ($event) {
            _this.closeEvent.emit($event);
            _this.close();
        });
        if (this.dismissOnTimeout) {
            this._timeout = setTimeout(function () { _this.close(); }, this.dismissOnTimeout);
        }
    };
    NgbSelfClosingAlert.prototype.ngOnDestroy = function () { clearTimeout(this._timeout); };
    NgbSelfClosingAlert.decorators = [
        { type: Directive, args: [{ selector: 'template[ngbAlert]' },] },
    ];
    /** @nocollapse */
    NgbSelfClosingAlert.ctorParameters = [
        { type: TemplateRef, },
        { type: ViewContainerRef, },
        { type: Injector, },
        { type: ComponentFactoryResolver, },
        { type: Renderer, },
        { type: NgbSelfClosingAlertConfig, },
    ];
    NgbSelfClosingAlert.propDecorators = {
        'dismissible': [{ type: Input },],
        'type': [{ type: Input },],
        'closeEvent': [{ type: Output, args: ['close',] },],
        'dismissOnTimeout': [{ type: Input },],
    };
    return NgbSelfClosingAlert;
}());
export var NGB_ALERT_DIRECTIVES = [NgbAlert, NgbSelfClosingAlert];
//# sourceMappingURL=alert.js.map