import { Renderer, ElementRef, OnDestroy } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
/**
 * Easily create Bootstrap-style radio buttons. A value of a selected button is bound to a variable
 * specified via ngModel.
 */
export declare class NgbRadioGroup implements ControlValueAccessor {
    private _radios;
    private _value;
    onChange: (_: any) => void;
    onTouched: () => void;
    onRadioChange(radio: NgbRadio): void;
    onRadioValueUpdate(): void;
    register(radio: NgbRadio): void;
    registerOnChange(fn: (value: any) => any): void;
    registerOnTouched(fn: () => any): void;
    unregister(radio: NgbRadio): void;
    writeValue(value: any): void;
    private _updateRadios();
}
export declare class NgbActiveLabel {
    private _renderer;
    private _elRef;
    constructor(_renderer: Renderer, _elRef: ElementRef);
    active: boolean;
}
/**
 * Marks an input of type "radio" as part of the NgbRadioGroup.
 */
export declare class NgbRadio implements OnDestroy {
    private _group;
    private _label;
    private _renderer;
    private _element;
    private _value;
    private _checked;
    /**
     * You can specify model value of a given radio by binding to the value property.
    */
    value: any;
    readonly isChecked: boolean;
    constructor(_group: NgbRadioGroup, _label: NgbActiveLabel, _renderer: Renderer, _element: ElementRef);
    markChecked(value: any): void;
    ngOnDestroy(): void;
    onChange(): void;
}
export declare const NGB_RADIO_DIRECTIVES: (typeof NgbRadioGroup | typeof NgbActiveLabel | typeof NgbRadio)[];
