import { Directive, forwardRef, Optional, Input, Renderer, ElementRef } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
var NGB_RADIO_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(function () { return NgbRadioGroup; }),
    multi: true
};
/**
 * Easily create Bootstrap-style radio buttons. A value of a selected button is bound to a variable
 * specified via ngModel.
 */
export var NgbRadioGroup = (function () {
    function NgbRadioGroup() {
        this._radios = new Set();
        this._value = null;
        this.onChange = function (_) { };
        this.onTouched = function () { };
    }
    NgbRadioGroup.prototype.onRadioChange = function (radio) {
        this.writeValue(radio.value);
        this.onChange(radio.value);
    };
    NgbRadioGroup.prototype.onRadioValueUpdate = function () { this._updateRadios(); };
    NgbRadioGroup.prototype.register = function (radio) { this._radios.add(radio); };
    NgbRadioGroup.prototype.registerOnChange = function (fn) { this.onChange = fn; };
    NgbRadioGroup.prototype.registerOnTouched = function (fn) { this.onTouched = fn; };
    NgbRadioGroup.prototype.unregister = function (radio) { this._radios.delete(radio); };
    NgbRadioGroup.prototype.writeValue = function (value) {
        this._value = value;
        this._updateRadios();
    };
    NgbRadioGroup.prototype._updateRadios = function () {
        var _this = this;
        this._radios.forEach(function (radio) { return radio.markChecked(_this._value); });
    };
    NgbRadioGroup.decorators = [
        { type: Directive, args: [{
                    selector: '[ngbRadioGroup]',
                    host: { 'data-toggle': 'buttons', 'class': 'btn-group' },
                    providers: [NGB_RADIO_VALUE_ACCESSOR]
                },] },
    ];
    /** @nocollapse */
    NgbRadioGroup.ctorParameters = [];
    return NgbRadioGroup;
}());
export var NgbActiveLabel = (function () {
    function NgbActiveLabel(_renderer, _elRef) {
        this._renderer = _renderer;
        this._elRef = _elRef;
    }
    Object.defineProperty(NgbActiveLabel.prototype, "active", {
        set: function (isActive) { this._renderer.setElementClass(this._elRef.nativeElement, 'active', isActive); },
        enumerable: true,
        configurable: true
    });
    NgbActiveLabel.decorators = [
        { type: Directive, args: [{ selector: 'label.btn' },] },
    ];
    /** @nocollapse */
    NgbActiveLabel.ctorParameters = [
        { type: Renderer, },
        { type: ElementRef, },
    ];
    return NgbActiveLabel;
}());
/**
 * Marks an input of type "radio" as part of the NgbRadioGroup.
 */
export var NgbRadio = (function () {
    function NgbRadio(_group, _label, _renderer, _element) {
        this._group = _group;
        this._label = _label;
        this._renderer = _renderer;
        this._element = _element;
        this._value = null;
        if (this._group) {
            this._group.register(this);
        }
    }
    Object.defineProperty(NgbRadio.prototype, "value", {
        get: function () { return this._value; },
        /**
         * You can specify model value of a given radio by binding to the value property.
        */
        set: function (value) {
            this._value = value;
            var stringValue = value ? value.toString() : '';
            this._renderer.setElementProperty(this._element.nativeElement, 'value', stringValue);
            if (this._group) {
                this._group.onRadioValueUpdate();
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(NgbRadio.prototype, "isChecked", {
        get: function () { return this._checked; },
        enumerable: true,
        configurable: true
    });
    NgbRadio.prototype.markChecked = function (value) {
        this._checked = (this.value === value && value !== null);
        this._label.active = this._checked;
    };
    NgbRadio.prototype.ngOnDestroy = function () {
        if (this._group) {
            this._group.unregister(this);
        }
    };
    NgbRadio.prototype.onChange = function () {
        if (this._group) {
            this._group.onRadioChange(this);
        }
    };
    NgbRadio.decorators = [
        { type: Directive, args: [{ selector: 'input[type=radio]', host: { '(change)': 'onChange($event.target.value)', '[checked]': 'isChecked' } },] },
    ];
    /** @nocollapse */
    NgbRadio.ctorParameters = [
        { type: NgbRadioGroup, decorators: [{ type: Optional },] },
        { type: NgbActiveLabel, decorators: [{ type: Optional },] },
        { type: Renderer, },
        { type: ElementRef, },
    ];
    NgbRadio.propDecorators = {
        'value': [{ type: Input, args: ['value',] },],
    };
    return NgbRadio;
}());
export var NGB_RADIO_DIRECTIVES = [NgbRadio, NgbActiveLabel, NgbRadioGroup];
//# sourceMappingURL=radio.js.map