import { ElementRef, ViewContainerRef, Renderer, ComponentFactoryResolver, NgZone, TemplateRef } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { DayTemplateContext } from './datepicker-day-template-context';
import { NgbDateParserFormatter } from './ngb-date-parser-formatter';
/**
 * A directive that makes it possible to have datepickers on input fields.
 * Manages integration with the input field itself (data entry) and ngModel (validation etc.).
 */
export declare class NgbInputDatepicker implements ControlValueAccessor {
    private _parserFormatter;
    private _elRef;
    private _vcRef;
    private _renderer;
    private _cfr;
    private _cRef;
    private _model;
    private _zoneSubscription;
    /**
     * Reference for the custom template for the day display
     */
    dayTemplate: TemplateRef<DayTemplateContext>;
    /**
     * First day of the week, 0=Sun, 1=Mon, etc.
     */
    firstDayOfWeek: number;
    /**
     * Callback to mark a given date as disabled
     */
    markDisabled: (date: {
        year: number;
        month: number;
        day: number;
    }) => boolean;
    /**
     * Min date for the navigation. If not provided will be 10 years before today or `startDate`
     */
    minDate: {
        year: number;
        month: number;
        day: number;
    };
    /**
     * Max date for the navigation. If not provided will be 10 years from today or `startDate`
     */
    maxDate: {
        year: number;
        month: number;
        day: number;
    };
    /**
     * Whether to display navigation or not
     */
    showNavigation: boolean;
    /**
     * Whether to display days of the week
     */
    showWeekdays: boolean;
    /**
     * Whether to display week numbers
     */
    showWeekNumbers: boolean;
    /**
     * Date to open calendar with. If nothing provided, calendar will open with current month.
     * Use 'navigateTo(date)' as an alternative
     */
    startDate: {
        year: number;
        month: number;
    };
    private _onChange;
    private _onTouched;
    constructor(_parserFormatter: NgbDateParserFormatter, _elRef: ElementRef, _vcRef: ViewContainerRef, _renderer: Renderer, _cfr: ComponentFactoryResolver, ngZone: NgZone);
    isOpen(): boolean;
    /**
     * Opens the datepicker with the selected date indicated by the ngModel value.
     */
    open(): void;
    /**
     * Closes the datepicker popup.
     */
    close(): void;
    /**
     * Toggles the datepicker popup (opens when closed and closes when opened).
     */
    toggle(): void;
    /**
     * Navigates current view to provided date. If nothing provided calendar will open current month.
     * Use 'startDate' input as an alternative
     */
    navigateTo(date?: {
        year: number;
        month: number;
    }): void;
    private _applyDatepickerInputs(datepickerInstance);
    private _applyPopupStyling(nativeElement);
    private _writeModelValue(model);
}
