import { Directive, Input, Output, HostListener, EventEmitter } from '@angular/core';
import { NgbDropdownConfig } from './dropdown-config';
/**
 * Transforms a node into a dropdown.
 */
export var NgbDropdown = (function () {
    function NgbDropdown(config) {
        /**
         *  Defines whether or not the dropdown-menu is open initially.
         */
        this._open = false;
        /**
         *  An event fired when the dropdown is opened or closed.
         *  Event's payload equals whether dropdown is open.
         */
        this.openChange = new EventEmitter();
        this.up = config.up;
        this.autoClose = config.autoClose;
    }
    /**
     * Checks if the dropdown menu is open or not.
     */
    NgbDropdown.prototype.isOpen = function () { return this._open; };
    /**
     * Opens the dropdown menu of a given navbar or tabbed navigation.
     */
    NgbDropdown.prototype.open = function () {
        if (!this._open) {
            this._open = true;
            this.openChange.emit(true);
        }
    };
    /**
     * Closes the dropdown menu of a given navbar or tabbed navigation.
     */
    NgbDropdown.prototype.close = function () {
        if (this._open) {
            this._open = false;
            this.openChange.emit(false);
        }
    };
    /**
     * Toggles the dropdown menu of a given navbar or tabbed navigation.
     */
    NgbDropdown.prototype.toggle = function () {
        if (this.isOpen()) {
            this.close();
        }
        else {
            this.open();
        }
    };
    /**
     * @internal
     */
    NgbDropdown.prototype.closeFromOutside = function () {
        if (this.autoClose) {
            this.close();
        }
    };
    NgbDropdown.decorators = [
        { type: Directive, args: [{
                    selector: '[ngbDropdown]',
                    exportAs: 'ngbDropdown',
                    host: {
                        '[class.dropdown]': '!up',
                        '[class.dropup]': 'up',
                        '[class.open]': 'isOpen()',
                        '(keyup.esc)': 'closeFromOutside()',
                        '(document:click)': 'closeFromOutside()'
                    }
                },] },
    ];
    /** @nocollapse */
    NgbDropdown.ctorParameters = [
        { type: NgbDropdownConfig, },
    ];
    NgbDropdown.propDecorators = {
        'up': [{ type: Input },],
        'autoClose': [{ type: Input },],
        '_open': [{ type: Input, args: ['open',] },],
        'openChange': [{ type: Output },],
    };
    return NgbDropdown;
}());
/**
 * Allows the dropdown to be toggled via click. This directive is optional.
 */
export var NgbDropdownToggle = (function () {
    function NgbDropdownToggle(_dropdown) {
        this._dropdown = _dropdown;
    }
    NgbDropdownToggle.prototype.toggleOpen = function ($event) {
        $event.stopPropagation();
        this._dropdown.toggle();
    };
    NgbDropdownToggle.decorators = [
        { type: Directive, args: [{
                    selector: '[ngbDropdownToggle]',
                    host: { 'class': 'dropdown-toggle', 'aria-haspopup': 'true', '[attr.aria-expanded]': '_dropdown.isOpen()' }
                },] },
    ];
    /** @nocollapse */
    NgbDropdownToggle.ctorParameters = [
        { type: NgbDropdown, },
    ];
    NgbDropdownToggle.propDecorators = {
        'toggleOpen': [{ type: HostListener, args: ['click', ['$event'],] },],
    };
    return NgbDropdownToggle;
}());
export var NGB_DROPDOWN_DIRECTIVES = [NgbDropdownToggle, NgbDropdown];
//# sourceMappingURL=dropdown.js.map