import { Directive, Injector, Renderer, TemplateRef, ViewContainerRef, ComponentFactoryResolver } from '@angular/core';
import { isDefined } from '../util/util';
import { NgbModalBackdrop } from './modal-backdrop';
import { NgbModalWindow } from './modal-window';
import { NgbModalStack } from './modal-stack';
import { NgbModalRef } from './modal-ref';
var ModalContentContext = (function () {
    function ModalContentContext() {
    }
    ModalContentContext.prototype.close = function (result) { };
    ModalContentContext.prototype.dismiss = function (reason) { };
    return ModalContentContext;
}());
export var NgbModalContainer = (function () {
    function NgbModalContainer(_injector, _renderer, _viewContainerRef, componentFactoryResolver, ngbModalStack) {
        this._injector = _injector;
        this._renderer = _renderer;
        this._viewContainerRef = _viewContainerRef;
        this._backdropFactory = componentFactoryResolver.resolveComponentFactory(NgbModalBackdrop);
        this._windowFactory = componentFactoryResolver.resolveComponentFactory(NgbModalWindow);
        ngbModalStack.registerContainer(this);
    }
    NgbModalContainer.prototype.open = function (content, options) {
        var modalContentContext = new ModalContentContext();
        var nodes = this._getContentNodes(content, modalContentContext);
        var windowCmptRef = this._viewContainerRef.createComponent(this._windowFactory, 0, this._injector, nodes);
        var backdropCmptRef;
        var ngbModalRef;
        if (options.backdrop !== false) {
            backdropCmptRef = this._viewContainerRef.createComponent(this._backdropFactory, 0, this._injector);
        }
        ngbModalRef = new NgbModalRef(this._viewContainerRef, windowCmptRef, backdropCmptRef);
        modalContentContext.close = function (result) { ngbModalRef.close(result); };
        modalContentContext.dismiss = function (reason) { ngbModalRef.dismiss(reason); };
        this._applyWindowOptions(windowCmptRef.instance, options);
        return ngbModalRef;
    };
    NgbModalContainer.prototype._applyWindowOptions = function (windowInstance, options) {
        ['backdrop', 'keyboard', 'size'].forEach(function (optionName) {
            if (isDefined(options[optionName])) {
                windowInstance[optionName] = options[optionName];
            }
        });
    };
    NgbModalContainer.prototype._getContentNodes = function (content, context) {
        if (!content) {
            return [];
        }
        else if (content instanceof TemplateRef) {
            return [this._viewContainerRef.createEmbeddedView(content, context).rootNodes];
        }
        else {
            return [[this._renderer.createText(null, "" + content)]];
        }
    };
    NgbModalContainer.decorators = [
        { type: Directive, args: [{ selector: 'template[ngbModalContainer]' },] },
    ];
    /** @nocollapse */
    NgbModalContainer.ctorParameters = [
        { type: Injector, },
        { type: Renderer, },
        { type: ViewContainerRef, },
        { type: ComponentFactoryResolver, },
        { type: NgbModalStack, },
    ];
    return NgbModalContainer;
}());
//# sourceMappingURL=modal-container.js.map