import { Injectable, ComponentRef, ViewContainerRef } from '@angular/core';
/**
 * A reference to a newly opened modal.
 */
export var NgbModalRef = (function () {
    function NgbModalRef(_viewContainerRef, _windowCmptRef, _backdropCmptRef) {
        var _this = this;
        this._viewContainerRef = _viewContainerRef;
        this._windowCmptRef = _windowCmptRef;
        this._backdropCmptRef = _backdropCmptRef;
        _windowCmptRef.instance.dismissEvent.subscribe(function (reason) { _this.dismiss(reason); });
        this.result = new Promise(function (resolve, reject) {
            _this._resolve = resolve;
            _this._reject = reject;
        });
    }
    /**
     * Can be used to close a modal, passing an optional result.
     */
    NgbModalRef.prototype.close = function (result) {
        if (this._windowCmptRef) {
            this._resolve(result);
            this._removeModalElements();
        }
    };
    /**
     * Can be used to dismiss a modal, passing an optional reason.
     */
    NgbModalRef.prototype.dismiss = function (reason) {
        if (this._windowCmptRef) {
            this._reject(reason);
            this._removeModalElements();
        }
    };
    NgbModalRef.prototype._removeModalElements = function () {
        this._viewContainerRef.remove(this._viewContainerRef.indexOf(this._windowCmptRef.hostView));
        if (this._backdropCmptRef) {
            this._viewContainerRef.remove(this._viewContainerRef.indexOf(this._backdropCmptRef.hostView));
        }
        this._windowCmptRef = null;
        this._backdropCmptRef = null;
    };
    NgbModalRef.decorators = [
        { type: Injectable },
    ];
    /** @nocollapse */
    NgbModalRef.ctorParameters = [
        { type: ViewContainerRef, },
        { type: ComponentRef, },
        { type: ComponentRef, },
    ];
    return NgbModalRef;
}());
//# sourceMappingURL=modal-ref.js.map