import { Component, Output, EventEmitter, Input, ElementRef, Renderer } from '@angular/core';
import { ModalDismissReasons } from './modal-dismiss-reasons';
export var NgbModalWindow = (function () {
    function NgbModalWindow(_elRef, _renderer) {
        this._elRef = _elRef;
        this._renderer = _renderer;
        this.backdrop = true;
        this.keyboard = true;
        this.dismissEvent = new EventEmitter();
    }
    NgbModalWindow.prototype.backdropClick = function () {
        if (this.backdrop === true) {
            this.dismiss(ModalDismissReasons.BACKDROP_CLICK);
        }
    };
    NgbModalWindow.prototype.escKey = function ($event) {
        if (this.keyboard && !$event.defaultPrevented) {
            this.dismiss(ModalDismissReasons.ESC);
        }
    };
    NgbModalWindow.prototype.dismiss = function (reason) { this.dismissEvent.emit(reason); };
    NgbModalWindow.prototype.stopPropagation = function ($event) { $event.stopPropagation(); };
    NgbModalWindow.prototype.ngOnInit = function () {
        this._elWithFocus = document.activeElement;
        this._renderer.setElementClass(document.body, 'modal-open', true);
    };
    NgbModalWindow.prototype.ngAfterViewInit = function () {
        if (!this._isNodeChildOfAnother(this._elRef.nativeElement, document.activeElement)) {
            this._renderer.invokeElementMethod(this._elRef.nativeElement, 'focus', []);
        }
    };
    NgbModalWindow.prototype.ngOnDestroy = function () {
        if (this._elWithFocus && this._isNodeChildOfAnother(document.body, this._elWithFocus)) {
            this._renderer.invokeElementMethod(this._elWithFocus, 'focus', []);
        }
        else {
            this._renderer.invokeElementMethod(document.body, 'focus', []);
        }
        this._elWithFocus = null;
        this._renderer.setElementClass(document.body, 'modal-open', false);
    };
    NgbModalWindow.prototype._isNodeChildOfAnother = function (parentNode, potentialChildNode) { return parentNode.contains(potentialChildNode); };
    NgbModalWindow.decorators = [
        { type: Component, args: [{
                    selector: 'ngb-modal-window',
                    host: {
                        'class': 'modal fade in',
                        'role': 'dialog',
                        'tabindex': '-1',
                        'style': 'display: block;',
                        '(keyup.esc)': 'escKey($event)',
                        '(click)': 'backdropClick()'
                    },
                    template: "\n    <div [class]=\"'modal-dialog' + (size ? ' modal-' + size : '')\" role=\"document\">\n        <div class=\"modal-content\" (click)=\"stopPropagation($event)\"><ng-content></ng-content></div>\n    </div>\n    "
                },] },
    ];
    /** @nocollapse */
    NgbModalWindow.ctorParameters = [
        { type: ElementRef, },
        { type: Renderer, },
    ];
    NgbModalWindow.propDecorators = {
        'backdrop': [{ type: Input },],
        'keyboard': [{ type: Input },],
        'size': [{ type: Input },],
        'dismissEvent': [{ type: Output, args: ['dismiss',] },],
    };
    return NgbModalWindow;
}());
//# sourceMappingURL=modal-window.js.map