import { Injectable } from '@angular/core';
import { NgbModalStack } from './modal-stack';
/**
 * A service to open modal windows. Creating a modal is straightforward: create a template and pass it as an argument to
 * the "open" method!
 */
export var NgbModal = (function () {
    function NgbModal(_modalStack) {
        this._modalStack = _modalStack;
    }
    /**
     * Opens a new modal window with the specified content and using supplied options.
     */
    NgbModal.prototype.open = function (content, options) {
        if (options === void 0) { options = {}; }
        return this._modalStack.open(content, options);
    };
    NgbModal.decorators = [
        { type: Injectable },
    ];
    /** @nocollapse */
    NgbModal.ctorParameters = [
        { type: NgbModalStack, },
    ];
    return NgbModal;
}());
//# sourceMappingURL=modal.js.map