import { Component, Directive, Input, ChangeDetectionStrategy, Injector, Renderer, ElementRef, ViewContainerRef, ComponentFactoryResolver, NgZone } from '@angular/core';
import { listenToTriggers } from '../util/triggers';
import { positionElements } from '../util/positioning';
import { PopupService } from '../util/popup';
import { NgbPopoverConfig } from './popover-config';
export var NgbPopoverWindow = (function () {
    function NgbPopoverWindow() {
        this.placement = 'top';
    }
    NgbPopoverWindow.decorators = [
        { type: Component, args: [{
                    selector: 'ngb-popover-window',
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    host: { '[class]': '"popover in popover-" + placement', 'role': 'tooltip' },
                    template: "\n    <div class=\"popover-arrow\"></div>\n    <h3 class=\"popover-title\">{{title}}</h3><div class=\"popover-content\"><ng-content></ng-content></div>\n    "
                },] },
    ];
    /** @nocollapse */
    NgbPopoverWindow.ctorParameters = [];
    NgbPopoverWindow.propDecorators = {
        'placement': [{ type: Input },],
        'title': [{ type: Input },],
    };
    return NgbPopoverWindow;
}());
/**
 * A lightweight, extensible directive for fancy popover creation.
 */
export var NgbPopover = (function () {
    function NgbPopover(_elementRef, _renderer, injector, componentFactoryResolver, viewContainerRef, config, ngZone) {
        var _this = this;
        this._elementRef = _elementRef;
        this._renderer = _renderer;
        this.placement = config.placement;
        this.triggers = config.triggers;
        this._popupService = new PopupService(NgbPopoverWindow, injector, viewContainerRef, _renderer, componentFactoryResolver);
        this._zoneSubscription = ngZone.onStable.subscribe(function () {
            if (_this._windowRef) {
                positionElements(_this._elementRef.nativeElement, _this._windowRef.location.nativeElement, _this.placement);
            }
        });
    }
    /**
     * Opens an element’s popover. This is considered a “manual” triggering of the popover.
     */
    NgbPopover.prototype.open = function () {
        if (!this._windowRef) {
            this._windowRef = this._popupService.open(this.ngbPopover);
            this._windowRef.instance.placement = this.placement;
            this._windowRef.instance.title = this.title;
        }
    };
    /**
     * Closes an element’s popover. This is considered a “manual” triggering of the popover.
     */
    NgbPopover.prototype.close = function () {
        this._popupService.close();
        this._windowRef = null;
    };
    /**
     * Toggles an element’s popover. This is considered a “manual” triggering of the popover.
     */
    NgbPopover.prototype.toggle = function () {
        if (this._windowRef) {
            this.close();
        }
        else {
            this.open();
        }
    };
    NgbPopover.prototype.ngOnInit = function () {
        this._unregisterListenersFn = listenToTriggers(this._renderer, this._elementRef.nativeElement, this.triggers, this.open.bind(this), this.close.bind(this), this.toggle.bind(this));
    };
    NgbPopover.prototype.ngOnDestroy = function () {
        this._unregisterListenersFn();
        this._zoneSubscription.unsubscribe();
    };
    NgbPopover.decorators = [
        { type: Directive, args: [{ selector: '[ngbPopover]', exportAs: 'ngbPopover' },] },
    ];
    /** @nocollapse */
    NgbPopover.ctorParameters = [
        { type: ElementRef, },
        { type: Renderer, },
        { type: Injector, },
        { type: ComponentFactoryResolver, },
        { type: ViewContainerRef, },
        { type: NgbPopoverConfig, },
        { type: NgZone, },
    ];
    NgbPopover.propDecorators = {
        'ngbPopover': [{ type: Input },],
        'title': [{ type: Input },],
        'placement': [{ type: Input },],
        'triggers': [{ type: Input },],
    };
    return NgbPopover;
}());
export var NGB_POPOVER_DIRECTIVES = [NgbPopover, NgbPopoverWindow];
//# sourceMappingURL=popover.js.map