import { OnInit, OnDestroy, Injector, Renderer, ElementRef, TemplateRef, ViewContainerRef, ComponentFactoryResolver, NgZone } from '@angular/core';
import { NgbTooltipConfig } from './tooltip-config';
export declare class NgbTooltipWindow {
    placement: 'top' | 'bottom' | 'left' | 'right';
}
/**
 * A lightweight, extensible directive for fancy tooltip creation.
 */
export declare class NgbTooltip implements OnInit, OnDestroy {
    private _elementRef;
    private _renderer;
    /**
     * Content to be displayed as tooltip.
     */
    ngbTooltip: string | TemplateRef<any>;
    /**
     * Placement of a tooltip. Accepts: "top", "bottom", "left", "right"
     */
    placement: 'top' | 'bottom' | 'left' | 'right';
    /**
     * Specifies events that should trigger. Supports a space separated list of event names.
     */
    triggers: string;
    private _popupService;
    private _windowRef;
    private _unregisterListenersFn;
    private _zoneSubscription;
    constructor(_elementRef: ElementRef, _renderer: Renderer, injector: Injector, componentFactoryResolver: ComponentFactoryResolver, viewContainerRef: ViewContainerRef, config: NgbTooltipConfig, ngZone: NgZone);
    /**
     * Opens an element’s tooltip. This is considered a “manual” triggering of the tooltip.
     */
    open(): void;
    /**
     * Closes an element’s tooltip. This is considered a “manual” triggering of the tooltip.
     */
    close(): void;
    /**
     * Toggles an element’s tooltip. This is considered a “manual” triggering of the tooltip.
     */
    toggle(): void;
    ngOnInit(): void;
    ngOnDestroy(): void;
}
