import { reflow } from '../util/util';
/**
 * Defines the carousel slide transition direction.
 */
export var NgbSlideEventDirection;
(function (NgbSlideEventDirection) {
    NgbSlideEventDirection["START"] = "start";
    NgbSlideEventDirection["END"] = "end";
})(NgbSlideEventDirection || (NgbSlideEventDirection = {}));
const isBeingAnimated = ({ classList }) => {
    return classList.contains('carousel-item-start') || classList.contains('carousel-item-end');
};
const ɵ0 = isBeingAnimated;
const removeDirectionClasses = (classList) => {
    classList.remove('carousel-item-start');
    classList.remove('carousel-item-end');
};
const ɵ1 = removeDirectionClasses;
const removeClasses = (classList) => {
    removeDirectionClasses(classList);
    classList.remove('carousel-item-prev');
    classList.remove('carousel-item-next');
};
const ɵ2 = removeClasses;
export const ngbCarouselTransitionIn = (element, animation, { direction }) => {
    const { classList } = element;
    if (!animation) {
        removeDirectionClasses(classList);
        removeClasses(classList);
        classList.add('active');
        return;
    }
    if (isBeingAnimated(element)) {
        // Revert the transition
        removeDirectionClasses(classList);
    }
    else {
        // For the 'in' transition, a 'pre-class' is applied to the element to ensure its visibility
        classList.add('carousel-item-' + (direction === NgbSlideEventDirection.START ? 'next' : 'prev'));
        reflow(element);
        classList.add('carousel-item-' + direction);
    }
    return () => {
        removeClasses(classList);
        classList.add('active');
    };
};
export const ngbCarouselTransitionOut = (element, animation, { direction }) => {
    const { classList } = element;
    if (!animation) {
        removeDirectionClasses(classList);
        removeClasses(classList);
        classList.remove('active');
        return;
    }
    //  direction is left or right, depending on the way the slide goes out.
    if (isBeingAnimated(element)) {
        // Revert the transition
        removeDirectionClasses(classList);
    }
    else {
        classList.add('carousel-item-' + direction);
    }
    return () => {
        removeClasses(classList);
        classList.remove('active');
    };
};
export { ɵ0, ɵ1, ɵ2 };
//# sourceMappingURL=data:application/json;base64,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