import { AfterContentChecked, AfterContentInit, ChangeDetectorRef, ElementRef, EventEmitter, OnInit, QueryList, TemplateRef } from '@angular/core';
import { NgbNavConfig } from './nav-config';
/**
 * Context passed to the nav content template.
 *
 * See [this demo](#/components/nav/examples#keep-content) as the example.
 *
 * @since 5.2.0
 */
export interface NgbNavContentContext {
    /**
     * If `true`, current nav content is visible and active
     */
    $implicit: boolean;
}
/**
 * This directive must be used to wrap content to be displayed in the nav.
 *
 * @since 5.2.0
 */
export declare class NgbNavContent {
    templateRef: TemplateRef<any>;
    constructor(templateRef: TemplateRef<any>);
}
/**
 * The directive used to group nav link and related nav content. As well as set nav identifier and some options.
 *
 * @since 5.2.0
 */
export declare class NgbNavItem implements AfterContentChecked, OnInit {
    elementRef: ElementRef<any>;
    private _nav;
    /**
     * If `true`, non-active current nav item content will be removed from DOM
     * Otherwise it will just be hidden
     */
    destroyOnHide: any;
    /**
     * If `true`, the current nav item is disabled and can't be toggled by user.
     *
     * Nevertheless disabled nav can be selected programmatically via the `.select()` method and the `[activeId]` binding.
     */
    disabled: boolean;
    /**
     * The id used for the DOM elements.
     * Must be unique inside the document in case you have multiple `ngbNav`s on the page.
     *
     * Autogenerated as `ngb-nav-XXX` if not provided.
     */
    domId: string;
    /**
     * The id used as a model for active nav.
     * It can be anything, but must be unique inside one `ngbNav`.
     */
    _id: any;
    contentTpl: NgbNavContent | null;
    contentTpls: QueryList<NgbNavContent>;
    constructor(nav: any, elementRef: ElementRef<any>);
    ngAfterContentChecked(): void;
    ngOnInit(): void;
    readonly active: boolean;
    readonly id: any;
    readonly panelDomId: string;
    isPanelInDom(): boolean;
}
/**
 * A nav directive that helps with implementing tabbed navigation components.
 *
 * @since 5.2.0
 */
export declare class NgbNav implements AfterContentInit {
    role: string;
    private _cd;
    /**
     * The id of the nav that should be active
     *
     * You could also use the `.select()` method and the `(navChange)` event
     */
    activeId: any;
    /**
     * The event emitted after the active nav changes
     * The payload of the event is the newly active nav id
     *
     * If you want to prevent nav change, you should use `(navChange)` event
     */
    activeIdChange: EventEmitter<any>;
    /**
     * If `true`, non-active nav content will be removed from DOM
     * Otherwise it will just be hidden
     */
    destroyOnHide: any;
    /**
     * The orientation of navs.
     *
     * Using `vertical` will also add the `aria-orientation` attribute
     */
    orientation: 'horizontal' | 'vertical';
    /**
     * Role attribute generating strategy:
     * - `false` - no role attributes will be generated
     * - `'tablist'` - 'tablist', 'tab' and 'tabpanel' will be generated (default)
     */
    roles: 'tablist' | false;
    items: QueryList<NgbNavItem>;
    constructor(role: string, config: NgbNavConfig, _cd: ChangeDetectorRef);
    /**
     * The nav change event emitted right before the nav change happens on user click.
     *
     * This event won't be emitted if nav is changed programmatically via `[activeId]` or `.select()`.
     *
     * See [`NgbNavChangeEvent`](#/components/nav/api#NgbNavChangeEvent) for payload details.
     */
    navChange: EventEmitter<NgbNavChangeEvent>;
    click(item: NgbNavItem): void;
    /**
     * Selects the nav with the given id and shows its associated pane.
     * Any other nav that was previously selected becomes unselected and its associated pane is hidden.
     */
    select(id: any): void;
    ngAfterContentInit(): void;
    private _updateActiveId;
}
/**
 * A directive to put on the nav link.
 *
 * @since 5.2.0
 */
export declare class NgbNavLink {
    role: string;
    navItem: NgbNavItem;
    nav: NgbNav;
    constructor(role: string, navItem: NgbNavItem, nav: NgbNav);
    hasNavItemClass(): boolean;
}
/**
 * The payload of the change event emitted right before the nav change happens on user click.
 *
 * This event won't be emitted if nav is changed programmatically via `[activeId]` or `.select()`.
 *
 * @since 5.2.0
 */
export interface NgbNavChangeEvent {
    /**
     * Id of the currently active nav.
     */
    activeId: any;
    /**
     * Id of the newly selected nav.
     */
    nextId: any;
    /**
     * Function that will prevent nav change if called.
     */
    preventDefault: () => void;
}
