(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('flexmonster'), require('@angular/common')) :
    typeof define === 'function' && define.amd ? define('ng-flexmonster', ['exports', '@angular/core', 'flexmonster', '@angular/common'], factory) :
    (factory((global['ng-flexmonster'] = {}),global.ng.core,null,global.ng.common));
}(this, (function (exports,core,Flexmonster,common) { 'use strict';

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingReturn,uselessCode} checked by tsc
     */
    var FlexmonsterPivot = /** @class */ (function () {
        function FlexmonsterPivot(el) {
            // events
            this.cellclick = new core.EventEmitter();
            this.celldoubleclick = new core.EventEmitter();
            this.chartclick = new core.EventEmitter();
            this.dataerror = new core.EventEmitter();
            this.datafilecancelled = new core.EventEmitter();
            this.dataloaded = new core.EventEmitter();
            this.datachanged = new core.EventEmitter();
            this.fieldslistclose = new core.EventEmitter();
            this.fieldslistopen = new core.EventEmitter();
            this.filterclose = new core.EventEmitter();
            this.filteropen = new core.EventEmitter();
            this.drillthroughopen = new core.EventEmitter();
            this.exportcomplete = new core.EventEmitter();
            this.exportstart = new core.EventEmitter();
            this.drillthroughclose = new core.EventEmitter();
            this.fullscreen = new core.EventEmitter();
            this.loadingdata = new core.EventEmitter();
            this.loadinglocalization = new core.EventEmitter();
            this.loadingolapstructure = new core.EventEmitter();
            this.loadingreportfile = new core.EventEmitter();
            this.localizationerror = new core.EventEmitter();
            this.localizationloaded = new core.EventEmitter();
            this.olapstructureerror = new core.EventEmitter();
            this.olapstructureloaded = new core.EventEmitter();
            this.openingreportfile = new core.EventEmitter();
            this.printcomplete = new core.EventEmitter();
            this.printstart = new core.EventEmitter();
            this.querycomplete = new core.EventEmitter();
            this.queryerror = new core.EventEmitter();
            this.ready = new core.EventEmitter();
            this.reportchange = new core.EventEmitter();
            this.reportcomplete = new core.EventEmitter();
            this.reportfilecancelled = new core.EventEmitter();
            this.reportfileerror = new core.EventEmitter();
            this.reportfileloaded = new core.EventEmitter();
            this.runningquery = new core.EventEmitter();
            this.unauthorizederror = new core.EventEmitter();
            this.update = new core.EventEmitter();
            this.beforetoolbarcreated = new core.EventEmitter();
            this.beforegriddraw = new core.EventEmitter();
            this.aftergriddraw = new core.EventEmitter();
            this.afterchartdraw = new core.EventEmitter();
            this.root = ( /** @type {?} */(el.nativeElement));
        }
        /**
         * @return {?}
         */
        FlexmonsterPivot.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.flexmonster = new Flexmonster({
                    container: this.root.getElementsByClassName('fm-ng-wrapper')[0],
                    componentFolder: this.componentFolder,
                    width: this.width,
                    height: this.height,
                    toolbar: this.toolbar,
                    licenseKey: this.licenseKey,
                    licenseFilePath: this.licenseFilePath,
                    report: this.report,
                    global: this.global,
                    customizeAPIRequest: this.customizeAPIRequest,
                    customizeCell: this.customizeCell,
                    customizeChartElement: this.customizeChartElement,
                    customizeContextMenu: this.customizeContextMenu,
                    cellclick: function (cell) { return _this.cellclick.next(cell); },
                    celldoubleclick: function (cell) { return _this.celldoubleclick.next(cell); },
                    chartclick: function (event) { return _this.chartclick.next(event); },
                    datachanged: function (event) { return _this.datachanged.next(event); },
                    dataerror: function (event) { return _this.dataerror.next(event); },
                    datafilecancelled: function () { return _this.datafilecancelled.next(); },
                    dataloaded: function () { return _this.dataloaded.next(); },
                    fieldslistclose: function () { return _this.fieldslistclose.next(); },
                    fieldslistopen: function () { return _this.fieldslistopen.next(); },
                    filterclose: function () { return _this.filterclose.next(); },
                    filteropen: function (event) { return _this.filteropen.next(event); },
                    drillthroughopen: function (cell) { return _this.drillthroughopen.next(cell); },
                    exportcomplete: function () { return _this.exportcomplete.next(); },
                    exportstart: function () { return _this.exportstart.next(); },
                    drillthroughclose: function () { return _this.drillthroughclose.next(); },
                    loadingdata: function () { return _this.loadingdata.next(); },
                    loadinglocalization: function () { return _this.loadinglocalization.next(); },
                    loadingolapstructure: function () { return _this.loadingolapstructure.next(); },
                    loadingreportfile: function () { return _this.loadingreportfile.next(); },
                    localizationerror: function () { return _this.localizationerror.next(); },
                    localizationloaded: function () { return _this.localizationloaded.next(); },
                    olapstructureerror: function () { return _this.olapstructureerror.next(); },
                    olapstructureloaded: function () { return _this.olapstructureloaded.next(); },
                    openingreportfile: function () { return _this.openingreportfile.next(); },
                    printcomplete: function () { return _this.printcomplete.next(); },
                    printstart: function () { return _this.printstart.next(); },
                    querycomplete: function () { return _this.querycomplete.next(); },
                    queryerror: function () { return _this.queryerror.next(); },
                    ready: function () { return _this.ready.next(_this.flexmonster); },
                    reportchange: function () { return _this.reportchange.next(); },
                    reportcomplete: function () { return _this.reportcomplete.next(); },
                    reportfileloaded: function () { return _this.reportfileloaded.next(); },
                    reportfilecancelled: function () { return _this.reportfilecancelled.next(); },
                    reportfileerror: function () { return _this.reportfileerror.next(); },
                    runningquery: function () { return _this.runningquery.next(); },
                    unauthorizederror: function (done) { return _this.unauthorizederror.next(done); },
                    update: function () { return _this.update.next(); },
                    beforetoolbarcreated: function (toolbar) { return _this.beforetoolbarcreated.next(toolbar); },
                    beforegriddraw: function (event) { return _this.beforegriddraw.next(event); },
                    aftergriddraw: function (event) { return _this.aftergriddraw.next(event); },
                    afterchartdraw: function () { return _this.afterchartdraw.next(); }
                });
            };
        FlexmonsterPivot.decorators = [
            { type: core.Component, args: [{
                        selector: 'fm-pivot',
                        template: '<div style="width:100%;height:100%;"><div class="fm-ng-wrapper"></div></div>'
                    },] },
        ];
        FlexmonsterPivot.ctorParameters = function () {
            return [
                { type: core.ElementRef }
            ];
        };
        FlexmonsterPivot.propDecorators = {
            toolbar: [{ type: core.Input }],
            licenseKey: [{ type: core.Input }],
            licenseFilePath: [{ type: core.Input }],
            width: [{ type: core.Input }],
            height: [{ type: core.Input }],
            componentFolder: [{ type: core.Input }],
            report: [{ type: core.Input }],
            global: [{ type: core.Input }],
            customizeAPIRequest: [{ type: core.Input }],
            customizeCell: [{ type: core.Input }],
            customizeChartElement: [{ type: core.Input }],
            customizeContextMenu: [{ type: core.Input }],
            cellclick: [{ type: core.Output }],
            celldoubleclick: [{ type: core.Output }],
            chartclick: [{ type: core.Output }],
            dataerror: [{ type: core.Output }],
            datafilecancelled: [{ type: core.Output }],
            dataloaded: [{ type: core.Output }],
            datachanged: [{ type: core.Output }],
            fieldslistclose: [{ type: core.Output }],
            fieldslistopen: [{ type: core.Output }],
            filterclose: [{ type: core.Output }],
            filteropen: [{ type: core.Output }],
            drillthroughopen: [{ type: core.Output }],
            exportcomplete: [{ type: core.Output }],
            exportstart: [{ type: core.Output }],
            drillthroughclose: [{ type: core.Output }],
            fullscreen: [{ type: core.Output }],
            loadingdata: [{ type: core.Output }],
            loadinglocalization: [{ type: core.Output }],
            loadingolapstructure: [{ type: core.Output }],
            loadingreportfile: [{ type: core.Output }],
            localizationerror: [{ type: core.Output }],
            localizationloaded: [{ type: core.Output }],
            olapstructureerror: [{ type: core.Output }],
            olapstructureloaded: [{ type: core.Output }],
            openingreportfile: [{ type: core.Output }],
            printcomplete: [{ type: core.Output }],
            printstart: [{ type: core.Output }],
            querycomplete: [{ type: core.Output }],
            queryerror: [{ type: core.Output }],
            ready: [{ type: core.Output }],
            reportchange: [{ type: core.Output }],
            reportcomplete: [{ type: core.Output }],
            reportfilecancelled: [{ type: core.Output }],
            reportfileerror: [{ type: core.Output }],
            reportfileloaded: [{ type: core.Output }],
            runningquery: [{ type: core.Output }],
            unauthorizederror: [{ type: core.Output }],
            update: [{ type: core.Output }],
            beforetoolbarcreated: [{ type: core.Output }],
            beforegriddraw: [{ type: core.Output }],
            aftergriddraw: [{ type: core.Output }],
            afterchartdraw: [{ type: core.Output }]
        };
        return FlexmonsterPivot;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingReturn,uselessCode} checked by tsc
     */
    var FlexmonsterPivotModule = /** @class */ (function () {
        function FlexmonsterPivotModule() {
        }
        FlexmonsterPivotModule.decorators = [
            { type: core.NgModule, args: [{
                        imports: [
                            common.CommonModule
                        ],
                        declarations: [FlexmonsterPivot],
                        exports: [FlexmonsterPivot]
                    },] },
        ];
        return FlexmonsterPivotModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingReturn,uselessCode} checked by tsc
     */

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes,extraRequire,missingReturn,uselessCode} checked by tsc
     */

    exports.FlexmonsterPivotModule = FlexmonsterPivotModule;
    exports.FlexmonsterPivot = FlexmonsterPivot;

    Object.defineProperty(exports, '__esModule', { value: true });

})));

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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