/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingReturn,uselessCode} checked by tsc
 */
import { Component, ElementRef, Input, Output, EventEmitter } from '@angular/core';
import * as Flexmonster from 'flexmonster';
export class FlexmonsterPivot {
    /**
     * @param {?} el
     */
    constructor(el) {
        // events
        this.cellclick = new EventEmitter();
        this.celldoubleclick = new EventEmitter();
        this.chartclick = new EventEmitter();
        this.dataerror = new EventEmitter();
        this.datafilecancelled = new EventEmitter();
        this.dataloaded = new EventEmitter();
        this.datachanged = new EventEmitter();
        this.fieldslistclose = new EventEmitter();
        this.fieldslistopen = new EventEmitter();
        this.filterclose = new EventEmitter();
        this.filteropen = new EventEmitter();
        this.drillthroughopen = new EventEmitter();
        this.exportcomplete = new EventEmitter();
        this.exportstart = new EventEmitter();
        this.drillthroughclose = new EventEmitter();
        this.fullscreen = new EventEmitter();
        this.loadingdata = new EventEmitter();
        this.loadinglocalization = new EventEmitter();
        this.loadingolapstructure = new EventEmitter();
        this.loadingreportfile = new EventEmitter();
        this.localizationerror = new EventEmitter();
        this.localizationloaded = new EventEmitter();
        this.olapstructureerror = new EventEmitter();
        this.olapstructureloaded = new EventEmitter();
        this.openingreportfile = new EventEmitter();
        this.printcomplete = new EventEmitter();
        this.printstart = new EventEmitter();
        this.querycomplete = new EventEmitter();
        this.queryerror = new EventEmitter();
        this.ready = new EventEmitter();
        this.reportchange = new EventEmitter();
        this.reportcomplete = new EventEmitter();
        this.reportfilecancelled = new EventEmitter();
        this.reportfileerror = new EventEmitter();
        this.reportfileloaded = new EventEmitter();
        this.runningquery = new EventEmitter();
        this.unauthorizederror = new EventEmitter();
        this.update = new EventEmitter();
        this.beforetoolbarcreated = new EventEmitter();
        this.beforegriddraw = new EventEmitter();
        this.aftergriddraw = new EventEmitter();
        this.afterchartdraw = new EventEmitter();
        this.root = (/** @type {?} */ (el.nativeElement));
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        this.flexmonster = new Flexmonster({
            container: this.root.getElementsByClassName('fm-ng-wrapper')[0],
            componentFolder: this.componentFolder,
            width: this.width,
            height: this.height,
            toolbar: this.toolbar,
            licenseKey: this.licenseKey,
            licenseFilePath: this.licenseFilePath,
            report: this.report,
            global: this.global,
            customizeAPIRequest: this.customizeAPIRequest,
            customizeCell: this.customizeCell,
            customizeChartElement: this.customizeChartElement,
            customizeContextMenu: this.customizeContextMenu,
            cellclick: (cell) => this.cellclick.next(cell),
            celldoubleclick: (cell) => this.celldoubleclick.next(cell),
            chartclick: (event) => this.chartclick.next(event),
            datachanged: (event) => this.datachanged.next(event),
            dataerror: (event) => this.dataerror.next(event),
            datafilecancelled: () => this.datafilecancelled.next(),
            dataloaded: () => this.dataloaded.next(),
            fieldslistclose: () => this.fieldslistclose.next(),
            fieldslistopen: () => this.fieldslistopen.next(),
            filterclose: () => this.filterclose.next(),
            filteropen: (event) => this.filteropen.next(event),
            drillthroughopen: (cell) => this.drillthroughopen.next(cell),
            exportcomplete: () => this.exportcomplete.next(),
            exportstart: () => this.exportstart.next(),
            drillthroughclose: () => this.drillthroughclose.next(),
            loadingdata: () => this.loadingdata.next(),
            loadinglocalization: () => this.loadinglocalization.next(),
            loadingolapstructure: () => this.loadingolapstructure.next(),
            loadingreportfile: () => this.loadingreportfile.next(),
            localizationerror: () => this.localizationerror.next(),
            localizationloaded: () => this.localizationloaded.next(),
            olapstructureerror: () => this.olapstructureerror.next(),
            olapstructureloaded: () => this.olapstructureloaded.next(),
            openingreportfile: () => this.openingreportfile.next(),
            printcomplete: () => this.printcomplete.next(),
            printstart: () => this.printstart.next(),
            querycomplete: () => this.querycomplete.next(),
            queryerror: () => this.queryerror.next(),
            ready: () => this.ready.next(this.flexmonster),
            reportchange: () => this.reportchange.next(),
            reportcomplete: () => this.reportcomplete.next(),
            reportfileloaded: () => this.reportfileloaded.next(),
            reportfilecancelled: () => this.reportfilecancelled.next(),
            reportfileerror: () => this.reportfileerror.next(),
            runningquery: () => this.runningquery.next(),
            unauthorizederror: (done) => this.unauthorizederror.next(done),
            update: () => this.update.next(),
            beforetoolbarcreated: (toolbar) => this.beforetoolbarcreated.next(toolbar),
            beforegriddraw: (event) => this.beforegriddraw.next(event),
            aftergriddraw: (event) => this.aftergriddraw.next(event),
            afterchartdraw: () => this.afterchartdraw.next()
        });
    }
}
FlexmonsterPivot.decorators = [
    { type: Component, args: [{
                selector: 'fm-pivot',
                template: '<div style="width:100%;height:100%;"><div class="fm-ng-wrapper"></div></div>'
            },] },
];
FlexmonsterPivot.ctorParameters = () => [
    { type: ElementRef }
];
FlexmonsterPivot.propDecorators = {
    toolbar: [{ type: Input }],
    licenseKey: [{ type: Input }],
    licenseFilePath: [{ type: Input }],
    width: [{ type: Input }],
    height: [{ type: Input }],
    componentFolder: [{ type: Input }],
    report: [{ type: Input }],
    global: [{ type: Input }],
    customizeAPIRequest: [{ type: Input }],
    customizeCell: [{ type: Input }],
    customizeChartElement: [{ type: Input }],
    customizeContextMenu: [{ type: Input }],
    cellclick: [{ type: Output }],
    celldoubleclick: [{ type: Output }],
    chartclick: [{ type: Output }],
    dataerror: [{ type: Output }],
    datafilecancelled: [{ type: Output }],
    dataloaded: [{ type: Output }],
    datachanged: [{ type: Output }],
    fieldslistclose: [{ type: Output }],
    fieldslistopen: [{ type: Output }],
    filterclose: [{ type: Output }],
    filteropen: [{ type: Output }],
    drillthroughopen: [{ type: Output }],
    exportcomplete: [{ type: Output }],
    exportstart: [{ type: Output }],
    drillthroughclose: [{ type: Output }],
    fullscreen: [{ type: Output }],
    loadingdata: [{ type: Output }],
    loadinglocalization: [{ type: Output }],
    loadingolapstructure: [{ type: Output }],
    loadingreportfile: [{ type: Output }],
    localizationerror: [{ type: Output }],
    localizationloaded: [{ type: Output }],
    olapstructureerror: [{ type: Output }],
    olapstructureloaded: [{ type: Output }],
    openingreportfile: [{ type: Output }],
    printcomplete: [{ type: Output }],
    printstart: [{ type: Output }],
    querycomplete: [{ type: Output }],
    queryerror: [{ type: Output }],
    ready: [{ type: Output }],
    reportchange: [{ type: Output }],
    reportcomplete: [{ type: Output }],
    reportfilecancelled: [{ type: Output }],
    reportfileerror: [{ type: Output }],
    reportfileloaded: [{ type: Output }],
    runningquery: [{ type: Output }],
    unauthorizederror: [{ type: Output }],
    update: [{ type: Output }],
    beforetoolbarcreated: [{ type: Output }],
    beforegriddraw: [{ type: Output }],
    aftergriddraw: [{ type: Output }],
    afterchartdraw: [{ type: Output }]
};
if (false) {
    /** @type {?} */
    FlexmonsterPivot.prototype.toolbar;
    /** @type {?} */
    FlexmonsterPivot.prototype.licenseKey;
    /** @type {?} */
    FlexmonsterPivot.prototype.licenseFilePath;
    /** @type {?} */
    FlexmonsterPivot.prototype.width;
    /** @type {?} */
    FlexmonsterPivot.prototype.height;
    /** @type {?} */
    FlexmonsterPivot.prototype.componentFolder;
    /** @type {?} */
    FlexmonsterPivot.prototype.report;
    /** @type {?} */
    FlexmonsterPivot.prototype.global;
    /** @type {?} */
    FlexmonsterPivot.prototype.customizeAPIRequest;
    /** @type {?} */
    FlexmonsterPivot.prototype.customizeCell;
    /** @type {?} */
    FlexmonsterPivot.prototype.customizeChartElement;
    /** @type {?} */
    FlexmonsterPivot.prototype.customizeContextMenu;
    /** @type {?} */
    FlexmonsterPivot.prototype.cellclick;
    /** @type {?} */
    FlexmonsterPivot.prototype.celldoubleclick;
    /** @type {?} */
    FlexmonsterPivot.prototype.chartclick;
    /** @type {?} */
    FlexmonsterPivot.prototype.dataerror;
    /** @type {?} */
    FlexmonsterPivot.prototype.datafilecancelled;
    /** @type {?} */
    FlexmonsterPivot.prototype.dataloaded;
    /** @type {?} */
    FlexmonsterPivot.prototype.datachanged;
    /** @type {?} */
    FlexmonsterPivot.prototype.fieldslistclose;
    /** @type {?} */
    FlexmonsterPivot.prototype.fieldslistopen;
    /** @type {?} */
    FlexmonsterPivot.prototype.filterclose;
    /** @type {?} */
    FlexmonsterPivot.prototype.filteropen;
    /** @type {?} */
    FlexmonsterPivot.prototype.drillthroughopen;
    /** @type {?} */
    FlexmonsterPivot.prototype.exportcomplete;
    /** @type {?} */
    FlexmonsterPivot.prototype.exportstart;
    /** @type {?} */
    FlexmonsterPivot.prototype.drillthroughclose;
    /** @type {?} */
    FlexmonsterPivot.prototype.fullscreen;
    /** @type {?} */
    FlexmonsterPivot.prototype.loadingdata;
    /** @type {?} */
    FlexmonsterPivot.prototype.loadinglocalization;
    /** @type {?} */
    FlexmonsterPivot.prototype.loadingolapstructure;
    /** @type {?} */
    FlexmonsterPivot.prototype.loadingreportfile;
    /** @type {?} */
    FlexmonsterPivot.prototype.localizationerror;
    /** @type {?} */
    FlexmonsterPivot.prototype.localizationloaded;
    /** @type {?} */
    FlexmonsterPivot.prototype.olapstructureerror;
    /** @type {?} */
    FlexmonsterPivot.prototype.olapstructureloaded;
    /** @type {?} */
    FlexmonsterPivot.prototype.openingreportfile;
    /** @type {?} */
    FlexmonsterPivot.prototype.printcomplete;
    /** @type {?} */
    FlexmonsterPivot.prototype.printstart;
    /** @type {?} */
    FlexmonsterPivot.prototype.querycomplete;
    /** @type {?} */
    FlexmonsterPivot.prototype.queryerror;
    /** @type {?} */
    FlexmonsterPivot.prototype.ready;
    /** @type {?} */
    FlexmonsterPivot.prototype.reportchange;
    /** @type {?} */
    FlexmonsterPivot.prototype.reportcomplete;
    /** @type {?} */
    FlexmonsterPivot.prototype.reportfilecancelled;
    /** @type {?} */
    FlexmonsterPivot.prototype.reportfileerror;
    /** @type {?} */
    FlexmonsterPivot.prototype.reportfileloaded;
    /** @type {?} */
    FlexmonsterPivot.prototype.runningquery;
    /** @type {?} */
    FlexmonsterPivot.prototype.unauthorizederror;
    /** @type {?} */
    FlexmonsterPivot.prototype.update;
    /** @type {?} */
    FlexmonsterPivot.prototype.beforetoolbarcreated;
    /** @type {?} */
    FlexmonsterPivot.prototype.beforegriddraw;
    /** @type {?} */
    FlexmonsterPivot.prototype.aftergriddraw;
    /** @type {?} */
    FlexmonsterPivot.prototype.afterchartdraw;
    /** @type {?} */
    FlexmonsterPivot.prototype.flexmonster;
    /** @type {?} */
    FlexmonsterPivot.prototype.root;
}
//# sourceMappingURL=data:application/json;base64,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