import { Component, ElementRef, Input, Output, EventEmitter, NgModule } from '@angular/core';
import * as Flexmonster from 'flexmonster';
import { CommonModule } from '@angular/common';

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingReturn,uselessCode} checked by tsc
 */
class FlexmonsterPivot {
    /**
     * @param {?} el
     */
    constructor(el) {
        // events
        this.cellclick = new EventEmitter();
        this.celldoubleclick = new EventEmitter();
        this.chartclick = new EventEmitter();
        this.dataerror = new EventEmitter();
        this.datafilecancelled = new EventEmitter();
        this.dataloaded = new EventEmitter();
        this.datachanged = new EventEmitter();
        this.fieldslistclose = new EventEmitter();
        this.fieldslistopen = new EventEmitter();
        this.filterclose = new EventEmitter();
        this.filteropen = new EventEmitter();
        this.drillthroughopen = new EventEmitter();
        this.exportcomplete = new EventEmitter();
        this.exportstart = new EventEmitter();
        this.drillthroughclose = new EventEmitter();
        this.fullscreen = new EventEmitter();
        this.loadingdata = new EventEmitter();
        this.loadinglocalization = new EventEmitter();
        this.loadingolapstructure = new EventEmitter();
        this.loadingreportfile = new EventEmitter();
        this.localizationerror = new EventEmitter();
        this.localizationloaded = new EventEmitter();
        this.olapstructureerror = new EventEmitter();
        this.olapstructureloaded = new EventEmitter();
        this.openingreportfile = new EventEmitter();
        this.printcomplete = new EventEmitter();
        this.printstart = new EventEmitter();
        this.querycomplete = new EventEmitter();
        this.queryerror = new EventEmitter();
        this.ready = new EventEmitter();
        this.reportchange = new EventEmitter();
        this.reportcomplete = new EventEmitter();
        this.reportfilecancelled = new EventEmitter();
        this.reportfileerror = new EventEmitter();
        this.reportfileloaded = new EventEmitter();
        this.runningquery = new EventEmitter();
        this.unauthorizederror = new EventEmitter();
        this.update = new EventEmitter();
        this.beforetoolbarcreated = new EventEmitter();
        this.beforegriddraw = new EventEmitter();
        this.aftergriddraw = new EventEmitter();
        this.afterchartdraw = new EventEmitter();
        this.root = (/** @type {?} */ (el.nativeElement));
    }
    /**
     * @return {?}
     */
    ngOnInit() {
        this.flexmonster = new Flexmonster({
            container: this.root.getElementsByClassName('fm-ng-wrapper')[0],
            componentFolder: this.componentFolder,
            width: this.width,
            height: this.height,
            toolbar: this.toolbar,
            licenseKey: this.licenseKey,
            licenseFilePath: this.licenseFilePath,
            report: this.report,
            global: this.global,
            customizeAPIRequest: this.customizeAPIRequest,
            customizeCell: this.customizeCell,
            customizeChartElement: this.customizeChartElement,
            customizeContextMenu: this.customizeContextMenu,
            cellclick: (cell) => this.cellclick.next(cell),
            celldoubleclick: (cell) => this.celldoubleclick.next(cell),
            chartclick: (event) => this.chartclick.next(event),
            datachanged: (event) => this.datachanged.next(event),
            dataerror: (event) => this.dataerror.next(event),
            datafilecancelled: () => this.datafilecancelled.next(),
            dataloaded: () => this.dataloaded.next(),
            fieldslistclose: () => this.fieldslistclose.next(),
            fieldslistopen: () => this.fieldslistopen.next(),
            filterclose: () => this.filterclose.next(),
            filteropen: (event) => this.filteropen.next(event),
            drillthroughopen: (cell) => this.drillthroughopen.next(cell),
            exportcomplete: () => this.exportcomplete.next(),
            exportstart: () => this.exportstart.next(),
            drillthroughclose: () => this.drillthroughclose.next(),
            loadingdata: () => this.loadingdata.next(),
            loadinglocalization: () => this.loadinglocalization.next(),
            loadingolapstructure: () => this.loadingolapstructure.next(),
            loadingreportfile: () => this.loadingreportfile.next(),
            localizationerror: () => this.localizationerror.next(),
            localizationloaded: () => this.localizationloaded.next(),
            olapstructureerror: () => this.olapstructureerror.next(),
            olapstructureloaded: () => this.olapstructureloaded.next(),
            openingreportfile: () => this.openingreportfile.next(),
            printcomplete: () => this.printcomplete.next(),
            printstart: () => this.printstart.next(),
            querycomplete: () => this.querycomplete.next(),
            queryerror: () => this.queryerror.next(),
            ready: () => this.ready.next(this.flexmonster),
            reportchange: () => this.reportchange.next(),
            reportcomplete: () => this.reportcomplete.next(),
            reportfileloaded: () => this.reportfileloaded.next(),
            reportfilecancelled: () => this.reportfilecancelled.next(),
            reportfileerror: () => this.reportfileerror.next(),
            runningquery: () => this.runningquery.next(),
            unauthorizederror: (done) => this.unauthorizederror.next(done),
            update: () => this.update.next(),
            beforetoolbarcreated: (toolbar) => this.beforetoolbarcreated.next(toolbar),
            beforegriddraw: (event) => this.beforegriddraw.next(event),
            aftergriddraw: (event) => this.aftergriddraw.next(event),
            afterchartdraw: () => this.afterchartdraw.next()
        });
    }
}
FlexmonsterPivot.decorators = [
    { type: Component, args: [{
                selector: 'fm-pivot',
                template: '<div style="width:100%;height:100%;"><div class="fm-ng-wrapper"></div></div>'
            },] },
];
FlexmonsterPivot.ctorParameters = () => [
    { type: ElementRef }
];
FlexmonsterPivot.propDecorators = {
    toolbar: [{ type: Input }],
    licenseKey: [{ type: Input }],
    licenseFilePath: [{ type: Input }],
    width: [{ type: Input }],
    height: [{ type: Input }],
    componentFolder: [{ type: Input }],
    report: [{ type: Input }],
    global: [{ type: Input }],
    customizeAPIRequest: [{ type: Input }],
    customizeCell: [{ type: Input }],
    customizeChartElement: [{ type: Input }],
    customizeContextMenu: [{ type: Input }],
    cellclick: [{ type: Output }],
    celldoubleclick: [{ type: Output }],
    chartclick: [{ type: Output }],
    dataerror: [{ type: Output }],
    datafilecancelled: [{ type: Output }],
    dataloaded: [{ type: Output }],
    datachanged: [{ type: Output }],
    fieldslistclose: [{ type: Output }],
    fieldslistopen: [{ type: Output }],
    filterclose: [{ type: Output }],
    filteropen: [{ type: Output }],
    drillthroughopen: [{ type: Output }],
    exportcomplete: [{ type: Output }],
    exportstart: [{ type: Output }],
    drillthroughclose: [{ type: Output }],
    fullscreen: [{ type: Output }],
    loadingdata: [{ type: Output }],
    loadinglocalization: [{ type: Output }],
    loadingolapstructure: [{ type: Output }],
    loadingreportfile: [{ type: Output }],
    localizationerror: [{ type: Output }],
    localizationloaded: [{ type: Output }],
    olapstructureerror: [{ type: Output }],
    olapstructureloaded: [{ type: Output }],
    openingreportfile: [{ type: Output }],
    printcomplete: [{ type: Output }],
    printstart: [{ type: Output }],
    querycomplete: [{ type: Output }],
    queryerror: [{ type: Output }],
    ready: [{ type: Output }],
    reportchange: [{ type: Output }],
    reportcomplete: [{ type: Output }],
    reportfilecancelled: [{ type: Output }],
    reportfileerror: [{ type: Output }],
    reportfileloaded: [{ type: Output }],
    runningquery: [{ type: Output }],
    unauthorizederror: [{ type: Output }],
    update: [{ type: Output }],
    beforetoolbarcreated: [{ type: Output }],
    beforegriddraw: [{ type: Output }],
    aftergriddraw: [{ type: Output }],
    afterchartdraw: [{ type: Output }]
};

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingReturn,uselessCode} checked by tsc
 */
class FlexmonsterPivotModule {
}
FlexmonsterPivotModule.decorators = [
    { type: NgModule, args: [{
                imports: [
                    CommonModule
                ],
                declarations: [FlexmonsterPivot],
                exports: [FlexmonsterPivot]
            },] },
];

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingReturn,uselessCode} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,missingReturn,uselessCode} checked by tsc
 */

export { FlexmonsterPivotModule, FlexmonsterPivot };

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmctZmxleG1vbnN0ZXIuanMubWFwIiwic291cmNlcyI6WyJuZzovL25nLWZsZXhtb25zdGVyL2ZsZXhtb25zdGVyLmNvbXBvbmVudC50cyIsIm5nOi8vbmctZmxleG1vbnN0ZXIvZmxleG1vbnN0ZXIubW9kdWxlLnRzIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCwgRWxlbWVudFJlZiwgSW5wdXQsIE91dHB1dCwgRXZlbnRFbWl0dGVyIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XHJcbmltcG9ydCAqIGFzIEZsZXhtb25zdGVyIGZyb20gJ2ZsZXhtb25zdGVyJztcclxuXHJcbkBDb21wb25lbnQoe1xyXG4gIHNlbGVjdG9yOiAnZm0tcGl2b3QnLFxyXG4gIHRlbXBsYXRlOiAnPGRpdiBzdHlsZT1cIndpZHRoOjEwMCU7aGVpZ2h0OjEwMCU7XCI+PGRpdiBjbGFzcz1cImZtLW5nLXdyYXBwZXJcIj48L2Rpdj48L2Rpdj4nXHJcbn0pXHJcbmV4cG9ydCBjbGFzcyBGbGV4bW9uc3RlclBpdm90IHtcclxuICAvLyBwYXJhbXNcclxuICBASW5wdXQoKSB0b29sYmFyOiBib29sZWFuO1xyXG4gIEBJbnB1dCgpIGxpY2Vuc2VLZXk6IHN0cmluZztcclxuICBASW5wdXQoKSBsaWNlbnNlRmlsZVBhdGg6IHN0cmluZztcclxuICBASW5wdXQoKSB3aWR0aDogc3RyaW5nIHwgbnVtYmVyO1xyXG4gIEBJbnB1dCgpIGhlaWdodDogc3RyaW5nIHwgbnVtYmVyO1xyXG4gIEBJbnB1dCgpIGNvbXBvbmVudEZvbGRlcjogc3RyaW5nO1xyXG4gIEBJbnB1dCgpIHJlcG9ydDogRmxleG1vbnN0ZXIuUmVwb3J0IHwgc3RyaW5nO1xyXG4gIEBJbnB1dCgpIGdsb2JhbDogRmxleG1vbnN0ZXIuUmVwb3J0O1xyXG4gIEBJbnB1dCgpIGN1c3RvbWl6ZUFQSVJlcXVlc3Q6IChyZXF1ZXN0OiBPYmplY3QpID0+IE9iamVjdDtcclxuICBASW5wdXQoKSBjdXN0b21pemVDZWxsOiAoY2VsbDogRmxleG1vbnN0ZXIuQ2VsbEJ1aWxkZXIsIGRhdGE6IEZsZXhtb25zdGVyLkNlbGxEYXRhKSA9PiB2b2lkO1xyXG4gIEBJbnB1dCgpIGN1c3RvbWl6ZUNoYXJ0RWxlbWVudDogKGVsZW1lbnQ6IEVsZW1lbnQsIGRhdGE6IEZsZXhtb25zdGVyLkNoYXJ0RGF0YSB8IEZsZXhtb25zdGVyLkNoYXJ0TGVnZW5kSXRlbURhdGEpID0+IHZvaWQ7XHJcbiAgQElucHV0KCkgY3VzdG9taXplQ29udGV4dE1lbnU6IChjZWxsOiBGbGV4bW9uc3Rlci5Db250ZXh0TWVudUl0ZW1bXSwgZGF0YTogRmxleG1vbnN0ZXIuQ2VsbERhdGEgfCBGbGV4bW9uc3Rlci5DaGFydERhdGEsIHZpZXdUeXBlOiBzdHJpbmcpID0+IEZsZXhtb25zdGVyLkNvbnRleHRNZW51SXRlbVtdO1xyXG4gIC8vIGV2ZW50c1xyXG4gIEBPdXRwdXQoKSBjZWxsY2xpY2s6IEV2ZW50RW1pdHRlcjxGbGV4bW9uc3Rlci5DZWxsRGF0YT4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XHJcbiAgQE91dHB1dCgpIGNlbGxkb3VibGVjbGljazogRXZlbnRFbWl0dGVyPEZsZXhtb25zdGVyLkNlbGxEYXRhPiA9IG5ldyBFdmVudEVtaXR0ZXIoKTtcclxuICBAT3V0cHV0KCkgY2hhcnRjbGljazogRXZlbnRFbWl0dGVyPEZsZXhtb25zdGVyLkNoYXJ0RGF0YT4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XHJcbiAgQE91dHB1dCgpIGRhdGFlcnJvcjogRXZlbnRFbWl0dGVyPE9iamVjdD4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XHJcbiAgQE91dHB1dCgpIGRhdGFmaWxlY2FuY2VsbGVkOiBFdmVudEVtaXR0ZXI8T2JqZWN0PiA9IG5ldyBFdmVudEVtaXR0ZXIoKTtcclxuICBAT3V0cHV0KCkgZGF0YWxvYWRlZDogRXZlbnRFbWl0dGVyPE9iamVjdD4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XHJcbiAgQE91dHB1dCgpIGRhdGFjaGFuZ2VkOiBFdmVudEVtaXR0ZXI8T2JqZWN0PiA9IG5ldyBFdmVudEVtaXR0ZXIoKTtcclxuICBAT3V0cHV0KCkgZmllbGRzbGlzdGNsb3NlOiBFdmVudEVtaXR0ZXI8T2JqZWN0PiA9IG5ldyBFdmVudEVtaXR0ZXIoKTtcclxuICBAT3V0cHV0KCkgZmllbGRzbGlzdG9wZW46IEV2ZW50RW1pdHRlcjxPYmplY3Q+ID0gbmV3IEV2ZW50RW1pdHRlcigpO1xyXG4gIEBPdXRwdXQoKSBmaWx0ZXJjbG9zZTogRXZlbnRFbWl0dGVyPE9iamVjdD4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XHJcbiAgQE91dHB1dCgpIGZpbHRlcm9wZW46IEV2ZW50RW1pdHRlcjxPYmplY3Q+ID0gbmV3IEV2ZW50RW1pdHRlcigpO1xyXG4gIEBPdXRwdXQoKSBkcmlsbHRocm91Z2hvcGVuOiBFdmVudEVtaXR0ZXI8RmxleG1vbnN0ZXIuQ2VsbERhdGEgfCBGbGV4bW9uc3Rlci5DaGFydERhdGE+ID0gbmV3IEV2ZW50RW1pdHRlcigpO1xyXG4gIEBPdXRwdXQoKSBleHBvcnRjb21wbGV0ZTogRXZlbnRFbWl0dGVyPE9iamVjdD4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XHJcbiAgQE91dHB1dCgpIGV4cG9ydHN0YXJ0OiBFdmVudEVtaXR0ZXI8T2JqZWN0PiA9IG5ldyBFdmVudEVtaXR0ZXIoKTtcclxuICBAT3V0cHV0KCkgZHJpbGx0aHJvdWdoY2xvc2U6IEV2ZW50RW1pdHRlcjxPYmplY3Q+ID0gbmV3IEV2ZW50RW1pdHRlcigpO1xyXG4gIEBPdXRwdXQoKSBmdWxsc2NyZWVuOiBFdmVudEVtaXR0ZXI8T2JqZWN0PiA9IG5ldyBFdmVudEVtaXR0ZXIoKTtcclxuICBAT3V0cHV0KCkgbG9hZGluZ2RhdGE6IEV2ZW50RW1pdHRlcjxPYmplY3Q+ID0gbmV3IEV2ZW50RW1pdHRlcigpO1xyXG4gIEBPdXRwdXQoKSBsb2FkaW5nbG9jYWxpemF0aW9uOiBFdmVudEVtaXR0ZXI8T2JqZWN0PiA9IG5ldyBFdmVudEVtaXR0ZXIoKTtcclxuICBAT3V0cHV0KCkgbG9hZGluZ29sYXBzdHJ1Y3R1cmU6IEV2ZW50RW1pdHRlcjxPYmplY3Q+ID0gbmV3IEV2ZW50RW1pdHRlcigpO1xyXG4gIEBPdXRwdXQoKSBsb2FkaW5ncmVwb3J0ZmlsZTogRXZlbnRFbWl0dGVyPE9iamVjdD4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XHJcbiAgQE91dHB1dCgpIGxvY2FsaXphdGlvbmVycm9yOiBFdmVudEVtaXR0ZXI8T2JqZWN0PiA9IG5ldyBFdmVudEVtaXR0ZXIoKTtcclxuICBAT3V0cHV0KCkgbG9jYWxpemF0aW9ubG9hZGVkOiBFdmVudEVtaXR0ZXI8T2JqZWN0PiA9IG5ldyBFdmVudEVtaXR0ZXIoKTtcclxuICBAT3V0cHV0KCkgb2xhcHN0cnVjdHVyZWVycm9yOiBFdmVudEVtaXR0ZXI8T2JqZWN0PiA9IG5ldyBFdmVudEVtaXR0ZXIoKTtcclxuICBAT3V0cHV0KCkgb2xhcHN0cnVjdHVyZWxvYWRlZDogRXZlbnRFbWl0dGVyPE9iamVjdD4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XHJcbiAgQE91dHB1dCgpIG9wZW5pbmdyZXBvcnRmaWxlOiBFdmVudEVtaXR0ZXI8T2JqZWN0PiA9IG5ldyBFdmVudEVtaXR0ZXIoKTtcclxuICBAT3V0cHV0KCkgcHJpbnRjb21wbGV0ZTogRXZlbnRFbWl0dGVyPE9iamVjdD4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XHJcbiAgQE91dHB1dCgpIHByaW50c3RhcnQ6IEV2ZW50RW1pdHRlcjxPYmplY3Q+ID0gbmV3IEV2ZW50RW1pdHRlcigpO1xyXG4gIEBPdXRwdXQoKSBxdWVyeWNvbXBsZXRlOiBFdmVudEVtaXR0ZXI8T2JqZWN0PiA9IG5ldyBFdmVudEVtaXR0ZXIoKTtcclxuICBAT3V0cHV0KCkgcXVlcnllcnJvcjogRXZlbnRFbWl0dGVyPE9iamVjdD4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XHJcbiAgQE91dHB1dCgpIHJlYWR5OiBFdmVudEVtaXR0ZXI8RmxleG1vbnN0ZXIuUGl2b3Q+ID0gbmV3IEV2ZW50RW1pdHRlcigpO1xyXG4gIEBPdXRwdXQoKSByZXBvcnRjaGFuZ2U6IEV2ZW50RW1pdHRlcjxPYmplY3Q+ID0gbmV3IEV2ZW50RW1pdHRlcigpO1xyXG4gIEBPdXRwdXQoKSByZXBvcnRjb21wbGV0ZTogRXZlbnRFbWl0dGVyPE9iamVjdD4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XHJcbiAgQE91dHB1dCgpIHJlcG9ydGZpbGVjYW5jZWxsZWQ6IEV2ZW50RW1pdHRlcjxPYmplY3Q+ID0gbmV3IEV2ZW50RW1pdHRlcigpO1xyXG4gIEBPdXRwdXQoKSByZXBvcnRmaWxlZXJyb3I6IEV2ZW50RW1pdHRlcjxPYmplY3Q+ID0gbmV3IEV2ZW50RW1pdHRlcigpO1xyXG4gIEBPdXRwdXQoKSByZXBvcnRmaWxlbG9hZGVkOiBFdmVudEVtaXR0ZXI8T2JqZWN0PiA9IG5ldyBFdmVudEVtaXR0ZXIoKTtcclxuICBAT3V0cHV0KCkgcnVubmluZ3F1ZXJ5OiBFdmVudEVtaXR0ZXI8T2JqZWN0PiA9IG5ldyBFdmVudEVtaXR0ZXIoKTtcclxuICBAT3V0cHV0KCkgdW5hdXRob3JpemVkZXJyb3I6IEV2ZW50RW1pdHRlcjxGbGV4bW9uc3Rlci5VbmF1dGhvcml6ZWRFcnJvckhhbmRsZXI+ID0gbmV3IEV2ZW50RW1pdHRlcigpO1xyXG4gIEBPdXRwdXQoKSB1cGRhdGU6IEV2ZW50RW1pdHRlcjxPYmplY3Q+ID0gbmV3IEV2ZW50RW1pdHRlcigpO1xyXG4gIEBPdXRwdXQoKSBiZWZvcmV0b29sYmFyY3JlYXRlZDogRXZlbnRFbWl0dGVyPE9iamVjdD4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XHJcbiAgQE91dHB1dCgpIGJlZm9yZWdyaWRkcmF3OiBFdmVudEVtaXR0ZXI8T2JqZWN0PiA9IG5ldyBFdmVudEVtaXR0ZXIoKTtcclxuICBAT3V0cHV0KCkgYWZ0ZXJncmlkZHJhdzogRXZlbnRFbWl0dGVyPE9iamVjdD4gPSBuZXcgRXZlbnRFbWl0dGVyKCk7XHJcbiAgQE91dHB1dCgpIGFmdGVyY2hhcnRkcmF3OiBFdmVudEVtaXR0ZXI8T2JqZWN0PiA9IG5ldyBFdmVudEVtaXR0ZXIoKTtcclxuICAvLyBhcGlcclxuICBwdWJsaWMgZmxleG1vbnN0ZXI6IEZsZXhtb25zdGVyLlBpdm90O1xyXG4gIC8vIHByaXZhdGVcclxuICBwcml2YXRlIHJvb3Q6IEhUTUxFbGVtZW50O1xyXG5cclxuICBjb25zdHJ1Y3RvcihlbDogRWxlbWVudFJlZikge1xyXG4gICAgdGhpcy5yb290ID0gPEhUTUxFbGVtZW50PmVsLm5hdGl2ZUVsZW1lbnQ7XHJcbiAgfVxyXG5cclxuICBuZ09uSW5pdCgpIHtcclxuICAgIHRoaXMuZmxleG1vbnN0ZXIgPSBuZXcgRmxleG1vbnN0ZXIoe1xyXG4gICAgICBjb250YWluZXI6IHRoaXMucm9vdC5nZXRFbGVtZW50c0J5Q2xhc3NOYW1lKCdmbS1uZy13cmFwcGVyJylbMF0sXHJcbiAgICAgIGNvbXBvbmVudEZvbGRlcjogdGhpcy5jb21wb25lbnRGb2xkZXIsXHJcbiAgICAgIHdpZHRoOiB0aGlzLndpZHRoLFxyXG4gICAgICBoZWlnaHQ6IHRoaXMuaGVpZ2h0LFxyXG4gICAgICB0b29sYmFyOiB0aGlzLnRvb2xiYXIsXHJcbiAgICAgIGxpY2Vuc2VLZXk6IHRoaXMubGljZW5zZUtleSxcclxuICAgICAgbGljZW5zZUZpbGVQYXRoOiB0aGlzLmxpY2Vuc2VGaWxlUGF0aCxcclxuICAgICAgcmVwb3J0OiB0aGlzLnJlcG9ydCxcclxuICAgICAgZ2xvYmFsOiB0aGlzLmdsb2JhbCxcclxuICAgICAgY3VzdG9taXplQVBJUmVxdWVzdDogdGhpcy5jdXN0b21pemVBUElSZXF1ZXN0LFxyXG4gICAgICBjdXN0b21pemVDZWxsOiB0aGlzLmN1c3RvbWl6ZUNlbGwsXHJcbiAgICAgIGN1c3RvbWl6ZUNoYXJ0RWxlbWVudDogdGhpcy5jdXN0b21pemVDaGFydEVsZW1lbnQsXHJcbiAgICAgIGN1c3RvbWl6ZUNvbnRleHRNZW51OiB0aGlzLmN1c3RvbWl6ZUNvbnRleHRNZW51LFxyXG4gICAgICBjZWxsY2xpY2s6IChjZWxsOiBGbGV4bW9uc3Rlci5DZWxsRGF0YSkgPT4gdGhpcy5jZWxsY2xpY2submV4dChjZWxsKSxcclxuICAgICAgY2VsbGRvdWJsZWNsaWNrOiAoY2VsbDogRmxleG1vbnN0ZXIuQ2VsbERhdGEpID0+IHRoaXMuY2VsbGRvdWJsZWNsaWNrLm5leHQoY2VsbCksXHJcbiAgICAgIGNoYXJ0Y2xpY2s6IChldmVudDogRmxleG1vbnN0ZXIuQ2hhcnREYXRhKSA9PiB0aGlzLmNoYXJ0Y2xpY2submV4dChldmVudCksXHJcbiAgICAgIGRhdGFjaGFuZ2VkOiAoZXZlbnQ6IE9iamVjdCkgPT4gdGhpcy5kYXRhY2hhbmdlZC5uZXh0KGV2ZW50KSxcclxuICAgICAgZGF0YWVycm9yOiAoZXZlbnQ6IE9iamVjdCkgPT4gdGhpcy5kYXRhZXJyb3IubmV4dChldmVudCksXHJcbiAgICAgIGRhdGFmaWxlY2FuY2VsbGVkOiAoKSA9PiB0aGlzLmRhdGFmaWxlY2FuY2VsbGVkLm5leHQoKSxcclxuICAgICAgZGF0YWxvYWRlZDogKCkgPT4gdGhpcy5kYXRhbG9hZGVkLm5leHQoKSxcclxuICAgICAgZmllbGRzbGlzdGNsb3NlOiAoKSA9PiB0aGlzLmZpZWxkc2xpc3RjbG9zZS5uZXh0KCksXHJcbiAgICAgIGZpZWxkc2xpc3RvcGVuOiAoKSA9PiB0aGlzLmZpZWxkc2xpc3RvcGVuLm5leHQoKSxcclxuICAgICAgZmlsdGVyY2xvc2U6ICgpID0+IHRoaXMuZmlsdGVyY2xvc2UubmV4dCgpLFxyXG4gICAgICBmaWx0ZXJvcGVuOiAoZXZlbnQ6IE9iamVjdCkgPT4gdGhpcy5maWx0ZXJvcGVuLm5leHQoZXZlbnQpLFxyXG4gICAgICBkcmlsbHRocm91Z2hvcGVuOiAoY2VsbDogRmxleG1vbnN0ZXIuQ2VsbERhdGEgfCBGbGV4bW9uc3Rlci5DaGFydERhdGEpID0+IHRoaXMuZHJpbGx0aHJvdWdob3Blbi5uZXh0KGNlbGwpLFxyXG4gICAgICBleHBvcnRjb21wbGV0ZTogKCkgPT4gdGhpcy5leHBvcnRjb21wbGV0ZS5uZXh0KCksXHJcbiAgICAgIGV4cG9ydHN0YXJ0OiAoKSA9PiB0aGlzLmV4cG9ydHN0YXJ0Lm5leHQoKSxcclxuICAgICAgZHJpbGx0aHJvdWdoY2xvc2U6ICgpID0+IHRoaXMuZHJpbGx0aHJvdWdoY2xvc2UubmV4dCgpLFxyXG4gICAgICBsb2FkaW5nZGF0YTogKCkgPT4gdGhpcy5sb2FkaW5nZGF0YS5uZXh0KCksXHJcbiAgICAgIGxvYWRpbmdsb2NhbGl6YXRpb246ICgpID0+IHRoaXMubG9hZGluZ2xvY2FsaXphdGlvbi5uZXh0KCksXHJcbiAgICAgIGxvYWRpbmdvbGFwc3RydWN0dXJlOiAoKSA9PiB0aGlzLmxvYWRpbmdvbGFwc3RydWN0dXJlLm5leHQoKSxcclxuICAgICAgbG9hZGluZ3JlcG9ydGZpbGU6ICgpID0+IHRoaXMubG9hZGluZ3JlcG9ydGZpbGUubmV4dCgpLFxyXG4gICAgICBsb2NhbGl6YXRpb25lcnJvcjogKCkgPT4gdGhpcy5sb2NhbGl6YXRpb25lcnJvci5uZXh0KCksXHJcbiAgICAgIGxvY2FsaXphdGlvbmxvYWRlZDogKCkgPT4gdGhpcy5sb2NhbGl6YXRpb25sb2FkZWQubmV4dCgpLFxyXG4gICAgICBvbGFwc3RydWN0dXJlZXJyb3I6ICgpID0+IHRoaXMub2xhcHN0cnVjdHVyZWVycm9yLm5leHQoKSxcclxuICAgICAgb2xhcHN0cnVjdHVyZWxvYWRlZDogKCkgPT4gdGhpcy5vbGFwc3RydWN0dXJlbG9hZGVkLm5leHQoKSxcclxuICAgICAgb3BlbmluZ3JlcG9ydGZpbGU6ICgpID0+IHRoaXMub3BlbmluZ3JlcG9ydGZpbGUubmV4dCgpLFxyXG4gICAgICBwcmludGNvbXBsZXRlOiAoKSA9PiB0aGlzLnByaW50Y29tcGxldGUubmV4dCgpLFxyXG4gICAgICBwcmludHN0YXJ0OiAoKSA9PiB0aGlzLnByaW50c3RhcnQubmV4dCgpLFxyXG4gICAgICBxdWVyeWNvbXBsZXRlOiAoKSA9PiB0aGlzLnF1ZXJ5Y29tcGxldGUubmV4dCgpLFxyXG4gICAgICBxdWVyeWVycm9yOiAoKSA9PiB0aGlzLnF1ZXJ5ZXJyb3IubmV4dCgpLFxyXG4gICAgICByZWFkeTogKCkgPT4gdGhpcy5yZWFkeS5uZXh0KHRoaXMuZmxleG1vbnN0ZXIpLFxyXG4gICAgICByZXBvcnRjaGFuZ2U6ICgpID0+IHRoaXMucmVwb3J0Y2hhbmdlLm5leHQoKSxcclxuICAgICAgcmVwb3J0Y29tcGxldGU6ICgpID0+IHRoaXMucmVwb3J0Y29tcGxldGUubmV4dCgpLFxyXG4gICAgICByZXBvcnRmaWxlbG9hZGVkOiAoKSA9PiB0aGlzLnJlcG9ydGZpbGVsb2FkZWQubmV4dCgpLFxyXG4gICAgICByZXBvcnRmaWxlY2FuY2VsbGVkOiAoKSA9PiB0aGlzLnJlcG9ydGZpbGVjYW5jZWxsZWQubmV4dCgpLFxyXG4gICAgICByZXBvcnRmaWxlZXJyb3I6ICgpID0+IHRoaXMucmVwb3J0ZmlsZWVycm9yLm5leHQoKSxcclxuICAgICAgcnVubmluZ3F1ZXJ5OiAoKSA9PiB0aGlzLnJ1bm5pbmdxdWVyeS5uZXh0KCksXHJcbiAgICAgIHVuYXV0aG9yaXplZGVycm9yOiAoZG9uZTogRmxleG1vbnN0ZXIuVW5hdXRob3JpemVkRXJyb3JIYW5kbGVyKSA9PiB0aGlzLnVuYXV0aG9yaXplZGVycm9yLm5leHQoZG9uZSksXHJcbiAgICAgIHVwZGF0ZTogKCkgPT4gdGhpcy51cGRhdGUubmV4dCgpLFxyXG4gICAgICBiZWZvcmV0b29sYmFyY3JlYXRlZDogKHRvb2xiYXI6IE9iamVjdCkgPT4gdGhpcy5iZWZvcmV0b29sYmFyY3JlYXRlZC5uZXh0KHRvb2xiYXIpLFxyXG4gICAgICBiZWZvcmVncmlkZHJhdzogKGV2ZW50OiBPYmplY3QpID0+IHRoaXMuYmVmb3JlZ3JpZGRyYXcubmV4dChldmVudCksXHJcbiAgICAgIGFmdGVyZ3JpZGRyYXc6IChldmVudDogT2JqZWN0KSA9PiB0aGlzLmFmdGVyZ3JpZGRyYXcubmV4dChldmVudCksXHJcbiAgICAgIGFmdGVyY2hhcnRkcmF3OiAoKSA9PiB0aGlzLmFmdGVyY2hhcnRkcmF3Lm5leHQoKVxyXG4gICAgfSk7XHJcbiAgfVxyXG59XHJcbiIsImltcG9ydCB7IE5nTW9kdWxlIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XHJcbmltcG9ydCB7IENvbW1vbk1vZHVsZSB9IGZyb20gJ0Bhbmd1bGFyL2NvbW1vbic7XHJcbmltcG9ydCB7IEZsZXhtb25zdGVyUGl2b3QgfSBmcm9tICcuL2ZsZXhtb25zdGVyLmNvbXBvbmVudCc7XHJcblxyXG5ATmdNb2R1bGUoe1xyXG4gIGltcG9ydHM6IFtcclxuICAgIENvbW1vbk1vZHVsZVxyXG4gIF0sXHJcbiAgZGVjbGFyYXRpb25zOiBbRmxleG1vbnN0ZXJQaXZvdF0sXHJcbiAgZXhwb3J0czogW0ZsZXhtb25zdGVyUGl2b3RdXHJcbn0pXHJcbmV4cG9ydCBjbGFzcyBGbGV4bW9uc3RlclBpdm90TW9kdWxlIHsgfVxyXG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7QUFBQTs7OztJQXFFRSxZQUFZLEVBQWM7O1FBL0NoQixjQUFTLEdBQXVDLElBQUksWUFBWSxFQUFFLENBQUM7UUFDbkUsb0JBQWUsR0FBdUMsSUFBSSxZQUFZLEVBQUUsQ0FBQztRQUN6RSxlQUFVLEdBQXdDLElBQUksWUFBWSxFQUFFLENBQUM7UUFDckUsY0FBUyxHQUF5QixJQUFJLFlBQVksRUFBRSxDQUFDO1FBQ3JELHNCQUFpQixHQUF5QixJQUFJLFlBQVksRUFBRSxDQUFDO1FBQzdELGVBQVUsR0FBeUIsSUFBSSxZQUFZLEVBQUUsQ0FBQztRQUN0RCxnQkFBVyxHQUF5QixJQUFJLFlBQVksRUFBRSxDQUFDO1FBQ3ZELG9CQUFlLEdBQXlCLElBQUksWUFBWSxFQUFFLENBQUM7UUFDM0QsbUJBQWMsR0FBeUIsSUFBSSxZQUFZLEVBQUUsQ0FBQztRQUMxRCxnQkFBVyxHQUF5QixJQUFJLFlBQVksRUFBRSxDQUFDO1FBQ3ZELGVBQVUsR0FBeUIsSUFBSSxZQUFZLEVBQUUsQ0FBQztRQUN0RCxxQkFBZ0IsR0FBK0QsSUFBSSxZQUFZLEVBQUUsQ0FBQztRQUNsRyxtQkFBYyxHQUF5QixJQUFJLFlBQVksRUFBRSxDQUFDO1FBQzFELGdCQUFXLEdBQXlCLElBQUksWUFBWSxFQUFFLENBQUM7UUFDdkQsc0JBQWlCLEdBQXlCLElBQUksWUFBWSxFQUFFLENBQUM7UUFDN0QsZUFBVSxHQUF5QixJQUFJLFlBQVksRUFBRSxDQUFDO1FBQ3RELGdCQUFXLEdBQXlCLElBQUksWUFBWSxFQUFFLENBQUM7UUFDdkQsd0JBQW1CLEdBQXlCLElBQUksWUFBWSxFQUFFLENBQUM7UUFDL0QseUJBQW9CLEdBQXlCLElBQUksWUFBWSxFQUFFLENBQUM7UUFDaEUsc0JBQWlCLEdBQXlCLElBQUksWUFBWSxFQUFFLENBQUM7UUFDN0Qsc0JBQWlCLEdBQXlCLElBQUksWUFBWSxFQUFFLENBQUM7UUFDN0QsdUJBQWtCLEdBQXlCLElBQUksWUFBWSxFQUFFLENBQUM7UUFDOUQsdUJBQWtCLEdBQXlCLElBQUksWUFBWSxFQUFFLENBQUM7UUFDOUQsd0JBQW1CLEdBQXlCLElBQUksWUFBWSxFQUFFLENBQUM7UUFDL0Qsc0JBQWlCLEdBQXlCLElBQUksWUFBWSxFQUFFLENBQUM7UUFDN0Qsa0JBQWEsR0FBeUIsSUFBSSxZQUFZLEVBQUUsQ0FBQztRQUN6RCxlQUFVLEdBQXlCLElBQUksWUFBWSxFQUFFLENBQUM7UUFDdEQsa0JBQWEsR0FBeUIsSUFBSSxZQUFZLEVBQUUsQ0FBQztRQUN6RCxlQUFVLEdBQXlCLElBQUksWUFBWSxFQUFFLENBQUM7UUFDdEQsVUFBSyxHQUFvQyxJQUFJLFlBQVksRUFBRSxDQUFDO1FBQzVELGlCQUFZLEdBQXlCLElBQUksWUFBWSxFQUFFLENBQUM7UUFDeEQsbUJBQWMsR0FBeUIsSUFBSSxZQUFZLEVBQUUsQ0FBQztRQUMxRCx3QkFBbUIsR0FBeUIsSUFBSSxZQUFZLEVBQUUsQ0FBQztRQUMvRCxvQkFBZSxHQUF5QixJQUFJLFlBQVksRUFBRSxDQUFDO1FBQzNELHFCQUFnQixHQUF5QixJQUFJLFlBQVksRUFBRSxDQUFDO1FBQzVELGlCQUFZLEdBQXlCLElBQUksWUFBWSxFQUFFLENBQUM7UUFDeEQsc0JBQWlCLEdBQXVELElBQUksWUFBWSxFQUFFLENBQUM7UUFDM0YsV0FBTSxHQUF5QixJQUFJLFlBQVksRUFBRSxDQUFDO1FBQ2xELHlCQUFvQixHQUF5QixJQUFJLFlBQVksRUFBRSxDQUFDO1FBQ2hFLG1CQUFjLEdBQXlCLElBQUksWUFBWSxFQUFFLENBQUM7UUFDMUQsa0JBQWEsR0FBeUIsSUFBSSxZQUFZLEVBQUUsQ0FBQztRQUN6RCxtQkFBYyxHQUF5QixJQUFJLFlBQVksRUFBRSxDQUFDO1FBT2xFLElBQUksQ0FBQyxJQUFJLHNCQUFnQixFQUFFLENBQUMsYUFBYSxFQUFBLENBQUM7S0FDM0M7Ozs7SUFFRCxRQUFRO1FBQ04sSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLFdBQVcsQ0FBQztZQUNqQyxTQUFTLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDL0QsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlO1lBQ3JDLEtBQUssRUFBRSxJQUFJLENBQUMsS0FBSztZQUNqQixNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU07WUFDbkIsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO1lBQ3JCLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVTtZQUMzQixlQUFlLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDckMsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNO1lBQ25CLE1BQU0sRUFBRSxJQUFJLENBQUMsTUFBTTtZQUNuQixtQkFBbUIsRUFBRSxJQUFJLENBQUMsbUJBQW1CO1lBQzdDLGFBQWEsRUFBRSxJQUFJLENBQUMsYUFBYTtZQUNqQyxxQkFBcUIsRUFBRSxJQUFJLENBQUMscUJBQXFCO1lBQ2pELG9CQUFvQixFQUFFLElBQUksQ0FBQyxvQkFBb0I7WUFDL0MsU0FBUyxFQUFFLENBQUMsSUFBMEIsS0FBSyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7WUFDcEUsZUFBZSxFQUFFLENBQUMsSUFBMEIsS0FBSyxJQUFJLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7WUFDaEYsVUFBVSxFQUFFLENBQUMsS0FBNEIsS0FBSyxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7WUFDekUsV0FBVyxFQUFFLENBQUMsS0FBYSxLQUFLLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQztZQUM1RCxTQUFTLEVBQUUsQ0FBQyxLQUFhLEtBQUssSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO1lBQ3hELGlCQUFpQixFQUFFLE1BQU0sSUFBSSxDQUFDLGlCQUFpQixDQUFDLElBQUksRUFBRTtZQUN0RCxVQUFVLEVBQUUsTUFBTSxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksRUFBRTtZQUN4QyxlQUFlLEVBQUUsTUFBTSxJQUFJLENBQUMsZUFBZSxDQUFDLElBQUksRUFBRTtZQUNsRCxjQUFjLEVBQUUsTUFBTSxJQUFJLENBQUMsY0FBYyxDQUFDLElBQUksRUFBRTtZQUNoRCxXQUFXLEVBQUUsTUFBTSxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksRUFBRTtZQUMxQyxVQUFVLEVBQUUsQ0FBQyxLQUFhLEtBQUssSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO1lBQzFELGdCQUFnQixFQUFFLENBQUMsSUFBa0QsS0FBSyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQztZQUMxRyxjQUFjLEVBQUUsTUFBTSxJQUFJLENBQUMsY0FBYyxDQUFDLElBQUksRUFBRTtZQUNoRCxXQUFXLEVBQUUsTUFBTSxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksRUFBRTtZQUMxQyxpQkFBaUIsRUFBRSxNQUFNLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLEVBQUU7WUFDdEQsV0FBVyxFQUFFLE1BQU0sSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLEVBQUU7WUFDMUMsbUJBQW1CLEVBQUUsTUFBTSxJQUFJLENBQUMsbUJBQW1CLENBQUMsSUFBSSxFQUFFO1lBQzFELG9CQUFvQixFQUFFLE1BQU0sSUFBSSxDQUFDLG9CQUFvQixDQUFDLElBQUksRUFBRTtZQUM1RCxpQkFBaUIsRUFBRSxNQUFNLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLEVBQUU7WUFDdEQsaUJBQWlCLEVBQUUsTUFBTSxJQUFJLENBQUMsaUJBQWlCLENBQUMsSUFBSSxFQUFFO1lBQ3RELGtCQUFrQixFQUFFLE1BQU0sSUFBSSxDQUFDLGtCQUFrQixDQUFDLElBQUksRUFBRTtZQUN4RCxrQkFBa0IsRUFBRSxNQUFNLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLEVBQUU7WUFDeEQsbUJBQW1CLEVBQUUsTUFBTSxJQUFJLENBQUMsbUJBQW1CLENBQUMsSUFBSSxFQUFFO1lBQzFELGlCQUFpQixFQUFFLE1BQU0sSUFBSSxDQUFDLGlCQUFpQixDQUFDLElBQUksRUFBRTtZQUN0RCxhQUFhLEVBQUUsTUFBTSxJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksRUFBRTtZQUM5QyxVQUFVLEVBQUUsTUFBTSxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksRUFBRTtZQUN4QyxhQUFhLEVBQUUsTUFBTSxJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksRUFBRTtZQUM5QyxVQUFVLEVBQUUsTUFBTSxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksRUFBRTtZQUN4QyxLQUFLLEVBQUUsTUFBTSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQzlDLFlBQVksRUFBRSxNQUFNLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxFQUFFO1lBQzVDLGNBQWMsRUFBRSxNQUFNLElBQUksQ0FBQyxjQUFjLENBQUMsSUFBSSxFQUFFO1lBQ2hELGdCQUFnQixFQUFFLE1BQU0sSUFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksRUFBRTtZQUNwRCxtQkFBbUIsRUFBRSxNQUFNLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLEVBQUU7WUFDMUQsZUFBZSxFQUFFLE1BQU0sSUFBSSxDQUFDLGVBQWUsQ0FBQyxJQUFJLEVBQUU7WUFDbEQsWUFBWSxFQUFFLE1BQU0sSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLEVBQUU7WUFDNUMsaUJBQWlCLEVBQUUsQ0FBQyxJQUEwQyxLQUFLLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO1lBQ3BHLE1BQU0sRUFBRSxNQUFNLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxFQUFFO1lBQ2hDLG9CQUFvQixFQUFFLENBQUMsT0FBZSxLQUFLLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDO1lBQ2xGLGNBQWMsRUFBRSxDQUFDLEtBQWEsS0FBSyxJQUFJLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7WUFDbEUsYUFBYSxFQUFFLENBQUMsS0FBYSxLQUFLLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQztZQUNoRSxjQUFjLEVBQUUsTUFBTSxJQUFJLENBQUMsY0FBYyxDQUFDLElBQUksRUFBRTtTQUNqRCxDQUFDLENBQUM7S0FDSjs7O1lBL0hGLFNBQVMsU0FBQztnQkFDVCxRQUFRLEVBQUUsVUFBVTtnQkFDcEIsUUFBUSxFQUFFLDhFQUE4RTthQUN6Rjs7O1lBTm1CLFVBQVU7OztzQkFTM0IsS0FBSzt5QkFDTCxLQUFLOzhCQUNMLEtBQUs7b0JBQ0wsS0FBSztxQkFDTCxLQUFLOzhCQUNMLEtBQUs7cUJBQ0wsS0FBSztxQkFDTCxLQUFLO2tDQUNMLEtBQUs7NEJBQ0wsS0FBSztvQ0FDTCxLQUFLO21DQUNMLEtBQUs7d0JBRUwsTUFBTTs4QkFDTixNQUFNO3lCQUNOLE1BQU07d0JBQ04sTUFBTTtnQ0FDTixNQUFNO3lCQUNOLE1BQU07MEJBQ04sTUFBTTs4QkFDTixNQUFNOzZCQUNOLE1BQU07MEJBQ04sTUFBTTt5QkFDTixNQUFNOytCQUNOLE1BQU07NkJBQ04sTUFBTTswQkFDTixNQUFNO2dDQUNOLE1BQU07eUJBQ04sTUFBTTswQkFDTixNQUFNO2tDQUNOLE1BQU07bUNBQ04sTUFBTTtnQ0FDTixNQUFNO2dDQUNOLE1BQU07aUNBQ04sTUFBTTtpQ0FDTixNQUFNO2tDQUNOLE1BQU07Z0NBQ04sTUFBTTs0QkFDTixNQUFNO3lCQUNOLE1BQU07NEJBQ04sTUFBTTt5QkFDTixNQUFNO29CQUNOLE1BQU07MkJBQ04sTUFBTTs2QkFDTixNQUFNO2tDQUNOLE1BQU07OEJBQ04sTUFBTTsrQkFDTixNQUFNOzJCQUNOLE1BQU07Z0NBQ04sTUFBTTtxQkFDTixNQUFNO21DQUNOLE1BQU07NkJBQ04sTUFBTTs0QkFDTixNQUFNOzZCQUNOLE1BQU07Ozs7Ozs7QUMvRFQ7OztZQUlDLFFBQVEsU0FBQztnQkFDUixPQUFPLEVBQUU7b0JBQ1AsWUFBWTtpQkFDYjtnQkFDRCxZQUFZLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQztnQkFDaEMsT0FBTyxFQUFFLENBQUMsZ0JBQWdCLENBQUM7YUFDNUI7Ozs7Ozs7Ozs7Ozs7OzsifQ==