'use strict';

exports.__esModule = true;
exports['default'] = Connector;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _utilsIsFunction = require('../utils/isFunction');

var _utilsIsFunction2 = _interopRequireDefault(_utilsIsFunction);

var _utilsShallowEqual = require('../utils/shallowEqual');

var _utilsShallowEqual2 = _interopRequireDefault(_utilsShallowEqual);

var _invariant = require('invariant');

var _invariant2 = _interopRequireDefault(_invariant);

function Connector(store) {
  return {
    connect: function connect(selectors, callback) {
      var disableCaching = arguments.length <= 2 || arguments[2] === undefined ? false : arguments[2];

      if (!Array.isArray(selectors)) {
        selectors = [selectors];
      }

      _invariant2['default'](_utilsIsFunction2['default'](callback), 'The callback parameter passed to connect must be a Function. Instead received %s.', typeof selector);

      //Initial update
      var params = selectors.map(function (selector) {
        return selector(store.getState());
      });
      callback.apply(undefined, params);

      var unsubscribe = store.subscribe(function () {
        var nextParams = selectors.map(function (selector) {
          return selector(store.getState());
        });
        if (disableCaching || !_utilsShallowEqual2['default'](params, nextParams)) {
          callback.apply(undefined, nextParams);
          params = nextParams;
        }
      });

      return unsubscribe;
    },
    getStore: function getStore() {
      return store;
    }
  };
}

module.exports = exports['default'];