/**
 * @fileoverview added by tsickle
 * Generated from: lib/ng-dropdown-panel.service.ts
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingRequire,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
import { Injectable } from '@angular/core';
/**
 * @record
 */
export function ItemsRangeResult() { }
if (false) {
    /** @type {?} */
    ItemsRangeResult.prototype.scrollHeight;
    /** @type {?} */
    ItemsRangeResult.prototype.topPadding;
    /** @type {?} */
    ItemsRangeResult.prototype.start;
    /** @type {?} */
    ItemsRangeResult.prototype.end;
}
/**
 * @record
 */
export function PanelDimensions() { }
if (false) {
    /** @type {?} */
    PanelDimensions.prototype.itemHeight;
    /** @type {?} */
    PanelDimensions.prototype.panelHeight;
    /** @type {?} */
    PanelDimensions.prototype.itemsPerViewport;
}
export class NgDropdownPanelService {
    constructor() {
        this._dimensions = {
            itemHeight: 0,
            panelHeight: 0,
            itemsPerViewport: 0
        };
    }
    /**
     * @return {?}
     */
    get dimensions() {
        return this._dimensions;
    }
    /**
     * @param {?} scrollPos
     * @param {?} itemsLength
     * @param {?} buffer
     * @return {?}
     */
    calculateItems(scrollPos, itemsLength, buffer) {
        /** @type {?} */
        const d = this._dimensions;
        /** @type {?} */
        const scrollHeight = d.itemHeight * itemsLength;
        /** @type {?} */
        const scrollTop = Math.max(0, scrollPos);
        /** @type {?} */
        const indexByScrollTop = scrollTop / scrollHeight * itemsLength;
        /** @type {?} */
        let end = Math.min(itemsLength, Math.ceil(indexByScrollTop) + (d.itemsPerViewport + 1));
        /** @type {?} */
        const maxStartEnd = end;
        /** @type {?} */
        const maxStart = Math.max(0, maxStartEnd - d.itemsPerViewport);
        /** @type {?} */
        let start = Math.min(maxStart, Math.floor(indexByScrollTop));
        /** @type {?} */
        let topPadding = d.itemHeight * Math.ceil(start) - (d.itemHeight * Math.min(start, buffer));
        topPadding = !isNaN(topPadding) ? topPadding : 0;
        start = !isNaN(start) ? start : -1;
        end = !isNaN(end) ? end : -1;
        start -= buffer;
        start = Math.max(0, start);
        end += buffer;
        end = Math.min(itemsLength, end);
        return {
            topPadding,
            scrollHeight,
            start,
            end
        };
    }
    /**
     * @param {?} itemHeight
     * @param {?} panelHeight
     * @return {?}
     */
    setDimensions(itemHeight, panelHeight) {
        /** @type {?} */
        const itemsPerViewport = Math.max(1, Math.floor(panelHeight / itemHeight));
        this._dimensions = {
            itemHeight,
            panelHeight,
            itemsPerViewport
        };
    }
    /**
     * @param {?} itemTop
     * @param {?} itemHeight
     * @param {?} lastScroll
     * @return {?}
     */
    getScrollTo(itemTop, itemHeight, lastScroll) {
        const { panelHeight } = this.dimensions;
        /** @type {?} */
        const itemBottom = itemTop + itemHeight;
        /** @type {?} */
        const top = lastScroll;
        /** @type {?} */
        const bottom = top + panelHeight;
        if (panelHeight >= itemBottom && lastScroll === itemTop) {
            return null;
        }
        if (itemBottom > bottom) {
            return top + itemBottom - bottom;
        }
        else if (itemTop <= top) {
            return itemTop;
        }
        return null;
    }
}
NgDropdownPanelService.decorators = [
    { type: Injectable }
];
if (false) {
    /**
     * @type {?}
     * @private
     */
    NgDropdownPanelService.prototype._dimensions;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmctZHJvcGRvd24tcGFuZWwuc2VydmljZS5qcyIsInNvdXJjZVJvb3QiOiIvaG9tZS9ydW5uZXIvd29yay9uZy1zZWxlY3Qvbmctc2VsZWN0L3NyYy9uZy1zZWxlY3QvIiwic291cmNlcyI6WyJsaWIvbmctZHJvcGRvd24tcGFuZWwuc2VydmljZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLE9BQU8sRUFBRSxVQUFVLEVBQUUsTUFBTSxlQUFlLENBQUM7Ozs7QUFDM0Msc0NBS0M7OztJQUpHLHdDQUFxQjs7SUFDckIsc0NBQW1COztJQUNuQixpQ0FBYzs7SUFDZCwrQkFBWTs7Ozs7QUFHaEIscUNBSUM7OztJQUhHLHFDQUFtQjs7SUFDbkIsc0NBQW9COztJQUNwQiwyQ0FBeUI7O0FBSTdCLE1BQU0sT0FBTyxzQkFBc0I7SUFEbkM7UUFHWSxnQkFBVyxHQUFvQjtZQUNuQyxVQUFVLEVBQUUsQ0FBQztZQUNiLFdBQVcsRUFBRSxDQUFDO1lBQ2QsZ0JBQWdCLEVBQUUsQ0FBQztTQUN0QixDQUFDO0lBOEROLENBQUM7Ozs7SUE1REcsSUFBSSxVQUFVO1FBQ1YsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDO0lBQzVCLENBQUM7Ozs7Ozs7SUFFRCxjQUFjLENBQUMsU0FBaUIsRUFBRSxXQUFtQixFQUFFLE1BQWM7O2NBQzNELENBQUMsR0FBRyxJQUFJLENBQUMsV0FBVzs7Y0FDcEIsWUFBWSxHQUFHLENBQUMsQ0FBQyxVQUFVLEdBQUcsV0FBVzs7Y0FFekMsU0FBUyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxFQUFFLFNBQVMsQ0FBQzs7Y0FDbEMsZ0JBQWdCLEdBQUcsU0FBUyxHQUFHLFlBQVksR0FBRyxXQUFXOztZQUMzRCxHQUFHLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxXQUFXLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLGdCQUFnQixHQUFHLENBQUMsQ0FBQyxDQUFDOztjQUVqRixXQUFXLEdBQUcsR0FBRzs7Y0FDakIsUUFBUSxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxFQUFFLFdBQVcsR0FBRyxDQUFDLENBQUMsZ0JBQWdCLENBQUM7O1lBQzFELEtBQUssR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLFFBQVEsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGdCQUFnQixDQUFDLENBQUM7O1lBRXhELFVBQVUsR0FBRyxDQUFDLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxFQUFFLE1BQU0sQ0FBQyxDQUFDO1FBQzNGLFVBQVUsR0FBRyxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDakQsS0FBSyxHQUFHLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ25DLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUM3QixLQUFLLElBQUksTUFBTSxDQUFDO1FBQ2hCLEtBQUssR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUMzQixHQUFHLElBQUksTUFBTSxDQUFDO1FBQ2QsR0FBRyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBRWpDLE9BQU87WUFDSCxVQUFVO1lBQ1YsWUFBWTtZQUNaLEtBQUs7WUFDTCxHQUFHO1NBQ04sQ0FBQTtJQUNMLENBQUM7Ozs7OztJQUVELGFBQWEsQ0FBQyxVQUFrQixFQUFFLFdBQW1COztjQUMzQyxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsR0FBRyxVQUFVLENBQUMsQ0FBQztRQUMxRSxJQUFJLENBQUMsV0FBVyxHQUFHO1lBQ2YsVUFBVTtZQUNWLFdBQVc7WUFDWCxnQkFBZ0I7U0FDbkIsQ0FBQztJQUNOLENBQUM7Ozs7Ozs7SUFFRCxXQUFXLENBQUMsT0FBZSxFQUFFLFVBQWtCLEVBQUUsVUFBa0I7Y0FDekQsRUFBRSxXQUFXLEVBQUUsR0FBRyxJQUFJLENBQUMsVUFBVTs7Y0FDakMsVUFBVSxHQUFHLE9BQU8sR0FBRyxVQUFVOztjQUNqQyxHQUFHLEdBQUcsVUFBVTs7Y0FDaEIsTUFBTSxHQUFHLEdBQUcsR0FBRyxXQUFXO1FBRWhDLElBQUksV0FBVyxJQUFJLFVBQVUsSUFBSSxVQUFVLEtBQUssT0FBTyxFQUFFO1lBQ3JELE9BQU8sSUFBSSxDQUFDO1NBQ2Y7UUFFRCxJQUFJLFVBQVUsR0FBRyxNQUFNLEVBQUU7WUFDckIsT0FBTyxHQUFHLEdBQUcsVUFBVSxHQUFHLE1BQU0sQ0FBQztTQUNwQzthQUFNLElBQUksT0FBTyxJQUFJLEdBQUcsRUFBRTtZQUN2QixPQUFPLE9BQU8sQ0FBQztTQUNsQjtRQUVELE9BQU8sSUFBSSxDQUFDO0lBQ2hCLENBQUM7OztZQXBFSixVQUFVOzs7Ozs7O0lBR1AsNkNBSUUiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJbmplY3RhYmxlIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5leHBvcnQgaW50ZXJmYWNlIEl0ZW1zUmFuZ2VSZXN1bHQge1xuICAgIHNjcm9sbEhlaWdodDogbnVtYmVyO1xuICAgIHRvcFBhZGRpbmc6IG51bWJlcjtcbiAgICBzdGFydDogbnVtYmVyO1xuICAgIGVuZDogbnVtYmVyO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIFBhbmVsRGltZW5zaW9ucyB7XG4gICAgaXRlbUhlaWdodDogbnVtYmVyO1xuICAgIHBhbmVsSGVpZ2h0OiBudW1iZXI7XG4gICAgaXRlbXNQZXJWaWV3cG9ydDogbnVtYmVyO1xufVxuXG5ASW5qZWN0YWJsZSgpXG5leHBvcnQgY2xhc3MgTmdEcm9wZG93blBhbmVsU2VydmljZSB7XG5cbiAgICBwcml2YXRlIF9kaW1lbnNpb25zOiBQYW5lbERpbWVuc2lvbnMgPSB7XG4gICAgICAgIGl0ZW1IZWlnaHQ6IDAsXG4gICAgICAgIHBhbmVsSGVpZ2h0OiAwLFxuICAgICAgICBpdGVtc1BlclZpZXdwb3J0OiAwXG4gICAgfTtcblxuICAgIGdldCBkaW1lbnNpb25zKCkge1xuICAgICAgICByZXR1cm4gdGhpcy5fZGltZW5zaW9ucztcbiAgICB9XG5cbiAgICBjYWxjdWxhdGVJdGVtcyhzY3JvbGxQb3M6IG51bWJlciwgaXRlbXNMZW5ndGg6IG51bWJlciwgYnVmZmVyOiBudW1iZXIpOiBJdGVtc1JhbmdlUmVzdWx0IHtcbiAgICAgICAgY29uc3QgZCA9IHRoaXMuX2RpbWVuc2lvbnM7XG4gICAgICAgIGNvbnN0IHNjcm9sbEhlaWdodCA9IGQuaXRlbUhlaWdodCAqIGl0ZW1zTGVuZ3RoO1xuXG4gICAgICAgIGNvbnN0IHNjcm9sbFRvcCA9IE1hdGgubWF4KDAsIHNjcm9sbFBvcyk7XG4gICAgICAgIGNvbnN0IGluZGV4QnlTY3JvbGxUb3AgPSBzY3JvbGxUb3AgLyBzY3JvbGxIZWlnaHQgKiBpdGVtc0xlbmd0aDtcbiAgICAgICAgbGV0IGVuZCA9IE1hdGgubWluKGl0ZW1zTGVuZ3RoLCBNYXRoLmNlaWwoaW5kZXhCeVNjcm9sbFRvcCkgKyAoZC5pdGVtc1BlclZpZXdwb3J0ICsgMSkpO1xuXG4gICAgICAgIGNvbnN0IG1heFN0YXJ0RW5kID0gZW5kO1xuICAgICAgICBjb25zdCBtYXhTdGFydCA9IE1hdGgubWF4KDAsIG1heFN0YXJ0RW5kIC0gZC5pdGVtc1BlclZpZXdwb3J0KTtcbiAgICAgICAgbGV0IHN0YXJ0ID0gTWF0aC5taW4obWF4U3RhcnQsIE1hdGguZmxvb3IoaW5kZXhCeVNjcm9sbFRvcCkpO1xuXG4gICAgICAgIGxldCB0b3BQYWRkaW5nID0gZC5pdGVtSGVpZ2h0ICogTWF0aC5jZWlsKHN0YXJ0KSAtIChkLml0ZW1IZWlnaHQgKiBNYXRoLm1pbihzdGFydCwgYnVmZmVyKSk7XG4gICAgICAgIHRvcFBhZGRpbmcgPSAhaXNOYU4odG9wUGFkZGluZykgPyB0b3BQYWRkaW5nIDogMDtcbiAgICAgICAgc3RhcnQgPSAhaXNOYU4oc3RhcnQpID8gc3RhcnQgOiAtMTtcbiAgICAgICAgZW5kID0gIWlzTmFOKGVuZCkgPyBlbmQgOiAtMTtcbiAgICAgICAgc3RhcnQgLT0gYnVmZmVyO1xuICAgICAgICBzdGFydCA9IE1hdGgubWF4KDAsIHN0YXJ0KTtcbiAgICAgICAgZW5kICs9IGJ1ZmZlcjtcbiAgICAgICAgZW5kID0gTWF0aC5taW4oaXRlbXNMZW5ndGgsIGVuZCk7XG5cbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIHRvcFBhZGRpbmcsXG4gICAgICAgICAgICBzY3JvbGxIZWlnaHQsXG4gICAgICAgICAgICBzdGFydCxcbiAgICAgICAgICAgIGVuZFxuICAgICAgICB9XG4gICAgfVxuXG4gICAgc2V0RGltZW5zaW9ucyhpdGVtSGVpZ2h0OiBudW1iZXIsIHBhbmVsSGVpZ2h0OiBudW1iZXIpIHtcbiAgICAgICAgY29uc3QgaXRlbXNQZXJWaWV3cG9ydCA9IE1hdGgubWF4KDEsIE1hdGguZmxvb3IocGFuZWxIZWlnaHQgLyBpdGVtSGVpZ2h0KSk7XG4gICAgICAgIHRoaXMuX2RpbWVuc2lvbnMgPSB7XG4gICAgICAgICAgICBpdGVtSGVpZ2h0LFxuICAgICAgICAgICAgcGFuZWxIZWlnaHQsXG4gICAgICAgICAgICBpdGVtc1BlclZpZXdwb3J0XG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgZ2V0U2Nyb2xsVG8oaXRlbVRvcDogbnVtYmVyLCBpdGVtSGVpZ2h0OiBudW1iZXIsIGxhc3RTY3JvbGw6IG51bWJlcikge1xuICAgICAgICBjb25zdCB7IHBhbmVsSGVpZ2h0IH0gPSB0aGlzLmRpbWVuc2lvbnM7XG4gICAgICAgIGNvbnN0IGl0ZW1Cb3R0b20gPSBpdGVtVG9wICsgaXRlbUhlaWdodDtcbiAgICAgICAgY29uc3QgdG9wID0gbGFzdFNjcm9sbDtcbiAgICAgICAgY29uc3QgYm90dG9tID0gdG9wICsgcGFuZWxIZWlnaHQ7XG5cbiAgICAgICAgaWYgKHBhbmVsSGVpZ2h0ID49IGl0ZW1Cb3R0b20gJiYgbGFzdFNjcm9sbCA9PT0gaXRlbVRvcCkge1xuICAgICAgICAgICAgcmV0dXJuIG51bGw7XG4gICAgICAgIH1cblxuICAgICAgICBpZiAoaXRlbUJvdHRvbSA+IGJvdHRvbSkge1xuICAgICAgICAgICAgcmV0dXJuIHRvcCArIGl0ZW1Cb3R0b20gLSBib3R0b207XG4gICAgICAgIH0gZWxzZSBpZiAoaXRlbVRvcCA8PSB0b3ApIHtcbiAgICAgICAgICAgIHJldHVybiBpdGVtVG9wO1xuICAgICAgICB9XG5cbiAgICAgICAgcmV0dXJuIG51bGw7XG4gICAgfVxufVxuIl19