"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require("@angular/core");
var SemanticTabComponent = (function () {
    function SemanticTabComponent() {
    }
    SemanticTabComponent.prototype.ngAfterViewInit = function () {
        this.tabEl.nativeElement.parentElement.classList.add("ui", "tab", "bottom", "attached", "segment");
        if (this.active) {
            this.tabEl.nativeElement.parentElement.classList.add("active");
        }
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Number)
    ], SemanticTabComponent.prototype, "tab", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], SemanticTabComponent.prototype, "title", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], SemanticTabComponent.prototype, "active", void 0);
    __decorate([
        core_1.ViewChild("tab"), 
        __metadata('design:type', core_1.ElementRef)
    ], SemanticTabComponent.prototype, "tabEl", void 0);
    SemanticTabComponent = __decorate([
        core_1.Component({
            selector: "sm-tab",
            template: "\n<div #tab>\n    <ng-content></ng-content>\n</div>  "
        }), 
        __metadata('design:paramtypes', [])
    ], SemanticTabComponent);
    return SemanticTabComponent;
}());
exports.SemanticTabComponent = SemanticTabComponent;
var SemanticTabsComponent = (function () {
    function SemanticTabsComponent(elementRef) {
        this.elementRef = elementRef;
    }
    SemanticTabsComponent.prototype.ngAfterViewInit = function () {
        this.tabs
            .map(function (cmp, index) {
            cmp.tabEl.nativeElement.parentElement.setAttribute("data-tab", index.toString());
        });
        jQuery(this.menu.nativeElement.getElementsByClassName("item")).tab({
            childrenOnly: true,
            context: jQuery(this.elementRef.nativeElement)
        });
    };
    __decorate([
        core_1.ContentChildren(SemanticTabComponent), 
        __metadata('design:type', core_1.QueryList)
    ], SemanticTabsComponent.prototype, "tabs", void 0);
    __decorate([
        core_1.ViewChild("menu"), 
        __metadata('design:type', core_1.ElementRef)
    ], SemanticTabsComponent.prototype, "menu", void 0);
    SemanticTabsComponent = __decorate([
        core_1.Component({
            directives: [SemanticTabComponent],
            selector: "sm-tabs",
            template: "<div class=\"ui top attached tabular menu\" #menu>\n  <a class=\"item\" [ngClass]=\"{'active': tab.active}\" *ngFor=\"let tab of tabs; let i = index\" [attr.data-tab]=\"i\">{{tab.title}}</a>\n</div>\n<ng-content></ng-content>\n"
        }), 
        __metadata('design:paramtypes', [core_1.ElementRef])
    ], SemanticTabsComponent);
    return SemanticTabsComponent;
}());
exports.SemanticTabsComponent = SemanticTabsComponent;
