/**
 * ngTable: Table + Angular JS
 *
 * @author Vitalii Savchuk <esvit666@gmail.com>
 * @url https://github.com/esvit/ng-table/
 * @license New BSD License <http://creativecommons.org/licenses/BSD/>
 */
ngTableColumnsBinding.$inject = ["$parse"];
/**
 * One-way data binds the $columns array generated by ngTable/ngTableDynamic to the specified
 * expression.
 * This allows the $columns array created for the table to be accessed outside of the html table
 * markup.
 *
 * @ngdoc directive
 *
 * @example
 * ```html
 * <table ng-table="$ctrl.tableParams" class="table" ng-table-columns-binding="$ctlr.tableColumns">
 * ```
 */
export function ngTableColumnsBinding($parse) {
    var directive = {
        restrict: 'A',
        require: 'ngTable',
        link: linkFn
    };
    return directive;
    function linkFn($scope, $element, $attrs) {
        var setter = $parse($attrs.ngTableColumnsBinding).assign;
        if (setter) {
            $scope.$watch('$columns', function (newColumns) {
                var shallowClone = (newColumns || []).slice(0);
                setter($scope, shallowClone);
            });
        }
    }
}
//# sourceMappingURL=ngTableColumnsBinding.directive.js.map