(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/common'), require('@angular/core'), require('@angular/cdk/coercion'), require('@angular/animations'), require('rxjs'), require('rxjs/operators'), require('@angular/cdk/keycodes'), require('@angular/cdk/overlay'), require('@angular/cdk/portal'), require('@angular/forms'), require('@angular/cdk/observers'), require('@angular/router'), require('@angular/cdk/platform'), require('date-fns/parse'), require('date-fns/set_month'), require('date-fns/add_days'), require('date-fns/difference_in_calendar_days'), require('date-fns/difference_in_calendar_months'), require('date-fns/difference_in_calendar_weeks'), require('date-fns/end_of_month'), require('date-fns/is_same_day'), require('date-fns/is_same_month'), require('date-fns/is_same_year'), require('date-fns/is_this_month'), require('date-fns/is_this_year'), require('date-fns/set_year'), require('date-fns/start_of_month'), require('date-fns/start_of_week'), require('date-fns/start_of_year'), require('date-fns/add_months'), require('date-fns/add_years'), require('date-fns/set_day'), require('@angular/cdk/a11y'), require('@angular/cdk/bidi'), require('@angular/common/http')) :
    typeof define === 'function' && define.amd ? define('ng-zorro-antd', ['exports', '@angular/common', '@angular/core', '@angular/cdk/coercion', '@angular/animations', 'rxjs', 'rxjs/operators', '@angular/cdk/keycodes', '@angular/cdk/overlay', '@angular/cdk/portal', '@angular/forms', '@angular/cdk/observers', '@angular/router', '@angular/cdk/platform', 'date-fns/parse', 'date-fns/set_month', 'date-fns/add_days', 'date-fns/difference_in_calendar_days', 'date-fns/difference_in_calendar_months', 'date-fns/difference_in_calendar_weeks', 'date-fns/end_of_month', 'date-fns/is_same_day', 'date-fns/is_same_month', 'date-fns/is_same_year', 'date-fns/is_this_month', 'date-fns/is_this_year', 'date-fns/set_year', 'date-fns/start_of_month', 'date-fns/start_of_week', 'date-fns/start_of_year', 'date-fns/add_months', 'date-fns/add_years', 'date-fns/set_day', '@angular/cdk/a11y', '@angular/cdk/bidi', '@angular/common/http'], factory) :
    (factory((global['ng-zorro-antd'] = {}),global.ng.common,global.ng.core,global.ng.cdk.coercion,global.ng.animations,global.rxjs,global.rxjs.operators,global.ng.cdk.keycodes,global.ng.cdk.overlay,global.ng.cdk.portal,global.ng.forms,global.ng.cdk.observers,global.ng.router,global.ng.cdk.platform,global.parse,global.setMonth,global.addDays,global.differenceInCalendarDays,global.differenceInCalendarMonths,global.differenceInCalendarWeeks,global.endOfMonth,global.isSameDay,global.isSameMonth,global.isSameYear,global.isThisMonth,global.isThisYear,global.setYear,global.startOfMonth,global.startOfWeek,global.startOfYear,global.addMonths,global.addYears,global.setDay,global.ng.cdk.a11y,global.ng.cdk.bidi,global.ng.common.http));
}(this, (function (exports,i1,i0,coercion,animations,rxjs,operators,keycodes,i2,portal,forms,observers,router,platform,parse,setMonth,addDays,differenceInCalendarDays,differenceInCalendarMonths,differenceInCalendarWeeks,endOfMonth,isSameDay,isSameMonth,isSameYear,isThisMonth,isThisYear,setYear,startOfMonth,startOfWeek,startOfYear,addMonths,addYears,setDay,a11y,bidi,http) { 'use strict';

    parse = parse && parse.hasOwnProperty('default') ? parse['default'] : parse;
    setMonth = setMonth && setMonth.hasOwnProperty('default') ? setMonth['default'] : setMonth;
    addDays = addDays && addDays.hasOwnProperty('default') ? addDays['default'] : addDays;
    differenceInCalendarDays = differenceInCalendarDays && differenceInCalendarDays.hasOwnProperty('default') ? differenceInCalendarDays['default'] : differenceInCalendarDays;
    differenceInCalendarMonths = differenceInCalendarMonths && differenceInCalendarMonths.hasOwnProperty('default') ? differenceInCalendarMonths['default'] : differenceInCalendarMonths;
    differenceInCalendarWeeks = differenceInCalendarWeeks && differenceInCalendarWeeks.hasOwnProperty('default') ? differenceInCalendarWeeks['default'] : differenceInCalendarWeeks;
    endOfMonth = endOfMonth && endOfMonth.hasOwnProperty('default') ? endOfMonth['default'] : endOfMonth;
    isSameDay = isSameDay && isSameDay.hasOwnProperty('default') ? isSameDay['default'] : isSameDay;
    isSameMonth = isSameMonth && isSameMonth.hasOwnProperty('default') ? isSameMonth['default'] : isSameMonth;
    isSameYear = isSameYear && isSameYear.hasOwnProperty('default') ? isSameYear['default'] : isSameYear;
    isThisMonth = isThisMonth && isThisMonth.hasOwnProperty('default') ? isThisMonth['default'] : isThisMonth;
    isThisYear = isThisYear && isThisYear.hasOwnProperty('default') ? isThisYear['default'] : isThisYear;
    setYear = setYear && setYear.hasOwnProperty('default') ? setYear['default'] : setYear;
    startOfMonth = startOfMonth && startOfMonth.hasOwnProperty('default') ? startOfMonth['default'] : startOfMonth;
    startOfWeek = startOfWeek && startOfWeek.hasOwnProperty('default') ? startOfWeek['default'] : startOfWeek;
    startOfYear = startOfYear && startOfYear.hasOwnProperty('default') ? startOfYear['default'] : startOfYear;
    addMonths = addMonths && addMonths.hasOwnProperty('default') ? addMonths['default'] : addMonths;
    addYears = addYears && addYears.hasOwnProperty('default') ? addYears['default'] : addYears;
    setDay = setDay && setDay.hasOwnProperty('default') ? setDay['default'] : setDay;

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var availablePrefixs = ['moz', 'ms', 'webkit'];
    /**
     * @return {?}
     */
    function requestAnimationFramePolyfill() {
        /** @type {?} */
        var lastTime = 0;
        return function (callback) {
            /** @type {?} */
            var currTime = new Date().getTime();
            /** @type {?} */
            var timeToCall = Math.max(0, 16 - (currTime - lastTime));
            /** @type {?} */
            var id = window.setTimeout(function () { callback(currTime + timeToCall); }, timeToCall);
            lastTime = currTime + timeToCall;
            return id;
        };
    }
    /**
     * @return {?}
     */
    function getRequestAnimationFrame() {
        if (typeof window === 'undefined') {
            return function () { return null; };
        }
        if (window.requestAnimationFrame) {
            // https://github.com/vuejs/vue/issues/4465
            return window.requestAnimationFrame.bind(window);
        }
        /** @type {?} */
        var prefix = availablePrefixs.filter(function (key) { return key + "RequestAnimationFrame" in window; })[0];
        return prefix
            ? window[prefix + "RequestAnimationFrame"]
            : requestAnimationFramePolyfill();
    }
    /**
     * @param {?} id
     * @return {?}
     */
    function cancelRequestAnimationFrame(id) {
        if (typeof window === 'undefined') {
            return null;
        }
        if (window.cancelAnimationFrame) {
            return window.cancelAnimationFrame(id);
        }
        /** @type {?} */
        var prefix = availablePrefixs.filter(function (key) {
            return key + "CancelAnimationFrame" in window || key + "CancelRequestAnimationFrame" in window;
        })[0];
        return prefix ?
            (( /** @type {?} */(window))[prefix + "CancelAnimationFrame"] ||
                ( /** @type {?} */(window))[prefix + "CancelRequestAnimationFrame"]).call(this, id) : clearTimeout(id);
    }
    /** @type {?} */
    var reqAnimFrame = getRequestAnimationFrame();

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * @param {?} t
     * @param {?} b
     * @param {?} c
     * @param {?} d
     * @return {?}
     */
    function easeInOutCubic(t, b, c, d) {
        /** @type {?} */
        var cc = c - b;
        /** @type {?} */
        var tt = t / (d / 2);
        if (tt < 1) {
            return cc / 2 * tt * tt * tt + b;
        }
        else {
            return cc / 2 * ((tt -= 2) * tt * tt + 2) + b;
        }
    }
    var NzScrollService = /** @class */ (function () {
        /* tslint:disable-next-line:no-any */
        function NzScrollService(doc) {
            this.doc = doc;
        }
        /** 设置 `el` 滚动条位置 */
        /**
         * 设置 `el` 滚动条位置
         * @param {?} el
         * @param {?=} topValue
         * @return {?}
         */
        NzScrollService.prototype.setScrollTop = /**
         * 设置 `el` 滚动条位置
         * @param {?} el
         * @param {?=} topValue
         * @return {?}
         */
            function (el, topValue) {
                if (topValue === void 0) {
                    topValue = 0;
                }
                if (el === window) {
                    this.doc.body.scrollTop = topValue;
                    this.doc.documentElement.scrollTop = topValue;
                }
                else {
                    ( /** @type {?} */(el)).scrollTop = topValue;
                }
            };
        /** 获取 `el` 相对于视窗距离 */
        /**
         * 获取 `el` 相对于视窗距离
         * @param {?} el
         * @return {?}
         */
        NzScrollService.prototype.getOffset = /**
         * 获取 `el` 相对于视窗距离
         * @param {?} el
         * @return {?}
         */
            function (el) {
                /** @type {?} */
                var ret = {
                    top: 0,
                    left: 0
                };
                if (!el || !el.getClientRects().length)
                    return ret;
                /** @type {?} */
                var rect = el.getBoundingClientRect();
                if (rect.width || rect.height) {
                    /** @type {?} */
                    var doc = el.ownerDocument.documentElement;
                    ret.top = rect.top - doc.clientTop;
                    ret.left = rect.left - doc.clientLeft;
                }
                else {
                    ret.top = rect.top;
                    ret.left = rect.left;
                }
                return ret;
            };
        /** 获取 `el` 滚动条位置 */
        // TODO: remove '| Window' as the fallback already happens here
        /**
         * 获取 `el` 滚动条位置
         * @param {?=} el
         * @param {?=} top
         * @return {?}
         */
        NzScrollService.prototype.getScroll = /**
         * 获取 `el` 滚动条位置
         * @param {?=} el
         * @param {?=} top
         * @return {?}
         */
            function (el, top) {
                if (top === void 0) {
                    top = true;
                }
                /** @type {?} */
                var target = el ? el : window;
                /** @type {?} */
                var prop = top ? 'pageYOffset' : 'pageXOffset';
                /** @type {?} */
                var method = top ? 'scrollTop' : 'scrollLeft';
                /** @type {?} */
                var isWindow = target === window;
                /** @type {?} */
                var ret = isWindow ? target[prop] : target[method];
                if (isWindow && typeof ret !== 'number') {
                    ret = this.doc.documentElement[method];
                }
                return ret;
            };
        /**
         * 使用动画形式将 `el` 滚动至某位置
         *
         * @param containerEl 容器，默认 `window`
         * @param targetTopValue 滚动至目标 `top` 值，默认：0，相当于顶部
         * @param easing 动作算法，默认：`easeInOutCubic`
         * @param callback 动画结束后回调
         */
        /**
         * 使用动画形式将 `el` 滚动至某位置
         *
         * @param {?} containerEl 容器，默认 `window`
         * @param {?=} targetTopValue 滚动至目标 `top` 值，默认：0，相当于顶部
         * @param {?=} easing 动作算法，默认：`easeInOutCubic`
         * @param {?=} callback 动画结束后回调
         * @return {?}
         */
        NzScrollService.prototype.scrollTo = /**
         * 使用动画形式将 `el` 滚动至某位置
         *
         * @param {?} containerEl 容器，默认 `window`
         * @param {?=} targetTopValue 滚动至目标 `top` 值，默认：0，相当于顶部
         * @param {?=} easing 动作算法，默认：`easeInOutCubic`
         * @param {?=} callback 动画结束后回调
         * @return {?}
         */
            function (containerEl, targetTopValue, easing, callback) {
                var _this = this;
                if (targetTopValue === void 0) {
                    targetTopValue = 0;
                }
                /** @type {?} */
                var target = containerEl ? containerEl : window;
                /** @type {?} */
                var scrollTop = this.getScroll(target);
                /** @type {?} */
                var startTime = Date.now();
                /** @type {?} */
                var frameFunc = function () {
                    /** @type {?} */
                    var timestamp = Date.now();
                    /** @type {?} */
                    var time = timestamp - startTime;
                    _this.setScrollTop(target, (easing || easeInOutCubic)(time, scrollTop, targetTopValue, 450));
                    if (time < 450) {
                        reqAnimFrame(frameFunc);
                    }
                    else {
                        if (callback)
                            callback();
                    }
                };
                reqAnimFrame(frameFunc);
            };
        NzScrollService.decorators = [
            { type: i0.Injectable }
        ];
        /** @nocollapse */
        NzScrollService.ctorParameters = function () {
            return [
                { type: undefined, decorators: [{ type: i0.Inject, args: [i1.DOCUMENT,] }] }
            ];
        };
        return NzScrollService;
    }());
    /**
     * @param {?} doc
     * @param {?} scrollService
     * @return {?}
     */
    function SCROLL_SERVICE_PROVIDER_FACTORY(doc, scrollService) {
        return scrollService || new NzScrollService(doc);
    }
    /** @type {?} */
    var SCROLL_SERVICE_PROVIDER = {
        provide: NzScrollService,
        useFactory: SCROLL_SERVICE_PROVIDER_FACTORY,
        deps: [i1.DOCUMENT, [new i0.Optional(), new i0.SkipSelf(), NzScrollService]]
    };

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
    /* global Reflect, Promise */
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b)
                if (b.hasOwnProperty(p))
                    d[p] = b[p]; };
        return extendStatics(d, b);
    };
    function __extends(d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }
    var __assign = function () {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    function __decorate(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }
    function __metadata(metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(metadataKey, metadataValue);
    }
    function __values(o) {
        var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
        if (m)
            return m.call(o);
        return {
            next: function () {
                if (o && i >= o.length)
                    o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
    }
    function __read(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    }
    function __spread() {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * @param {?} value
     * @return {?}
     */
    function isNotNil(value) {
        return (typeof (value) !== 'undefined') && value !== null;
    }
    /**
     * 校验对象是否相等
     * @param {?} objA
     * @param {?} objB
     * @return {?}
     */
    function shallowEqual(objA, objB) {
        if (objA === objB)
            return true;
        if (typeof objA !== 'object' || !objA || typeof objB !== 'object' || !objB)
            return false;
        /** @type {?} */
        var keysA = Object.keys(objA);
        /** @type {?} */
        var keysB = Object.keys(objB);
        if (keysA.length !== keysB.length)
            return false;
        /** @type {?} */
        var bHasOwnProperty = Object.prototype.hasOwnProperty.bind(objB);
        // tslint:disable-next-line:prefer-for-of
        for (var idx = 0; idx < keysA.length; idx++) {
            /** @type {?} */
            var key = keysA[idx];
            if (!bHasOwnProperty(key))
                return false;
            if (objA[key] !== objB[key])
                return false;
        }
        return true;
    }
    /**
     * @param {?} value
     * @return {?}
     */
    function isInteger(value) {
        return typeof value === 'number' &&
            isFinite(value) &&
            Math.floor(value) === value;
    }
    /**
     * @param {?} element
     * @return {?}
     */
    function isEmpty(element) {
        /** @type {?} */
        var nodes = element.childNodes;
        for (var i = 0; i < nodes.length; i++) {
            /** @type {?} */
            var node = nodes.item(i);
            if ((node.nodeType === 1) && (( /** @type {?} */(node)).outerHTML.toString().trim().length !== 0)) {
                return false;
            }
            else if ((node.nodeType === 3) && ((node.textContent.toString().trim().length !== 0))) {
                return false;
            }
        }
        return true;
    }
    /**
     * @param {?} value
     * @return {?}
     */
    function isNonEmptyString(value) {
        // tslint:disable-line:no-any
        return typeof value === 'string' && value !== '';
    }
    /**
     * @param {?} value
     * @return {?}
     */
    function isTemplateRef(value) {
        // tslint:disable-line:no-any
        return value instanceof i0.TemplateRef;
    }
    /**
     * @param {?} value
     * @return {?}
     */
    function isComponent(value) {
        // tslint:disable-line:no-any
        return value instanceof i0.Type;
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * @param {?} value
     * @return {?}
     */
    function toBoolean(value) {
        return coercion.coerceBooleanProperty(value);
    }
    /**
     * @template D
     * @param {?} value
     * @param {?} fallback
     * @return {?}
     */
    function toNumber(value, fallback) {
        return coercion.coerceNumberProperty(value, fallback);
    }
    /**
     * @param {?} value
     * @return {?}
     */
    function toCssPixel(value) {
        return coercion.coerceCssPixelValue(value);
    }
    /**
     * @template T
     * @param {?} prop
     * @param {...?} args
     * @return {?}
     */
    function valueFunctionProp(prop) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        // tslint:disable-line: no-any
        return typeof prop === 'function' ? prop.apply(void 0, __spread(args)) : prop;
    }
    /**
     * Input decorator that handle a prop to do get/set automatically with toBoolean
     *
     * Why not using \@InputBoolean alone without \@Input? AOT needs \@Input to be visible
     *
     * \@howToUse
     * ```
     * \@Input() \@InputBoolean() visible: boolean = false;
     *
     * // Act as below:
     * // \@Input()
     * // get visible() { return this.__visibile; }
     * // set visible(value) { this.__visible = value; }
     * // __visible = false;
     * ```
     * @return {?}
     */
    function InputBoolean() {
        // tslint:disable-line:no-any
        return function InputBooleanPropDecorator(target, name) {
            /** @type {?} */
            var privatePropName = "$$__" + name;
            if (Object.prototype.hasOwnProperty.call(target, privatePropName)) {
                console.warn("The prop \"" + privatePropName + "\" is already exist, it will be overrided by InputBoolean decorator.");
            }
            Object.defineProperty(target, privatePropName, {
                configurable: true,
                writable: true
            });
            Object.defineProperty(target, name, {
                get: /**
                 * @return {?}
                 */ function () {
                    return this[privatePropName]; // tslint:disable-line:no-invalid-this
                },
                set: /**
                 * @param {?} value
                 * @return {?}
                 */ function (value) {
                    this[privatePropName] = toBoolean(value); // tslint:disable-line:no-invalid-this
                }
            });
            // // Do rest things for input decorator
            // const inputDecorator = Input();
            // inputDecorator(target, name);
        };
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * @param {?} fn
     * @return {?}
     */
    function throttleByAnimationFrame(fn) {
        /** @type {?} */
        var requestId;
        /** @type {?} */
        var later = function (args) {
            return function () {
                requestId = null;
                fn.apply(void 0, __spread(args));
            };
        };
        /** @type {?} */
        var throttled = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            if (requestId == null) {
                requestId = reqAnimFrame(later(args));
            }
        };
        // tslint:disable-next-line:no-non-null-assertion
        ( /** @type {?} */(throttled)).cancel = function () { return cancelRequestAnimationFrame(/** @type {?} */ ((requestId))); };
        return throttled;
    }
    /**
     * @return {?}
     */
    function throttleByAnimationFrameDecorator() {
        return function (target, key, descriptor) {
            /** @type {?} */
            var fn = descriptor.value;
            /** @type {?} */
            var definingProperty = false;
            return {
                configurable: true,
                get: /**
                 * @return {?}
                 */ function () {
                    if (definingProperty || this === target.prototype || this.hasOwnProperty(key)) {
                        return fn;
                    }
                    /** @type {?} */
                    var boundFn = throttleByAnimationFrame(fn.bind(this));
                    definingProperty = true;
                    Object.defineProperty(this, key, {
                        value: boundFn,
                        configurable: true,
                        writable: true,
                    });
                    definingProperty = false;
                    return boundFn;
                },
            };
        };
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzAffixComponent = /** @class */ (function () {
        function NzAffixComponent(scrollSrv, _el, cd) {
            this.scrollSrv = scrollSrv;
            this._el = _el;
            this.cd = cd;
            this.events = [
                'resize',
                'scroll',
                'touchstart',
                'touchmove',
                'touchend',
                'pageshow',
                'load'
            ];
            this._target = window;
            this.nzChange = new i0.EventEmitter();
        }
        Object.defineProperty(NzAffixComponent.prototype, "nzTarget", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.clearEventListeners();
                this._target = value || window;
                this.setTargetEventListeners();
                this.updatePosition({});
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzAffixComponent.prototype, "nzOffsetTop", {
            get: /**
             * @return {?}
             */ function () {
                return this._offsetTop;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (typeof value === 'undefined') {
                    return;
                }
                this._offsetTop = toNumber(value, null);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzAffixComponent.prototype, "nzOffsetBottom", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (typeof value === 'undefined') {
                    return;
                }
                this._offsetBottom = toNumber(value, null);
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzAffixComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.timeout = setTimeout(function () {
                    _this.setTargetEventListeners();
                    _this.updatePosition({});
                });
            };
        /**
         * @return {?}
         */
        NzAffixComponent.prototype.setTargetEventListeners = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.clearEventListeners();
                this.events.forEach(function (eventName) {
                    _this._target.addEventListener(eventName, _this.updatePosition, false);
                });
            };
        /**
         * @return {?}
         */
        NzAffixComponent.prototype.clearEventListeners = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.events.forEach(function (eventName) {
                    _this._target.removeEventListener(eventName, _this.updatePosition, false);
                });
            };
        /**
         * @return {?}
         */
        NzAffixComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.clearEventListeners();
                clearTimeout(this.timeout);
                ( /** @type {?} */(this.updatePosition)).cancel();
            };
        /**
         * @param {?} target
         * @return {?}
         */
        NzAffixComponent.prototype.getTargetRect = /**
         * @param {?} target
         * @return {?}
         */
            function (target) {
                return target !== window ?
                    ( /** @type {?} */(target)).getBoundingClientRect() : /** @type {?} */ ({ top: 0, left: 0, bottom: 0 });
            };
        /**
         * @param {?} element
         * @param {?} target
         * @return {?}
         */
        NzAffixComponent.prototype.getOffset = /**
         * @param {?} element
         * @param {?} target
         * @return {?}
         */
            function (element, target) {
                /** @type {?} */
                var elemRect = element.getBoundingClientRect();
                /** @type {?} */
                var targetRect = this.getTargetRect(target);
                /** @type {?} */
                var scrollTop = this.scrollSrv.getScroll(target, true);
                /** @type {?} */
                var scrollLeft = this.scrollSrv.getScroll(target, false);
                /** @type {?} */
                var docElem = window.document.body;
                /** @type {?} */
                var clientTop = docElem.clientTop || 0;
                /** @type {?} */
                var clientLeft = docElem.clientLeft || 0;
                return {
                    top: elemRect.top - targetRect.top + scrollTop - clientTop,
                    left: elemRect.left - targetRect.left + scrollLeft - clientLeft,
                    width: elemRect.width,
                    height: elemRect.height
                };
            };
        /**
         * @param {?} affixStyle
         * @return {?}
         */
        NzAffixComponent.prototype.genStyle = /**
         * @param {?} affixStyle
         * @return {?}
         */
            function (affixStyle) {
                if (affixStyle == null) {
                    return '';
                }
                return Object.keys(affixStyle).map(function (key) {
                    /** @type {?} */
                    var val = affixStyle[key];
                    return key + ":" + (typeof val === 'string' ? val : val + 'px');
                }).join(';');
            };
        /**
         * @param {?} e
         * @param {?} affixStyle
         * @return {?}
         */
        NzAffixComponent.prototype.setAffixStyle = /**
         * @param {?} e
         * @param {?} affixStyle
         * @return {?}
         */
            function (e, affixStyle) {
                /** @type {?} */
                var originalAffixStyle = this.affixStyle;
                /** @type {?} */
                var isWindow = this._target === window;
                if (e.type === 'scroll' && originalAffixStyle && affixStyle && isWindow) {
                    return;
                }
                if (shallowEqual(originalAffixStyle, affixStyle)) {
                    return;
                }
                /** @type {?} */
                var fixed = !!affixStyle;
                /** @type {?} */
                var wrapEl = /** @type {?} */ (this.wrap.nativeElement);
                wrapEl.style.cssText = this.genStyle(affixStyle);
                this.affixStyle = affixStyle;
                /** @type {?} */
                var cls = 'ant-affix';
                if (fixed) {
                    wrapEl.classList.add(cls);
                }
                else {
                    wrapEl.classList.remove(cls);
                }
                if ((affixStyle && !originalAffixStyle) || (!affixStyle && originalAffixStyle)) {
                    this.nzChange.emit(fixed);
                }
            };
        /**
         * @param {?} placeholderStyle
         * @return {?}
         */
        NzAffixComponent.prototype.setPlaceholderStyle = /**
         * @param {?} placeholderStyle
         * @return {?}
         */
            function (placeholderStyle) {
                /** @type {?} */
                var originalPlaceholderStyle = this.placeholderStyle;
                if (shallowEqual(placeholderStyle, originalPlaceholderStyle)) {
                    return;
                }
                ( /** @type {?} */(this._el.nativeElement)).style.cssText = this.genStyle(placeholderStyle);
                this.placeholderStyle = placeholderStyle;
            };
        /**
         * @param {?} e
         * @return {?}
         */
        NzAffixComponent.prototype.updatePosition = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                /** @type {?} */
                var targetNode = this._target;
                /** @type {?} */
                var offsetTop = this.nzOffsetTop;
                /** @type {?} */
                var scrollTop = this.scrollSrv.getScroll(targetNode, true);
                /** @type {?} */
                var affixNode = /** @type {?} */ (this._el.nativeElement);
                /** @type {?} */
                var elemOffset = this.getOffset(affixNode, targetNode);
                /** @type {?} */
                var elemSize = {
                    width: affixNode.offsetWidth,
                    height: affixNode.offsetHeight
                };
                /** @type {?} */
                var offsetMode = {
                    top: false,
                    bottom: false
                };
                // Default to `offsetTop=0`.
                if (typeof offsetTop !== 'number' && typeof this._offsetBottom !== 'number') {
                    offsetMode.top = true;
                    offsetTop = 0;
                }
                else {
                    offsetMode.top = typeof offsetTop === 'number';
                    offsetMode.bottom = typeof this._offsetBottom === 'number';
                }
                /** @type {?} */
                var targetRect = this.getTargetRect(targetNode);
                /** @type {?} */
                var targetInnerHeight = ( /** @type {?} */(targetNode)).innerHeight || ( /** @type {?} */(targetNode)).clientHeight;
                if (scrollTop > elemOffset.top - ( /** @type {?} */(offsetTop)) && offsetMode.top) {
                    /** @type {?} */
                    var width = elemOffset.width;
                    /** @type {?} */
                    var top_1 = targetRect.top + ( /** @type {?} */(offsetTop));
                    this.setAffixStyle(e, {
                        position: 'fixed',
                        top: top_1,
                        left: targetRect.left + elemOffset.left,
                        maxHeight: "calc(100vh - " + top_1 + "px)",
                        width: width
                    });
                    this.setPlaceholderStyle({
                        width: width,
                        height: elemSize.height
                    });
                }
                else if (scrollTop < elemOffset.top + elemSize.height + ( /** @type {?} */(this._offsetBottom)) - targetInnerHeight &&
                    offsetMode.bottom) {
                    /** @type {?} */
                    var targetBottomOffet = targetNode === window ? 0 : (window.innerHeight - targetRect.bottom);
                    /** @type {?} */
                    var width = elemOffset.width;
                    this.setAffixStyle(e, {
                        position: 'fixed',
                        bottom: targetBottomOffet + ( /** @type {?} */(this._offsetBottom)),
                        left: targetRect.left + elemOffset.left,
                        width: width
                    });
                    this.setPlaceholderStyle({
                        width: width,
                        height: elemOffset.height
                    });
                }
                else {
                    if (e.type === 'resize' && this.affixStyle && this.affixStyle.position === 'fixed' && affixNode.offsetWidth) {
                        this.setAffixStyle(e, __assign({}, this.affixStyle, { width: affixNode.offsetWidth }));
                    }
                    else {
                        this.setAffixStyle(e, null);
                    }
                    this.setPlaceholderStyle(null);
                }
            };
        NzAffixComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-affix',
                        template: "<div #wrap>\n  <ng-content></ng-content>\n</div>",
                        changeDetection: i0.ChangeDetectionStrategy.OnPush,
                        styles: [":host {\n      display: block;\n    }"]
                    }] }
        ];
        /** @nocollapse */
        NzAffixComponent.ctorParameters = function () {
            return [
                { type: NzScrollService },
                { type: i0.ElementRef },
                { type: i0.ChangeDetectorRef }
            ];
        };
        NzAffixComponent.propDecorators = {
            wrap: [{ type: i0.ViewChild, args: ['wrap',] }],
            nzTarget: [{ type: i0.Input }],
            nzOffsetTop: [{ type: i0.Input }],
            nzOffsetBottom: [{ type: i0.Input }],
            nzChange: [{ type: i0.Output }]
        };
        __decorate([
            throttleByAnimationFrameDecorator(),
            __metadata("design:type", Function),
            __metadata("design:paramtypes", [Object]),
            __metadata("design:returntype", void 0)
        ], NzAffixComponent.prototype, "updatePosition", null);
        return NzAffixComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzAffixModule = /** @class */ (function () {
        function NzAffixModule() {
        }
        NzAffixModule.decorators = [
            { type: i0.NgModule, args: [{
                        declarations: [NzAffixComponent],
                        exports: [NzAffixComponent],
                        imports: [i1.CommonModule],
                        providers: [SCROLL_SERVICE_PROVIDER]
                    },] }
        ];
        return NzAffixModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var fadeAnimation = animations.trigger('fadeAnimation', [
        animations.state('void', animations.style({ opacity: 0 })),
        animations.state('true', animations.style({ opacity: 1 })),
        animations.state('false', animations.style({ opacity: 0 })),
        animations.transition('* => true', animations.animate('150ms cubic-bezier(0.0, 0.0, 0.2, 1)')),
        animations.transition('* => void', animations.animate('150ms cubic-bezier(0.4, 0.0, 1, 1)')),
    ]);

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzAlertComponent = /** @class */ (function () {
        function NzAlertComponent() {
            this._banner = false;
            this._closeable = false;
            this._showIcon = false;
            this._type = 'info';
            this.display = true;
            this.isTypeSet = false;
            this.isShowIconSet = false;
            this.prefixClass = 'ant-alert';
            this.nzOnClose = new i0.EventEmitter();
        }
        Object.defineProperty(NzAlertComponent.prototype, "nzDescription", {
            get: /**
             * @return {?}
             */ function () {
                return this._description;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.isDescriptionString = !(value instanceof i0.TemplateRef);
                this._description = value;
                this.updateOuterClassMap();
                this.updateIconClassMap();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzAlertComponent.prototype, "nzCloseText", {
            get: /**
             * @return {?}
             */ function () {
                return this._closeText;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.isCloseTextString = !(value instanceof i0.TemplateRef);
                this._closeText = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzAlertComponent.prototype, "nzMessage", {
            get: /**
             * @return {?}
             */ function () {
                return this._message;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.isMessageString = !(value instanceof i0.TemplateRef);
                this._message = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzAlertComponent.prototype, "nzType", {
            get: /**
             * @return {?}
             */ function () {
                return this._type;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._type = value;
                this.isTypeSet = true;
                this.updateOuterClassMap();
                this.updateIconClassMap();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzAlertComponent.prototype, "nzBanner", {
            get: /**
             * @return {?}
             */ function () {
                return this._banner;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._banner = toBoolean(value);
                if (!this.isTypeSet) {
                    this.nzType = 'warning';
                }
                if (!this.isShowIconSet) {
                    this.nzShowIcon = true;
                }
                this.updateOuterClassMap();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzAlertComponent.prototype, "nzCloseable", {
            get: /**
             * @return {?}
             */ function () {
                return this._closeable;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._closeable = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzAlertComponent.prototype, "nzShowIcon", {
            get: /**
             * @return {?}
             */ function () {
                return this._showIcon;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._showIcon = toBoolean(value);
                this.isShowIconSet = true;
                this.updateOuterClassMap();
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzAlertComponent.prototype.closeAlert = /**
         * @return {?}
         */
            function () {
                this.display = false;
            };
        /**
         * @return {?}
         */
        NzAlertComponent.prototype.onFadeAnimationDone = /**
         * @return {?}
         */
            function () {
                if (!this.display) {
                    this.nzOnClose.emit(true);
                }
            };
        /**
         * @return {?}
         */
        NzAlertComponent.prototype.updateOuterClassMap = /**
         * @return {?}
         */
            function () {
                var _a;
                this.outerClassMap = (_a = {},
                    _a["" + this.prefixClass] = true,
                    _a[this.prefixClass + "-" + this.nzType] = true,
                    _a[this.prefixClass + "-no-icon"] = !this.nzShowIcon,
                    _a[this.prefixClass + "-banner"] = this.nzBanner,
                    _a[this.prefixClass + "-with-description"] = !!this.nzDescription,
                    _a);
            };
        /**
         * @return {?}
         */
        NzAlertComponent.prototype.updateIconClassMap = /**
         * @return {?}
         */
            function () {
                this.iconClassMap = {
                    'anticon-cross-circle-o': this.nzDescription && this.nzType === 'error',
                    'anticon-check-circle-o': this.nzDescription && this.nzType === 'success',
                    'anticon-info-circle-o': this.nzDescription && this.nzType === 'info',
                    'anticon-exclamation-circle-o': this.nzDescription && this.nzType === 'warning',
                    'anticon-cross-circle': (!this.nzDescription) && this.nzType === 'error',
                    'anticon-check-circle': (!this.nzDescription) && this.nzType === 'success',
                    'anticon-info-circle': (!this.nzDescription) && this.nzType === 'info',
                    'anticon-exclamation-circle': (!this.nzDescription) && this.nzType === 'warning'
                };
            };
        /**
         * @return {?}
         */
        NzAlertComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.updateIconClassMap();
                this.updateOuterClassMap();
            };
        NzAlertComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-alert',
                        animations: [fadeAnimation],
                        preserveWhitespaces: false,
                        template: "<div [ngClass]=\"outerClassMap\" *ngIf=\"display\" [@fadeAnimation] (@fadeAnimation.done)=\"onFadeAnimationDone()\">\n  <ng-container *ngIf=\"nzShowIcon\">\n    <i class=\"ant-alert-icon\" [ngClass]=\"nzIconType\" *ngIf=\"nzIconType; else iconTemplate\"></i>\n    <ng-template #iconTemplate>\n      <i class=\"ant-alert-icon anticon\" [ngClass]=\"iconClassMap\">\n      </i>\n    </ng-template>\n  </ng-container>\n  <span class=\"ant-alert-message\" *ngIf=\"nzMessage\">\n        <ng-container *ngIf=\"isMessageString; else messageTemplate\">{{ nzMessage }}</ng-container>\n        <ng-template #messageTemplate>\n          <ng-template [ngTemplateOutlet]=\"nzMessage\"></ng-template>\n        </ng-template>\n      </span>\n  <span class=\"ant-alert-description\" *ngIf=\"nzDescription\">\n        <ng-container *ngIf=\"isDescriptionString; else descriptionTemplate\">{{ nzDescription }}</ng-container>\n        <ng-template #descriptionTemplate>\n          <ng-template [ngTemplateOutlet]=\"nzDescription\"></ng-template>\n        </ng-template>\n      </span>\n  <a\n    *ngIf=\"nzCloseable || nzCloseText\"\n    (click)=\"closeAlert()\"\n    class=\"ant-alert-close-icon\">\n    <ng-template #closeDefaultTemplate>\n      <i class=\"anticon anticon-cross\"></i>\n    </ng-template>\n    <ng-container *ngIf=\"nzCloseText; else closeDefaultTemplate\">\n      <ng-container *ngIf=\"isCloseTextString; else closeTextTemplate\">{{ nzCloseText }}</ng-container>\n      <ng-template #closeTextTemplate>\n        <ng-template [ngTemplateOutlet]=\"nzCloseText\"></ng-template>\n      </ng-template>\n    </ng-container>\n  </a>\n</div>",
                        styles: [":host {\n      display: block;\n    }"]
                    }] }
        ];
        NzAlertComponent.propDecorators = {
            nzOnClose: [{ type: i0.Output }],
            nzIconType: [{ type: i0.Input }],
            nzDescription: [{ type: i0.Input }],
            nzCloseText: [{ type: i0.Input }],
            nzMessage: [{ type: i0.Input }],
            nzType: [{ type: i0.Input }],
            nzBanner: [{ type: i0.Input }],
            nzCloseable: [{ type: i0.Input }],
            nzShowIcon: [{ type: i0.Input }]
        };
        return NzAlertComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzAlertModule = /** @class */ (function () {
        function NzAlertModule() {
        }
        NzAlertModule.decorators = [
            { type: i0.NgModule, args: [{
                        declarations: [NzAlertComponent],
                        exports: [NzAlertComponent],
                        imports: [i1.CommonModule]
                    },] }
        ];
        return NzAlertModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var sharpMatcherRegx = /#([^#]+)$/;
    var NzAnchorComponent = /** @class */ (function () {
        // endregion
        /* tslint:disable-next-line:no-any */
        function NzAnchorComponent(scrollSrv, doc, cd) {
            this.scrollSrv = scrollSrv;
            this.doc = doc;
            this.cd = cd;
            this.links = [];
            this.animating = false;
            this.target = null;
            this.scroll$ = null;
            this.visible = false;
            this.wrapperStyle = { 'max-height': '100vh' };
            this._affix = true;
            this._bounds = 5;
            this._showInkInFixed = false;
            this.nzClick = new i0.EventEmitter();
            this.nzScroll = new i0.EventEmitter();
        }
        Object.defineProperty(NzAnchorComponent.prototype, "nzAffix", {
            get: /**
             * @return {?}
             */ function () {
                return this._affix;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._affix = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzAnchorComponent.prototype, "nzBounds", {
            get: /**
             * @return {?}
             */ function () {
                return this._bounds;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._bounds = toNumber(value, 5);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzAnchorComponent.prototype, "nzOffsetTop", {
            get: /**
             * @return {?}
             */ function () {
                return this._offsetTop;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._offsetTop = toNumber(value, 0);
                this.wrapperStyle = {
                    'max-height': "calc(100vh - " + this._offsetTop + "px)"
                };
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzAnchorComponent.prototype, "nzShowInkInFixed", {
            get: /**
             * @return {?}
             */ function () {
                return this._showInkInFixed;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._showInkInFixed = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzAnchorComponent.prototype, "nzTarget", {
            set: /**
             * @param {?} el
             * @return {?}
             */ function (el) {
                this.target = el;
                this.registerScrollEvent();
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} link
         * @return {?}
         */
        NzAnchorComponent.prototype.registerLink = /**
         * @param {?} link
         * @return {?}
         */
            function (link) {
                this.links.push(link);
            };
        /**
         * @param {?} link
         * @return {?}
         */
        NzAnchorComponent.prototype.unregisterLink = /**
         * @param {?} link
         * @return {?}
         */
            function (link) {
                this.links.splice(this.links.indexOf(link), 1);
            };
        /**
         * @return {?}
         */
        NzAnchorComponent.prototype.getTarget = /**
         * @return {?}
         */
            function () {
                return this.target || window;
            };
        /**
         * @return {?}
         */
        NzAnchorComponent.prototype.ngAfterViewInit = /**
         * @return {?}
         */
            function () {
                this.registerScrollEvent();
            };
        /**
         * @return {?}
         */
        NzAnchorComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.removeListen();
            };
        /**
         * @return {?}
         */
        NzAnchorComponent.prototype.registerScrollEvent = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.removeListen();
                this.scroll$ = rxjs.fromEvent(this.getTarget(), 'scroll').pipe(operators.throttleTime(50), operators.distinctUntilChanged())
                    .subscribe(function (e) { return _this.handleScroll(); });
                // 由于页面刷新时滚动条位置的记忆
                // 倒置在dom未渲染完成，导致计算不正确
                setTimeout(function () { return _this.handleScroll(); });
            };
        /**
         * @return {?}
         */
        NzAnchorComponent.prototype.removeListen = /**
         * @return {?}
         */
            function () {
                if (this.scroll$) {
                    this.scroll$.unsubscribe();
                }
            };
        /**
         * @param {?} element
         * @return {?}
         */
        NzAnchorComponent.prototype.getOffsetTop = /**
         * @param {?} element
         * @return {?}
         */
            function (element) {
                if (!element || !element.getClientRects().length) {
                    return 0;
                }
                /** @type {?} */
                var rect = element.getBoundingClientRect();
                if (!rect.width && !rect.height) {
                    return rect.top;
                }
                return rect.top - element.ownerDocument.documentElement.clientTop;
            };
        /**
         * @return {?}
         */
        NzAnchorComponent.prototype.handleScroll = /**
         * @return {?}
         */
            function () {
                var _this = this;
                if (this.animating) {
                    return;
                }
                /** @type {?} */
                var sections = [];
                /** @type {?} */
                var scope = (this.nzOffsetTop || 0) + this.nzBounds;
                this.links.forEach(function (comp) {
                    /** @type {?} */
                    var sharpLinkMatch = sharpMatcherRegx.exec(comp.nzHref.toString());
                    if (!sharpLinkMatch) {
                        return;
                    }
                    /** @type {?} */
                    var target = _this.doc.getElementById(sharpLinkMatch[1]);
                    if (target && _this.getOffsetTop(target) < scope) {
                        /** @type {?} */
                        var top_1 = _this.getOffsetTop(target);
                        sections.push({
                            top: top_1,
                            comp: comp
                        });
                    }
                });
                this.visible = !!sections.length;
                if (!this.visible) {
                    this.clearActive();
                    this.cd.detectChanges();
                }
                else {
                    /** @type {?} */
                    var maxSection = sections.reduce(function (prev, curr) { return curr.top > prev.top ? curr : prev; });
                    this.handleActive(maxSection.comp);
                }
            };
        /**
         * @return {?}
         */
        NzAnchorComponent.prototype.clearActive = /**
         * @return {?}
         */
            function () {
                this.links.forEach(function (i) { return i.active = false; });
            };
        /**
         * @param {?} comp
         * @return {?}
         */
        NzAnchorComponent.prototype.handleActive = /**
         * @param {?} comp
         * @return {?}
         */
            function (comp) {
                this.clearActive();
                comp.active = true;
                this.cd.detectChanges();
                /** @type {?} */
                var linkNode = /** @type {?} */ (( /** @type {?} */(comp.el.nativeElement)).querySelector('.ant-anchor-link-title'));
                this.ink.nativeElement.style.top = linkNode.offsetTop + linkNode.clientHeight / 2 - 4.5 + "px";
                this.nzScroll.emit(comp);
            };
        /**
         * @param {?} linkComp
         * @return {?}
         */
        NzAnchorComponent.prototype.handleScrollTo = /**
         * @param {?} linkComp
         * @return {?}
         */
            function (linkComp) {
                var _this = this;
                /** @type {?} */
                var el = this.doc.querySelector(linkComp.nzHref);
                if (!el) {
                    return;
                }
                this.animating = true;
                /** @type {?} */
                var containerScrollTop = this.scrollSrv.getScroll(this.getTarget());
                /** @type {?} */
                var elOffsetTop = this.scrollSrv.getOffset(el).top;
                /** @type {?} */
                var targetScrollTop = containerScrollTop + elOffsetTop - (this.nzOffsetTop || 0);
                this.scrollSrv.scrollTo(this.getTarget(), targetScrollTop, null, function () {
                    _this.animating = false;
                    _this.handleActive(linkComp);
                });
                this.nzClick.emit(linkComp.nzHref);
            };
        NzAnchorComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-anchor',
                        preserveWhitespaces: false,
                        template: "<nz-affix *ngIf=\"nzAffix;else content\" [nzOffsetTop]=\"nzOffsetTop\">\n  <ng-template [ngTemplateOutlet]=\"content\"></ng-template>\n</nz-affix>\n<ng-template #content>\n  <div class=\"ant-anchor-wrapper\" #wrap [ngStyle]=\"wrapperStyle\">\n    <div class=\"ant-anchor\" [ngClass]=\"{'fixed': !nzAffix && !nzShowInkInFixed}\">\n      <div class=\"ant-anchor-ink\">\n        <div class=\"ant-anchor-ink-ball\" [class.visible]=\"visible\" #ink></div>\n      </div>\n      <ng-content></ng-content>\n    </div>\n  </div>\n</ng-template>",
                        changeDetection: i0.ChangeDetectionStrategy.OnPush
                    }] }
        ];
        /** @nocollapse */
        NzAnchorComponent.ctorParameters = function () {
            return [
                { type: NzScrollService },
                { type: undefined, decorators: [{ type: i0.Inject, args: [i1.DOCUMENT,] }] },
                { type: i0.ChangeDetectorRef }
            ];
        };
        NzAnchorComponent.propDecorators = {
            wrap: [{ type: i0.ViewChild, args: ['wrap',] }],
            ink: [{ type: i0.ViewChild, args: ['ink',] }],
            nzAffix: [{ type: i0.Input }],
            nzBounds: [{ type: i0.Input }],
            nzOffsetTop: [{ type: i0.Input }],
            nzShowInkInFixed: [{ type: i0.Input }],
            nzTarget: [{ type: i0.Input }],
            nzClick: [{ type: i0.Output }],
            nzScroll: [{ type: i0.Output }]
        };
        return NzAnchorComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzAnchorLinkComponent = /** @class */ (function () {
        function NzAnchorLinkComponent(el, anchorComp) {
            this.el = el;
            this.anchorComp = anchorComp;
            this.nzHref = '#';
            this.titleStr = '';
            this.active = false;
        }
        Object.defineProperty(NzAnchorLinkComponent.prototype, "nzTitle", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value instanceof i0.TemplateRef) {
                    this.titleTpl = value;
                }
                else {
                    this.titleStr = value;
                }
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzAnchorLinkComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.anchorComp.registerLink(this);
            };
        /**
         * @param {?} e
         * @return {?}
         */
        NzAnchorLinkComponent.prototype.goToClick = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                e.preventDefault();
                e.stopPropagation();
                this.anchorComp.handleScrollTo(this);
            };
        /**
         * @return {?}
         */
        NzAnchorLinkComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.anchorComp.unregisterLink(this);
            };
        NzAnchorLinkComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-link',
                        preserveWhitespaces: false,
                        template: "<a (click)=\"goToClick($event)\" href=\"{{nzHref}}\" class=\"ant-anchor-link-title\" title=\"{{titleStr}}\">\n  <span *ngIf=\"titleStr; else (titleTpl || nzTemplate)\">{{ titleStr }}</span>\n</a>\n<ng-content></ng-content>",
                        host: {
                            '[class.ant-anchor-link]': 'true',
                            'style': 'display:block'
                        }
                    }] }
        ];
        /** @nocollapse */
        NzAnchorLinkComponent.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: NzAnchorComponent }
            ];
        };
        NzAnchorLinkComponent.propDecorators = {
            nzHref: [{ type: i0.Input }],
            nzTitle: [{ type: i0.Input }],
            nzTemplate: [{ type: i0.ContentChild, args: ['nzTemplate',] }],
            active: [{ type: i0.HostBinding, args: ['class.ant-anchor-link-active',] }]
        };
        return NzAnchorLinkComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzAnchorModule = /** @class */ (function () {
        function NzAnchorModule() {
        }
        NzAnchorModule.decorators = [
            { type: i0.NgModule, args: [{
                        declarations: [NzAnchorComponent, NzAnchorLinkComponent],
                        exports: [NzAnchorComponent, NzAnchorLinkComponent],
                        imports: [i1.CommonModule, NzAffixModule],
                        providers: [SCROLL_SERVICE_PROVIDER]
                    },] }
        ];
        return NzAnchorModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzAutocompleteOptgroupComponent = /** @class */ (function () {
        function NzAutocompleteOptgroupComponent() {
        }
        Object.defineProperty(NzAutocompleteOptgroupComponent.prototype, "nzLabel", {
            get: /**
             * @return {?}
             */ function () {
                return this._label;
            },
            /** group 的 label，支持 'string' 和 `TemplateRef` */
            set: /**
             * group 的 label，支持 'string' 和 `TemplateRef`
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.isLabelString = !(value instanceof i0.TemplateRef);
                this._label = value;
            },
            enumerable: true,
            configurable: true
        });
        NzAutocompleteOptgroupComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-auto-optgroup',
                        preserveWhitespaces: false,
                        changeDetection: i0.ChangeDetectionStrategy.OnPush,
                        template: "<div class=\"ant-select-dropdown-menu-item-group-title\">\n  <ng-container *ngIf=\"isLabelString; else labelTemplate\">{{nzLabel}}</ng-container>\n  <ng-template #labelTemplate>\n    <ng-template [ngTemplateOutlet]=\"nzLabel\"></ng-template>\n  </ng-template>\n</div>\n<ul class=\"ant-select-dropdown-menu-item-group-list\">\n  <ng-content select=\"nz-auto-option\"></ng-content>\n</ul>\n",
                        host: {
                            'role': 'group',
                            'class': 'ant-select-dropdown-menu-item-group'
                        }
                    }] }
        ];
        /** @nocollapse */
        NzAutocompleteOptgroupComponent.ctorParameters = function () { return []; };
        NzAutocompleteOptgroupComponent.propDecorators = {
            nzLabel: [{ type: i0.Input }]
        };
        return NzAutocompleteOptgroupComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzOptionSelectionChange = /** @class */ (function () {
        function NzOptionSelectionChange(source, isUserInput) {
            if (isUserInput === void 0) {
                isUserInput = false;
            }
            this.source = source;
            this.isUserInput = isUserInput;
        }
        return NzOptionSelectionChange;
    }());
    var NzAutocompleteOptionComponent = /** @class */ (function () {
        function NzAutocompleteOptionComponent(changeDetectorRef, element) {
            this.changeDetectorRef = changeDetectorRef;
            this.element = element;
            this.disabled = false;
            this.active = false;
            this.selected = false;
            this.selectionChange = new i0.EventEmitter();
        }
        Object.defineProperty(NzAutocompleteOptionComponent.prototype, "nzDisabled", {
            get: /**
             * @return {?}
             */ function () {
                return this.disabled;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.disabled = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        /** 选择 */
        /**
         * 选择
         * @return {?}
         */
        NzAutocompleteOptionComponent.prototype.select = /**
         * 选择
         * @return {?}
         */
            function () {
                this.selected = true;
                this.changeDetectorRef.markForCheck();
                this.emitSelectionChangeEvent();
            };
        /** 取消选择 */
        /**
         * 取消选择
         * @return {?}
         */
        NzAutocompleteOptionComponent.prototype.deselect = /**
         * 取消选择
         * @return {?}
         */
            function () {
                this.selected = false;
                this.changeDetectorRef.markForCheck();
                this.emitSelectionChangeEvent();
            };
        /** 获取用于显示的 label */
        /**
         * 获取用于显示的 label
         * @return {?}
         */
        NzAutocompleteOptionComponent.prototype.getLabel = /**
         * 获取用于显示的 label
         * @return {?}
         */
            function () {
                return this.nzLabel || this.nzValue.toString();
            };
        /** 设置激活样式 (仅限样式) */
        /**
         * 设置激活样式 (仅限样式)
         * @return {?}
         */
        NzAutocompleteOptionComponent.prototype.setActiveStyles = /**
         * 设置激活样式 (仅限样式)
         * @return {?}
         */
            function () {
                if (!this.active) {
                    this.active = true;
                    this.changeDetectorRef.markForCheck();
                }
            };
        /** 设置非激活样式 (仅限样式) */
        /**
         * 设置非激活样式 (仅限样式)
         * @return {?}
         */
        NzAutocompleteOptionComponent.prototype.setInactiveStyles = /**
         * 设置非激活样式 (仅限样式)
         * @return {?}
         */
            function () {
                if (this.active) {
                    this.active = false;
                    this.changeDetectorRef.markForCheck();
                }
            };
        /**
         * @return {?}
         */
        NzAutocompleteOptionComponent.prototype.scrollIntoViewIfNeeded = /**
         * @return {?}
         */
            function () {
                var _this = this;
                /* tslint:disable-next-line:no-string-literal */
                if (this.element.nativeElement && this.element.nativeElement['scrollIntoViewIfNeeded']) {
                    /* tslint:disable-next-line:no-string-literal */
                    setTimeout(function () { return _this.element.nativeElement['scrollIntoViewIfNeeded'](false); }, 150);
                }
            };
        /**
         * @param {?=} isUserInput
         * @return {?}
         */
        NzAutocompleteOptionComponent.prototype.emitSelectionChangeEvent = /**
         * @param {?=} isUserInput
         * @return {?}
         */
            function (isUserInput) {
                if (isUserInput === void 0) {
                    isUserInput = false;
                }
                this.selectionChange.emit(new NzOptionSelectionChange(this, isUserInput));
            };
        /**
         * @return {?}
         */
        NzAutocompleteOptionComponent.prototype.selectViaInteraction = /**
         * @return {?}
         */
            function () {
                if (!this.disabled) {
                    this.selected = !this.selected;
                    if (this.selected) {
                        this.setActiveStyles();
                    }
                    else {
                        this.setInactiveStyles();
                    }
                    this.emitSelectionChangeEvent(true);
                    this.changeDetectorRef.markForCheck();
                }
            };
        NzAutocompleteOptionComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-auto-option',
                        preserveWhitespaces: false,
                        changeDetection: i0.ChangeDetectionStrategy.OnPush,
                        template: "<ng-content></ng-content>",
                        host: {
                            'role': 'menuitem',
                            'class': 'ant-select-dropdown-menu-item',
                            '[class.ant-select-dropdown-menu-item-selected]': 'selected',
                            '[class.ant-select-dropdown-menu-item-active]': 'active',
                            '[class.ant-select-dropdown-menu-item-disabled]': 'nzDisabled',
                            '[attr.aria-selected]': 'selected.toString()',
                            '[attr.aria-disabled]': 'nzDisabled.toString()',
                            '(click)': 'selectViaInteraction()'
                        }
                    }] }
        ];
        /** @nocollapse */
        NzAutocompleteOptionComponent.ctorParameters = function () {
            return [
                { type: i0.ChangeDetectorRef },
                { type: i0.ElementRef }
            ];
        };
        NzAutocompleteOptionComponent.propDecorators = {
            nzValue: [{ type: i0.Input }],
            nzLabel: [{ type: i0.Input }],
            nzDisabled: [{ type: i0.Input }],
            selectionChange: [{ type: i0.Output }]
        };
        return NzAutocompleteOptionComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var NZ_AUTOCOMPLETE_VALUE_ACCESSOR = {
        provide: forms.NG_VALUE_ACCESSOR,
        useExisting: i0.forwardRef(function () { return NzAutocompleteTriggerDirective; }),
        multi: true
    };
    /**
     * @return {?}
     */
    function getNzAutocompleteMissingPanelError() {
        return Error('Attempting to open an undefined instance of `nz-autocomplete`. ' +
            'Make sure that the id passed to the `nzAutocomplete` is correct and that ' +
            'you\'re attempting to open it after the ngAfterContentInit hook.');
    }
    var NzAutocompleteTriggerDirective = /** @class */ (function () {
        function NzAutocompleteTriggerDirective(_element, _overlay, _viewContainerRef, 
        // tslint:disable-next-line:no-any
        _document) {
            this._element = _element;
            this._overlay = _overlay;
            this._viewContainerRef = _viewContainerRef;
            this._document = _document;
            this._onChange = function () { };
            this._onTouched = function () { };
            this.panelOpen = false;
        }
        Object.defineProperty(NzAutocompleteTriggerDirective.prototype, "activeOption", {
            /**
             * 当前被激活的 Option
             */
            get: /**
             * 当前被激活的 Option
             * @return {?}
             */ function () {
                if (this.nzAutocomplete && this.nzAutocomplete.options.length) {
                    return this.nzAutocomplete.activeItem;
                }
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.openPanel = /**
         * @return {?}
         */
            function () {
                this.attachOverlay();
            };
        /**
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.closePanel = /**
         * @return {?}
         */
            function () {
                if (this.panelOpen) {
                    this.nzAutocomplete.isOpen = this.panelOpen = false;
                    if (this.overlayRef && this.overlayRef.hasAttached()) {
                        this.overlayRef.detach();
                        this.selectionChangeSubscription.unsubscribe();
                        this.overlayBackdropClickSubscription.unsubscribe();
                        this.overlayPositionChangeSubscription.unsubscribe();
                        this.optionsChangeSubscription.unsubscribe();
                    }
                }
            };
        /**
         * 订阅数据源改变事件
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.subscribeOptionsChange = /**
         * 订阅数据源改变事件
         * @return {?}
         */
            function () {
                var _this = this;
                return this.nzAutocomplete.options.changes.pipe(operators.delay(0)).subscribe(function () {
                    _this.resetActiveItem();
                });
            };
        /**
         * 订阅 option 选择事件
         * 并设置值
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.subscribeSelectionChange = /**
         * 订阅 option 选择事件
         * 并设置值
         * @return {?}
         */
            function () {
                var _this = this;
                return this.nzAutocomplete.selectionChange
                    .subscribe(function (option) {
                    _this.setValueAndClose(option);
                });
            };
        /**
         * 订阅组件外部的单击事件
         * 并关闭弹窗
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.subscribeOverlayBackdropClick = /**
         * 订阅组件外部的单击事件
         * 并关闭弹窗
         * @return {?}
         */
            function () {
                var _this = this;
                return rxjs.merge(rxjs.fromEvent(this._document, 'click'), rxjs.fromEvent(this._document, 'touchend'))
                    .subscribe(function (event) {
                    /** @type {?} */
                    var clickTarget = /** @type {?} */ (event.target);
                    // 确保不是点击组件自身
                    if (clickTarget !== _this._element.nativeElement && !_this.overlayRef.overlayElement.contains(clickTarget) && _this.panelOpen) {
                        _this.closePanel();
                    }
                });
            };
        /**
         * 订阅 Overlay 位置改变事件
         * 并重新设置动画方向
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.subscribeOverlayPositionChange = /**
         * 订阅 Overlay 位置改变事件
         * 并重新设置动画方向
         * @return {?}
         */
            function () {
                var _this = this;
                return this.positionStrategy.positionChanges
                    .pipe(operators.map(function (position) { return position.connectionPair.originY; }), operators.distinct())
                    .subscribe(function (position) {
                    _this.nzAutocomplete.dropDownPosition = position;
                });
            };
        /**
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.attachOverlay = /**
         * @return {?}
         */
            function () {
                var _this = this;
                if (!this.nzAutocomplete) {
                    throw getNzAutocompleteMissingPanelError();
                }
                if (!this.overlayRef) {
                    this.portal = new portal.TemplatePortal(this.nzAutocomplete.template, this._viewContainerRef);
                    this.overlayRef = this._overlay.create(this.getOverlayConfig());
                }
                if (this.overlayRef && !this.overlayRef.hasAttached()) {
                    this.overlayRef.attach(this.portal);
                    this.overlayPositionChangeSubscription = this.subscribeOverlayPositionChange();
                    this.selectionChangeSubscription = this.subscribeSelectionChange();
                    this.overlayBackdropClickSubscription = this.subscribeOverlayBackdropClick();
                    this.optionsChangeSubscription = this.subscribeOptionsChange();
                }
                this.nzAutocomplete.isOpen = this.panelOpen = true;
                this.nzAutocomplete.setVisibility();
                this.overlayRef.updateSize({ width: this.nzAutocomplete.nzWidth || this.getHostWidth() });
                setTimeout(function () {
                    if (_this.overlayRef) {
                        _this.overlayRef.updatePosition();
                    }
                }, 150);
                this.resetActiveItem();
                if (this.activeOption) {
                    this.activeOption.scrollIntoViewIfNeeded();
                }
            };
        /**
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.destroyPanel = /**
         * @return {?}
         */
            function () {
                if (this.overlayRef) {
                    this.closePanel();
                    this.overlayRef.dispose();
                    this.overlayRef = null;
                }
            };
        /**
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.getOverlayConfig = /**
         * @return {?}
         */
            function () {
                return new i2.OverlayConfig({
                    positionStrategy: this.getOverlayPosition(),
                    scrollStrategy: this._overlay.scrollStrategies.reposition(),
                    // 如果没有设置 nzWidth 则使用 Host 元素的宽度
                    width: this.nzAutocomplete.nzWidth || this.getHostWidth()
                });
            };
        /**
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.getConnectedElement = /**
         * @return {?}
         */
            function () {
                return this._element;
            };
        /**
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.getHostWidth = /**
         * @return {?}
         */
            function () {
                return this.getConnectedElement().nativeElement.getBoundingClientRect().width;
            };
        /**
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.getOverlayPosition = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var positions = [
                    new i2.ConnectionPositionPair({ originX: 'start', originY: 'bottom' }, { overlayX: 'start', overlayY: 'top' }),
                    new i2.ConnectionPositionPair({ originX: 'start', originY: 'top' }, { overlayX: 'start', overlayY: 'bottom' })
                ];
                this.positionStrategy = this._overlay.position()
                    .flexibleConnectedTo(this.getConnectedElement())
                    .withPositions(positions)
                    .withFlexibleDimensions(false)
                    .withPush(false);
                return this.positionStrategy;
            };
        /**
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.resetActiveItem = /**
         * @return {?}
         */
            function () {
                if (this.nzAutocomplete.activeItem && this.nzAutocomplete.getOptionIndex(this.nzAutocomplete.activeItem)) {
                    this.nzAutocomplete.setActiveItem(this.nzAutocomplete.getOptionIndex(this.nzAutocomplete.activeItem));
                }
                else {
                    this.nzAutocomplete.setActiveItem(this.nzAutocomplete.nzDefaultActiveFirstOption ? 0 : -1);
                }
            };
        /**
         * @param {?} event
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.handleKeydown = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                /** @type {?} */
                var keyCode = event.keyCode;
                /** @type {?} */
                var isArrowKey = keyCode === keycodes.UP_ARROW || keyCode === keycodes.DOWN_ARROW;
                if (keyCode === keycodes.ESCAPE) {
                    event.preventDefault();
                }
                if (this.panelOpen && (keyCode === keycodes.ESCAPE || keyCode === keycodes.TAB)) {
                    // 通过 tab / ESC 关闭，重置输入标签 value
                    if (this.activeOption.getLabel() !== this.previousValue) {
                        this.setTriggerValue(this.previousValue);
                    }
                    this.closePanel();
                }
                else if (this.panelOpen && keyCode === keycodes.ENTER) {
                    event.preventDefault();
                    if (this.nzAutocomplete.showPanel && this.activeOption) {
                        this.activeOption.selectViaInteraction();
                    }
                }
                else if (this.panelOpen && isArrowKey && this.nzAutocomplete.showPanel) {
                    event.stopPropagation();
                    if (keyCode === keycodes.UP_ARROW) {
                        this.nzAutocomplete.setPreviousItemActive();
                    }
                    else {
                        this.nzAutocomplete.setNextItemActive();
                    }
                    if (this.activeOption) {
                        this.activeOption.scrollIntoViewIfNeeded();
                    }
                    this.doBackfill();
                }
            };
        /**
         * @param {?} option
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.setValueAndClose = /**
         * @param {?} option
         * @return {?}
         */
            function (option) {
                /** @type {?} */
                var value = option.nzValue;
                this.setTriggerValue(option.getLabel());
                this._onChange(value);
                this._element.nativeElement.focus();
                this.closePanel();
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.setTriggerValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this._element.nativeElement.value = value || '';
            };
        /**
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.doBackfill = /**
         * @return {?}
         */
            function () {
                if (this.nzAutocomplete.nzBackfill) {
                    // 只设置标签显示值
                    this.setTriggerValue(this.nzAutocomplete.activeItem.getLabel());
                }
            };
        /**
         * @param {?} event
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.handleInput = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                /** @type {?} */
                var target = /** @type {?} */ (event.target);
                /** @type {?} */
                var value = target.value;
                if (target.type === 'number') {
                    value = value === '' ? null : parseFloat(value);
                }
                if (this.canOpen() && document.activeElement === event.target &&
                    this.previousValue !== value) {
                    this.previousValue = value;
                    this._onChange(value);
                    this.openPanel();
                }
            };
        /**
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.handleFocus = /**
         * @return {?}
         */
            function () {
                if (this.canOpen()) {
                    this.previousValue = this._element.nativeElement.value;
                    this.openPanel();
                }
            };
        /**
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.handleBlur = /**
         * @return {?}
         */
            function () {
                this._onTouched();
            };
        /**
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.canOpen = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var element = this._element.nativeElement;
                return !element.readOnly && !element.disabled;
            };
        // tslint:disable-next-line:no-any
        /**
         * @param {?} value
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.writeValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.setTriggerValue(value);
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this._onChange = fn;
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this._onTouched = fn;
            };
        /**
         * @param {?} isDisabled
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.setDisabledState = /**
         * @param {?} isDisabled
         * @return {?}
         */
            function (isDisabled) {
                /** @type {?} */
                var element = this._element.nativeElement;
                element.disabled = isDisabled;
                this.closePanel();
            };
        /**
         * @return {?}
         */
        NzAutocompleteTriggerDirective.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.destroyPanel();
            };
        NzAutocompleteTriggerDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: "input[nzAutocomplete], textarea[nzAutocomplete]",
                        providers: [NZ_AUTOCOMPLETE_VALUE_ACCESSOR],
                        host: {
                            'autocomplete': 'off',
                            'aria-autocomplete': 'list',
                            '(focusin)': 'handleFocus()',
                            '(blur)': 'handleBlur()',
                            '(input)': 'handleInput($event)',
                            '(keydown)': 'handleKeydown($event)'
                        }
                    },] }
        ];
        /** @nocollapse */
        NzAutocompleteTriggerDirective.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: i2.Overlay },
                { type: i0.ViewContainerRef },
                { type: undefined, decorators: [{ type: i0.Optional }, { type: i0.Inject, args: [i1.DOCUMENT,] }] }
            ];
        };
        NzAutocompleteTriggerDirective.propDecorators = {
            nzAutocomplete: [{ type: i0.Input }]
        };
        return NzAutocompleteTriggerDirective;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var dropDownAnimation = animations.trigger('dropDownAnimation', [
        animations.state('bottom', animations.style({
            opacity: 1,
            transform: 'scaleY(1)',
            transformOrigin: '0% 0%'
        })),
        animations.transition('void => bottom', [
            animations.style({
                opacity: 0,
                transform: 'scaleY(0.8)',
                transformOrigin: '0% 0%'
            }),
            animations.animate('150ms cubic-bezier(0.23, 1, 0.32, 1)')
        ]),
        animations.transition('bottom => void', [
            animations.animate('150ms cubic-bezier(0.23, 1, 0.32, 1)', animations.style({
                opacity: 0,
                transform: 'scaleY(0.8)',
                transformOrigin: '0% 0%'
            }))
        ]),
        animations.state('top', animations.style({
            opacity: 1,
            transform: 'scaleY(1)',
            transformOrigin: '0% 100%'
        })),
        animations.transition('void => top', [
            animations.style({
                opacity: 0,
                transform: 'scaleY(0.8)',
                transformOrigin: '0% 100%'
            }),
            animations.animate('150ms cubic-bezier(0.23, 1, 0.32, 1)')
        ]),
        animations.transition('top => void', [
            animations.animate('150ms cubic-bezier(0.23, 1, 0.32, 1)', animations.style({
                opacity: 0,
                transform: 'scaleY(0.8)',
                transformOrigin: '0% 100%'
            }))
        ])
    ]);

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzAutocompleteComponent = /** @class */ (function () {
        function NzAutocompleteComponent(changeDetectorRef, _ngZone) {
            var _this = this;
            this.changeDetectorRef = changeDetectorRef;
            this._ngZone = _ngZone;
            this.activeItemIndex = -1;
            this.showPanel = false;
            this.isOpen = false;
            this.dropDownPosition = 'bottom';
            this._defaultActiveFirstOption = true;
            this._backfill = false;
            /**
             * 选择时发出的事件
             */
            this.selectionChange = new i0.EventEmitter();
            /**
             * 用于组件内部监听 options 的选择变化
             */
            this.optionSelectionChanges = rxjs.defer(function () {
                if (_this.options) {
                    return rxjs.merge.apply(void 0, __spread(_this.options.map(function (option) { return option.selectionChange; })));
                }
                return _this._ngZone.onStable
                    .asObservable()
                    .pipe(operators.take(1), operators.switchMap(function () { return _this.optionSelectionChanges; }));
            });
        }
        Object.defineProperty(NzAutocompleteComponent.prototype, "options", {
            /** 组件支持设置 dataSource 和 content 设置 options
             *  这个属性为其提供方便的访问方式 */
            get: /**
             * 组件支持设置 dataSource 和 content 设置 options
             *  这个属性为其提供方便的访问方式
             * @return {?}
             */ function () {
                // 优先使用 dataSource
                if (this.nzDataSource) {
                    return this.fromDataSourceOptions;
                }
                else {
                    return this.fromContentOptions;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzAutocompleteComponent.prototype, "nzDefaultActiveFirstOption", {
            /** 是否默认高亮第一个选项，默认 `true` */
            get: /**
             * 是否默认高亮第一个选项，默认 `true`
             * @return {?}
             */ function () {
                return this._defaultActiveFirstOption;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._defaultActiveFirstOption = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzAutocompleteComponent.prototype, "nzBackfill", {
            /** 使用键盘选择选项的时候把选中项回填到输入框中，默认 `false` */
            get: /**
             * 使用键盘选择选项的时候把选中项回填到输入框中，默认 `false`
             * @return {?}
             */ function () {
                return this._backfill;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._backfill = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzAutocompleteComponent.prototype, "nzDataSource", {
            /** 自动完成的数据源 */
            get: /**
             * 自动完成的数据源
             * @return {?}
             */ function () {
                return this._dataSource;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._dataSource = value;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzAutocompleteComponent.prototype.ngAfterViewInit = /**
         * @return {?}
         */
            function () {
                this.optionsInit();
            };
        /**
         * @return {?}
         */
        NzAutocompleteComponent.prototype.setVisibility = /**
         * @return {?}
         */
            function () {
                this.showPanel = !!this.options.length;
                this.changeDetectorRef.markForCheck();
            };
        /**
         * @param {?} index
         * @return {?}
         */
        NzAutocompleteComponent.prototype.setActiveItem = /**
         * @param {?} index
         * @return {?}
         */
            function (index) {
                /** @type {?} */
                var activeItem = this.options.toArray()[index];
                if (activeItem && !activeItem.active) {
                    this.activeItem = activeItem;
                    this.activeItemIndex = index;
                    this.clearSelectedOptions(this.activeItem);
                    this.activeItem.setActiveStyles();
                    this.changeDetectorRef.markForCheck();
                }
            };
        /**
         * @return {?}
         */
        NzAutocompleteComponent.prototype.setNextItemActive = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var nextIndex = this.activeItemIndex + 1 <= this.options.length - 1 ? this.activeItemIndex + 1 : 0;
                this.setActiveItem(nextIndex);
            };
        /**
         * @return {?}
         */
        NzAutocompleteComponent.prototype.setPreviousItemActive = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var previousIndex = this.activeItemIndex - 1 < 0 ? this.options.length - 1 : this.activeItemIndex - 1;
                this.setActiveItem(previousIndex);
            };
        /**
         * @param {?} option
         * @return {?}
         */
        NzAutocompleteComponent.prototype.getOptionIndex = /**
         * @param {?} option
         * @return {?}
         */
            function (option) {
                return this.options.reduce(function (result, current, index) {
                    return result === undefined ? (option === current ? index : undefined) : result;
                }, undefined);
            };
        /**
         * @return {?}
         */
        NzAutocompleteComponent.prototype.optionsInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.setVisibility();
                this.subscribeOptionChanges();
                /** @type {?} */
                var changes = this.nzDataSource ? this.fromDataSourceOptions.changes : this.fromContentOptions.changes;
                // 用于处理动态/异步的 options
                changes.subscribe(function (e) {
                    if (!e.dirty && _this.isOpen) {
                        setTimeout(function (_) { return _this.setVisibility(); });
                    }
                    _this.subscribeOptionChanges();
                });
            };
        /**
         * 清除 Options 的激活状态
         * @param {?=} skip
         * @param {?=} deselect
         * @return {?}
         */
        NzAutocompleteComponent.prototype.clearSelectedOptions = /**
         * 清除 Options 的激活状态
         * @param {?=} skip
         * @param {?=} deselect
         * @return {?}
         */
            function (skip, deselect) {
                if (deselect === void 0) {
                    deselect = false;
                }
                this.options.forEach(function (option) {
                    if (option !== skip) {
                        if (deselect) {
                            option.deselect();
                        }
                        option.setInactiveStyles();
                    }
                });
            };
        /**
         * @return {?}
         */
        NzAutocompleteComponent.prototype.subscribeOptionChanges = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.selectionChangeSubscription = this.optionSelectionChanges
                    .pipe(operators.filter(function (event) { return event.isUserInput; }))
                    .subscribe(function (event) {
                    event.source.select();
                    event.source.setActiveStyles();
                    _this.activeItem = event.source;
                    _this.activeItemIndex = _this.getOptionIndex(_this.activeItem);
                    _this.clearSelectedOptions(event.source, true);
                    _this.selectionChange.emit(event.source);
                });
            };
        NzAutocompleteComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-autocomplete',
                        preserveWhitespaces: false,
                        changeDetection: i0.ChangeDetectionStrategy.OnPush,
                        animations: [
                            dropDownAnimation
                        ],
                        template: "<ng-template>\n  <div class=\"ant-select-dropdown ant-select-dropdown--single ant-select-dropdown-placement-bottomLeft\"\n    #panel\n    [@dropDownAnimation]=\"dropDownPosition\"\n    [class.ant-select-dropdown-hidden]=\"!showPanel\">\n    <div style=\"overflow: auto;\">\n      <ul class=\"ant-select-dropdown-menu  ant-select-dropdown-menu-root ant-select-dropdown-menu-vertical\"\n        role=\"menu\"\n        aria-activedescendant>\n        <ng-template *ngTemplateOutlet=\"nzDataSource ? optionsTemplate : contentTemplate\"></ng-template>\n      </ul>\n    </div>\n  </div>\n  <ng-template #contentTemplate>\n    <ng-content></ng-content>\n  </ng-template>\n  <ng-template #optionsTemplate>\n    <nz-auto-option *ngFor=\"let option of nzDataSource\" [nzValue]=\"option\">{{option}}</nz-auto-option>\n  </ng-template>\n</ng-template>",
                        styles: ["\n    .ant-select-dropdown {\n      top: 100%;\n      left: 0;\n      position: relative;\n      width: 100%;\n      margin-top: 4px;\n      margin-bottom: 4px;\n    }\n    "]
                    }] }
        ];
        /** @nocollapse */
        NzAutocompleteComponent.ctorParameters = function () {
            return [
                { type: i0.ChangeDetectorRef },
                { type: i0.NgZone }
            ];
        };
        NzAutocompleteComponent.propDecorators = {
            template: [{ type: i0.ViewChild, args: [i0.TemplateRef,] }],
            panel: [{ type: i0.ViewChild, args: ['panel',] }],
            content: [{ type: i0.ViewChild, args: ['content',] }],
            fromContentOptions: [{ type: i0.ContentChildren, args: [NzAutocompleteOptionComponent, { descendants: true },] }],
            fromDataSourceOptions: [{ type: i0.ViewChildren, args: [NzAutocompleteOptionComponent,] }],
            nzWidth: [{ type: i0.Input }],
            nzDefaultActiveFirstOption: [{ type: i0.Input }],
            nzBackfill: [{ type: i0.Input }],
            nzDataSource: [{ type: i0.Input }],
            selectionChange: [{ type: i0.Output }]
        };
        return NzAutocompleteComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzAutocompleteModule = /** @class */ (function () {
        function NzAutocompleteModule() {
        }
        NzAutocompleteModule.decorators = [
            { type: i0.NgModule, args: [{
                        declarations: [NzAutocompleteComponent, NzAutocompleteOptionComponent, NzAutocompleteTriggerDirective, NzAutocompleteOptgroupComponent],
                        exports: [NzAutocompleteComponent, NzAutocompleteOptionComponent, NzAutocompleteTriggerDirective, NzAutocompleteOptgroupComponent],
                        imports: [i1.CommonModule, i2.OverlayModule, forms.FormsModule]
                    },] }
        ];
        return NzAutocompleteModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzUpdateHostClassService = /** @class */ (function () {
        function NzUpdateHostClassService(renderer) {
            this.renderer = renderer;
            this.classMap = {};
        }
        /**
         * @param {?} el
         * @param {?} classMap
         * @return {?}
         */
        NzUpdateHostClassService.prototype.updateHostClass = /**
         * @param {?} el
         * @param {?} classMap
         * @return {?}
         */
            function (el, classMap) {
                this.removeClass(el, this.classMap, this.renderer);
                this.classMap = __assign({}, classMap);
                this.addClass(el, this.classMap, this.renderer);
            };
        /**
         * @param {?} el
         * @param {?} classMap
         * @param {?} renderer
         * @return {?}
         */
        NzUpdateHostClassService.prototype.removeClass = /**
         * @param {?} el
         * @param {?} classMap
         * @param {?} renderer
         * @return {?}
         */
            function (el, classMap, renderer) {
                for (var i in classMap) {
                    if (classMap.hasOwnProperty(i)) {
                        renderer.removeClass(el, i);
                    }
                }
            };
        /**
         * @param {?} el
         * @param {?} classMap
         * @param {?} renderer
         * @return {?}
         */
        NzUpdateHostClassService.prototype.addClass = /**
         * @param {?} el
         * @param {?} classMap
         * @param {?} renderer
         * @return {?}
         */
            function (el, classMap, renderer) {
                for (var i in classMap) {
                    if (classMap.hasOwnProperty(i)) {
                        if (classMap[i]) {
                            renderer.addClass(el, i);
                        }
                    }
                }
            };
        NzUpdateHostClassService.decorators = [
            { type: i0.Injectable }
        ];
        /** @nocollapse */
        NzUpdateHostClassService.ctorParameters = function () {
            return [
                { type: i0.Renderer2 }
            ];
        };
        return NzUpdateHostClassService;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzAvatarComponent = /** @class */ (function () {
        function NzAvatarComponent(elementRef, cd, updateHostClassService) {
            this.cd = cd;
            this.updateHostClassService = updateHostClassService;
            this.prefixCls = 'ant-avatar';
            this.sizeMap = { large: 'lg', small: 'sm' };
            this.hasText = false;
            this.hasSrc = true;
            this.hasIcon = false;
            this.nzShape = 'circle';
            this.nzSize = 'default';
            this.el = elementRef.nativeElement;
        }
        /**
         * @return {?}
         */
        NzAvatarComponent.prototype.setClass = /**
         * @return {?}
         */
            function () {
                var _a;
                /** @type {?} */
                var classMap = (_a = {},
                    _a[this.prefixCls] = true,
                    _a[this.prefixCls + "-" + this.sizeMap[this.nzSize]] = this.sizeMap[this.nzSize],
                    _a[this.prefixCls + "-" + this.nzShape] = this.nzShape,
                    _a[this.prefixCls + "-icon"] = this.nzIcon,
                    _a[this.prefixCls + "-image"] = this.nzSrc,
                    _a);
                this.updateHostClassService.updateHostClass(this.el, classMap);
                this.cd.detectChanges();
                return this;
            };
        /**
         * @return {?}
         */
        NzAvatarComponent.prototype.imgError = /**
         * @return {?}
         */
            function () {
                this.hasSrc = false;
                this.hasIcon = false;
                this.hasText = false;
                if (this.nzIcon) {
                    this.hasIcon = true;
                }
                else if (this.nzText) {
                    this.hasText = true;
                }
                this.setClass().notifyCalc();
            };
        /**
         * @return {?}
         */
        NzAvatarComponent.prototype.calcStringSize = /**
         * @return {?}
         */
            function () {
                if (!this.hasText) {
                    return;
                }
                /** @type {?} */
                var childrenWidth = this.textEl.nativeElement.offsetWidth;
                /** @type {?} */
                var avatarWidth = this.el.getBoundingClientRect().width;
                /** @type {?} */
                var scale = avatarWidth - 8 < childrenWidth ? (avatarWidth - 8) / childrenWidth : 1;
                if (scale === 1) {
                    this.textStyles = {};
                }
                else {
                    this.textStyles = {
                        transform: "scale(" + scale + ")",
                        position: 'absolute',
                        display: 'inline-block',
                        left: "calc(50% - " + Math.round(childrenWidth / 2) + "px)"
                    };
                }
                this.cd.detectChanges();
            };
        /**
         * @return {?}
         */
        NzAvatarComponent.prototype.notifyCalc = /**
         * @return {?}
         */
            function () {
                var _this = this;
                // If use ngAfterViewChecked, always demands more computations, so......
                setTimeout(function () {
                    _this.calcStringSize();
                });
                return this;
            };
        /**
         * @param {?} changes
         * @return {?}
         */
        NzAvatarComponent.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                this.hasText = !this.nzSrc && !!this.nzText;
                this.hasIcon = !this.nzSrc && !!this.nzIcon;
                this.hasSrc = !!this.nzSrc;
                this.setClass().notifyCalc();
            };
        NzAvatarComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-avatar',
                        template: "<i *ngIf=\"nzIcon && hasIcon\" [ngClass]=\"nzIcon\"></i>\n<img [src]=\"nzSrc\" *ngIf=\"nzSrc && hasSrc\" (error)=\"imgError()\"/>\n<span class=\"ant-avatar-string\" #textEl [ngStyle]=\"textStyles\" *ngIf=\"nzText && hasText\">{{ nzText }}</span>",
                        providers: [NzUpdateHostClassService],
                        preserveWhitespaces: false,
                        changeDetection: i0.ChangeDetectionStrategy.OnPush
                    }] }
        ];
        /** @nocollapse */
        NzAvatarComponent.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: i0.ChangeDetectorRef },
                { type: NzUpdateHostClassService }
            ];
        };
        NzAvatarComponent.propDecorators = {
            textEl: [{ type: i0.ViewChild, args: ['textEl',] }],
            nzShape: [{ type: i0.Input }],
            nzSize: [{ type: i0.Input }],
            nzText: [{ type: i0.Input }],
            nzSrc: [{ type: i0.Input }],
            nzIcon: [{ type: i0.Input }]
        };
        return NzAvatarComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzAvatarModule = /** @class */ (function () {
        function NzAvatarModule() {
        }
        NzAvatarModule.decorators = [
            { type: i0.NgModule, args: [{
                        declarations: [NzAvatarComponent],
                        exports: [NzAvatarComponent],
                        imports: [i1.CommonModule]
                    },] }
        ];
        return NzAvatarModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzBackTopComponent = /** @class */ (function () {
        function NzBackTopComponent(scrollSrv, cd) {
            this.scrollSrv = scrollSrv;
            this.cd = cd;
            this.scroll$ = null;
            this.target = null;
            this.visible = false;
            this._visibilityHeight = 400;
            this.nzClick = new i0.EventEmitter();
        }
        Object.defineProperty(NzBackTopComponent.prototype, "nzVisibilityHeight", {
            get: /**
             * @return {?}
             */ function () {
                return this._visibilityHeight;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._visibilityHeight = toNumber(value, 400);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzBackTopComponent.prototype, "nzTarget", {
            set: /**
             * @param {?} el
             * @return {?}
             */ function (el) {
                this.target = el;
                this.registerScrollEvent();
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzBackTopComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                if (!this.scroll$) {
                    this.registerScrollEvent();
                }
            };
        /**
         * @return {?}
         */
        NzBackTopComponent.prototype.clickBackTop = /**
         * @return {?}
         */
            function () {
                this.scrollSrv.scrollTo(this.getTarget(), 0);
                this.nzClick.emit(true);
            };
        /**
         * @return {?}
         */
        NzBackTopComponent.prototype.getTarget = /**
         * @return {?}
         */
            function () {
                return this.target || window;
            };
        /**
         * @return {?}
         */
        NzBackTopComponent.prototype.handleScroll = /**
         * @return {?}
         */
            function () {
                if (this.visible === this.scrollSrv.getScroll(this.getTarget()) > this.nzVisibilityHeight) {
                    return;
                }
                this.visible = !this.visible;
                this.cd.detectChanges();
            };
        /**
         * @return {?}
         */
        NzBackTopComponent.prototype.removeListen = /**
         * @return {?}
         */
            function () {
                if (this.scroll$) {
                    this.scroll$.unsubscribe();
                }
            };
        /**
         * @return {?}
         */
        NzBackTopComponent.prototype.registerScrollEvent = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.removeListen();
                this.handleScroll();
                this.scroll$ = rxjs.fromEvent(this.getTarget(), 'scroll').pipe(operators.throttleTime(50), operators.distinctUntilChanged())
                    .subscribe(function (e) { return _this.handleScroll(); });
            };
        /**
         * @return {?}
         */
        NzBackTopComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.removeListen();
            };
        NzBackTopComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-back-top',
                        animations: [
                            animations.trigger('enterLeave', [
                                animations.transition(':enter', [
                                    animations.style({ opacity: 0 }),
                                    animations.animate(300, animations.style({ opacity: 1 }))
                                ]),
                                animations.transition(':leave', [
                                    animations.style({ opacity: 1 }),
                                    animations.animate(300, animations.style({ opacity: 0 }))
                                ])
                            ])
                        ],
                        template: "<div class=\"ant-back-top\" (click)=\"clickBackTop()\" [@enterLeave] *ngIf=\"visible\">\n  <ng-template #defaultContent>\n    <div class=\"ant-back-top-content\">\n      <div class=\"ant-back-top-icon\"></div>\n    </div>\n  </ng-template>\n  <ng-template [ngTemplateOutlet]=\"nzTemplate || defaultContent\"></ng-template>\n</div>",
                        changeDetection: i0.ChangeDetectionStrategy.OnPush,
                        preserveWhitespaces: false
                    }] }
        ];
        /** @nocollapse */
        NzBackTopComponent.ctorParameters = function () {
            return [
                { type: NzScrollService },
                { type: i0.ChangeDetectorRef }
            ];
        };
        NzBackTopComponent.propDecorators = {
            nzTemplate: [{ type: i0.Input }],
            nzVisibilityHeight: [{ type: i0.Input }],
            nzTarget: [{ type: i0.Input }],
            nzClick: [{ type: i0.Output }]
        };
        return NzBackTopComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzBackTopModule = /** @class */ (function () {
        function NzBackTopModule() {
        }
        NzBackTopModule.decorators = [
            { type: i0.NgModule, args: [{
                        declarations: [NzBackTopComponent],
                        exports: [NzBackTopComponent],
                        imports: [i1.CommonModule],
                        providers: [SCROLL_SERVICE_PROVIDER]
                    },] }
        ];
        return NzBackTopModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzBadgeComponent = /** @class */ (function () {
        function NzBadgeComponent(zone, renderer, elementRef) {
            this.zone = zone;
            this.renderer = renderer;
            this.elementRef = elementRef;
            this._showDot = false;
            this._showZero = false;
            this.maxNumberArray = [];
            this.countArray = [];
            this.countSingleArray = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9];
            this.nzOverflowCount = 99;
        }
        Object.defineProperty(NzBadgeComponent.prototype, "nzShowZero", {
            get: /**
             * @return {?}
             */ function () {
                return this._showZero;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._showZero = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzBadgeComponent.prototype, "nzDot", {
            get: /**
             * @return {?}
             */ function () {
                return this._showDot;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._showDot = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzBadgeComponent.prototype, "nzCount", {
            get: /**
             * @return {?}
             */ function () {
                return this._count;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value < 0) {
                    this._count = 0;
                }
                else {
                    this._count = value;
                }
                this.countArray = this._count.toString().split('');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzBadgeComponent.prototype, "showSup", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzDot || this.nzCount > 0 || ((this.nzCount === 0) && this.nzShowZero);
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzBadgeComponent.prototype.checkContent = /**
         * @return {?}
         */
            function () {
                if (isEmpty(this.contentElement.nativeElement)) {
                    this.renderer.addClass(this.elementRef.nativeElement, 'ant-badge-not-a-wrapper');
                }
                else {
                    this.renderer.removeClass(this.elementRef.nativeElement, 'ant-badge-not-a-wrapper');
                }
            };
        /**
         * @return {?}
         */
        NzBadgeComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.maxNumberArray = this.nzOverflowCount.toString().split('');
            };
        /**
         * @return {?}
         */
        NzBadgeComponent.prototype.ngAfterViewInit = /**
         * @return {?}
         */
            function () {
                this.checkContent();
            };
        NzBadgeComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-badge',
                        preserveWhitespaces: false,
                        animations: [
                            animations.trigger('enterLeave', [
                                animations.transition('void => *', [
                                    animations.style({ opacity: 0 }),
                                    animations.animate('0.3s cubic-bezier(0.12, 0.4, 0.29, 1.46)')
                                ]),
                                animations.transition('* => void', [
                                    animations.style({ opacity: 1 }),
                                    animations.animate('0.3s cubic-bezier(0.12, 0.4, 0.29, 1.46)')
                                ])
                            ])
                        ],
                        template: "<span (cdkObserveContent)=\"checkContent()\" #contentElement><ng-content></ng-content></span>\n<span class=\"ant-badge-status-dot ant-badge-status-{{nzStatus}}\" *ngIf=\"nzStatus\" [ngStyle]=\"nzStyle\"></span>\n<span class=\"ant-badge-status-text\" *ngIf=\"nzStatus\">{{ nzText }}</span>\n<sup\n  *ngIf=\"showSup\"\n  [@enterLeave]\n  [ngStyle]=\"nzStyle\"\n  class=\"ant-scroll-number\"\n  [class.ant-badge-count]=\"!nzDot\"\n  [class.ant-badge-dot]=\"nzDot\"\n  [class.ant-badge-multiple-words]=\"countArray.length>=2\">\n  <ng-template\n    ngFor\n    [ngForOf]=\"maxNumberArray\"\n    let-number\n    let-i=\"index\">\n      <span\n        *ngIf=\"nzCount<=nzOverflowCount\"\n        class=\"ant-scroll-number-only\"\n        [style.transform]=\"'translateY('+((-countArray[i]*100))+'%)'\">\n          <ng-template [ngIf]=\"(!nzDot)&&(countArray[i]!=null)\">\n            <p *ngFor=\"let p of countSingleArray\" [class.current]=\"p==countArray[i]\">{{ p }}</p>\n          </ng-template>\n      </span>\n  </ng-template>\n  <ng-template [ngIf]=\"nzCount>nzOverflowCount\">{{ nzOverflowCount }}+</ng-template>\n</sup>",
                        host: {
                            '[class.ant-badge]': 'true',
                            '[class.ant-badge-status]': 'nzStatus'
                        },
                        styles: ["\n      :host:not(.ant-badge-not-a-wrapper) .ant-badge-count {\n        position: absolute;\n        transform: translateX(50%);\n        right: 0;\n      }\n\n      :host .ant-badge-dot {\n        position: absolute;\n        transform: translateX(50%);\n        right: 0;\n      }\n    "]
                    }] }
        ];
        /** @nocollapse */
        NzBadgeComponent.ctorParameters = function () {
            return [
                { type: i0.NgZone },
                { type: i0.Renderer2 },
                { type: i0.ElementRef }
            ];
        };
        NzBadgeComponent.propDecorators = {
            contentElement: [{ type: i0.ViewChild, args: ['contentElement',] }],
            nzOverflowCount: [{ type: i0.Input }],
            nzText: [{ type: i0.Input }],
            nzStyle: [{ type: i0.Input }],
            nzStatus: [{ type: i0.Input }],
            nzShowZero: [{ type: i0.Input }],
            nzDot: [{ type: i0.Input }],
            nzCount: [{ type: i0.Input }]
        };
        return NzBadgeComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzBadgeModule = /** @class */ (function () {
        function NzBadgeModule() {
        }
        NzBadgeModule.decorators = [
            { type: i0.NgModule, args: [{
                        declarations: [NzBadgeComponent],
                        exports: [NzBadgeComponent],
                        imports: [i1.CommonModule, observers.ObserversModule]
                    },] }
        ];
        return NzBadgeModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var ROUTE_DATA_BREADCRUMB = 'breadcrumb';
    var NzBreadCrumbComponent = /** @class */ (function () {
        function NzBreadCrumbComponent(_injector) {
            this._injector = _injector;
            this._separator = '/';
            this.$destroy = new rxjs.Subject();
            this.isTemplateRef = false;
            this.nzAutoGenerate = false;
            this.breadcrumbs = [];
        }
        Object.defineProperty(NzBreadCrumbComponent.prototype, "nzSeparator", {
            get: /**
             * @return {?}
             */ function () {
                return this._separator;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._separator = value;
                this.isTemplateRef = value instanceof i0.TemplateRef;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} route
         * @param {?=} url
         * @param {?=} breadcrumbs
         * @return {?}
         */
        NzBreadCrumbComponent.prototype.getBreadcrumbs = /**
         * @param {?} route
         * @param {?=} url
         * @param {?=} breadcrumbs
         * @return {?}
         */
            function (route, url, breadcrumbs) {
                if (url === void 0) {
                    url = '';
                }
                if (breadcrumbs === void 0) {
                    breadcrumbs = [];
                }
                var e_1, _a;
                /** @type {?} */
                var children = route.children;
                if (children.length === 0) {
                    return breadcrumbs; // If there's no sub root, then stop the recurse and returns the generated breadcrumbs.
                }
                try {
                    for (var children_1 = __values(children), children_1_1 = children_1.next(); !children_1_1.done; children_1_1 = children_1.next()) {
                        var child = children_1_1.value;
                        if (child.outlet !== router.PRIMARY_OUTLET) {
                            continue; // Only parse components in primary router-outlet (in another word, router-outlet without a specific name).
                        }
                        else {
                            /** @type {?} */
                            var routeURL = child.snapshot.url.map(function (segment) { return segment.path; }).join('/');
                            /** @type {?} */
                            var nextUrl = url + ("/" + routeURL);
                            // If have data, go to generate a breadcrumb for it.
                            if (child.snapshot.data.hasOwnProperty(ROUTE_DATA_BREADCRUMB)) {
                                /** @type {?} */
                                var breadcrumb = {
                                    label: child.snapshot.data[ROUTE_DATA_BREADCRUMB] || 'Breadcrumb',
                                    params: child.snapshot.params,
                                    url: nextUrl
                                };
                                breadcrumbs.push(breadcrumb);
                            }
                            return this.getBreadcrumbs(child, nextUrl, breadcrumbs);
                        }
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (children_1_1 && !children_1_1.done && (_a = children_1.return))
                            _a.call(children_1);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
            };
        /**
         * @return {?}
         */
        NzBreadCrumbComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                if (this.nzAutoGenerate) {
                    try {
                        /** @type {?} */
                        var activatedRoute_1 = this._injector.get(router.ActivatedRoute);
                        /** @type {?} */
                        var router$$1 = this._injector.get(router.Router);
                        router$$1.events.pipe(operators.filter(function (e) { return e instanceof router.NavigationEnd; }), operators.takeUntil(this.$destroy)).subscribe(function () {
                            _this.breadcrumbs = _this.getBreadcrumbs(activatedRoute_1.root); // Build the breadcrumb tree from root route.
                        });
                    }
                    catch (e) {
                        throw new Error('You should import RouterModule if you want to use NzAutoGenerate');
                    }
                }
            };
        /**
         * @return {?}
         */
        NzBreadCrumbComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.$destroy.next();
                this.$destroy.complete();
            };
        NzBreadCrumbComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-breadcrumb',
                        preserveWhitespaces: false,
                        template: "<ng-content></ng-content>\n<ng-container *ngIf=\"nzAutoGenerate\">\n  <nz-breadcrumb-item *ngFor=\"let breadcrumb of breadcrumbs\">\n    <a [attr.href]=\"breadcrumb.url\">{{ breadcrumb.label }}</a>\n  </nz-breadcrumb-item>\n</ng-container>\n",
                        host: {
                            '[class.ant-breadcrumb]': 'true'
                        },
                        styles: ["\n    :host {\n      display: block;\n    }\n  "]
                    }] }
        ];
        /** @nocollapse */
        NzBreadCrumbComponent.ctorParameters = function () {
            return [
                { type: i0.Injector }
            ];
        };
        NzBreadCrumbComponent.propDecorators = {
            nzAutoGenerate: [{ type: i0.Input }],
            nzSeparator: [{ type: i0.Input }]
        };
        return NzBreadCrumbComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzBreadCrumbItemComponent = /** @class */ (function () {
        function NzBreadCrumbItemComponent(nzBreadCrumbComponent) {
            this.nzBreadCrumbComponent = nzBreadCrumbComponent;
        }
        NzBreadCrumbItemComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-breadcrumb-item',
                        preserveWhitespaces: false,
                        template: "\n    <span class=\"ant-breadcrumb-link\">\n      <ng-content></ng-content>\n    </span>\n    <span class=\"ant-breadcrumb-separator\">\n      <ng-container *ngIf=\"nzBreadCrumbComponent.isTemplateRef; else stringTemplate\">\n        <ng-template [ngTemplateOutlet]=\"nzBreadCrumbComponent.nzSeparator\"></ng-template>\n      </ng-container>\n      <ng-template #stringTemplate>\n         {{ nzBreadCrumbComponent.nzSeparator }}\n      </ng-template>\n    </span>",
                        styles: [":host:last-child {\n      color: rgba(0, 0, 0, 0.65);\n    }\n\n    :host:last-child .ant-breadcrumb-separator{\n      display: none;\n    }\n    "]
                    }] }
        ];
        /** @nocollapse */
        NzBreadCrumbItemComponent.ctorParameters = function () {
            return [
                { type: NzBreadCrumbComponent }
            ];
        };
        return NzBreadCrumbItemComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzBreadCrumbModule = /** @class */ (function () {
        function NzBreadCrumbModule() {
        }
        NzBreadCrumbModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [i1.CommonModule],
                        declarations: [NzBreadCrumbComponent, NzBreadCrumbItemComponent],
                        exports: [NzBreadCrumbComponent, NzBreadCrumbItemComponent]
                    },] }
        ];
        return NzBreadCrumbModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzWaveRenderer = /** @class */ (function () {
        function NzWaveRenderer(triggerElement, ngZone, insertExtraNode) {
            var _this = this;
            this.triggerElement = triggerElement;
            this.ngZone = ngZone;
            this.insertExtraNode = insertExtraNode;
            this.waveTransitionDuration = 400;
            this.lastTime = 0;
            this.onClick = function (event) {
                if (!_this.triggerElement ||
                    !_this.triggerElement.getAttribute ||
                    _this.triggerElement.getAttribute('disabled') ||
                    ( /** @type {?} */(event.target)).tagName === 'INPUT' ||
                    _this.triggerElement.className.indexOf('disabled') >= 0) {
                    return;
                }
                _this.fadeOutWave();
            };
            /** @type {?} */
            var platform$$1 = new platform.Platform();
            if (platform$$1.isBrowser) {
                this.bindTriggerEvent();
            }
        }
        Object.defineProperty(NzWaveRenderer.prototype, "waveAttributeName", {
            get: /**
             * @return {?}
             */ function () {
                return this.insertExtraNode ? 'ant-click-animating' : 'ant-click-animating-without-extra-node';
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzWaveRenderer.prototype.bindTriggerEvent = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.ngZone.runOutsideAngular(function () {
                    if (_this.triggerElement) {
                        _this.triggerElement.addEventListener('click', _this.onClick, true);
                    }
                });
            };
        /**
         * @return {?}
         */
        NzWaveRenderer.prototype.removeTriggerEvent = /**
         * @return {?}
         */
            function () {
                if (this.triggerElement) {
                    this.triggerElement.removeEventListener('click', this.onClick, true);
                }
            };
        /**
         * @return {?}
         */
        NzWaveRenderer.prototype.removeStyleAndExtraNode = /**
         * @return {?}
         */
            function () {
                if (this.styleForPseudo && document.body.contains(this.styleForPseudo)) {
                    document.body.removeChild(this.styleForPseudo);
                    this.styleForPseudo = null;
                }
                if (this.insertExtraNode && this.triggerElement.contains(this.extraNode)) {
                    this.triggerElement.removeChild(this.extraNode);
                }
            };
        /**
         * @return {?}
         */
        NzWaveRenderer.prototype.destroy = /**
         * @return {?}
         */
            function () {
                this.removeTriggerEvent();
                this.removeStyleAndExtraNode();
            };
        /**
         * @return {?}
         */
        NzWaveRenderer.prototype.fadeOutWave = /**
         * @return {?}
         */
            function () {
                var _this = this;
                /** @type {?} */
                var node = this.triggerElement;
                /** @type {?} */
                var waveColor = this.getWaveColor(node);
                node.setAttribute(this.waveAttributeName, 'true');
                if (Date.now() < this.lastTime + this.waveTransitionDuration) {
                    return;
                }
                if (this.isValidColor(waveColor)) {
                    if (!this.styleForPseudo) {
                        this.styleForPseudo = document.createElement('style');
                    }
                    this.styleForPseudo.innerHTML =
                        "[ant-click-animating-without-extra-node]:after { border-color: " + waveColor + "; }";
                    document.body.appendChild(this.styleForPseudo);
                }
                if (this.insertExtraNode) {
                    if (!this.extraNode) {
                        this.extraNode = document.createElement('div');
                    }
                    this.extraNode.className = 'ant-click-animating-node';
                    node.appendChild(this.extraNode);
                }
                this.lastTime = Date.now();
                this.runTimeoutOutsideZone(function () {
                    node.removeAttribute(_this.waveAttributeName);
                    _this.removeStyleAndExtraNode();
                }, this.waveTransitionDuration);
            };
        /**
         * @param {?} color
         * @return {?}
         */
        NzWaveRenderer.prototype.isValidColor = /**
         * @param {?} color
         * @return {?}
         */
            function (color) {
                return color
                    && color !== '#ffffff'
                    && color !== 'rgb(255, 255, 255)'
                    && this.isNotGrey(color)
                    && !/rgba\(\d*, \d*, \d*, 0\)/.test(color)
                    && color !== 'transparent';
            };
        /**
         * @param {?} color
         * @return {?}
         */
        NzWaveRenderer.prototype.isNotGrey = /**
         * @param {?} color
         * @return {?}
         */
            function (color) {
                /** @type {?} */
                var match = color.match(/rgba?\((\d*), (\d*), (\d*)(, [\.\d]*)?\)/);
                if (match && match[1] && match[2] && match[3]) {
                    return !(match[1] === match[2] && match[2] === match[3]);
                }
                return true;
            };
        /**
         * @param {?} node
         * @return {?}
         */
        NzWaveRenderer.prototype.getWaveColor = /**
         * @param {?} node
         * @return {?}
         */
            function (node) {
                /** @type {?} */
                var nodeStyle = getComputedStyle(node);
                return nodeStyle.getPropertyValue('border-top-color') || // Firefox Compatible
                    // Firefox Compatible
                    nodeStyle.getPropertyValue('border-color') ||
                    nodeStyle.getPropertyValue('background-color');
            };
        /**
         * @param {?} fn
         * @param {?} delay
         * @return {?}
         */
        NzWaveRenderer.prototype.runTimeoutOutsideZone = /**
         * @param {?} fn
         * @param {?} delay
         * @return {?}
         */
            function (fn, delay) {
                this.ngZone.runOutsideAngular(function () { return setTimeout(fn, delay); });
            };
        return NzWaveRenderer;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzWaveDirective = /** @class */ (function () {
        function NzWaveDirective(ngZone, elementRef) {
            this.ngZone = ngZone;
            this.elementRef = elementRef;
            this.nzWaveExtraNode = false;
        }
        /**
         * @return {?}
         */
        NzWaveDirective.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                if (this.waveRenderer) {
                    this.waveRenderer.destroy();
                }
            };
        /**
         * @return {?}
         */
        NzWaveDirective.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                if (this.elementRef.nativeElement) {
                    this.waveRenderer = new NzWaveRenderer(this.elementRef.nativeElement, this.ngZone, this.nzWaveExtraNode);
                }
            };
        NzWaveDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: '[nz-wave]'
                    },] }
        ];
        /** @nocollapse */
        NzWaveDirective.ctorParameters = function () {
            return [
                { type: i0.NgZone },
                { type: i0.ElementRef }
            ];
        };
        NzWaveDirective.propDecorators = {
            nzWaveExtraNode: [{ type: i0.Input }]
        };
        return NzWaveDirective;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzWaveModule = /** @class */ (function () {
        function NzWaveModule() {
        }
        NzWaveModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [platform.PlatformModule],
                        exports: [NzWaveDirective],
                        declarations: [NzWaveDirective]
                    },] }
        ];
        return NzWaveModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzButtonGroupComponent = /** @class */ (function () {
        function NzButtonGroupComponent() {
            var _a;
            this.prefixCls = 'ant-btn-group';
            this.sizeMap = { large: 'lg', small: 'sm' };
            this.classMap = (_a = {},
                _a[this.prefixCls] = true,
                _a[this.prefixCls + "-" + this.sizeMap[this.nzSize]] = this.sizeMap[this.nzSize],
                _a);
        }
        Object.defineProperty(NzButtonGroupComponent.prototype, "nzSize", {
            get: /**
             * @return {?}
             */ function () {
                return this._size;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                var _a;
                this._size = value;
                this.classMap = (_a = {},
                    _a[this.prefixCls] = true,
                    _a[this.prefixCls + "-" + this.sizeMap[this.nzSize]] = this.sizeMap[this.nzSize],
                    _a);
            },
            enumerable: true,
            configurable: true
        });
        NzButtonGroupComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-button-group',
                        preserveWhitespaces: false,
                        template: "<div [ngClass]=\"classMap\" #groupWrapper>\n  <ng-content></ng-content>\n</div>"
                    }] }
        ];
        NzButtonGroupComponent.propDecorators = {
            groupWrapper: [{ type: i0.ViewChild, args: ['groupWrapper',] }],
            nzSize: [{ type: i0.Input }]
        };
        return NzButtonGroupComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzButtonComponent = /** @class */ (function () {
        function NzButtonComponent(elementRef, cdr, renderer, nzUpdateHostClassService, ngZone) {
            this.elementRef = elementRef;
            this.cdr = cdr;
            this.renderer = renderer;
            this.nzUpdateHostClassService = nzUpdateHostClassService;
            this.ngZone = ngZone;
            this._ghost = false;
            this._search = false;
            this._loading = false;
            this._block = false;
            this.iconOnly = false;
            this.prefixCls = 'ant-btn';
            this.sizeMap = { large: 'lg', small: 'sm' };
            this.nzWave = new NzWaveDirective(this.ngZone, this.elementRef);
            this.el = this.elementRef.nativeElement;
            this.renderer.addClass(this.el, this.prefixCls);
        }
        Object.defineProperty(NzButtonComponent.prototype, "nzBlock", {
            get: /**
             * @return {?}
             */ function () {
                return this._block;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._block = toBoolean(value);
                this.setClassMap();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzButtonComponent.prototype, "nzGhost", {
            get: /**
             * @return {?}
             */ function () {
                return this._ghost;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._ghost = toBoolean(value);
                this.setClassMap();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzButtonComponent.prototype, "nzSearch", {
            get: /**
             * @return {?}
             */ function () {
                return this._search;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._search = toBoolean(value);
                this.setClassMap();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzButtonComponent.prototype, "nzType", {
            get: /**
             * @return {?}
             */ function () {
                return this._type;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._type = value;
                this.setClassMap();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzButtonComponent.prototype, "nzShape", {
            get: /**
             * @return {?}
             */ function () {
                return this._shape;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._shape = value;
                this.setClassMap();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzButtonComponent.prototype, "nzSize", {
            get: /**
             * @return {?}
             */ function () {
                return this._size;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._size = value;
                this.setClassMap();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzButtonComponent.prototype, "nzLoading", {
            get: /**
             * @return {?}
             */ function () {
                return this._loading;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._loading = toBoolean(value);
                this.setClassMap();
                this.updateIconDisplay(value);
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} value
         * @return {?}
         */
        NzButtonComponent.prototype.updateIconDisplay = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                if (this.iconElement) {
                    this.renderer.setStyle(this.iconElement, 'display', value ? 'none' : 'inline-block');
                }
            };
        /** temp solution since no method add classMap to host https://github.com/angular/angular/issues/7289 */
        /**
         * temp solution since no method add classMap to host https://github.com/angular/angular/issues/7289
         * @return {?}
         */
        NzButtonComponent.prototype.setClassMap = /**
         * temp solution since no method add classMap to host https://github.com/angular/angular/issues/7289
         * @return {?}
         */
            function () {
                var _a;
                /** @type {?} */
                var classMap = (_a = {},
                    _a[this.prefixCls + "-" + this.nzType] = this.nzType,
                    _a[this.prefixCls + "-" + this.nzShape] = this.nzShape,
                    _a[this.prefixCls + "-" + this.sizeMap[this.nzSize]] = this.sizeMap[this.nzSize],
                    _a[this.prefixCls + "-loading"] = this.nzLoading,
                    _a[this.prefixCls + "-icon-only"] = this.iconOnly,
                    _a[this.prefixCls + "-background-ghost"] = this.nzGhost,
                    _a["ant-input-search-button"] = this.nzSearch,
                    _a["ant-btn-block"] = this.nzBlock,
                    _a);
                this.nzUpdateHostClassService.updateHostClass(this.el, classMap);
            };
        /**
         * @return {?}
         */
        NzButtonComponent.prototype.checkContent = /**
         * @return {?}
         */
            function () {
                this.moveIcon();
                this.renderer.removeStyle(this.contentElement.nativeElement, 'display');
                /** https://github.com/angular/angular/issues/12530 **/
                if (isEmpty(this.contentElement.nativeElement)) {
                    this.renderer.setStyle(this.contentElement.nativeElement, 'display', 'none');
                    this.iconOnly = !!this.iconElement;
                }
                else {
                    this.renderer.removeStyle(this.contentElement.nativeElement, 'display');
                    this.iconOnly = false;
                }
                this.setClassMap();
                this.updateIconDisplay(this.nzLoading);
                this.cdr.detectChanges();
            };
        /**
         * @return {?}
         */
        NzButtonComponent.prototype.moveIcon = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var firstChildElement = this.findFirstNotEmptyNode(this.contentElement.nativeElement);
                /** @type {?} */
                var lastChildElement = this.findLastNotEmptyNode(this.contentElement.nativeElement);
                if (firstChildElement && (firstChildElement.nodeName === 'I')) {
                    this.renderer.insertBefore(this.el, firstChildElement, this.contentElement.nativeElement);
                    this.iconElement = /** @type {?} */ (firstChildElement);
                }
                else if (lastChildElement && (lastChildElement.nodeName === 'I')) {
                    this.renderer.appendChild(this.el, lastChildElement);
                    this.iconElement = /** @type {?} */ (lastChildElement);
                }
                else {
                    this.iconElement = null;
                }
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzButtonComponent.prototype.findFirstNotEmptyNode = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                /** @type {?} */
                var children = value.childNodes;
                for (var i = 0; i < children.length; i++) {
                    /** @type {?} */
                    var node = children.item(i);
                    if (node && (node.nodeType === 1) && (( /** @type {?} */(node)).outerHTML.toString().trim().length !== 0)) {
                        return node;
                    }
                    else if (node && (node.nodeType === 3) && ((node.textContent.toString().trim().length !== 0))) {
                        return node;
                    }
                }
                return null;
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzButtonComponent.prototype.findLastNotEmptyNode = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                /** @type {?} */
                var children = value.childNodes;
                for (var i = children.length - 1; i >= 0; i--) {
                    /** @type {?} */
                    var node = children.item(i);
                    if (node && (node.nodeType === 1) && (( /** @type {?} */(node)).outerHTML.toString().trim().length !== 0)) {
                        return node;
                    }
                    else if (node && (node.nodeType === 3) && ((node.textContent.toString().trim().length !== 0))) {
                        return node;
                    }
                }
                return null;
            };
        /**
         * @return {?}
         */
        NzButtonComponent.prototype.ngAfterContentInit = /**
         * @return {?}
         */
            function () {
                this.checkContent();
            };
        /**
         * @return {?}
         */
        NzButtonComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.nzWave.ngOnInit();
            };
        /**
         * @return {?}
         */
        NzButtonComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.nzWave.ngOnDestroy();
            };
        NzButtonComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: '[nz-button]',
                        providers: [NzUpdateHostClassService],
                        preserveWhitespaces: false,
                        template: "<i class=\"anticon anticon-spin anticon-loading\" *ngIf=\"nzLoading\"></i>\n<span (cdkObserveContent)=\"checkContent()\" #contentElement><ng-content></ng-content></span>"
                    }] }
        ];
        /** @nocollapse */
        NzButtonComponent.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: i0.ChangeDetectorRef },
                { type: i0.Renderer2 },
                { type: NzUpdateHostClassService },
                { type: i0.NgZone }
            ];
        };
        NzButtonComponent.propDecorators = {
            contentElement: [{ type: i0.ViewChild, args: ['contentElement',] }],
            nzBlock: [{ type: i0.Input }],
            nzGhost: [{ type: i0.Input }],
            nzSearch: [{ type: i0.Input }],
            nzType: [{ type: i0.Input }],
            nzShape: [{ type: i0.Input }],
            nzSize: [{ type: i0.Input }],
            nzLoading: [{ type: i0.Input }],
            nzWave: [{ type: i0.HostBinding, args: ['attr.nz-wave',] }]
        };
        return NzButtonComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzButtonModule = /** @class */ (function () {
        function NzButtonModule() {
        }
        NzButtonModule.decorators = [
            { type: i0.NgModule, args: [{
                        declarations: [NzButtonComponent, NzButtonGroupComponent],
                        exports: [NzButtonComponent, NzButtonGroupComponent],
                        imports: [i1.CommonModule, observers.ObserversModule, NzWaveModule]
                    },] }
        ];
        return NzButtonModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var LoggerService = /** @class */ (function () {
        function LoggerService(_loggerState) {
            this._loggerState = _loggerState;
        }
        /**
         * @param {...?} args
         * @return {?}
         */
        LoggerService.prototype.log = /**
         * @param {...?} args
         * @return {?}
         */
            function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                if (this._loggerState) {
                    // console.log(...args);
                    console.log.apply(console, arguments);
                }
            };
        /**
         * @param {...?} args
         * @return {?}
         */
        LoggerService.prototype.warn = /**
         * @param {...?} args
         * @return {?}
         */
            function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                if (this._loggerState) {
                    // console.warn(...args);
                    console.warn.apply(console, arguments);
                }
            };
        /**
         * @param {...?} args
         * @return {?}
         */
        LoggerService.prototype.error = /**
         * @param {...?} args
         * @return {?}
         */
            function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                if (this._loggerState) {
                    // console.error(...args);
                    console.error.apply(console, arguments);
                }
            };
        /**
         * @param {...?} args
         * @return {?}
         */
        LoggerService.prototype.info = /**
         * @param {...?} args
         * @return {?}
         */
            function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                if (this._loggerState) {
                    // console.log(...args);
                    console.log.apply(console, arguments);
                }
            };
        /**
         * @param {...?} args
         * @return {?}
         */
        LoggerService.prototype.debug = /**
         * @param {...?} args
         * @return {?}
         */
            function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                if (this._loggerState) {
                    /** @type {?} */
                    var arrs = Array.prototype.slice.call(arguments);
                    console.log.apply(console, ['[NG-ZORRO-DEBUG]'].concat(arrs));
                }
            };
        LoggerService.decorators = [
            { type: i0.Injectable }
        ];
        /** @nocollapse */
        LoggerService.ctorParameters = function () {
            return [
                { type: Boolean, decorators: [{ type: i0.Inject, args: [NZ_LOGGER_STATE,] }] }
            ];
        };
        return LoggerService;
    }());
    /** @type {?} */
    var NZ_LOGGER_STATE = new i0.InjectionToken('nz-logger-state');
    /**
     * @param {?} exist
     * @param {?} loggerState
     * @return {?}
     */
    function LOGGER_SERVICE_PROVIDER_FACTORY(exist, loggerState) { return exist || new LoggerService(loggerState); }
    /** @type {?} */
    var LOGGER_SERVICE_PROVIDER = {
        provide: LoggerService,
        useFactory: LOGGER_SERVICE_PROVIDER_FACTORY,
        deps: [[new i0.Optional(), new i0.SkipSelf(), LoggerService], NZ_LOGGER_STATE]
    };

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var LoggerModule = /** @class */ (function () {
        function LoggerModule() {
        }
        LoggerModule.decorators = [
            { type: i0.NgModule, args: [{
                        providers: [
                            { provide: NZ_LOGGER_STATE, useValue: false },
                            LOGGER_SERVICE_PROVIDER,
                        ],
                    },] }
        ];
        return LoggerModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var CalendarLocale = {
        today: '今天',
        now: '此刻',
        backToToday: '返回今天',
        ok: '确定',
        timeSelect: '选择时间',
        dateSelect: '选择日期',
        clear: '清除',
        month: '月',
        year: '年',
        previousMonth: '上个月 (翻页上键)',
        nextMonth: '下个月 (翻页下键)',
        monthSelect: '选择月份',
        yearSelect: '选择年份',
        decadeSelect: '选择年代',
        yearFormat: 'YYYY年',
        dayFormat: 'D日',
        dateFormat: 'YYYY年M月D日',
        dateTimeFormat: 'YYYY年M月D日 HH时mm分ss秒',
        previousYear: '上一年 (Control键加左方向键)',
        nextYear: '下一年 (Control键加右方向键)',
        previousDecade: '上一年代',
        nextDecade: '下一年代',
        previousCentury: '上一世纪',
        nextCentury: '下一世纪',
    };

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var locale = {
        placeholder: '请选择时间',
    };

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var locale$1 = {
        lang: __assign({ placeholder: '请选择日期', rangePlaceholder: ['开始日期', '结束日期'] }, CalendarLocale),
        timePickerLocale: __assign({}, locale),
    };
    // should add whitespace between char in Button
    locale$1.lang.ok = '确 定';

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var Pagination = {
        // Options.jsx
        items_per_page: '条/页',
        jump_to: '跳至',
        jump_to_confirm: '确定',
        page: '页',
        // Pagination.jsx
        prev_page: '上一页',
        next_page: '下一页',
        prev_5: '向前 5 页',
        next_5: '向后 5 页',
        prev_3: '向前 3 页',
        next_3: '向后 3 页',
    };

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var zh_CN = {
        locale: 'zh-cn',
        Pagination: Pagination,
        DatePicker: locale$1,
        TimePicker: locale,
        Calendar: CalendarLocale,
        Table: {
            filterTitle: '筛选',
            filterConfirm: '确定',
            filterReset: '重置',
            emptyText: '暂无数据',
            selectAll: '全选当页',
            selectInvert: '反选当页',
        },
        Modal: {
            okText: '确定',
            cancelText: '取消',
            justOkText: '知道了',
        },
        Popconfirm: {
            cancelText: '取消',
            okText: '确定',
        },
        Transfer: {
            notFoundContent: '无匹配结果',
            searchPlaceholder: '请输入搜索内容',
            itemUnit: '项',
            itemsUnit: '项',
        },
        Select: {
            notFoundContent: '无匹配结果',
        },
        Upload: {
            uploading: '文件上传中',
            removeFile: '删除文件',
            uploadError: '上传错误',
            previewFile: '预览文件',
        },
    };

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var NZ_I18N = new i0.InjectionToken('nz-i18n');

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzI18nService = /** @class */ (function () {
        function NzI18nService(locale, _logger, datePipe) {
            this._logger = _logger;
            this.datePipe = datePipe;
            this._change = new rxjs.BehaviorSubject(this._locale);
            this.setLocale(locale || zh_CN);
        }
        Object.defineProperty(NzI18nService.prototype, "localeChange", {
            get: /**
             * @return {?}
             */ function () {
                return this._change.asObservable();
            },
            enumerable: true,
            configurable: true
        });
        // [NOTE] Performance issue: this method may called by every change detections
        // TODO: cache more deeply paths for performance
        /* tslint:disable-next-line:no-any */
        /**
         * @param {?} path
         * @param {?=} data
         * @return {?}
         */
        NzI18nService.prototype.translate = /**
         * @param {?} path
         * @param {?=} data
         * @return {?}
         */
            function (path, data) {
                /** @type {?} */
                var content = /** @type {?} */ (this._getObjectPath(this._locale, path));
                if (typeof content === 'string') {
                    if (data) {
                        Object.keys(data).forEach(function (key) { return content = content.replace(new RegExp("%" + key + "%", 'g'), data[key]); });
                    }
                    return content;
                }
                return path;
            };
        /**
         * Set/Change current locale globally throughout the WHOLE application
         * [NOTE] If called at runtime, rendered interface may not change along with the locale change (because this do not trigger another render schedule)
         * @param locale The translating letters
         */
        /**
         * Set/Change current locale globally throughout the WHOLE application
         * [NOTE] If called at runtime, rendered interface may not change along with the locale change (because this do not trigger another render schedule)
         * @param {?} locale The translating letters
         * @return {?}
         */
        NzI18nService.prototype.setLocale = /**
         * Set/Change current locale globally throughout the WHOLE application
         * [NOTE] If called at runtime, rendered interface may not change along with the locale change (because this do not trigger another render schedule)
         * @param {?} locale The translating letters
         * @return {?}
         */
            function (locale) {
                if (this._locale && this._locale.locale === locale.locale) {
                    return;
                }
                this._locale = locale;
                this._change.next(locale);
            };
        /**
         * @return {?}
         */
        NzI18nService.prototype.getLocale = /**
         * @return {?}
         */
            function () {
                return this._locale;
            };
        /**
         * @return {?}
         */
        NzI18nService.prototype.getLocaleId = /**
         * @return {?}
         */
            function () {
                return this._locale ? this._locale.locale : '';
            };
        /**
         * Get locale data
         * @param path dot paths for finding exist value from locale data, eg. "a.b.c"
         * @param defaultValue default value if the result is not "truthy"
         */
        /**
         * Get locale data
         * @param {?=} path dot paths for finding exist value from locale data, eg. "a.b.c"
         * @param {?=} defaultValue default value if the result is not "truthy"
         * @return {?}
         */
        NzI18nService.prototype.getLocaleData = /**
         * Get locale data
         * @param {?=} path dot paths for finding exist value from locale data, eg. "a.b.c"
         * @param {?=} defaultValue default value if the result is not "truthy"
         * @return {?}
         */
            function (path, defaultValue) {
                /** @type {?} */
                var result = path ? this._getObjectPath(this._locale, path) : this._locale;
                return result || defaultValue;
            };
        /**
         * @param {?} date
         * @param {?=} format
         * @param {?=} locale
         * @return {?}
         */
        NzI18nService.prototype.formatDate = /**
         * @param {?} date
         * @param {?=} format
         * @param {?=} locale
         * @return {?}
         */
            function (date, format, locale) {
                return date ? this.datePipe.transform(date, format, null, locale || this.getLocale().locale) : '';
            };
        /**
         * Format date with compatible for the format of moment and others
         * Why? For now, we need to support the existing language formats in AntD, and AntD uses the default temporal syntax.
         */
        /**
         * Format date with compatible for the format of moment and others
         * Why? For now, we need to support the existing language formats in AntD, and AntD uses the default temporal syntax.
         * @param {?} date
         * @param {?=} format
         * @param {?=} locale
         * @return {?}
         */
        NzI18nService.prototype.formatDateCompatible = /**
         * Format date with compatible for the format of moment and others
         * Why? For now, we need to support the existing language formats in AntD, and AntD uses the default temporal syntax.
         * @param {?} date
         * @param {?=} format
         * @param {?=} locale
         * @return {?}
         */
            function (date, format, locale) {
                return this.formatDate(date, this.compatDateFormat(format), locale);
            };
        /**
         * @param {?} text
         * @return {?}
         */
        NzI18nService.prototype.parseDate = /**
         * @param {?} text
         * @return {?}
         */
            function (text) {
                if (!text) {
                    return;
                }
                return parse(text);
            };
        /**
         * @param {?} text
         * @return {?}
         */
        NzI18nService.prototype.parseTime = /**
         * @param {?} text
         * @return {?}
         */
            function (text) {
                if (!text) {
                    return;
                }
                return parse("1970-01-01 " + text);
            };
        /**
         * @param {?} obj
         * @param {?} path
         * @return {?}
         */
        NzI18nService.prototype._getObjectPath = /**
         * @param {?} obj
         * @param {?} path
         * @return {?}
         */
            function (obj, path) {
                /** @type {?} */
                var res = obj;
                /** @type {?} */
                var paths = path.split('.');
                /** @type {?} */
                var depth = paths.length;
                /** @type {?} */
                var index = 0;
                while (res && index < depth) {
                    res = res[paths[index++]];
                }
                return index === depth ? res : null;
            };
        /**
         * Compatible translate the moment-like format pattern to angular's pattern
         * Why? For now, we need to support the existing language formats in AntD, and AntD uses the default temporal syntax.
         *
         * TODO: compare and complete all format patterns
         * Each format docs as below:
         * @link https://momentjs.com/docs/#/displaying/format/
         * @link https://angular.io/api/common/DatePipe#description
         * @param {?} format input format pattern
         * @return {?}
         */
        NzI18nService.prototype.compatDateFormat = /**
         * Compatible translate the moment-like format pattern to angular's pattern
         * Why? For now, we need to support the existing language formats in AntD, and AntD uses the default temporal syntax.
         *
         * TODO: compare and complete all format patterns
         * Each format docs as below:
         * @link https://momentjs.com/docs/#/displaying/format/
         * @link https://angular.io/api/common/DatePipe#description
         * @param {?} format input format pattern
         * @return {?}
         */
            function (format) {
                return format && format
                    .replace(/Y/g, 'y') // only support y, yy, yyy, yyyy
                    .replace(/D/g, 'd'); // d, dd represent of D, DD for momentjs, others are not support
            };
        NzI18nService.decorators = [
            { type: i0.Injectable }
        ];
        /** @nocollapse */
        NzI18nService.ctorParameters = function () {
            return [
                { type: undefined, decorators: [{ type: i0.Inject, args: [NZ_I18N,] }] },
                { type: LoggerService },
                { type: i1.DatePipe }
            ];
        };
        return NzI18nService;
    }());
    /**
     * @param {?} exist
     * @param {?} locale
     * @param {?} logger
     * @param {?} datePipe
     * @return {?}
     */
    function NZ_LOCALE_SERVICE_PROVIDER_FACTORY(exist, locale, logger, datePipe) {
        return exist || new NzI18nService(locale, logger, datePipe);
    }
    /** @type {?} */
    var NZ_I18N_SERVICE_PROVIDER = {
        provide: NzI18nService,
        useFactory: NZ_LOCALE_SERVICE_PROVIDER_FACTORY,
        deps: [[new i0.Optional(), new i0.SkipSelf(), NzI18nService], NZ_I18N, LoggerService, i1.DatePipe]
    };

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzI18nPipe = /** @class */ (function () {
        function NzI18nPipe(_locale) {
            this._locale = _locale;
        }
        /**
         * @param {?} path
         * @param {?=} keyValue
         * @return {?}
         */
        NzI18nPipe.prototype.transform = /**
         * @param {?} path
         * @param {?=} keyValue
         * @return {?}
         */
            function (path, keyValue) {
                return this._locale.translate(path, keyValue);
            };
        NzI18nPipe.decorators = [
            { type: i0.Pipe, args: [{
                        name: 'nzI18n'
                    },] }
        ];
        /** @nocollapse */
        NzI18nPipe.ctorParameters = function () {
            return [
                { type: NzI18nService }
            ];
        };
        return NzI18nPipe;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var ɵ0 = zh_CN;
    var NzI18nModule = /** @class */ (function () {
        function NzI18nModule() {
        }
        NzI18nModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [LoggerModule],
                        declarations: [NzI18nPipe],
                        exports: [NzI18nPipe],
                        providers: [
                            { provide: NZ_I18N, useValue: ɵ0 },
                            i1.DatePipe,
                            NZ_I18N_SERVICE_PROVIDER
                        ]
                    },] }
        ];
        return NzI18nModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzRadioGroupComponent = /** @class */ (function () {
        function NzRadioGroupComponent(elementRef) {
            this.elementRef = elementRef;
            this._size = 'default';
            // ngModel Access
            this.onChange = function () { return null; };
            this.onTouched = function () { return null; };
            this.radios = [];
            this.nzButtonStyle = 'outline';
            this.el = this.elementRef.nativeElement;
        }
        Object.defineProperty(NzRadioGroupComponent.prototype, "nzSize", {
            get: /**
             * @return {?}
             */ function () {
                return this._size;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._size = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzRadioGroupComponent.prototype, "nzDisabled", {
            get: /**
             * @return {?}
             */ function () {
                return this._disabled;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._disabled = toBoolean(value);
                this.updateDisabledState();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzRadioGroupComponent.prototype, "nzName", {
            get: /**
             * @return {?}
             */ function () {
                return this._name;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._name = value;
                this.updateChildrenName();
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzRadioGroupComponent.prototype.updateDisabledState = /**
         * @return {?}
         */
            function () {
                var _this = this;
                if (isNotNil(this.nzDisabled)) {
                    this.radios.forEach(function (radio) {
                        radio.nzDisabled = _this.nzDisabled;
                    });
                }
            };
        /**
         * @return {?}
         */
        NzRadioGroupComponent.prototype.updateChildrenName = /**
         * @return {?}
         */
            function () {
                var _this = this;
                if (this.nzName) {
                    this.radios.forEach(function (item) {
                        item.name = _this.nzName;
                    });
                }
            };
        /**
         * @return {?}
         */
        NzRadioGroupComponent.prototype.syncCheckedValue = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.radios.forEach(function (item) {
                    item.nzChecked = item.nzValue === _this.value;
                });
            };
        Object.defineProperty(NzRadioGroupComponent.prototype, "isLarge", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzSize === 'large';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzRadioGroupComponent.prototype, "isSmall", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzSize === 'small';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzRadioGroupComponent.prototype, "isSolid", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzButtonStyle === 'solid';
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} radio
         * @return {?}
         */
        NzRadioGroupComponent.prototype.addRadio = /**
         * @param {?} radio
         * @return {?}
         */
            function (radio) {
                this.radios.push(radio);
                radio.nzChecked = radio.nzValue === this.value;
            };
        /**
         * @param {?} radio
         * @return {?}
         */
        NzRadioGroupComponent.prototype.selectRadio = /**
         * @param {?} radio
         * @return {?}
         */
            function (radio) {
                this.updateValue(radio.nzValue, true);
            };
        /**
         * @param {?} value
         * @param {?} emit
         * @return {?}
         */
        NzRadioGroupComponent.prototype.updateValue = /**
         * @param {?} value
         * @param {?} emit
         * @return {?}
         */
            function (value, emit) {
                this.value = value;
                this.syncCheckedValue();
                if (emit) {
                    this.onChange(value);
                }
            };
        /**
         * @return {?}
         */
        NzRadioGroupComponent.prototype.ngAfterContentInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.syncCheckedValue();
                this.updateChildrenName();
                Promise.resolve().then(function () {
                    _this.updateDisabledState();
                });
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzRadioGroupComponent.prototype.writeValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.updateValue(value, false);
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzRadioGroupComponent.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onChange = fn;
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzRadioGroupComponent.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onTouched = fn;
            };
        /**
         * @param {?} isDisabled
         * @return {?}
         */
        NzRadioGroupComponent.prototype.setDisabledState = /**
         * @param {?} isDisabled
         * @return {?}
         */
            function (isDisabled) {
                this.nzDisabled = isDisabled;
            };
        NzRadioGroupComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-radio-group',
                        preserveWhitespaces: false,
                        template: "<ng-content></ng-content>",
                        host: {
                            '[class.ant-radio-group]': 'true'
                        },
                        providers: [
                            {
                                provide: forms.NG_VALUE_ACCESSOR,
                                useExisting: i0.forwardRef(function () { return NzRadioGroupComponent; }),
                                multi: true
                            }
                        ]
                    }] }
        ];
        /** @nocollapse */
        NzRadioGroupComponent.ctorParameters = function () {
            return [
                { type: i0.ElementRef }
            ];
        };
        NzRadioGroupComponent.propDecorators = {
            nzSize: [{ type: i0.Input }],
            nzDisabled: [{ type: i0.Input }],
            nzName: [{ type: i0.Input }],
            nzButtonStyle: [{ type: i0.Input }],
            isLarge: [{ type: i0.HostBinding, args: ['class.ant-radio-group-large',] }],
            isSmall: [{ type: i0.HostBinding, args: ['class.ant-radio-group-small',] }],
            isSolid: [{ type: i0.HostBinding, args: ['class.ant-radio-group-solid',] }]
        };
        return NzRadioGroupComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzRadioComponent = /** @class */ (function () {
        /* tslint:disable-next-line:no-any */
        function NzRadioComponent(nzRadioGroup, renderer, document) {
            this.nzRadioGroup = nzRadioGroup;
            this.renderer = renderer;
            this.document = document;
            this._checked = false;
            this._disabled = false;
            this._autoFocus = false;
            this.isInit = false;
            this.prefixCls = 'ant-radio';
            this.onChange = function () { return null; };
            this.onTouched = function () { return null; };
        }
        Object.defineProperty(NzRadioComponent.prototype, "nzChecked", {
            get: /**
             * @return {?}
             */ function () {
                return this._checked;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._checked = toBoolean(value);
                this.setClassMap();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzRadioComponent.prototype, "nzDisabled", {
            get: /**
             * @return {?}
             */ function () {
                return this._disabled;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._disabled = toBoolean(value);
                this.setClassMap();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzRadioComponent.prototype, "nzAutoFocus", {
            get: /**
             * @return {?}
             */ function () {
                return this._autoFocus;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._autoFocus = toBoolean(value);
                this.updateAutoFocus();
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzRadioComponent.prototype.updateAutoFocus = /**
         * @return {?}
         */
            function () {
                if (this.isInit) {
                    if (this.nzAutoFocus) {
                        this.renderer.setAttribute(this.inputElement.nativeElement, 'autofocus', 'autofocus');
                    }
                    else {
                        this.renderer.removeAttribute(this.inputElement.nativeElement, 'autofocus');
                    }
                }
            };
        /**
         * @return {?}
         */
        NzRadioComponent.prototype.updateInputFocus = /**
         * @return {?}
         */
            function () {
                if (this.inputElement) {
                    if (this.nzChecked) {
                        if (this.document.activeElement.nodeName === 'BODY') {
                            this.inputElement.nativeElement.focus();
                        }
                    }
                    else {
                        this.inputElement.nativeElement.blur();
                    }
                }
            };
        /**
         * @param {?} e
         * @return {?}
         */
        NzRadioComponent.prototype.onClick = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                e.preventDefault();
                this.setClassMap();
                if (this.nzDisabled || this.nzChecked) {
                    this.updateInputFocus();
                    return;
                }
                else {
                    if (this.nzRadioGroup) {
                        this.nzRadioGroup.selectRadio(this);
                    }
                    else {
                        this.updateValue(true);
                    }
                    this.updateInputFocus();
                }
            };
        /**
         * @return {?}
         */
        NzRadioComponent.prototype.onBlur = /**
         * @return {?}
         */
            function () {
                this.onTouched();
                if (this.nzRadioGroup) {
                    this.nzRadioGroup.onTouched();
                }
            };
        /**
         * @return {?}
         */
        NzRadioComponent.prototype.setClassMap = /**
         * @return {?}
         */
            function () {
                var _a;
                this.classMap = (_a = {},
                    _a[this.prefixCls] = true,
                    _a[this.prefixCls + "-checked"] = this.nzChecked,
                    _a[this.prefixCls + "-disabled"] = this.nzDisabled,
                    _a);
            };
        /**
         * @return {?}
         */
        NzRadioComponent.prototype.focus = /**
         * @return {?}
         */
            function () {
                this.inputElement.nativeElement.focus();
            };
        /**
         * @return {?}
         */
        NzRadioComponent.prototype.blur = /**
         * @return {?}
         */
            function () {
                this.inputElement.nativeElement.blur();
                this.onBlur();
            };
        /**
         * @return {?}
         */
        NzRadioComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                if (this.nzRadioGroup) {
                    this.nzRadioGroup.addRadio(this);
                }
                this.setClassMap();
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzRadioComponent.prototype.updateValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.onChange(value);
                this.nzChecked = value;
                this.setClassMap();
            };
        /**
         * @param {?} isDisabled
         * @return {?}
         */
        NzRadioComponent.prototype.setDisabledState = /**
         * @param {?} isDisabled
         * @return {?}
         */
            function (isDisabled) {
                this.nzDisabled = isDisabled;
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzRadioComponent.prototype.writeValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.nzChecked = value;
                this.setClassMap();
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzRadioComponent.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onChange = fn;
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzRadioComponent.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onTouched = fn;
            };
        /**
         * @return {?}
         */
        NzRadioComponent.prototype.ngAfterViewInit = /**
         * @return {?}
         */
            function () {
                this.isInit = true;
                this.updateAutoFocus();
                this.updateInputFocus();
            };
        NzRadioComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: '[nz-radio]',
                        preserveWhitespaces: false,
                        template: "<span [ngClass]=\"classMap\">\n  <input #inputElement type=\"radio\" class=\"ant-radio-input\" [disabled]=\"nzDisabled\" [(ngModel)]=\"nzChecked\" (blur)=\"onBlur()\" [attr.name]=\"name\">\n  <span class=\"ant-radio-inner\"></span>\n</span>\n<span><ng-content></ng-content></span>",
                        host: {
                            '[class.ant-radio-wrapper]': 'true',
                            '[class.ant-radio-wrapper-checked]': 'nzChecked',
                            '[class.ant-radio-wrapper-disabled]': 'nzDisabled'
                        },
                        providers: [
                            {
                                provide: forms.NG_VALUE_ACCESSOR,
                                useExisting: i0.forwardRef(function () { return NzRadioComponent; }),
                                multi: true
                            }
                        ]
                    }] }
        ];
        /** @nocollapse */
        NzRadioComponent.ctorParameters = function () {
            return [
                { type: NzRadioGroupComponent, decorators: [{ type: i0.Optional }] },
                { type: i0.Renderer2 },
                { type: undefined, decorators: [{ type: i0.Inject, args: [i1.DOCUMENT,] }] }
            ];
        };
        NzRadioComponent.propDecorators = {
            inputElement: [{ type: i0.ViewChild, args: ['inputElement',] }],
            nzValue: [{ type: i0.Input }],
            nzDisabled: [{ type: i0.Input }],
            nzAutoFocus: [{ type: i0.Input }],
            onClick: [{ type: i0.HostListener, args: ['click', ['$event'],] }]
        };
        return NzRadioComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzRadioButtonComponent = /** @class */ (function (_super) {
        __extends(NzRadioButtonComponent, _super);
        function NzRadioButtonComponent() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.prefixCls = 'ant-radio-button';
            return _this;
        }
        NzRadioButtonComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: '[nz-radio-button]',
                        preserveWhitespaces: false,
                        template: "<span [ngClass]=\"classMap\">\n  <input type=\"radio\" #inputElement class=\"ant-radio-button-input\" [disabled]=\"nzDisabled\" [(ngModel)]=\"nzChecked\" (blur)=\"onBlur()\" [attr.name]=\"name\">\n  <span class=\"ant-radio-button-inner\"></span>\n</span>\n<span><ng-content></ng-content></span>",
                        host: {
                            '[class.ant-radio-button-wrapper]': 'true',
                            '[class.ant-radio-button-wrapper-checked]': 'nzChecked',
                            '[class.ant-radio-button-wrapper-disabled]': 'nzDisabled'
                        }
                    }] }
        ];
        return NzRadioButtonComponent;
    }(NzRadioComponent));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzRadioModule = /** @class */ (function () {
        function NzRadioModule() {
        }
        NzRadioModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [i1.CommonModule, forms.FormsModule],
                        exports: [NzRadioComponent, NzRadioButtonComponent, NzRadioGroupComponent],
                        declarations: [NzRadioComponent, NzRadioButtonComponent, NzRadioGroupComponent]
                    },] }
        ];
        return NzRadioModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzOptionComponent = /** @class */ (function () {
        function NzOptionComponent() {
            this._disabled = false;
            this._customContent = false;
        }
        Object.defineProperty(NzOptionComponent.prototype, "nzDisabled", {
            get: /**
             * @return {?}
             */ function () {
                return this._disabled;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._disabled = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzOptionComponent.prototype, "nzCustomContent", {
            get: /**
             * @return {?}
             */ function () {
                return this._customContent;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._customContent = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        NzOptionComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-option',
                        template: "<ng-template>\n  <ng-content></ng-content>\n</ng-template>"
                    }] }
        ];
        NzOptionComponent.propDecorators = {
            template: [{ type: i0.ViewChild, args: [i0.TemplateRef,] }],
            nzLabel: [{ type: i0.Input }],
            nzValue: [{ type: i0.Input }],
            nzDisabled: [{ type: i0.Input }],
            nzCustomContent: [{ type: i0.Input }]
        };
        return NzOptionComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzOptionLiComponent = /** @class */ (function () {
        function NzOptionLiComponent(elementRef) {
            this.elementRef = elementRef;
            this.selected = false;
            this.active = false;
            this.nzShowActive = true;
            this.el = elementRef.nativeElement;
        }
        Object.defineProperty(NzOptionLiComponent.prototype, "nzActiveOption", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value) {
                    this.active = this.compareWith(value.nzValue, this.nzOption.nzValue);
                }
                else {
                    this.active = false;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzOptionLiComponent.prototype, "nzListOfSelectedValue", {
            set: /**
             * @param {?} valueList
             * @return {?}
             */ function (valueList) {
                var _this = this;
                this.selected = isNotNil(valueList.find(function (v) { return _this.compareWith(v, _this.nzOption.nzValue); }));
            },
            enumerable: true,
            configurable: true
        });
        NzOptionLiComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: '[nz-option-li]',
                        template: "<ng-container *ngIf=\"nzOption.nzCustomContent\">\n  <ng-template [ngTemplateOutlet]=\"nzOption.template\"></ng-template>\n</ng-container>\n<ng-container *ngIf=\"!nzOption.nzCustomContent\">\n  {{nzOption.nzLabel}}\n</ng-container>",
                        host: {
                            '[class.ant-select-dropdown-menu-item]': 'true',
                            '[class.ant-select-dropdown-menu-item-selected]': 'selected && !nzOption.nzDisabled',
                            '[class.ant-select-dropdown-menu-item-disabled]': 'nzOption.nzDisabled',
                            '[class.ant-select-dropdown-menu-item-active]': 'active && !nzOption.nzDisabled && nzShowActive && !selected',
                            '[attr.unselectable]': '"unselectable"',
                            '[style.user-select]': '"none"'
                        }
                    }] }
        ];
        /** @nocollapse */
        NzOptionLiComponent.ctorParameters = function () {
            return [
                { type: i0.ElementRef }
            ];
        };
        NzOptionLiComponent.propDecorators = {
            nzOption: [{ type: i0.Input }],
            nzShowActive: [{ type: i0.Input }],
            compareWith: [{ type: i0.Input }],
            nzActiveOption: [{ type: i0.Input }],
            nzListOfSelectedValue: [{ type: i0.Input }]
        };
        return NzOptionLiComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzOptionPipe = /** @class */ (function () {
        function NzOptionPipe() {
        }
        /**
         * @param {?} options
         * @param {?} input
         * @param {?} filterOption
         * @param {?} serverSearch
         * @return {?}
         */
        NzOptionPipe.prototype.transform = /**
         * @param {?} options
         * @param {?} input
         * @param {?} filterOption
         * @param {?} serverSearch
         * @return {?}
         */
            function (options, input, filterOption, serverSearch) {
                if (serverSearch || !input) {
                    return options;
                }
                else {
                    return ( /** @type {?} */(options)).filter(function (o) { return filterOption(input, o); });
                }
            };
        NzOptionPipe.decorators = [
            { type: i0.Pipe, args: [{ name: 'nzFilterOptionPipe' },] }
        ];
        return NzOptionPipe;
    }());
    var NzSubOptionPipe = /** @class */ (function () {
        function NzSubOptionPipe() {
        }
        /**
         * @param {?} groups
         * @param {?} input
         * @param {?} filterOption
         * @param {?} serverSearch
         * @return {?}
         */
        NzSubOptionPipe.prototype.transform = /**
         * @param {?} groups
         * @param {?} input
         * @param {?} filterOption
         * @param {?} serverSearch
         * @return {?}
         */
            function (groups, input, filterOption, serverSearch) {
                if (serverSearch || !input) {
                    return groups;
                }
                else {
                    return ( /** @type {?} */(groups)).filter(function (g) {
                        return g.listOfNzOptionComponent.some(function (o) { return filterOption(input, o); });
                    });
                }
            };
        NzSubOptionPipe.decorators = [
            { type: i0.Pipe, args: [{ name: 'nzSubFilterOptionPipe' },] }
        ];
        return NzSubOptionPipe;
    }());
    /**
     * @param {?} input
     * @param {?} option
     * @return {?}
     */
    function defaultFilterOption(input, option) {
        if (option && option.nzLabel) {
            return option.nzLabel.toLowerCase().indexOf(input.toLowerCase()) > -1;
        }
        else {
            return false;
        }
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzOptionContainerComponent = /** @class */ (function () {
        function NzOptionContainerComponent() {
            this.isInit = false;
            this.isAddTagOptionDisplay = false;
            this.listOfAllTemplateOption = [];
            this.listOfTagOption = [];
            this.listOfFilterOption = [];
            // tslint:disable-next-line:no-any
            this.nzListOfSelectedValueChange = new i0.EventEmitter();
            this.nzListOfTemplateOptionChange = new i0.EventEmitter();
            this.nzClickOption = new i0.EventEmitter();
            this.nzScrollToBottom = new i0.EventEmitter();
            this.nzMode = 'default';
            this.nzServerSearch = false;
            this.nzFilterOption = defaultFilterOption;
            this.nzMaxMultipleCount = Infinity;
            // tslint:disable-next-line:no-any
            this.compareWith = function (o1, o2) { return o1 === o2; };
        }
        Object.defineProperty(NzOptionContainerComponent.prototype, "nzSearchValue", {
            get: /**
             * @return {?}
             */ function () {
                return this._searchValue;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._searchValue = value;
                this.updateAddTagOptionDisplay();
                this.updateListOfFilterOption();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzOptionContainerComponent.prototype, "nzListOfSelectedValue", {
            // tslint:disable-next-line:no-any
            get: /**
             * @return {?}
             */ function () {
                return this._listOfSelectedValue;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (this._listOfSelectedValue !== value) {
                    this._listOfSelectedValue = value;
                    /** should clear activedOption when listOfSelectedValue change **/
                    this.clearActivatedOption();
                    this.refreshAllOptionStatus(false);
                }
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzOptionContainerComponent.prototype.addTagOption = /**
         * @return {?}
         */
            function () {
                if (this.nzListOfSelectedValue.length < this.nzMaxMultipleCount) {
                    this.nzListOfSelectedValue = __spread(this.nzListOfSelectedValue, [this.nzSearchValue]);
                    this.nzListOfSelectedValueChange.emit(this.nzListOfSelectedValue);
                }
            };
        /**
         * @param {?} option
         * @param {?} isPressEnter
         * @return {?}
         */
        NzOptionContainerComponent.prototype.clickOption = /**
         * @param {?} option
         * @param {?} isPressEnter
         * @return {?}
         */
            function (option, isPressEnter) {
                this.updateSelectedOption(option, isPressEnter);
                this.nzClickOption.emit();
            };
        /**
         * @param {?} e
         * @return {?}
         */
        NzOptionContainerComponent.prototype.onKeyDownUl = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                var _this = this;
                if ([38, 40, 13].indexOf(e.keyCode) > -1) {
                    e.preventDefault();
                    /** @type {?} */
                    var activeIndex = this.listOfFilterOption.findIndex(function (item) { return item === _this.activatedOption; });
                    if (e.keyCode === 38) {
                        /** @type {?} */
                        var preIndex = activeIndex > 0 ? (activeIndex - 1) : (this.listOfFilterOption.length - 1);
                        this.setActiveOption(this.listOfFilterOption[preIndex]);
                    }
                    else if (e.keyCode === 40) {
                        /** @type {?} */
                        var nextIndex = activeIndex < this.listOfFilterOption.length - 1 ? (activeIndex + 1) : 0;
                        this.setActiveOption(this.listOfFilterOption[nextIndex]);
                    }
                    else if (e.keyCode === 13) {
                        // enter
                        if (this.isTagsMode) {
                            if (!this.isAddTagOptionDisplay) {
                                this.clickOption(this.activatedOption, true);
                            }
                            else {
                                this.addTagOption();
                                this.nzClickOption.emit();
                            }
                        }
                        else {
                            this.clickOption(this.activatedOption, true);
                        }
                    }
                }
            };
        /**
         * @return {?}
         */
        NzOptionContainerComponent.prototype.resetActiveOption = /**
         * @return {?}
         */
            function () {
                var _this = this;
                /** @type {?} */
                var firstActiveOption = this.listOfAllTemplateOption.concat(this.listOfTagOption).find(function (item) { return _this.compareWith(item.nzValue, _this.nzListOfSelectedValue[0]); });
                this.setActiveOption(firstActiveOption);
            };
        /**
         * @return {?}
         */
        NzOptionContainerComponent.prototype.clearActivatedOption = /**
         * @return {?}
         */
            function () {
                this.setActiveOption(null);
            };
        /**
         * @param {?} option
         * @param {?=} scroll
         * @return {?}
         */
        NzOptionContainerComponent.prototype.setActiveOption = /**
         * @param {?} option
         * @param {?=} scroll
         * @return {?}
         */
            function (option, scroll) {
                if (scroll === void 0) {
                    scroll = true;
                }
                this.activatedOption = option;
                if (scroll) {
                    this.scrollIntoView();
                }
            };
        /**
         * @return {?}
         */
        NzOptionContainerComponent.prototype.scrollIntoView = /**
         * @return {?}
         */
            function () {
                var _this = this;
                if (this.listOfNzOptionLiComponent && this.listOfNzOptionLiComponent.length) {
                    /** @type {?} */
                    var targetOption_1 = this.listOfNzOptionLiComponent.find(function (o) { return o.nzOption === _this.activatedOption; });
                    /* tslint:disable-next-line:no-string-literal */
                    if (targetOption_1 && targetOption_1.el && targetOption_1.el['scrollIntoViewIfNeeded']) {
                        /* tslint:disable-next-line:no-string-literal */
                        setTimeout(function () { return targetOption_1.el['scrollIntoViewIfNeeded'](false); }, 150);
                    }
                }
            };
        /**
         * @param {?} option
         * @param {?} isPressEnter
         * @return {?}
         */
        NzOptionContainerComponent.prototype.updateSelectedOption = /**
         * @param {?} option
         * @param {?} isPressEnter
         * @return {?}
         */
            function (option, isPressEnter) {
                var _this = this;
                /** update listOfSelectedOption -> update nzListOfSelectedValue -> emit nzListOfSelectedValueChange **/
                if (option && !option.nzDisabled) {
                    /** @type {?} */
                    var changed = false;
                    this.setActiveOption(option);
                    /** @type {?} */
                    var listOfSelectedValue = __spread(this.nzListOfSelectedValue);
                    if (this.isMultipleOrTags) {
                        /** @type {?} */
                        var targetValue = listOfSelectedValue.find(function (o) { return _this.compareWith(o, option.nzValue); });
                        if (isNotNil(targetValue)) {
                            if (!isPressEnter) {
                                /** should not toggle option when press enter **/
                                listOfSelectedValue.splice(listOfSelectedValue.indexOf(targetValue), 1);
                                changed = true;
                            }
                        }
                        else if (this.nzListOfSelectedValue.length < this.nzMaxMultipleCount) {
                            listOfSelectedValue.push(option.nzValue);
                            changed = true;
                        }
                    }
                    else if (!this.compareWith(listOfSelectedValue[0], option.nzValue)) {
                        listOfSelectedValue = [option.nzValue];
                        changed = true;
                    }
                    /** update selectedValues when click option **/
                    if (changed) {
                        this._listOfSelectedValue = listOfSelectedValue;
                        this.nzListOfSelectedValueChange.emit(this.nzListOfSelectedValue);
                        if (this.isTagsMode) {
                            this.refreshAllOptionStatus(false);
                        }
                    }
                }
            };
        /**
         * @return {?}
         */
        NzOptionContainerComponent.prototype.refreshListOfTagOption = /**
         * @return {?}
         */
            function () {
                var _this = this;
                if (this.isTagsMode) {
                    /** *
                     * refresh tags option *
                      @type {?} */
                    var listOfTagsOption_1 = [];
                    this.nzListOfSelectedValue.forEach(function (value) {
                        /** @type {?} */
                        var existedOption = _this.listOfAllTemplateOption.find(function (o) { return _this.compareWith(o.nzValue, value); });
                        if (!existedOption) {
                            /** @type {?} */
                            var nzOptionComponent = new NzOptionComponent();
                            nzOptionComponent.nzValue = value;
                            nzOptionComponent.nzLabel = value;
                            listOfTagsOption_1.push(nzOptionComponent);
                        }
                    });
                    this.listOfTagOption = listOfTagsOption_1;
                }
            };
        /**
         * @return {?}
         */
        NzOptionContainerComponent.prototype.refreshListOfAllTemplateOption = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.listOfAllTemplateOption = this.listOfNzOptionComponent.toArray().concat(this.listOfNzOptionGroupComponent.toArray().reduce(function (pre, cur) { return __spread(pre, cur.listOfNzOptionComponent.toArray()); }, []));
                Promise.resolve().then(function () { return _this.nzListOfTemplateOptionChange.emit(_this.listOfAllTemplateOption); });
            };
        /**
         * @param {?} isTemplateOptionChange
         * @return {?}
         */
        NzOptionContainerComponent.prototype.refreshAllOptionStatus = /**
         * @param {?} isTemplateOptionChange
         * @return {?}
         */
            function (isTemplateOptionChange) {
                /** update nzListOfSelectedValue | update option list -> update listOfAllTemplateOption -> update listOfSelectedOption -> update activatedOption **/
                if (this.isInit) {
                    if (isTemplateOptionChange) {
                        this.refreshListOfAllTemplateOption();
                    }
                    this.refreshListOfTagOption();
                    this.updateListOfFilterOption();
                    this.updateAddTagOptionDisplay();
                }
            };
        /**
         * @return {?}
         */
        NzOptionContainerComponent.prototype.updateListOfFilterOption = /**
         * @return {?}
         */
            function () {
                this.listOfFilterOption = /** @type {?} */ (new NzOptionPipe().transform(this.listOfAllTemplateOption.concat(this.listOfTagOption), this.nzSearchValue, this.nzFilterOption, this.nzServerSearch));
                if (this.nzSearchValue) {
                    this.setActiveOption(this.listOfFilterOption[0]);
                }
            };
        /** watch options change in option group **/
        /**
         * watch options change in option group *
         * @return {?}
         */
        NzOptionContainerComponent.prototype.watchSubOptionChanges = /**
         * watch options change in option group *
         * @return {?}
         */
            function () {
                var _this = this;
                this.unsubscribeOption();
                /** @type {?} */
                var optionChanges$ = rxjs.merge(new rxjs.Subject().asObservable(), this.listOfNzOptionGroupComponent.changes, this.listOfNzOptionComponent.changes);
                if (this.listOfNzOptionGroupComponent.length) {
                    this.listOfNzOptionGroupComponent.forEach(function (group) { return optionChanges$ = group.listOfNzOptionComponent ? rxjs.merge(group.listOfNzOptionComponent.changes, optionChanges$) : optionChanges$; });
                }
                this.optionSubscription = optionChanges$.subscribe(function () { return _this.refreshAllOptionStatus(true); });
            };
        /**
         * @return {?}
         */
        NzOptionContainerComponent.prototype.unsubscribeGroup = /**
         * @return {?}
         */
            function () {
                if (this.groupSubscription) {
                    this.groupSubscription.unsubscribe();
                    this.groupSubscription = null;
                }
            };
        /**
         * @return {?}
         */
        NzOptionContainerComponent.prototype.unsubscribeOption = /**
         * @return {?}
         */
            function () {
                if (this.optionSubscription) {
                    this.optionSubscription.unsubscribe();
                    this.optionSubscription = null;
                }
            };
        Object.defineProperty(NzOptionContainerComponent.prototype, "isTagsMode", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzMode === 'tags';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzOptionContainerComponent.prototype, "isMultipleOrTags", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzMode === 'tags' || this.nzMode === 'multiple';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzOptionContainerComponent.prototype, "isNotFoundDisplay", {
            get: /**
             * @return {?}
             */ function () {
                return (!this.isTagsMode) && (!this.listOfFilterOption.length);
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzOptionContainerComponent.prototype.updateAddTagOptionDisplay = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var listOfAllOption = this.listOfAllTemplateOption.concat(this.listOfTagOption).map(function (item) { return item.nzLabel; });
                /** @type {?} */
                var isMatch = listOfAllOption.indexOf(this.nzSearchValue) > -1;
                this.isAddTagOptionDisplay = this.isTagsMode && this.nzSearchValue && (!isMatch);
            };
        /**
         * @param {?} e
         * @param {?} ul
         * @return {?}
         */
        NzOptionContainerComponent.prototype.dropDownScroll = /**
         * @param {?} e
         * @param {?} ul
         * @return {?}
         */
            function (e, ul) {
                e.preventDefault();
                e.stopPropagation();
                if (ul && (ul.scrollHeight - ul.scrollTop === ul.clientHeight)) {
                    this.nzScrollToBottom.emit();
                }
            };
        /**
         * @return {?}
         */
        NzOptionContainerComponent.prototype.ngAfterContentInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.isInit = true;
                this.refreshAllOptionStatus(true);
                this.watchSubOptionChanges();
                this.groupSubscription = this.listOfNzOptionGroupComponent.changes.subscribe(function () { return _this.watchSubOptionChanges(); });
            };
        /**
         * @return {?}
         */
        NzOptionContainerComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.unsubscribeGroup();
                this.unsubscribeOption();
            };
        NzOptionContainerComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: '[nz-option-container]',
                        preserveWhitespaces: false,
                        template: "<ul\n  #dropdownUl\n  class=\"ant-select-dropdown-menu ant-select-dropdown-menu-root ant-select-dropdown-menu-vertical\"\n  role=\"menu\"\n  (keydown)=\"onKeyDownUl($event)\"\n  (scroll)=\"dropDownScroll($event,dropdownUl)\"\n  tabindex=\"0\">\n  <li\n    *ngIf=\"isNotFoundDisplay\"\n    nz-select-unselectable\n    class=\"ant-select-dropdown-menu-item ant-select-dropdown-menu-item-disabled\">\n    {{ nzNotFoundContent ? nzNotFoundContent : ('Select.notFoundContent' | nzI18n) }}\n  </li>\n  <li\n    *ngIf=\"isAddTagOptionDisplay\"\n    nz-select-unselectable\n    (click)=\"addTagOption()\"\n    class=\"ant-select-dropdown-menu-item ant-select-dropdown-menu-item-active\">\n    {{ nzSearchValue }}\n  </li>\n  <li\n    nz-option-li\n    [compareWith]=\"compareWith\"\n    *ngFor=\"let option of listOfNzOptionComponent | nzFilterOptionPipe : nzSearchValue : nzFilterOption : nzServerSearch \"\n    (click)=\"clickOption(option,false)\"\n    [nzActiveOption]=\"activatedOption\"\n    [nzOption]=\"option\"\n    [nzListOfSelectedValue]=\"nzListOfSelectedValue\">\n  </li>\n  <li\n    *ngFor=\"let group of listOfNzOptionGroupComponent | nzSubFilterOptionPipe : nzSearchValue : nzFilterOption : nzServerSearch\"\n    class=\"ant-select-dropdown-menu-item-group\">\n    <div\n      class=\"ant-select-dropdown-menu-item-group-title\"\n      [attr.title]=\"group.isLabelString ? group.nzLabel : ''\">\n      <ng-container *ngIf=\"group.isLabelString; else labelTemplate\">{{ group.nzLabel }}</ng-container>\n      <ng-template #labelTemplate>\n        <ng-template [ngTemplateOutlet]=\"group.nzLabel\"></ng-template>\n      </ng-template>\n    </div>\n    <ul class=\"ant-select-dropdown-menu-item-group-list\">\n      <li\n        nz-option-li\n        [compareWith]=\"compareWith\"\n        *ngFor=\"let option of group.listOfNzOptionComponent | nzFilterOptionPipe : nzSearchValue : nzFilterOption : nzServerSearch\"\n        (click)=\"clickOption(option,false)\"\n        [nzActiveOption]=\"activatedOption\"\n        [nzShowActive]=\"!isAddTagOptionDisplay\"\n        [nzOption]=\"option\"\n        [nzListOfSelectedValue]=\"nzListOfSelectedValue\">\n      </li>\n    </ul>\n  </li>\n  <li\n    nz-option-li\n    [compareWith]=\"compareWith\"\n    *ngFor=\"let option of listOfTagOption | nzFilterOptionPipe : nzSearchValue : nzFilterOption : nzServerSearch \"\n    (click)=\"clickOption(option,false)\"\n    [nzActiveOption]=\"activatedOption\"\n    [nzShowActive]=\"!isAddTagOptionDisplay\"\n    [nzOption]=\"option\"\n    [nzListOfSelectedValue]=\"nzListOfSelectedValue\">\n  </li>\n</ul>"
                    }] }
        ];
        NzOptionContainerComponent.propDecorators = {
            listOfNzOptionLiComponent: [{ type: i0.ViewChildren, args: [NzOptionLiComponent,] }],
            listOfNzOptionComponent: [{ type: i0.Input }],
            listOfNzOptionGroupComponent: [{ type: i0.Input }],
            nzListOfSelectedValueChange: [{ type: i0.Output }],
            nzListOfTemplateOptionChange: [{ type: i0.Output }],
            nzClickOption: [{ type: i0.Output }],
            nzScrollToBottom: [{ type: i0.Output }],
            nzMode: [{ type: i0.Input }],
            nzServerSearch: [{ type: i0.Input }],
            nzFilterOption: [{ type: i0.Input }],
            nzMaxMultipleCount: [{ type: i0.Input }],
            nzNotFoundContent: [{ type: i0.Input }],
            compareWith: [{ type: i0.Input }],
            nzSearchValue: [{ type: i0.Input }],
            nzListOfSelectedValue: [{ type: i0.Input }]
        };
        return NzOptionContainerComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzOptionGroupComponent = /** @class */ (function () {
        function NzOptionGroupComponent() {
        }
        Object.defineProperty(NzOptionGroupComponent.prototype, "nzLabel", {
            get: /**
             * @return {?}
             */ function () {
                return this._label;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.isLabelString = !(value instanceof i0.TemplateRef);
                this._label = value;
            },
            enumerable: true,
            configurable: true
        });
        NzOptionGroupComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-option-group',
                        template: "<ng-content></ng-content>"
                    }] }
        ];
        NzOptionGroupComponent.propDecorators = {
            listOfNzOptionComponent: [{ type: i0.ContentChildren, args: [NzOptionComponent,] }],
            nzLabel: [{ type: i0.Input }]
        };
        return NzOptionGroupComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzSelectTopControlComponent = /** @class */ (function () {
        function NzSelectTopControlComponent(renderer) {
            this.renderer = renderer;
            this._listTemplateOfOption = [];
            this.listOfCachedSelectedOption = [];
            this.isComposing = false;
            // tslint:disable-next-line:no-any
            this.nzListOfSelectedValueChange = new i0.EventEmitter();
            this.nzOnSearch = new i0.EventEmitter();
            this.nzMode = 'default';
            this.nzShowSearch = false;
            this.nzDisabled = false;
            this.nzOpen = false;
        }
        Object.defineProperty(NzSelectTopControlComponent.prototype, "nzListOfSelectedValue", {
            // tslint:disable-next-line:no-any
            get: /**
             * @return {?}
             */ function () {
                return this._listOfSelectedValue;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._listOfSelectedValue = value;
                this.updateListOfCachedOption();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSelectTopControlComponent.prototype, "nzListTemplateOfOption", {
            get: /**
             * @return {?}
             */ function () {
                return this._listTemplateOfOption;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._listTemplateOfOption = value;
                this.updateListOfCachedOption();
            },
            enumerable: true,
            configurable: true
        });
        /** cached selected option list **/
        /**
         * cached selected option list *
         * @return {?}
         */
        NzSelectTopControlComponent.prototype.updateListOfCachedOption = /**
         * cached selected option list *
         * @return {?}
         */
            function () {
                var _this = this;
                if (this.isSingleMode) {
                    /** @type {?} */
                    var selectedOption = this.nzListTemplateOfOption.find(function (o) { return _this.compareWith(o.nzValue, _this.nzListOfSelectedValue[0]); });
                    if (isNotNil(selectedOption)) {
                        this.listOfCachedSelectedOption = [selectedOption];
                    }
                }
                else {
                    /** @type {?} */
                    var listOfCachedOptionFromLatestTemplate_1 = this.nzListTemplateOfOption.filter(function (o) { return isNotNil(_this.nzListOfSelectedValue.find(function (v) { return _this.compareWith(v, o.nzValue); })); });
                    /** @type {?} */
                    var restSelectedValue_1 = this.nzListOfSelectedValue.filter(function (v) { return !isNotNil(listOfCachedOptionFromLatestTemplate_1.find(function (o) { return _this.compareWith(o.nzValue, v); })); });
                    /** @type {?} */
                    var listOfCachedOptionFromOld = this.listOfCachedSelectedOption.filter(function (o) { return isNotNil(restSelectedValue_1.find(function (v) { return _this.compareWith(o.nzValue, v); })); });
                    this.listOfCachedSelectedOption = listOfCachedOptionFromLatestTemplate_1.concat(listOfCachedOptionFromOld);
                }
            };
        /**
         * @param {?} value
         * @param {?} emit
         * @return {?}
         */
        NzSelectTopControlComponent.prototype.setInputValue = /**
         * @param {?} value
         * @param {?} emit
         * @return {?}
         */
            function (value, emit) {
                this.inputValue = value;
                this.updateWidth();
                this.nzOnSearch.emit({ value: value, emit: emit });
            };
        Object.defineProperty(NzSelectTopControlComponent.prototype, "isSingleMode", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzMode === 'default';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSelectTopControlComponent.prototype, "isMultipleOrTags", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzMode === 'tags' || this.nzMode === 'multiple';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSelectTopControlComponent.prototype, "placeHolderDisplay", {
            get: /**
             * @return {?}
             */ function () {
                return this.inputValue || this.isComposing || this.nzListOfSelectedValue.length ? 'none' : 'block';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSelectTopControlComponent.prototype, "selectedValueDisplay", {
            get: /**
             * @return {?}
             */ function () {
                /** @type {?} */
                var showSelectedValue = false;
                /** @type {?} */
                var opacity = 1;
                if (!this.nzShowSearch) {
                    showSelectedValue = true;
                }
                else {
                    if (this.nzOpen) {
                        showSelectedValue = !(this.inputValue || this.isComposing);
                        if (showSelectedValue) {
                            opacity = 0.4;
                        }
                    }
                    else {
                        showSelectedValue = true;
                    }
                }
                return {
                    display: showSelectedValue ? 'block' : 'none',
                    opacity: "" + opacity
                };
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSelectTopControlComponent.prototype, "singleValueLabel", {
            get: /**
             * @return {?}
             */ function () {
                return this.getPropertyFromValue(this.nzListOfSelectedValue[0], 'nzLabel');
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzSelectTopControlComponent.prototype.focusOnInput = /**
         * @return {?}
         */
            function () {
                var _this = this;
                setTimeout(function () {
                    if (_this.inputElement) {
                        _this.inputElement.nativeElement.focus();
                    }
                });
            };
        // tslint:disable-next-line:no-any
        /**
         * @param {?} value
         * @param {?} prop
         * @return {?}
         */
        NzSelectTopControlComponent.prototype.getPropertyFromValue = /**
         * @param {?} value
         * @param {?} prop
         * @return {?}
         */
            function (value, prop) {
                var _this = this;
                /** @type {?} */
                var targetOption = this.listOfCachedSelectedOption.find(function (item) { return _this.compareWith(item.nzValue, value); });
                return targetOption ? targetOption[prop] : '';
            };
        // tslint:disable-next-line:no-any
        /**
         * @param {?} value
         * @return {?}
         */
        NzSelectTopControlComponent.prototype.isOptionDisplay = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                return (this.nzMode === 'tags') || !!this.getPropertyFromValue(value, 'nzLabel');
            };
        // tslint:disable-next-line:no-any
        /**
         * @param {?} value
         * @return {?}
         */
        NzSelectTopControlComponent.prototype.removeValueFormSelected = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                if (this.nzDisabled || this.getPropertyFromValue(value, 'nzDisabled')) {
                    return;
                }
                this._listOfSelectedValue = this.nzListOfSelectedValue.filter(function (item) { return item !== value; });
                this.nzListOfSelectedValueChange.emit(this.nzListOfSelectedValue);
            };
        /**
         * @return {?}
         */
        NzSelectTopControlComponent.prototype.updateWidth = /**
         * @return {?}
         */
            function () {
                if (this.isMultipleOrTags && this.inputElement) {
                    if (this.inputValue || this.isComposing) {
                        this.renderer.setStyle(this.inputElement.nativeElement, 'width', this.inputElement.nativeElement.scrollWidth + "px");
                    }
                    else {
                        this.renderer.removeStyle(this.inputElement.nativeElement, 'width');
                    }
                }
            };
        /**
         * @param {?} e
         * @return {?}
         */
        NzSelectTopControlComponent.prototype.onKeyDownInput = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                /** @type {?} */
                var keyCode = e.keyCode;
                /** @type {?} */
                var eventTarget = /** @type {?} */ (e.target);
                if (this.isMultipleOrTags &&
                    !eventTarget.value &&
                    // BackSpace
                    keyCode === 8) {
                    e.preventDefault();
                    if (this.nzListOfSelectedValue.length) {
                        this.removeValueFormSelected(this.nzListOfSelectedValue[this.nzListOfSelectedValue.length - 1]);
                    }
                }
            };
        NzSelectTopControlComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: '[nz-select-top-control]',
                        preserveWhitespaces: false,
                        animations: [
                            animations.trigger('tagAnimation', [
                                animations.state('*', animations.style({ opacity: 1, transform: 'scale(1)' })),
                                animations.transition('void => *', [
                                    animations.style({ opacity: 0, transform: 'scale(0)' }),
                                    animations.animate('150ms linear')
                                ]),
                                animations.state('void', animations.style({ opacity: 0, transform: 'scale(0)' })),
                                animations.transition('* => void', [
                                    animations.style({ opacity: 1, transform: 'scale(1)' }),
                                    animations.animate('150ms linear')
                                ])
                            ])
                        ],
                        template: "<ng-template #inputTemplate>\n  <input\n    #inputElement\n    autocomplete=\"something-new\"\n    class=\"ant-select-search__field\"\n    (compositionstart)=\"isComposing = true\"\n    (compositionend)=\"isComposing = false\"\n    (input)=\"updateWidth()\"\n    (keydown)=\"onKeyDownInput($event)\"\n    [ngModel]=\"inputValue\"\n    (ngModelChange)=\"setInputValue($event,true)\"\n    [disabled]=\"nzDisabled\">\n</ng-template>\n<div\n  *ngIf=\"nzPlaceHolder\"\n  nz-select-unselectable\n  [style.display]=\"placeHolderDisplay\"\n  (click)=\"focusOnInput()\"\n  class=\"ant-select-selection__placeholder\">{{ nzPlaceHolder }}</div>\n<!--single mode-->\n<ng-container *ngIf=\"isSingleMode\">\n  <!--selected label-->\n  <div\n    *ngIf=\"nzListOfSelectedValue.length\"\n    class=\"ant-select-selection-selected-value\"\n    [attr.title]=\"nzListOfSelectedValue[0].nzLabel\"\n    [ngStyle]=\"selectedValueDisplay\">\n    {{ singleValueLabel }}\n  </div>\n  <!--show search-->\n  <div\n    *ngIf=\"nzShowSearch\"\n    class=\"ant-select-search ant-select-search--inline\">\n    <div class=\"ant-select-search__field__wrap\">\n      <ng-template [ngTemplateOutlet]=\"inputTemplate\"></ng-template>\n      <span class=\"ant-select-search__field__mirror\">{{inputValue}}&nbsp;</span>\n    </div>\n  </div>\n</ng-container>\n<!--multiple or tags mode-->\n<ul *ngIf=\"isMultipleOrTags\">\n  <ng-container *ngFor=\"let value of nzListOfSelectedValue\">\n    <li\n      *ngIf=\"isOptionDisplay(value)\"\n      [@tagAnimation]\n      [attr.title]=\"getPropertyFromValue(value,'nzLabel')\"\n      [class.ant-select-selection__choice__disabled]=\"getPropertyFromValue(value,'nzDisabled')\"\n      class=\"ant-select-selection__choice\">\n      <div class=\"ant-select-selection__choice__content\">{{ getPropertyFromValue(value, 'nzLabel') || value }}</div>\n      <span *ngIf=\"!getPropertyFromValue(value,'nzDisabled')\" class=\"ant-select-selection__choice__remove\" (click)=\"removeValueFormSelected(value)\"></span>\n    </li>\n  </ng-container>\n\n  <li class=\"ant-select-search ant-select-search--inline\">\n    <ng-template [ngTemplateOutlet]=\"inputTemplate\"></ng-template>\n  </li>\n</ul>",
                        host: {
                            '[class.ant-select-selection__rendered]': 'true'
                        }
                    }] }
        ];
        /** @nocollapse */
        NzSelectTopControlComponent.ctorParameters = function () {
            return [
                { type: i0.Renderer2 }
            ];
        };
        NzSelectTopControlComponent.propDecorators = {
            inputElement: [{ type: i0.ViewChild, args: ['inputElement',] }],
            nzListOfSelectedValueChange: [{ type: i0.Output }],
            nzOnSearch: [{ type: i0.Output }],
            nzMode: [{ type: i0.Input }],
            nzShowSearch: [{ type: i0.Input }],
            nzDisabled: [{ type: i0.Input }],
            nzPlaceHolder: [{ type: i0.Input }],
            nzOpen: [{ type: i0.Input }],
            compareWith: [{ type: i0.Input }],
            nzListOfSelectedValue: [{ type: i0.Input }],
            nzListTemplateOfOption: [{ type: i0.Input }]
        };
        return NzSelectTopControlComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzSelectUnselectableDirective = /** @class */ (function () {
        function NzSelectUnselectableDirective() {
        }
        NzSelectUnselectableDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: '[nz-select-unselectable]',
                        host: {
                            '[attr.unselectable]': '"unselectable"',
                            '[style.user-select]': '"none"'
                        }
                    },] }
        ];
        return NzSelectUnselectableDirective;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzSelectComponent = /** @class */ (function () {
        function NzSelectComponent(renderer) {
            this.renderer = renderer;
            this._disabled = false;
            this._allowClear = false;
            this._showSearch = false;
            this._open = false;
            this._autoFocus = false;
            this.onChange = function () { return null; };
            this.onTouched = function () { return null; };
            this.dropDownPosition = 'bottom';
            // tslint:disable-next-line:no-any
            this.listOfSelectedValue = [];
            this.listOfTemplateOption = [];
            this.searchValue = '';
            this.isDestroy = true;
            this.isInit = false;
            this.nzOnSearch = new i0.EventEmitter();
            this.nzScrollToBottom = new i0.EventEmitter();
            this.nzOpenChange = new i0.EventEmitter();
            this.nzSize = 'default';
            this.nzServerSearch = false;
            this.nzMode = 'default';
            this.nzDropdownMatchSelectWidth = true;
            this.nzFilterOption = defaultFilterOption;
            this.nzMaxMultipleCount = Infinity;
            /**
             * https://github.com/angular/angular/pull/13349/files *
             */
            this.compareWith = function (o1, o2) { return o1 === o2; };
        }
        Object.defineProperty(NzSelectComponent.prototype, "nzDropdownClassName", {
            get: /**
             * @return {?}
             */ function () {
                return this._dropdownClassName;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._dropdownClassName = value;
                this.updateDropDownClassMap();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSelectComponent.prototype, "nzAutoFocus", {
            get: /**
             * @return {?}
             */ function () {
                return this._autoFocus;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._autoFocus = toBoolean(value);
                this.updateAutoFocus();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSelectComponent.prototype, "nzOpen", {
            get: /**
             * @return {?}
             */ function () {
                return this._open;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._open = value;
                this.handleEscBug();
                this.updateCdkConnectedOverlayStatus();
                this.updateDropDownClassMap();
                if (this.nzOpen) {
                    if (this.nzSelectTopControlComponent) {
                        this.nzSelectTopControlComponent.focusOnInput();
                        this.nzSelectTopControlComponent.setInputValue('', true);
                    }
                    if (this.nzOptionContainerComponent) {
                        this.nzOptionContainerComponent.scrollIntoView();
                    }
                    if (this.cdkConnectedOverlay && this.cdkConnectedOverlay.overlayRef) {
                        this.cdkConnectedOverlay.overlayRef.updatePosition();
                        /** @type {?} */
                        var backdropElement = this.cdkConnectedOverlay.overlayRef.backdropElement;
                        /** @type {?} */
                        var parentNode = this.renderer.parentNode(backdropElement);
                        /** @type {?} */
                        var hostElement = this.cdkConnectedOverlay.overlayRef.hostElement;
                        this.renderer.appendChild(parentNode, backdropElement);
                        this.renderer.appendChild(parentNode, hostElement);
                    }
                }
                else {
                    if (this.nzSelectTopControlComponent) {
                        this.nzSelectTopControlComponent.setInputValue('', false);
                    }
                    if (this.nzOptionContainerComponent) {
                        this.nzOptionContainerComponent.resetActiveOption();
                    }
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSelectComponent.prototype, "nzDisabled", {
            get: /**
             * @return {?}
             */ function () {
                return this._disabled;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._disabled = toBoolean(value);
                if (this.nzDisabled) {
                    this.closeDropDown();
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSelectComponent.prototype, "nzAllowClear", {
            get: /**
             * @return {?}
             */ function () {
                return this._allowClear;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._allowClear = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSelectComponent.prototype, "nzShowSearch", {
            get: /**
             * @return {?}
             */ function () {
                return this._showSearch;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._showSearch = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSelectComponent.prototype, "nzPlaceHolder", {
            get: /**
             * @return {?}
             */ function () {
                return this._placeholder;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._placeholder = value;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzSelectComponent.prototype.onClick = /**
         * @return {?}
         */
            function () {
                if (!this.nzDisabled) {
                    this.nzOpen = !this.nzOpen;
                    this.nzOpenChange.emit(this.nzOpen);
                }
            };
        /**
         * @param {?} event
         * @return {?}
         */
        NzSelectComponent.prototype._handleKeydown = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                if (this._disabled) {
                    return;
                }
                /** @type {?} */
                var keyCode = event.keyCode;
                if (!this._open) {
                    if (keyCode === keycodes.SPACE || keyCode === keycodes.DOWN_ARROW) {
                        this.nzOpen = true;
                        this.nzOpenChange.emit(this.nzOpen);
                        event.preventDefault();
                    }
                }
                else {
                    if (keyCode === keycodes.SPACE || keyCode === keycodes.TAB) {
                        this.nzOpen = false;
                        this.nzOpenChange.emit(this.nzOpen);
                        event.preventDefault();
                    }
                }
            };
        /**
         * @return {?}
         */
        NzSelectComponent.prototype.updateAutoFocus = /**
         * @return {?}
         */
            function () {
                if (this.isInit && this.nzSelectTopControlComponent.inputElement) {
                    if (this.nzAutoFocus) {
                        this.renderer.setAttribute(this.nzSelectTopControlComponent.inputElement.nativeElement, 'autofocus', 'autofocus');
                    }
                    else {
                        this.renderer.removeAttribute(this.nzSelectTopControlComponent.inputElement.nativeElement, 'autofocus');
                    }
                }
            };
        /**
         * @return {?}
         */
        NzSelectComponent.prototype.focus = /**
         * @return {?}
         */
            function () {
                if (this.nzSelectTopControlComponent.inputElement) {
                    this.nzSelectTopControlComponent.inputElement.nativeElement.focus();
                }
            };
        /**
         * @return {?}
         */
        NzSelectComponent.prototype.blur = /**
         * @return {?}
         */
            function () {
                if (this.nzSelectTopControlComponent.inputElement) {
                    this.nzSelectTopControlComponent.inputElement.nativeElement.blur();
                }
            };
        /** overlay can not be always open , reopen overlay after press esc **/
        /**
         * overlay can not be always open , reopen overlay after press esc *
         * @return {?}
         */
        NzSelectComponent.prototype.handleEscBug = /**
         * overlay can not be always open , reopen overlay after press esc *
         * @return {?}
         */
            function () {
                if (this.nzOpen && this.cdkConnectedOverlay && this.cdkConnectedOverlay.overlayRef && !this.cdkConnectedOverlay.overlayRef.backdropElement) {
                    this.cdkConnectedOverlay.open = true;
                    this.cdkConnectedOverlay.ngOnChanges({ open: new i0.SimpleChange(false, true, false) });
                }
            };
        /**
         * @param {?} e
         * @return {?}
         */
        NzSelectComponent.prototype.onKeyDownCdkOverlayOrigin = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                if (this.nzOptionContainerComponent) {
                    this.nzOptionContainerComponent.onKeyDownUl(e);
                }
            };
        /**
         * @return {?}
         */
        NzSelectComponent.prototype.closeDropDown = /**
         * @return {?}
         */
            function () {
                if (this.nzOpen) {
                    this.onTouched();
                    this.nzOpen = false;
                    this.nzOpenChange.emit(this.nzOpen);
                    this.blur();
                }
            };
        /**
         * @param {?} position
         * @return {?}
         */
        NzSelectComponent.prototype.onPositionChange = /**
         * @param {?} position
         * @return {?}
         */
            function (position) {
                this.dropDownPosition = position.connectionPair.originY;
                this.updateDropDownClassMap();
            };
        /**
         * @return {?}
         */
        NzSelectComponent.prototype.onClickOptionFromOptionContainer = /**
         * @return {?}
         */
            function () {
                if (this.isSingleMode) {
                    this.closeDropDown();
                }
                else if (this.nzMode === 'tags') {
                    this.onSearch('', true);
                }
            };
        /**
         * @return {?}
         */
        NzSelectComponent.prototype.updateCdkConnectedOverlayStatus = /**
         * @return {?}
         */
            function () {
                if (this.isInit && this.nzOpen && this.cdkOverlayOrigin) {
                    if (this.nzDropdownMatchSelectWidth) {
                        this.overlayWidth = this.cdkOverlayOrigin.elementRef.nativeElement.getBoundingClientRect().width;
                        this.cdkConnectedOverlay.overlayRef.updateSize({ width: this.overlayWidth });
                    }
                    else {
                        this.overlayMinWidth = this.cdkOverlayOrigin.elementRef.nativeElement.getBoundingClientRect().width;
                        this.cdkConnectedOverlay.overlayRef.updateSize({ minWidth: this.overlayMinWidth });
                    }
                }
                this.updateCdkConnectedOverlayPositions();
                if (this.cdkConnectedOverlay && this.cdkConnectedOverlay.overlayRef && this.cdkConnectedOverlay.overlayRef.backdropElement) {
                    if (this.nzOpen) {
                        this.renderer.removeStyle(this.cdkConnectedOverlay.overlayRef.backdropElement, 'display');
                    }
                    else {
                        this.renderer.setStyle(this.cdkConnectedOverlay.overlayRef.backdropElement, 'display', 'none');
                    }
                }
            };
        /**
         * @return {?}
         */
        NzSelectComponent.prototype.updateCdkConnectedOverlayPositions = /**
         * @return {?}
         */
            function () {
                var _this = this;
                /** wait for input size change **/
                setTimeout(function () { return _this.cdkConnectedOverlay.overlayRef.updatePosition(); }, 160);
            };
        Object.defineProperty(NzSelectComponent.prototype, "isSingleMode", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzMode === 'default';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSelectComponent.prototype, "isMultipleOrTags", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzMode === 'tags' || this.nzMode === 'multiple';
            },
            enumerable: true,
            configurable: true
        });
        /** option container nzListOfSelectedValueChange -> update ngModel **/
        // tslint:disable-next-line:no-any
        /**
         * option container nzListOfSelectedValueChange -> update ngModel *
         * @param {?} value
         * @return {?}
         */
        NzSelectComponent.prototype.updateListOfSelectedValueFromOptionContainer = /**
         * option container nzListOfSelectedValueChange -> update ngModel *
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.clearSearchValue();
                this.updateFromSelectedList(value);
            };
        /** option container nzListOfSelectedValueChange -> update ngModel **/
        // tslint:disable-next-line:no-any
        /**
         * option container nzListOfSelectedValueChange -> update ngModel *
         * @param {?} value
         * @return {?}
         */
        NzSelectComponent.prototype.updateListOfSelectedValueFromTopControl = /**
         * option container nzListOfSelectedValueChange -> update ngModel *
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.clearSearchValue();
                this.updateFromSelectedList(value);
            };
        // tslint:disable-next-line:no-any
        /**
         * @param {?} value
         * @return {?}
         */
        NzSelectComponent.prototype.updateFromSelectedList = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                /** @type {?} */
                var modelValue;
                if (this.isSingleMode) {
                    if (value.length) {
                        modelValue = value[0];
                    }
                }
                else {
                    modelValue = value;
                    this.updateCdkConnectedOverlayPositions();
                }
                this.updateNgModel(value, modelValue);
            };
        /**
         * @param {?} value
         * @param {?} emit
         * @return {?}
         */
        NzSelectComponent.prototype.onSearch = /**
         * @param {?} value
         * @param {?} emit
         * @return {?}
         */
            function (value, emit) {
                if (emit && (this.searchValue !== value)) {
                    this.nzOnSearch.emit(value);
                    this.searchValue = value;
                }
            };
        /**
         * @return {?}
         */
        NzSelectComponent.prototype.clearNgModel = /**
         * @return {?}
         */
            function () {
                if (this.isSingleMode) {
                    this.updateNgModel([], null);
                }
                else {
                    this.updateNgModel([], []);
                }
            };
        // tslint:disable-next-line:no-any
        /**
         * @param {?} list
         * @param {?} value
         * @return {?}
         */
        NzSelectComponent.prototype.updateNgModel = /**
         * @param {?} list
         * @param {?} value
         * @return {?}
         */
            function (list, value) {
                this.listOfSelectedValue = list;
                if (value !== this.value) {
                    this.value = value;
                    this.onChange(this.value);
                }
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzSelectComponent.prototype.listOfTemplateOptionChange = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.listOfTemplateOption = value;
            };
        /**
         * @return {?}
         */
        NzSelectComponent.prototype.updateDropDownClassMap = /**
         * @return {?}
         */
            function () {
                var _a;
                this.dropDownClassMap = (_a = {},
                    _a['ant-select-dropdown'] = true,
                    _a["ant-select-dropdown--single"] = this.isSingleMode,
                    _a["ant-select-dropdown--multiple"] = this.isMultipleOrTags,
                    _a["ant-select-dropdown-placement-bottomLeft"] = this.dropDownPosition === 'bottom',
                    _a["ant-select-dropdown-placement-topLeft"] = this.dropDownPosition === 'top',
                    _a["" + this.nzDropdownClassName] = !!this.nzDropdownClassName,
                    _a);
            };
        /**
         * @param {?} e
         * @return {?}
         */
        NzSelectComponent.prototype.onClearSelection = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                // TODO: should not clear disabled option ?
                e.stopPropagation();
                this.clearNgModel();
            };
        /**
         * @return {?}
         */
        NzSelectComponent.prototype.clearSearchValue = /**
         * @return {?}
         */
            function () {
                if (this.isSingleMode) {
                    this.nzSelectTopControlComponent.setInputValue('', false);
                }
                else {
                    this.nzSelectTopControlComponent.setInputValue('', false);
                }
            };
        /** update ngModel -> update listOfSelectedValue **/
        // tslint:disable-next-line:no-any
        /**
         * update ngModel -> update listOfSelectedValue *
         * @param {?} value
         * @return {?}
         */
        NzSelectComponent.prototype.writeValue = /**
         * update ngModel -> update listOfSelectedValue *
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.value = value;
                if (isNotNil(value)) {
                    if (Array.isArray(value)) {
                        this.listOfSelectedValue = value;
                    }
                    else {
                        this.listOfSelectedValue = [value];
                    }
                }
                else {
                    this.listOfSelectedValue = [];
                }
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzSelectComponent.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onChange = fn;
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzSelectComponent.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onTouched = fn;
            };
        /**
         * @param {?} isDisabled
         * @return {?}
         */
        NzSelectComponent.prototype.setDisabledState = /**
         * @param {?} isDisabled
         * @return {?}
         */
            function (isDisabled) {
                this.nzDisabled = isDisabled;
            };
        /**
         * @return {?}
         */
        NzSelectComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.isDestroy = false;
                this.updateDropDownClassMap();
            };
        /**
         * @return {?}
         */
        NzSelectComponent.prototype.ngAfterViewInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.isInit = true;
                Promise.resolve().then(function () { return _this.updateCdkConnectedOverlayStatus(); });
            };
        /**
         * @return {?}
         */
        NzSelectComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.isDestroy = true;
            };
        NzSelectComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-select',
                        preserveWhitespaces: false,
                        providers: [
                            {
                                provide: forms.NG_VALUE_ACCESSOR,
                                useExisting: i0.forwardRef(function () { return NzSelectComponent; }),
                                multi: true
                            }
                        ],
                        animations: [
                            animations.trigger('dropDownAnimation', [
                                animations.state('hidden', animations.style({
                                    opacity: 0,
                                    display: 'none'
                                })),
                                animations.state('bottom', animations.style({
                                    opacity: 1,
                                    transform: 'scaleY(1)',
                                    transformOrigin: '0% 0%'
                                })),
                                animations.state('top', animations.style({
                                    opacity: 1,
                                    transform: 'scaleY(1)',
                                    transformOrigin: '0% 100%'
                                })),
                                animations.transition('hidden => bottom', [
                                    animations.style({
                                        opacity: 0,
                                        transform: 'scaleY(0.8)',
                                        transformOrigin: '0% 0%'
                                    }),
                                    animations.animate('100ms cubic-bezier(0.755, 0.05, 0.855, 0.06)')
                                ]),
                                animations.transition('bottom => hidden', [
                                    animations.animate('100ms cubic-bezier(0.755, 0.05, 0.855, 0.06)', animations.style({
                                        opacity: 0,
                                        transform: 'scaleY(0.8)',
                                        transformOrigin: '0% 0%'
                                    }))
                                ]),
                                animations.transition('hidden => top', [
                                    animations.style({
                                        opacity: 0,
                                        transform: 'scaleY(0.8)',
                                        transformOrigin: '0% 100%'
                                    }),
                                    animations.animate('100ms cubic-bezier(0.755, 0.05, 0.855, 0.06)')
                                ]),
                                animations.transition('top => hidden', [
                                    animations.animate('100ms cubic-bezier(0.755, 0.05, 0.855, 0.06)', animations.style({
                                        opacity: 0,
                                        transform: 'scaleY(0.8)',
                                        transformOrigin: '0% 100%'
                                    }))
                                ])
                            ])
                        ],
                        template: "<div\n  cdkOverlayOrigin\n  class=\"ant-select-selection\"\n  [class.ant-select-selection--single]=\"isSingleMode\"\n  [class.ant-select-selection--multiple]=\"isMultipleOrTags\"\n  (keydown)=\"onKeyDownCdkOverlayOrigin($event)\"\n  tabindex=\"0\">\n  <div\n    nz-select-top-control\n    [nzOpen]=\"nzOpen\"\n    [compareWith]=\"compareWith\"\n    [nzPlaceHolder]=\"nzPlaceHolder\"\n    [nzShowSearch]=\"nzShowSearch\"\n    [nzDisabled]=\"nzDisabled\"\n    [nzMode]=\"nzMode\"\n    [nzListTemplateOfOption]=\"listOfTemplateOption\"\n    [nzListOfSelectedValue]=\"listOfSelectedValue\"\n    (nzOnSearch)=\"onSearch($event.value,$event.emit)\"\n    (nzListOfSelectedValueChange)=\"updateListOfSelectedValueFromTopControl($event)\">\n  </div>\n  <span *ngIf=\"nzAllowClear\" class=\"ant-select-selection__clear\" nz-select-unselectable (click)=\"onClearSelection($event)\"></span>\n  <span class=\"ant-select-arrow\" nz-select-unselectable><b></b></span>\n</div>\n<ng-template\n  cdkConnectedOverlay\n  [cdkConnectedOverlayHasBackdrop]=\"true\"\n  [cdkConnectedOverlayOrigin]=\"cdkOverlayOrigin\"\n  (backdropClick)=\"closeDropDown()\"\n  (detach)=\"closeDropDown();\"\n  (positionChange)=\"onPositionChange($event)\"\n  [cdkConnectedOverlayWidth]=\"overlayWidth\"\n  [cdkConnectedOverlayMinWidth]=\"overlayMinWidth\"\n  [cdkConnectedOverlayOpen]=\"!isDestroy\">\n  <div [ngClass]=\"dropDownClassMap\" [@dropDownAnimation]=\"nzOpen ? dropDownPosition : 'hidden' \" [ngStyle]=\"nzDropdownStyle\">\n    <div\n      style=\"overflow: auto\"\n      nz-option-container\n      [listOfNzOptionComponent]=\"listOfNzOptionComponent\"\n      [listOfNzOptionGroupComponent]=\"listOfNzOptionGroupComponent\"\n      [nzSearchValue]=\"searchValue\"\n      [nzFilterOption]=\"nzFilterOption\"\n      [nzServerSearch]=\"nzServerSearch\"\n      [compareWith]=\"compareWith\"\n      [nzNotFoundContent]=\"nzNotFoundContent\"\n      [nzMaxMultipleCount]=\"nzMaxMultipleCount\"\n      [nzMode]=\"nzMode\"\n      (nzScrollToBottom)=\"nzScrollToBottom.emit()\"\n      (nzClickOption)=\"onClickOptionFromOptionContainer()\"\n      (nzListOfTemplateOptionChange)=\"listOfTemplateOptionChange($event)\"\n      (nzListOfSelectedValueChange)=\"updateListOfSelectedValueFromOptionContainer($event)\"\n      [nzListOfSelectedValue]=\"listOfSelectedValue\">\n    </div>\n  </div>\n</ng-template>\n<!--can not use ViewChild since it will match sub options in option group -->\n<ng-template>\n  <ng-content></ng-content>\n</ng-template>",
                        host: {
                            '[class.ant-select]': 'true',
                            '[class.ant-select-lg]': 'nzSize==="large"',
                            '[class.ant-select-sm]': 'nzSize==="small"',
                            '[class.ant-select-enabled]': '!nzDisabled',
                            '[class.ant-select-disabled]': 'nzDisabled',
                            '[class.ant-select-allow-clear]': 'nzAllowClear',
                            '[class.ant-select-open]': 'nzOpen'
                        },
                        styles: ["\n    .ant-select-dropdown {\n      top: 100%;\n      left: 0;\n      position: relative;\n      width: 100%;\n      margin-top: 4px;\n      margin-bottom: 4px;\n    }\n  "]
                    }] }
        ];
        /** @nocollapse */
        NzSelectComponent.ctorParameters = function () {
            return [
                { type: i0.Renderer2 }
            ];
        };
        NzSelectComponent.propDecorators = {
            cdkOverlayOrigin: [{ type: i0.ViewChild, args: [i2.CdkOverlayOrigin,] }],
            cdkConnectedOverlay: [{ type: i0.ViewChild, args: [i2.CdkConnectedOverlay,] }],
            nzSelectTopControlComponent: [{ type: i0.ViewChild, args: [NzSelectTopControlComponent,] }],
            nzOptionContainerComponent: [{ type: i0.ViewChild, args: [NzOptionContainerComponent,] }],
            listOfNzOptionComponent: [{ type: i0.ContentChildren, args: [NzOptionComponent,] }],
            listOfNzOptionGroupComponent: [{ type: i0.ContentChildren, args: [NzOptionGroupComponent,] }],
            nzOnSearch: [{ type: i0.Output }],
            nzScrollToBottom: [{ type: i0.Output }],
            nzOpenChange: [{ type: i0.Output }],
            nzSize: [{ type: i0.Input }],
            nzServerSearch: [{ type: i0.Input }],
            nzMode: [{ type: i0.Input }],
            nzDropdownMatchSelectWidth: [{ type: i0.Input }],
            nzFilterOption: [{ type: i0.Input }],
            nzMaxMultipleCount: [{ type: i0.Input }],
            nzDropdownStyle: [{ type: i0.Input }],
            nzNotFoundContent: [{ type: i0.Input }],
            compareWith: [{ type: i0.Input }],
            nzDropdownClassName: [{ type: i0.Input }],
            nzAutoFocus: [{ type: i0.Input }],
            nzOpen: [{ type: i0.Input }],
            nzDisabled: [{ type: i0.Input }],
            nzAllowClear: [{ type: i0.Input }],
            nzShowSearch: [{ type: i0.Input }],
            nzPlaceHolder: [{ type: i0.Input }],
            onClick: [{ type: i0.HostListener, args: ['click',] }],
            _handleKeydown: [{ type: i0.HostListener, args: ['keydown', ['$event'],] }]
        };
        return NzSelectComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzSelectModule = /** @class */ (function () {
        function NzSelectModule() {
        }
        NzSelectModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [i1.CommonModule, forms.FormsModule, i2.OverlayModule, NzI18nModule],
                        declarations: [NzOptionPipe, NzSubOptionPipe, NzOptionComponent, NzSelectComponent, NzOptionContainerComponent, NzOptionGroupComponent, NzOptionLiComponent, NzSelectTopControlComponent, NzSelectUnselectableDirective],
                        exports: [NzOptionComponent, NzSelectComponent, NzOptionContainerComponent, NzOptionGroupComponent, NzSelectTopControlComponent]
                    },] }
        ];
        return NzSelectModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzDateCellDirective = /** @class */ (function () {
        function NzDateCellDirective() {
        }
        NzDateCellDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: '[nzDateCell]'
                    },] }
        ];
        return NzDateCellDirective;
    }());
    var NzMonthCellDirective = /** @class */ (function () {
        function NzMonthCellDirective() {
        }
        NzMonthCellDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: '[nzMonthCell]'
                    },] }
        ];
        return NzMonthCellDirective;
    }());
    var NzDateFullCellDirective = /** @class */ (function () {
        function NzDateFullCellDirective() {
        }
        NzDateFullCellDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: '[nzDateFullCell]'
                    },] }
        ];
        return NzDateFullCellDirective;
    }());
    var NzMonthFullCellDirective = /** @class */ (function () {
        function NzMonthFullCellDirective() {
        }
        NzMonthFullCellDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: '[nzMonthFullCell]'
                    },] }
        ];
        return NzMonthFullCellDirective;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCalendarHeaderComponent = /** @class */ (function () {
        function NzCalendarHeaderComponent(i18n) {
            this.i18n = i18n;
            this.mode = 'month';
            this.modeChange = new i0.EventEmitter();
            this.fullscreen = true;
            this.activeDate = new Date();
            this.yearChange = new i0.EventEmitter();
            this.monthChange = new i0.EventEmitter();
            this.yearOffset = 10;
            this.yearTotal = 20;
            this.prefixCls = 'ant-fullcalendar';
        }
        Object.defineProperty(NzCalendarHeaderComponent.prototype, "activeYear", {
            get: /**
             * @return {?}
             */ function () {
                return this.activeDate.getFullYear();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCalendarHeaderComponent.prototype, "activeMonth", {
            get: /**
             * @return {?}
             */ function () {
                return this.activeDate.getMonth();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCalendarHeaderComponent.prototype, "size", {
            get: /**
             * @return {?}
             */ function () {
                return this.fullscreen ? 'default' : 'small';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCalendarHeaderComponent.prototype, "yearTypeText", {
            get: /**
             * @return {?}
             */ function () {
                return this.i18n.getLocale().Calendar.year;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCalendarHeaderComponent.prototype, "monthTypeText", {
            get: /**
             * @return {?}
             */ function () {
                return this.i18n.getLocale().Calendar.month;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzCalendarHeaderComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.setUpYears();
                this.setUpMonths();
            };
        /**
         * @param {?} year
         * @return {?}
         */
        NzCalendarHeaderComponent.prototype.updateYear = /**
         * @param {?} year
         * @return {?}
         */
            function (year) {
                this.yearChange.emit(year);
                this.setUpYears(year);
            };
        /**
         * @param {?=} year
         * @return {?}
         */
        NzCalendarHeaderComponent.prototype.setUpYears = /**
         * @param {?=} year
         * @return {?}
         */
            function (year) {
                /** @type {?} */
                var start = (year || this.activeYear) - this.yearOffset;
                /** @type {?} */
                var end = start + this.yearTotal;
                this.years = [];
                for (var i = start; i < end; i++) {
                    this.years.push({ label: "" + i, value: i });
                }
            };
        /**
         * @return {?}
         */
        NzCalendarHeaderComponent.prototype.setUpMonths = /**
         * @return {?}
         */
            function () {
                this.months = [];
                for (var i = 0; i < 12; i++) {
                    /** @type {?} */
                    var dateInMonth = setMonth(this.activeDate, i);
                    /** @type {?} */
                    var monthText = this.i18n.formatDate(dateInMonth, 'MMM');
                    this.months.push({ label: monthText, value: i });
                }
            };
        NzCalendarHeaderComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-calendar-header',
                        template: "<nz-select class=\"ant-fullcalendar-year-select\" [nzSize]=\"size\" [nzDropdownMatchSelectWidth]=\"false\"\n           [ngModel]=\"activeYear\" (ngModelChange)=\"updateYear($event)\">\n  <nz-option *ngFor=\"let year of years\" [nzLabel]=\"year.label\" [nzValue]=\"year.value\"></nz-option>\n</nz-select>\n\n<nz-select *ngIf=\"mode === 'month'\" class=\"ant-fullcalendar-month-select\" [nzSize]=\"size\" [nzDropdownMatchSelectWidth]=\"false\"\n           [ngModel]=\"activeMonth\" (ngModelChange)=\"monthChange.emit($event)\">\n  <nz-option *ngFor=\"let month of months\" [nzLabel]=\"month.label\" [nzValue]=\"month.value\"></nz-option>\n</nz-select>\n\n<nz-radio-group [(ngModel)]=\"mode\" (ngModelChange)=\"modeChange.emit($event)\" [nzSize]=\"size\">\n  <label nz-radio-button nzValue=\"month\">{{ monthTypeText }}</label>\n  <label nz-radio-button nzValue=\"year\">{{ yearTypeText }}</label>\n</nz-radio-group>\n",
                        host: {
                            '[style.display]': "'block'",
                            '[class.ant-fullcalendar-header]': "true"
                        }
                    }] }
        ];
        /** @nocollapse */
        NzCalendarHeaderComponent.ctorParameters = function () {
            return [
                { type: NzI18nService }
            ];
        };
        NzCalendarHeaderComponent.propDecorators = {
            mode: [{ type: i0.Input }],
            modeChange: [{ type: i0.Output }],
            fullscreen: [{ type: i0.Input }],
            activeDate: [{ type: i0.Input }],
            yearChange: [{ type: i0.Output }],
            monthChange: [{ type: i0.Output }]
        };
        return NzCalendarHeaderComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCalendarComponent = /** @class */ (function () {
        function NzCalendarComponent(i18n) {
            this.i18n = i18n;
            this.nzMode = 'month';
            this.nzModeChange = new i0.EventEmitter();
            this.nzValueChange = new i0.EventEmitter();
            this.fullscreen = true;
            this.daysInWeek = [];
            this.monthsInYear = [];
            this.dateMatrix = [];
            this.activeDate = new Date();
            this.currentDateRow = -1;
            this.currentDateCol = -1;
            this.activeDateRow = -1;
            this.activeDateCol = -1;
            this.currentMonthRow = -1;
            this.currentMonthCol = -1;
            this.activeMonthRow = -1;
            this.activeMonthCol = -1;
            this.dateCell = null;
            this.dateFullCell = null;
            this.monthCell = null;
            this.monthFullCell = null;
            this.prefixCls = 'ant-fullcalendar';
            this.currentDate = new Date();
            this.onChangeFn = function () { };
            this.onTouchFn = function () { };
        }
        Object.defineProperty(NzCalendarComponent.prototype, "nzValue", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) { this.updateDate(value, false); },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCalendarComponent.prototype, "nzDateCell", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) { this.dateCell = value; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCalendarComponent.prototype, "nzDateFullCell", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) { this.dateFullCell = value; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCalendarComponent.prototype, "nzMonthCell", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) { this.monthCell = value; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCalendarComponent.prototype, "nzMonthFullCell", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) { this.monthFullCell = value; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCalendarComponent.prototype, "nzFullscreen", {
            get: /**
             * @return {?}
             */ function () { return this.fullscreen; },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) { this.fullscreen = coercion.coerceBooleanProperty(value); },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCalendarComponent.prototype, "nzCard", {
            get: /**
             * @return {?}
             */ function () { return !this.fullscreen; },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) { this.fullscreen = !coercion.coerceBooleanProperty(value); },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCalendarComponent.prototype, "dateCellChild", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value) {
                    this.dateCell = value;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCalendarComponent.prototype, "dateFullCellChild", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value) {
                    this.dateFullCell = value;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCalendarComponent.prototype, "monthCellChild", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value) {
                    this.monthCell = value;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCalendarComponent.prototype, "monthFullCellChild", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value) {
                    this.monthFullCell = value;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCalendarComponent.prototype, "calendarStart", {
            get: /**
             * @return {?}
             */ function () {
                return startOfWeek(startOfMonth(this.activeDate));
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzCalendarComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.setUpDaysInWeek();
                this.setUpMonthsInYear();
                this.setUpDateMatrix();
                this.calculateCurrentDate();
                this.calculateActiveDate();
                this.calculateCurrentMonth();
                this.calculateActiveMonth();
            };
        /**
         * @param {?} mode
         * @return {?}
         */
        NzCalendarComponent.prototype.onModeChange = /**
         * @param {?} mode
         * @return {?}
         */
            function (mode) {
                this.nzModeChange.emit(mode);
            };
        /**
         * @param {?} date
         * @return {?}
         */
        NzCalendarComponent.prototype.onDateSelect = /**
         * @param {?} date
         * @return {?}
         */
            function (date) {
                this.updateDate(date);
            };
        /**
         * @param {?} year
         * @return {?}
         */
        NzCalendarComponent.prototype.onYearSelect = /**
         * @param {?} year
         * @return {?}
         */
            function (year) {
                /** @type {?} */
                var date = setYear(this.activeDate, year);
                this.updateDate(date);
            };
        /**
         * @param {?} month
         * @return {?}
         */
        NzCalendarComponent.prototype.onMonthSelect = /**
         * @param {?} month
         * @return {?}
         */
            function (month) {
                /** @type {?} */
                var date = setMonth(this.activeDate, month);
                this.updateDate(date);
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzCalendarComponent.prototype.writeValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.updateDate(value || new Date(), false);
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzCalendarComponent.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onChangeFn = fn;
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzCalendarComponent.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onTouchFn = fn;
            };
        /**
         * @param {?} date
         * @param {?=} touched
         * @return {?}
         */
        NzCalendarComponent.prototype.updateDate = /**
         * @param {?} date
         * @param {?=} touched
         * @return {?}
         */
            function (date, touched) {
                if (touched === void 0) {
                    touched = true;
                }
                /** @type {?} */
                var dayChanged = !isSameDay(date, this.activeDate);
                /** @type {?} */
                var monthChanged = !isSameMonth(date, this.activeDate);
                /** @type {?} */
                var yearChanged = !isSameYear(date, this.activeDate);
                this.activeDate = date;
                if (dayChanged) {
                    this.calculateActiveDate();
                }
                if (monthChanged) {
                    this.setUpDateMatrix();
                    this.calculateCurrentDate();
                    this.calculateActiveMonth();
                }
                if (yearChanged) {
                    this.calculateCurrentMonth();
                }
                if (touched) {
                    this.onChangeFn(date);
                    this.onTouchFn();
                    this.nzValueChange.emit(date);
                }
            };
        /**
         * @return {?}
         */
        NzCalendarComponent.prototype.setUpDaysInWeek = /**
         * @return {?}
         */
            function () {
                this.daysInWeek = [];
                /** @type {?} */
                var weekStart = startOfWeek(this.activeDate);
                for (var i = 0; i < 7; i++) {
                    /** @type {?} */
                    var date = addDays(weekStart, i);
                    /** @type {?} */
                    var title = this.i18n.formatDate(date, 'E');
                    /** @type {?} */
                    var label = this.i18n.formatDate(date, 'EEEEEE');
                    this.daysInWeek.push({ title: title, label: label });
                }
            };
        /**
         * @return {?}
         */
        NzCalendarComponent.prototype.setUpMonthsInYear = /**
         * @return {?}
         */
            function () {
                this.monthsInYear = [];
                for (var i = 0; i < 12; i++) {
                    /** @type {?} */
                    var date = setMonth(this.activeDate, i);
                    /** @type {?} */
                    var title = this.i18n.formatDate(date, 'MMM');
                    /** @type {?} */
                    var label = this.i18n.formatDate(date, 'MMM');
                    /** @type {?} */
                    var start = startOfMonth(date);
                    this.monthsInYear.push({ title: title, label: label, start: start });
                }
            };
        /**
         * @return {?}
         */
        NzCalendarComponent.prototype.setUpDateMatrix = /**
         * @return {?}
         */
            function () {
                this.dateMatrix = [];
                /** @type {?} */
                var monthStart = startOfMonth(this.activeDate);
                /** @type {?} */
                var monthEnd = endOfMonth(this.activeDate);
                /** @type {?} */
                var weekDiff = differenceInCalendarWeeks(monthEnd, monthStart) + 2;
                for (var week = 0; week < weekDiff; week++) {
                    /** @type {?} */
                    var row = [];
                    /** @type {?} */
                    var weekStart = addDays(this.calendarStart, week * 7);
                    for (var day = 0; day < 7; day++) {
                        /** @type {?} */
                        var date = addDays(weekStart, day);
                        /** @type {?} */
                        var monthDiff = differenceInCalendarMonths(date, this.activeDate);
                        /** @type {?} */
                        var title = this.i18n.formatDate(date, 'longDate');
                        /** @type {?} */
                        var label = this.i18n.formatDate(date, 'dd');
                        /** @type {?} */
                        var rel = monthDiff === 0 ? 'current' : monthDiff < 0 ? 'last' : 'next';
                        row.push({ title: title, label: label, rel: rel, value: date });
                    }
                    this.dateMatrix.push(row);
                }
            };
        /**
         * @return {?}
         */
        NzCalendarComponent.prototype.calculateCurrentDate = /**
         * @return {?}
         */
            function () {
                if (isThisMonth(this.activeDate)) {
                    this.currentDateRow = differenceInCalendarWeeks(this.currentDate, this.calendarStart);
                    this.currentDateCol = differenceInCalendarDays(this.currentDate, addDays(this.calendarStart, this.currentDateRow * 7));
                }
                else {
                    this.currentDateRow = -1;
                    this.currentDateCol = -1;
                }
            };
        /**
         * @return {?}
         */
        NzCalendarComponent.prototype.calculateActiveDate = /**
         * @return {?}
         */
            function () {
                this.activeDateRow = differenceInCalendarWeeks(this.activeDate, this.calendarStart);
                this.activeDateCol = differenceInCalendarDays(this.activeDate, addDays(this.calendarStart, this.activeDateRow * 7));
            };
        /**
         * @return {?}
         */
        NzCalendarComponent.prototype.calculateCurrentMonth = /**
         * @return {?}
         */
            function () {
                if (isThisYear(this.activeDate)) {
                    /** @type {?} */
                    var yearStart = startOfYear(this.currentDate);
                    /** @type {?} */
                    var monthDiff = differenceInCalendarMonths(this.currentDate, yearStart);
                    this.currentMonthRow = Math.floor(monthDiff / 3);
                    this.currentMonthCol = monthDiff % 3;
                }
                else {
                    this.currentMonthRow = -1;
                    this.currentMonthCol = -1;
                }
            };
        /**
         * @return {?}
         */
        NzCalendarComponent.prototype.calculateActiveMonth = /**
         * @return {?}
         */
            function () {
                this.activeMonthRow = Math.floor(this.activeDate.getMonth() / 3);
                this.activeMonthCol = this.activeDate.getMonth() % 3;
            };
        NzCalendarComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-calendar',
                        template: "<nz-calendar-header [fullscreen]=\"fullscreen\" [activeDate]=\"activeDate\"\n                    [(mode)]=\"nzMode\" (modeChange)=\"onModeChange($event)\"\n                    (yearChange)=\"onYearSelect($event)\" (monthChange)=\"onMonthSelect($event)\">\n</nz-calendar-header>\n\n<div class=\"ant-fullcalendar ant-fullcalendar-full\" [ngClass]=\"fullscreen ? 'ant-fullcalendar-fullscreen' : ''\">\n  <div class=\"ant-fullcalendar-calendar-body\">\n    <ng-container *ngIf=\"nzMode === 'month' then monthModeTable else yearModeTable\"></ng-container>\n  </div>\n</div>\n\n<ng-template #monthModeTable>\n  <table class=\"ant-fullcalendar-table\" cellspacing=\"0\" role=\"grid\">\n    <thead>\n      <tr role=\"row\">\n        <th *ngFor=\"let day of daysInWeek\" class=\"ant-fullcalendar-column-header\" role=\"columnheader\" [title]=\"day.title\">\n          <span class=\"ant-fullcalendar-column-header-inner\">{{ day.label }}</span>\n        </th>\n      </tr>\n    </thead>\n    <tbody class=\"ant-fullcalendar-tbody\">\n      <tr *ngFor=\"let week of dateMatrix; index as row\"\n          [class.ant-fullcalendar-current-week]=\"row === currentDateRow\"\n          [class.ant-fullcalendar-active-week]=\"row === activeDateRow\">\n        <td *ngFor=\"let day of week; index as col\" role=\"gridcell\" class=\"ant-fullcalendar-cell\" [title]=\"day.title\"\n            [class.ant-fullcalendar-today]=\"row === currentDateRow && col === currentDateCol\"\n            [class.ant-fullcalendar-selected-day]=\"row === activeDateRow && col === activeDateCol\"\n            [class.ant-fullcalendar-last-month-cell]=\"day.rel === 'last'\"\n            [class.ant-fullcalendar-next-month-btn-day]=\"day.rel === 'next'\"\n            (click)=\"onDateSelect(day.value)\">\n            <div class=\"ant-fullcalendar-date\">\n              <ng-container *ngIf=\"dateFullCell else defaultCell\">\n                <ng-container *ngTemplateOutlet=\"dateFullCell; context: {$implicit: day.value}\"></ng-container>\n              </ng-container>\n              <ng-template #defaultCell>\n                <div class=\"ant-fullcalendar-value\">{{ day.label }}</div>\n                <div *ngIf=\"dateCell\" class=\"ant-fullcalendar-content\">\n                  <ng-container *ngTemplateOutlet=\"dateCell; context: {$implicit: day.value}\"></ng-container>\n                </div>\n              </ng-template>\n            </div>\n        </td>\n      </tr>\n    </tbody>\n  </table>\n</ng-template>\n\n<ng-template #yearModeTable>\n  <table class=\"ant-fullcalendar-month-panel-table\" cellspacing=\"0\" role=\"grid\">\n    <tbody class=\"ant-fullcalendar-month-panel-tbody\">\n      <tr *ngFor=\"let row of [0, 1, 2, 3]\" role=\"row\">\n        <td *ngFor=\"let col of [0, 1, 2]\" role=\"gridcell\" [title]=\"monthsInYear[row * 3 + col].title\"\n            class=\"ant-fullcalendar-month-panel-cell\"\n            [class.ant-fullcalendar-month-panel-current-cell]=\"row === currentMonthRow && col === currentMonthCol\"\n            [class.ant-fullcalendar-month-panel-selected-cell]=\"row === activeMonthRow && col === activeMonthCol\"\n            (click)=\"onMonthSelect(row * 3 + col)\">\n          <div class=\"ant-fullcalendar-month\">\n            <ng-container *ngIf=\"monthFullCell else defaultCell\">\n              <ng-container *ngTemplateOutlet=\"monthFullCell; context: {$implicit: monthsInYear[row * 3 + col].start}\"></ng-container>\n            </ng-container>\n            <ng-template #defaultCell>\n              <div class=\"ant-fullcalendar-value\">{{ monthsInYear[row * 3 + col].label }}</div>\n              <div *ngIf=\"monthCell\" class=\"ant-fullcalendar-content\">\n                <ng-container *ngTemplateOutlet=\"monthCell; context: {$implicit: monthsInYear[row * 3 + col].start}\"></ng-container>\n              </div>\n            </ng-template>\n          </div>\n        </td>\n      </tr>\n    </tbody>\n  </table>\n</ng-template>\n",
                        providers: [
                            { provide: forms.NG_VALUE_ACCESSOR, useExisting: i0.forwardRef(function () { return NzCalendarComponent; }), multi: true }
                        ]
                    }] }
        ];
        /** @nocollapse */
        NzCalendarComponent.ctorParameters = function () {
            return [
                { type: NzI18nService }
            ];
        };
        NzCalendarComponent.propDecorators = {
            nzMode: [{ type: i0.Input }],
            nzModeChange: [{ type: i0.Output }],
            nzValue: [{ type: i0.Input }],
            nzValueChange: [{ type: i0.Output }],
            nzDateCell: [{ type: i0.Input }],
            nzDateFullCell: [{ type: i0.Input }],
            nzMonthCell: [{ type: i0.Input }],
            nzMonthFullCell: [{ type: i0.Input }],
            nzFullscreen: [{ type: i0.Input }],
            nzCard: [{ type: i0.Input }],
            dateCellChild: [{ type: i0.ContentChild, args: [NzDateCellDirective, { read: i0.TemplateRef },] }],
            dateFullCellChild: [{ type: i0.ContentChild, args: [NzDateFullCellDirective, { read: i0.TemplateRef },] }],
            monthCellChild: [{ type: i0.ContentChild, args: [NzMonthCellDirective, { read: i0.TemplateRef },] }],
            monthFullCellChild: [{ type: i0.ContentChild, args: [NzMonthFullCellDirective, { read: i0.TemplateRef },] }],
            fullscreen: [{ type: i0.HostBinding, args: ['class.ant-fullcalendar--fullscreen',] }]
        };
        return NzCalendarComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCalendarModule = /** @class */ (function () {
        function NzCalendarModule() {
        }
        NzCalendarModule.decorators = [
            { type: i0.NgModule, args: [{
                        declarations: [
                            NzCalendarHeaderComponent,
                            NzCalendarComponent,
                            NzDateCellDirective,
                            NzDateFullCellDirective,
                            NzMonthCellDirective,
                            NzMonthFullCellDirective
                        ],
                        exports: [
                            NzCalendarComponent,
                            NzDateCellDirective,
                            NzDateFullCellDirective,
                            NzMonthCellDirective,
                            NzMonthFullCellDirective
                        ],
                        imports: [i1.CommonModule, forms.FormsModule, NzI18nModule, NzRadioModule, NzSelectModule]
                    },] }
        ];
        return NzCalendarModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCardGridDirective = /** @class */ (function () {
        function NzCardGridDirective() {
        }
        NzCardGridDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: '[nz-card-grid]',
                        host: {
                            '[class.ant-card-grid]': 'true'
                        }
                    },] }
        ];
        return NzCardGridDirective;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCardLoadingComponent = /** @class */ (function () {
        function NzCardLoadingComponent() {
        }
        NzCardLoadingComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-card-loading',
                        template: "<div class=\"ant-card-loading-content\">\n  <div class=\"ant-row\" style=\"margin-left: -4px; margin-right: -4px;\">\n    <div class=\"ant-col-22\" style=\"padding-left: 4px; padding-right: 4px;\">\n      <div class=\"ant-card-loading-block\"></div>\n    </div>\n  </div>\n  <div class=\"ant-row\" style=\"margin-left: -4px; margin-right: -4px;\">\n    <div class=\"ant-col-8\" style=\"padding-left: 4px; padding-right: 4px;\">\n      <div class=\"ant-card-loading-block\"></div>\n    </div>\n    <div class=\"ant-col-15\" style=\"padding-left: 4px; padding-right: 4px;\">\n      <div class=\"ant-card-loading-block\"></div>\n    </div>\n  </div>\n  <div class=\"ant-row\" style=\"margin-left: -4px; margin-right: -4px;\">\n    <div class=\"ant-col-6\" style=\"padding-left: 4px; padding-right: 4px;\">\n      <div class=\"ant-card-loading-block\"></div>\n    </div>\n    <div class=\"ant-col-18\" style=\"padding-left: 4px; padding-right: 4px;\">\n      <div class=\"ant-card-loading-block\"></div>\n    </div>\n  </div>\n  <div class=\"ant-row\" style=\"margin-left: -4px; margin-right: -4px;\">\n    <div class=\"ant-col-13\" style=\"padding-left: 4px; padding-right: 4px;\">\n      <div class=\"ant-card-loading-block\"></div>\n    </div>\n    <div class=\"ant-col-9\" style=\"padding-left: 4px; padding-right: 4px;\">\n      <div class=\"ant-card-loading-block\"></div>\n    </div>\n  </div>\n  <div class=\"ant-row\" style=\"margin-left: -4px; margin-right: -4px;\">\n    <div class=\"ant-col-4\" style=\"padding-left: 4px; padding-right: 4px;\">\n      <div class=\"ant-card-loading-block\"></div>\n    </div>\n    <div class=\"ant-col-3\" style=\"padding-left: 4px; padding-right: 4px;\">\n      <div class=\"ant-card-loading-block\"></div>\n    </div>\n    <div class=\"ant-col-16\" style=\"padding-left: 4px; padding-right: 4px;\">\n      <div class=\"ant-card-loading-block\"></div>\n    </div>\n  </div>\n  <div class=\"ant-row\" style=\"margin-left: -4px; margin-right: -4px;\">\n    <div class=\"ant-col-8\" style=\"padding-left: 4px; padding-right: 4px;\">\n      <div class=\"ant-card-loading-block\"></div>\n    </div>\n    <div class=\"ant-col-6\" style=\"padding-left: 4px; padding-right: 4px;\">\n      <div class=\"ant-card-loading-block\"></div>\n    </div>\n    <div class=\"ant-col-8\" style=\"padding-left: 4px; padding-right: 4px;\">\n      <div class=\"ant-card-loading-block\"></div>\n    </div>\n  </div>\n</div>",
                        host: {
                            '[class.ant-card-loading-content]': 'true'
                        },
                        styles: ["\n    :host {\n      display: block;\n    }\n  "]
                    }] }
        ];
        return NzCardLoadingComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCardMetaComponent = /** @class */ (function () {
        function NzCardMetaComponent() {
        }
        Object.defineProperty(NzCardMetaComponent.prototype, "nzTitle", {
            get: /**
             * @return {?}
             */ function () {
                return this._title;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.isTitleString = !(value instanceof i0.TemplateRef);
                this._title = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCardMetaComponent.prototype, "nzDescription", {
            get: /**
             * @return {?}
             */ function () {
                return this._description;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.isDescriptionString = !(value instanceof i0.TemplateRef);
                this._description = value;
            },
            enumerable: true,
            configurable: true
        });
        NzCardMetaComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-card-meta',
                        preserveWhitespaces: false,
                        template: "<div class=\"ant-card-meta-avatar\" *ngIf=\"nzAvatar\">\n  <ng-template [ngTemplateOutlet]=\"nzAvatar\"></ng-template>\n</div>\n<div class=\"ant-card-meta-detail\" *ngIf=\"nzTitle || nzDescription\">\n  <div class=\"ant-card-meta-title\" *ngIf=\"nzTitle\">\n    <ng-container *ngIf=\"isTitleString; else titleTemplate\">{{ nzTitle }}</ng-container>\n    <ng-template #titleTemplate>\n      <ng-template [ngTemplateOutlet]=\"nzTitle\"></ng-template>\n    </ng-template>\n  </div>\n  <div class=\"ant-card-meta-description\" *ngIf=\"nzDescription\">\n    <ng-container *ngIf=\"isDescriptionString; else descriptionTemplate\">{{ nzDescription }}</ng-container>\n    <ng-template #descriptionTemplate>\n      <ng-template [ngTemplateOutlet]=\"nzDescription\"></ng-template>\n    </ng-template>\n  </div>\n</div>",
                        host: {
                            '[class.ant-card-meta]': 'true'
                        },
                        styles: ["\n    :host {\n      display: block;\n    }\n  "]
                    }] }
        ];
        NzCardMetaComponent.propDecorators = {
            nzAvatar: [{ type: i0.Input }],
            nzTitle: [{ type: i0.Input }],
            nzDescription: [{ type: i0.Input }]
        };
        return NzCardMetaComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCardTabComponent = /** @class */ (function () {
        function NzCardTabComponent() {
        }
        NzCardTabComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-card-tab',
                        template: "<ng-template>\n  <ng-content></ng-content>\n</ng-template>"
                    }] }
        ];
        NzCardTabComponent.propDecorators = {
            template: [{ type: i0.ViewChild, args: [i0.TemplateRef,] }]
        };
        return NzCardTabComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCardComponent = /** @class */ (function () {
        function NzCardComponent() {
            this._bordered = true;
            this._loading = false;
            this._hoverable = false;
            this.nzActions = [];
        }
        Object.defineProperty(NzCardComponent.prototype, "nzTitle", {
            get: /**
             * @return {?}
             */ function () {
                return this._title;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.isTitleString = !(value instanceof i0.TemplateRef);
                this._title = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCardComponent.prototype, "nzExtra", {
            get: /**
             * @return {?}
             */ function () {
                return this._extra;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.isExtraString = !(value instanceof i0.TemplateRef);
                this._extra = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCardComponent.prototype, "isInner", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzType === 'inner';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCardComponent.prototype, "isTabs", {
            get: /**
             * @return {?}
             */ function () {
                return !!this.tab;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCardComponent.prototype, "nzBordered", {
            get: /**
             * @return {?}
             */ function () {
                return this._bordered;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._bordered = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCardComponent.prototype, "nzLoading", {
            get: /**
             * @return {?}
             */ function () {
                return this._loading;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._loading = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCardComponent.prototype, "nzHoverable", {
            get: /**
             * @return {?}
             */ function () {
                return this._hoverable;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._hoverable = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        NzCardComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-card',
                        preserveWhitespaces: false,
                        template: "<ng-template #titleTemplate>\n  <ng-template [ngTemplateOutlet]=\"nzTitle\"></ng-template>\n</ng-template>\n<ng-template #extraTemplate>\n  <ng-template [ngTemplateOutlet]=\"nzExtra\"></ng-template>\n</ng-template>\n<div class=\"ant-card-head\" *ngIf=\"nzTitle||nzExtra||tab\">\n  <div class=\"ant-card-head-wrapper\">\n    <div class=\"ant-card-head-title\" *ngIf=\"nzTitle\">\n      <ng-container *ngIf=\"isTitleString; else titleTemplate\">{{ nzTitle }}</ng-container>\n    </div>\n    <div class=\"ant-card-extra\" *ngIf=\"nzExtra\">\n      <ng-container *ngIf=\"isExtraString; else extraTemplate\">{{ nzExtra }}</ng-container>\n    </div>\n  </div>\n  <ng-container *ngIf=\"tab\">\n    <ng-template [ngTemplateOutlet]=\"tab.template\"></ng-template>\n  </ng-container>\n</div>\n<div class=\"ant-card-cover\" *ngIf=\"nzCover\">\n  <ng-template [ngTemplateOutlet]=\"nzCover\"></ng-template>\n</div>\n<div class=\"ant-card-body\" [ngStyle]=\"nzBodyStyle\">\n  <ng-container *ngIf=\"!nzLoading\">\n    <ng-content></ng-content>\n  </ng-container>\n  <nz-card-loading *ngIf=\"nzLoading\"></nz-card-loading>\n</div>\n<ul class=\"ant-card-actions\" *ngIf=\"nzActions.length\">\n  <li *ngFor=\"let action of nzActions\" [style.width.%]=\"100/nzActions.length\">\n    <span><ng-template [ngTemplateOutlet]=\"action\"></ng-template></span>\n  </li>\n</ul>",
                        host: {
                            '[class.ant-card]': 'true',
                            '[class.ant-card-loading]': 'nzLoading'
                        },
                        styles: ["\n    :host {\n      display: block;\n      position: relative;\n    }\n  "]
                    }] }
        ];
        NzCardComponent.propDecorators = {
            tab: [{ type: i0.ContentChild, args: [NzCardTabComponent,] }],
            nzBodyStyle: [{ type: i0.Input }],
            nzCover: [{ type: i0.Input }],
            nzActions: [{ type: i0.Input }],
            nzType: [{ type: i0.Input }],
            nzTitle: [{ type: i0.Input }],
            nzExtra: [{ type: i0.Input }],
            isInner: [{ type: i0.HostBinding, args: ['class.ant-card-type-inner',] }],
            isTabs: [{ type: i0.HostBinding, args: ['class.ant-card-contain-tabs',] }],
            nzBordered: [{ type: i0.Input }, { type: i0.HostBinding, args: ['class.ant-card-bordered',] }],
            nzLoading: [{ type: i0.Input }],
            nzHoverable: [{ type: i0.Input }, { type: i0.HostBinding, args: ['class.ant-card-hoverable',] }]
        };
        return NzCardComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCardModule = /** @class */ (function () {
        function NzCardModule() {
        }
        NzCardModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [i1.CommonModule],
                        declarations: [NzCardComponent, NzCardGridDirective, NzCardMetaComponent, NzCardLoadingComponent, NzCardTabComponent],
                        exports: [NzCardComponent, NzCardGridDirective, NzCardMetaComponent, NzCardLoadingComponent, NzCardTabComponent]
                    },] }
        ];
        return NzCardModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCarouselContentDirective = /** @class */ (function () {
        function NzCarouselContentDirective(elementRef, renderer) {
            this.elementRef = elementRef;
            this.renderer = renderer;
            this._active = false;
            this._width = 0;
            this._fadeMode = false;
            this.el = this.elementRef.nativeElement;
        }
        Object.defineProperty(NzCarouselContentDirective.prototype, "width", {
            get: /**
             * @return {?}
             */ function () {
                return this._width;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._width = value;
                this.renderer.setStyle(this.el, 'width', this.width + "px");
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCarouselContentDirective.prototype, "left", {
            get: /**
             * @return {?}
             */ function () {
                return this._left;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._left = value;
                if (isNotNil(this.left)) {
                    this.renderer.setStyle(this.el, 'left', this.left + "px");
                }
                else {
                    this.renderer.removeStyle(this.el, 'left');
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCarouselContentDirective.prototype, "top", {
            get: /**
             * @return {?}
             */ function () {
                return this._top;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._top = value;
                if (isNotNil(this.top)) {
                    this.renderer.setStyle(this.el, 'top', this.top + "px");
                }
                else {
                    this.renderer.removeStyle(this.el, 'top');
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCarouselContentDirective.prototype, "isActive", {
            get: /**
             * @return {?}
             */ function () {
                return this._active;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._active = value;
                this.updateOpacity();
                if (this.isActive) {
                    this.renderer.addClass(this.el, 'slick-active');
                }
                else {
                    this.renderer.removeClass(this.el, 'slick-active');
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCarouselContentDirective.prototype, "fadeMode", {
            get: /**
             * @return {?}
             */ function () {
                return this._fadeMode;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._fadeMode = value;
                if (this.fadeMode) {
                    this.renderer.setStyle(this.el, 'position', 'relative');
                }
                else {
                    this.renderer.removeStyle(this.el, 'position');
                }
                this.updateOpacity();
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzCarouselContentDirective.prototype.updateOpacity = /**
         * @return {?}
         */
            function () {
                if (this.fadeMode) {
                    this.renderer.setStyle(this.el, 'opacity', this.isActive ? 1 : 0);
                }
            };
        /**
         * @return {?}
         */
        NzCarouselContentDirective.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.renderer.setStyle(this.el, 'transition', 'opacity 500ms ease');
            };
        NzCarouselContentDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: '[nz-carousel-content]',
                        host: {
                            '[class.slick-slide]': 'true'
                        }
                    },] }
        ];
        /** @nocollapse */
        NzCarouselContentDirective.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: i0.Renderer2 }
            ];
        };
        return NzCarouselContentDirective;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCarouselComponent = /** @class */ (function () {
        function NzCarouselComponent(elementRef, renderer) {
            this.elementRef = elementRef;
            this.renderer = renderer;
            this._autoPlay = false;
            this._autoPlaySpeed = 3000;
            this._dots = true;
            this._vertical = false;
            this._effect = 'scrollx';
            this.unsubscribe$ = new rxjs.Subject();
            this.activeIndex = 0;
            this.transform = 'translate3d(0px, 0px, 0px)';
            this.nzAfterChange = new i0.EventEmitter();
            this.nzBeforeChange = new i0.EventEmitter();
            this.nzEnableSwipe = true;
        }
        /**
         * @param {?} e
         * @return {?}
         */
        NzCarouselComponent.prototype.onWindowResize = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                this.renderContent();
            };
        Object.defineProperty(NzCarouselComponent.prototype, "nextIndex", {
            get: /**
             * @return {?}
             */ function () {
                return this.activeIndex < this.slideContents.length - 1 ? (this.activeIndex + 1) : 0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCarouselComponent.prototype, "prevIndex", {
            get: /**
             * @return {?}
             */ function () {
                return this.activeIndex > 0 ? (this.activeIndex - 1) : (this.slideContents.length - 1);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCarouselComponent.prototype, "nzDots", {
            get: /**
             * @return {?}
             */ function () {
                return this._dots;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._dots = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCarouselComponent.prototype, "nzEffect", {
            get: /**
             * @return {?}
             */ function () {
                return this._effect;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._effect = value;
                this.updateMode();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCarouselComponent.prototype, "nzAutoPlay", {
            get: /**
             * @return {?}
             */ function () {
                return this._autoPlay;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._autoPlay = toBoolean(value);
                this.setUpAutoPlay();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCarouselComponent.prototype, "nzAutoPlaySpeed", {
            get: /**
             * @return {?}
             */ function () {
                return this._autoPlaySpeed;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._autoPlaySpeed = toNumber(value, null);
                this.setUpAutoPlay();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCarouselComponent.prototype, "nzVertical", {
            get: /**
             * @return {?}
             */ function () {
                return this._vertical;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._vertical = toBoolean(value);
                this.updateMode();
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} content
         * @param {?} i
         * @return {?}
         */
        NzCarouselComponent.prototype.setActive = /**
         * @param {?} content
         * @param {?} i
         * @return {?}
         */
            function (content, i) {
                if (this.slideContents && this.slideContents.length) {
                    this.setUpAutoPlay();
                    /** @type {?} */
                    var beforeIndex = this.slideContents.toArray().findIndex(function (slide) { return slide.isActive; });
                    this.nzBeforeChange.emit({ from: beforeIndex, to: i });
                    this.activeIndex = i;
                    if (this.nzEffect === 'scrollx') {
                        if (this.nzVertical) {
                            this.transform = "translate3d(0px, " + -this.activeIndex * this.elementRef.nativeElement.offsetHeight + "px, 0px)";
                        }
                        else {
                            this.transform = "translate3d(" + -this.activeIndex * this.elementRef.nativeElement.offsetWidth + "px, 0px, 0px)";
                        }
                    }
                    else {
                        this.transform = 'translate3d(0px, 0px, 0px)';
                    }
                    this.slideContents.forEach(function (slide) { return slide.isActive = slide === content; });
                    this.nzAfterChange.emit(i);
                }
            };
        /**
         * @return {?}
         */
        NzCarouselComponent.prototype.renderContent = /**
         * @return {?}
         */
            function () {
                var _this = this;
                if (this.slideContents && this.slideContents.length) {
                    this.slideContents.forEach(function (content, i) {
                        content.width = _this.elementRef.nativeElement.offsetWidth;
                        if (_this.nzEffect === 'fade') {
                            content.fadeMode = true;
                            if (_this.nzVertical) {
                                content.top = -i * _this.elementRef.nativeElement.offsetHeight;
                            }
                            else {
                                content.left = -i * content.width;
                            }
                        }
                        else {
                            content.fadeMode = false;
                            content.left = null;
                            content.top = null;
                        }
                    });
                    if (this.nzVertical) {
                        this.renderer.removeStyle(this.slickTrack.nativeElement, 'width');
                        this.renderer.removeStyle(this.slickList.nativeElement, 'width');
                        this.renderer.removeStyle(this.slickList.nativeElement, 'height');
                        this.renderer.setStyle(this.slickList.nativeElement, 'height', this.slideContents.first.el.offsetHeight + "px");
                        this.renderer.removeStyle(this.slickTrack.nativeElement, 'height');
                        this.renderer.setStyle(this.slickTrack.nativeElement, 'height', this.slideContents.length * this.elementRef.nativeElement.offsetHeight + "px");
                    }
                    else {
                        this.renderer.removeStyle(this.slickTrack.nativeElement, 'height');
                        this.renderer.removeStyle(this.slickList.nativeElement, 'height');
                        this.renderer.removeStyle(this.slickTrack.nativeElement, 'width');
                        this.renderer.setStyle(this.slickTrack.nativeElement, 'width', this.slideContents.length * this.elementRef.nativeElement.offsetWidth + "px");
                    }
                    this.setUpAutoPlay();
                }
            };
        /**
         * @return {?}
         */
        NzCarouselComponent.prototype.setUpAutoPlay = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.clearTimeout();
                if (this.nzAutoPlay && this.nzAutoPlaySpeed > 0) {
                    this.timeout = setTimeout(function (_) {
                        _this.setActive(_this.slideContents.toArray()[_this.nextIndex], _this.nextIndex);
                    }, this.nzAutoPlaySpeed);
                }
            };
        /**
         * @return {?}
         */
        NzCarouselComponent.prototype.updateMode = /**
         * @return {?}
         */
            function () {
                if (this.slideContents && this.slideContents.length) {
                    this.renderContent();
                    this.setActive(this.slideContents.first, 0);
                }
            };
        /**
         * @return {?}
         */
        NzCarouselComponent.prototype.clearTimeout = /**
         * @return {?}
         */
            function () {
                if (this.timeout) {
                    clearTimeout(this.timeout);
                    this.timeout = null;
                }
            };
        /**
         * @return {?}
         */
        NzCarouselComponent.prototype.next = /**
         * @return {?}
         */
            function () {
                this.setActive(this.slideContents.toArray()[this.nextIndex], this.nextIndex);
            };
        /**
         * @return {?}
         */
        NzCarouselComponent.prototype.pre = /**
         * @return {?}
         */
            function () {
                this.setActive(this.slideContents.toArray()[this.prevIndex], this.prevIndex);
            };
        /**
         * @param {?} index
         * @return {?}
         */
        NzCarouselComponent.prototype.goTo = /**
         * @param {?} index
         * @return {?}
         */
            function (index) {
                if (index >= 0 && index <= this.slideContents.length - 1) {
                    this.setActive(this.slideContents.toArray()[index], index);
                }
            };
        /**
         * @param {?} e
         * @return {?}
         */
        NzCarouselComponent.prototype.onKeyDown = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                if (e.keyCode === 37) { // Left
                    // Left
                    this.pre();
                    e.preventDefault();
                }
                else if (e.keyCode === 39) { // Right
                    // Right
                    this.next();
                    e.preventDefault();
                }
            };
        /**
         * @param {?=} action
         * @return {?}
         */
        NzCarouselComponent.prototype.swipe = /**
         * @param {?=} action
         * @return {?}
         */
            function (action) {
                if (action === void 0) {
                    action = 'swipeleft';
                }
                if (!this.nzEnableSwipe) {
                    return;
                }
                if (action === 'swipeleft') {
                    this.next();
                }
                if (action === 'swiperight') {
                    this.pre();
                }
            };
        /* tslint:disable:no-any */
        /**
         * @param {?} e
         * @return {?}
         */
        NzCarouselComponent.prototype.swipeInProgress = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                if (this.nzEffect === 'scrollx') {
                    /** @type {?} */
                    var final = e.isFinal;
                    /** @type {?} */
                    var scrollWidth = final ? 0 : e.deltaX * 1.2;
                    /** @type {?} */
                    var totalWidth = this.elementRef.nativeElement.offsetWidth;
                    if (this.nzVertical) {
                        /** @type {?} */
                        var totalHeight = this.elementRef.nativeElement.offsetHeight;
                        /** @type {?} */
                        var scrollPercent = scrollWidth / totalWidth;
                        /** @type {?} */
                        var scrollHeight = scrollPercent * totalHeight;
                        this.transform = "translate3d(0px, " + (-this.activeIndex * totalHeight + scrollHeight) + "px, 0px)";
                    }
                    else {
                        this.transform = "translate3d(" + (-this.activeIndex * totalWidth + scrollWidth) + "px, 0px, 0px)";
                    }
                }
                if (e.isFinal) {
                    this.setUpAutoPlay();
                }
                else {
                    this.clearTimeout();
                }
            };
        /**
         * @return {?}
         */
        NzCarouselComponent.prototype.ngAfterContentInit = /**
         * @return {?}
         */
            function () {
                if (this.slideContents && this.slideContents.length) {
                    this.slideContents.first.isActive = true;
                }
            };
        /**
         * @return {?}
         */
        NzCarouselComponent.prototype.ngAfterViewInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.slideContents.changes
                    .pipe(operators.takeUntil(this.unsubscribe$))
                    .subscribe(function () {
                    _this.renderContent();
                });
                this.renderContent();
            };
        /**
         * @return {?}
         */
        NzCarouselComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.unsubscribe$.next();
                this.unsubscribe$.complete();
                this.clearTimeout();
            };
        NzCarouselComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-carousel',
                        preserveWhitespaces: false,
                        template: "<div class=\"slick-initialized slick-slider\" [class.slick-vertical]=\"nzVertical\">\n  <div class=\"slick-list\" #slickList tabindex=\"-1\" (keydown)=\"onKeyDown($event)\" \n    (swipeleft)=\"swipe('swipeleft')\" (swiperight)=\"swipe('swiperight')\" (pan)=\"swipeInProgress($event);\">\n    <div class=\"slick-track\" [style.transform]=\"transform\" #slickTrack (mousedown)=\"$event.preventDefault()\">\n      <ng-content></ng-content>\n    </div>\n  </div>\n  <ul class=\"slick-dots\" *ngIf=\"nzDots\">\n    <li\n      *ngFor=\"let content of slideContents; let i =index\"\n      [class.slick-active]=\"content.isActive\"\n      (click)=\"setActive(content,i)\">\n      <ng-template [ngTemplateOutlet]=\"nzDotRender || renderDotTemplate\" [ngTemplateOutletContext]=\"{ $implicit: i }\"></ng-template>\n    </li>\n  </ul>\n</div>\n\n<ng-template #renderDotTemplate let-index>\n  <button>{{index + 1}}</button>\n</ng-template>",
                        host: {
                            '[class.ant-carousel]': 'true'
                        },
                        styles: ["\n      :host {\n        display: block;\n        position: relative;\n        overflow: hidden;\n        width: 100%;\n        height: 100%;\n      }\n\n      .slick-dots {\n        display: block;\n      }\n\n      .slick-track {\n        opacity: 1;\n        transition: all 0.5s ease;\n      }\n\n      .slick-slide {\n        transition: opacity 500ms ease;\n      }\n\n    "]
                    }] }
        ];
        /** @nocollapse */
        NzCarouselComponent.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: i0.Renderer2 }
            ];
        };
        NzCarouselComponent.propDecorators = {
            slideContents: [{ type: i0.ContentChildren, args: [NzCarouselContentDirective,] }],
            slickList: [{ type: i0.ViewChild, args: ['slickList',] }],
            slickTrack: [{ type: i0.ViewChild, args: ['slickTrack',] }],
            nzAfterChange: [{ type: i0.Output }],
            nzBeforeChange: [{ type: i0.Output }],
            nzEnableSwipe: [{ type: i0.Input }],
            onWindowResize: [{ type: i0.HostListener, args: ['window:resize', ['$event'],] }],
            nzDotRender: [{ type: i0.Input }],
            nzDots: [{ type: i0.Input }],
            nzEffect: [{ type: i0.Input }],
            nzAutoPlay: [{ type: i0.Input }],
            nzAutoPlaySpeed: [{ type: i0.Input }],
            nzVertical: [{ type: i0.Input }, { type: i0.HostBinding, args: ['class.ant-carousel-vertical',] }]
        };
        return NzCarouselComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCarouselModule = /** @class */ (function () {
        function NzCarouselModule() {
        }
        NzCarouselModule.decorators = [
            { type: i0.NgModule, args: [{
                        declarations: [NzCarouselComponent, NzCarouselContentDirective],
                        exports: [NzCarouselComponent, NzCarouselContentDirective],
                        imports: [i1.CommonModule]
                    },] }
        ];
        return NzCarouselModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    // Thanks to https://github.com/andreypopp/react-textarea-autosize/
    /**
     * calculateNodeHeight(uiTextNode, useCache = false)
     */
    /** @type {?} */
    var HIDDEN_TEXTAREA_STYLE = "\n  min-height:0 !important;\n  max-height:none !important;\n  height:0 !important;\n  visibility:hidden !important;\n  overflow:hidden !important;\n  position:absolute !important;\n  z-index:-1000 !important;\n  top:0 !important;\n  right:0 !important\n";
    /** @type {?} */
    var SIZING_STYLE = [
        'letter-spacing',
        'line-height',
        'padding-top',
        'padding-bottom',
        'font-family',
        'font-weight',
        'font-size',
        'text-rendering',
        'text-transform',
        'width',
        'text-indent',
        'padding-left',
        'padding-right',
        'border-width',
        'box-sizing'
    ];
    /** @type {?} */
    var computedStyleCache = {};
    /** @type {?} */
    var hiddenTextarea;
    /**
     * @param {?} node
     * @param {?=} useCache
     * @return {?}
     */
    function calculateNodeStyling(node, useCache) {
        if (useCache === void 0) {
            useCache = false;
        }
        /** @type {?} */
        var nodeRef = /** @type {?} */ ((node.getAttribute('id') ||
            node.getAttribute('data-reactid') ||
            node.getAttribute('name')));
        if (useCache && computedStyleCache[nodeRef]) {
            return computedStyleCache[nodeRef];
        }
        /** @type {?} */
        var style = window.getComputedStyle(node);
        /** @type {?} */
        var boxSizing = (style.getPropertyValue('box-sizing') ||
            style.getPropertyValue('-moz-box-sizing') ||
            style.getPropertyValue('-webkit-box-sizing'));
        /** @type {?} */
        var paddingSize = (parseFloat(style.getPropertyValue('padding-bottom')) +
            parseFloat(style.getPropertyValue('padding-top')));
        /** @type {?} */
        var borderSize = (parseFloat(style.getPropertyValue('border-bottom-width')) +
            parseFloat(style.getPropertyValue('border-top-width')));
        /** @type {?} */
        var sizingStyle = SIZING_STYLE
            .map(function (name) { return name + ":" + style.getPropertyValue(name); })
            .join(';');
        /** @type {?} */
        var nodeInfo = {
            sizingStyle: sizingStyle,
            paddingSize: paddingSize,
            borderSize: borderSize,
            boxSizing: boxSizing
        };
        if (useCache && nodeRef) {
            computedStyleCache[nodeRef] = nodeInfo;
        }
        return nodeInfo;
    }
    /**
     * @param {?} uiTextNode
     * @param {?=} useCache
     * @param {?=} minRows
     * @param {?=} maxRows
     * @return {?}
     */
    function calculateNodeHeight(uiTextNode, useCache, minRows, maxRows) {
        if (useCache === void 0) {
            useCache = false;
        }
        if (minRows === void 0) {
            minRows = null;
        }
        if (maxRows === void 0) {
            maxRows = null;
        }
        if (!hiddenTextarea) {
            hiddenTextarea = document.createElement('textarea');
            document.body.appendChild(hiddenTextarea);
        }
        // Fix wrap="off" issue
        // https://github.com/ant-design/ant-design/issues/6577
        if (uiTextNode.getAttribute('wrap')) {
            hiddenTextarea.setAttribute('wrap', /** @type {?} */ (uiTextNode.getAttribute('wrap')));
        }
        else {
            hiddenTextarea.removeAttribute('wrap');
        }
        var _a = calculateNodeStyling(uiTextNode, useCache), paddingSize = _a.paddingSize, borderSize = _a.borderSize, boxSizing = _a.boxSizing, sizingStyle = _a.sizingStyle;
        // Need to have the overflow attribute to hide the scrollbar otherwise
        // text-lines will not calculated properly as the shadow will technically be
        // narrower for content
        hiddenTextarea.setAttribute('style', sizingStyle + ";" + HIDDEN_TEXTAREA_STYLE);
        hiddenTextarea.value = uiTextNode.value || uiTextNode.placeholder || '';
        /** @type {?} */
        var minHeight = Number.MIN_SAFE_INTEGER;
        /** @type {?} */
        var maxHeight = Number.MAX_SAFE_INTEGER;
        /** @type {?} */
        var height = hiddenTextarea.scrollHeight;
        /** @type {?} */
        var overflowY;
        if (boxSizing === 'border-box') {
            // border-box: add border, since height = content + padding + border
            height = height + borderSize;
        }
        else if (boxSizing === 'content-box') {
            // remove padding, since height = content
            height = height - paddingSize;
        }
        if (minRows !== null || maxRows !== null) {
            // measure height of a textarea with a single row
            hiddenTextarea.value = '';
            /** @type {?} */
            var singleRowHeight = hiddenTextarea.scrollHeight - paddingSize;
            if (minRows !== null) {
                minHeight = singleRowHeight * minRows;
                if (boxSizing === 'border-box') {
                    minHeight = minHeight + paddingSize + borderSize;
                }
                height = Math.max(minHeight, height);
            }
            if (maxRows !== null) {
                maxHeight = singleRowHeight * maxRows;
                if (boxSizing === 'border-box') {
                    maxHeight = maxHeight + paddingSize + borderSize;
                }
                overflowY = height > maxHeight ? '' : 'hidden';
                height = Math.min(maxHeight, height);
            }
        }
        // Remove scroll bar flash when autosize without maxRows
        if (!maxRows) {
            overflowY = 'hidden';
        }
        return { height: height, minHeight: minHeight, maxHeight: maxHeight, overflowY: overflowY };
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzInputDirective = /** @class */ (function () {
        function NzInputDirective(elementRef, renderer, ngModel, ngControl) {
            this.elementRef = elementRef;
            this.renderer = renderer;
            this.ngModel = ngModel;
            this.ngControl = ngControl;
            this._size = 'default';
            this._disabled = false;
            this._autosize = false;
            this.isInit = false;
            this.el = this.elementRef.nativeElement;
        }
        Object.defineProperty(NzInputDirective.prototype, "nzSize", {
            get: /**
             * @return {?}
             */ function () {
                return this._size;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._size = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputDirective.prototype, "disabled", {
            get: /**
             * @return {?}
             */ function () {
                if (this.ngControl && this.ngControl.disabled !== null) {
                    return this.ngControl.disabled;
                }
                return this._disabled;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._disabled = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputDirective.prototype, "nzAutosize", {
            get: /**
             * @return {?}
             */ function () {
                return this._autosize;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (typeof value === 'string') {
                    this._autosize = true;
                }
                else {
                    this._autosize = value;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputDirective.prototype, "setLgClass", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzSize === 'large';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputDirective.prototype, "setSmClass", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzSize === 'small';
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzInputDirective.prototype.textAreaOnChange = /**
         * @return {?}
         */
            function () {
                if (this.nzAutosize) {
                    this.resizeTextArea();
                }
            };
        /**
         * @return {?}
         */
        NzInputDirective.prototype.resizeTextArea = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var textAreaRef = /** @type {?} */ (this.el);
                /** @type {?} */
                var maxRows = this.nzAutosize ? ( /** @type {?} */(this.nzAutosize)).maxRows || null : null;
                /** @type {?} */
                var minRows = this.nzAutosize ? ( /** @type {?} */(this.nzAutosize)).minRows || null : null;
                if ((this.previousValue === textAreaRef.value) && (this.previewsMaxRows === maxRows) && (this.previewsMinRows === minRows)) {
                    return;
                }
                this.previousValue = textAreaRef.value;
                this.previewsMinRows = minRows;
                this.previewsMaxRows = maxRows;
                // eliminate jitter
                this.renderer.setStyle(textAreaRef, 'height', 'auto');
                /** @type {?} */
                var textAreaStyles = calculateNodeHeight(textAreaRef, false, minRows, maxRows);
                this.renderer.setStyle(textAreaRef, 'height', textAreaStyles.height + "px");
                this.renderer.setStyle(textAreaRef, 'overflowY', textAreaStyles.overflowY);
                this.renderer.setStyle(textAreaRef, 'minHeight', textAreaStyles.minHeight + "px");
                this.renderer.setStyle(textAreaRef, 'maxHeight', textAreaStyles.maxHeight + "px");
            };
        /**
         * @return {?}
         */
        NzInputDirective.prototype.ngDoCheck = /**
         * @return {?}
         */
            function () {
                if (this.nzAutosize && this.isInit) {
                    this.resizeTextArea();
                }
            };
        /**
         * @return {?}
         */
        NzInputDirective.prototype.ngAfterViewInit = /**
         * @return {?}
         */
            function () {
                this.isInit = true;
                if (this.nzAutosize) {
                    this.resizeTextArea();
                }
            };
        NzInputDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: '[nz-input]',
                        host: {
                            '[class.ant-input]': 'true'
                        }
                    },] }
        ];
        /** @nocollapse */
        NzInputDirective.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: i0.Renderer2 },
                { type: forms.NgModel, decorators: [{ type: i0.Optional }] },
                { type: forms.NgControl, decorators: [{ type: i0.Optional }, { type: i0.Self }] }
            ];
        };
        NzInputDirective.propDecorators = {
            nzSize: [{ type: i0.Input }],
            disabled: [{ type: i0.Input }, { type: i0.HostBinding, args: ["class.ant-input-disabled",] }],
            nzAutosize: [{ type: i0.Input }],
            setLgClass: [{ type: i0.HostBinding, args: ["class.ant-input-lg",] }],
            setSmClass: [{ type: i0.HostBinding, args: ["class.ant-input-sm",] }],
            textAreaOnChange: [{ type: i0.HostListener, args: ['input',] }]
        };
        return NzInputDirective;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzInputGroupComponent = /** @class */ (function () {
        function NzInputGroupComponent(el) {
            this.el = el;
            this._addOnBefore = '';
            this._addOnAfter = '';
            this._prefix = '';
            this._suffix = '';
            this._size = 'default';
            this._compact = false;
            this._search = false;
        }
        Object.defineProperty(NzInputGroupComponent.prototype, "nzSize", {
            get: /**
             * @return {?}
             */ function () {
                return this._size;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._size = value;
                this.updateChildrenInputSize();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "nzCompact", {
            get: /**
             * @return {?}
             */ function () {
                return this._compact;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._compact = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "nzAddOnBefore", {
            get: /**
             * @return {?}
             */ function () {
                return this._addOnBefore;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.isAddOnBeforeString = !(value instanceof i0.TemplateRef);
                this._addOnBefore = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "nzAddOnAfter", {
            get: /**
             * @return {?}
             */ function () {
                return this._addOnAfter;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.isAddOnAfterString = !(value instanceof i0.TemplateRef);
                this._addOnAfter = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "nzPrefix", {
            get: /**
             * @return {?}
             */ function () {
                return this._prefix;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.isPrefixString = !(value instanceof i0.TemplateRef);
                this._prefix = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "nzSuffix", {
            get: /**
             * @return {?}
             */ function () {
                return this._suffix;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.isSuffixString = !(value instanceof i0.TemplateRef);
                this._suffix = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "nzSearch", {
            get: /**
             * @return {?}
             */ function () {
                return this._search;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._search = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "isLarge", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzSize === 'large';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "isSmall", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzSize === 'small';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "isAffix", {
            get: /**
             * @return {?}
             */ function () {
                return (!!(this.nzSuffix || this.nzPrefix || this.nzPrefixIcon || this.nzSuffixIcon));
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "isAffixWrapper", {
            get: /**
             * @return {?}
             */ function () {
                return (!!(this.nzSuffix || this.nzPrefix || this.nzPrefixIcon || this.nzSuffixIcon)) && !this.isAddOn;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "isAddOn", {
            get: /**
             * @return {?}
             */ function () {
                return !!(this.nzAddOnAfter || this.nzAddOnBefore || this.nzAddOnAfterIcon || this.nzAddOnBeforeIcon);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "isGroup", {
            get: /**
             * @return {?}
             */ function () {
                return (!this.isAffix) && (!this.isAddOn);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "isLargeGroup", {
            get: /**
             * @return {?}
             */ function () {
                return this.isGroup && this.isLarge;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "isLargeGroupWrapper", {
            get: /**
             * @return {?}
             */ function () {
                return this.isAddOn && this.isLarge;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "isLargeAffix", {
            get: /**
             * @return {?}
             */ function () {
                return this.isAffixWrapper && this.isLarge;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "isLargeSearch", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzSearch && this.isLarge;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "isSmallGroup", {
            get: /**
             * @return {?}
             */ function () {
                return this.isGroup && this.isSmall;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "isSmallAffix", {
            get: /**
             * @return {?}
             */ function () {
                return this.isAffixWrapper && this.isSmall;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "isSmallGroupWrapper", {
            get: /**
             * @return {?}
             */ function () {
                return this.isAddOn && this.isSmall;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputGroupComponent.prototype, "isSmallSearch", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzSearch && this.isSmall;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzInputGroupComponent.prototype.updateChildrenInputSize = /**
         * @return {?}
         */
            function () {
                var _this = this;
                if (this.nzInputDirectiveQueryList) {
                    this.nzInputDirectiveQueryList.forEach(function (item) { return item.nzSize = _this.nzSize; });
                }
            };
        /**
         * @return {?}
         */
        NzInputGroupComponent.prototype.ngAfterContentInit = /**
         * @return {?}
         */
            function () {
                this.updateChildrenInputSize();
            };
        NzInputGroupComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-input-group',
                        preserveWhitespaces: false,
                        template: "<span class=\"ant-input-wrapper ant-input-group\" *ngIf=\"isAddOn\">\n  <span class=\"ant-input-group-addon\" *ngIf=\"nzAddOnBefore || nzAddOnBeforeIcon\">\n    <i [ngClass]=\"nzAddOnBeforeIcon\" *ngIf=\"nzAddOnBeforeIcon\"></i>\n    <ng-container *ngIf=\"isAddOnBeforeString; else addOnBeforeTemplate\">{{ nzAddOnBefore }}</ng-container>\n    <ng-template #addOnBeforeTemplate>\n      <ng-template [ngTemplateOutlet]=\"nzAddOnBefore\"></ng-template>\n    </ng-template>\n  </span>\n  <ng-template [ngIf]=\"!isAffix\" *ngTemplateOutlet=\"contentTemplate\"></ng-template>\n  <span class=\"ant-input-affix-wrapper\" [class.ant-input-affix-wrapper-sm]=\"isSmall\" [class.ant-input-affix-wrapper-lg]=\"isLarge\" *ngIf=\"isAffix\">\n    <ng-template *ngTemplateOutlet=\"affixTemplate\"></ng-template>\n  </span>\n  <span class=\"ant-input-group-addon\" *ngIf=\"nzAddOnAfter || nzAddOnAfterIcon\">\n    <i [ngClass]=\"nzAddOnAfterIcon\" *ngIf=\"nzAddOnAfterIcon\"></i>\n    <ng-container *ngIf=\"isAddOnAfterString; else addOnAfterTemplate\">{{ nzAddOnAfter }}</ng-container>\n    <ng-template #addOnAfterTemplate>\n      <ng-template [ngTemplateOutlet]=\"nzAddOnAfter\"></ng-template>\n    </ng-template>\n  </span>\n</span>\n<ng-container *ngIf=\"isAffix && !isAddOn\">\n  <ng-template *ngTemplateOutlet=\"affixTemplate\"></ng-template>\n</ng-container>\n<ng-template #affixTemplate>\n  <span class=\"ant-input-prefix\" *ngIf=\"nzPrefix || nzPrefixIcon\">\n    <i [ngClass]=\"nzPrefixIcon\" *ngIf=\"nzPrefixIcon\"></i>\n    <ng-container *ngIf=\"isPrefixString; else prefixTemplate\">{{ nzPrefix }}</ng-container>\n    <ng-template #prefixTemplate>\n      <ng-template [ngTemplateOutlet]=\"nzPrefix\"></ng-template>\n    </ng-template>\n  </span>\n  <ng-template *ngTemplateOutlet=\"contentTemplate\"></ng-template>\n  <span class=\"ant-input-suffix\" *ngIf=\"nzSuffix || nzSuffixIcon\">\n    <i [ngClass]=\"nzSuffixIcon\" *ngIf=\"nzSuffixIcon\"></i>\n    <ng-container *ngIf=\"isSuffixString; else suffixTemplate\">{{ nzSuffix }}</ng-container>\n    <ng-template #suffixTemplate>\n      <ng-template [ngTemplateOutlet]=\"nzSuffix\"></ng-template>\n    </ng-template>\n  </span>\n</ng-template>\n<ng-template [ngIf]=\"isGroup\" *ngTemplateOutlet=\"contentTemplate\"></ng-template>\n<ng-template #contentTemplate>\n  <ng-content></ng-content>\n</ng-template>"
                    }] }
        ];
        /** @nocollapse */
        NzInputGroupComponent.ctorParameters = function () {
            return [
                { type: i0.ElementRef }
            ];
        };
        NzInputGroupComponent.propDecorators = {
            nzInputDirectiveQueryList: [{ type: i0.ContentChildren, args: [NzInputDirective,] }],
            nzAddOnBeforeIcon: [{ type: i0.Input }],
            nzAddOnAfterIcon: [{ type: i0.Input }],
            nzPrefixIcon: [{ type: i0.Input }],
            nzSuffixIcon: [{ type: i0.Input }],
            nzSize: [{ type: i0.Input }],
            nzCompact: [{ type: i0.Input }, { type: i0.HostBinding, args: ["class.ant-input-group-compact",] }],
            nzAddOnBefore: [{ type: i0.Input }],
            nzAddOnAfter: [{ type: i0.Input }],
            nzPrefix: [{ type: i0.Input }],
            nzSuffix: [{ type: i0.Input }],
            nzSearch: [{ type: i0.Input }, { type: i0.HostBinding, args: ["class.ant-input-search-enter-button",] }, { type: i0.HostBinding, args: ["class.ant-input-search",] }],
            isAffixWrapper: [{ type: i0.HostBinding, args: ['class.ant-input-affix-wrapper',] }],
            isAddOn: [{ type: i0.HostBinding, args: ['class.ant-input-group-wrapper',] }],
            isGroup: [{ type: i0.HostBinding, args: ['class.ant-input-group',] }],
            isLargeGroup: [{ type: i0.HostBinding, args: ["class.ant-input-group-lg",] }],
            isLargeGroupWrapper: [{ type: i0.HostBinding, args: ["class.ant-input-group-wrapper-lg",] }],
            isLargeAffix: [{ type: i0.HostBinding, args: ["class.ant-input-affix-wrapper-lg",] }],
            isLargeSearch: [{ type: i0.HostBinding, args: ["class.ant-input-search-lg",] }],
            isSmallGroup: [{ type: i0.HostBinding, args: ["class.ant-input-group-sm",] }],
            isSmallAffix: [{ type: i0.HostBinding, args: ["class.ant-input-affix-wrapper-sm",] }],
            isSmallGroupWrapper: [{ type: i0.HostBinding, args: ["class.ant-input-group-wrapper-sm",] }],
            isSmallSearch: [{ type: i0.HostBinding, args: ["class.ant-input-search-sm",] }]
        };
        return NzInputGroupComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzInputModule = /** @class */ (function () {
        function NzInputModule() {
        }
        NzInputModule.decorators = [
            { type: i0.NgModule, args: [{
                        declarations: [NzInputDirective, NzInputGroupComponent],
                        exports: [NzInputDirective, NzInputGroupComponent],
                        imports: [i1.CommonModule, forms.FormsModule]
                    },] }
        ];
        return NzInputModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var POSITION_MAP = /** @type {?} */ (({
        'top': {
            originX: 'center',
            originY: 'top',
            overlayX: 'center',
            overlayY: 'bottom'
        },
        'topCenter': {
            originX: 'center',
            originY: 'top',
            overlayX: 'center',
            overlayY: 'bottom'
        },
        'topLeft': {
            originX: 'start',
            originY: 'top',
            overlayX: 'start',
            overlayY: 'bottom'
        },
        'topRight': {
            originX: 'end',
            originY: 'top',
            overlayX: 'end',
            overlayY: 'bottom'
        },
        'right': {
            originX: 'end',
            originY: 'center',
            overlayX: 'start',
            overlayY: 'center',
        },
        'rightTop': {
            originX: 'end',
            originY: 'top',
            overlayX: 'start',
            overlayY: 'top',
        },
        'rightBottom': {
            originX: 'end',
            originY: 'bottom',
            overlayX: 'start',
            overlayY: 'bottom',
        },
        'bottom': {
            originX: 'center',
            originY: 'bottom',
            overlayX: 'center',
            overlayY: 'top',
        },
        'bottomCenter': {
            originX: 'center',
            originY: 'bottom',
            overlayX: 'center',
            overlayY: 'top',
        },
        'bottomLeft': {
            originX: 'start',
            originY: 'bottom',
            overlayX: 'start',
            overlayY: 'top',
        },
        'bottomRight': {
            originX: 'end',
            originY: 'bottom',
            overlayX: 'end',
            overlayY: 'top',
        },
        'left': {
            originX: 'start',
            originY: 'center',
            overlayX: 'end',
            overlayY: 'center',
        },
        'leftTop': {
            originX: 'start',
            originY: 'top',
            overlayX: 'end',
            overlayY: 'top',
        },
        'leftBottom': {
            originX: 'start',
            originY: 'bottom',
            overlayX: 'end',
            overlayY: 'bottom',
        },
    }));
    /** @type {?} */
    var DEFAULT_4_POSITIONS = _objectValues([POSITION_MAP["top"], POSITION_MAP["right"], POSITION_MAP["bottom"], POSITION_MAP["left"]]);
    /** @type {?} */
    var DEFAULT_DROPDOWN_POSITIONS = _objectValues([POSITION_MAP["bottomLeft"], POSITION_MAP["topLeft"]]);
    /** @type {?} */
    var DEFAULT_MENTION_POSITIONS = /** @type {?} */ ([
        POSITION_MAP["bottomLeft"],
        {
            originX: 'start',
            originY: 'bottom',
            overlayX: 'start',
            overlayY: 'bottom'
        }
    ]);
    /**
     * @template T, S
     * @param {?} array
     * @param {?} iteratee
     * @return {?}
     */
    function arrayMap(array, iteratee) {
        /** @type {?} */
        var index = -1;
        /** @type {?} */
        var length = array == null ? 0 : array.length;
        /** @type {?} */
        var result = Array(length);
        while (++index < length) {
            result[index] = iteratee(array[index], index, array);
        }
        return result;
    }
    /**
     * @template T
     * @param {?} object
     * @param {?} props
     * @return {?}
     */
    function baseValues(object, props) {
        return arrayMap(props, function (key) {
            return object[key];
        });
    }
    /**
     * @template T
     * @param {?} object
     * @return {?}
     */
    function _objectValues(object) {
        return object == null ? [] : baseValues(object, Object.keys(object));
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * @template T
     * @param {?} value
     * @return {?}
     */
    function toArray(value) {
        /** @type {?} */
        var ret;
        if (value == null) {
            ret = [];
        }
        else if (!Array.isArray(value)) {
            ret = [value];
        }
        else {
            ret = value;
        }
        return ret;
    }
    /**
     * @template T
     * @param {?} array1
     * @param {?} array2
     * @return {?}
     */
    function arrayEquals(array1, array2) {
        if (!array1 || !array2 || array1.length !== array2.length) {
            return false;
        }
        /** @type {?} */
        var len = array1.length;
        for (var i = 0; i < len; i++) {
            if (array1[i] !== array2[i]) {
                return false;
            }
        }
        return true;
    }
    /** @type {?} */
    var defaultDisplayRender = function (label) { return label.join(' / '); };
    var NzCascaderComponent = /** @class */ (function () {
        function NzCascaderComponent(elementRef, cdr, nzUpdateHostClassService) {
            this.elementRef = elementRef;
            this.cdr = cdr;
            this.nzUpdateHostClassService = nzUpdateHostClassService;
            this.allowClear = true;
            this.autoFocus = false;
            this.disabled = false;
            this.enableCache = true;
            this.showArrow = true;
            this.showInput = true;
            this.size = 'default';
            this.prefixCls = 'ant-cascader';
            this.inputPrefixCls = 'ant-input';
            this.changeOnSelect = false;
            this.dropDownPosition = 'bottom';
            this.menuVisible = false;
            this.isLoading = false;
            this.isOpening = false;
            this.isFocused = false;
            this.isLabelRenderTemplate = false;
            this.labelRenderContext = {};
            this.selectedOptions = [];
            this.activatedOptions = [];
            this.nzColumns = [];
            /**
             * 搜索相关的输入值
             */
            this._inputValue = '';
            // ngModel Access
            this.onChange = Function.prototype;
            this.onTouched = Function.prototype;
            this.positions = __spread(DEFAULT_DROPDOWN_POSITIONS);
            /**
             * If cascader is in search mode.
             */
            this.inSearch = false;
            /**
             * Hover text for the clear icon
             */
            this.nzClearText = 'Clear';
            /**
             * Expand column item when click or hover, one of 'click' 'hover'
             */
            this.nzExpandTrigger = 'click';
            /**
             * Specify content to show when no result matches.
             */
            this.nzNotFoundContent = 'Not Found';
            /**
             * Input placeholder
             */
            this.nzPlaceHolder = 'Please select';
            /**
             * Delay time to show when mouse enter, when `nzExpandTrigger` is `hover`.
             */
            this.nzMouseEnterDelay = 150;
            /**
             * Delay time to hide when mouse enter, when `nzExpandTrigger` is `hover`.
             */
            this.nzMouseLeaveDelay = 150;
            /**
             * Triggering mode: can be Array<'click'|'hover'>
             */
            this.nzTriggerAction = ['click'];
            /**
             * Property name for getting `value` in the option
             */
            this.nzValueProperty = 'value';
            /**
             * Property name for getting `label` in the option
             */
            this.nzLabelProperty = 'label';
            /**
             * Event: emit on popup show or hide
             */
            this.nzVisibleChange = new i0.EventEmitter();
            /**
             * Event: emit on values changed
             */
            this.nzChange = new i0.EventEmitter();
            /**
             * Event: emit on values and selection changed
             */
            this.nzSelectionChange = new i0.EventEmitter();
            /**
             * Event: emit on option selected, event data：{option: any, index: number}
             */
            this.nzSelect = new i0.EventEmitter();
            /**
             * Event: emit on the clear button clicked
             */
            this.nzClear = new i0.EventEmitter();
            this.el = this.elementRef.nativeElement;
        }
        Object.defineProperty(NzCascaderComponent.prototype, "inputValue", {
            get: /**
             * @return {?}
             */ function () {
                return this._inputValue;
            },
            set: /**
             * @param {?} inputValue
             * @return {?}
             */ function (inputValue) {
                this._inputValue = inputValue;
                /** @type {?} */
                var willBeInSearch = !!inputValue;
                // 搜索状态变动之前，如要进入则要保留之前激活选项的快照，退出搜索状态要还原该快照
                if (!this.inSearch && willBeInSearch) {
                    this.oldActivatedOptions = this.activatedOptions;
                    this.activatedOptions = [];
                    this.searchWidthStyle = this.input.nativeElement.offsetWidth + "px";
                }
                else if (this.inSearch && !willBeInSearch) {
                    this.activatedOptions = this.oldActivatedOptions;
                }
                // 搜索状态变更之后
                this.inSearch = !!willBeInSearch;
                if (this.inSearch) {
                    this.prepareSearchValue();
                }
                else {
                    if (this.showSearch) {
                        this.nzColumns = this.oldColumnsHolder;
                    }
                    this.searchWidthStyle = '';
                }
                this.setClassMap();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCascaderComponent.prototype, "nzLabelRender", {
            get: /**
             * @return {?}
             */ function () {
                return this.labelRenderTpl;
            },
            /** Display Render ngTemplate */
            set: /**
             * Display Render ngTemplate
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.labelRenderTpl = value;
                this.isLabelRenderTemplate = (value instanceof i0.TemplateRef);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCascaderComponent.prototype, "nzPrefixCls", {
            get: /**
             * @return {?}
             */ function () {
                return this.prefixCls;
            },
            /** prefixCls */
            set: /**
             * prefixCls
             * @param {?} prefixCls
             * @return {?}
             */ function (prefixCls) {
                this.prefixCls = prefixCls;
                this.setClassMap();
                this.setLabelClass();
                this.setArrowClass();
                this.setLoadingClass();
                this.setClearClass();
                this.setInputClass();
                this.setMenuClass();
                this.setMenuColumnClass();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCascaderComponent.prototype, "nzDisabled", {
            get: /**
             * @return {?}
             */ function () {
                return this.disabled;
            },
            /** Whether is disabled */
            set: /**
             * Whether is disabled
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.disabled = toBoolean(value);
                this.setClassMap();
                this.setInputClass();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCascaderComponent.prototype, "nzSize", {
            get: /**
             * @return {?}
             */ function () {
                return this.size;
            },
            /** Input size, one of `large` `default` `small` */
            set: /**
             * Input size, one of `large` `default` `small`
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.size = value;
                this.setClassMap();
                this.setInputClass();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCascaderComponent.prototype, "nzShowInput", {
            get: /**
             * @return {?}
             */ function () {
                return this.showInput;
            },
            /** Whether show input box. Defaults to `true`. */
            set: /**
             * Whether show input box. Defaults to `true`.
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.showInput = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCascaderComponent.prototype, "nzShowSearch", {
            get: /**
             * @return {?}
             */ function () {
                return this.showSearch;
            },
            /** Whether can search. Defaults to `false`. */
            set: /**
             * Whether can search. Defaults to `false`.
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.showSearch = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCascaderComponent.prototype, "nzAllowClear", {
            get: /**
             * @return {?}
             */ function () {
                return this.allowClear;
            },
            /** Whether allow clear. Defaults to `true`. */
            set: /**
             * Whether allow clear. Defaults to `true`.
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.allowClear = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCascaderComponent.prototype, "nzAutoFocus", {
            get: /**
             * @return {?}
             */ function () {
                return this.autoFocus;
            },
            /** Whether auto focus. */
            set: /**
             * Whether auto focus.
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.autoFocus = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCascaderComponent.prototype, "nzShowArrow", {
            get: /**
             * @return {?}
             */ function () {
                return this.showArrow;
            },
            /** Whether to show arrow */
            set: /**
             * Whether to show arrow
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.showArrow = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCascaderComponent.prototype, "nzMenuClassName", {
            get: /**
             * @return {?}
             */ function () {
                return this.menuClassName;
            },
            /** Additional className of popup overlay */
            set: /**
             * Additional className of popup overlay
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.menuClassName = value;
                this.setMenuClass();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCascaderComponent.prototype, "nzColumnClassName", {
            get: /**
             * @return {?}
             */ function () {
                return this.columnClassName;
            },
            /** Additional className of popup overlay column */
            set: /**
             * Additional className of popup overlay column
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.columnClassName = value;
                this.setMenuColumnClass();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCascaderComponent.prototype, "nzOptions", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzColumns[0];
            },
            /** Options for first column, sub column will be load async */
            set: /**
             * Options for first column, sub column will be load async
             * @param {?} options
             * @return {?}
             */ function (options) {
                this.oldColumnsHolder = this.nzColumns = options && options.length ? [options] : [];
                if (this.defaultValue && this.nzColumns.length) {
                    this.initOptions(0);
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCascaderComponent.prototype, "nzChangeOnSelect", {
            get: /**
             * @return {?}
             */ function () {
                return this.changeOnSelect;
            },
            /** Change value on each selection if set to true */
            set: /**
             * Change value on each selection if set to true
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.changeOnSelect = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} position
         * @return {?}
         */
        NzCascaderComponent.prototype.onPositionChange = /**
         * @param {?} position
         * @return {?}
         */
            function (position) {
                /** @type {?} */
                var newValue = position.connectionPair.originY === 'bottom' ? 'bottom' : 'top';
                if (this.dropDownPosition !== newValue) {
                    this.dropDownPosition = newValue;
                    this.cdr.detectChanges();
                }
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.focus = /**
         * @return {?}
         */
            function () {
                if (!this.isFocused) {
                    /** @type {?} */
                    var input = /** @type {?} */ (this.el.querySelector("." + this.prefixCls + "-input"));
                    if (input && input.focus) {
                        input.focus();
                    }
                    else {
                        this.el.focus();
                    }
                    this.isFocused = true;
                    this.setClassMap();
                }
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.blur = /**
         * @return {?}
         */
            function () {
                if (this.isFocused) {
                    /** @type {?} */
                    var input = /** @type {?} */ (this.el.querySelector("." + this.prefixCls + "-input"));
                    if (input && input.blur) {
                        input.blur();
                    }
                    else {
                        this.el.blur();
                    }
                    this.isFocused = false;
                    this.setClassMap();
                    this.setLabelClass();
                }
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.setClassMap = /**
         * @return {?}
         */
            function () {
                var _a;
                /** @type {?} */
                var classMap = (_a = {},
                    _a["" + this.prefixCls] = 1,
                    _a[this.prefixCls + "-picker"] = 1,
                    _a[this.prefixCls + "-lg"] = this.nzSize === 'large',
                    _a[this.prefixCls + "-sm"] = this.nzSize === 'small',
                    _a[this.prefixCls + "-picker-disabled"] = this.disabled,
                    _a[this.prefixCls + "-focused"] = this.isFocused,
                    _a[this.prefixCls + "-picker-open"] = this.menuVisible,
                    _a[this.prefixCls + "-picker-with-value"] = this.inputValue && this.inputValue.length,
                    _a);
                this.nzUpdateHostClassService.updateHostClass(this.el, classMap);
            };
        Object.defineProperty(NzCascaderComponent.prototype, "labelCls", {
            get: /**
             * 标签 样式
             * @return {?}
             */ function () {
                return this._labelCls;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.setLabelClass = /**
         * @return {?}
         */
            function () {
                var _a;
                this._labelCls = (_a = {},
                    _a[this.prefixCls + "-picker-label"] = true,
                    _a[this.prefixCls + "-show-search"] = !!this.nzShowSearch,
                    _a[this.prefixCls + "-focused"] = !!this.nzShowSearch && this.isFocused && !this._inputValue,
                    _a);
            };
        Object.defineProperty(NzCascaderComponent.prototype, "arrowCls", {
            get: /**
             * 箭头 样式
             * @return {?}
             */ function () {
                return this._arrowCls;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.setArrowClass = /**
         * @return {?}
         */
            function () {
                var _a;
                this._arrowCls = (_a = {},
                    _a[this.prefixCls + "-picker-arrow"] = true,
                    _a[this.prefixCls + "-picker-arrow-expand"] = this.menuVisible,
                    _a);
            };
        Object.defineProperty(NzCascaderComponent.prototype, "loadingCls", {
            get: /**
             * 加载中图标 样式
             * @return {?}
             */ function () {
                return this._loadingCls;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.setLoadingClass = /**
         * @return {?}
         */
            function () {
                var _a;
                this._loadingCls = (_a = {},
                    _a[this.prefixCls + "-picker-arrow"] = true,
                    _a);
            };
        Object.defineProperty(NzCascaderComponent.prototype, "clearCls", {
            get: /**
             * 清除图标 样式
             * @return {?}
             */ function () {
                return this._clearCls;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.setClearClass = /**
         * @return {?}
         */
            function () {
                var _a;
                this._clearCls = (_a = {},
                    _a[this.prefixCls + "-picker-clear"] = true,
                    _a);
            };
        Object.defineProperty(NzCascaderComponent.prototype, "inputCls", {
            get: /**
             * 输入框 样式
             * @return {?}
             */ function () {
                return this._inputCls;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.setInputClass = /**
         * @return {?}
         */
            function () {
                var _a;
                this._inputCls = (_a = {},
                    _a[this.prefixCls + "-input"] = 1,
                    _a[this.inputPrefixCls + "-disabled"] = this.nzDisabled,
                    _a[this.inputPrefixCls + "-lg"] = this.nzSize === 'large',
                    _a[this.inputPrefixCls + "-sm"] = this.nzSize === 'small',
                    _a);
            };
        Object.defineProperty(NzCascaderComponent.prototype, "menuCls", {
            get: /**
             * 浮层 样式
             * @return {?}
             */ function () {
                return this._menuCls;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.setMenuClass = /**
         * @return {?}
         */
            function () {
                var _a;
                this._menuCls = (_a = {},
                    _a[this.prefixCls + "-menus"] = true,
                    _a[this.prefixCls + "-menus-hidden"] = !this.menuVisible,
                    _a["" + this.nzMenuClassName] = this.nzMenuClassName,
                    _a);
            };
        Object.defineProperty(NzCascaderComponent.prototype, "menuColumnCls", {
            get: /**
             * 浮层列 样式
             * @return {?}
             */ function () {
                return this._menuColumnCls;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.setMenuColumnClass = /**
         * @return {?}
         */
            function () {
                var _a;
                this._menuColumnCls = (_a = {},
                    _a[this.prefixCls + "-menu"] = true,
                    _a["" + this.nzColumnClassName] = this.nzColumnClassName,
                    _a);
            };
        /**
         * 获取列中Option的样式
         * @param {?} option
         * @param {?} index
         * @return {?}
         */
        NzCascaderComponent.prototype.getOptionCls = /**
         * 获取列中Option的样式
         * @param {?} option
         * @param {?} index
         * @return {?}
         */
            function (option, index) {
                var _a;
                return _a = {},
                    _a[this.prefixCls + "-menu-item"] = true,
                    _a[this.prefixCls + "-menu-item-expand"] = !option.isLeaf,
                    _a[this.prefixCls + "-menu-item-active"] = this.isActivedOption(option, index),
                    _a[this.prefixCls + "-menu-item-disabled"] = option.disabled,
                    _a[this.prefixCls + "-menu-item-loading"] = option.loading,
                    _a;
            };
        /**
         * prevent input change event
         * @param {?} event
         * @return {?}
         */
        NzCascaderComponent.prototype.handlerInputChange = /**
         * prevent input change event
         * @param {?} event
         * @return {?}
         */
            function (event) {
                event.stopPropagation();
            };
        /**
         * input element blur
         * @param {?} event
         * @return {?}
         */
        NzCascaderComponent.prototype.handleInputBlur = /**
         * input element blur
         * @param {?} event
         * @return {?}
         */
            function (event) {
                /*
                    if (!this.nzShowSearch) {
                      return;
                    }
                    */
                if (this.menuVisible) {
                    this.focus(); // keep input has focus when menu opened
                }
                else {
                    this.blur();
                }
            };
        /**
         * input element focus
         * @param {?} event
         * @return {?}
         */
        NzCascaderComponent.prototype.handleInputFocus = /**
         * input element focus
         * @param {?} event
         * @return {?}
         */
            function (event) {
                /*
                    if (!this.nzShowSearch) {
                      return;
                    }
                    */
                this.focus();
                this.setLabelClass();
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.hasInput = /**
         * @return {?}
         */
            function () {
                return this.inputValue.length > 0;
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.hasValue = /**
         * @return {?}
         */
            function () {
                return this.value && this.value.length > 0;
            };
        Object.defineProperty(NzCascaderComponent.prototype, "showPlaceholder", {
            get: /**
             * Whether to show input element placeholder
             * @return {?}
             */ function () {
                return !(this.hasInput() || this.hasValue());
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCascaderComponent.prototype, "showClearIcon", {
            get: /**
             * Whether the clear button is visible
             * @return {?}
             */ function () {
                /** @type {?} */
                var isHasValue = this.hasValue();
                /** @type {?} */
                var isHasInput = this.hasInput();
                return this.nzAllowClear && !this.nzDisabled && (isHasValue || isHasInput);
            },
            enumerable: true,
            configurable: true
        });
        /**
         * clear the input box and selected options
         * @param {?=} event
         * @return {?}
         */
        NzCascaderComponent.prototype.clearSelection = /**
         * clear the input box and selected options
         * @param {?=} event
         * @return {?}
         */
            function (event) {
                if (event) {
                    event.preventDefault();
                    event.stopPropagation();
                }
                this.labelRenderText = '';
                // this.isLabelRenderTemplate = false;
                // clear custom context
                this.labelRenderContext = {};
                this.selectedOptions = [];
                this.activatedOptions = [];
                this.inputValue = '';
                this.setMenuVisible(false);
                // trigger change event
                this.onValueChange();
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.buildDisplayLabel = /**
         * @return {?}
         */
            function () {
                var _this = this;
                /** @type {?} */
                var selectedOptions = this.selectedOptions;
                /** @type {?} */
                var labels = selectedOptions.map(function (o) { return _this.getOptionLabel(o); });
                // 设置当前控件的显示值
                if (this.isLabelRenderTemplate) {
                    this.labelRenderContext = { labels: labels, selectedOptions: selectedOptions };
                }
                else {
                    this.labelRenderText = defaultDisplayRender.call(this, labels, selectedOptions);
                }
            };
        /**
         * @param {?} event
         * @return {?}
         */
        NzCascaderComponent.prototype.onKeyDown = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                /** @type {?} */
                var keyCode = event.keyCode;
                if (keyCode !== keycodes.DOWN_ARROW &&
                    keyCode !== keycodes.UP_ARROW &&
                    keyCode !== keycodes.LEFT_ARROW &&
                    keyCode !== keycodes.RIGHT_ARROW &&
                    keyCode !== keycodes.ENTER &&
                    keyCode !== keycodes.BACKSPACE &&
                    keyCode !== keycodes.ESCAPE) {
                    return;
                }
                if (this.inSearch && (keyCode === keycodes.BACKSPACE ||
                    keyCode === keycodes.LEFT_ARROW ||
                    keyCode === keycodes.RIGHT_ARROW)) {
                    return;
                }
                // Press any keys above to reopen menu
                if (!this.isMenuVisible() &&
                    keyCode !== keycodes.BACKSPACE &&
                    keyCode !== keycodes.ESCAPE) {
                    this.setMenuVisible(true);
                    return;
                }
                // Press ESC to close menu
                if (keyCode === keycodes.ESCAPE) {
                    // this.setMenuVisible(false); // already call by cdk-overlay detach
                    return;
                }
                if (this.isMenuVisible()) {
                    event.preventDefault();
                    if (keyCode === keycodes.DOWN_ARROW) {
                        this.moveDown();
                    }
                    else if (keyCode === keycodes.UP_ARROW) {
                        this.moveUp();
                    }
                    else if (keyCode === keycodes.LEFT_ARROW) {
                        this.moveLeft();
                    }
                    else if (keyCode === keycodes.RIGHT_ARROW) {
                        this.moveRight();
                    }
                    else if (keyCode === keycodes.ENTER) {
                        this.onEnter();
                    }
                }
            };
        /**
         * @param {?} event
         * @return {?}
         */
        NzCascaderComponent.prototype.onTriggerClick = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                if (this.nzDisabled) {
                    return;
                }
                this.onTouched(); // set your control to 'touched'
                if (this.nzShowSearch) {
                    this.focus();
                }
                if (this.isClickTiggerAction()) {
                    this.delaySetMenuVisible(!this.menuVisible, 100);
                }
            };
        /**
         * @param {?} event
         * @return {?}
         */
        NzCascaderComponent.prototype.onTriggerMouseEnter = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                if (this.nzDisabled) {
                    return;
                }
                if (this.isPointerTiggerAction()) {
                    this.delaySetMenuVisible(true, this.nzMouseEnterDelay, true);
                }
            };
        /**
         * @param {?} event
         * @return {?}
         */
        NzCascaderComponent.prototype.onTriggerMouseLeave = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                if (this.nzDisabled) {
                    return;
                }
                if (!this.isMenuVisible() || this.isOpening) {
                    event.preventDefault();
                    return;
                }
                if (this.isPointerTiggerAction()) {
                    /** @type {?} */
                    var mouseTarget = /** @type {?} */ (event.relatedTarget);
                    /** @type {?} */
                    var hostEl = this.el;
                    /** @type {?} */
                    var menuEl = this.menu && /** @type {?} */ (this.menu.nativeElement);
                    if (hostEl.contains(mouseTarget) || (menuEl && menuEl.contains(mouseTarget))
                    /*|| mouseTarget.parentElement.contains(menuEl)*/ ) {
                        // 因为浮层的backdrop出现，暂时没有办法自动消失
                        return;
                    }
                    this.delaySetMenuVisible(false, this.nzMouseLeaveDelay);
                }
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.isClickTiggerAction = /**
         * @return {?}
         */
            function () {
                if (typeof this.nzTriggerAction === 'string') {
                    return this.nzTriggerAction === 'click';
                }
                return this.nzTriggerAction.indexOf('click') !== -1;
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.isPointerTiggerAction = /**
         * @return {?}
         */
            function () {
                if (typeof this.nzTriggerAction === 'string') {
                    return this.nzTriggerAction === 'hover';
                }
                return this.nzTriggerAction.indexOf('hover') !== -1;
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.closeMenu = /**
         * @return {?}
         */
            function () {
                this.blur();
                this.clearDelayTimer();
                this.setMenuVisible(false);
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.clearDelayTimer = /**
         * @return {?}
         */
            function () {
                if (this.delayTimer) {
                    clearTimeout(this.delayTimer);
                    this.delayTimer = null;
                }
            };
        /**
         * 显示或者隐藏菜单
         *
         * @param {?} visible true-显示，false-隐藏
         * @param {?} delay 延迟时间
         * @param {?=} setOpening
         * @return {?}
         */
        NzCascaderComponent.prototype.delaySetMenuVisible = /**
         * 显示或者隐藏菜单
         *
         * @param {?} visible true-显示，false-隐藏
         * @param {?} delay 延迟时间
         * @param {?=} setOpening
         * @return {?}
         */
            function (visible, delay, setOpening) {
                var _this = this;
                if (setOpening === void 0) {
                    setOpening = false;
                }
                this.clearDelayTimer();
                if (delay) {
                    if (visible && setOpening) {
                        this.isOpening = true;
                    }
                    this.delayTimer = setTimeout(function () {
                        _this.setMenuVisible(visible);
                        _this.clearDelayTimer();
                        if (visible) {
                            setTimeout(function () {
                                _this.isOpening = false;
                            }, 100);
                        }
                    }, delay);
                }
                else {
                    this.setMenuVisible(visible);
                }
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.isMenuVisible = /**
         * @return {?}
         */
            function () {
                return this.menuVisible;
            };
        /**
         * @param {?} menuVisible
         * @return {?}
         */
        NzCascaderComponent.prototype.setMenuVisible = /**
         * @param {?} menuVisible
         * @return {?}
         */
            function (menuVisible) {
                if (this.nzDisabled) {
                    return;
                }
                if (this.menuVisible !== menuVisible) {
                    this.menuVisible = menuVisible;
                    // update class
                    this.setClassMap();
                    this.setArrowClass();
                    this.setMenuClass();
                    if (menuVisible) {
                        this.beforeVisible();
                    }
                    this.nzVisibleChange.emit(menuVisible);
                }
            };
        /**
         * load init data if necessary
         * @return {?}
         */
        NzCascaderComponent.prototype.beforeVisible = /**
         * load init data if necessary
         * @return {?}
         */
            function () {
                this.loadRootOptions();
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.loadRootOptions = /**
         * @return {?}
         */
            function () {
                if (!this.nzColumns.length) {
                    /** @type {?} */
                    var root = {};
                    this.loadChildren(root, -1);
                }
            };
        /**
         * 获取Option的值，例如，可以指定labelProperty="name"来取Name
         * @param {?} option
         * @return {?}
         */
        NzCascaderComponent.prototype.getOptionLabel = /**
         * 获取Option的值，例如，可以指定labelProperty="name"来取Name
         * @param {?} option
         * @return {?}
         */
            function (option) {
                return option[this.nzLabelProperty || 'label'];
            };
        /**
         * 获取Option的值，例如，可以指定valueProperty="id"来取ID
         * @param {?} option
         * @return {?}
         */
        NzCascaderComponent.prototype.getOptionValue = /**
         * 获取Option的值，例如，可以指定valueProperty="id"来取ID
         * @param {?} option
         * @return {?}
         */
            function (option) {
                return option[this.nzValueProperty || 'value'];
            };
        /**
         * @param {?} option
         * @param {?} index
         * @return {?}
         */
        NzCascaderComponent.prototype.isActivedOption = /**
         * @param {?} option
         * @param {?} index
         * @return {?}
         */
            function (option, index) {
                /** @type {?} */
                var activeOpt = this.activatedOptions[index];
                return activeOpt === option;
            };
        /**
         * 设置某列的激活的菜单选项
         *
         * @param {?} option 菜单选项
         * @param {?} index  选项所在的列组的索引
         * @param {?=} select 是否触发选择结点
         * @param {?=} loadChildren
         * @return {?}
         */
        NzCascaderComponent.prototype.setActiveOption = /**
         * 设置某列的激活的菜单选项
         *
         * @param {?} option 菜单选项
         * @param {?} index  选项所在的列组的索引
         * @param {?=} select 是否触发选择结点
         * @param {?=} loadChildren
         * @return {?}
         */
            function (option, index, select, loadChildren) {
                if (select === void 0) {
                    select = false;
                }
                if (loadChildren === void 0) {
                    loadChildren = true;
                }
                if (!option || option.disabled) {
                    return;
                }
                this.activatedOptions[index] = option;
                // 当直接选择最后一级时，前面的选项要补全。例如，选择“城市”，则自动补全“国家”、“省份”
                for (var i = index - 1; i >= 0; i--) {
                    if (!this.activatedOptions[i]) {
                        this.activatedOptions[i] = this.activatedOptions[i + 1].parent;
                    }
                }
                // 截断多余的选项，如选择“省份”，则只会有“国家”、“省份”，去掉“城市”、“区县”
                if (index < this.activatedOptions.length - 1) {
                    this.activatedOptions = this.activatedOptions.slice(0, index + 1);
                }
                // load children
                if (option.children && option.children.length) {
                    option.isLeaf = false;
                    option.children.forEach(function (child) { return child.parent = option; });
                    this.setColumnData(option.children, index + 1);
                }
                else if (!option.isLeaf && loadChildren) {
                    this.loadChildren(option, index);
                }
                else {
                    // clicking leaf node will remove any children columns
                    if (index < this.nzColumns.length - 1) {
                        this.nzColumns = this.nzColumns.slice(0, index + 1);
                    }
                }
                // trigger select event, and display label
                if (select) {
                    this.onSelectOption(option, index);
                }
            };
        /**
         * @param {?} option
         * @param {?} index
         * @param {?=} success
         * @param {?=} failure
         * @return {?}
         */
        NzCascaderComponent.prototype.loadChildren = /**
         * @param {?} option
         * @param {?} index
         * @param {?=} success
         * @param {?=} failure
         * @return {?}
         */
            function (option, index, success, failure) {
                var _this = this;
                if (this.nzLoadData) {
                    this.isLoading = index < 0;
                    option.loading = true;
                    this.nzLoadData(option, index).then(function () {
                        option.loading = _this.isLoading = false;
                        if (option.children) {
                            option.children.forEach(function (child) { return child.parent = index < 0 ? undefined : option; });
                            _this.setColumnData(option.children, index + 1);
                        }
                        if (success) {
                            success();
                        }
                    }, function () {
                        option.loading = _this.isLoading = false;
                        option.isLeaf = true;
                        if (failure) {
                            failure();
                        }
                    });
                }
            };
        /**
         * @param {?} option
         * @param {?} index
         * @return {?}
         */
        NzCascaderComponent.prototype.onSelectOption = /**
         * @param {?} option
         * @param {?} index
         * @return {?}
         */
            function (option, index) {
                // trigger `nzSelect` event
                this.nzSelect.emit({ option: option, index: index });
                // 生成显示
                if (option.isLeaf || this.nzChangeOnSelect || this.isChangeOn(option, index)) {
                    this.selectedOptions = this.activatedOptions;
                    // 设置当前控件的显示值
                    this.buildDisplayLabel();
                    // 触发变更事件
                    this.onValueChange();
                }
                // close menu if click on leaf
                if (option.isLeaf) {
                    this.delaySetMenuVisible(false, this.nzMouseLeaveDelay);
                }
            };
        /**
         * 由用户来定义点击后是否变更
         * @param {?} option
         * @param {?} index
         * @return {?}
         */
        NzCascaderComponent.prototype.isChangeOn = /**
         * 由用户来定义点击后是否变更
         * @param {?} option
         * @param {?} index
         * @return {?}
         */
            function (option, index) {
                if (typeof this.nzChangeOn === 'function') {
                    return this.nzChangeOn(option, index) === true;
                }
                return false;
            };
        /**
         * @param {?} options
         * @param {?} index
         * @return {?}
         */
        NzCascaderComponent.prototype.setColumnData = /**
         * @param {?} options
         * @param {?} index
         * @return {?}
         */
            function (options, index) {
                if (!arrayEquals(this.nzColumns[index], options)) {
                    this.nzColumns[index] = options;
                    if (index < this.nzColumns.length - 1) {
                        this.nzColumns = this.nzColumns.slice(0, index + 1);
                    }
                }
            };
        /**
         * 鼠标点击选项
         *
         * @param option 菜单选项
         * @param index 选项所在的列组的索引
         * @param event 鼠标事件
         */
        /**
         * 鼠标点击选项
         *
         * @param {?} option 菜单选项
         * @param {?} index 选项所在的列组的索引
         * @param {?} event 鼠标事件
         * @return {?}
         */
        NzCascaderComponent.prototype.onOptionClick = /**
         * 鼠标点击选项
         *
         * @param {?} option 菜单选项
         * @param {?} index 选项所在的列组的索引
         * @param {?} event 鼠标事件
         * @return {?}
         */
            function (option, index, event) {
                if (event) {
                    event.preventDefault();
                }
                // Keep focused state for keyboard support
                this.el.focus();
                if (option && option.disabled) {
                    return;
                }
                if (this.inSearch) {
                    this.setSearchActiveOption(/** @type {?} */ (option), event);
                }
                else {
                    this.setActiveOption(option, index, true);
                }
            };
        /**
         * 按下回车键时选择
         * @return {?}
         */
        NzCascaderComponent.prototype.onEnter = /**
         * 按下回车键时选择
         * @return {?}
         */
            function () {
                /** @type {?} */
                var columnIndex = Math.max(this.activatedOptions.length - 1, 0);
                /** @type {?} */
                var activeOption = this.activatedOptions[columnIndex];
                if (activeOption && !activeOption.disabled) {
                    if (this.inSearch) {
                        this.setSearchActiveOption(/** @type {?} */ (activeOption), null);
                    }
                    else {
                        this.onSelectOption(activeOption, columnIndex);
                    }
                }
            };
        /**
         * press `up` or `down` arrow to activate the sibling option.
         * @param {?} isUp
         * @return {?}
         */
        NzCascaderComponent.prototype.moveUpOrDown = /**
         * press `up` or `down` arrow to activate the sibling option.
         * @param {?} isUp
         * @return {?}
         */
            function (isUp) {
                /** @type {?} */
                var columnIndex = Math.max(this.activatedOptions.length - 1, 0);
                /** @type {?} */
                var activeOption = this.activatedOptions[columnIndex];
                /** @type {?} */
                var options = this.nzColumns[columnIndex] || [];
                /** @type {?} */
                var length = options.length;
                /** @type {?} */
                var nextIndex = -1;
                if (!activeOption) { // 该列还没有选中的选项
                    // 该列还没有选中的选项
                    nextIndex = isUp ? length : -1;
                }
                else {
                    nextIndex = options.indexOf(activeOption);
                }
                while (true) {
                    nextIndex = isUp ? nextIndex - 1 : nextIndex + 1;
                    if (nextIndex < 0 || nextIndex >= length) {
                        break;
                    }
                    /** @type {?} */
                    var nextOption = options[nextIndex];
                    if (!nextOption || nextOption.disabled) {
                        continue;
                    }
                    this.setActiveOption(nextOption, columnIndex);
                    break;
                }
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.moveUp = /**
         * @return {?}
         */
            function () {
                this.moveUpOrDown(true);
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.moveDown = /**
         * @return {?}
         */
            function () {
                this.moveUpOrDown(false);
            };
        /**
         * press `left` arrow to remove the last selected option.
         * @return {?}
         */
        NzCascaderComponent.prototype.moveLeft = /**
         * press `left` arrow to remove the last selected option.
         * @return {?}
         */
            function () {
                /** @type {?} */
                var options = this.activatedOptions;
                if (options.length) {
                    options.pop(); // Remove the last one
                }
            };
        /**
         * press `right` arrow to select the next column option.
         * @return {?}
         */
        NzCascaderComponent.prototype.moveRight = /**
         * press `right` arrow to select the next column option.
         * @return {?}
         */
            function () {
                /** @type {?} */
                var length = this.activatedOptions.length;
                /** @type {?} */
                var options = this.nzColumns[length];
                if (options && options.length) {
                    /** @type {?} */
                    var nextOpt = options.find(function (o) { return !o.disabled; });
                    if (nextOpt) {
                        this.setActiveOption(nextOpt, length);
                    }
                }
            };
        /**
         * 鼠标划入选项
         *
         * @param option 菜单选项
         * @param index 选项所在的列组的索引
         * @param event 鼠标事件
         */
        /**
         * 鼠标划入选项
         *
         * @param {?} option 菜单选项
         * @param {?} index 选项所在的列组的索引
         * @param {?} event 鼠标事件
         * @return {?}
         */
        NzCascaderComponent.prototype.onOptionMouseEnter = /**
         * 鼠标划入选项
         *
         * @param {?} option 菜单选项
         * @param {?} index 选项所在的列组的索引
         * @param {?} event 鼠标事件
         * @return {?}
         */
            function (option, index, event) {
                event.preventDefault();
                if (this.nzExpandTrigger === 'hover' && !option.isLeaf) {
                    this.delaySelect(option, index, true);
                }
            };
        /**
         * 鼠标划出选项
         *
         * @param option 菜单选项
         * @param index 选项所在的列组的索引
         * @param event 鼠标事件
         */
        /**
         * 鼠标划出选项
         *
         * @param {?} option 菜单选项
         * @param {?} index 选项所在的列组的索引
         * @param {?} event 鼠标事件
         * @return {?}
         */
        NzCascaderComponent.prototype.onOptionMouseLeave = /**
         * 鼠标划出选项
         *
         * @param {?} option 菜单选项
         * @param {?} index 选项所在的列组的索引
         * @param {?} event 鼠标事件
         * @return {?}
         */
            function (option, index, event) {
                event.preventDefault();
                if (this.nzExpandTrigger === 'hover' && !option.isLeaf) {
                    this.delaySelect(option, index, false);
                }
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.clearDelaySelectTimer = /**
         * @return {?}
         */
            function () {
                if (this.delaySelectTimer) {
                    clearTimeout(this.delaySelectTimer);
                    this.delaySelectTimer = null;
                }
            };
        /**
         * @param {?} option
         * @param {?} index
         * @param {?} doSelect
         * @return {?}
         */
        NzCascaderComponent.prototype.delaySelect = /**
         * @param {?} option
         * @param {?} index
         * @param {?} doSelect
         * @return {?}
         */
            function (option, index, doSelect) {
                var _this = this;
                this.clearDelaySelectTimer();
                if (doSelect) {
                    this.delaySelectTimer = setTimeout(function () {
                        // 鼠标滑入只展开，不进行选中操作
                        // 鼠标滑入只展开，不进行选中操作
                        _this.setActiveOption(option, index);
                        _this.delaySelectTimer = null;
                    }, 150);
                }
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.getSubmitValue = /**
         * @return {?}
         */
            function () {
                var _this = this;
                /** @type {?} */
                var values = [];
                this.selectedOptions.forEach(function (option) {
                    values.push(_this.getOptionValue(option));
                });
                return values;
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.onValueChange = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var value = this.getSubmitValue();
                if (!arrayEquals(this.value, value)) {
                    this.defaultValue = null; // clear the init-value
                    this.value = value;
                    this.onChange(value); // Angular need this
                    if (value.length === 0) {
                        this.nzClear.emit(); // first trigger `clear` and then `change`
                    }
                    this.nzSelectionChange.emit(this.selectedOptions);
                    this.nzChange.emit(value);
                }
            };
        /**
         * @param {?} option
         * @param {?} index
         * @return {?}
         */
        NzCascaderComponent.prototype.findOption = /**
         * @param {?} option
         * @param {?} index
         * @return {?}
         */
            function (option, index) {
                var _this = this;
                /** @type {?} */
                var options = this.nzColumns[index];
                if (options) {
                    /** @type {?} */
                    var value_1 = typeof option === 'object' ? this.getOptionValue(option) : option;
                    return options.find(function (o) { return value_1 === _this.getOptionValue(o); });
                }
                return null;
            };
        /**
         * @param {?} index
         * @return {?}
         */
        NzCascaderComponent.prototype.isLoaded = /**
         * @param {?} index
         * @return {?}
         */
            function (index) {
                return this.nzColumns[index] && this.nzColumns[index].length > 0;
            };
        /**
         * @param {?} index
         * @param {?} value
         * @return {?}
         */
        NzCascaderComponent.prototype.activateOnInit = /**
         * @param {?} index
         * @param {?} value
         * @return {?}
         */
            function (index, value) {
                var _a;
                /** @type {?} */
                var option = this.findOption(value, index);
                if (!option) {
                    option = typeof value === 'object' ? value : (_a = {},
                        _a["" + (this.nzValueProperty || 'value')] = value,
                        _a["" + (this.nzLabelProperty || 'label')] = value,
                        _a);
                }
                this.setActiveOption(option, index, false, false);
            };
        /**
         * @param {?} index
         * @return {?}
         */
        NzCascaderComponent.prototype.initOptions = /**
         * @param {?} index
         * @return {?}
         */
            function (index) {
                var _this = this;
                /** @type {?} */
                var vs = this.defaultValue;
                /** @type {?} */
                var load = function () {
                    _this.activateOnInit(index, vs[index]);
                    if (index < vs.length - 1) {
                        _this.initOptions(index + 1);
                    }
                    if (index === vs.length - 1) {
                        _this.afterWriteValue();
                    }
                };
                if (this.isLoaded(index) || !this.nzLoadData) {
                    load();
                }
                else {
                    /** @type {?} */
                    var node = this.activatedOptions[index - 1] || {};
                    this.loadChildren(node, index - 1, load, this.afterWriteValue);
                }
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.afterWriteValue = /**
         * @return {?}
         */
            function () {
                this.selectedOptions = this.activatedOptions;
                this.value = this.getSubmitValue();
                this.buildDisplayLabel();
            };
        /**
         * Write a new value to the element.
         *
         * @Override (From ControlValueAccessor interface)
         */
        /**
         * Write a new value to the element.
         *
         * \@Override (From ControlValueAccessor interface)
         * @param {?} value
         * @return {?}
         */
        NzCascaderComponent.prototype.writeValue = /**
         * Write a new value to the element.
         *
         * \@Override (From ControlValueAccessor interface)
         * @param {?} value
         * @return {?}
         */
            function (value) {
                /** @type {?} */
                var vs = this.defaultValue = toArray(value);
                if (vs.length) {
                    this.initOptions(0);
                }
                else {
                    this.value = vs;
                    this.activatedOptions = [];
                    this.afterWriteValue();
                }
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzCascaderComponent.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onChange = fn;
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzCascaderComponent.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onTouched = fn;
            };
        /**
         * @param {?} isDisabled
         * @return {?}
         */
        NzCascaderComponent.prototype.setDisabledState = /**
         * @param {?} isDisabled
         * @return {?}
         */
            function (isDisabled) {
                if (isDisabled) {
                    this.closeMenu();
                }
                this.nzDisabled = isDisabled;
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.prepareSearchValue = /**
         * @return {?}
         */
            function () {
                var _this = this;
                /** @type {?} */
                var results = [];
                /** @type {?} */
                var path = [];
                /** @type {?} */
                var defaultFilter = function (inputValue, p) {
                    /** @type {?} */
                    var flag = false;
                    p.forEach(function (n) {
                        if (n.label.indexOf(inputValue) > -1) {
                            flag = true;
                        }
                    });
                    return flag;
                };
                /** @type {?} */
                var filter = this.nzShowSearch instanceof Object && ( /** @type {?} */(this.nzShowSearch)).filter ?
                    ( /** @type {?} */(this.nzShowSearch)).filter :
                    defaultFilter;
                /** @type {?} */
                var sorter = this.nzShowSearch instanceof Object && ( /** @type {?} */(this.nzShowSearch)).sorter;
                /** @type {?} */
                var loopParent = function (node, forceDisabled) {
                    if (forceDisabled === void 0) {
                        forceDisabled = false;
                    }
                    /** @type {?} */
                    var disabled = forceDisabled || node.disabled;
                    path.push(node);
                    node.children.forEach(function (sNode) {
                        if (!sNode.parent) {
                            sNode.parent = node;
                        }
                        /** 搜索的同时建立 parent 连接，因为用户直接搜索的话是没有建立连接的，会提升从叶子节点回溯的难度 */
                        if (!sNode.isLeaf) {
                            loopParent(sNode, disabled);
                        }
                        if (sNode.isLeaf || !sNode.children || !sNode.children.length) {
                            loopChild(sNode, disabled);
                        }
                    });
                    path.pop();
                };
                /** @type {?} */
                var loopChild = function (node, forceDisabled) {
                    if (forceDisabled === void 0) {
                        forceDisabled = false;
                    }
                    path.push(node);
                    /** @type {?} */
                    var cPath = Array.from(path);
                    if (filter(_this._inputValue, cPath)) {
                        /** @type {?} */
                        var disabled = forceDisabled || node.disabled;
                        results.push(/** @type {?} */ ({
                            disabled: disabled,
                            isLeaf: true,
                            path: cPath,
                            label: cPath.map(function (p) { return p.label; }).join(' / ')
                        }));
                    }
                    path.pop();
                };
                this.oldColumnsHolder[0].forEach(function (node) { return (node.isLeaf || !node.children || !node.children.length) ? loopChild(node) : loopParent(node); });
                if (sorter) {
                    results.sort(function (a, b) { return sorter(a.path, b.path, _this._inputValue); });
                }
                this.nzColumns = [results];
            };
        /**
         * @param {?} str
         * @return {?}
         */
        NzCascaderComponent.prototype.renderSearchString = /**
         * @param {?} str
         * @return {?}
         */
            function (str) {
                return str.replace(new RegExp(this._inputValue, 'g'), "<span class=\"ant-cascader-menu-item-keyword\">" + this._inputValue + "</span>");
            };
        /**
         * @param {?} result
         * @param {?} event
         * @return {?}
         */
        NzCascaderComponent.prototype.setSearchActiveOption = /**
         * @param {?} result
         * @param {?} event
         * @return {?}
         */
            function (result, event) {
                var _this = this;
                this.activatedOptions = [result];
                this.delaySetMenuVisible(false, 200);
                setTimeout(function () {
                    _this.inputValue = '';
                    /** @type {?} */
                    var index = result.path.length - 1;
                    /** @type {?} */
                    var destiNode = result.path[index];
                    /** @type {?} */
                    var mockClickParent = function (node, cIndex) {
                        if (node && node.parent) {
                            mockClickParent(node.parent, cIndex - 1);
                        }
                        _this.onOptionClick(node, cIndex, event);
                    };
                    mockClickParent(destiNode, index);
                }, 300);
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                // 设置样式
                this.setClassMap();
                this.setLabelClass();
                this.setArrowClass();
                this.setLoadingClass();
                this.setClearClass();
                this.setInputClass();
                this.setMenuClass();
                this.setMenuColumnClass();
            };
        /**
         * @return {?}
         */
        NzCascaderComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.clearDelayTimer();
                this.clearDelaySelectTimer();
            };
        NzCascaderComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-cascader,[nz-cascader]',
                        preserveWhitespaces: false,
                        animations: [
                            dropDownAnimation
                        ],
                        template: "<div\n  cdkOverlayOrigin\n  #origin=\"cdkOverlayOrigin\"\n  #trigger>\n  <div *ngIf=\"nzShowInput\">\n    <input #input\n      nz-input\n      [attr.autoComplete]=\"'off'\"\n      [attr.placeholder]=\"showPlaceholder ? nzPlaceHolder : null\"\n      [attr.autofocus]=\"nzAutoFocus ? 'autofocus' : null\"\n      [readonly]=\"!nzShowSearch\"\n      [disabled]=\"nzDisabled\"\n      [nzSize]=\"nzSize\"\n      [ngClass]=\"inputCls\"\n      [(ngModel)]=\"inputValue\"\n      (blur)=\"handleInputBlur($event)\"\n      (focus)=\"handleInputFocus($event)\"\n      (change)=\"handlerInputChange($event)\">\n    <i *ngIf=\"showClearIcon\"\n      [class]=\"'anticon anticon-cross-circle'\"\n      [ngClass]=\"clearCls\"\n      [attr.title]=\"nzClearText\"\n      (click)=\"clearSelection($event)\"></i>\n    <i *ngIf=\"nzShowArrow && !isLoading\"\n      class=\"anticon anticon-down\"\n      [ngClass]=\"arrowCls\"></i>\n    <i *ngIf=\"isLoading\"\n      class=\"anticon anticon-loading anticon-spin\"\n      [ngClass]=\"loadingCls\"></i>\n    <span [ngClass]=\"labelCls\">\n          <ng-container *ngIf=\"!isLabelRenderTemplate; else labelTemplate\">{{ labelRenderText }}</ng-container>\n          <ng-template #labelTemplate>\n            <ng-template [ngTemplateOutlet]=\"nzLabelRender\" [ngTemplateOutletContext]=\"labelRenderContext\"></ng-template>\n          </ng-template>\n        </span>\n  </div>\n  <ng-content></ng-content>\n</div>\n<ng-template\n  cdkConnectedOverlay\n  cdkConnectedOverlayHasBackdrop\n  [cdkConnectedOverlayOrigin]=\"origin\"\n  [cdkConnectedOverlayPositions]=\"positions\"\n  (backdropClick)=\"closeMenu()\"\n  (detach)=\"closeMenu()\"\n  (positionChange)=\"onPositionChange($event)\"\n  [cdkConnectedOverlayOpen]=\"menuVisible\">\n  <div #menu\n    [ngClass]=\"menuCls\" [ngStyle]=\"nzMenuStyle\"\n    [@dropDownAnimation]=\"dropDownPosition\"\n    (mouseleave)=\"onTriggerMouseLeave($event)\">\n    <ul *ngFor=\"let options of nzColumns; let i = index;\" [ngClass]=\"menuColumnCls\"\n      [style.height]=\"inSearch && !nzColumns[0].length ? 'auto': ''\" [style.width]=\"searchWidthStyle\">\n      <li *ngFor=\"let option of options\"\n        [attr.title]=\"option.title || getOptionLabel(option)\"\n        [ngClass]=\"getOptionCls(option, i)\"\n        (mouseenter)=\"onOptionMouseEnter(option, i, $event)\"\n        (mouseleave)=\"onOptionMouseLeave(option, i, $event)\"\n        (click)=\"onOptionClick(option, i, $event)\">\n        <ng-container *ngIf=\"inSearch\">\n          <span [innerHTML]=\"renderSearchString(getOptionLabel(option))\"></span>\n        </ng-container>\n        <ng-container *ngIf=\"!inSearch\">\n          {{ getOptionLabel(option) }}\n        </ng-container>\n      </li>\n      <li *ngIf=\"inSearch && !nzColumns[0].length\" class=\"ant-cascader-menu-item ant-cascader-menu-item-expanded ant-cascader-menu-item-disabled\">\n        Not Found\n      </li>\n    </ul>\n  </div>\n</ng-template>\n",
                        providers: [
                            NzUpdateHostClassService,
                            {
                                provide: forms.NG_VALUE_ACCESSOR,
                                useExisting: i0.forwardRef(function () { return NzCascaderComponent; }),
                                multi: true
                            }
                        ],
                        host: {
                            '[attr.tabIndex]': '"0"'
                        },
                        styles: [".ant-cascader-menus {\n      margin-top: 4px;\n      margin-bottom: 4px;\n      top: 100%;\n      left: 0;\n      position: relative;\n      width: 100%;\n    }"]
                    }] }
        ];
        /** @nocollapse */
        NzCascaderComponent.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: i0.ChangeDetectorRef },
                { type: NzUpdateHostClassService }
            ];
        };
        NzCascaderComponent.propDecorators = {
            nzLabelRender: [{ type: i0.Input }],
            nzPrefixCls: [{ type: i0.Input }],
            nzDisabled: [{ type: i0.Input }],
            nzSize: [{ type: i0.Input }],
            nzShowInput: [{ type: i0.Input }],
            nzShowSearch: [{ type: i0.Input }],
            nzAllowClear: [{ type: i0.Input }],
            nzAutoFocus: [{ type: i0.Input }],
            nzShowArrow: [{ type: i0.Input }],
            nzMenuClassName: [{ type: i0.Input }],
            nzColumnClassName: [{ type: i0.Input }],
            nzOptions: [{ type: i0.Input }],
            nzChangeOnSelect: [{ type: i0.Input }],
            nzClearText: [{ type: i0.Input }],
            nzExpandTrigger: [{ type: i0.Input }],
            nzNotFoundContent: [{ type: i0.Input }],
            nzPlaceHolder: [{ type: i0.Input }],
            nzMenuStyle: [{ type: i0.Input }],
            nzChangeOn: [{ type: i0.Input }],
            nzMouseEnterDelay: [{ type: i0.Input }],
            nzMouseLeaveDelay: [{ type: i0.Input }],
            nzTriggerAction: [{ type: i0.Input }],
            nzValueProperty: [{ type: i0.Input }],
            nzLabelProperty: [{ type: i0.Input }],
            nzLoadData: [{ type: i0.Input }],
            nzVisibleChange: [{ type: i0.Output }],
            nzChange: [{ type: i0.Output }],
            nzSelectionChange: [{ type: i0.Output }],
            nzSelect: [{ type: i0.Output }],
            nzClear: [{ type: i0.Output }],
            input: [{ type: i0.ViewChild, args: ['input',] }],
            menu: [{ type: i0.ViewChild, args: ['menu',] }],
            onKeyDown: [{ type: i0.HostListener, args: ['keydown', ['$event'],] }],
            onTriggerClick: [{ type: i0.HostListener, args: ['click', ['$event'],] }],
            onTriggerMouseEnter: [{ type: i0.HostListener, args: ['mouseenter', ['$event'],] }],
            onTriggerMouseLeave: [{ type: i0.HostListener, args: ['mouseleave', ['$event'],] }]
        };
        return NzCascaderComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCascaderModule = /** @class */ (function () {
        function NzCascaderModule() {
        }
        NzCascaderModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [i1.CommonModule, forms.FormsModule, i2.OverlayModule, NzInputModule],
                        declarations: [
                            NzCascaderComponent
                        ],
                        exports: [
                            NzCascaderComponent
                        ]
                    },] }
        ];
        return NzCascaderModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCheckboxGroupComponent = /** @class */ (function () {
        function NzCheckboxGroupComponent(elementRef, renderer) {
            this.elementRef = elementRef;
            this.renderer = renderer;
            this._disabled = false;
            this.prefixCls = 'ant-checkbox-group';
            this.onChange = Function.prototype;
            this.onTouched = Function.prototype;
            this.el = this.elementRef.nativeElement;
        }
        Object.defineProperty(NzCheckboxGroupComponent.prototype, "nzDisabled", {
            get: /**
             * @return {?}
             */ function () {
                return this._disabled;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._disabled = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzCheckboxGroupComponent.prototype.onOptionChange = /**
         * @return {?}
         */
            function () {
                this.onChange(this.options);
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzCheckboxGroupComponent.prototype.writeValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.options = value;
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzCheckboxGroupComponent.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onChange = fn;
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzCheckboxGroupComponent.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onTouched = fn;
            };
        /**
         * @param {?} isDisabled
         * @return {?}
         */
        NzCheckboxGroupComponent.prototype.setDisabledState = /**
         * @param {?} isDisabled
         * @return {?}
         */
            function (isDisabled) {
                this.nzDisabled = isDisabled;
            };
        /**
         * @return {?}
         */
        NzCheckboxGroupComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.renderer.addClass(this.el, "" + this.prefixCls);
            };
        NzCheckboxGroupComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-checkbox-group',
                        preserveWhitespaces: false,
                        template: "<label\n  nz-checkbox\n  *ngFor=\"let option of options\"\n  [nzDisabled]=\"option.disabled||nzDisabled\"\n  [(nzChecked)]=\"option.checked\"\n  (nzCheckedChange)=\"onOptionChange()\">\n  <span>{{ option.label }}</span>\n</label>",
                        providers: [
                            {
                                provide: forms.NG_VALUE_ACCESSOR,
                                useExisting: i0.forwardRef(function () { return NzCheckboxGroupComponent; }),
                                multi: true
                            }
                        ]
                    }] }
        ];
        /** @nocollapse */
        NzCheckboxGroupComponent.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: i0.Renderer2 }
            ];
        };
        NzCheckboxGroupComponent.propDecorators = {
            nzDisabled: [{ type: i0.Input }]
        };
        return NzCheckboxGroupComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCheckboxWrapperComponent = /** @class */ (function () {
        function NzCheckboxWrapperComponent() {
            this.nzOnChange = new i0.EventEmitter();
            this.checkboxList = [];
        }
        /**
         * @param {?} value
         * @return {?}
         */
        NzCheckboxWrapperComponent.prototype.addCheckbox = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.checkboxList.push(value);
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzCheckboxWrapperComponent.prototype.removeCheckbox = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.checkboxList.splice(this.checkboxList.indexOf(value), 1);
            };
        /**
         * @return {?}
         */
        NzCheckboxWrapperComponent.prototype.outputValue = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var checkedList = this.checkboxList.filter(function (item) { return item.nzChecked; });
                return checkedList.map(function (item) { return item.nzValue; });
            };
        /**
         * @return {?}
         */
        NzCheckboxWrapperComponent.prototype.onChange = /**
         * @return {?}
         */
            function () {
                this.nzOnChange.emit(this.outputValue());
            };
        NzCheckboxWrapperComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-checkbox-wrapper',
                        preserveWhitespaces: false,
                        template: "<ng-content></ng-content>",
                        host: {
                            '[class.ant-checkbox-group]': 'true'
                        }
                    }] }
        ];
        NzCheckboxWrapperComponent.propDecorators = {
            nzOnChange: [{ type: i0.Output }]
        };
        return NzCheckboxWrapperComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCheckboxComponent = /** @class */ (function () {
        function NzCheckboxComponent(elementRef, renderer, nzCheckboxWrapperComponent) {
            this.elementRef = elementRef;
            this.renderer = renderer;
            this.nzCheckboxWrapperComponent = nzCheckboxWrapperComponent;
            this._disabled = false;
            this._indeterminate = false;
            this._autoFocus = false;
            this._checked = false;
            this.isInit = false;
            this.prefixCls = 'ant-checkbox';
            this.onChange = Function.prototype;
            this.onTouched = Function.prototype;
            this.classMap = {};
            this.nzCheckedChange = new i0.EventEmitter();
            this.el = this.elementRef.nativeElement;
        }
        Object.defineProperty(NzCheckboxComponent.prototype, "nzAutoFocus", {
            get: /**
             * @return {?}
             */ function () {
                return this._autoFocus;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._autoFocus = toBoolean(value);
                this.updateAutoFocus();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCheckboxComponent.prototype, "nzDisabled", {
            get: /**
             * @return {?}
             */ function () {
                return this._disabled;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._disabled = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCheckboxComponent.prototype, "nzIndeterminate", {
            get: /**
             * @return {?}
             */ function () {
                return this._indeterminate;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._indeterminate = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCheckboxComponent.prototype, "nzChecked", {
            get: /**
             * @return {?}
             */ function () {
                return this._checked;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._checked = value;
                this.updateClassMap();
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} e
         * @return {?}
         */
        NzCheckboxComponent.prototype.onClick = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                e.preventDefault();
                this.inputElement.nativeElement.focus();
                if (!this.nzDisabled) {
                    this.updateValue(!this.nzChecked);
                }
            };
        /**
         * @return {?}
         */
        NzCheckboxComponent.prototype.onBlur = /**
         * @return {?}
         */
            function () {
                this.onTouched();
            };
        /**
         * @return {?}
         */
        NzCheckboxComponent.prototype.updateAutoFocus = /**
         * @return {?}
         */
            function () {
                if (this.isInit) {
                    if (this.nzAutoFocus) {
                        this.renderer.setAttribute(this.inputElement.nativeElement, 'autofocus', 'autofocus');
                    }
                    else {
                        this.renderer.removeAttribute(this.inputElement.nativeElement, 'autofocus');
                    }
                }
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzCheckboxComponent.prototype.updateValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.onChange(value);
                this.nzCheckedChange.emit(value);
                this.nzChecked = value;
                if (this.nzCheckboxWrapperComponent) {
                    this.nzCheckboxWrapperComponent.onChange();
                }
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzCheckboxComponent.prototype.writeValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.nzChecked = value;
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzCheckboxComponent.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onChange = fn;
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzCheckboxComponent.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onTouched = fn;
            };
        /**
         * @param {?} isDisabled
         * @return {?}
         */
        NzCheckboxComponent.prototype.setDisabledState = /**
         * @param {?} isDisabled
         * @return {?}
         */
            function (isDisabled) {
                this.nzDisabled = isDisabled;
            };
        /**
         * @return {?}
         */
        NzCheckboxComponent.prototype.updateClassMap = /**
         * @return {?}
         */
            function () {
                var _a;
                this.classMap = (_a = {},
                    _a[this.prefixCls] = true,
                    _a[this.prefixCls + "-checked"] = this.nzChecked && (!this.nzIndeterminate),
                    _a[this.prefixCls + "-disabled"] = this.nzDisabled,
                    _a[this.prefixCls + "-indeterminate"] = this.nzIndeterminate,
                    _a);
            };
        /**
         * @return {?}
         */
        NzCheckboxComponent.prototype.focus = /**
         * @return {?}
         */
            function () {
                this.inputElement.nativeElement.focus();
            };
        /**
         * @return {?}
         */
        NzCheckboxComponent.prototype.blur = /**
         * @return {?}
         */
            function () {
                this.inputElement.nativeElement.blur();
            };
        /**
         * @return {?}
         */
        NzCheckboxComponent.prototype.checkContent = /**
         * @return {?}
         */
            function () {
                if (isEmpty(this.contentElement.nativeElement)) {
                    this.renderer.setStyle(this.contentElement.nativeElement, 'display', 'none');
                }
                else {
                    this.renderer.removeStyle(this.contentElement.nativeElement, 'display');
                }
            };
        /**
         * @return {?}
         */
        NzCheckboxComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.renderer.addClass(this.el, this.prefixCls + "-wrapper");
                this.updateClassMap();
                if (this.nzCheckboxWrapperComponent) {
                    this.nzCheckboxWrapperComponent.addCheckbox(this);
                }
            };
        /**
         * @return {?}
         */
        NzCheckboxComponent.prototype.ngOnChanges = /**
         * @return {?}
         */
            function () {
                this.updateClassMap();
            };
        /**
         * @return {?}
         */
        NzCheckboxComponent.prototype.ngAfterViewInit = /**
         * @return {?}
         */
            function () {
                this.isInit = true;
                this.updateAutoFocus();
                this.checkContent();
            };
        /**
         * @return {?}
         */
        NzCheckboxComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                if (this.nzCheckboxWrapperComponent) {
                    this.nzCheckboxWrapperComponent.removeCheckbox(this);
                }
            };
        NzCheckboxComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: '[nz-checkbox]',
                        preserveWhitespaces: false,
                        template: "<span [ngClass]=\"classMap\">\n      <input\n        #inputElement\n        [checked]=\"nzChecked\"\n        type=\"checkbox\"\n        class=\"ant-checkbox-input\"\n        (blur)=\"onBlur()\">\n      <span class=\"ant-checkbox-inner\"></span>\n    </span>\n<span #contentElement (cdkObserveContent)=\"checkContent()\"><ng-content></ng-content></span>",
                        providers: [
                            {
                                provide: forms.NG_VALUE_ACCESSOR,
                                useExisting: i0.forwardRef(function () { return NzCheckboxComponent; }),
                                multi: true
                            }
                        ]
                    }] }
        ];
        /** @nocollapse */
        NzCheckboxComponent.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: i0.Renderer2 },
                { type: NzCheckboxWrapperComponent, decorators: [{ type: i0.Optional }] }
            ];
        };
        NzCheckboxComponent.propDecorators = {
            inputElement: [{ type: i0.ViewChild, args: ['inputElement',] }],
            contentElement: [{ type: i0.ViewChild, args: ['contentElement',] }],
            nzCheckedChange: [{ type: i0.Output }],
            nzValue: [{ type: i0.Input }],
            nzAutoFocus: [{ type: i0.Input }],
            nzDisabled: [{ type: i0.Input }],
            nzIndeterminate: [{ type: i0.Input }],
            nzChecked: [{ type: i0.Input }],
            onClick: [{ type: i0.HostListener, args: ['click', ['$event'],] }]
        };
        return NzCheckboxComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCheckboxModule = /** @class */ (function () {
        function NzCheckboxModule() {
        }
        NzCheckboxModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [i1.CommonModule, forms.FormsModule, observers.ObserversModule],
                        declarations: [
                            NzCheckboxComponent,
                            NzCheckboxGroupComponent,
                            NzCheckboxWrapperComponent
                        ],
                        exports: [
                            NzCheckboxComponent,
                            NzCheckboxGroupComponent,
                            NzCheckboxWrapperComponent
                        ]
                    },] }
        ];
        return NzCheckboxModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCollapseComponent = /** @class */ (function () {
        function NzCollapseComponent() {
            this._accordion = false;
            this._bordered = true;
            this.listOfPanel = [];
        }
        Object.defineProperty(NzCollapseComponent.prototype, "nzAccordion", {
            get: /**
             * @return {?}
             */ function () {
                return this._accordion;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._accordion = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCollapseComponent.prototype, "nzBordered", {
            get: /**
             * @return {?}
             */ function () {
                return this._bordered;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._bordered = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} collapse
         * @return {?}
         */
        NzCollapseComponent.prototype.click = /**
         * @param {?} collapse
         * @return {?}
         */
            function (collapse) {
                if (this.nzAccordion) {
                    this.listOfPanel.forEach(function (item) {
                        /** @type {?} */
                        var active = collapse === item;
                        if (item.nzActive !== active) {
                            item.nzActive = active;
                            item.nzActiveChange.emit(item.nzActive);
                        }
                    });
                }
                else {
                    collapse.nzActive = !collapse.nzActive;
                    collapse.nzActiveChange.emit(collapse.nzActive);
                }
            };
        /**
         * @param {?} collapse
         * @return {?}
         */
        NzCollapseComponent.prototype.addCollapse = /**
         * @param {?} collapse
         * @return {?}
         */
            function (collapse) {
                this.listOfPanel.push(collapse);
            };
        /**
         * @param {?} collapse
         * @return {?}
         */
        NzCollapseComponent.prototype.removeCollapse = /**
         * @param {?} collapse
         * @return {?}
         */
            function (collapse) {
                this.listOfPanel.splice(this.listOfPanel.indexOf(collapse), 1);
            };
        NzCollapseComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-collapse',
                        template: "<div class=\"ant-collapse\" [class.ant-collapse-borderless]=\"!nzBordered\">\n  <ng-content></ng-content>\n</div>",
                        styles: [":host {\n      display: block;\n    }"]
                    }] }
        ];
        NzCollapseComponent.propDecorators = {
            nzAccordion: [{ type: i0.Input }],
            nzBordered: [{ type: i0.Input }]
        };
        return NzCollapseComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCollapsePanelComponent = /** @class */ (function () {
        function NzCollapsePanelComponent(nzCollapseComponent, elementRef) {
            this.nzCollapseComponent = nzCollapseComponent;
            this.elementRef = elementRef;
            this._disabled = false;
            this._showArrow = true;
            this._active = false;
            this.nzActiveChange = new i0.EventEmitter();
            this.el = this.elementRef.nativeElement;
        }
        Object.defineProperty(NzCollapsePanelComponent.prototype, "nzShowArrow", {
            get: /**
             * @return {?}
             */ function () {
                return this._showArrow;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._showArrow = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCollapsePanelComponent.prototype, "isNoArrow", {
            get: /**
             * @return {?}
             */ function () {
                return !this.nzShowArrow;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCollapsePanelComponent.prototype, "nzHeader", {
            get: /**
             * @return {?}
             */ function () {
                return this._header;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.isHeaderString = !(value instanceof i0.TemplateRef);
                this._header = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCollapsePanelComponent.prototype, "nzDisabled", {
            get: /**
             * @return {?}
             */ function () {
                return this._disabled;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._disabled = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzCollapsePanelComponent.prototype, "nzActive", {
            get: /**
             * @return {?}
             */ function () {
                return this._active;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._active = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzCollapsePanelComponent.prototype.clickHeader = /**
         * @return {?}
         */
            function () {
                if (!this.nzDisabled) {
                    this.nzCollapseComponent.click(this);
                }
            };
        /**
         * @return {?}
         */
        NzCollapsePanelComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.nzCollapseComponent.addCollapse(this);
            };
        /**
         * @return {?}
         */
        NzCollapsePanelComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.nzCollapseComponent.removeCollapse(this);
            };
        NzCollapsePanelComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-collapse-panel',
                        template: "<div\n  role=\"tab\"\n  [attr.aria-expanded]=\"nzActive\"\n  class=\"ant-collapse-header\"\n  (click)=\"clickHeader()\">\n  <i class=\"arrow\" *ngIf=\"nzShowArrow\"></i>\n  <ng-container *ngIf=\"isHeaderString; else headerTemplate\">{{ nzHeader }}</ng-container>\n  <ng-template #headerTemplate>\n    <ng-template [ngTemplateOutlet]=\"nzHeader\"></ng-template>\n  </ng-template>\n</div>\n<div\n  class=\"ant-collapse-content\"\n  [class.ant-collapse-content-active]=\"nzActive\"\n  [@collapseState]=\"nzActive?'active':'inactive'\">\n  <div class=\"ant-collapse-content-box\">\n    <ng-content></ng-content>\n  </div>\n</div>",
                        animations: [
                            animations.trigger('collapseState', [
                                animations.state('inactive', animations.style({
                                    opacity: '0',
                                    height: 0
                                })),
                                animations.state('active', animations.style({
                                    opacity: '1',
                                    height: '*'
                                })),
                                animations.transition('inactive => active', animations.animate('150ms ease-in')),
                                animations.transition('active => inactive', animations.animate('150ms ease-out'))
                            ])
                        ],
                        host: {
                            '[class.ant-collapse-item]': 'true',
                            '[attr.role]': '"tablist"'
                        },
                        styles: ["\n      :host {\n        display: block\n      }"]
                    }] }
        ];
        /** @nocollapse */
        NzCollapsePanelComponent.ctorParameters = function () {
            return [
                { type: NzCollapseComponent, decorators: [{ type: i0.Host }] },
                { type: i0.ElementRef }
            ];
        };
        NzCollapsePanelComponent.propDecorators = {
            nzActiveChange: [{ type: i0.Output }],
            nzShowArrow: [{ type: i0.Input }],
            isNoArrow: [{ type: i0.HostBinding, args: ['class.ant-collapse-no-arrow',] }],
            nzHeader: [{ type: i0.Input }],
            nzDisabled: [{ type: i0.Input }, { type: i0.HostBinding, args: ['class.ant-collapse-item-disabled',] }],
            nzActive: [{ type: i0.Input }, { type: i0.HostBinding, args: ['class.ant-collapse-item-active',] }]
        };
        return NzCollapsePanelComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzCollapseModule = /** @class */ (function () {
        function NzCollapseModule() {
        }
        NzCollapseModule.decorators = [
            { type: i0.NgModule, args: [{
                        declarations: [NzCollapsePanelComponent, NzCollapseComponent],
                        exports: [NzCollapsePanelComponent, NzCollapseComponent],
                        imports: [i1.CommonModule]
                    },] }
        ];
        return NzCollapseModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzTimeValueAccessorDirective = /** @class */ (function () {
        function NzTimeValueAccessorDirective(i18n, elementRef) {
            this.i18n = i18n;
            this.elementRef = elementRef;
        }
        /**
         * @return {?}
         */
        NzTimeValueAccessorDirective.prototype.keyup = /**
         * @return {?}
         */
            function () {
                this.changed();
            };
        /**
         * @return {?}
         */
        NzTimeValueAccessorDirective.prototype.blur = /**
         * @return {?}
         */
            function () {
                this.touched();
            };
        /**
         * @return {?}
         */
        NzTimeValueAccessorDirective.prototype.changed = /**
         * @return {?}
         */
            function () {
                if (this._onChange) {
                    /** @type {?} */
                    var value = this.i18n.parseTime(this.elementRef.nativeElement.value);
                    this._onChange(value);
                }
            };
        /**
         * @return {?}
         */
        NzTimeValueAccessorDirective.prototype.touched = /**
         * @return {?}
         */
            function () {
                if (this._onTouch) {
                    this._onTouch();
                }
            };
        /**
         * @return {?}
         */
        NzTimeValueAccessorDirective.prototype.setRange = /**
         * @return {?}
         */
            function () {
                this.elementRef.nativeElement.focus();
                this.elementRef.nativeElement.setSelectionRange(0, this.elementRef.nativeElement.value.length);
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzTimeValueAccessorDirective.prototype.writeValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.elementRef.nativeElement.value = this.i18n.formatDate(value, this.format);
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzTimeValueAccessorDirective.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this._onChange = fn;
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzTimeValueAccessorDirective.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this._onTouch = fn;
            };
        NzTimeValueAccessorDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: 'input[nzTime]',
                        providers: [
                            { provide: forms.NG_VALUE_ACCESSOR, useExisting: NzTimeValueAccessorDirective, multi: true }
                        ]
                    },] }
        ];
        /** @nocollapse */
        NzTimeValueAccessorDirective.ctorParameters = function () {
            return [
                { type: NzI18nService },
                { type: i0.ElementRef }
            ];
        };
        NzTimeValueAccessorDirective.propDecorators = {
            format: [{ type: i0.Input, args: ['nzTime',] }],
            keyup: [{ type: i0.HostListener, args: ['keyup',] }],
            blur: [{ type: i0.HostListener, args: ['blur',] }]
        };
        return NzTimeValueAccessorDirective;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var TimeHolder = /** @class */ (function () {
        function TimeHolder() {
            this._seconds = undefined;
            this._hours = undefined;
            this._minutes = undefined;
            this._defaultOpenValue = new Date();
            this._changes = new rxjs.Subject();
        }
        /**
         * @return {?}
         */
        TimeHolder.prototype.setDefaultValueIfNil = /**
         * @return {?}
         */
            function () {
                if (!isNotNil(this._value)) {
                    this._value = new Date(this.defaultOpenValue);
                }
            };
        /**
         * @param {?} value
         * @param {?} disabled
         * @return {?}
         */
        TimeHolder.prototype.setMinutes = /**
         * @param {?} value
         * @param {?} disabled
         * @return {?}
         */
            function (value, disabled) {
                if (disabled) {
                    return this;
                }
                this.setDefaultValueIfNil();
                this.minutes = value;
                return this;
            };
        /**
         * @param {?} value
         * @param {?} disabled
         * @return {?}
         */
        TimeHolder.prototype.setHours = /**
         * @param {?} value
         * @param {?} disabled
         * @return {?}
         */
            function (value, disabled) {
                if (disabled) {
                    return this;
                }
                this.setDefaultValueIfNil();
                this.hours = value;
                return this;
            };
        /**
         * @param {?} value
         * @param {?} disabled
         * @return {?}
         */
        TimeHolder.prototype.setSeconds = /**
         * @param {?} value
         * @param {?} disabled
         * @return {?}
         */
            function (value, disabled) {
                if (disabled) {
                    return this;
                }
                this.setDefaultValueIfNil();
                this.seconds = value;
                return this;
            };
        Object.defineProperty(TimeHolder.prototype, "changes", {
            get: /**
             * @return {?}
             */ function () {
                return this._changes.asObservable();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TimeHolder.prototype, "value", {
            get: /**
             * @return {?}
             */ function () {
                return this._value;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value !== this._value) {
                    this._value = value;
                    if (isNotNil(this._value)) {
                        this._hours = this._value.getHours();
                        this._minutes = this._value.getMinutes();
                        this._seconds = this._value.getSeconds();
                    }
                    else {
                        this._clear();
                    }
                }
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} value
         * @return {?}
         */
        TimeHolder.prototype.setValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.value = value;
                return this;
            };
        /**
         * @return {?}
         */
        TimeHolder.prototype.clear = /**
         * @return {?}
         */
            function () {
                this._clear();
                this.update();
            };
        Object.defineProperty(TimeHolder.prototype, "isEmpty", {
            get: /**
             * @return {?}
             */ function () {
                return !(isNotNil(this._hours) || isNotNil(this._minutes) || isNotNil(this._seconds));
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        TimeHolder.prototype._clear = /**
         * @return {?}
         */
            function () {
                this._hours = undefined;
                this._minutes = undefined;
                this._seconds = undefined;
            };
        /**
         * @return {?}
         */
        TimeHolder.prototype.update = /**
         * @return {?}
         */
            function () {
                if (this.isEmpty) {
                    this._value = undefined;
                }
                else {
                    if (!isNotNil(this._hours)) {
                        this._hours = this.defaultHours;
                    }
                    else {
                        this._value.setHours(this.hours);
                    }
                    if (!isNotNil(this._minutes)) {
                        this._minutes = this.defaultMinutes;
                    }
                    else {
                        this._value.setMinutes(this.minutes);
                    }
                    if (!isNotNil(this._seconds)) {
                        this._seconds = this.defaultSeconds;
                    }
                    else {
                        this._value.setSeconds(this.seconds);
                    }
                    this._value = new Date(this._value);
                }
                this.changed();
            };
        /**
         * @return {?}
         */
        TimeHolder.prototype.changed = /**
         * @return {?}
         */
            function () {
                this._changes.next(this._value);
            };
        Object.defineProperty(TimeHolder.prototype, "hours", {
            get: /**
             * @return {?}
             */ function () {
                return this._hours;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value !== this._hours) {
                    this._hours = value;
                    this.update();
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TimeHolder.prototype, "minutes", {
            get: /**
             * @return {?}
             */ function () {
                return this._minutes;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value !== this._minutes) {
                    this._minutes = value;
                    this.update();
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TimeHolder.prototype, "seconds", {
            get: /**
             * @return {?}
             */ function () {
                return this._seconds;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value !== this._seconds) {
                    this._seconds = value;
                    this.update();
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TimeHolder.prototype, "defaultOpenValue", {
            get: /**
             * @return {?}
             */ function () {
                return this._defaultOpenValue;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (this._defaultOpenValue !== value) {
                    this._defaultOpenValue = value;
                    this.update();
                }
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} value
         * @return {?}
         */
        TimeHolder.prototype.setDefaultOpenValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.defaultOpenValue = value;
                return this;
            };
        Object.defineProperty(TimeHolder.prototype, "defaultHours", {
            get: /**
             * @return {?}
             */ function () {
                return this._defaultOpenValue.getHours();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TimeHolder.prototype, "defaultMinutes", {
            get: /**
             * @return {?}
             */ function () {
                return this._defaultOpenValue.getMinutes();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TimeHolder.prototype, "defaultSeconds", {
            get: /**
             * @return {?}
             */ function () {
                return this._defaultOpenValue.getSeconds();
            },
            enumerable: true,
            configurable: true
        });
        return TimeHolder;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * @param {?} length
     * @param {?=} step
     * @return {?}
     */
    function makeRange(length, step) {
        if (step === void 0) {
            step = 1;
        }
        return new Array(Math.ceil(length / step)).fill(0).map(function (_, i) { return i * step; });
    }
    var NzTimePickerPanelComponent = /** @class */ (function () {
        function NzTimePickerPanelComponent(element, updateCls) {
            this.element = element;
            this.updateCls = updateCls;
            this._nzHourStep = 1;
            this._nzMinuteStep = 1;
            this._nzSecondStep = 1;
            this.unsubscribe$ = new rxjs.Subject();
            this._format = 'HH:mm:ss';
            this._defaultOpenValue = new Date();
            this._opened = false;
            this._allowEmpty = true;
            this.prefixCls = 'ant-time-picker-panel';
            this.time = new TimeHolder();
            this.hourEnabled = true;
            this.minuteEnabled = true;
            this.secondEnabled = true;
            this.enabledColumns = 3;
            this.nzInDatePicker = false;
            this.nzHideDisabledOptions = false;
            this.timeClear = new i0.EventEmitter();
        }
        Object.defineProperty(NzTimePickerPanelComponent.prototype, "nzAllowEmpty", {
            get: /**
             * @return {?}
             */ function () {
                return this._allowEmpty;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (isNotNil(value)) {
                    this._allowEmpty = value;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzTimePickerPanelComponent.prototype, "opened", {
            get: /**
             * @return {?}
             */ function () {
                return this._opened;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._opened = value;
                if (this.opened) {
                    this.initPosition();
                    this.selectInputRange();
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzTimePickerPanelComponent.prototype, "nzDefaultOpenValue", {
            get: /**
             * @return {?}
             */ function () {
                return this._defaultOpenValue;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (isNotNil(value)) {
                    this._defaultOpenValue = value;
                    this.time.setDefaultOpenValue(this.nzDefaultOpenValue);
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzTimePickerPanelComponent.prototype, "nzDisabledHours", {
            get: /**
             * @return {?}
             */ function () {
                return this._disabledHours;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._disabledHours = value;
                if (this._disabledHours) {
                    this.buildHours();
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzTimePickerPanelComponent.prototype, "nzDisabledMinutes", {
            get: /**
             * @return {?}
             */ function () {
                return this._disabledMinutes;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (isNotNil(value)) {
                    this._disabledMinutes = value;
                    this.buildMinutes();
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzTimePickerPanelComponent.prototype, "nzDisabledSeconds", {
            get: /**
             * @return {?}
             */ function () {
                return this._disabledSeconds;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (isNotNil(value)) {
                    this._disabledSeconds = value;
                    this.buildSeconds();
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzTimePickerPanelComponent.prototype, "format", {
            get: /**
             * @return {?}
             */ function () {
                return this._format;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (isNotNil(value)) {
                    this._format = value;
                    this.enabledColumns = 0;
                    /** @type {?} */
                    var charSet = new Set(value);
                    this.hourEnabled = charSet.has('H') || charSet.has('h');
                    this.minuteEnabled = charSet.has('m');
                    this.secondEnabled = charSet.has('s');
                    if (this.hourEnabled) {
                        this.enabledColumns++;
                    }
                    if (this.minuteEnabled) {
                        this.enabledColumns++;
                    }
                    if (this.secondEnabled) {
                        this.enabledColumns++;
                    }
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzTimePickerPanelComponent.prototype, "nzHourStep", {
            get: /**
             * @return {?}
             */ function () {
                return this._nzHourStep;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (isNotNil(value)) {
                    this._nzHourStep = value;
                    this.buildHours();
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzTimePickerPanelComponent.prototype, "nzMinuteStep", {
            get: /**
             * @return {?}
             */ function () {
                return this._nzMinuteStep;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (isNotNil(value)) {
                    this._nzMinuteStep = value;
                    this.buildMinutes();
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzTimePickerPanelComponent.prototype, "nzSecondStep", {
            get: /**
             * @return {?}
             */ function () {
                return this._nzSecondStep;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (isNotNil(value)) {
                    this._nzSecondStep = value;
                    this.buildSeconds();
                }
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.selectInputRange = /**
         * @return {?}
         */
            function () {
                var _this = this;
                setTimeout(function () {
                    if (_this.nzTimeValueAccessorDirective) {
                        _this.nzTimeValueAccessorDirective.setRange();
                    }
                });
            };
        /**
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.buildHours = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.hourRange = makeRange(24, this.nzHourStep).map(function (r) {
                    return {
                        index: r,
                        disabled: _this.nzDisabledHours && (_this.nzDisabledHours().indexOf(r) !== -1)
                    };
                });
            };
        /**
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.buildMinutes = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.minuteRange = makeRange(60, this.nzMinuteStep).map(function (r) {
                    return {
                        index: r,
                        disabled: _this.nzDisabledMinutes && (_this.nzDisabledMinutes(_this.time.hours).indexOf(r) !== -1)
                    };
                });
            };
        /**
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.buildSeconds = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.secondRange = makeRange(60, this.nzSecondStep).map(function (r) {
                    return {
                        index: r,
                        disabled: _this.nzDisabledSeconds && (_this.nzDisabledSeconds(_this.time.hours, _this.time.minutes).indexOf(r) !== -1)
                    };
                });
            };
        /**
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.buildTimes = /**
         * @return {?}
         */
            function () {
                this.buildHours();
                this.buildMinutes();
                this.buildSeconds();
            };
        /**
         * @param {?} hour
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.selectHour = /**
         * @param {?} hour
         * @return {?}
         */
            function (hour) {
                this.time.setHours(hour.index, hour.disabled);
                this.scrollToSelected(this.hourListElement.nativeElement, hour.index, 120, 'hour');
                if (this._disabledMinutes) {
                    this.buildMinutes();
                }
                if (this._disabledSeconds || this._disabledMinutes) {
                    this.buildSeconds();
                }
            };
        /**
         * @param {?} minute
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.selectMinute = /**
         * @param {?} minute
         * @return {?}
         */
            function (minute) {
                this.time.setMinutes(minute.index, minute.disabled);
                this.scrollToSelected(this.minuteListElement.nativeElement, minute.index, 120, 'minute');
                if (this._disabledSeconds) {
                    this.buildSeconds();
                }
            };
        /**
         * @param {?} second
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.selectSecond = /**
         * @param {?} second
         * @return {?}
         */
            function (second) {
                this.time.setSeconds(second.index, second.disabled);
                this.scrollToSelected(this.secondListElement.nativeElement, second.index, 120, 'second');
            };
        /**
         * @param {?} instance
         * @param {?} index
         * @param {?=} duration
         * @param {?=} unit
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.scrollToSelected = /**
         * @param {?} instance
         * @param {?} index
         * @param {?=} duration
         * @param {?=} unit
         * @return {?}
         */
            function (instance, index, duration, unit) {
                if (duration === void 0) {
                    duration = 0;
                }
                /** @type {?} */
                var transIndex = this.translateIndex(index, unit);
                /** @type {?} */
                var currentOption = /** @type {?} */ ((instance.children[0].children[transIndex] || instance.children[0].children[0]));
                this.scrollTo(instance, currentOption.offsetTop, duration);
            };
        /**
         * @param {?} index
         * @param {?} unit
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.translateIndex = /**
         * @param {?} index
         * @param {?} unit
         * @return {?}
         */
            function (index, unit) {
                if (unit === 'hour') {
                    /** @type {?} */
                    var disabledHours = this.nzDisabledHours && this.nzDisabledHours();
                    return this.calcIndex(disabledHours, this.hourRange.map(function (item) { return item.index; }).indexOf(index));
                }
                else if (unit === 'minute') {
                    /** @type {?} */
                    var disabledMinutes = this.nzDisabledMinutes && this.nzDisabledMinutes(this.time.hours);
                    return this.calcIndex(disabledMinutes, this.minuteRange.map(function (item) { return item.index; }).indexOf(index));
                }
                else if (unit === 'second') {
                    /** @type {?} */
                    var disabledSeconds = this.nzDisabledSeconds && this.nzDisabledSeconds(this.time.hours, this.time.minutes);
                    return this.calcIndex(disabledSeconds, this.secondRange.map(function (item) { return item.index; }).indexOf(index));
                }
            };
        /**
         * @param {?} element
         * @param {?} to
         * @param {?} duration
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.scrollTo = /**
         * @param {?} element
         * @param {?} to
         * @param {?} duration
         * @return {?}
         */
            function (element, to, duration) {
                var _this = this;
                if (duration <= 0) {
                    element.scrollTop = to;
                    return;
                }
                /** @type {?} */
                var difference = to - element.scrollTop;
                /** @type {?} */
                var perTick = difference / duration * 10;
                reqAnimFrame(function () {
                    element.scrollTop = element.scrollTop + perTick;
                    if (element.scrollTop === to) {
                        return;
                    }
                    _this.scrollTo(element, to, duration - 10);
                });
            };
        /**
         * @param {?} array
         * @param {?} index
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.calcIndex = /**
         * @param {?} array
         * @param {?} index
         * @return {?}
         */
            function (array, index) {
                if (array && array.length && this.nzHideDisabledOptions) {
                    return index - array.reduce(function (pre, value) {
                        return pre + (value < index ? 1 : 0);
                    }, 0);
                }
                else {
                    return index;
                }
            };
        /**
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.clear = /**
         * @return {?}
         */
            function () {
                this.time.clear();
                this.timeClear.emit();
            };
        /**
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.changed = /**
         * @return {?}
         */
            function () {
                if (this.onChange) {
                    this.onChange(this.time.value);
                }
            };
        /**
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.touched = /**
         * @return {?}
         */
            function () {
                if (this.onTouch) {
                    this.onTouch();
                }
            };
        /**
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.setClassMap = /**
         * @return {?}
         */
            function () {
                var _a;
                this.updateCls.updateHostClass(this.element.nativeElement, (_a = {},
                    _a["" + this.prefixCls] = true,
                    _a[this.prefixCls + "-column-" + this.enabledColumns] = this.nzInDatePicker ? false : true,
                    _a[this.prefixCls + "-narrow"] = this.enabledColumns < 3,
                    _a[this.prefixCls + "-placement-bottomLeft"] = this.nzInDatePicker ? false : true,
                    _a));
            };
        /**
         * @param {?} hour
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.isSelectedHour = /**
         * @param {?} hour
         * @return {?}
         */
            function (hour) {
                return (hour.index === this.time.hours) || (!isNotNil(this.time.hours) && (hour.index === this.time.defaultHours));
            };
        /**
         * @param {?} minute
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.isSelectedMinute = /**
         * @param {?} minute
         * @return {?}
         */
            function (minute) {
                return (minute.index === this.time.minutes) || (!isNotNil(this.time.minutes) && (minute.index === this.time.defaultMinutes));
            };
        /**
         * @param {?} second
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.isSelectedSecond = /**
         * @param {?} second
         * @return {?}
         */
            function (second) {
                return (second.index === this.time.seconds) || (!isNotNil(this.time.seconds) && (second.index === this.time.defaultSeconds));
            };
        /**
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.initPosition = /**
         * @return {?}
         */
            function () {
                var _this = this;
                setTimeout(function () {
                    if (_this.hourEnabled && _this.hourListElement) {
                        if (isNotNil(_this.time.hours)) {
                            _this.scrollToSelected(_this.hourListElement.nativeElement, _this.time.hours, 0, 'hour');
                        }
                        else {
                            _this.scrollToSelected(_this.hourListElement.nativeElement, _this.time.defaultHours, 0, 'hour');
                        }
                    }
                    if (_this.minuteEnabled && _this.minuteListElement) {
                        if (isNotNil(_this.time.minutes)) {
                            _this.scrollToSelected(_this.minuteListElement.nativeElement, _this.time.minutes, 0, 'minute');
                        }
                        else {
                            _this.scrollToSelected(_this.minuteListElement.nativeElement, _this.time.defaultMinutes, 0, 'minute');
                        }
                    }
                    if (_this.secondEnabled && _this.secondListElement) {
                        if (isNotNil(_this.time.seconds)) {
                            _this.scrollToSelected(_this.secondListElement.nativeElement, _this.time.seconds, 0, 'second');
                        }
                        else {
                            _this.scrollToSelected(_this.secondListElement.nativeElement, _this.time.defaultSeconds, 0, 'second');
                        }
                    }
                });
            };
        /**
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                if (this.nzInDatePicker) {
                    this.prefixCls = 'ant-calendar-time-picker';
                }
                this.time.changes.pipe(operators.takeUntil(this.unsubscribe$)).subscribe(function () {
                    _this.changed();
                    _this.touched();
                });
                this.buildTimes();
                this.setClassMap();
            };
        /**
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.unsubscribe$.next();
                this.unsubscribe$.complete();
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.writeValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.time.value = value;
                this.buildTimes();
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onChange = fn;
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzTimePickerPanelComponent.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onTouch = fn;
            };
        NzTimePickerPanelComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-time-picker-panel',
                        template: "<div class=\"{{ nzInDatePicker ? prefixCls + '-panel' : '' }}\">\n  <div\n    class=\"{{ prefixCls }}-inner {{ nzInDatePicker ? prefixCls + '-column-' + enabledColumns : '' }}\"\n    [style.width.px]=\"nzInDatePicker ? null : enabledColumns * 56\">\n    <div class=\"{{ prefixCls }}-input-wrap\">\n      <input\n        type=\"text\"\n        class=\"{{ prefixCls }}-input\"\n        [placeholder]=\"nzPlaceHolder\"\n        [nzTime]=\"format\"\n        [(ngModel)]=\"time.value\"\n        (blur)=\"time.changed()\">\n      <a\n        *ngIf=\"nzAllowEmpty\"\n        class=\"{{ prefixCls }}-clear-btn\"\n        [attr.title]=\"nzClearText\"\n        (click)=\"clear()\">\n      </a>\n    </div>\n    <div class=\"{{ prefixCls }}-combobox\">\n      <div\n        *ngIf=\"hourEnabled\"\n        #hourListElement\n        class=\"{{ prefixCls }}-select\">\n        <ul>\n          <ng-container *ngFor=\"let hour of hourRange\">\n            <li\n              *ngIf=\"!(nzHideDisabledOptions && hour.disabled)\"\n              (click)=\"selectHour(hour)\"\n              class=\"\n                {{ isSelectedHour(hour) ? prefixCls + '-select-option-selected' : '' }}\n                {{ hour.disabled ? prefixCls + '-select-option-disabled' : '' }}\n              \"\n            >\n              {{ hour.index | number:'2.0-0' }}\n            </li>\n          </ng-container>\n        </ul>\n      </div>\n      <div\n        *ngIf=\"minuteEnabled\"\n        #minuteListElement\n        class=\"{{ prefixCls }}-select\">\n        <ul>\n          <ng-container *ngFor=\"let minute of minuteRange\">\n            <li\n              *ngIf=\"!(nzHideDisabledOptions && minute.disabled)\"\n              (click)=\"selectMinute(minute)\"\n              class=\"\n                {{ isSelectedMinute(minute) ? prefixCls + '-select-option-selected' : '' }}\n                {{ minute.disabled ? prefixCls + '-select-option-disabled' : '' }}\n              \"\n            >\n              {{ minute.index | number:'2.0-0' }}\n            </li>\n          </ng-container>\n        </ul>\n      </div>\n      <div\n        *ngIf=\"secondEnabled\"\n        #secondListElement\n        class=\"{{ prefixCls }}-select\">\n        <ul>\n          <ng-container *ngFor=\"let second of secondRange\">\n            <li\n              *ngIf=\"!(nzHideDisabledOptions && second.disabled)\"\n              (click)=\"selectSecond(second)\"\n              class=\"\n                {{ isSelectedSecond(second) ? prefixCls + '-select-option-selected' : '' }}\n                {{ second.disabled ? prefixCls + '-select-option-disabled' : '' }}\n              \"\n            >\n              {{ second.index | number:'2.0-0' }}\n            </li>\n          </ng-container>\n        </ul>\n      </div>\n    </div>\n    <div class=\"{{ prefixCls }}-addon\" *ngIf=\"nzAddOn\">\n      <ng-template [ngTemplateOutlet]=\"nzAddOn\"></ng-template>\n    </div>\n  </div>\n</div>",
                        providers: [
                            NzUpdateHostClassService,
                            { provide: forms.NG_VALUE_ACCESSOR, useExisting: NzTimePickerPanelComponent, multi: true }
                        ]
                    }] }
        ];
        /** @nocollapse */
        NzTimePickerPanelComponent.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: NzUpdateHostClassService }
            ];
        };
        NzTimePickerPanelComponent.propDecorators = {
            nzTimeValueAccessorDirective: [{ type: i0.ViewChild, args: [NzTimeValueAccessorDirective,] }],
            hourListElement: [{ type: i0.ViewChild, args: ['hourListElement',] }],
            minuteListElement: [{ type: i0.ViewChild, args: ['minuteListElement',] }],
            secondListElement: [{ type: i0.ViewChild, args: ['secondListElement',] }],
            nzInDatePicker: [{ type: i0.Input }],
            nzAddOn: [{ type: i0.Input }],
            nzHideDisabledOptions: [{ type: i0.Input }],
            nzClearText: [{ type: i0.Input }],
            nzPlaceHolder: [{ type: i0.Input }],
            timeClear: [{ type: i0.Output }],
            nzAllowEmpty: [{ type: i0.Input }],
            opened: [{ type: i0.Input }],
            nzDefaultOpenValue: [{ type: i0.Input }],
            nzDisabledHours: [{ type: i0.Input }],
            nzDisabledMinutes: [{ type: i0.Input }],
            nzDisabledSeconds: [{ type: i0.Input }],
            format: [{ type: i0.Input }],
            nzHourStep: [{ type: i0.Input }],
            nzMinuteStep: [{ type: i0.Input }],
            nzSecondStep: [{ type: i0.Input }]
        };
        return NzTimePickerPanelComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzTimePickerComponent = /** @class */ (function () {
        function NzTimePickerComponent(element, renderer, overlay, positionBuilder, i18n, updateCls) {
            this.element = element;
            this.renderer = renderer;
            this.overlay = overlay;
            this.positionBuilder = positionBuilder;
            this.i18n = i18n;
            this.updateCls = updateCls;
            this._disabled = false;
            this._value = null;
            this._allowEmpty = true;
            this._autoFocus = false;
            this._hideDisabledOptions = false;
            this.isInit = false;
            this.overlayPositions = [{
                    originX: 'start',
                    originY: 'top',
                    overlayX: 'end',
                    overlayY: 'top',
                    offsetX: 0,
                    offsetY: 0
                }];
            this.nzSize = null;
            this.nzHourStep = 1;
            this.nzMinuteStep = 1;
            this.nzSecondStep = 1;
            this.nzClearText = 'clear';
            this.nzPopupClassName = '';
            this.nzPlaceHolder = '';
            this.nzDefaultOpenValue = new Date();
            this.nzFormat = 'HH:mm:ss';
            this.nzOpen = false;
            this.nzOpenChange = new i0.EventEmitter();
        }
        Object.defineProperty(NzTimePickerComponent.prototype, "nzHideDisabledOptions", {
            get: /**
             * @return {?}
             */ function () {
                return this._hideDisabledOptions;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._hideDisabledOptions = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzTimePickerComponent.prototype, "nzAllowEmpty", {
            get: /**
             * @return {?}
             */ function () {
                return this._allowEmpty;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._allowEmpty = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzTimePickerComponent.prototype, "nzAutoFocus", {
            get: /**
             * @return {?}
             */ function () {
                return this._autoFocus;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._autoFocus = toBoolean(value);
                this.updateAutoFocus();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzTimePickerComponent.prototype, "nzDisabled", {
            get: /**
             * @return {?}
             */ function () {
                return this._disabled;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._disabled = toBoolean(value);
                /** @type {?} */
                var input = /** @type {?} */ (this.inputRef.nativeElement);
                if (this._disabled) {
                    this.renderer.setAttribute(input, 'disabled', '');
                }
                else {
                    this.renderer.removeAttribute(input, 'disabled');
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzTimePickerComponent.prototype, "value", {
            get: /**
             * @return {?}
             */ function () {
                return this._value;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._value = value;
                if (this._onChange) {
                    this._onChange(this.value);
                }
                if (this._onTouched) {
                    this._onTouched();
                }
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzTimePickerComponent.prototype.open = /**
         * @return {?}
         */
            function () {
                if (this.nzDisabled) {
                    return;
                }
                this.nzOpen = true;
                this.nzOpenChange.emit(this.nzOpen);
            };
        /**
         * @return {?}
         */
        NzTimePickerComponent.prototype.close = /**
         * @return {?}
         */
            function () {
                this.nzOpen = false;
                this.nzOpenChange.emit(this.nzOpen);
            };
        /**
         * @return {?}
         */
        NzTimePickerComponent.prototype.updateAutoFocus = /**
         * @return {?}
         */
            function () {
                if (this.isInit && !this.nzDisabled) {
                    if (this.nzAutoFocus) {
                        this.renderer.setAttribute(this.inputRef.nativeElement, 'autofocus', 'autofocus');
                    }
                    else {
                        this.renderer.removeAttribute(this.inputRef.nativeElement, 'autofocus');
                    }
                }
            };
        /**
         * @return {?}
         */
        NzTimePickerComponent.prototype.setClassMap = /**
         * @return {?}
         */
            function () {
                var _a;
                this.updateCls.updateHostClass(this.element.nativeElement, (_a = {},
                    _a["ant-time-picker"] = true,
                    _a["ant-time-picker-" + this.nzSize] = isNotNil(this.nzSize),
                    _a));
            };
        /**
         * @return {?}
         */
        NzTimePickerComponent.prototype.focus = /**
         * @return {?}
         */
            function () {
                if (this.inputRef.nativeElement) {
                    this.inputRef.nativeElement.focus();
                }
            };
        /**
         * @return {?}
         */
        NzTimePickerComponent.prototype.blur = /**
         * @return {?}
         */
            function () {
                if (this.inputRef.nativeElement) {
                    this.inputRef.nativeElement.blur();
                }
            };
        /**
         * @return {?}
         */
        NzTimePickerComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.setClassMap();
                this.origin = new i2.CdkOverlayOrigin(this.element);
            };
        /**
         * @return {?}
         */
        NzTimePickerComponent.prototype.ngAfterViewInit = /**
         * @return {?}
         */
            function () {
                this.isInit = true;
                this.updateAutoFocus();
            };
        /**
         * @param {?} time
         * @return {?}
         */
        NzTimePickerComponent.prototype.writeValue = /**
         * @param {?} time
         * @return {?}
         */
            function (time) {
                this._value = time;
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzTimePickerComponent.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this._onChange = fn;
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzTimePickerComponent.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this._onTouched = fn;
            };
        /**
         * @param {?} isDisabled
         * @return {?}
         */
        NzTimePickerComponent.prototype.setDisabledState = /**
         * @param {?} isDisabled
         * @return {?}
         */
            function (isDisabled) {
                this.nzDisabled = isDisabled;
            };
        NzTimePickerComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-time-picker',
                        template: "<input\n  type=\"text\"\n  [nzTime]=\"nzFormat\"\n  class=\"ant-time-picker-input\"\n  [placeholder]=\"nzPlaceHolder || ('TimePicker.placeholder' | nzI18n)\"\n  [(ngModel)]=\"value\"\n  readonly=\"readonly\"\n  (click)=\"open()\"\n  #inputElement>\n<span class=\"ant-time-picker-icon\"></span>\n\n<ng-template\n  cdkConnectedOverlay\n  cdkConnectedOverlayHasBackdrop\n  [cdkConnectedOverlayPositions]=\"overlayPositions\"\n  [cdkConnectedOverlayOrigin]=\"origin\"\n  [cdkConnectedOverlayOpen]=\"nzOpen\"\n  [cdkConnectedOverlayOffsetY]=\"-2\"\n  (detach)=\"close()\"\n  (backdropClick)=\"close()\">\n  <nz-time-picker-panel\n    [ngClass]=\"nzPopupClassName\"\n    [@dropDownAnimation]=\"'bottom'\"\n    [format]=\"nzFormat\"\n    [nzHourStep]=\"nzHourStep\"\n    [nzMinuteStep]=\"nzMinuteStep\"\n    [nzSecondStep]=\"nzSecondStep\"\n    [nzDisabledHours]=\"nzDisabledHours\"\n    [nzDisabledMinutes]=\"nzDisabledMinutes\"\n    [nzDisabledSeconds]=\"nzDisabledSeconds\"\n    [nzPlaceHolder]=\"nzPlaceHolder || ('TimePicker.placeholder' | nzI18n)\"\n    [nzHideDisabledOptions]=\"nzHideDisabledOptions\"\n    [nzDefaultOpenValue]=\"nzDefaultOpenValue\"\n    [nzAddOn]=\"nzAddOn\"\n    [opened]=\"nzOpen\"\n    [nzClearText]=\"nzClearText\"\n    [nzAllowEmpty]=\"nzAllowEmpty\"\n    (timeClear)=\"close()\"\n    [(ngModel)]=\"value\">\n  </nz-time-picker-panel>\n</ng-template>\n\n",
                        animations: [
                            animations.trigger('dropDownAnimation', [
                                animations.state('void', animations.style({
                                    opacity: 0,
                                    display: 'none'
                                })),
                                animations.state('*', animations.style({
                                    opacity: 1,
                                    transform: 'scaleY(1)',
                                    transformOrigin: '0% 0%'
                                })),
                                animations.transition('void => *', [
                                    animations.style({
                                        opacity: 0,
                                        transform: 'scaleY(0.8)',
                                        transformOrigin: '0% 0%'
                                    }),
                                    animations.animate('100ms cubic-bezier(0.755, 0.05, 0.855, 0.06)')
                                ]),
                                animations.transition('* => void', [
                                    animations.animate('100ms cubic-bezier(0.755, 0.05, 0.855, 0.06)', animations.style({
                                        opacity: 0,
                                        transform: 'scaleY(0.8)',
                                        transformOrigin: '0% 0%'
                                    }))
                                ])
                            ])
                        ],
                        providers: [
                            NzUpdateHostClassService,
                            { provide: forms.NG_VALUE_ACCESSOR, useExisting: NzTimePickerComponent, multi: true }
                        ]
                    }] }
        ];
        /** @nocollapse */
        NzTimePickerComponent.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: i0.Renderer2 },
                { type: i2.Overlay },
                { type: i2.OverlayPositionBuilder },
                { type: NzI18nService },
                { type: NzUpdateHostClassService }
            ];
        };
        NzTimePickerComponent.propDecorators = {
            inputRef: [{ type: i0.ViewChild, args: ['inputElement',] }],
            nzSize: [{ type: i0.Input }],
            nzHourStep: [{ type: i0.Input }],
            nzMinuteStep: [{ type: i0.Input }],
            nzSecondStep: [{ type: i0.Input }],
            nzClearText: [{ type: i0.Input }],
            nzPopupClassName: [{ type: i0.Input }],
            nzPlaceHolder: [{ type: i0.Input }],
            nzAddOn: [{ type: i0.Input }],
            nzDefaultOpenValue: [{ type: i0.Input }],
            nzDisabledHours: [{ type: i0.Input }],
            nzDisabledMinutes: [{ type: i0.Input }],
            nzDisabledSeconds: [{ type: i0.Input }],
            nzFormat: [{ type: i0.Input }],
            nzOpen: [{ type: i0.Input }],
            nzOpenChange: [{ type: i0.Output }],
            nzHideDisabledOptions: [{ type: i0.Input }],
            nzAllowEmpty: [{ type: i0.Input }],
            nzAutoFocus: [{ type: i0.Input }],
            nzDisabled: [{ type: i0.Input }]
        };
        return NzTimePickerComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzTimePickerModule = /** @class */ (function () {
        function NzTimePickerModule() {
        }
        NzTimePickerModule.decorators = [
            { type: i0.NgModule, args: [{
                        declarations: [
                            NzTimePickerComponent,
                            NzTimePickerPanelComponent,
                            NzTimeValueAccessorDirective
                        ],
                        exports: [
                            NzTimePickerPanelComponent,
                            NzTimePickerComponent
                        ],
                        imports: [i1.CommonModule, forms.FormsModule, NzI18nModule, i2.OverlayModule],
                        entryComponents: []
                    },] }
        ];
        return NzTimePickerModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var CalendarFooterComponent = /** @class */ (function () {
        function CalendarFooterComponent() {
            this.showToday = false;
            this.hasTimePicker = false;
            this.isRange = false;
            this.showTimePicker = false;
            this.showTimePickerChange = new i0.EventEmitter();
            // @Input() disabled: boolean = false;
            this.timePickerDisabled = false;
            this.okDisabled = false;
            this.clickOk = new i0.EventEmitter();
            this.clickToday = new i0.EventEmitter();
            this.prefixCls = 'ant-calendar';
            this.isTemplateRef = isTemplateRef;
            this.isNonEmptyString = isNonEmptyString;
        }
        CalendarFooterComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'calendar-footer',
                        template: "<div class=\"{{ prefixCls }}-footer {{ isRange ? prefixCls + '-range-bottom' : '' }} {{ hasTimePicker ? prefixCls + '-footer-show-ok' : '' }}\">\n  <div *ngIf=\"rangeQuickSelector\" class=\"{{ prefixCls }}-footer-extra {{ prefixCls }}-range-quick-selector\">\n    <ng-container *ngTemplateOutlet=\"rangeQuickSelector\"></ng-container>\n  </div>\n  <div *ngIf=\"extraFooter\" class=\"{{ prefixCls }}-footer-extra {{ isRange ? prefixCls + '-range-quick-selector' : '' }}\">\n    <ng-container [ngSwitch]=\"true\">\n      <ng-container *ngSwitchCase=\"isTemplateRef(extraFooter)\">\n        <ng-container *ngTemplateOutlet=\"extraFooter\"></ng-container>\n      </ng-container>\n      <ng-container *ngSwitchCase=\"isNonEmptyString(extraFooter)\">\n        <span [innerHTML]=\"extraFooter\"></span>\n      </ng-container>\n    </ng-container>\n  </div>\n  <span *ngIf=\"showToday || hasTimePicker\" class=\"{{ prefixCls }}-footer-btn\">\n    <today-button\n      *ngIf=\"showToday\"\n      [locale]=\"locale\"\n      [disabledDate]=\"disabledDate\"\n      [hasTimePicker]=\"hasTimePicker\"\n      (clickToday)=\"clickToday.emit($event)\"\n    ></today-button>\n    <time-picker-button\n      *ngIf=\"hasTimePicker\"\n      [locale]=\"locale\"\n      [timePickerDisabled]=\"timePickerDisabled\"\n      [showTimePicker]=\"showTimePicker\"\n      (showTimePickerChange)=\"showTimePickerChange.emit($event)\"\n    ></time-picker-button>\n    <ok-button\n      *ngIf=\"hasTimePicker\"\n      [okDisabled]=\"okDisabled\"\n      [locale]=\"locale\"\n      (clickOk)=\"clickOk.emit()\"\n    ></ok-button>\n  </span>\n</div>"
                    }] }
        ];
        CalendarFooterComponent.propDecorators = {
            locale: [{ type: i0.Input }],
            showToday: [{ type: i0.Input }],
            hasTimePicker: [{ type: i0.Input }],
            isRange: [{ type: i0.Input }],
            showTimePicker: [{ type: i0.Input }],
            showTimePickerChange: [{ type: i0.Output }],
            timePickerDisabled: [{ type: i0.Input }],
            okDisabled: [{ type: i0.Input }],
            disabledDate: [{ type: i0.Input }],
            extraFooter: [{ type: i0.Input }],
            rangeQuickSelector: [{ type: i0.Input }],
            clickOk: [{ type: i0.Output }],
            clickToday: [{ type: i0.Output }]
        };
        return CalendarFooterComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * [Temporary] Get the first day of week depend on locale (0-6 represent as Sunday-Saturday)
     * @param {?=} locale Locale code
     * @return {?}
     */
    function firstDayOfWeek(locale) {
        return locale && ['zh-cn', 'zh-tw'].indexOf(locale.toLowerCase()) > -1 ? 1 : 0;
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * Wrapping kind APIs for date operating and unify
     * NOTE: every new API return new CandyDate object without side effects to the former Date object
     * NOTE: most APIs are based on local time other than customized locale id (this needs tobe support in future)
     * TODO: support format() against to angular's core API
     */
    var /**
     * Wrapping kind APIs for date operating and unify
     * NOTE: every new API return new CandyDate object without side effects to the former Date object
     * NOTE: most APIs are based on local time other than customized locale id (this needs tobe support in future)
     * TODO: support format() against to angular's core API
     */ CandyDate = /** @class */ (function () {
        // locale: string; // Custom specified locale ID
        function CandyDate(date) {
            // if (!(this instanceof CandyDate)) {
            //   return new CandyDate(date);
            // }
            if (date) {
                if (date instanceof Date) {
                    this.nativeDate = date;
                }
                else if (typeof date === 'string') {
                    this.nativeDate = new Date(date);
                }
                else {
                    throw new Error('The input date type is not supported ("Date" and "string" is now recommended)');
                }
            }
            else {
                this.nativeDate = new Date();
            }
        }
        // getLocale(): string {
        //   return this.locale;
        // }
        // setLocale(locale: string): CandyDate {
        //   this.locale = locale;
        //   return this;
        // }
        // ---------------------------------------------------------------------
        // | Native shortcuts
        // ---------------------------------------------------------------------
        /**
         * @return {?}
         */
        CandyDate.prototype.getYear = /**
         * @return {?}
         */
            function () {
                return this.nativeDate.getFullYear();
            };
        /**
         * @return {?}
         */
        CandyDate.prototype.getMonth = /**
         * @return {?}
         */
            function () {
                return this.nativeDate.getMonth();
            };
        /**
         * @return {?}
         */
        CandyDate.prototype.getDay = /**
         * @return {?}
         */
            function () {
                return this.nativeDate.getDay();
            };
        /**
         * @return {?}
         */
        CandyDate.prototype.getTime = /**
         * @return {?}
         */
            function () {
                return this.nativeDate.getTime();
            };
        /**
         * @return {?}
         */
        CandyDate.prototype.getDate = /**
         * @return {?}
         */
            function () {
                return this.nativeDate.getDate();
            };
        /**
         * @return {?}
         */
        CandyDate.prototype.getHours = /**
         * @return {?}
         */
            function () {
                return this.nativeDate.getHours();
            };
        /**
         * @return {?}
         */
        CandyDate.prototype.getMinutes = /**
         * @return {?}
         */
            function () {
                return this.nativeDate.getMinutes();
            };
        /**
         * @return {?}
         */
        CandyDate.prototype.getSeconds = /**
         * @return {?}
         */
            function () {
                return this.nativeDate.getSeconds();
            };
        /**
         * @return {?}
         */
        CandyDate.prototype.getMilliseconds = /**
         * @return {?}
         */
            function () {
                return this.nativeDate.getMilliseconds();
            };
        // ---------------------------------------------------------------------
        // | New implementing APIs
        // ---------------------------------------------------------------------
        /**
         * @return {?}
         */
        CandyDate.prototype.clone = /**
         * @return {?}
         */
            function () {
                return new CandyDate(new Date(this.nativeDate));
            };
        /**
         * @param {?} hour
         * @param {?} minute
         * @param {?} second
         * @return {?}
         */
        CandyDate.prototype.setHms = /**
         * @param {?} hour
         * @param {?} minute
         * @param {?} second
         * @return {?}
         */
            function (hour, minute, second) {
                /** @type {?} */
                var date = new Date(this.nativeDate);
                date.setHours(hour, minute, second);
                return new CandyDate(date);
            };
        /**
         * @param {?} year
         * @return {?}
         */
        CandyDate.prototype.setYear = /**
         * @param {?} year
         * @return {?}
         */
            function (year) {
                /** @type {?} */
                var date = new Date(this.nativeDate);
                date.setFullYear(year);
                return new CandyDate(date);
            };
        /**
         * @param {?} amount
         * @return {?}
         */
        CandyDate.prototype.addYears = /**
         * @param {?} amount
         * @return {?}
         */
            function (amount) {
                return new CandyDate(addYears(this.nativeDate, amount));
            };
        // NOTE: month starts from 0
        // NOTE: Don't use the native API for month manipulation as it not restrict the date when it overflows, eg. (new Date('2018-7-31')).setMonth(1) will be date of 2018-3-03 instead of 2018-2-28
        /**
         * @param {?} month
         * @return {?}
         */
        CandyDate.prototype.setMonth = /**
         * @param {?} month
         * @return {?}
         */
            function (month) {
                // const date = new Date(this.nativeDate);
                // date.setMonth(month);
                // return new CandyDate(date);
                return new CandyDate(setMonth(this.nativeDate, month));
            };
        /**
         * @param {?} amount
         * @return {?}
         */
        CandyDate.prototype.addMonths = /**
         * @param {?} amount
         * @return {?}
         */
            function (amount) {
                return new CandyDate(addMonths(this.nativeDate, amount));
            };
        /**
         * @param {?} day
         * @param {?=} options
         * @return {?}
         */
        CandyDate.prototype.setDay = /**
         * @param {?} day
         * @param {?=} options
         * @return {?}
         */
            function (day, options) {
                return new CandyDate(setDay(this.nativeDate, day, options));
            };
        /**
         * @param {?} amount
         * @return {?}
         */
        CandyDate.prototype.setDate = /**
         * @param {?} amount
         * @return {?}
         */
            function (amount) {
                /** @type {?} */
                var date = new Date(this.nativeDate);
                date.setDate(amount);
                return new CandyDate(date);
            };
        /**
         * @param {?} amount
         * @return {?}
         */
        CandyDate.prototype.addDays = /**
         * @param {?} amount
         * @return {?}
         */
            function (amount) {
                return this.setDate(this.getDate() + amount);
            };
        /**
         * @param {?} grain
         * @return {?}
         */
        CandyDate.prototype.endOf = /**
         * @param {?} grain
         * @return {?}
         */
            function (grain) {
                switch (grain) {
                    case 'month': return new CandyDate(endOfMonth(this.nativeDate));
                }
                return null;
            };
        /**
         * @param {?} date
         * @param {?} grain
         * @return {?}
         */
        CandyDate.prototype.isSame = /**
         * @param {?} date
         * @param {?} grain
         * @return {?}
         */
            function (date, grain) {
                // TODO: Precipitate into a function "compare()"
                if (date) {
                    /** @type {?} */
                    var left = this.toNativeDate();
                    /** @type {?} */
                    var right = this.toNativeDate(date);
                    switch (grain) {
                        case 'year':
                            return left.getFullYear() === right.getFullYear();
                        case 'month':
                            return left.getFullYear() === right.getFullYear()
                                && left.getMonth() === right.getMonth();
                        case 'day':
                            return left.getFullYear() === right.getFullYear()
                                && left.getMonth() === right.getMonth()
                                && left.getDate() === right.getDate();
                        case 'hour':
                            return left.getFullYear() === right.getFullYear()
                                && left.getMonth() === right.getMonth()
                                && left.getDate() === right.getDate()
                                && left.getHours() === right.getHours();
                        case 'minute':
                            return left.getFullYear() === right.getFullYear()
                                && left.getMonth() === right.getMonth()
                                && left.getDate() === right.getDate()
                                && left.getHours() === right.getHours()
                                && left.getMinutes() === right.getMinutes();
                        case 'second':
                            return left.getFullYear() === right.getFullYear()
                                && left.getMonth() === right.getMonth()
                                && left.getDate() === right.getDate()
                                && left.getHours() === right.getHours()
                                && left.getMinutes() === right.getMinutes()
                                && left.getSeconds() === right.getSeconds();
                    }
                }
                return false;
            };
        /**
         * @param {?} date
         * @param {?} grain
         * @return {?}
         */
        CandyDate.prototype.isAfter = /**
         * @param {?} date
         * @param {?} grain
         * @return {?}
         */
            function (date, grain) {
                // TODO: Precipitate into a function "compare()"
                if (date) {
                    /** @type {?} */
                    var left = this.toNativeDate();
                    /** @type {?} */
                    var right = this.toNativeDate(date);
                    switch (grain) {
                        case 'year':
                            return left.getFullYear() > right.getFullYear();
                        case 'month':
                            return (left.getFullYear() > right.getFullYear())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() > right.getMonth());
                        case 'day':
                            return (left.getFullYear() > right.getFullYear())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() > right.getMonth())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() > right.getDate());
                        case 'hour':
                            return (left.getFullYear() > right.getFullYear())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() > right.getMonth())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() > right.getDate())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() === right.getDate() && left.getHours() > right.getHours());
                        case 'minute':
                            return (left.getFullYear() > right.getFullYear())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() > right.getMonth())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() > right.getDate())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() === right.getDate() && left.getHours() > right.getHours())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() === right.getDate() && left.getHours() === right.getHours() && left.getMinutes() > right.getMinutes());
                        case 'second':
                            return (left.getFullYear() > right.getFullYear())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() > right.getMonth())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() > right.getDate())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() === right.getDate() && left.getHours() > right.getHours())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() === right.getDate() && left.getHours() === right.getHours() && left.getMinutes() > right.getMinutes())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() === right.getDate() && left.getHours() === right.getHours() && left.getMinutes() === right.getMinutes() && left.getSeconds() > right.getSeconds());
                    }
                }
                return false;
            };
        /**
         * @param {?} date
         * @param {?} grain
         * @return {?}
         */
        CandyDate.prototype.isBefore = /**
         * @param {?} date
         * @param {?} grain
         * @return {?}
         */
            function (date, grain) {
                // TODO: Precipitate into a function "compare()"
                if (date) {
                    /** @type {?} */
                    var left = this.toNativeDate();
                    /** @type {?} */
                    var right = this.toNativeDate(date);
                    switch (grain) {
                        case 'year':
                            return left.getFullYear() < right.getFullYear();
                        case 'month':
                            return (left.getFullYear() < right.getFullYear())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() < right.getMonth());
                        case 'day':
                            return (left.getFullYear() < right.getFullYear())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() < right.getMonth())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() < right.getDate());
                        case 'hour':
                            return (left.getFullYear() < right.getFullYear())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() < right.getMonth())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() < right.getDate())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() === right.getDate() && left.getHours() < right.getHours());
                        case 'minute':
                            return (left.getFullYear() < right.getFullYear())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() < right.getMonth())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() < right.getDate())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() === right.getDate() && left.getHours() < right.getHours())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() === right.getDate() && left.getHours() === right.getHours() && left.getMinutes() < right.getMinutes());
                        case 'second':
                            return (left.getFullYear() < right.getFullYear())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() < right.getMonth())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() < right.getDate())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() === right.getDate() && left.getHours() < right.getHours())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() === right.getDate() && left.getHours() === right.getHours() && left.getMinutes() < right.getMinutes())
                                || (left.getFullYear() === right.getFullYear() && left.getMonth() === right.getMonth() && left.getDate() === right.getDate() && left.getHours() === right.getHours() && left.getMinutes() === right.getMinutes() && left.getSeconds() < right.getSeconds());
                    }
                }
                return false;
            };
        // Equal to today accurate to "day"
        /**
         * @return {?}
         */
        CandyDate.prototype.isToday = /**
         * @return {?}
         */
            function () {
                return this.isSame(new Date(), 'day');
            };
        /**
         * @return {?}
         */
        CandyDate.prototype.isInvalid = /**
         * @return {?}
         */
            function () {
                return isNaN(this.nativeDate.valueOf());
            };
        /**
         * 0-6 (Sunday to Saturday)
         */
        /**
         * 0-6 (Sunday to Saturday)
         * @param {?=} locale
         * @return {?}
         */
        CandyDate.prototype.firstDayOfWeek = /**
         * 0-6 (Sunday to Saturday)
         * @param {?=} locale
         * @return {?}
         */
            function (locale) {
                return firstDayOfWeek(locale);
            };
        /**
         * @param {?=} date
         * @return {?}
         */
        CandyDate.prototype.toNativeDate = /**
         * @param {?=} date
         * @return {?}
         */
            function (date) {
                if (date === void 0) {
                    date = this;
                }
                return date instanceof CandyDate ? date.nativeDate : date;
            };
        return CandyDate;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var CalendarHeaderComponent = /** @class */ (function () {
        function CalendarHeaderComponent(i18n) {
            this.i18n = i18n;
            this.enablePrev = true;
            this.enableNext = true;
            this.showTimePicker = false;
            this.valueChange = new i0.EventEmitter();
            this.panelModeChange = new i0.EventEmitter();
            this.chooseDecade = new i0.EventEmitter();
            this.chooseYear = new i0.EventEmitter();
            this.chooseMonth = new i0.EventEmitter();
            this.prefixCls = 'ant-calendar';
            this.yearToMonth = false;
        }
        /**
         * @return {?}
         */
        CalendarHeaderComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                if (!this.value) {
                    this.value = new CandyDate(); // Show today by default
                }
            };
        /**
         * @param {?} changes
         * @return {?}
         */
        CalendarHeaderComponent.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                if (changes["value"] || changes["showTimePicker"] || changes["panelMode"]) {
                    this.render();
                }
            };
        /**
         * @return {?}
         */
        CalendarHeaderComponent.prototype.previousYear = /**
         * @return {?}
         */
            function () {
                this.gotoYear(-1);
            };
        /**
         * @return {?}
         */
        CalendarHeaderComponent.prototype.nextYear = /**
         * @return {?}
         */
            function () {
                this.gotoYear(1);
            };
        /**
         * @return {?}
         */
        CalendarHeaderComponent.prototype.previousMonth = /**
         * @return {?}
         */
            function () {
                this.gotoMonth(-1);
            };
        /**
         * @return {?}
         */
        CalendarHeaderComponent.prototype.nextMonth = /**
         * @return {?}
         */
            function () {
                this.gotoMonth(1);
            };
        /**
         * @param {?} mode
         * @param {?=} value
         * @return {?}
         */
        CalendarHeaderComponent.prototype.changePanel = /**
         * @param {?} mode
         * @param {?=} value
         * @return {?}
         */
            function (mode, value) {
                this.panelModeChange.emit(mode);
                if (value) {
                    this.changeValueFromInside(value);
                }
            };
        /**
         * @param {?} value
         * @return {?}
         */
        CalendarHeaderComponent.prototype.onChooseDecade = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.changePanel('year', value);
                this.chooseDecade.emit(value);
            };
        /**
         * @param {?} value
         * @return {?}
         */
        CalendarHeaderComponent.prototype.onChooseYear = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.changePanel(this.yearToMonth ? 'month' : 'date', value);
                this.yearToMonth = false; // Clear
                this.chooseYear.emit(value);
            };
        /**
         * @param {?} value
         * @return {?}
         */
        CalendarHeaderComponent.prototype.onChooseMonth = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.changePanel('date', value);
                this.yearToMonth = false; // Clear
                this.chooseMonth.emit(value);
            };
        /**
         * @return {?}
         */
        CalendarHeaderComponent.prototype.changeToMonthPanel = /**
         * @return {?}
         */
            function () {
                this.changePanel('month');
                this.yearToMonth = true;
            };
        /**
         * @return {?}
         */
        CalendarHeaderComponent.prototype.render = /**
         * @return {?}
         */
            function () {
                if (this.value) {
                    this.yearMonthDaySelectors = this.createYearMonthDaySelectors();
                }
            };
        /**
         * @param {?} amount
         * @return {?}
         */
        CalendarHeaderComponent.prototype.gotoMonth = /**
         * @param {?} amount
         * @return {?}
         */
            function (amount) {
                this.changeValueFromInside(this.value.addMonths(amount));
            };
        /**
         * @param {?} amount
         * @return {?}
         */
        CalendarHeaderComponent.prototype.gotoYear = /**
         * @param {?} amount
         * @return {?}
         */
            function (amount) {
                this.changeValueFromInside(this.value.addYears(amount));
            };
        /**
         * @param {?} value
         * @return {?}
         */
        CalendarHeaderComponent.prototype.changeValueFromInside = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                if (this.value !== value) {
                    this.value = value;
                    this.valueChange.emit(this.value);
                    this.render();
                }
            };
        /**
         * @param {?} localeFormat
         * @return {?}
         */
        CalendarHeaderComponent.prototype.formatDateTime = /**
         * @param {?} localeFormat
         * @return {?}
         */
            function (localeFormat) {
                return this.i18n.formatDateCompatible(this.value.nativeDate, localeFormat);
            };
        /**
         * @return {?}
         */
        CalendarHeaderComponent.prototype.createYearMonthDaySelectors = /**
         * @return {?}
         */
            function () {
                var _this = this;
                /** @type {?} */
                var year;
                /** @type {?} */
                var month;
                /** @type {?} */
                var day;
                year = {
                    className: this.prefixCls + "-year-select",
                    title: this.locale.yearSelect,
                    onClick: function () { return _this.showTimePicker ? null : _this.changePanel('year'); },
                    label: this.formatDateTime(this.locale.yearFormat)
                };
                month = {
                    className: this.prefixCls + "-month-select",
                    title: this.locale.monthSelect,
                    onClick: function () { return _this.showTimePicker ? null : _this.changeToMonthPanel(); },
                    label: this.locale.monthFormat ? this.formatDateTime(this.locale.monthFormat) : this.i18n.formatDate(this.value.nativeDate, 'MMM')
                };
                if (this.showTimePicker) {
                    day = {
                        className: this.prefixCls + "-day-select",
                        label: this.formatDateTime(this.locale.dayFormat)
                    };
                }
                /** @type {?} */
                var result;
                if (this.locale.monthBeforeYear) {
                    result = [month, day, year];
                }
                else {
                    result = [year, month, day];
                }
                return result.filter(function (selector) { return !!selector; });
            };
        CalendarHeaderComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'calendar-header',
                        template: "<div class=\"{{ prefixCls }}-header\">\n  <div style=\"position: relative;\">\n    <a *ngIf=\"enablePrev && !showTimePicker\"\n      class=\"{{ prefixCls }}-prev-year-btn\"\n      role=\"button\"\n      (click)=\"previousYear()\"\n      title=\"{{ locale.previousYear }}\"\n    ></a>\n    <a *ngIf=\"enablePrev && !showTimePicker\"\n      class=\"{{ prefixCls }}-prev-month-btn\"\n      role=\"button\"\n      (click)=\"previousMonth()\"\n      title=\"{{ locale.previousMonth }}\"\n    ></a>\n\n    <span class=\"{{ prefixCls }}-{{ locale.monthBeforeYear ? 'my-select' : 'ym-select' }}\">\n      <ng-container *ngFor=\"let selector of yearMonthDaySelectors\">\n        <a class=\"{{ selector.className }}\"\n          role=\"button\"\n          (click)=\"selector.onClick ? selector.onClick() : null\"\n          title=\"{{ selector.title || null }}\"\n        >\n          {{ selector.label }}\n        </a>\n      </ng-container>\n    </span>\n\n    <a *ngIf=\"enableNext && !showTimePicker\"\n      class=\"{{ prefixCls }}-next-month-btn\"\n      role=\"button\"\n      (click)=\"nextMonth()\"\n      title=\"{{ locale.nextMonth }}\"\n    ></a>\n    <a *ngIf=\"enableNext && !showTimePicker\"\n      class=\"{{ prefixCls }}-next-year-btn\"\n      role=\"button\"\n      (click)=\"nextYear()\"\n      title=\"{{ locale.nextYear }}\"\n    ></a>\n  </div>\n\n  <ng-container [ngSwitch]=\"panelMode\">\n    <ng-container *ngSwitchCase=\"'decade'\">\n      <decade-panel\n        [locale]=\"locale\"\n        [value]=\"value\"\n        (valueChange)=\"onChooseDecade($event)\"\n      ></decade-panel>\n    </ng-container>\n    <ng-container *ngSwitchCase=\"'year'\">\n      <year-panel\n        [locale]=\"locale\"\n        [value]=\"value\"\n        (valueChange)=\"onChooseYear($event)\"\n        (decadePanelShow)=\"changePanel('decade')\"\n      ></year-panel>\n    </ng-container>\n    <ng-container *ngSwitchCase=\"'month'\">\n      <month-panel\n        [locale]=\"locale\"\n        [value]=\"value\"\n        [disabledDate]=\"disabledMonth\"\n        (valueChange)=\"onChooseMonth($event)\"\n        (yearPanelShow)=\"changePanel('year')\"\n      ></month-panel>\n    </ng-container>\n  </ng-container>\n</div>"
                    }] }
        ];
        /** @nocollapse */
        CalendarHeaderComponent.ctorParameters = function () {
            return [
                { type: NzI18nService }
            ];
        };
        CalendarHeaderComponent.propDecorators = {
            locale: [{ type: i0.Input }],
            enablePrev: [{ type: i0.Input }],
            enableNext: [{ type: i0.Input }],
            disabledMonth: [{ type: i0.Input }],
            showTimePicker: [{ type: i0.Input }],
            value: [{ type: i0.Input }],
            valueChange: [{ type: i0.Output }],
            panelMode: [{ type: i0.Input }],
            panelModeChange: [{ type: i0.Output }],
            chooseDecade: [{ type: i0.Output }],
            chooseYear: [{ type: i0.Output }],
            chooseMonth: [{ type: i0.Output }]
        };
        return CalendarHeaderComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var CalendarInputComponent = /** @class */ (function () {
        function CalendarInputComponent(i18n) {
            this.i18n = i18n;
            this.valueChange = new i0.EventEmitter();
            this.prefixCls = 'ant-calendar';
            this.invalidInputClass = '';
        }
        /**
         * @return {?}
         */
        CalendarInputComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () { };
        /**
         * @param {?} event
         * @return {?}
         */
        CalendarInputComponent.prototype.onInputKeyup = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                /** @type {?} */
                var date = this.checkValidInputDate(event);
                if (!date || (this.disabledDate && this.disabledDate(date.nativeDate))) {
                    return;
                }
                if (!date.isSame(this.value, 'second')) { // Not same with original value
                    // Not same with original value
                    this.value = date;
                    this.valueChange.emit(this.value);
                }
            };
        /**
         * @param {?} value
         * @return {?}
         */
        CalendarInputComponent.prototype.toReadableInput = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                return value ? this.i18n.formatDateCompatible(value.nativeDate, this.format) : '';
            };
        /**
         * @param {?} event
         * @return {?}
         */
        CalendarInputComponent.prototype.checkValidInputDate = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                /** @type {?} */
                var input = ( /** @type {?} */(event.target)).value;
                /** @type {?} */
                var date = new CandyDate(input);
                this.invalidInputClass = '';
                if (date.isInvalid() || input !== this.toReadableInput(date)) { // Should also match the input format exactly
                    // Should also match the input format exactly
                    this.invalidInputClass = this.prefixCls + "-input-invalid";
                    return null;
                }
                return date;
            };
        CalendarInputComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'calendar-input',
                        template: "<div class=\"{{ prefixCls }}-input-wrap\">\n  <div class=\"{{ prefixCls }}-date-input-wrap\">\n    <input\n      class=\"{{ prefixCls }}-input {{ invalidInputClass }}\"\n      placeholder=\"{{ placeholder || locale.dateSelect }}\"\n      value=\"{{ toReadableInput(value) }}\"\n      (keyup)=\"onInputKeyup($event)\"\n    />\n  </div>\n  <a class=\"{{ prefixCls }}-clear-btn\" role=\"button\" title=\"{{ locale.clear }}\"></a>\n</div>"
                    }] }
        ];
        /** @nocollapse */
        CalendarInputComponent.ctorParameters = function () {
            return [
                { type: NzI18nService }
            ];
        };
        CalendarInputComponent.propDecorators = {
            locale: [{ type: i0.Input }],
            format: [{ type: i0.Input }],
            placeholder: [{ type: i0.Input }],
            disabledDate: [{ type: i0.Input }],
            value: [{ type: i0.Input }],
            valueChange: [{ type: i0.Output }]
        };
        return CalendarInputComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var OkButtonComponent = /** @class */ (function () {
        function OkButtonComponent() {
            this.okDisabled = false;
            this.clickOk = new i0.EventEmitter();
            this.prefixCls = 'ant-calendar';
        }
        OkButtonComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'ok-button',
                        template: "<a\n    class=\"{{ prefixCls }}-ok-btn {{ okDisabled ? prefixCls + '-ok-btn-disabled' : '' }}\"\n    role=\"button\"\n    (click)=\"okDisabled ? null : clickOk.emit()\"\n  >\n    {{ locale.ok }}\n  </a>"
                    }] }
        ];
        OkButtonComponent.propDecorators = {
            locale: [{ type: i0.Input }],
            okDisabled: [{ type: i0.Input }],
            clickOk: [{ type: i0.Output }]
        };
        return OkButtonComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var TimePickerButtonComponent = /** @class */ (function () {
        function TimePickerButtonComponent() {
            this.timePickerDisabled = false;
            this.showTimePicker = false;
            this.showTimePickerChange = new i0.EventEmitter();
            this.prefixCls = 'ant-calendar';
        }
        /**
         * @return {?}
         */
        TimePickerButtonComponent.prototype.onClick = /**
         * @return {?}
         */
            function () {
                this.showTimePicker = !this.showTimePicker;
                this.showTimePickerChange.emit(this.showTimePicker);
            };
        TimePickerButtonComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'time-picker-button',
                        template: "<a\n  class=\"{{ prefixCls }}-time-picker-btn {{ timePickerDisabled ? prefixCls + '-time-picker-btn-disabled' : '' }}\"\n  role=\"button\"\n  (click)=\"timePickerDisabled ? null : onClick()\"\n>\n  {{ showTimePicker ? locale.dateSelect : locale.timeSelect }}\n</a>"
                    }] }
        ];
        TimePickerButtonComponent.propDecorators = {
            locale: [{ type: i0.Input }],
            timePickerDisabled: [{ type: i0.Input }],
            showTimePicker: [{ type: i0.Input }],
            showTimePickerChange: [{ type: i0.Output }]
        };
        return TimePickerButtonComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var TodayButtonComponent = /** @class */ (function () {
        function TodayButtonComponent(i18n) {
            this.i18n = i18n;
            this.hasTimePicker = false;
            this.clickToday = new i0.EventEmitter();
            this.prefixCls = 'ant-calendar';
            this.isDisabled = false;
            this.now = new CandyDate();
        }
        Object.defineProperty(TodayButtonComponent.prototype, "title", {
            get: /**
             * @return {?}
             */ function () {
                return this.i18n.formatDate(this.now.nativeDate, 'longDate');
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        TodayButtonComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () { };
        /**
         * @param {?} changes
         * @return {?}
         */
        TodayButtonComponent.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                if (changes["disabledDate"]) {
                    this.isDisabled = this.disabledDate && this.disabledDate(this.now.nativeDate);
                }
            };
        /**
         * @return {?}
         */
        TodayButtonComponent.prototype.onClickToday = /**
         * @return {?}
         */
            function () {
                this.clickToday.emit(this.now.clone()); // To prevent the "now" being modified from outside, we use clone
            };
        TodayButtonComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'today-button',
                        template: "<a\n  class=\"{{ prefixCls }}-today-btn {{ isDisabled ? prefixCls + '-today-btn-disabled' : '' }}\"\n  role=\"button\"\n  (click)=\"isDisabled ? null : onClickToday()\"\n  title=\"{{ title }}\"\n>\n  {{ hasTimePicker ? locale.now : locale.today }}\n</a>"
                    }] }
        ];
        /** @nocollapse */
        TodayButtonComponent.ctorParameters = function () {
            return [
                { type: NzI18nService }
            ];
        };
        TodayButtonComponent.propDecorators = {
            locale: [{ type: i0.Input }],
            hasTimePicker: [{ type: i0.Input }],
            disabledDate: [{ type: i0.Input }],
            clickToday: [{ type: i0.Output }]
        };
        return TodayButtonComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var DATE_ROW_NUM = 6;
    /** @type {?} */
    var DATE_COL_NUM = 7;
    var DateTableComponent = /** @class */ (function () {
        function DateTableComponent(i18n) {
            this.i18n = i18n;
            this.valueChange = new i0.EventEmitter();
            this.dayHover = new i0.EventEmitter();
            this.prefixCls = 'ant-calendar';
            this.isTemplateRef = isTemplateRef;
            this.isNonEmptyString = isNonEmptyString;
        }
        /**
         * @return {?}
         */
        DateTableComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () { };
        /**
         * @param {?} changes
         * @return {?}
         */
        DateTableComponent.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                if (this.isDateRealChange(changes["value"]) ||
                    this.isDateRealChange(changes["selectedValue"]) ||
                    this.isDateRealChange(changes["hoverValue"])) {
                    this.render();
                }
            };
        /**
         * @param {?} change
         * @return {?}
         */
        DateTableComponent.prototype.isDateRealChange = /**
         * @param {?} change
         * @return {?}
         */
            function (change) {
                var _this = this;
                if (change) {
                    /** @type {?} */
                    var previousValue_1 = change.previousValue;
                    /** @type {?} */
                    var currentValue = change.currentValue;
                    if (Array.isArray(currentValue)) {
                        return !Array.isArray(previousValue_1) ||
                            currentValue.length !== previousValue_1.length ||
                            currentValue.some(function (value, index) { return !_this.isSameDate(previousValue_1[index], value); });
                    }
                    else {
                        return !this.isSameDate(/** @type {?} */ (previousValue_1), currentValue);
                    }
                }
                return false;
            };
        /**
         * @param {?} left
         * @param {?} right
         * @return {?}
         */
        DateTableComponent.prototype.isSameDate = /**
         * @param {?} left
         * @param {?} right
         * @return {?}
         */
            function (left, right) {
                return (!left && !right) || (left && right && right.isSame(left, 'day'));
            };
        /**
         * @return {?}
         */
        DateTableComponent.prototype.render = /**
         * @return {?}
         */
            function () {
                if (this.value) {
                    this.headWeekDays = this.makeHeadWeekDays();
                    this.weekRows = this.makeWeekRows();
                }
            };
        /**
         * @param {?} value
         * @return {?}
         */
        DateTableComponent.prototype.changeValueFromInside = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                if (this.value !== value) {
                    // this.value = value;
                    // this.valueChange.emit(this.value);
                    // this.render();
                    this.valueChange.emit(value);
                }
            };
        /**
         * @return {?}
         */
        DateTableComponent.prototype.makeHeadWeekDays = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var weekDays = [];
                /** @type {?} */
                var firstDayOfWeek = this.getFirstDayOfWeek();
                for (var colIndex = 0; colIndex < DATE_COL_NUM; colIndex++) {
                    /** @type {?} */
                    var day = (firstDayOfWeek + colIndex) % DATE_COL_NUM;
                    /** @type {?} */
                    var tempDate = this.value.setDay(day);
                    weekDays[colIndex] = {
                        short: this.i18n.formatDate(tempDate.nativeDate, 'E'),
                        // eg. Tue
                        veryShort: this.i18n.formatDate(tempDate.nativeDate, this.getVeryShortWeekFormat()) // eg. Tu
                    };
                }
                return weekDays;
            };
        /**
         * @return {?}
         */
        DateTableComponent.prototype.getVeryShortWeekFormat = /**
         * @return {?}
         */
            function () {
                return this.i18n.getLocaleId().toLowerCase().indexOf('zh') === 0 ? 'EEEEE' : 'EEEEEE'; // Use extreme short for chinese
            };
        /**
         * @return {?}
         */
        DateTableComponent.prototype.makeWeekRows = /**
         * @return {?}
         */
            function () {
                var _this = this;
                var _a;
                /** @type {?} */
                var weekRows = [];
                /** @type {?} */
                var firstDayOfWeek = this.getFirstDayOfWeek();
                /** @type {?} */
                var firstDateOfMonth = this.value.setDate(1);
                /** @type {?} */
                var firstDateOffset = (firstDateOfMonth.getDay() + 7 - firstDayOfWeek) % 7;
                /** @type {?} */
                var firstDateToShow = firstDateOfMonth.addDays(0 - firstDateOffset);
                /** @type {?} */
                var increased = 0;
                for (var rowIndex = 0; rowIndex < DATE_ROW_NUM; rowIndex++) {
                    /** @type {?} */
                    var week = weekRows[rowIndex] = {
                        isActive: false,
                        isCurrent: false,
                        dateCells: []
                    };
                    var _loop_1 = function (colIndex) {
                        var _a;
                        /** @type {?} */
                        var current = firstDateToShow.addDays(increased++);
                        /** @type {?} */
                        var isBeforeMonthYear = this_1.isBeforeMonthYear(current, this_1.value);
                        /** @type {?} */
                        var isAfterMonthYear = this_1.isAfterMonthYear(current, this_1.value);
                        /** @type {?} */
                        var cell = {
                            value: current,
                            isSelected: false,
                            isDisabled: false,
                            isToday: false,
                            title: this_1.getDateTitle(current),
                            customContent: valueFunctionProp(this_1.dateRender, current),
                            // Customized content
                            content: "" + current.getDate(),
                            onClick: function () { return _this.changeValueFromInside(current); },
                            onMouseEnter: function () { return _this.dayHover.emit(cell.value); }
                        };
                        if (this_1.showWeek && !week.weekNum) {
                            week.weekNum = this_1.getWeekNum(current);
                        }
                        if (current.isToday()) {
                            cell.isToday = true;
                            week.isCurrent = true;
                        }
                        if (Array.isArray(this_1.selectedValue) && !isBeforeMonthYear && !isAfterMonthYear) { // Range selections
                            /** @type {?} */
                            var rangeValue = this_1.hoverValue && this_1.hoverValue.length ? this_1.hoverValue : this_1.selectedValue;
                            /** @type {?} */
                            var start = rangeValue[0];
                            /** @type {?} */
                            var end = rangeValue[1];
                            if (start) {
                                if (current.isSame(start, 'day')) {
                                    cell.isSelectedStartDate = true;
                                    cell.isSelected = true;
                                    week.isActive = true;
                                }
                                if (end) {
                                    if (current.isSame(end, 'day')) {
                                        cell.isSelectedEndDate = true;
                                        cell.isSelected = true;
                                        week.isActive = true;
                                    }
                                    else if (current.isAfter(start, 'day') && current.isBefore(end, 'day')) {
                                        cell.isInRange = true;
                                    }
                                }
                            }
                        }
                        else if (current.isSame(this_1.value, 'day')) {
                            cell.isSelected = true;
                            week.isActive = true;
                        }
                        if (this_1.disabledDate && this_1.disabledDate(current.nativeDate)) {
                            cell.isDisabled = true;
                        }
                        cell.classMap = (_a = {},
                            _a[this_1.prefixCls + "-cell"] = true,
                            // [`${this.prefixCls}-selected-date`]: false,
                            _a[this_1.prefixCls + "-today"] = cell.isToday,
                            _a[this_1.prefixCls + "-last-month-cell"] = isBeforeMonthYear,
                            _a[this_1.prefixCls + "-next-month-btn-day"] = isAfterMonthYear,
                            _a[this_1.prefixCls + "-selected-day"] = cell.isSelected,
                            _a[this_1.prefixCls + "-disabled-cell"] = cell.isDisabled,
                            _a[this_1.prefixCls + "-selected-start-date"] = !!cell.isSelectedStartDate,
                            _a[this_1.prefixCls + "-selected-end-date"] = !!cell.isSelectedEndDate,
                            _a[this_1.prefixCls + "-in-range-cell"] = !!cell.isInRange,
                            _a);
                        week.dateCells.push(cell);
                    };
                    var this_1 = this;
                    for (var colIndex = 0; colIndex < DATE_COL_NUM; colIndex++) {
                        _loop_1(colIndex);
                    }
                    week.classMap = (_a = {},
                        _a[this.prefixCls + "-current-week"] = week.isCurrent,
                        _a[this.prefixCls + "-active-week"] = week.isActive,
                        _a);
                }
                return weekRows;
            };
        /**
         * @return {?}
         */
        DateTableComponent.prototype.getFirstDayOfWeek = /**
         * @return {?}
         */
            function () {
                return this.value.firstDayOfWeek(this.i18n.getLocaleId());
            };
        /**
         * @param {?} date
         * @return {?}
         */
        DateTableComponent.prototype.getDateTitle = /**
         * @param {?} date
         * @return {?}
         */
            function (date) {
                return this.i18n.formatDate(date.nativeDate, 'longDate');
            };
        /**
         * @param {?} date
         * @return {?}
         */
        DateTableComponent.prototype.getWeekNum = /**
         * @param {?} date
         * @return {?}
         */
            function (date) {
                return +this.i18n.formatDate(date.nativeDate, 'w');
            };
        /**
         * @param {?} current
         * @param {?} target
         * @return {?}
         */
        DateTableComponent.prototype.isBeforeMonthYear = /**
         * @param {?} current
         * @param {?} target
         * @return {?}
         */
            function (current, target) {
                if (current.getYear() < target.getYear()) {
                    return true;
                }
                return current.getYear() === target.getYear() && current.getMonth() < target.getMonth();
            };
        /**
         * @param {?} current
         * @param {?} target
         * @return {?}
         */
        DateTableComponent.prototype.isAfterMonthYear = /**
         * @param {?} current
         * @param {?} target
         * @return {?}
         */
            function (current, target) {
                if (current.getYear() > target.getYear()) {
                    return true;
                }
                return current.getYear() === target.getYear() && current.getMonth() > target.getMonth();
            };
        DateTableComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'date-table',
                        template: "<table class=\"{{ prefixCls }}-table\" cellSpacing=\"0\" role=\"grid\">\n  <thead>\n    <tr role=\"row\">\n      <th *ngIf=\"showWeek\" role=\"columnheader\" class=\"{{ prefixCls }}-column-header {{ prefixCls }}-week-number-header\">\n        <span class=\"{{ prefixCls }}-column-header-inner\">x</span>\n      </th>\n      <th *ngFor=\"let cell of headWeekDays\"\n        role=\"columnheader\"\n        title=\"{{ cell.short }}\"\n        class=\"{{ prefixCls }}-column-header\"\n      >\n        <span class=\"{{ prefixCls }}-column-header-inner\">{{ cell.veryShort }}</span>\n      </th>\n    </tr>\n  </thead>\n  <tbody class=\"{{ prefixCls }}-tbody\">\n    <tr *ngFor=\"let row of weekRows\" [ngClass]=\"row.classMap\" role=\"row\">\n      <td *ngIf=\"row.weekNum\" role=\"gridcell\" class=\"{{ prefixCls }}-week-number-cell\">\n        {{ row.weekNum }}\n      </td>\n      <td\n        *ngFor=\"let cell of row.dateCells\"\n        (click)=\"cell.isDisabled ? null : cell.onClick()\"\n        (mouseenter)=\"cell.isDisabled ? null : cell.onMouseEnter()\"\n        title=\"{{ cell.title }}\"\n        [ngClass]=\"cell.classMap\"\n        role=\"gridcell\"\n      >\n\n        <ng-container [ngSwitch]=\"true\">\n          <ng-container *ngSwitchCase=\"isTemplateRef(cell.customContent)\">\n            <ng-container *ngTemplateOutlet=\"cell.customContent; context: { $implicit: cell.value }\"></ng-container>\n          </ng-container>\n          <ng-container *ngSwitchCase=\"isNonEmptyString(cell.customContent)\">\n            <span [innerHTML]=\"cell.customContent\"></span>\n          </ng-container>\n          <ng-container *ngSwitchDefault>\n            <div\n              class=\"{{ prefixCls }}-date\"\n              [attr.aria-selected]=\"cell.isSelected\"\n              [attr.aria-disabled]=\"cell.isDisabled\"\n            >\n              {{ cell.content }}\n            </div>\n          </ng-container>\n        </ng-container>\n\n      </td>\n    </tr>\n  </tbody>\n</table>"
                    }] }
        ];
        /** @nocollapse */
        DateTableComponent.ctorParameters = function () {
            return [
                { type: NzI18nService }
            ];
        };
        DateTableComponent.propDecorators = {
            selectedValue: [{ type: i0.Input }],
            hoverValue: [{ type: i0.Input }],
            value: [{ type: i0.Input }],
            valueChange: [{ type: i0.Output }],
            showWeek: [{ type: i0.Input }],
            disabledDate: [{ type: i0.Input }],
            dateRender: [{ type: i0.Input }],
            dayHover: [{ type: i0.Output }]
        };
        return DateTableComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var MAX_ROW = 4;
    /** @type {?} */
    var MAX_COL = 3;
    var DecadePanelComponent = /** @class */ (function () {
        function DecadePanelComponent() {
            this.valueChange = new i0.EventEmitter();
            this.prefixCls = 'ant-calendar-decade-panel';
        }
        Object.defineProperty(DecadePanelComponent.prototype, "startYear", {
            get: /**
             * @return {?}
             */ function () {
                return parseInt("" + this.value.getYear() / 100, 10) * 100;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(DecadePanelComponent.prototype, "endYear", {
            get: /**
             * @return {?}
             */ function () {
                return this.startYear + 99;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} changes
         * @return {?}
         */
        DecadePanelComponent.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                if (changes["value"]) {
                    this.render();
                }
            };
        /**
         * @return {?}
         */
        DecadePanelComponent.prototype.previousCentury = /**
         * @return {?}
         */
            function () {
                this.gotoYear(-100);
            };
        /**
         * @return {?}
         */
        DecadePanelComponent.prototype.nextCentury = /**
         * @return {?}
         */
            function () {
                this.gotoYear(100);
            };
        /**
         * @param {?} index
         * @param {?} decadeData
         * @return {?}
         */
        DecadePanelComponent.prototype.trackPanelDecade = /**
         * @param {?} index
         * @param {?} decadeData
         * @return {?}
         */
            function (index, decadeData) {
                return decadeData.content;
            };
        /**
         * @return {?}
         */
        DecadePanelComponent.prototype.render = /**
         * @return {?}
         */
            function () {
                if (this.value) {
                    this.panelDecades = this.makePanelDecades();
                }
            };
        /**
         * @param {?} amount
         * @return {?}
         */
        DecadePanelComponent.prototype.gotoYear = /**
         * @param {?} amount
         * @return {?}
         */
            function (amount) {
                this.value = this.value.addYears(amount);
                // this.valueChange.emit(this.value); // Do not try to trigger final value change
                this.render();
            };
        /**
         * @param {?} startYear
         * @return {?}
         */
        DecadePanelComponent.prototype.chooseDecade = /**
         * @param {?} startYear
         * @return {?}
         */
            function (startYear) {
                this.value = this.value.setYear(startYear);
                this.valueChange.emit(this.value);
            };
        /**
         * @return {?}
         */
        DecadePanelComponent.prototype.makePanelDecades = /**
         * @return {?}
         */
            function () {
                var _this = this;
                /** @type {?} */
                var decades = [];
                /** @type {?} */
                var currentYear = this.value.getYear();
                /** @type {?} */
                var startYear = this.startYear;
                /** @type {?} */
                var endYear = this.endYear;
                /** @type {?} */
                var previousYear = startYear - 10;
                /** @type {?} */
                var index = 0;
                for (var rowIndex = 0; rowIndex < MAX_ROW; rowIndex++) {
                    decades[rowIndex] = [];
                    var _loop_1 = function (colIndex) {
                        var _a;
                        /** @type {?} */
                        var start = previousYear + index * 10;
                        /** @type {?} */
                        var end = previousYear + index * 10 + 9;
                        /** @type {?} */
                        var content = start + "-" + end;
                        /** @type {?} */
                        var cell = decades[rowIndex][colIndex] = {
                            content: content,
                            title: content,
                            isCurrent: currentYear >= start && currentYear <= end,
                            isLowerThanStart: end < startYear,
                            isBiggerThanEnd: start > endYear,
                            classMap: null,
                            onClick: null
                        };
                        cell.classMap = (_a = {},
                            _a[this_1.prefixCls + "-cell"] = true,
                            _a[this_1.prefixCls + "-selected-cell"] = cell.isCurrent,
                            _a[this_1.prefixCls + "-last-century-cell"] = cell.isLowerThanStart,
                            _a[this_1.prefixCls + "-next-century-cell"] = cell.isBiggerThanEnd,
                            _a);
                        if (cell.isLowerThanStart) {
                            cell.onClick = function () { return _this.previousCentury(); };
                        }
                        else if (cell.isBiggerThanEnd) {
                            cell.onClick = function () { return _this.nextCentury(); };
                        }
                        else {
                            cell.onClick = function () { return _this.chooseDecade(start); };
                        }
                        index++;
                    };
                    var this_1 = this;
                    for (var colIndex = 0; colIndex < MAX_COL; colIndex++) {
                        _loop_1(colIndex);
                    }
                }
                return decades;
            };
        DecadePanelComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'decade-panel',
                        template: "<div class=\"{{ prefixCls }}\">\n  <div class=\"{{ prefixCls }}-header\">\n    <a\n      class=\"{{ prefixCls }}-prev-century-btn\"\n      role=\"button\"\n      (click)=\"previousCentury()\"\n      title=\"{{ locale.previousCentury }}\"\n    ></a>\n\n    <div class=\"{{ prefixCls }}-century\">\n      {{ startYear }}-{{ endYear }}\n    </div>\n    <a\n      class=\"{{ prefixCls }}-next-century-btn\"\n      role=\"button\"\n      (click)=\"nextCentury()\"\n      title=\"{{ locale.nextCentury }}\"\n    ></a>\n  </div>\n  <div class=\"{{ prefixCls }}-body\">\n    <table class=\"{{ prefixCls }}-table\" cellSpacing=\"0\" role=\"grid\">\n      <tbody class=\"{{ prefixCls }}-tbody\">\n        <tr *ngFor=\"let row of panelDecades\" role=\"row\">\n          <td *ngFor=\"let cell of row; trackBy: trackPanelDecade\"\n            role=\"gridcell\"\n            title=\"{{ cell.title }}\"\n            (click)=\"cell.onClick()\"\n            [ngClass]=\"cell.classMap\"\n          >\n            <a class=\"{{ prefixCls }}-decade\">{{ cell.content }}</a>\n          </td>\n        </tr>\n      </tbody>\n    </table>\n  </div>\n</div>"
                    }] }
        ];
        /** @nocollapse */
        DecadePanelComponent.ctorParameters = function () { return []; };
        DecadePanelComponent.propDecorators = {
            locale: [{ type: i0.Input }],
            value: [{ type: i0.Input }],
            valueChange: [{ type: i0.Output }]
        };
        return DecadePanelComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var MonthPanelComponent = /** @class */ (function () {
        function MonthPanelComponent() {
            this.valueChange = new i0.EventEmitter();
            this.yearPanelShow = new i0.EventEmitter();
            this.prefixCls = 'ant-calendar-month-panel';
        }
        /**
         * @return {?}
         */
        MonthPanelComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () { };
        /**
         * @return {?}
         */
        MonthPanelComponent.prototype.previousYear = /**
         * @return {?}
         */
            function () {
                this.gotoYear(-1);
            };
        /**
         * @return {?}
         */
        MonthPanelComponent.prototype.nextYear = /**
         * @return {?}
         */
            function () {
                this.gotoYear(1);
            };
        /**
         * @param {?} amount
         * @return {?}
         */
        MonthPanelComponent.prototype.gotoYear = /**
         * @param {?} amount
         * @return {?}
         */
            function (amount) {
                this.value = this.value.addYears(amount);
                // this.valueChange.emit(this.value); // Do not try to trigger final value change
            };
        MonthPanelComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'month-panel',
                        template: "<div class=\"{{ prefixCls }}\">\n  <div>\n    <div class=\"{{ prefixCls }}-header\">\n      <a\n        class=\"{{ prefixCls }}-prev-year-btn\"\n        role=\"button\"\n        (click)=\"previousYear()\"\n        title=\"{{ locale.previousYear }}\"\n      ></a>\n\n      <a\n        class=\"{{ prefixCls }}-year-select\"\n        role=\"button\"\n        (click)=\"yearPanelShow.emit()\"\n        title=\"{{ locale.yearSelect }}\"\n      >\n        <span class=\"{{ prefixCls }}-year-select-content\">{{ value.getYear() }}</span>\n        <span class=\"{{ prefixCls }}-year-select-arrow\">x</span>\n      </a>\n\n      <a\n        class=\"{{ prefixCls }}-next-year-btn\"\n        role=\"button\"\n        (click)=\"nextYear()\"\n        title=\"{{ locale.nextYear }}\"\n      ></a>\n    </div>\n    <div class=\"{{ prefixCls }}-body\">\n      <month-table [disabledDate]=\"disabledDate\" [value]=\"value\" (valueChange)=\"valueChange.emit($event)\"></month-table>\n    </div>\n  </div>\n</div>"
                    }] }
        ];
        /** @nocollapse */
        MonthPanelComponent.ctorParameters = function () { return []; };
        MonthPanelComponent.propDecorators = {
            locale: [{ type: i0.Input }],
            value: [{ type: i0.Input }],
            valueChange: [{ type: i0.Output }],
            disabledDate: [{ type: i0.Input }],
            yearPanelShow: [{ type: i0.Output }]
        };
        return MonthPanelComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var MAX_ROW$1 = 4;
    /** @type {?} */
    var MAX_COL$1 = 3;
    var MonthTableComponent = /** @class */ (function () {
        function MonthTableComponent(i18n) {
            this.i18n = i18n;
            this.valueChange = new i0.EventEmitter();
            this.prefixCls = 'ant-calendar-month-panel';
        }
        /**
         * @return {?}
         */
        MonthTableComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () { };
        /**
         * @param {?} changes
         * @return {?}
         */
        MonthTableComponent.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                if (changes["value"] || changes["disabledDate"]) {
                    this.render();
                }
            };
        /**
         * @param {?} index
         * @param {?} monthData
         * @return {?}
         */
        MonthTableComponent.prototype.trackPanelMonth = /**
         * @param {?} index
         * @param {?} monthData
         * @return {?}
         */
            function (index, monthData) {
                return monthData.month;
            };
        /**
         * @return {?}
         */
        MonthTableComponent.prototype.render = /**
         * @return {?}
         */
            function () {
                if (this.value) {
                    this.panelMonths = this.makePanelMonths();
                }
            };
        /**
         * @return {?}
         */
        MonthTableComponent.prototype.makePanelMonths = /**
         * @return {?}
         */
            function () {
                var _this = this;
                /** @type {?} */
                var months = [];
                /** @type {?} */
                var currentMonth = this.value.getMonth();
                /** @type {?} */
                var today = new CandyDate();
                /** @type {?} */
                var monthValue = 0;
                for (var rowIndex = 0; rowIndex < MAX_ROW$1; rowIndex++) {
                    months[rowIndex] = [];
                    var _loop_1 = function (colIndex) {
                        var _a;
                        /** @type {?} */
                        var month = this_1.value.setMonth(monthValue);
                        /** @type {?} */
                        var disabled = this_1.disabledDate ? this_1.disabledDate(this_1.value.setMonth(monthValue).nativeDate) : false;
                        /** @type {?} */
                        var content = this_1.i18n.formatDateCompatible(month.nativeDate, 'MMM');
                        /** @type {?} */
                        var cell = months[rowIndex][colIndex] = {
                            disabled: disabled,
                            content: content,
                            month: monthValue,
                            title: content,
                            classMap: null,
                            onClick: function () { return _this.chooseMonth(cell.month); }
                        };
                        cell.classMap = (_a = {},
                            _a[this_1.prefixCls + "-cell"] = true,
                            _a[this_1.prefixCls + "-cell-disabled"] = disabled,
                            _a[this_1.prefixCls + "-selected-cell"] = cell.month === currentMonth,
                            _a[this_1.prefixCls + "-current-cell"] = today.getYear() === this_1.value.getYear() && cell.month === today.getMonth(),
                            _a);
                        monthValue++;
                    };
                    var this_1 = this;
                    for (var colIndex = 0; colIndex < MAX_COL$1; colIndex++) {
                        _loop_1(colIndex);
                    }
                }
                return months;
            };
        /**
         * @param {?} month
         * @return {?}
         */
        MonthTableComponent.prototype.chooseMonth = /**
         * @param {?} month
         * @return {?}
         */
            function (month) {
                this.value = this.value.setMonth(month);
                this.valueChange.emit(this.value);
                this.render();
            };
        MonthTableComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'month-table',
                        template: "<table class=\"{{ prefixCls }}-table\" cellSpacing=\"0\" role=\"grid\">\n  <tbody class=\"{{ prefixCls }}-tbody\">\n    <tr *ngFor=\"let row of panelMonths\" role=\"row\">\n      <td *ngFor=\"let monthCell of row; trackBy: trackPanelMonth\"\n        role=\"gridcell\"\n        title=\"{{ monthCell.title }}\"\n        (click)=\"monthCell.disabled ? null : monthCell.onClick()\"\n        [ngClass]=\"monthCell.classMap\"\n      >\n        <a class=\"{{ prefixCls }}-month\">{{ monthCell.content }}</a>\n      </td>\n    </tr>\n  </tbody>\n</table>"
                    }] }
        ];
        /** @nocollapse */
        MonthTableComponent.ctorParameters = function () {
            return [
                { type: NzI18nService }
            ];
        };
        MonthTableComponent.propDecorators = {
            value: [{ type: i0.Input }],
            valueChange: [{ type: i0.Output }],
            disabledDate: [{ type: i0.Input }]
        };
        return MonthTableComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var defaultDisabledTime = {
        nzDisabledHours: /**
         * @return {?}
         */ function () {
            return [];
        },
        nzDisabledMinutes: /**
         * @return {?}
         */ function () {
            return [];
        },
        nzDisabledSeconds: /**
         * @return {?}
         */ function () {
            return [];
        }
    };
    /**
     * @param {?} value
     * @param {?} disabledTime
     * @return {?}
     */
    function getTimeConfig(value, disabledTime) {
        /** @type {?} */
        var disabledTimeConfig = disabledTime ? disabledTime(value && value.nativeDate) : /** @type {?} */ ({});
        disabledTimeConfig = __assign({}, defaultDisabledTime, disabledTimeConfig);
        return disabledTimeConfig;
    }
    /**
     * @param {?} value
     * @param {?} disabledTimeConfig
     * @return {?}
     */
    function isTimeValidByConfig(value, disabledTimeConfig) {
        /** @type {?} */
        var invalidTime = false;
        if (value) {
            /** @type {?} */
            var hour = value.getHours();
            /** @type {?} */
            var minutes = value.getMinutes();
            /** @type {?} */
            var seconds = value.getSeconds();
            /** @type {?} */
            var disabledHours = disabledTimeConfig.nzDisabledHours();
            if (disabledHours.indexOf(hour) === -1) {
                /** @type {?} */
                var disabledMinutes = disabledTimeConfig.nzDisabledMinutes(hour);
                if (disabledMinutes.indexOf(minutes) === -1) {
                    /** @type {?} */
                    var disabledSeconds = disabledTimeConfig.nzDisabledSeconds(hour, minutes);
                    invalidTime = disabledSeconds.indexOf(seconds) !== -1;
                }
                else {
                    invalidTime = true;
                }
            }
            else {
                invalidTime = true;
            }
        }
        return !invalidTime;
    }
    /**
     * @param {?} value
     * @param {?} disabledTime
     * @return {?}
     */
    function isTimeValid(value, disabledTime) {
        /** @type {?} */
        var disabledTimeConfig = getTimeConfig(value, disabledTime);
        return isTimeValidByConfig(value, disabledTimeConfig);
    }
    /**
     * @param {?} value
     * @param {?=} disabledDate
     * @param {?=} disabledTime
     * @return {?}
     */
    function isAllowedDate(value, disabledDate, disabledTime) {
        if (disabledDate) {
            if (disabledDate(value.nativeDate)) {
                return false;
            }
        }
        if (disabledTime) {
            if (!isTimeValid(value, disabledTime)) {
                return false;
            }
        }
        return true;
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var DateRangePopupComponent = /** @class */ (function () {
        function DateRangePopupComponent() {
            var _this = this;
            this.panelModeChange = new i0.EventEmitter();
            this.valueChange = new i0.EventEmitter();
            this.resultOk = new i0.EventEmitter();
            this.closePicker = new i0.EventEmitter();
            // @Output() selectDate = new EventEmitter<CandyDate>(); // Emitted when the date is selected by click the date panel (if isRange, the returned date is from one of the range parts)
            this.prefixCls = 'ant-calendar';
            this.showTimePicker = false;
            this.partTypeMap = { 'left': 0, 'right': 1 };
            this.disabledStartTime = function (value) {
                return _this.disabledTime && _this.disabledTime(value, 'start');
            };
            this.disabledEndTime = function (value) {
                return _this.disabledTime && _this.disabledTime(value, 'end');
            };
        }
        Object.defineProperty(DateRangePopupComponent.prototype, "hasTimePicker", {
            // initialValue: CandyDate = new CandyDate(); // Initial date to show when no value inputs
            // get valueOrInitial(): CandyDate {
            //   return this.value || this.initialValue;
            // }
            get: /**
             * @return {?}
             */ function () {
                return !!this.showTime;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(DateRangePopupComponent.prototype, "hasFooter", {
            get: /**
             * @return {?}
             */ function () {
                return this.showToday || this.hasTimePicker || !!this.extraFooter || !!this.ranges;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        DateRangePopupComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                // Initialization for range properties to prevent errors while later assignment
                if (this.isRange) {
                    ['placeholder', 'panelMode', 'selectedValue', 'hoverValue'].forEach(function (prop) { return _this.initialArray(prop); });
                }
            };
        /**
         * @param {?} changes
         * @return {?}
         */
        DateRangePopupComponent.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                if (this.isRange) {
                    if (changes["value"]) { // Re-initialize all related values
                        // Re-initialize all related values
                        this.clearHoverValue();
                        this.selectedValue = /** @type {?} */ (this.value);
                        this.valueForRangeShow = this.normalizeRangeValue(/** @type {?} */ (this.value));
                    }
                }
                // Parse showTime options
                if (changes["showTime"] || changes["disabledTime"]) {
                    if (this.showTime) {
                        this.buildTimeOptions();
                    }
                }
                // Show time picker when assigned panel mode as "time"
                if (changes["panelMode"] && this.hasTimePicker) {
                    this.showTimePicker = this.panelMode === 'time';
                }
            };
        /**
         * @param {?} show
         * @return {?}
         */
        DateRangePopupComponent.prototype.onShowTimePickerChange = /**
         * @param {?} show
         * @return {?}
         */
            function (show) {
                // this.panelMode = show ? 'time' : 'date';
                // this.panelModeChange.emit(this.panelMode);
                this.panelModeChange.emit(show ? 'time' : 'date');
            };
        /**
         * @param {?} value
         * @return {?}
         */
        DateRangePopupComponent.prototype.onClickToday = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                // if (this.isRange) { // Show today is not support by range
                //   throw new Error('"nzShowToday" is not support for "RangePicker"!');
                // } else {
                if (!this.isRange) {
                    this.value = null; // Clear current value to not sync time by next step
                    this.changeValue(value);
                }
                this.closePickerPanel();
            };
        /**
         * @param {?} value
         * @return {?}
         */
        DateRangePopupComponent.prototype.onDayHover = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                if (this.isRange && this.selectedValue[0] && !this.selectedValue[1]) { // When right value is selected, don't do hover
                    /** @type {?} */
                    var base = this.selectedValue[0]; // Use the left of selected value as the base to decide later hoverValue
                    if (base.isBefore(value, 'day')) {
                        this.hoverValue = [base, value];
                    }
                    else {
                        this.hoverValue = [value, base];
                    }
                }
            };
        /**
         * @param {?} mode
         * @param {?=} partType
         * @return {?}
         */
        DateRangePopupComponent.prototype.onPanelModeChange = /**
         * @param {?} mode
         * @param {?=} partType
         * @return {?}
         */
            function (mode, partType) {
                if (this.isRange) {
                    ( /** @type {?} */(this.panelMode))[this.getPartTypeIndex(partType)] = mode;
                }
                else {
                    this.panelMode = mode;
                }
                this.panelModeChange.emit(this.panelMode);
            };
        /**
         * @param {?} value
         * @param {?=} partType
         * @return {?}
         */
        DateRangePopupComponent.prototype.onHeaderChange = /**
         * @param {?} value
         * @param {?=} partType
         * @return {?}
         */
            function (value, partType) {
                if (this.isRange) {
                    this.valueForRangeShow[this.getPartTypeIndex(partType)] = value;
                    this.valueForRangeShow = this.normalizeRangeValue(this.valueForRangeShow); // Should always take care of start/end
                }
            };
        /**
         * @param {?} value
         * @param {?=} partType
         * @return {?}
         */
        DateRangePopupComponent.prototype.onSelectTime = /**
         * @param {?} value
         * @param {?=} partType
         * @return {?}
         */
            function (value, partType) {
                if (this.isRange) {
                    /** @type {?} */
                    var newValue = this.cloneRangeDate(/** @type {?} */ (this.value));
                    /** @type {?} */
                    var index = this.getPartTypeIndex(partType);
                    newValue[index] = this.overrideHms(value, newValue[index]);
                    this.setValue(newValue);
                }
                else {
                    this.setValue(this.overrideHms(value, ( /** @type {?} */(this.value)) || new CandyDate())); // If not select a date currently, use today
                }
            };
        /**
         * @param {?} value
         * @param {?=} partType
         * @return {?}
         */
        DateRangePopupComponent.prototype.changeValue = /**
         * @param {?} value
         * @param {?=} partType
         * @return {?}
         */
            function (value, partType) {
                if (this.isRange) {
                    /** @type {?} */
                    var index = this.getPartTypeIndex(partType);
                    this.selectedValue[index] = value;
                    if (this.isValidRange(this.selectedValue)) {
                        this.valueForRangeShow = this.normalizeRangeValue(this.selectedValue);
                        this.setValue(this.cloneRangeDate(this.selectedValue));
                    }
                }
                else {
                    this.setValue(value);
                }
            };
        /**
         * @param {?} value
         * @return {?}
         */
        DateRangePopupComponent.prototype.changeValueFromSelect = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                if (this.isRange) {
                    var _a = __read(/** @type {?} */ (this.selectedValue), 2), left = _a[0], right = _a[1]; // NOTE: the left/right maybe not the sequence it select at the date panels
                    if ((!left && !right) || (left && right)) { // If totally full or empty, clean up && re-assign left first
                        // If totally full or empty, clean up && re-assign left first
                        this.hoverValue = this.selectedValue = [value];
                    }
                    else if (left && !right) { // If one of them is empty, assign the other one and sort, then set the final values
                        // If one of them is empty, assign the other one and sort, then set the final values
                        this.clearHoverValue(); // Clean up
                        this.setRangeValue('selectedValue', 'right', value);
                        this.sortRangeValue('selectedValue'); // Sort
                        this.valueForRangeShow = this.normalizeRangeValue(this.selectedValue);
                        this.setValue(this.cloneRangeDate(this.selectedValue));
                    }
                }
                else {
                    this.setValue(value);
                }
                // this.selectDate.emit(value);
            };
        /**
         * @param {?} direction
         * @param {?=} partType
         * @return {?}
         */
        DateRangePopupComponent.prototype.enablePrevNext = /**
         * @param {?} direction
         * @param {?=} partType
         * @return {?}
         */
            function (direction, partType) {
                if (this.isRange) {
                    var _a = __read(this.valueForRangeShow, 2), start = _a[0], end = _a[1];
                    /** @type {?} */
                    var showMiddle = !start.addMonths(1).isSame(end, 'month'); // One month diff then don't show middle prev/next
                    if ((partType === 'left' && direction === 'next') || (partType === 'right' && direction === 'prev')) {
                        return showMiddle;
                    }
                    return true;
                }
                else {
                    return true;
                }
            };
        /**
         * @param {?=} partType
         * @return {?}
         */
        DateRangePopupComponent.prototype.getPanelMode = /**
         * @param {?=} partType
         * @return {?}
         */
            function (partType) {
                if (this.isRange) {
                    return /** @type {?} */ (this.panelMode[this.getPartTypeIndex(partType)]);
                }
                else {
                    return /** @type {?} */ (this.panelMode);
                }
            };
        // Get single value or part value of a range
        /**
         * @param {?=} partType
         * @return {?}
         */
        DateRangePopupComponent.prototype.getValue = /**
         * @param {?=} partType
         * @return {?}
         */
            function (partType) {
                if (this.isRange) {
                    return this.value[this.getPartTypeIndex(partType)];
                }
                else {
                    return /** @type {?} */ (this.value);
                }
            };
        /**
         * @param {?=} partType
         * @return {?}
         */
        DateRangePopupComponent.prototype.getValueBySelector = /**
         * @param {?=} partType
         * @return {?}
         */
            function (partType) {
                if (this.isRange) {
                    /** @type {?} */
                    var valueShow = this.showTimePicker ? this.value : this.valueForRangeShow; // Use the real time value that without decorations when timepicker is shown up
                    return valueShow[this.getPartTypeIndex(partType)];
                }
                else {
                    return /** @type {?} */ (this.value);
                }
            };
        /**
         * @param {?} partType
         * @return {?}
         */
        DateRangePopupComponent.prototype.getPartTypeIndex = /**
         * @param {?} partType
         * @return {?}
         */
            function (partType) {
                return this.partTypeMap[partType];
            };
        /**
         * @param {?=} partType
         * @return {?}
         */
        DateRangePopupComponent.prototype.getPlaceholder = /**
         * @param {?=} partType
         * @return {?}
         */
            function (partType) {
                return this.isRange ? this.placeholder[this.getPartTypeIndex(partType)] : /** @type {?} */ (this.placeholder);
            };
        /**
         * @return {?}
         */
        DateRangePopupComponent.prototype.hasSelectedValue = /**
         * @return {?}
         */
            function () {
                return this.selectedValue && !!this.selectedValue[1] && !!this.selectedValue[0];
            };
        /**
         * @return {?}
         */
        DateRangePopupComponent.prototype.isAllowedSelectedValue = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var selectedValue = this.selectedValue;
                if (selectedValue && selectedValue[0] && selectedValue[1]) {
                    return isAllowedDate(selectedValue[0], this.disabledDate, this.disabledStartTime) &&
                        isAllowedDate(selectedValue[1], this.disabledDate, this.disabledEndTime);
                }
                return false;
            };
        /**
         * @return {?}
         */
        DateRangePopupComponent.prototype.timePickerDisabled = /**
         * @return {?}
         */
            function () {
                if (!this.hasTimePicker) {
                    return true;
                }
                if (this.isRange) {
                    return !this.hasSelectedValue() || !!this.hoverValue.length;
                }
                else {
                    return false;
                }
            };
        /**
         * @return {?}
         */
        DateRangePopupComponent.prototype.okDisabled = /**
         * @return {?}
         */
            function () {
                if (!this.hasTimePicker) {
                    return true;
                }
                if (this.isRange) {
                    return !this.isAllowedSelectedValue() || !this.hasSelectedValue() || !!this.hoverValue.length;
                }
                else {
                    return this.value ? !isAllowedDate(/** @type {?} */ (this.value), this.disabledDate, this.disabledTime) : false;
                }
            };
        /**
         * @param {?=} partType
         * @return {?}
         */
        DateRangePopupComponent.prototype.getTimeOptions = /**
         * @param {?=} partType
         * @return {?}
         */
            function (partType) {
                if (this.showTime && this.timeOptions) {
                    return this.isRange ? this.timeOptions[this.getPartTypeIndex(partType)] : this.timeOptions;
                }
                return null;
            };
        /**
         * @param {?} val
         * @return {?}
         */
        DateRangePopupComponent.prototype.onClickPresetRange = /**
         * @param {?} val
         * @return {?}
         */
            function (val) {
                /** @type {?} */
                var value = valueFunctionProp(val);
                this.setValue([new CandyDate(value[0]), new CandyDate(value[1])]);
                this.resultOk.emit();
            };
        /**
         * @return {?}
         */
        DateRangePopupComponent.prototype.onPresetRangeMouseLeave = /**
         * @return {?}
         */
            function () {
                this.clearHoverValue();
            };
        /**
         * @param {?} val
         * @return {?}
         */
        DateRangePopupComponent.prototype.onHoverPresetRange = /**
         * @param {?} val
         * @return {?}
         */
            function (val) {
                this.hoverValue = ([new CandyDate(val[0]), new CandyDate(val[1])]);
            };
        /**
         * @param {?} obj
         * @return {?}
         */
        DateRangePopupComponent.prototype.getObjectKeys = /**
         * @param {?} obj
         * @return {?}
         */
            function (obj) {
                return obj ? Object.keys(obj) : [];
            };
        /**
         * @return {?}
         */
        DateRangePopupComponent.prototype.closePickerPanel = /**
         * @return {?}
         */
            function () {
                this.closePicker.emit();
            };
        /**
         * @return {?}
         */
        DateRangePopupComponent.prototype.clearHoverValue = /**
         * @return {?}
         */
            function () {
                this.hoverValue = [];
            };
        /**
         * @return {?}
         */
        DateRangePopupComponent.prototype.buildTimeOptions = /**
         * @return {?}
         */
            function () {
                if (this.showTime) {
                    /** @type {?} */
                    var showTime = typeof this.showTime === 'object' ? this.showTime : {};
                    if (this.isRange) {
                        this.timeOptions = [this.overrideTimeOptions(showTime, this.value[0], 'start'), this.overrideTimeOptions(showTime, this.value[1], 'end')];
                    }
                    else {
                        this.timeOptions = this.overrideTimeOptions(showTime, /** @type {?} */ (this.value));
                    }
                }
                else {
                    this.timeOptions = null;
                }
            };
        /**
         * @param {?} origin
         * @param {?} value
         * @param {?=} partial
         * @return {?}
         */
        DateRangePopupComponent.prototype.overrideTimeOptions = /**
         * @param {?} origin
         * @param {?} value
         * @param {?=} partial
         * @return {?}
         */
            function (origin, value, partial) {
                /** @type {?} */
                var disabledTimeFn;
                if (partial) {
                    disabledTimeFn = partial === 'start' ? this.disabledStartTime : this.disabledEndTime;
                }
                else {
                    disabledTimeFn = this.disabledTime;
                }
                return __assign({}, origin, getTimeConfig(value, disabledTimeFn));
            };
        /**
         * @param {?} value
         * @return {?}
         */
        DateRangePopupComponent.prototype.setValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                /** @type {?} */
                var newValue = value;
                // TODO: Sync original time (NOTE: this should take more care of beacuse it may depend on many change sources)
                // if (this.isRange) {
                //   // TODO: Sync time
                // } else {
                //   if (this.value) { // Sync time from the original one if it's available
                //     newValue = this.overrideHms(this.value as CandyDate, newValue as CandyDate);
                //   }
                // }
                this.value = newValue;
                this.valueChange.emit(this.value);
                this.buildTimeOptions();
            };
        /**
         * @param {?} from
         * @param {?} to
         * @return {?}
         */
        DateRangePopupComponent.prototype.overrideHms = /**
         * @param {?} from
         * @param {?} to
         * @return {?}
         */
            function (from, to) {
                if (!from || !to) {
                    return null;
                }
                return to.setHms(from.getHours(), from.getMinutes(), from.getSeconds());
            };
        /**
         * @param {?} value
         * @return {?}
         */
        DateRangePopupComponent.prototype.isValidRange = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                if (Array.isArray(value)) {
                    var _a = __read(value, 2), start = _a[0], end = _a[1];
                    /** @type {?} */
                    var grain = this.hasTimePicker ? 'second' : 'day';
                    return start && end && (start.isBefore(end, grain) || start.isSame(end, grain));
                }
                return false;
            };
        /**
         * @param {?} value
         * @return {?}
         */
        DateRangePopupComponent.prototype.normalizeRangeValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                var _a = __read(value, 2), start = _a[0], end = _a[1];
                /** @type {?} */
                var newStart = start || new CandyDate();
                /** @type {?} */
                var newEnd = end && end.isSame(newStart, 'month') ? end.addMonths(1) : end || newStart.addMonths(1);
                return [newStart, newEnd];
            };
        /**
         * @param {?} key
         * @return {?}
         */
        DateRangePopupComponent.prototype.sortRangeValue = /**
         * @param {?} key
         * @return {?}
         */
            function (key) {
                if (Array.isArray(this[key])) {
                    var _a = __read(this[key], 2), start = _a[0], end = _a[1];
                    if (start && end && start.isAfter(end, 'day')) {
                        this[key] = [end, start];
                    }
                }
            };
        /**
         * @param {?} key
         * @param {?} partType
         * @param {?} value
         * @return {?}
         */
        DateRangePopupComponent.prototype.setRangeValue = /**
         * @param {?} key
         * @param {?} partType
         * @param {?} value
         * @return {?}
         */
            function (key, partType, value) {
                /** @type {?} */
                var ref = this[key] = this.cloneRangeDate(/** @type {?} */ (this[key]));
                ref[this.getPartTypeIndex(partType)] = value;
            };
        /**
         * @param {?} value
         * @return {?}
         */
        DateRangePopupComponent.prototype.cloneRangeDate = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                return /** @type {?} */ ([value[0] && value[0].clone(), value[1] && value[1].clone()]);
            };
        /**
         * @param {?} key
         * @return {?}
         */
        DateRangePopupComponent.prototype.initialArray = /**
         * @param {?} key
         * @return {?}
         */
            function (key) {
                if (!this[key] || !Array.isArray(this[key])) {
                    this[key] = [];
                }
            };
        DateRangePopupComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'date-range-popup',
                        template: "<div\n  class=\"{{ prefixCls }}-picker-container {{ dropdownClassName }} {{ prefixCls }}-picker-container-placement-bottomLeft\"\n  [ngStyle]=\"popupStyle\">\n\n  <div class=\"{{ prefixCls }} {{ showWeek ? prefixCls + '-week-number': '' }} {{ hasTimePicker ? prefixCls + '-time' : '' }} {{ isRange ? prefixCls + '-range' : '' }}\" tabindex=\"0\">\n    <div class=\"{{ prefixCls }}-panel\">\n      <ng-container *ngIf=\"!isRange\"> <!-- Single ONLY -->\n        <ng-container *ngTemplateOutlet=\"tplCalendarInput\"></ng-container>\n      </ng-container>\n      <div class=\"{{ prefixCls }}-date-panel\">\n        <ng-container *ngIf=\"isRange; else tplSinglePart\">\n          <!-- Range Selectors -->\n          <ng-container *ngTemplateOutlet=\"tplRangePart; context: { partType: 'left' }\"></ng-container>\n          <div class=\"ant-calendar-range-middle\">~</div>\n          <ng-container *ngTemplateOutlet=\"tplRangePart; context: { partType: 'right' }\"></ng-container>\n        </ng-container>\n\n        <ng-container *ngIf=\"!isRange\"> <!-- Single ONLY -->\n          <ng-container *ngTemplateOutlet=\"tplFooter\"></ng-container>\n        </ng-container>\n      </div>\n      <ng-container *ngIf=\"isRange\"> <!-- Range ONLY -->\n        <ng-container *ngTemplateOutlet=\"tplFooter\"></ng-container>\n      </ng-container>\n    </div>\n  </div>\n</div>\n\n<ng-template #tplCalendarInput let-partType=\"partType\">\n  <calendar-input\n    [value]=\"getValue(partType)\"\n    (valueChange)=\"changeValue($event, partType)\"\n    [locale]=\"locale\"\n    [disabledDate]=\"disabledDate\"\n    [format]=\"format\"\n    [placeholder]=\"getPlaceholder(partType)\"\n  ></calendar-input>\n</ng-template>\n\n<ng-template #tplInnerPopup let-partType=\"partType\">\n  <inner-popup\n    [showWeek]=\"showWeek\"\n    [locale]=\"locale\"\n    [showTimePicker]=\"hasTimePicker && showTimePicker\"\n    [timeOptions]=\"getTimeOptions(partType)\"\n    [panelMode]=\"getPanelMode(partType)\"\n    (panelModeChange)=\"onPanelModeChange($event, partType)\"\n    [value]=\"getValueBySelector(partType)\"\n    [disabledDate]=\"disabledDate\"\n    [dateRender]=\"dateRender\"\n    [selectedValue]=\"selectedValue\"\n    [hoverValue]=\"hoverValue\"\n    [enablePrev]=\"enablePrevNext('prev', partType)\"\n    [enableNext]=\"enablePrevNext('next', partType)\"\n    (dayHover)=\"onDayHover($event)\"\n    (selectDate)=\"changeValueFromSelect($event)\"\n    (selectTime)=\"onSelectTime($event, partType)\"\n    (headerChange)=\"onHeaderChange($event, partType)\"\n  ></inner-popup>\n</ng-template>\n\n<ng-template #tplFooter>\n  <calendar-footer\n    *ngIf=\"hasFooter\"\n    [locale]=\"locale\"\n    [showToday]=\"showToday\"\n    [hasTimePicker]=\"hasTimePicker\"\n    [timePickerDisabled]=\"timePickerDisabled()\"\n    [okDisabled]=\"okDisabled()\"\n    [extraFooter]=\"extraFooter\"\n    [rangeQuickSelector]=\"ranges ? tplRangeQuickSelector : null\"\n    [(showTimePicker)]=\"showTimePicker\"\n    (showTimePickerChange)=\"onShowTimePickerChange($event)\"\n    (clickOk)=\"resultOk.emit()\"\n    (clickToday)=\"onClickToday($event)\"\n  ></calendar-footer>\n</ng-template>\n\n<!-- Single ONLY -->\n<ng-template #tplSinglePart>\n  <ng-container *ngTemplateOutlet=\"tplInnerPopup\"></ng-container>\n</ng-template>\n\n<!-- Range ONLY -->\n<ng-template #tplRangePart let-partType=\"partType\">\n  <div class=\"{{ prefixCls }}-range-part {{ prefixCls }}-range-{{ partType }}\">\n    <ng-container *ngTemplateOutlet=\"tplCalendarInput; context: { partType: partType }\"></ng-container>\n    <div style=\"outline: none;\">\n      <ng-container *ngTemplateOutlet=\"tplInnerPopup; context: { partType: partType }\"></ng-container>\n    </div>\n  </div>\n</ng-template>\n\n<!-- Range ONLY: Range Quick Selector -->\n<ng-template #tplRangeQuickSelector>\n  <a *ngFor=\"let name of getObjectKeys(ranges)\"\n    (click)=\"onClickPresetRange(ranges[name])\"\n    (mouseenter)=\"onHoverPresetRange(ranges[name])\"\n    (mouseleave)=\"onPresetRangeMouseLeave()\"\n  >{{ name }}</a>\n</ng-template>"
                    }] }
        ];
        DateRangePopupComponent.propDecorators = {
            isRange: [{ type: i0.Input }],
            showWeek: [{ type: i0.Input }],
            locale: [{ type: i0.Input }],
            format: [{ type: i0.Input }],
            placeholder: [{ type: i0.Input }],
            disabledDate: [{ type: i0.Input }],
            disabledTime: [{ type: i0.Input }],
            showToday: [{ type: i0.Input }],
            showTime: [{ type: i0.Input }],
            extraFooter: [{ type: i0.Input }],
            ranges: [{ type: i0.Input }],
            dateRender: [{ type: i0.Input }],
            popupStyle: [{ type: i0.Input }],
            dropdownClassName: [{ type: i0.Input }],
            panelMode: [{ type: i0.Input }],
            panelModeChange: [{ type: i0.Output }],
            value: [{ type: i0.Input }],
            valueChange: [{ type: i0.Output }],
            resultOk: [{ type: i0.Output }],
            closePicker: [{ type: i0.Output }]
        };
        return DateRangePopupComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var InnerPopupComponent = /** @class */ (function () {
        function InnerPopupComponent() {
            this.panelModeChange = new i0.EventEmitter();
            this.headerChange = new i0.EventEmitter();
            this.selectDate = new i0.EventEmitter();
            this.selectTime = new i0.EventEmitter();
            this.dayHover = new i0.EventEmitter();
            this.prefixCls = 'ant-calendar';
        }
        /**
         * @return {?}
         */
        InnerPopupComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () { };
        /**
         * @param {?} changes
         * @return {?}
         */
        InnerPopupComponent.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                if (changes["value"] && !this.value) {
                    this.value = new CandyDate();
                }
            };
        /**
         * @param {?} date
         * @return {?}
         */
        InnerPopupComponent.prototype.onSelectTime = /**
         * @param {?} date
         * @return {?}
         */
            function (date) {
                this.selectTime.emit(new CandyDate(date));
            };
        // The value real changed to outside
        /**
         * @param {?} date
         * @return {?}
         */
        InnerPopupComponent.prototype.onSelectDate = /**
         * @param {?} date
         * @return {?}
         */
            function (date) {
                /** @type {?} */
                var value = date instanceof CandyDate ? date : new CandyDate(date);
                this.selectDate.emit(value);
            };
        InnerPopupComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'inner-popup',
                        template: "<calendar-header\n  [(panelMode)]=\"panelMode\"\n  (panelModeChange)=\"panelModeChange.emit($event)\"\n  [(value)]=\"value\"\n  (valueChange)=\"headerChange.emit($event)\"\n  [locale]=\"locale\"\n  [showTimePicker]=\"showTimePicker\"\n  [enablePrev]=\"enablePrev\"\n  [enableNext]=\"enableNext\"\n></calendar-header>\n\n<ng-container *ngIf=\"showTimePicker && timeOptions\">\n  <nz-time-picker-panel\n    [nzInDatePicker]=\"true\"\n    [ngModel]=\"value.nativeDate\"\n    (ngModelChange)=\"onSelectTime($event)\"\n    [format]=\"timeOptions.nzFormat\"\n    [nzHourStep]=\"timeOptions.nzHourStep\"\n    [nzMinuteStep]=\"timeOptions.nzMinuteStep\"\n    [nzSecondStep]=\"timeOptions.nzSecondStep\"\n    [nzDisabledHours]=\"timeOptions.nzDisabledHours\"\n    [nzDisabledMinutes]=\"timeOptions.nzDisabledMinutes\"\n    [nzDisabledSeconds]=\"timeOptions.nzDisabledSeconds\"\n    [nzHideDisabledOptions]=\"timeOptions.nzHideDisabledOptions\"\n    [nzDefaultOpenValue]=\"timeOptions.nzDefaultOpenValue\"\n    [nzAddOn]=\"timeOptions.nzAddOn\"\n  ></nz-time-picker-panel>\n</ng-container>\n\n<div class=\"{{ prefixCls }}-body\">\n  <date-table\n    [showWeek]=\"showWeek\"\n    [value]=\"value\"\n    (valueChange)=\"onSelectDate($event)\"\n    showWeekNumber=\"false\"\n    [disabledDate]=\"disabledDate\"\n    [dateRender]=\"dateRender\"\n    [selectedValue]=\"selectedValue\"\n    [hoverValue]=\"hoverValue\"\n    (dayHover)=\"dayHover.emit($event)\"\n  ></date-table>\n</div>"
                    }] }
        ];
        /** @nocollapse */
        InnerPopupComponent.ctorParameters = function () { return []; };
        InnerPopupComponent.propDecorators = {
            showWeek: [{ type: i0.Input }],
            locale: [{ type: i0.Input }],
            showTimePicker: [{ type: i0.Input }],
            timeOptions: [{ type: i0.Input }],
            enablePrev: [{ type: i0.Input }],
            enableNext: [{ type: i0.Input }],
            disabledDate: [{ type: i0.Input }],
            dateRender: [{ type: i0.Input }],
            selectedValue: [{ type: i0.Input }],
            hoverValue: [{ type: i0.Input }],
            panelMode: [{ type: i0.Input }],
            panelModeChange: [{ type: i0.Output }],
            value: [{ type: i0.Input }],
            headerChange: [{ type: i0.Output }],
            selectDate: [{ type: i0.Output }],
            selectTime: [{ type: i0.Output }],
            dayHover: [{ type: i0.Output }]
        };
        return InnerPopupComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var MAX_ROW$2 = 4;
    /** @type {?} */
    var MAX_COL$2 = 3;
    var YearPanelComponent = /** @class */ (function () {
        function YearPanelComponent() {
            this.valueChange = new i0.EventEmitter();
            this.decadePanelShow = new i0.EventEmitter();
            this.prefixCls = 'ant-calendar-year-panel';
        }
        Object.defineProperty(YearPanelComponent.prototype, "currentYear", {
            get: /**
             * @return {?}
             */ function () {
                return this.value.getYear();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(YearPanelComponent.prototype, "startYear", {
            get: /**
             * @return {?}
             */ function () {
                return parseInt("" + this.currentYear / 10, 10) * 10;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(YearPanelComponent.prototype, "endYear", {
            get: /**
             * @return {?}
             */ function () {
                return this.startYear + 9;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} changes
         * @return {?}
         */
        YearPanelComponent.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                if (changes["value"]) {
                    this.render();
                }
            };
        /**
         * @return {?}
         */
        YearPanelComponent.prototype.previousDecade = /**
         * @return {?}
         */
            function () {
                this.gotoYear(-10);
            };
        /**
         * @return {?}
         */
        YearPanelComponent.prototype.nextDecade = /**
         * @return {?}
         */
            function () {
                this.gotoYear(10);
            };
        /**
         * @param {?} index
         * @param {?} yearData
         * @return {?}
         */
        YearPanelComponent.prototype.trackPanelYear = /**
         * @param {?} index
         * @param {?} yearData
         * @return {?}
         */
            function (index, yearData) {
                return yearData.content;
            };
        /**
         * @return {?}
         */
        YearPanelComponent.prototype.render = /**
         * @return {?}
         */
            function () {
                if (this.value) {
                    this.panelYears = this.makePanelYears();
                }
            };
        /**
         * @param {?} amount
         * @return {?}
         */
        YearPanelComponent.prototype.gotoYear = /**
         * @param {?} amount
         * @return {?}
         */
            function (amount) {
                this.value = this.value.addYears(amount);
                // this.valueChange.emit(this.value); // Do not trigger final value change
                this.render();
            };
        /**
         * @param {?} year
         * @return {?}
         */
        YearPanelComponent.prototype.chooseYear = /**
         * @param {?} year
         * @return {?}
         */
            function (year) {
                this.value = this.value.setYear(year);
                this.valueChange.emit(this.value);
                this.render();
            };
        /**
         * @return {?}
         */
        YearPanelComponent.prototype.makePanelYears = /**
         * @return {?}
         */
            function () {
                var _this = this;
                /** @type {?} */
                var years = [];
                /** @type {?} */
                var currentYear = this.currentYear;
                /** @type {?} */
                var startYear = this.startYear;
                /** @type {?} */
                var endYear = this.endYear;
                /** @type {?} */
                var previousYear = startYear - 1;
                /** @type {?} */
                var index = 0;
                for (var rowIndex = 0; rowIndex < MAX_ROW$2; rowIndex++) {
                    years[rowIndex] = [];
                    var _loop_1 = function (colIndex) {
                        var _a;
                        /** @type {?} */
                        var year = previousYear + index;
                        /** @type {?} */
                        var content = String(year);
                        /** @type {?} */
                        var cell = years[rowIndex][colIndex] = {
                            content: content,
                            year: year,
                            title: content,
                            isCurrent: year === currentYear,
                            isLowerThanStart: year < startYear,
                            isBiggerThanEnd: year > endYear,
                            classMap: null,
                            onClick: null
                        };
                        cell.classMap = (_a = {},
                            _a[this_1.prefixCls + "-cell"] = true,
                            _a[this_1.prefixCls + "-selected-cell"] = cell.isCurrent,
                            _a[this_1.prefixCls + "-last-decade-cell"] = cell.isLowerThanStart,
                            _a[this_1.prefixCls + "-next-decade-cell"] = cell.isBiggerThanEnd,
                            _a);
                        if (cell.isLowerThanStart) {
                            cell.onClick = function () { return _this.previousDecade(); };
                        }
                        else if (cell.isBiggerThanEnd) {
                            cell.onClick = function () { return _this.nextDecade(); };
                        }
                        else {
                            cell.onClick = function () { return _this.chooseYear(cell.year); };
                        }
                        index++;
                    };
                    var this_1 = this;
                    for (var colIndex = 0; colIndex < MAX_COL$2; colIndex++) {
                        _loop_1(colIndex);
                    }
                }
                return years;
            };
        YearPanelComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'year-panel',
                        template: "<div class=\"{{ prefixCls }}\">\n  <div>\n    <div class=\"{{ prefixCls }}-header\">\n      <a\n        class=\"{{ prefixCls }}-prev-decade-btn\"\n        role=\"button\"\n        (click)=\"previousDecade()\"\n        title=\"{{ locale.previousDecade }}\"\n      ></a>\n      <a\n        class=\"{{ prefixCls }}-decade-select\"\n        role=\"button\"\n        (click)=\"decadePanelShow.emit()\"\n        title=\"{{ locale.decadeSelect }}\"\n      >\n        <span class=\"{{ prefixCls }}-decade-select-content\">\n          {{ startYear }}-{{ endYear }}\n        </span>\n        <span class=\"{{ prefixCls }}-decade-select-arrow\">x</span>\n      </a>\n\n      <a class=\"{{ prefixCls }}-next-decade-btn\" (click)=\"nextDecade()\" title=\"{{ locale.nextDecade }}\" role=\"button\"></a>\n    </div>\n    <div class=\"{{ prefixCls }}-body\">\n      <table class=\"{{ prefixCls }}-table\" cellSpacing=\"0\" role=\"grid\">\n        <tbody class=\"{{ prefixCls }}-tbody\">\n          <tr *ngFor=\"let row of panelYears\" role=\"row\">\n            <td *ngFor=\"let yearCell of row; trackBy: trackPanelYear\"\n              role=\"gridcell\"\n              title=\"{{ yearCell.title }}\"\n              (click)=\"yearCell.onClick()\"\n              [ngClass]=\"yearCell.classMap\"\n            >\n              <a class=\"{{ prefixCls }}-year\">{{ yearCell.content }}</a>\n            </td>\n          </tr>\n        </tbody>\n      </table>\n    </div>\n  </div>\n</div>"
                    }] }
        ];
        /** @nocollapse */
        YearPanelComponent.ctorParameters = function () { return []; };
        YearPanelComponent.propDecorators = {
            locale: [{ type: i0.Input }],
            value: [{ type: i0.Input }],
            valueChange: [{ type: i0.Output }],
            decadePanelShow: [{ type: i0.Output }]
        };
        return YearPanelComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var LibPackerModule = /** @class */ (function () {
        function LibPackerModule() {
        }
        LibPackerModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [
                            i1.CommonModule,
                            forms.FormsModule,
                            NzI18nModule,
                            NzTimePickerModule
                        ],
                        exports: [
                            CalendarHeaderComponent,
                            CalendarInputComponent,
                            CalendarFooterComponent,
                            OkButtonComponent,
                            TimePickerButtonComponent,
                            TodayButtonComponent,
                            DateTableComponent,
                            YearPanelComponent,
                            MonthPanelComponent,
                            MonthTableComponent,
                            DecadePanelComponent,
                            InnerPopupComponent,
                            DateRangePopupComponent
                        ],
                        declarations: [
                            CalendarHeaderComponent,
                            CalendarInputComponent,
                            CalendarFooterComponent,
                            OkButtonComponent,
                            TimePickerButtonComponent,
                            TodayButtonComponent,
                            DateTableComponent,
                            YearPanelComponent,
                            MonthPanelComponent,
                            MonthTableComponent,
                            DecadePanelComponent,
                            InnerPopupComponent,
                            DateRangePopupComponent
                        ]
                    },] }
        ];
        return LibPackerModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzPickerComponent = /** @class */ (function () {
        function NzPickerComponent(i18n, changeDetector) {
            this.i18n = i18n;
            this.changeDetector = changeDetector;
            this.isRange = false;
            this.open = undefined;
            this.valueChange = new i0.EventEmitter();
            this.openChange = new i0.EventEmitter();
            this.prefixCls = 'ant-calendar';
            this.animationOpenState = false;
            this.overlayOpen = false;
            this.overlayOffsetY = 0;
            this.overlayOffsetX = -2;
            this.overlayPositions = /** @type {?} */ ([
                {
                    // offsetX: -10, // TODO: What a pity, cdk/overlay current not support offset configs even though it already provide these properties
                    // offsetY: -10,
                    originX: 'start',
                    originY: 'top',
                    overlayX: 'start',
                    overlayY: 'top'
                },
                {
                    originX: 'start',
                    originY: 'bottom',
                    overlayX: 'start',
                    overlayY: 'bottom'
                },
                {
                    originX: 'end',
                    originY: 'top',
                    overlayX: 'end',
                    overlayY: 'top'
                },
                {
                    originX: 'end',
                    originY: 'bottom',
                    overlayX: 'end',
                    overlayY: 'bottom'
                }
            ]);
            this.dropdownAnimation = 'bottom';
            this.currentPositionX = 'start';
            this.currentPositionY = 'top';
        }
        Object.defineProperty(NzPickerComponent.prototype, "realOpenState", {
            // get valueReadable(): string {
            //   return this.value && this.i18n.formatDateCompatible(this.value.nativeDate, this.format);
            // }
            get: /**
             * @return {?}
             */ function () {
                // The value that really decide the open state of overlay
                return this.isOpenHandledByUser() ? this.open : this.overlayOpen;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzPickerComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
            };
        /**
         * @return {?}
         */
        NzPickerComponent.prototype.ngAfterViewInit = /**
         * @return {?}
         */
            function () {
                if (this.autoFocus) {
                    if (this.isRange) {
                        /** @type {?} */
                        var firstInput = /** @type {?} */ (( /** @type {?} */(this.pickerInput.nativeElement)).querySelector('input:first-child'));
                        firstInput.focus(); // Focus on the first input
                    }
                    else {
                        this.pickerInput.nativeElement.focus();
                    }
                }
            };
        // Show overlay content
        /**
         * @return {?}
         */
        NzPickerComponent.prototype.showOverlay = /**
         * @return {?}
         */
            function () {
                var _this = this;
                if (!this.realOpenState) {
                    this.overlayOpen = true;
                    this.openChange.emit(this.overlayOpen);
                    setTimeout(function () {
                        if (_this.cdkConnectedOverlay && _this.cdkConnectedOverlay.overlayRef) {
                            _this.cdkConnectedOverlay.overlayRef.updatePosition();
                        }
                    });
                }
            };
        /**
         * @return {?}
         */
        NzPickerComponent.prototype.hideOverlay = /**
         * @return {?}
         */
            function () {
                if (this.realOpenState) {
                    this.overlayOpen = false;
                    this.openChange.emit(this.overlayOpen);
                }
            };
        /**
         * @return {?}
         */
        NzPickerComponent.prototype.onClickInputBox = /**
         * @return {?}
         */
            function () {
                if (!this.disabled && !this.isOpenHandledByUser()) {
                    this.showOverlay();
                }
            };
        /**
         * @return {?}
         */
        NzPickerComponent.prototype.onClickBackdrop = /**
         * @return {?}
         */
            function () {
                this.hideOverlay();
            };
        /**
         * @return {?}
         */
        NzPickerComponent.prototype.onOverlayDetach = /**
         * @return {?}
         */
            function () {
                this.hideOverlay();
            };
        // NOTE: A issue here, the first time position change, the animation will not be triggered.
        // Because the overlay's "positionChange" event is emitted after the content's full shown up.
        // All other components like "nz-dropdown" which depends on overlay also has the same issue.
        // See: https://github.com/NG-ZORRO/ng-zorro-antd/issues/1429
        /**
         * @param {?} position
         * @return {?}
         */
        NzPickerComponent.prototype.onPositionChange = /**
         * @param {?} position
         * @return {?}
         */
            function (position) {
                this.dropdownAnimation = position.connectionPair.originY === 'top' ? 'bottom' : 'top';
                this.currentPositionX = /** @type {?} */ (position.connectionPair.originX);
                this.currentPositionY = /** @type {?} */ (position.connectionPair.originY);
                this.changeDetector.detectChanges(); // Take side-effects to position styles
            };
        /**
         * @param {?} event
         * @return {?}
         */
        NzPickerComponent.prototype.onClickClear = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                event.preventDefault();
                event.stopPropagation();
                this.value = this.isRange ? [] : null;
                this.valueChange.emit(this.value);
            };
        /**
         * @param {?=} partType
         * @return {?}
         */
        NzPickerComponent.prototype.getReadableValue = /**
         * @param {?=} partType
         * @return {?}
         */
            function (partType) {
                /** @type {?} */
                var value;
                if (this.isRange) {
                    value = this.value[this.getPartTypeIndex(partType)];
                }
                else {
                    value = /** @type {?} */ (this.value);
                }
                return value ? this.i18n.formatDateCompatible(value.nativeDate, this.format) : null;
            };
        /**
         * @param {?} partType
         * @return {?}
         */
        NzPickerComponent.prototype.getPartTypeIndex = /**
         * @param {?} partType
         * @return {?}
         */
            function (partType) {
                return { 'left': 0, 'right': 1 }[partType];
            };
        /**
         * @param {?=} partType
         * @return {?}
         */
        NzPickerComponent.prototype.getPlaceholder = /**
         * @param {?=} partType
         * @return {?}
         */
            function (partType) {
                return this.isRange ? this.placeholder[this.getPartTypeIndex(partType)] : /** @type {?} */ (this.placeholder);
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzPickerComponent.prototype.isEmptyValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                if (this.isRange) {
                    return !value || !Array.isArray(value) || value.every(function (val) { return !val; });
                }
                else {
                    return !value;
                }
            };
        // Whether open state is permanently controlled by user himself
        /**
         * @return {?}
         */
        NzPickerComponent.prototype.isOpenHandledByUser = /**
         * @return {?}
         */
            function () {
                return this.open !== undefined;
            };
        /**
         * @return {?}
         */
        NzPickerComponent.prototype.animationStart = /**
         * @return {?}
         */
            function () {
                if (this.realOpenState) {
                    this.animationOpenState = true;
                }
            };
        /**
         * @return {?}
         */
        NzPickerComponent.prototype.animationDone = /**
         * @return {?}
         */
            function () {
                this.animationOpenState = this.realOpenState;
            };
        NzPickerComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-picker',
                        template: "<span cdkOverlayOrigin #origin=\"cdkOverlayOrigin\" class=\"{{ prefixCls }}-picker {{ size ? prefixCls + '-picker-' + size : '' }} {{ className }}\" [ngStyle]=\"style\" tabindex=\"0\">\n  <!-- Content of single picker -->\n  <ng-container *ngIf=\"!isRange\">\n    <input\n      #pickerInput\n      class=\"{{ prefixCls }}-picker-input ant-input\"\n      [class.ant-input-lg]=\"size === 'large'\"\n      [class.ant-input-sm]=\"size === 'small'\"\n      [class.ant-input-disabled]=\"disabled\"\n      (click)=\"onClickInputBox()\"\n\n      [disabled]=\"disabled\"\n      readonly\n      value=\"{{ getReadableValue() }}\"\n      placeholder=\"{{ getPlaceholder() }}\"\n    />\n    <ng-container *ngTemplateOutlet=\"tplRightRest\"></ng-container>\n  </ng-container>\n\n  <!-- Content of range picker -->\n  <ng-container *ngIf=\"isRange\">\n    <span\n      #pickerInput\n      class=\"{{ prefixCls }}-picker-input ant-input\"\n      [class.ant-input-lg]=\"size === 'large'\"\n      [class.ant-input-sm]=\"size === 'small'\"\n      [class.ant-input-disabled]=\"disabled\"\n      (click)=\"onClickInputBox()\"\n    >\n      <ng-container *ngTemplateOutlet=\"tplRangeInput; context: { partType: 'left' }\"></ng-container>\n      <span class=\"{{ prefixCls }}-range-picker-separator\"> ~ </span>\n      <ng-container *ngTemplateOutlet=\"tplRangeInput; context: { partType: 'right' }\"></ng-container>\n      <ng-container *ngTemplateOutlet=\"tplRightRest\"></ng-container>\n    </span>\n  </ng-container>\n</span>\n\n<!-- Input for Range ONLY -->\n<ng-template #tplRangeInput let-partType=\"partType\">\n  <input\n    class=\"{{ prefixCls }}-range-picker-input\"\n    [disabled]=\"disabled\"\n    readonly\n    value=\"{{ getReadableValue(partType) }}\"\n    placeholder=\"{{ getPlaceholder(partType) }}\"\n  />\n</ng-template>\n\n<!-- Right operator icons -->\n<ng-template #tplRightRest>\n  <i\n    *ngIf=\"!disabled && !isEmptyValue(value) && allowClear\"\n    class=\"anticon anticon-cross-circle {{ prefixCls }}-picker-clear\"\n    (click)=\"onClickClear($event)\"\n  ></i>\n  <span class=\"{{ prefixCls }}-picker-icon\"></span>\n</ng-template>\n\n<!-- Overlay -->\n<ng-template\n  cdkConnectedOverlay\n  [cdkConnectedOverlayOrigin]=\"origin\"\n  [cdkConnectedOverlayOpen]=\"realOpenState\"\n  [cdkConnectedOverlayHasBackdrop]=\"!isOpenHandledByUser()\"\n  [cdkConnectedOverlayPositions]=\"overlayPositions\"\n  (positionChange)=\"onPositionChange($event)\"\n  (backdropClick)=\"onClickBackdrop()\"\n  (detach)=\"onOverlayDetach()\"\n>\n  <div\n    [@dropDownAnimation]=\"dropdownAnimation\"\n    (@dropDownAnimation.start)=\"animationStart()\"\n    (@dropDownAnimation.done)=\"animationDone()\"\n    style=\"position: relative;\"\n    [style.left]=\"currentPositionX === 'start' ? '-2px' : '2px'\"\n    [style.top]=\"currentPositionY === 'top' ? '-2px' : '2px'\"\n  > <!-- Compatible for overlay that not support offset dynamically and immediately -->\n    <ng-content></ng-content>\n  </div>\n</ng-template>",
                        animations: [
                            dropDownAnimation
                        ],
                        changeDetection: i0.ChangeDetectionStrategy.OnPush
                    }] }
        ];
        /** @nocollapse */
        NzPickerComponent.ctorParameters = function () {
            return [
                { type: NzI18nService },
                { type: i0.ChangeDetectorRef }
            ];
        };
        NzPickerComponent.propDecorators = {
            isRange: [{ type: i0.Input }],
            open: [{ type: i0.Input }],
            disabled: [{ type: i0.Input }],
            placeholder: [{ type: i0.Input }],
            allowClear: [{ type: i0.Input }],
            autoFocus: [{ type: i0.Input }],
            className: [{ type: i0.Input }],
            format: [{ type: i0.Input }],
            size: [{ type: i0.Input }],
            style: [{ type: i0.Input }],
            value: [{ type: i0.Input }],
            valueChange: [{ type: i0.Output }],
            openChange: [{ type: i0.Output }],
            origin: [{ type: i0.ViewChild, args: ['origin',] }],
            cdkConnectedOverlay: [{ type: i0.ViewChild, args: [i2.CdkConnectedOverlay,] }],
            pickerInput: [{ type: i0.ViewChild, args: ['pickerInput',] }]
        };
        return NzPickerComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var POPUP_STYLE_PATCH = { 'position': 'relative' };
    /**
     * The base picker for all common APIs
     * @abstract
     */
    var AbstractPickerComponent = /** @class */ (function () {
        function AbstractPickerComponent(i18n) {
            this.i18n = i18n;
            // --- Common API
            this.nzAllowClear = true;
            this.nzAutoFocus = false;
            this.nzDisabled = false;
            this.nzPopupStyle = POPUP_STYLE_PATCH;
            this.nzOnOpenChange = new i0.EventEmitter();
            this.isRange = false;
            this.destroyed$ = new rxjs.Subject();
            this.isCustomPlaceHolder = false;
            // ------------------------------------------------------------------------
            // | Control value accessor implements
            // ------------------------------------------------------------------------
            // NOTE: onChangeFn/onTouchedFn will not be assigned if user not use as ngModel
            this.onChangeFn = function () { return void 0; };
            this.onTouchedFn = function () { return void 0; };
        }
        Object.defineProperty(AbstractPickerComponent.prototype, "realOpenState", {
            get: /**
             * @return {?}
             */ function () {
                return this.picker.animationOpenState;
            } // Use picker's real open state to let re-render the picker's content when shown up
            ,
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        AbstractPickerComponent.prototype.initValue = /**
         * @return {?}
         */
            function () {
                this.nzValue = this.isRange ? [] : null;
            };
        /**
         * @return {?}
         */
        AbstractPickerComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                // Subscribe the every locale change if the nzLocale is not handled by user
                if (!this.nzLocale) {
                    this.i18n.localeChange
                        .pipe(operators.takeUntil(this.destroyed$))
                        .subscribe(function () { return _this.setLocale(); });
                }
                // Default value
                this.initValue();
            };
        /**
         * @param {?} changes
         * @return {?}
         */
        AbstractPickerComponent.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                if (changes["nzPopupStyle"]) { // Always assign the popup style patch
                    // Always assign the popup style patch
                    this.nzPopupStyle = this.nzPopupStyle ? __assign({}, this.nzPopupStyle, POPUP_STYLE_PATCH) : POPUP_STYLE_PATCH;
                }
                // Mark as customized placeholder by user once nzPlaceHolder assigned at the first time
                if (changes["nzPlaceHolder"] && changes["nzPlaceHolder"].firstChange && typeof this.nzPlaceHolder !== 'undefined') {
                    this.isCustomPlaceHolder = true;
                }
                if (changes["nzLocale"]) { // The nzLocale is currently handled by user
                    // The nzLocale is currently handled by user
                    this.setDefaultPlaceHolder();
                }
            };
        /**
         * @return {?}
         */
        AbstractPickerComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.destroyed$.next();
                this.destroyed$.complete();
            };
        /**
         * @return {?}
         */
        AbstractPickerComponent.prototype.closeOverlay = /**
         * @return {?}
         */
            function () {
                this.picker.hideOverlay();
            };
        /**
         * Common handle for value changes
         * @param value changed value
         */
        /**
         * Common handle for value changes
         * @param {?} value changed value
         * @return {?}
         */
        AbstractPickerComponent.prototype.onValueChange = /**
         * Common handle for value changes
         * @param {?} value changed value
         * @return {?}
         */
            function (value) {
                this.nzValue = value;
                if (this.isRange) {
                    if (( /** @type {?} */(this.nzValue)).length) {
                        this.onChangeFn([this.nzValue[0].nativeDate, this.nzValue[1].nativeDate]);
                    }
                    else {
                        this.onChangeFn([]);
                    }
                }
                else {
                    if (this.nzValue) {
                        this.onChangeFn(( /** @type {?} */(this.nzValue)).nativeDate);
                    }
                    else {
                        this.onChangeFn(null);
                    }
                }
                this.onTouchedFn();
            };
        /**
         * Triggered when overlayOpen changes (different with realOpenState)
         * @param open The overlayOpen in picker component
         */
        /**
         * Triggered when overlayOpen changes (different with realOpenState)
         * @param {?} open The overlayOpen in picker component
         * @return {?}
         */
        AbstractPickerComponent.prototype.onOpenChange = /**
         * Triggered when overlayOpen changes (different with realOpenState)
         * @param {?} open The overlayOpen in picker component
         * @return {?}
         */
            function (open) {
                this.nzOnOpenChange.emit(open);
            };
        /**
         * @param {?} value
         * @return {?}
         */
        AbstractPickerComponent.prototype.writeValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.setValue(value);
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        AbstractPickerComponent.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                // tslint:disable-line:no-any
                this.onChangeFn = fn;
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        AbstractPickerComponent.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                // tslint:disable-line:no-any
                this.onTouchedFn = fn;
            };
        /**
         * @param {?} disabled
         * @return {?}
         */
        AbstractPickerComponent.prototype.setDisabledState = /**
         * @param {?} disabled
         * @return {?}
         */
            function (disabled) {
                this.nzDisabled = disabled;
            };
        /**
         * @return {?}
         */
        AbstractPickerComponent.prototype.setLocale = /**
         * @return {?}
         */
            function () {
                this.nzLocale = this.i18n.getLocaleData('DatePicker', {});
                this.setDefaultPlaceHolder();
            };
        /**
         * @return {?}
         */
        AbstractPickerComponent.prototype.setDefaultPlaceHolder = /**
         * @return {?}
         */
            function () {
                if (!this.isCustomPlaceHolder && this.nzLocale) {
                    this.nzPlaceHolder = this.isRange ? this.nzLocale.lang.rangePlaceholder : this.nzLocale.lang.placeholder;
                }
            };
        /**
         * @param {?} date
         * @return {?}
         */
        AbstractPickerComponent.prototype.formatDate = /**
         * @param {?} date
         * @return {?}
         */
            function (date) {
                return date ? this.i18n.formatDateCompatible(date.nativeDate, this.nzFormat) : '';
            };
        /**
         * @param {?} value
         * @return {?}
         */
        AbstractPickerComponent.prototype.setValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                if (this.isRange) {
                    this.nzValue = value ? ( /** @type {?} */(value)).map(function (val) { return new CandyDate(val); }) : [];
                }
                else {
                    this.nzValue = value ? new CandyDate(/** @type {?} */ (value)) : null;
                }
            };
        AbstractPickerComponent.propDecorators = {
            nzAllowClear: [{ type: i0.Input }],
            nzAutoFocus: [{ type: i0.Input }],
            nzDisabled: [{ type: i0.Input }],
            nzOpen: [{ type: i0.Input }],
            nzClassName: [{ type: i0.Input }],
            nzDisabledDate: [{ type: i0.Input }],
            nzLocale: [{ type: i0.Input }],
            nzPlaceHolder: [{ type: i0.Input }],
            nzPopupStyle: [{ type: i0.Input }],
            nzDropdownClassName: [{ type: i0.Input }],
            nzSize: [{ type: i0.Input }],
            nzStyle: [{ type: i0.Input }],
            nzOnOpenChange: [{ type: i0.Output }],
            nzFormat: [{ type: i0.Input }],
            nzValue: [{ type: i0.Input }],
            picker: [{ type: i0.ViewChild, args: [NzPickerComponent,] }]
        };
        __decorate([
            InputBoolean(),
            __metadata("design:type", Boolean)
        ], AbstractPickerComponent.prototype, "nzAllowClear", void 0);
        __decorate([
            InputBoolean(),
            __metadata("design:type", Boolean)
        ], AbstractPickerComponent.prototype, "nzAutoFocus", void 0);
        __decorate([
            InputBoolean(),
            __metadata("design:type", Boolean)
        ], AbstractPickerComponent.prototype, "nzDisabled", void 0);
        __decorate([
            InputBoolean(),
            __metadata("design:type", Boolean)
        ], AbstractPickerComponent.prototype, "nzOpen", void 0);
        return AbstractPickerComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var DateRangePickerComponent = /** @class */ (function (_super) {
        __extends(DateRangePickerComponent, _super);
        function DateRangePickerComponent(i18n, logger) {
            var _this = _super.call(this, i18n) || this;
            _this.logger = logger;
            _this.showWeek = false;
            _this.nzShowToday = true;
            _this.nzOnPanelChange = new i0.EventEmitter();
            _this.nzOnOk = new i0.EventEmitter();
            return _this;
        }
        Object.defineProperty(DateRangePickerComponent.prototype, "nzShowTime", {
            get: /**
             * @return {?}
             */ function () { return this._showTime; },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._showTime = typeof value === 'object' ? value : toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(DateRangePickerComponent.prototype, "realShowToday", {
            get: /**
             * @return {?}
             */ function () {
                // Range not support nzShowToday currently
                return !this.isRange && this.nzShowToday;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        DateRangePickerComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                _super.prototype.ngOnInit.call(this);
                // Default format when it's empty
                if (!this.nzFormat) {
                    if (this.showWeek) {
                        this.nzFormat = 'yyyy-ww'; // Format for week
                    }
                    else {
                        this.nzFormat = this.nzShowTime ? 'yyyy-MM-dd HH:mm:ss' : 'yyyy-MM-dd';
                    }
                }
            };
        /**
         * @param {?} changes
         * @return {?}
         */
        DateRangePickerComponent.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                _super.prototype.ngOnChanges.call(this, changes);
                if (changes["nzRenderExtraFooter"]) {
                    this.extraFooter = valueFunctionProp(this.nzRenderExtraFooter);
                }
            };
        // If has no timepicker and the user select a date by date panel, then close picker
        /**
         * @param {?} value
         * @return {?}
         */
        DateRangePickerComponent.prototype.onValueChange = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                _super.prototype.onValueChange.call(this, value);
                if (!this.nzShowTime) {
                    this.closeOverlay();
                }
            };
        // Emitted when done with date selecting
        /**
         * @return {?}
         */
        DateRangePickerComponent.prototype.onResultOk = /**
         * @return {?}
         */
            function () {
                if (this.isRange) {
                    if (( /** @type {?} */(this.nzValue)).length) {
                        this.nzOnOk.emit([this.nzValue[0].nativeDate, this.nzValue[1].nativeDate]);
                    }
                    else {
                        this.nzOnOk.emit([]);
                    }
                }
                else {
                    if (this.nzValue) {
                        this.nzOnOk.emit(( /** @type {?} */(this.nzValue)).nativeDate);
                    }
                    else {
                        this.nzOnOk.emit(null);
                    }
                }
                this.closeOverlay();
            };
        /**
         * @param {?} open
         * @return {?}
         */
        DateRangePickerComponent.prototype.onOpenChange = /**
         * @param {?} open
         * @return {?}
         */
            function (open) {
                this.nzOnOpenChange.emit(open);
            };
        DateRangePickerComponent.decorators = [
            { type: i0.Component, args: [{
                        template: "" // Just for rollup
                        // Just for rollup
                    }] }
        ];
        /** @nocollapse */
        DateRangePickerComponent.ctorParameters = function () {
            return [
                { type: NzI18nService },
                { type: LoggerService }
            ];
        };
        DateRangePickerComponent.propDecorators = {
            nzDateRender: [{ type: i0.Input }],
            nzDisabledTime: [{ type: i0.Input }],
            nzRenderExtraFooter: [{ type: i0.Input }],
            nzShowToday: [{ type: i0.Input }],
            nzMode: [{ type: i0.Input }],
            nzRanges: [{ type: i0.Input }],
            nzOnPanelChange: [{ type: i0.Output }],
            nzShowTime: [{ type: i0.Input }],
            nzOnOk: [{ type: i0.Output }]
        };
        __decorate([
            InputBoolean(),
            __metadata("design:type", Boolean)
        ], DateRangePickerComponent.prototype, "nzShowToday", void 0);
        return DateRangePickerComponent;
    }(AbstractPickerComponent));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzDatePickerComponent = /** @class */ (function (_super) {
        __extends(NzDatePickerComponent, _super);
        function NzDatePickerComponent() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.isRange = false;
            return _this;
        }
        NzDatePickerComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-date-picker',
                        template: "<nz-picker\n  [isRange]=\"isRange\"\n  [value]=\"nzValue\"\n  (valueChange)=\"onValueChange($event)\"\n  [open]=\"nzOpen\"\n  [disabled]=\"nzDisabled\"\n  [format]=\"nzFormat\"\n  [allowClear]=\"nzAllowClear\"\n  [autoFocus]=\"nzAutoFocus\"\n  [className]=\"nzClassName\"\n  [placeholder]=\"nzPlaceHolder\"\n  [size]=\"nzSize\"\n  [style]=\"nzStyle\"\n  (openChange)=\"onOpenChange($event)\"\n>\n  <date-range-popup *ngIf=\"realOpenState\"\n    [isRange]=\"isRange\"\n    [showWeek]=\"showWeek\"\n    [panelMode]=\"nzMode\"\n    (panelModeChange)=\"nzOnPanelChange.emit($event)\"\n    [value]=\"nzValue\"\n    (valueChange)=\"onValueChange($event)\"\n    [locale]=\"nzLocale?.lang\"\n    [showToday]=\"realShowToday\"\n    [showTime]=\"nzShowTime\"\n    [format]=\"nzFormat\"\n    [dateRender]=\"nzDateRender\"\n    [disabledDate]=\"nzDisabledDate\"\n    [disabledTime]=\"nzDisabledTime\"\n    [placeholder]=\"nzPlaceHolder\"\n    [dropdownClassName]=\"nzDropdownClassName\"\n    [popupStyle]=\"nzPopupStyle\"\n    [extraFooter]=\"extraFooter\"\n    [ranges]=\"nzRanges\"\n    (resultOk)=\"onResultOk()\"\n    (closePicker)=\"closeOverlay()\"\n  ></date-range-popup>\n</nz-picker>",
                        providers: [{
                                provide: forms.NG_VALUE_ACCESSOR,
                                multi: true,
                                useExisting: i0.forwardRef(function () { return NzDatePickerComponent; })
                            }],
                        host: {
                            '[class.ant-calendar-picker]': 'true'
                        }
                    }] }
        ];
        return NzDatePickerComponent;
    }(DateRangePickerComponent));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * The base picker for header panels, current support: Year/Month
     */
    var HeaderPickerComponent = /** @class */ (function (_super) {
        __extends(HeaderPickerComponent, _super);
        function HeaderPickerComponent(i18n) {
            return _super.call(this, i18n) || this;
        }
        /**
         * @return {?}
         */
        HeaderPickerComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                _super.prototype.ngOnInit.call(this);
                this.panelMode = this.endPanelMode;
                /** @type {?} */
                var allHeaderPanels = ['decade', 'year', 'month'];
                this.supportPanels = allHeaderPanels.slice(0, allHeaderPanels.indexOf(this.endPanelMode) + 1);
            };
        /**
         * @param {?} changes
         * @return {?}
         */
        HeaderPickerComponent.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                _super.prototype.ngOnChanges.call(this, changes);
                if (changes["nzRenderExtraFooter"]) {
                    this.extraFooter = valueFunctionProp(this.nzRenderExtraFooter);
                }
            };
        /**
         * @param {?} mode
         * @return {?}
         */
        HeaderPickerComponent.prototype.onPanelModeChange = /**
         * @param {?} mode
         * @return {?}
         */
            function (mode) {
                if (this.supportPanels.indexOf(mode) > -1) {
                    this.panelMode = mode;
                }
                else { // Since the default "click year" logic can be "year panel" -> "date panel", we need force to the end panel otherwise
                    // Since the default "click year" logic can be "year panel" -> "date panel", we need force to the end panel otherwise
                    this.panelMode = this.endPanelMode;
                }
            };
        /**
         * @param {?} mode
         * @param {?} value
         * @return {?}
         */
        HeaderPickerComponent.prototype.onChooseValue = /**
         * @param {?} mode
         * @param {?} value
         * @return {?}
         */
            function (mode, value) {
                if (this.endPanelMode === mode) {
                    _super.prototype.onValueChange.call(this, value);
                    this.closeOverlay();
                }
            };
        /**
         * @param {?} open
         * @return {?}
         */
        HeaderPickerComponent.prototype.onOpenChange = /**
         * @param {?} open
         * @return {?}
         */
            function (open) {
                if (!open) {
                    this.cleanUp();
                }
                this.nzOnOpenChange.emit(open);
            };
        /**
         * @return {?}
         */
        HeaderPickerComponent.prototype.cleanUp = /**
         * @return {?}
         */
            function () {
                this.panelMode = this.endPanelMode;
            };
        HeaderPickerComponent.decorators = [
            { type: i0.Component, args: [{
                        template: ""
                    }] }
        ];
        /** @nocollapse */
        HeaderPickerComponent.ctorParameters = function () {
            return [
                { type: NzI18nService }
            ];
        };
        HeaderPickerComponent.propDecorators = {
            nzPlaceHolder: [{ type: i0.Input }],
            nzRenderExtraFooter: [{ type: i0.Input }],
            nzDefaultValue: [{ type: i0.Input }],
            nzFormat: [{ type: i0.Input }]
        };
        return HeaderPickerComponent;
    }(AbstractPickerComponent));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzMonthPickerComponent = /** @class */ (function (_super) {
        __extends(NzMonthPickerComponent, _super);
        function NzMonthPickerComponent() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.nzFormat = 'yyyy-MM';
            _this.endPanelMode = 'month';
            return _this;
        }
        NzMonthPickerComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-month-picker',
                        template: "<nz-picker\n  [isRange]=\"false\"\n  [value]=\"nzValue\"\n  (valueChange)=\"onValueChange($event)\"\n  [open]=\"nzOpen\"\n  [disabled]=\"nzDisabled\"\n  [format]=\"nzFormat\"\n  [allowClear]=\"nzAllowClear\"\n  [autoFocus]=\"nzAutoFocus\"\n  [className]=\"nzClassName\"\n  [placeholder]=\"nzPlaceHolder\"\n  [size]=\"nzSize\"\n  [style]=\"nzStyle\"\n  (openChange)=\"onOpenChange($event)\"\n>\n  <div *ngIf=\"realOpenState\">\n    <div class=\"ant-calendar-picker-container {{ nzDropdownClassName }} ant-calendar-picker-container-placement-bottomLeft\" [ngStyle]=\"nzPopupStyle\">\n      <div class=\"ant-calendar ant-calendar-month ant-calendar-month-calendar\" tabindex=\"0\">\n        <div class=\"ant-calendar-month-calendar-content\">\n          <div class=\"ant-calendar-month-header-wrap\">\n            <calendar-header\n              [disabledMonth]=\"nzDisabledDate\"\n              [panelMode]=\"panelMode\"\n              (panelModeChange)=\"onPanelModeChange($event)\"\n              [value]=\"nzValue\"\n              (chooseYear)=\"onChooseValue('year', $event)\"\n              (chooseMonth)=\"onChooseValue('month', $event)\"\n              [locale]=\"nzLocale.lang\"\n              [enablePrev]=\"true\"\n              [enableNext]=\"true\"\n            ></calendar-header>\n          </div>\n          <calendar-footer *ngIf=\"extraFooter\" [extraFooter]=\"extraFooter\"></calendar-footer>\n        </div>\n      </div>\n    </div>\n  </div>\n</nz-picker>",
                        providers: [{
                                provide: forms.NG_VALUE_ACCESSOR,
                                multi: true,
                                useExisting: i0.forwardRef(function () { return NzMonthPickerComponent; })
                            }],
                        host: {
                            '[class.ant-calendar-picker]': 'true'
                        }
                    }] }
        ];
        NzMonthPickerComponent.propDecorators = {
            nzFormat: [{ type: i0.Input }]
        };
        return NzMonthPickerComponent;
    }(HeaderPickerComponent));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzRangePickerComponent = /** @class */ (function (_super) {
        __extends(NzRangePickerComponent, _super);
        function NzRangePickerComponent() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.isRange = true;
            return _this;
        }
        NzRangePickerComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-range-picker',
                        template: "<nz-picker\n  [isRange]=\"isRange\"\n  [value]=\"nzValue\"\n  (valueChange)=\"onValueChange($event)\"\n  [open]=\"nzOpen\"\n  [disabled]=\"nzDisabled\"\n  [format]=\"nzFormat\"\n  [allowClear]=\"nzAllowClear\"\n  [autoFocus]=\"nzAutoFocus\"\n  [className]=\"nzClassName\"\n  [placeholder]=\"nzPlaceHolder\"\n  [size]=\"nzSize\"\n  [style]=\"nzStyle\"\n  (openChange)=\"onOpenChange($event)\"\n>\n  <date-range-popup *ngIf=\"realOpenState\"\n    [isRange]=\"isRange\"\n    [showWeek]=\"showWeek\"\n    [panelMode]=\"nzMode\"\n    (panelModeChange)=\"nzOnPanelChange.emit($event)\"\n    [value]=\"nzValue\"\n    (valueChange)=\"onValueChange($event)\"\n    [locale]=\"nzLocale?.lang\"\n    [showToday]=\"realShowToday\"\n    [showTime]=\"nzShowTime\"\n    [format]=\"nzFormat\"\n    [dateRender]=\"nzDateRender\"\n    [disabledDate]=\"nzDisabledDate\"\n    [disabledTime]=\"nzDisabledTime\"\n    [placeholder]=\"nzPlaceHolder\"\n    [dropdownClassName]=\"nzDropdownClassName\"\n    [popupStyle]=\"nzPopupStyle\"\n    [extraFooter]=\"extraFooter\"\n    [ranges]=\"nzRanges\"\n    (resultOk)=\"onResultOk()\"\n    (closePicker)=\"closeOverlay()\"\n  ></date-range-popup>\n</nz-picker>",
                        providers: [{
                                provide: forms.NG_VALUE_ACCESSOR,
                                multi: true,
                                useExisting: i0.forwardRef(function () { return NzRangePickerComponent; })
                            }],
                        host: {
                            '[class.ant-calendar-picker]': 'true'
                        }
                    }] }
        ];
        return NzRangePickerComponent;
    }(DateRangePickerComponent));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzWeekPickerComponent = /** @class */ (function (_super) {
        __extends(NzWeekPickerComponent, _super);
        function NzWeekPickerComponent() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.showWeek = true;
            return _this;
        }
        NzWeekPickerComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-week-picker',
                        template: "<nz-picker\n  [isRange]=\"isRange\"\n  [value]=\"nzValue\"\n  (valueChange)=\"onValueChange($event)\"\n  [open]=\"nzOpen\"\n  [disabled]=\"nzDisabled\"\n  [format]=\"nzFormat\"\n  [allowClear]=\"nzAllowClear\"\n  [autoFocus]=\"nzAutoFocus\"\n  [className]=\"nzClassName\"\n  [placeholder]=\"nzPlaceHolder\"\n  [size]=\"nzSize\"\n  [style]=\"nzStyle\"\n  (openChange)=\"onOpenChange($event)\"\n>\n  <date-range-popup *ngIf=\"realOpenState\"\n    [isRange]=\"isRange\"\n    [showWeek]=\"showWeek\"\n    [panelMode]=\"nzMode\"\n    (panelModeChange)=\"nzOnPanelChange.emit($event)\"\n    [value]=\"nzValue\"\n    (valueChange)=\"onValueChange($event)\"\n    [locale]=\"nzLocale?.lang\"\n    [showToday]=\"realShowToday\"\n    [showTime]=\"nzShowTime\"\n    [format]=\"nzFormat\"\n    [dateRender]=\"nzDateRender\"\n    [disabledDate]=\"nzDisabledDate\"\n    [disabledTime]=\"nzDisabledTime\"\n    [placeholder]=\"nzPlaceHolder\"\n    [dropdownClassName]=\"nzDropdownClassName\"\n    [popupStyle]=\"nzPopupStyle\"\n    [extraFooter]=\"extraFooter\"\n    [ranges]=\"nzRanges\"\n    (resultOk)=\"onResultOk()\"\n    (closePicker)=\"closeOverlay()\"\n  ></date-range-popup>\n</nz-picker>",
                        providers: [{
                                provide: forms.NG_VALUE_ACCESSOR,
                                multi: true,
                                useExisting: i0.forwardRef(function () { return NzWeekPickerComponent; })
                            }],
                        host: {
                            '[class.ant-calendar-picker]': 'true'
                        }
                    }] }
        ];
        return NzWeekPickerComponent;
    }(DateRangePickerComponent));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzYearPickerComponent = /** @class */ (function (_super) {
        __extends(NzYearPickerComponent, _super);
        function NzYearPickerComponent() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.nzFormat = 'yyyy';
            _this.endPanelMode = 'year';
            return _this;
        }
        NzYearPickerComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-year-picker',
                        template: "<nz-picker\n  [isRange]=\"false\"\n  [value]=\"nzValue\"\n  (valueChange)=\"onValueChange($event)\"\n  [open]=\"nzOpen\"\n  [disabled]=\"nzDisabled\"\n  [format]=\"nzFormat\"\n  [allowClear]=\"nzAllowClear\"\n  [autoFocus]=\"nzAutoFocus\"\n  [className]=\"nzClassName\"\n  [placeholder]=\"nzPlaceHolder\"\n  [size]=\"nzSize\"\n  [style]=\"nzStyle\"\n  (openChange)=\"onOpenChange($event)\"\n>\n  <div *ngIf=\"realOpenState\">\n    <div class=\"ant-calendar-picker-container {{ nzDropdownClassName }} ant-calendar-picker-container-placement-bottomLeft\" [ngStyle]=\"nzPopupStyle\">\n      <div class=\"ant-calendar ant-calendar-month ant-calendar-month-calendar\" tabindex=\"0\">\n        <div class=\"ant-calendar-month-calendar-content\">\n          <div class=\"ant-calendar-month-header-wrap\">\n            <calendar-header\n              [disabledMonth]=\"nzDisabledDate\"\n              [panelMode]=\"panelMode\"\n              (panelModeChange)=\"onPanelModeChange($event)\"\n              [value]=\"nzValue\"\n              (chooseYear)=\"onChooseValue('year', $event)\"\n              (chooseMonth)=\"onChooseValue('month', $event)\"\n              [locale]=\"nzLocale.lang\"\n              [enablePrev]=\"true\"\n              [enableNext]=\"true\"\n            ></calendar-header>\n          </div>\n          <calendar-footer *ngIf=\"extraFooter\" [extraFooter]=\"extraFooter\"></calendar-footer>\n        </div>\n      </div>\n    </div>\n  </div>\n</nz-picker>",
                        providers: [{
                                provide: forms.NG_VALUE_ACCESSOR,
                                multi: true,
                                useExisting: i0.forwardRef(function () { return NzYearPickerComponent; })
                            }],
                        host: {
                            '[class.ant-calendar-picker]': 'true'
                        }
                    }] }
        ];
        NzYearPickerComponent.propDecorators = {
            nzFormat: [{ type: i0.Input }]
        };
        return NzYearPickerComponent;
    }(HeaderPickerComponent));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzDatePickerModule = /** @class */ (function () {
        function NzDatePickerModule() {
        }
        NzDatePickerModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [
                            i1.CommonModule,
                            i2.OverlayModule,
                            LibPackerModule
                        ],
                        exports: [
                            NzDatePickerComponent,
                            NzRangePickerComponent,
                            NzMonthPickerComponent,
                            NzYearPickerComponent,
                            NzWeekPickerComponent
                        ],
                        declarations: [
                            HeaderPickerComponent,
                            DateRangePickerComponent,
                            NzPickerComponent,
                            NzDatePickerComponent,
                            NzMonthPickerComponent,
                            NzYearPickerComponent,
                            NzWeekPickerComponent,
                            NzRangePickerComponent
                        ],
                        providers: []
                    },] }
        ];
        return NzDatePickerModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzDividerComponent = /** @class */ (function () {
        function NzDividerComponent(el, cd, updateHostClassService) {
            this.el = el;
            this.cd = cd;
            this.updateHostClassService = updateHostClassService;
            // region fields
            this.isText = false;
            this.textStr = '';
            this.nzType = 'horizontal';
            this.nzOrientation = '';
            this._dashed = false;
        }
        Object.defineProperty(NzDividerComponent.prototype, "nzText", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value instanceof i0.TemplateRef) {
                    this.textStr = null;
                    this.textTpl = value;
                }
                else {
                    this.textStr = value;
                }
                this.isText = !!value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzDividerComponent.prototype, "nzDashed", {
            get: /**
             * @return {?}
             */ function () {
                return this._dashed;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._dashed = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzDividerComponent.prototype.setClass = /**
         * @return {?}
         */
            function () {
                var _a;
                /** @type {?} */
                var orientationPrefix = (this.nzOrientation.length > 0) ? '-' + this.nzOrientation : this.nzOrientation;
                /** @type {?} */
                var classMap = (_a = {},
                    _a['ant-divider'] = true,
                    _a["ant-divider-" + this.nzType] = true,
                    _a["ant-divider-with-text" + orientationPrefix] = this.isText,
                    _a["ant-divider-dashed"] = this.nzDashed,
                    _a);
                this.updateHostClassService.updateHostClass(this.el.nativeElement, classMap);
                this.cd.detectChanges();
            };
        /**
         * @param {?} changes
         * @return {?}
         */
        NzDividerComponent.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                this.setClass();
            };
        /**
         * @return {?}
         */
        NzDividerComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.setClass();
            };
        NzDividerComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-divider',
                        template: "<span *ngIf=\"isText\" class=\"ant-divider-inner-text\">\n  <ng-container *ngIf=\"textStr; else textTpl\">{{ textStr }}</ng-container>\n</span>",
                        providers: [NzUpdateHostClassService],
                        preserveWhitespaces: false,
                        changeDetection: i0.ChangeDetectionStrategy.OnPush
                    }] }
        ];
        /** @nocollapse */
        NzDividerComponent.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: i0.ChangeDetectorRef },
                { type: NzUpdateHostClassService }
            ];
        };
        NzDividerComponent.propDecorators = {
            nzText: [{ type: i0.Input }],
            nzType: [{ type: i0.Input }],
            nzOrientation: [{ type: i0.Input }],
            nzDashed: [{ type: i0.Input }]
        };
        return NzDividerComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzDividerModule = /** @class */ (function () {
        function NzDividerModule() {
        }
        NzDividerModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [i1.CommonModule],
                        declarations: [NzDividerComponent],
                        exports: [NzDividerComponent]
                    },] }
        ];
        return NzDividerModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzMeasureScrollbarService = /** @class */ (function () {
        // tslint:disable-next-line:no-any
        function NzMeasureScrollbarService(document) {
            this.document = document;
            this.scrollbarMeasure = {
                position: 'absolute',
                top: '-9999px',
                width: '50px',
                height: '50px',
                overflow: 'scroll'
            };
            this.initScrollBarWidth();
        }
        Object.defineProperty(NzMeasureScrollbarService.prototype, "scrollBarWidth", {
            get: /**
             * @return {?}
             */ function () {
                if (isNotNil(this._scrollbarWidth)) {
                    return this._scrollbarWidth;
                }
                this.initScrollBarWidth();
                return this._scrollbarWidth;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzMeasureScrollbarService.prototype.initScrollBarWidth = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var scrollDiv = this.document.createElement('div');
                for (var scrollProp in this.scrollbarMeasure) {
                    if (this.scrollbarMeasure.hasOwnProperty(scrollProp)) {
                        scrollDiv.style[scrollProp] = this.scrollbarMeasure[scrollProp];
                    }
                }
                this.document.body.appendChild(scrollDiv);
                /** @type {?} */
                var width = scrollDiv.offsetWidth - scrollDiv.clientWidth;
                this.document.body.removeChild(scrollDiv);
                this._scrollbarWidth = width;
            };
        NzMeasureScrollbarService.decorators = [
            { type: i0.Injectable, args: [{
                        providedIn: 'root'
                    },] }
        ];
        /** @nocollapse */
        NzMeasureScrollbarService.ctorParameters = function () {
            return [
                { type: undefined, decorators: [{ type: i0.Inject, args: [i1.DOCUMENT,] }] }
            ];
        };
        /** @nocollapse */ NzMeasureScrollbarService.ngInjectableDef = i0.defineInjectable({ factory: function NzMeasureScrollbarService_Factory() { return new NzMeasureScrollbarService(i0.inject(i1.DOCUMENT)); }, token: NzMeasureScrollbarService, providedIn: "root" });
        return NzMeasureScrollbarService;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzBlockScrollStrategy = /** @class */ (function () {
        function NzBlockScrollStrategy(document, renderer, nzMeasureScrollbarService) {
            this.document = document;
            this.renderer = renderer;
            this.nzMeasureScrollbarService = nzMeasureScrollbarService;
        }
        /**
         * @return {?}
         */
        NzBlockScrollStrategy.prototype.attach = /**
         * @return {?}
         */
            function () { };
        /**
         * @return {?}
         */
        NzBlockScrollStrategy.prototype.enable = /**
         * @return {?}
         */
            function () {
                this.renderer.setStyle(document.body, 'overflow', 'hidden');
                this.renderer.setStyle(this.document.body, 'padding-right', this.nzMeasureScrollbarService.scrollBarWidth + "px");
            };
        /**
         * @return {?}
         */
        NzBlockScrollStrategy.prototype.disable = /**
         * @return {?}
         */
            function () {
                this.renderer.removeStyle(document.body, 'overflow');
                this.renderer.removeStyle(document.body, 'padding-right');
            };
        return NzBlockScrollStrategy;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzScrollStrategyOptions = /** @class */ (function () {
        function NzScrollStrategyOptions(rendererFactory, nzMeasureScrollbarService, 
        // tslint:disable-next-line:no-any
        document) {
            var _this = this;
            this.nzMeasureScrollbarService = nzMeasureScrollbarService;
            this.block = function () { return new NzBlockScrollStrategy(_this.document, _this.renderer, _this.nzMeasureScrollbarService); };
            this.document = document;
            this.renderer = rendererFactory.createRenderer(null, null);
        }
        NzScrollStrategyOptions.decorators = [
            { type: i0.Injectable, args: [{ providedIn: 'root' },] }
        ];
        /** @nocollapse */
        NzScrollStrategyOptions.ctorParameters = function () {
            return [
                { type: i0.RendererFactory2 },
                { type: NzMeasureScrollbarService },
                { type: undefined, decorators: [{ type: i0.Inject, args: [i1.DOCUMENT,] }] }
            ];
        };
        /** @nocollapse */ NzScrollStrategyOptions.ngInjectableDef = i0.defineInjectable({ factory: function NzScrollStrategyOptions_Factory() { return new NzScrollStrategyOptions(i0.inject(i0.RendererFactory2), i0.inject(NzMeasureScrollbarService), i0.inject(i1.DOCUMENT)); }, token: NzScrollStrategyOptions, providedIn: "root" });
        return NzScrollStrategyOptions;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * @abstract
     * @template R
     */
    var /**
     * @abstract
     * @template R
     */ NzDrawerRef = /** @class */ (function () {
        function NzDrawerRef() {
        }
        return NzDrawerRef;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var DRAWER_ANIMATE_DURATION = 300;
    /**
     * @template T, R, D
     */
    var NzDrawerComponent = /** @class */ (function (_super) {
        __extends(NzDrawerComponent, _super);
        function NzDrawerComponent(
        // tslint:disable-next-line:no-any
        document, renderer, overlay, elementRef, injector, changeDetectorRef, focusTrapFactory, nzScrollStrategyOptions, viewContainerRef) {
            var _this = _super.call(this) || this;
            _this.document = document;
            _this.renderer = renderer;
            _this.overlay = overlay;
            _this.elementRef = elementRef;
            _this.injector = injector;
            _this.changeDetectorRef = changeDetectorRef;
            _this.focusTrapFactory = focusTrapFactory;
            _this.nzScrollStrategyOptions = nzScrollStrategyOptions;
            _this.viewContainerRef = viewContainerRef;
            _this.isOpen = false;
            _this.templateContext = {
                $implicit: undefined,
                drawerRef: /** @type {?} */ (_this)
            };
            _this.nzClosable = true;
            _this.nzMaskClosable = true;
            _this.nzMask = true;
            _this.nzPlacement = 'right';
            _this.nzMaskStyle = {};
            _this.nzBodyStyle = {};
            _this.nzWidth = 256;
            _this.nzHeight = 256;
            _this.nzZIndex = 1000;
            _this.nzOffsetX = 0;
            _this.nzOffsetY = 0;
            _this.nzOnViewInit = new i0.EventEmitter();
            _this.nzOnClose = new i0.EventEmitter();
            _this.nzAfterOpen = new rxjs.Subject();
            _this.nzAfterClose = new rxjs.Subject();
            return _this;
        }
        Object.defineProperty(NzDrawerComponent.prototype, "transform", {
            get: /**
             * @return {?}
             */ function () {
                switch (this.nzPlacement) {
                    case 'left':
                        return this.isOpen ? "translateX(" + this.nzOffsetX + "px)" : "translateX(-" + this.width + ")";
                    case 'right':
                        return this.isOpen ? "translateX(-" + this.nzOffsetX + "px)" : "translateX(" + this.width + ")";
                    case 'top':
                        return this.isOpen ? "translateY(" + this.nzOffsetY + "px)" : "translateY(-" + this.height + ")";
                    case 'bottom':
                        return this.isOpen ? "translateY(-" + this.nzOffsetY + "px)" : "translateY(" + this.height + ")";
                    default:
                        return '';
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzDrawerComponent.prototype, "width", {
            get: /**
             * @return {?}
             */ function () {
                return this.isLeftOrRight ? toCssPixel(this.nzWidth) : null;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzDrawerComponent.prototype, "height", {
            get: /**
             * @return {?}
             */ function () {
                return !this.isLeftOrRight ? toCssPixel(this.nzHeight) : null;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzDrawerComponent.prototype, "isLeftOrRight", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzPlacement === 'left' || this.nzPlacement === 'right';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzDrawerComponent.prototype, "nzVisible", {
            get: /**
             * @return {?}
             */ function () {
                return this.isOpen;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.isOpen = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzDrawerComponent.prototype, "afterOpen", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzAfterOpen.asObservable();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzDrawerComponent.prototype, "afterClose", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzAfterClose.asObservable();
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} value
         * @return {?}
         */
        NzDrawerComponent.prototype.isNonEmptyString = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                return typeof value === 'string' && value !== '';
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzDrawerComponent.prototype.isTemplateRef = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                return value instanceof i0.TemplateRef;
            };
        /**
         * @return {?}
         */
        NzDrawerComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.attachOverlay();
                this.updateOverlayStyle();
                this.updateBodyOverflow();
                this.templateContext = { $implicit: this.nzContentParams, drawerRef: /** @type {?} */ (this) };
                this.changeDetectorRef.detectChanges();
            };
        /**
         * @return {?}
         */
        NzDrawerComponent.prototype.ngAfterViewInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.attachBodyContent();
                setTimeout(function () {
                    _this.nzOnViewInit.emit();
                });
            };
        /**
         * @param {?} changes
         * @return {?}
         */
        NzDrawerComponent.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                var _this = this;
                if (changes.hasOwnProperty('nzVisible')) {
                    /** @type {?} */
                    var value = changes["nzVisible"].currentValue;
                    this.updateOverlayStyle();
                    if (value) {
                        this.updateBodyOverflow();
                        this.savePreviouslyFocusedElement();
                        this.trapFocus();
                    }
                    else {
                        setTimeout(function () {
                            _this.updateBodyOverflow();
                            _this.restoreFocus();
                        }, DRAWER_ANIMATE_DURATION);
                    }
                }
            };
        /**
         * @return {?}
         */
        NzDrawerComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.disposeOverlay();
            };
        /**
         * @param {?=} result
         * @return {?}
         */
        NzDrawerComponent.prototype.close = /**
         * @param {?=} result
         * @return {?}
         */
            function (result) {
                var _this = this;
                this.isOpen = false;
                this.updateOverlayStyle();
                this.changeDetectorRef.detectChanges();
                setTimeout(function () {
                    _this.updateBodyOverflow();
                    _this.restoreFocus();
                    _this.nzAfterClose.next(result);
                    _this.nzAfterClose.complete();
                }, DRAWER_ANIMATE_DURATION);
            };
        /**
         * @return {?}
         */
        NzDrawerComponent.prototype.open = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.isOpen = true;
                this.updateOverlayStyle();
                this.updateBodyOverflow();
                this.savePreviouslyFocusedElement();
                this.trapFocus();
                this.changeDetectorRef.detectChanges();
                setTimeout(function () {
                    _this.nzAfterOpen.next();
                }, DRAWER_ANIMATE_DURATION);
            };
        /**
         * @return {?}
         */
        NzDrawerComponent.prototype.closeClick = /**
         * @return {?}
         */
            function () {
                this.nzOnClose.emit();
            };
        /**
         * @return {?}
         */
        NzDrawerComponent.prototype.maskClick = /**
         * @return {?}
         */
            function () {
                if (this.nzMaskClosable && this.nzMask) {
                    this.nzOnClose.emit();
                }
            };
        /**
         * @return {?}
         */
        NzDrawerComponent.prototype.attachBodyContent = /**
         * @return {?}
         */
            function () {
                this.bodyPortalOutlet.dispose();
                if (this.nzContent instanceof i0.Type) {
                    /** @type {?} */
                    var childInjector = new portal.PortalInjector(this.injector, new WeakMap([[NzDrawerRef, this]]));
                    /** @type {?} */
                    var componentPortal = new portal.ComponentPortal(this.nzContent, null, childInjector);
                    /** @type {?} */
                    var componentRef = this.bodyPortalOutlet.attachComponentPortal(componentPortal);
                    if (this.nzContentParams) {
                        Object.assign(componentRef.instance, this.nzContentParams);
                    }
                    componentRef.changeDetectorRef.detectChanges();
                }
            };
        /**
         * @return {?}
         */
        NzDrawerComponent.prototype.attachOverlay = /**
         * @return {?}
         */
            function () {
                if (!this.overlayRef) {
                    this.portal = new portal.TemplatePortal(this.drawerTemplate, this.viewContainerRef);
                    this.overlayRef = this.overlay.create(this.getOverlayConfig());
                }
                if (this.overlayRef && !this.overlayRef.hasAttached()) {
                    this.overlayRef.attach(this.portal);
                }
            };
        /**
         * @return {?}
         */
        NzDrawerComponent.prototype.disposeOverlay = /**
         * @return {?}
         */
            function () {
                this.overlayRef.dispose();
                this.overlayRef = null;
            };
        /**
         * @return {?}
         */
        NzDrawerComponent.prototype.getOverlayConfig = /**
         * @return {?}
         */
            function () {
                return new i2.OverlayConfig({
                    scrollStrategy: this.nzScrollStrategyOptions.block()
                });
            };
        /**
         * @return {?}
         */
        NzDrawerComponent.prototype.updateOverlayStyle = /**
         * @return {?}
         */
            function () {
                if (this.overlayRef && this.overlayRef.overlayElement) {
                    this.renderer.setStyle(this.overlayRef.overlayElement, 'pointer-events', this.isOpen ? 'auto' : 'none');
                }
            };
        /**
         * @return {?}
         */
        NzDrawerComponent.prototype.updateBodyOverflow = /**
         * @return {?}
         */
            function () {
                if (this.overlayRef) {
                    if (this.isOpen) {
                        this.overlayRef.getConfig().scrollStrategy.enable();
                    }
                    else {
                        this.overlayRef.getConfig().scrollStrategy.disable();
                    }
                }
            };
        /**
         * @return {?}
         */
        NzDrawerComponent.prototype.savePreviouslyFocusedElement = /**
         * @return {?}
         */
            function () {
                if (this.document) {
                    this.previouslyFocusedElement = /** @type {?} */ (this.document.activeElement);
                    this.previouslyFocusedElement.blur();
                }
            };
        /**
         * @return {?}
         */
        NzDrawerComponent.prototype.trapFocus = /**
         * @return {?}
         */
            function () {
                if (!this.focusTrap) {
                    this.focusTrap = this.focusTrapFactory.create(this.overlayRef.overlayElement);
                }
                this.focusTrap.focusInitialElementWhenReady();
            };
        /**
         * @return {?}
         */
        NzDrawerComponent.prototype.restoreFocus = /**
         * @return {?}
         */
            function () {
                if (this.previouslyFocusedElement) {
                    this.previouslyFocusedElement.focus();
                }
                if (this.focusTrap) {
                    this.focusTrap.destroy();
                }
            };
        NzDrawerComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-drawer',
                        template: "<ng-template #drawerTemplate>\n  <div\n    class=\"ant-drawer\"\n    [class.ant-drawer-open]=\"isOpen\"\n    [class.ant-drawer-top]=\"nzPlacement === 'top'\"\n    [class.ant-drawer-bottom]=\"nzPlacement === 'bottom'\"\n    [class.ant-drawer-right]=\"nzPlacement === 'right'\"\n    [class.ant-drawer-left]=\"nzPlacement === 'left'\">\n    <div  class=\"ant-drawer-mask\" (click)=\"maskClick()\" *ngIf=\"nzMask\" [style.zIndex]=\"nzZIndex\" [ngStyle]=\"nzMaskStyle\"></div>\n    <div class=\"ant-drawer-content-wrapper {{ nzWrapClassName }}\"\n         [style.zIndex]=\"nzZIndex\"\n         [style.width]=\"width\"\n         [style.height]=\"height\"\n         [style.transform]=\"transform\">\n      <div class=\"ant-drawer-content\">\n        <div class=\"ant-drawer-wrapper-body\"\n          [style.overflow]=\"isLeftOrRight ? 'auto' : null\"\n          [style.height]=\"isLeftOrRight ? '100%' : null\">\n          <div *ngIf=\"nzTitle\" class=\"ant-drawer-header\">\n            <div class=\"ant-drawer-title\">\n              <ng-container [ngSwitch]=\"true\">\n                <ng-container *ngSwitchCase=\"isTemplateRef(nzTitle)\" [ngTemplateOutlet]=\"nzTitle\"></ng-container>\n                <ng-container *ngSwitchCase=\"isNonEmptyString(nzTitle)\"><div [innerHTML]=\"nzTitle\"></div></ng-container>\n              </ng-container>\n            </div>\n          </div>\n          <button *ngIf=\"nzClosable\" (click)=\"closeClick()\" aria-label=\"Close\" class=\"ant-drawer-close\"><span class=\"ant-drawer-close-x\"></span></button>\n          <div class=\"ant-drawer-body\" [ngStyle]=\"nzBodyStyle\">\n            <ng-template cdkPortalOutlet></ng-template>\n            <ng-container *ngIf=\"isTemplateRef(nzContent)\">\n              <ng-container *ngTemplateOutlet=\"nzContent; context: templateContext\"></ng-container>\n            </ng-container>\n            <ng-content *ngIf=\"!nzContent\"></ng-content>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n</ng-template>",
                        preserveWhitespaces: false,
                        changeDetection: i0.ChangeDetectionStrategy.OnPush
                    }] }
        ];
        /** @nocollapse */
        NzDrawerComponent.ctorParameters = function () {
            return [
                { type: undefined, decorators: [{ type: i0.Optional }, { type: i0.Inject, args: [i1.DOCUMENT,] }] },
                { type: i0.Renderer2 },
                { type: i2.Overlay },
                { type: i0.ElementRef },
                { type: i0.Injector },
                { type: i0.ChangeDetectorRef },
                { type: a11y.FocusTrapFactory },
                { type: NzScrollStrategyOptions },
                { type: i0.ViewContainerRef }
            ];
        };
        NzDrawerComponent.propDecorators = {
            drawerTemplate: [{ type: i0.ViewChild, args: ['drawerTemplate',] }],
            contentTemplate: [{ type: i0.ViewChild, args: ['contentTemplate',] }],
            bodyPortalOutlet: [{ type: i0.ViewChild, args: [portal.CdkPortalOutlet,] }],
            nzContent: [{ type: i0.Input }],
            nzClosable: [{ type: i0.Input }],
            nzMaskClosable: [{ type: i0.Input }],
            nzMask: [{ type: i0.Input }],
            nzTitle: [{ type: i0.Input }],
            nzPlacement: [{ type: i0.Input }],
            nzMaskStyle: [{ type: i0.Input }],
            nzBodyStyle: [{ type: i0.Input }],
            nzWrapClassName: [{ type: i0.Input }],
            nzWidth: [{ type: i0.Input }],
            nzHeight: [{ type: i0.Input }],
            nzZIndex: [{ type: i0.Input }],
            nzOffsetX: [{ type: i0.Input }],
            nzOffsetY: [{ type: i0.Input }],
            nzVisible: [{ type: i0.Input }],
            nzOnViewInit: [{ type: i0.Output }],
            nzOnClose: [{ type: i0.Output }]
        };
        __decorate([
            InputBoolean(),
            __metadata("design:type", Object)
        ], NzDrawerComponent.prototype, "nzClosable", void 0);
        __decorate([
            InputBoolean(),
            __metadata("design:type", Object)
        ], NzDrawerComponent.prototype, "nzMaskClosable", void 0);
        __decorate([
            InputBoolean(),
            __metadata("design:type", Object)
        ], NzDrawerComponent.prototype, "nzMask", void 0);
        return NzDrawerComponent;
    }(NzDrawerRef));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * @template R
     */
    var /**
     * @template R
     */ DrawerBuilderForService$$1 = /** @class */ (function () {
        function DrawerBuilderForService$$1(overlay, options) {
            var _this = this;
            this.overlay = overlay;
            this.options = options;
            this.unsubscribe$ = new rxjs.Subject();
            this.createDrawer();
            this.updateOptions(options);
            this.drawerRef.instance.nzOnViewInit
                .pipe(operators.takeUntil(this.unsubscribe$))
                .subscribe(function () {
                _this.drawerRef.instance.open();
            });
            this.drawerRef.instance.nzOnClose
                .subscribe(function () {
                _this.drawerRef.instance.close();
            });
            this.drawerRef.instance.afterClose
                .pipe(operators.takeUntil(this.unsubscribe$))
                .subscribe(function () {
                _this.overlayRef.dispose();
                _this.drawerRef = null;
                _this.unsubscribe$.next();
                _this.unsubscribe$.complete();
            });
        }
        /**
         * @return {?}
         */
        DrawerBuilderForService$$1.prototype.getInstance = /**
         * @return {?}
         */
            function () {
                return this.drawerRef && this.drawerRef.instance;
            };
        /**
         * @return {?}
         */
        DrawerBuilderForService$$1.prototype.createDrawer = /**
         * @return {?}
         */
            function () {
                this.overlayRef = this.overlay.create();
                this.drawerRef = this.overlayRef.attach(new portal.ComponentPortal(NzDrawerComponent));
            };
        /**
         * @param {?} options
         * @return {?}
         */
        DrawerBuilderForService$$1.prototype.updateOptions = /**
         * @param {?} options
         * @return {?}
         */
            function (options) {
                Object.assign(this.drawerRef.instance, options);
            };
        return DrawerBuilderForService$$1;
    }());
    var NzDrawerService$$1 = /** @class */ (function () {
        function NzDrawerService$$1(overlay) {
            this.overlay = overlay;
        }
        // tslint:disable-next-line:no-any
        /**
         * @template T, D, R
         * @param {?} options
         * @return {?}
         */
        NzDrawerService$$1.prototype.create = /**
         * @template T, D, R
         * @param {?} options
         * @return {?}
         */
            function (options) {
                return new DrawerBuilderForService$$1(this.overlay, options).getInstance();
            };
        NzDrawerService$$1.decorators = [
            { type: i0.Injectable, args: [{ providedIn: 'root' },] }
        ];
        /** @nocollapse */
        NzDrawerService$$1.ctorParameters = function () {
            return [
                { type: i2.Overlay }
            ];
        };
        /** @nocollapse */ NzDrawerService$$1.ngInjectableDef = i0.defineInjectable({ factory: function NzDrawerService_Factory() { return new NzDrawerService$$1(i0.inject(i2.Overlay)); }, token: NzDrawerService$$1, providedIn: "root" });
        return NzDrawerService$$1;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzDrawerModule = /** @class */ (function () {
        function NzDrawerModule() {
        }
        NzDrawerModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [i1.CommonModule, i2.OverlayModule, portal.PortalModule],
                        exports: [NzDrawerComponent],
                        declarations: [NzDrawerComponent],
                        entryComponents: [NzDrawerComponent],
                        providers: [NzDrawerService$$1]
                    },] }
        ];
        return NzDrawerModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzMenuDividerDirective = /** @class */ (function () {
        function NzMenuDividerDirective() {
        }
        NzMenuDividerDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: '[nz-menu-divider]',
                        host: {
                            '[class.ant-dropdown-menu-item-divider]': 'true'
                        }
                    },] }
        ];
        return NzMenuDividerDirective;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzMenuGroupComponent = /** @class */ (function () {
        function NzMenuGroupComponent() {
        }
        NzMenuGroupComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: '[nz-menu-group]',
                        preserveWhitespaces: false,
                        template: "<div class=\"ant-menu-item-group-title\">\n  <ng-content select=\"[title]\"></ng-content>\n</div>\n<ul class=\"ant-menu-item-group-list\">\n  <ng-content></ng-content>\n</ul>",
                        host: {
                            '[class.ant-menu-item-group]': 'true'
                        }
                    }] }
        ];
        return NzMenuGroupComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzMenuDirective = /** @class */ (function () {
        function NzMenuDirective(el) {
            this.el = el;
            this._selectable = true;
            this._inlineCollapsed = false;
            this._inDropDown = false;
            /**
             * view init flat
             */
            this.isInit = false;
            /**
             * opened index of array
             */
            this.subMenusOpenIndex = [];
            /**
             * collection of menu item
             */
            this.menuItems = [];
            /**
             * collection of sub menu
             */
            this.subMenus = [];
            this.nzTheme = 'light';
            this.nzInlineIndent = 24;
            this.nzMode = 'vertical';
            this.nzClick = new i0.EventEmitter();
        }
        Object.defineProperty(NzMenuDirective.prototype, "nzInDropDown", {
            get: /**
             * @return {?}
             */ function () {
                return this._inDropDown;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                var _this = this;
                this._inDropDown = toBoolean(value);
                this.nzSelectable = !this._inDropDown;
                this.menuItems.forEach(function (menu) { return menu.isInDropDown = _this._inDropDown; });
                this.subMenus.forEach(function (subMenu) { return subMenu.isInDropDown = _this._inDropDown; });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzMenuDirective.prototype, "nzSelectable", {
            get: /**
             * @return {?}
             */ function () {
                return this._selectable;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._selectable = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzMenuDirective.prototype, "nzInlineCollapsed", {
            get: /**
             * @return {?}
             */ function () {
                return this._inlineCollapsed;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._inlineCollapsed = toBoolean(value);
                if (this.isInit) {
                    this.updateInlineCollapse();
                }
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzMenuDirective.prototype.updateInlineCollapse = /**
         * @return {?}
         */
            function () {
                if (this._inlineCollapsed) {
                    this.hideSubMenus();
                    this.nzMode = 'vertical';
                }
                else {
                    this.reductionSubMenus();
                    this.nzMode = this.cacheMode;
                }
            };
        Object.defineProperty(NzMenuDirective.prototype, "isInDropDownClass", {
            /** define host class */
            get: /**
             * define host class
             * @return {?}
             */ function () {
                return this.nzInDropDown;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzMenuDirective.prototype, "isNotInDropDownClass", {
            get: /**
             * @return {?}
             */ function () {
                return !this.nzInDropDown;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzMenuDirective.prototype, "setDropDownThemeLightClass", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzInDropDown && (this.nzTheme === 'light');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzMenuDirective.prototype, "setDropDownThemeDarkClass", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzInDropDown && (this.nzTheme === 'dark');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzMenuDirective.prototype, "setMenuThemeLightClass", {
            get: /**
             * @return {?}
             */ function () {
                return (!this.nzInDropDown) && (this.nzTheme === 'light');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzMenuDirective.prototype, "setMenuThemeDarkClass", {
            get: /**
             * @return {?}
             */ function () {
                return (!this.nzInDropDown) && (this.nzTheme === 'dark');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzMenuDirective.prototype, "setMenuVerticalClass", {
            get: /**
             * @return {?}
             */ function () {
                return (!this.nzInDropDown) && (this.nzMode === 'vertical');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzMenuDirective.prototype, "setMenuHorizontalClass", {
            get: /**
             * @return {?}
             */ function () {
                return (!this.nzInDropDown) && (this.nzMode === 'horizontal');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzMenuDirective.prototype, "setMenuInlineClass", {
            get: /**
             * @return {?}
             */ function () {
                return (!this.nzInDropDown) && (this.nzMode === 'inline');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzMenuDirective.prototype, "setMenuInlineCollapsedClass", {
            get: /**
             * @return {?}
             */ function () {
                return (!this.nzInDropDown) && (this.nzMode !== 'horizontal') && this.nzInlineCollapsed;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzMenuDirective.prototype.ngAfterContentInit = /**
         * @return {?}
         */
            function () {
                this.isInit = true;
                this.cacheMode = this.nzMode;
                this.updateInlineCollapse();
            };
        /** trigger when menu item clicked */
        /**
         * trigger when menu item clicked
         * @return {?}
         */
        NzMenuDirective.prototype.clearAllSelected = /**
         * trigger when menu item clicked
         * @return {?}
         */
            function () {
                this.menuItems.forEach(function (menu) { return menu.nzSelected = false; });
            };
        /**
         * @return {?}
         */
        NzMenuDirective.prototype.hideSubMenus = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.subMenusOpenIndex = [];
                this.subMenus.forEach(function (submenu, index) {
                    if (submenu.nzOpen) {
                        _this.subMenusOpenIndex.push(index);
                    }
                    submenu.nzOpen = false;
                });
            };
        /**
         * @return {?}
         */
        NzMenuDirective.prototype.reductionSubMenus = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.subMenusOpenIndex.forEach(function (i) { return _this.subMenus[i].nzOpen = true; });
                this.subMenusOpenIndex = [];
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzMenuDirective.prototype.clickItem = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.nzClick.emit(value);
            };
        NzMenuDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: '[nz-menu]'
                    },] }
        ];
        /** @nocollapse */
        NzMenuDirective.ctorParameters = function () {
            return [
                { type: i0.ElementRef }
            ];
        };
        NzMenuDirective.propDecorators = {
            nzTheme: [{ type: i0.Input }],
            nzInlineIndent: [{ type: i0.Input }],
            nzMode: [{ type: i0.Input }],
            nzClick: [{ type: i0.Output }],
            nzInDropDown: [{ type: i0.Input }],
            nzSelectable: [{ type: i0.Input }],
            nzInlineCollapsed: [{ type: i0.Input }],
            isInDropDownClass: [{ type: i0.HostBinding, args: ['class.ant-dropdown-menu',] }, { type: i0.HostBinding, args: ['class.ant-menu-dropdown-vertical',] }, { type: i0.HostBinding, args: ['class.ant-dropdown-menu-root',] }],
            isNotInDropDownClass: [{ type: i0.HostBinding, args: ['class.ant-menu',] }, { type: i0.HostBinding, args: ['class.ant-menu-root',] }],
            setDropDownThemeLightClass: [{ type: i0.HostBinding, args: ['class.ant-dropdown-menu-light',] }],
            setDropDownThemeDarkClass: [{ type: i0.HostBinding, args: ['class.ant-dropdown-menu-dark',] }],
            setMenuThemeLightClass: [{ type: i0.HostBinding, args: ['class.ant-menu-light',] }],
            setMenuThemeDarkClass: [{ type: i0.HostBinding, args: ['class.ant-menu-dark',] }],
            setMenuVerticalClass: [{ type: i0.HostBinding, args: ['class.ant-menu-vertical',] }],
            setMenuHorizontalClass: [{ type: i0.HostBinding, args: ['class.ant-menu-horizontal',] }],
            setMenuInlineClass: [{ type: i0.HostBinding, args: ['class.ant-menu-inline',] }],
            setMenuInlineCollapsedClass: [{ type: i0.HostBinding, args: ['class.ant-menu-inline-collapsed',] }]
        };
        return NzMenuDirective;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzDropDownDirective = /** @class */ (function () {
        function NzDropDownDirective(elementRef, renderer) {
            this.elementRef = elementRef;
            this.renderer = renderer;
            this.$mouseenter = new rxjs.Subject();
            this.$mouseleave = new rxjs.Subject();
            this.$click = new rxjs.Subject();
        }
        /**
         * @param {?} e
         * @return {?}
         */
        NzDropDownDirective.prototype.onMouseEnter = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                this.$mouseenter.next(e);
            };
        /**
         * @param {?} e
         * @return {?}
         */
        NzDropDownDirective.prototype.onMouseLeave = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                this.$mouseleave.next(e);
            };
        /**
         * @param {?} e
         * @return {?}
         */
        NzDropDownDirective.prototype.onClick = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                this.$click.next(e);
            };
        /**
         * @return {?}
         */
        NzDropDownDirective.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                if (this.elementRef.nativeElement.nodeName === 'A') {
                    this.renderer.addClass(this.elementRef.nativeElement, 'ant-dropdown-link');
                }
            };
        NzDropDownDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: '[nz-dropdown]',
                        host: {
                            '[class.ant-dropdown-trigger]': 'true'
                        }
                    },] }
        ];
        /** @nocollapse */
        NzDropDownDirective.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: i0.Renderer2 }
            ];
        };
        NzDropDownDirective.propDecorators = {
            onMouseEnter: [{ type: i0.HostListener, args: ['mouseenter', ['$event'],] }],
            onMouseLeave: [{ type: i0.HostListener, args: ['mouseleave', ['$event'],] }],
            onClick: [{ type: i0.HostListener, args: ['click', ['$event'],] }]
        };
        return NzDropDownDirective;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzDropDownComponent = /** @class */ (function () {
        function NzDropDownComponent(renderer, changeDetector) {
            var _this = this;
            this.renderer = renderer;
            this.changeDetector = changeDetector;
            this._clickHide = true;
            this._visible = false;
            this._disabled = false;
            this.unsubscribe$ = new rxjs.Subject();
            this.hasFilterButton = false;
            this.triggerWidth = 0;
            this.placement = 'bottomLeft';
            this.dropDownPosition = 'bottom';
            this.positions = __spread(DEFAULT_DROPDOWN_POSITIONS);
            this.$subOpen = new rxjs.BehaviorSubject(false);
            this.$visibleChange = new rxjs.Subject();
            this.nzTrigger = 'hover';
            this.nzVisibleChange = new i0.EventEmitter();
            this.onVisibleChange = function (visible) {
                if (visible) {
                    _this.setTriggerWidth();
                }
                if (_this.nzVisible !== visible) {
                    _this.nzVisible = visible;
                    _this.nzVisibleChange.emit(_this.nzVisible);
                }
                _this.changeDetector.markForCheck();
            };
        }
        Object.defineProperty(NzDropDownComponent.prototype, "nzClickHide", {
            get: /**
             * @return {?}
             */ function () {
                return this._clickHide;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._clickHide = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzDropDownComponent.prototype, "nzDisabled", {
            get: /**
             * @return {?}
             */ function () {
                return this._disabled;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._disabled = toBoolean(value);
                if (this._disabled) {
                    this.renderer.setAttribute(this.nzOrigin.elementRef.nativeElement, 'disabled', '');
                }
                else {
                    this.renderer.removeAttribute(this.nzOrigin.elementRef.nativeElement, 'disabled');
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzDropDownComponent.prototype, "nzVisible", {
            get: /**
             * @return {?}
             */ function () {
                return this._visible;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._visible = toBoolean(value);
                /** handle nzVisible change with mouse event **/
                this.$visibleChange.next(this._visible);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzDropDownComponent.prototype, "nzPlacement", {
            get: /**
             * @return {?}
             */ function () {
                return this.placement;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.placement = value;
                this.dropDownPosition = (this.nzPlacement.indexOf('top') !== -1) ? 'top' : 'bottom';
                this.positions.unshift(/** @type {?} */ (POSITION_MAP[this.placement]));
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzDropDownComponent.prototype.onClickEvent = /**
         * @return {?}
         */
            function () {
                if (this.nzTrigger === 'click') {
                    this.show();
                }
            };
        /**
         * @return {?}
         */
        NzDropDownComponent.prototype.onMouseEnterEvent = /**
         * @return {?}
         */
            function () {
                if (this.nzTrigger === 'hover') {
                    this.show();
                }
            };
        /**
         * @return {?}
         */
        NzDropDownComponent.prototype.onMouseLeaveEvent = /**
         * @return {?}
         */
            function () {
                if (this.nzTrigger === 'hover') {
                    this.hide();
                }
            };
        /**
         * @return {?}
         */
        NzDropDownComponent.prototype.hide = /**
         * @return {?}
         */
            function () {
                this.$visibleChange.next(false);
            };
        /**
         * @return {?}
         */
        NzDropDownComponent.prototype.show = /**
         * @return {?}
         */
            function () {
                this.$visibleChange.next(true);
            };
        /**
         * @param {?} position
         * @return {?}
         */
        NzDropDownComponent.prototype.onPositionChange = /**
         * @param {?} position
         * @return {?}
         */
            function (position) {
                this.dropDownPosition = position.connectionPair.originY;
            };
        /**
         * @return {?}
         */
        NzDropDownComponent.prototype.setTriggerWidth = /**
         * @return {?}
         */
            function () {
                this.triggerWidth = this.nzOrigin.elementRef.nativeElement.getBoundingClientRect().width;
                /** should remove after https://github.com/angular/material2/pull/8765 merged **/
                if (this.cdkOverlay && this.cdkOverlay.overlayRef) {
                    this.cdkOverlay.overlayRef.updateSize({
                        minWidth: this.triggerWidth
                    });
                }
            };
        /**
         * @param {?} observable$
         * @return {?}
         */
        NzDropDownComponent.prototype.startSubscribe = /**
         * @param {?} observable$
         * @return {?}
         */
            function (observable$) {
                /** @type {?} */
                var $pre = observable$;
                if (this.nzClickHide && this.nzMenu) {
                    /** @type {?} */
                    var $menuItemClick = this.nzMenu.nzClick.asObservable().pipe(operators.mapTo(false));
                    $pre = rxjs.merge($pre, $menuItemClick);
                }
                /** @type {?} */
                var final$ = rxjs.combineLatest($pre, this.$subOpen).pipe(operators.map(function (value) { return value[0] || value[1]; }), operators.debounceTime(50), operators.distinctUntilChanged());
                final$.pipe(operators.takeUntil(this.unsubscribe$)).subscribe(this.onVisibleChange);
            };
        /**
         * @return {?}
         */
        NzDropDownComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                if (this.nzMenu) {
                    this.nzMenu.nzInDropDown = true;
                }
            };
        /**
         * @return {?}
         */
        NzDropDownComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.unsubscribe$.next();
                this.unsubscribe$.complete();
            };
        /**
         * @return {?}
         */
        NzDropDownComponent.prototype.ngAfterViewInit = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var mouse$;
                if (this.nzTrigger === 'hover') {
                    /** @type {?} */
                    var mouseEnterOrigin$ = this.nzOrigin.$mouseenter.pipe(operators.mapTo(true));
                    /** @type {?} */
                    var mouseLeaveOrigin$ = this.nzOrigin.$mouseleave.pipe(operators.mapTo(false));
                    mouse$ = rxjs.merge(mouseLeaveOrigin$, mouseEnterOrigin$);
                }
                if (this.nzTrigger === 'click') {
                    mouse$ = this.nzOrigin.$click.pipe(operators.mapTo(true));
                }
                /** @type {?} */
                var observable$ = rxjs.merge(this.$visibleChange, mouse$);
                this.startSubscribe(observable$);
            };
        Object.defineProperty(NzDropDownComponent.prototype, "hasBackdrop", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzTrigger === 'click';
            },
            enumerable: true,
            configurable: true
        });
        NzDropDownComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-dropdown',
                        preserveWhitespaces: false,
                        animations: [
                            dropDownAnimation
                        ],
                        template: "<div>\n  <ng-content select=\"[nz-dropdown]\"></ng-content>\n</div>\n<ng-template\n  cdkConnectedOverlay\n  [cdkConnectedOverlayHasBackdrop]=\"hasBackdrop\"\n  [cdkConnectedOverlayPositions]=\"positions\"\n  [cdkConnectedOverlayOrigin]=\"nzOrigin\"\n  (backdropClick)=\"hide()\"\n  (detach)=\"hide()\"\n  [cdkConnectedOverlayMinWidth]=\"triggerWidth\"\n  (positionChange)=\"onPositionChange($event)\"\n  [cdkConnectedOverlayOpen]=\"nzVisible\">\n  <div\n    class=\"{{'ant-dropdown ant-dropdown-placement-'+nzPlacement}}\"\n    [@dropDownAnimation]=\"dropDownPosition\"\n    (mouseenter)=\"onMouseEnterEvent()\"\n    (mouseleave)=\"onMouseLeaveEvent()\"\n    [style.minWidth.px]=\"triggerWidth\">\n    <div [class.ant-table-filter-dropdown]=\"hasFilterButton\">\n      <ng-content select=\"[nz-menu]\"></ng-content>\n      <ng-content select=\".ant-table-filter-dropdown-btns\"></ng-content>\n    </div>\n    <ng-content></ng-content>\n  </div>\n</ng-template>",
                        styles: ["\n      :host {\n        position: relative;\n        display: inline-block;\n      }\n\n      .ant-dropdown {\n        top: 100%;\n        left: 0;\n        position: relative;\n        width: 100%;\n        margin-top: 4px;\n        margin-bottom: 4px;\n      }\n    "]
                    }] }
        ];
        /** @nocollapse */
        NzDropDownComponent.ctorParameters = function () {
            return [
                { type: i0.Renderer2 },
                { type: i0.ChangeDetectorRef }
            ];
        };
        NzDropDownComponent.propDecorators = {
            hasFilterButton: [{ type: i0.Input }],
            nzOrigin: [{ type: i0.ContentChild, args: [NzDropDownDirective,] }],
            nzMenu: [{ type: i0.ContentChild, args: [NzMenuDirective,] }],
            nzTrigger: [{ type: i0.Input }],
            nzVisibleChange: [{ type: i0.Output }],
            cdkOverlay: [{ type: i0.ViewChild, args: [i2.CdkConnectedOverlay,] }],
            nzClickHide: [{ type: i0.Input }],
            nzDisabled: [{ type: i0.Input }],
            nzVisible: [{ type: i0.Input }],
            nzPlacement: [{ type: i0.Input }]
        };
        return NzDropDownComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzDropDownButtonComponent = /** @class */ (function (_super) {
        __extends(NzDropDownButtonComponent, _super);
        function NzDropDownButtonComponent() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this.nzSize = 'default';
            _this.nzType = 'default';
            _this.nzClick = new i0.EventEmitter();
            _this.onVisibleChange = function (visible) {
                if (_this.nzDisabled) {
                    return;
                }
                if (visible) {
                    _this.setTriggerWidth();
                }
                if (_this.nzVisible !== visible) {
                    _this.nzVisible = visible;
                    _this.nzVisibleChange.emit(_this.nzVisible);
                }
                _this.changeDetector.markForCheck();
            };
            return _this;
        }
        /** rewrite afterViewInit hook */
        /**
         * rewrite afterViewInit hook
         * @return {?}
         */
        NzDropDownButtonComponent.prototype.ngAfterViewInit = /**
         * rewrite afterViewInit hook
         * @return {?}
         */
            function () {
                this.startSubscribe(this.$visibleChange);
            };
        NzDropDownButtonComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-dropdown-button',
                        preserveWhitespaces: false,
                        animations: [
                            dropDownAnimation
                        ],
                        template: "<div class=\"ant-btn-group ant-dropdown-button\" nz-dropdown>\n  <button\n    type=\"button\"\n    nz-button\n    [disabled]=\"nzDisabled\"\n    [nzType]=\"nzType\"\n    [nzSize]=\"nzSize\"\n    (click)=\"nzClick.emit($event)\">\n    <span><ng-content></ng-content></span>\n  </button>\n  <button\n    nz-button\n    type=\"button\"\n    class=\"ant-dropdown-trigger\"\n    [nzType]=\"nzType\"\n    [nzSize]=\"nzSize\"\n    [disabled]=\"nzDisabled\"\n    (click)=\"onClickEvent()\"\n    (mouseenter)=\"onMouseEnterEvent()\"\n    (mouseleave)=\"onMouseLeaveEvent()\">\n    <i class=\"anticon anticon-ellipsis\"></i>\n  </button>\n</div>\n<ng-template\n  cdkConnectedOverlay\n  [cdkConnectedOverlayHasBackdrop]=\"hasBackdrop\"\n  [cdkConnectedOverlayPositions]=\"positions\"\n  [cdkConnectedOverlayOrigin]=\"nzOrigin\"\n  (backdropClick)=\"hide()\"\n  (detach)=\"hide()\"\n  [cdkConnectedOverlayMinWidth]=\"triggerWidth\"\n  (positionChange)=\"onPositionChange($event)\"\n  [cdkConnectedOverlayOpen]=\"nzVisible\">\n  <div\n    class=\"{{'ant-dropdown ant-dropdown-placement-'+nzPlacement}}\"\n    [@dropDownAnimation]=\"dropDownPosition\"\n    (mouseenter)=\"onMouseEnterEvent()\"\n    (mouseleave)=\"onMouseLeaveEvent()\"\n    [style.minWidth.px]=\"triggerWidth\">\n    <ng-content select=\"[nz-menu]\"></ng-content>\n  </div>\n</ng-template>",
                        styles: ["\n    :host {\n      position: relative;\n      display: inline-block;\n    }\n\n    .ant-dropdown {\n      top: 100%;\n      left: 0;\n      position: relative;\n      width: 100%;\n      margin-top: 4px;\n      margin-bottom: 4px;\n    }\n  "]
                    }] }
        ];
        NzDropDownButtonComponent.propDecorators = {
            nzSize: [{ type: i0.Input }],
            nzType: [{ type: i0.Input }],
            content: [{ type: i0.ViewChild, args: ['content',] }],
            nzClick: [{ type: i0.Output }],
            nzOrigin: [{ type: i0.ViewChild, args: [NzDropDownDirective,] }]
        };
        return NzDropDownButtonComponent;
    }(NzDropDownComponent));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzSubMenuComponent = /** @class */ (function () {
        function NzSubMenuComponent(nzMenuDirective, cd, nzSubMenuComponent, nzDropDownComponent, nzDropDownButtonComponent) {
            var _this = this;
            this.nzMenuDirective = nzMenuDirective;
            this.cd = cd;
            this.nzSubMenuComponent = nzSubMenuComponent;
            this.nzDropDownComponent = nzDropDownComponent;
            this.nzDropDownButtonComponent = nzDropDownButtonComponent;
            this._open = false;
            this._disabled = false;
            this.$mouseSubject = new rxjs.Subject();
            this.unsubscribe$ = new rxjs.Subject();
            this.placement = 'rightTop';
            this.$subOpen = new rxjs.BehaviorSubject(false);
            this.isInDropDown = false;
            this.isInSubMenu = false;
            this.level = 1;
            this.triggerWidth = null;
            this.nzOpenChange = new i0.EventEmitter();
            this.handleOpenEvent = function (data) {
                if (_this.nzDisabled) {
                    return;
                }
                if (_this.nzOpen !== data) {
                    _this.nzOpen = data;
                    _this.nzOpenChange.emit(_this.nzOpen);
                }
                if (_this.nzSubMenuComponent) {
                    _this.nzSubMenuComponent.$subOpen.next(_this.nzOpen);
                }
                if (_this.nzDropDownComponent) {
                    _this.nzDropDownComponent.$subOpen.next(_this.nzOpen);
                }
                if (_this.nzDropDownButtonComponent) {
                    _this.nzDropDownButtonComponent.$subOpen.next(_this.nzOpen);
                }
            };
        }
        Object.defineProperty(NzSubMenuComponent.prototype, "nzOpen", {
            get: /**
             * @return {?}
             */ function () {
                return this._open;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._open = toBoolean(value);
                this.setTriggerWidth();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSubMenuComponent.prototype, "nzDisabled", {
            get: /**
             * @return {?}
             */ function () {
                return this._disabled;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._disabled = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSubMenuComponent.prototype, "subItemSelected", {
            get: /**
             * @return {?}
             */ function () {
                var _this = this;
                return !!this.nzMenuDirective.menuItems.find(function (e) { return e.nzSelected && e.nzSubMenuComponent === _this; });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSubMenuComponent.prototype, "submenuSelected", {
            get: /**
             * @return {?}
             */ function () {
                var _this = this;
                return !!this.subMenus.toArray().find(function (e) { return e !== _this && e.subItemSelected; });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSubMenuComponent.prototype, "expandState", {
            get: /**
             * @return {?}
             */ function () {
                if (this.nzOpen && this.subMenuMode === 'inline') {
                    return 'expand';
                }
                else if (this.nzOpen && this.subMenuMode === 'horizontal') {
                    return 'bottom';
                }
                else if (this.nzOpen && this.subMenuMode === 'vertical') {
                    return 'fade';
                }
                else {
                    return 'hidden';
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSubMenuComponent.prototype, "overlayPositions", {
            get: /**
             * @return {?}
             */ function () {
                if (this.subMenuMode === 'horizontal') {
                    return [POSITION_MAP["bottomLeft"]];
                }
                else {
                    return [POSITION_MAP["rightTop"], POSITION_MAP["leftTop"]];
                }
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} $event
         * @return {?}
         */
        NzSubMenuComponent.prototype.clickSubMenuTitle = /**
         * @param {?} $event
         * @return {?}
         */
            function ($event) {
                if (this.nzDisabled) {
                    $event.preventDefault();
                    $event.stopPropagation();
                    return;
                }
                if ((this.subMenuMode === 'inline') && (!this.isInDropDown)) {
                    this.nzOpen = !this.nzOpen;
                    this.nzOpenChange.emit(this.nzOpen);
                }
            };
        /**
         * @return {?}
         */
        NzSubMenuComponent.prototype.clickSubMenuDropDown = /**
         * @return {?}
         */
            function () {
                if (this.isInDropDown || (this.subMenuMode === 'vertical') || (this.subMenuMode === 'horizontal')) {
                    this.$mouseSubject.next(false);
                }
            };
        Object.defineProperty(NzSubMenuComponent.prototype, "subMenuMode", {
            get: /**
             * @return {?}
             */ function () {
                if (this.nzMenuDirective.nzMode === 'inline') {
                    return 'inline';
                }
                else if ((this.nzMenuDirective.nzMode === 'vertical') || (this.isInSubMenu)) {
                    return 'vertical';
                }
                else {
                    return 'horizontal';
                }
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} e
         * @return {?}
         */
        NzSubMenuComponent.prototype.onMouseEnterEvent = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                if ((this.subMenuMode === 'horizontal') || (this.subMenuMode === 'vertical') || this.isInDropDown) {
                    this.$mouseSubject.next(true);
                }
            };
        /**
         * @param {?} e
         * @return {?}
         */
        NzSubMenuComponent.prototype.onMouseLeaveEvent = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                if ((this.subMenuMode === 'horizontal') || (this.subMenuMode === 'vertical') || this.isInDropDown) {
                    this.$mouseSubject.next(false);
                }
            };
        Object.defineProperty(NzSubMenuComponent.prototype, "setDropDownSubmenuClass", {
            get: /**
             * @return {?}
             */ function () {
                return this.isInDropDown;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSubMenuComponent.prototype, "setMenuSubmenuOpenClass", {
            get: /**
             * @return {?}
             */ function () {
                return (!this.isInDropDown) && (this.nzOpen);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSubMenuComponent.prototype, "setDropDownVerticalClass", {
            get: /**
             * @return {?}
             */ function () {
                return this.isInDropDown && (this.subMenuMode === 'vertical');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSubMenuComponent.prototype, "setDropDownHorizontalClass", {
            get: /**
             * @return {?}
             */ function () {
                return this.isInDropDown && (this.subMenuMode === 'horizontal');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSubMenuComponent.prototype, "setDropDownDisabled", {
            get: /**
             * @return {?}
             */ function () {
                return this.isInDropDown && this.nzDisabled;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSubMenuComponent.prototype, "setMenuSubmenuClass", {
            get: /**
             * @return {?}
             */ function () {
                return !this.isInDropDown;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSubMenuComponent.prototype, "setMenuSubmenuSelectedClass", {
            get: /**
             * @return {?}
             */ function () {
                return this.submenuSelected || this.subItemSelected;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSubMenuComponent.prototype, "setMenuVerticalClass", {
            get: /**
             * @return {?}
             */ function () {
                return (!this.isInDropDown) && (this.subMenuMode === 'vertical');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSubMenuComponent.prototype, "setMenuHorizontalClass", {
            get: /**
             * @return {?}
             */ function () {
                return (!this.isInDropDown) && (this.subMenuMode === 'horizontal');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSubMenuComponent.prototype, "setMenuInlineClass", {
            get: /**
             * @return {?}
             */ function () {
                return (!this.isInDropDown) && (this.subMenuMode === 'inline');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSubMenuComponent.prototype, "setMenuDisabled", {
            get: /**
             * @return {?}
             */ function () {
                return (!this.isInDropDown) && this.nzDisabled;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzSubMenuComponent.prototype.setTriggerWidth = /**
         * @return {?}
         */
            function () {
                if (this.subMenuMode === 'horizontal') {
                    this.triggerWidth = this.trigger.nativeElement.getBoundingClientRect().width;
                    /** should remove after after https://github.com/angular/material2/pull/8765 merged **/
                    if (this.cdkOverlay && this.cdkOverlay.overlayRef) {
                        this.cdkOverlay.overlayRef.updateSize({
                            width: this.triggerWidth
                        });
                    }
                }
            };
        /**
         * @param {?} $event
         * @return {?}
         */
        NzSubMenuComponent.prototype.onPositionChange = /**
         * @param {?} $event
         * @return {?}
         */
            function ($event) {
                if ($event.connectionPair) {
                    /** @type {?} */
                    var originMap_1 = {
                        originX: $event.connectionPair.originX,
                        originY: $event.connectionPair.originY,
                        overlayX: $event.connectionPair.overlayX,
                        overlayY: $event.connectionPair.overlayY
                    };
                    /** @type {?} */
                    var keyList = ['originX', 'originY', 'overlayX', 'overlayY'];
                    if (keyList.every(function (key) { return originMap_1[key] === POSITION_MAP["leftTop"][key]; })) {
                        this.placement = 'leftTop';
                    }
                    else if (keyList.every(function (key) { return originMap_1[key] === POSITION_MAP["rightTop"][key]; })) {
                        this.placement = 'rightTop';
                    }
                    this.cd.detectChanges();
                }
            };
        /**
         * @return {?}
         */
        NzSubMenuComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.nzMenuDirective.subMenus.push(this);
                /** @type {?} */
                var $combineAll = rxjs.combineLatest(this.$subOpen, this.$mouseSubject.asObservable()).pipe(operators.map(function (value) { return value[0] || value[1]; }), operators.auditTime(150));
                $combineAll.pipe(operators.takeUntil(this.unsubscribe$)).subscribe(this.handleOpenEvent);
                this.isInDropDown = this.nzMenuDirective.nzInDropDown;
            };
        /**
         * @return {?}
         */
        NzSubMenuComponent.prototype.ngAfterContentInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                if (this.subMenus && this.subMenus.length) {
                    this.subMenus.filter(function (x) { return x !== _this; }).forEach(function (menu) {
                        if (_this.subMenuMode === 'inline') {
                            Promise.resolve().then(function () { return menu.level = _this.level + 1; });
                        }
                        menu.isInSubMenu = true;
                    });
                }
            };
        /**
         * @return {?}
         */
        NzSubMenuComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.unsubscribe$.next();
                this.unsubscribe$.complete();
            };
        NzSubMenuComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: '[nz-submenu]',
                        preserveWhitespaces: false,
                        animations: [
                            animations.trigger('expandAnimation', [
                                animations.state('expand', animations.style({ height: '*' })),
                                animations.state('hidden', animations.style({ height: 0, overflow: 'hidden' })),
                                animations.transition('expand => hidden', animations.animate(150)),
                                animations.transition('hidden => expand', animations.animate(150)),
                                animations.state('fade', animations.style({ opacity: 1 })),
                                animations.transition('fade => void', [
                                    animations.animate(150, animations.style({ opacity: 0 }))
                                ]),
                                animations.transition('void => fade', [
                                    animations.style({ opacity: '0' }),
                                    animations.animate(150)
                                ]),
                                animations.state('bottom', animations.style({
                                    opacity: 1,
                                    transform: 'scaleY(1)',
                                    transformOrigin: '0% 0%'
                                })),
                                animations.transition('void => bottom', [
                                    animations.style({
                                        opacity: 0,
                                        transform: 'scaleY(0.8)',
                                        transformOrigin: '0% 0%'
                                    }),
                                    animations.animate('150ms cubic-bezier(0.23, 1, 0.32, 1)')
                                ]),
                                animations.transition('bottom => void', [
                                    animations.animate('150ms cubic-bezier(0.23, 1, 0.32, 1)', animations.style({
                                        opacity: 0,
                                        transform: 'scaleY(0.8)',
                                        transformOrigin: '0% 0%'
                                    }))
                                ])
                            ])
                        ],
                        template: "<div\n  #trigger\n  cdkOverlayOrigin\n  #origin=\"cdkOverlayOrigin\"\n  [class.ant-dropdown-menu-submenu-title]=\"isInDropDown\"\n  [class.ant-menu-submenu-title]=\"!isInDropDown\"\n  (mouseenter)=\"onMouseEnterEvent($event)\"\n  (mouseleave)=\"onMouseLeaveEvent($event)\"\n  (click)=\"clickSubMenuTitle($event)\"\n  [style.paddingLeft.px]=\"(nzMenuDirective.nzMode === 'inline')?(level*nzMenuDirective.nzInlineIndent):null\">\n  <ng-content select=\"[title]\"></ng-content>\n  <i [class.ant-dropdown-menu-submenu-arrow]=\"isInDropDown\" [class.ant-menu-submenu-arrow]=\"!isInDropDown\"></i>\n</div>\n<ul\n  [class.ant-dropdown-menu]=\"isInDropDown\"\n  [@expandAnimation]=\"expandState\"\n  [class.ant-menu]=\"!isInDropDown\"\n  [class.ant-dropdown-menu-vertical]=\"isInDropDown\"\n  [class.ant-menu-inline]=\"!isInDropDown\"\n  [class.ant-dropdown-menu-sub]=\"isInDropDown\"\n  [class.ant-menu-sub]=\"!isInDropDown\"\n  (mouseleave)=\"onMouseLeaveEvent($event)\"\n  (mouseenter)=\"onMouseEnterEvent($event)\"\n  *ngIf=\"(nzMenuDirective.nzMode=='inline')\">\n  <ng-template [ngTemplateOutlet]=\"subMenuTemplate\"></ng-template>\n</ul>\n<ng-template\n  cdkConnectedOverlay\n  [cdkConnectedOverlayPositions]=\"overlayPositions\"\n  [cdkConnectedOverlayOrigin]=\"origin\"\n  [cdkConnectedOverlayWidth]=\"triggerWidth\"\n  (positionChange)=\"onPositionChange($event)\"\n  [cdkConnectedOverlayOpen]=\"nzOpen&&(nzMenuDirective.nzMode!='inline')\">\n  <div\n    class=\"ant-menu-submenu ant-menu-submenu-popup\"\n    [class.ant-menu-light]=\"nzMenuDirective.nzTheme=='light'\"\n    [class.ant-menu-dark]=\"nzMenuDirective.nzTheme=='dark'\"\n    [class.ant-menu-submenu-placement-bottomLeft]=\"subMenuMode=='horizontal'\"\n    [class.ant-menu-submenu-placement-rightTop]=\"(subMenuMode=='vertical')&&(placement=='rightTop')\"\n    [class.ant-menu-submenu-placement-leftTop]=\"(subMenuMode=='vertical')&&(placement=='leftTop')\"\n    [@expandAnimation]=\"expandState\">\n    <ul\n      [class.ant-dropdown-menu]=\"isInDropDown\"\n      [class.ant-menu]=\"!isInDropDown\"\n      [class.ant-dropdown-menu-vertical]=\"isInDropDown\"\n      [class.ant-menu-vertical]=\"!isInDropDown\"\n      [class.ant-dropdown-menu-sub]=\"isInDropDown\"\n      [class.ant-menu-sub]=\"!isInDropDown\"\n      (mouseleave)=\"onMouseLeaveEvent($event)\"\n      (mouseenter)=\"onMouseEnterEvent($event)\">\n      <ng-template [ngTemplateOutlet]=\"subMenuTemplate\"></ng-template>\n    </ul>\n  </div>\n</ng-template>\n<ng-template #subMenuTemplate>\n  <ng-content></ng-content>\n</ng-template>",
                        styles: ["\n      .ant-menu-submenu-placement-bottomLeft {\n        top: 6px;\n        position: relative;\n      }\n\n      .ant-menu-submenu-placement-rightTop {\n        left: 4px;\n        position: relative;\n      }\n\n      .ant-menu-submenu-placement-leftTop {\n        right: 4px;\n        position: relative;\n      }\n    "]
                    }] }
        ];
        /** @nocollapse */
        NzSubMenuComponent.ctorParameters = function () {
            return [
                { type: NzMenuDirective },
                { type: i0.ChangeDetectorRef },
                { type: NzSubMenuComponent, decorators: [{ type: i0.SkipSelf }, { type: i0.Optional }] },
                { type: NzDropDownComponent, decorators: [{ type: i0.Host }, { type: i0.Optional }] },
                { type: NzDropDownButtonComponent, decorators: [{ type: i0.Host }, { type: i0.Optional }] }
            ];
        };
        NzSubMenuComponent.propDecorators = {
            subMenus: [{ type: i0.ContentChildren, args: [NzSubMenuComponent, { descendants: true },] }],
            nzOpenChange: [{ type: i0.Output }],
            cdkOverlay: [{ type: i0.ViewChild, args: [i2.CdkConnectedOverlay,] }],
            trigger: [{ type: i0.ViewChild, args: ['trigger',] }],
            nzOpen: [{ type: i0.Input }],
            nzDisabled: [{ type: i0.Input }],
            setDropDownSubmenuClass: [{ type: i0.HostBinding, args: ['class.ant-dropdown-menu-submenu',] }],
            setMenuSubmenuOpenClass: [{ type: i0.HostBinding, args: ['class.ant-menu-submenu-open',] }],
            setDropDownVerticalClass: [{ type: i0.HostBinding, args: ['class.ant-dropdown-menu-submenu-vertical',] }],
            setDropDownHorizontalClass: [{ type: i0.HostBinding, args: ['class.ant-dropdown-menu-submenu-horizontal',] }],
            setDropDownDisabled: [{ type: i0.HostBinding, args: ['class.ant-dropdown-menu-submenu-disabled',] }],
            setMenuSubmenuClass: [{ type: i0.HostBinding, args: ['class.ant-menu-submenu',] }],
            setMenuSubmenuSelectedClass: [{ type: i0.HostBinding, args: ['class.ant-menu-submenu-selected',] }],
            setMenuVerticalClass: [{ type: i0.HostBinding, args: ['class.ant-menu-submenu-vertical',] }],
            setMenuHorizontalClass: [{ type: i0.HostBinding, args: ['class.ant-menu-submenu-horizontal',] }],
            setMenuInlineClass: [{ type: i0.HostBinding, args: ['class.ant-menu-submenu-inline',] }],
            setMenuDisabled: [{ type: i0.HostBinding, args: ['class.ant-menu-submenu-disabled',] }]
        };
        return NzSubMenuComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzMenuItemDirective = /** @class */ (function () {
        function NzMenuItemDirective(renderer, cd, nzMenuDirective, nzSubMenuComponent, hostElement) {
            this.renderer = renderer;
            this.cd = cd;
            this.nzMenuDirective = nzMenuDirective;
            this.nzSubMenuComponent = nzSubMenuComponent;
            this.hostElement = hostElement;
            this._disabled = false;
            this._selected = false;
            this.level = 0;
            this.padding = null;
            this.isInDropDown = false;
        }
        Object.defineProperty(NzMenuItemDirective.prototype, "nzDisabled", {
            get: /**
             * @return {?}
             */ function () {
                return this._disabled;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._disabled = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzMenuItemDirective.prototype, "nzSelected", {
            get: /**
             * @return {?}
             */ function () {
                return this._selected;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._selected = toBoolean(value);
                if (this._selected) {
                    this.renderer.addClass(this.hostElement.nativeElement, this.isInDropDown ? 'ant-dropdown-menu-item-selected' : 'ant-menu-item-selected');
                }
                else {
                    this.renderer.removeClass(this.hostElement.nativeElement, this.isInDropDown ? 'ant-dropdown-menu-item-selected' : 'ant-menu-item-selected');
                }
            },
            enumerable: true,
            configurable: true
        });
        /** clear all item selected status except this */
        /**
         * clear all item selected status except this
         * @param {?} e
         * @return {?}
         */
        NzMenuItemDirective.prototype.onClickItem = /**
         * clear all item selected status except this
         * @param {?} e
         * @return {?}
         */
            function (e) {
                if (this.nzDisabled) {
                    e.preventDefault();
                    e.stopPropagation();
                    return;
                }
                this.nzMenuDirective.clickItem(this);
                if (this.nzMenuDirective.nzSelectable) {
                    this.nzMenuDirective.clearAllSelected();
                    this.nzSelected = true;
                }
                if (this.nzSubMenuComponent) {
                    this.nzSubMenuComponent.clickSubMenuDropDown();
                }
            };
        Object.defineProperty(NzMenuItemDirective.prototype, "isInDropDownClass", {
            /** define host class */
            get: /**
             * define host class
             * @return {?}
             */ function () {
                return this.isInDropDown;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzMenuItemDirective.prototype, "isNotInDropDownClass", {
            get: /**
             * @return {?}
             */ function () {
                return !this.isInDropDown;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzMenuItemDirective.prototype, "setDropDownDisableClass", {
            get: /**
             * @return {?}
             */ function () {
                return this.isInDropDown && this.nzDisabled;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzMenuItemDirective.prototype, "setMenuDisableClass", {
            get: /**
             * @return {?}
             */ function () {
                return (!this.isInDropDown) && this.nzDisabled;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzMenuItemDirective.prototype, "setPaddingLeft", {
            get: /**
             * @return {?}
             */ function () {
                if (this.nzMenuDirective.nzMode === 'inline') {
                    if (this.nzSubMenuComponent) {
                        /** if in sub menu component and host menu's mode is inline add PADDING_BASE * level padding */
                        return (this.nzSubMenuComponent.level + 1) * this.nzMenuDirective.nzInlineIndent;
                    }
                    else {
                        /** not in sub menu component but root menu's mode is inline return default padding */
                        return this.nzMenuDirective.nzInlineIndent;
                    }
                }
                else {
                    return this.padding;
                }
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzMenuItemDirective.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.nzMenuDirective.menuItems.push(this);
                /** store origin padding in padding */
                if (this.hostElement.nativeElement.style['padding-left']) {
                    this.padding = parseInt(this.hostElement.nativeElement.style['padding-left'], 10);
                }
                this.isInDropDown = this.nzMenuDirective.nzInDropDown;
            };
        NzMenuItemDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: '[nz-menu-item]'
                    },] }
        ];
        /** @nocollapse */
        NzMenuItemDirective.ctorParameters = function () {
            return [
                { type: i0.Renderer2 },
                { type: i0.ChangeDetectorRef },
                { type: NzMenuDirective },
                { type: NzSubMenuComponent, decorators: [{ type: i0.Optional }] },
                { type: i0.ElementRef }
            ];
        };
        NzMenuItemDirective.propDecorators = {
            nzDisabled: [{ type: i0.Input }],
            nzSelected: [{ type: i0.Input }],
            onClickItem: [{ type: i0.HostListener, args: ['click', ['$event'],] }],
            isInDropDownClass: [{ type: i0.HostBinding, args: ['class.ant-dropdown-menu-item',] }],
            isNotInDropDownClass: [{ type: i0.HostBinding, args: ['class.ant-menu-item',] }],
            setDropDownDisableClass: [{ type: i0.HostBinding, args: ['class.ant-dropdown-menu-item-disabled',] }],
            setMenuDisableClass: [{ type: i0.HostBinding, args: ['class.ant-menu-item-disabled',] }],
            setPaddingLeft: [{ type: i0.HostBinding, args: ['style.padding-left.px',] }]
        };
        return NzMenuItemDirective;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzMenuModule = /** @class */ (function () {
        function NzMenuModule() {
        }
        NzMenuModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [i1.CommonModule, forms.FormsModule, NzButtonModule, i2.OverlayModule],
                        declarations: [NzMenuDirective, NzMenuItemDirective, NzSubMenuComponent, NzMenuDividerDirective, NzMenuGroupComponent],
                        exports: [NzMenuDirective, NzMenuItemDirective, NzSubMenuComponent, NzMenuDividerDirective, NzMenuGroupComponent]
                    },] }
        ];
        return NzMenuModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzDropdownContextComponent = /** @class */ (function () {
        function NzDropdownContextComponent() {
            this.dropDownPosition = 'bottom';
            this.open = true;
        }
        /**
         * @param {?} value
         * @return {?}
         */
        NzDropdownContextComponent.prototype.setTemplateRef = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.template = value;
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzDropdownContextComponent.prototype.setControl = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.control = value;
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzDropdownContextComponent.prototype.setDropDownPosition = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.dropDownPosition = value;
            };
        /**
         * @return {?}
         */
        NzDropdownContextComponent.prototype.close = /**
         * @return {?}
         */
            function () {
                this.open = false;
            };
        /**
         * @return {?}
         */
        NzDropdownContextComponent.prototype.afterAnimation = /**
         * @return {?}
         */
            function () {
                if (!this.open) {
                    this.control.close();
                }
            };
        /**
         * @return {?}
         */
        NzDropdownContextComponent.prototype.ngAfterViewInit = /**
         * @return {?}
         */
            function () {
                // TODO auto set dropdown class after the bug resolved
                /** https://github.com/angular/angular/issues/14842 **/
            };
        NzDropdownContextComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-dropdown-context',
                        animations: [
                            dropDownAnimation
                        ],
                        template: "<div class=\"ant-dropdown ant-dropdown-placement-bottomLeft\" [@dropDownAnimation]=\"dropDownPosition\" (@dropDownAnimation.done)=\"afterAnimation()\" *ngIf=\"open\">\n  <ng-template [ngTemplateOutlet]=\"template\"></ng-template>\n</div>",
                        styles: ["\n      .ant-dropdown {\n        top: 100%;\n        left: 0;\n        position: relative;\n        width: 100%;\n        margin-top: 4px;\n        margin-bottom: 4px;\n      }\n    "]
                    }] }
        ];
        return NzDropdownContextComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzDropDownModule = /** @class */ (function () {
        function NzDropDownModule() {
        }
        NzDropDownModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [i1.CommonModule, i2.OverlayModule, forms.FormsModule, NzButtonModule, NzMenuModule],
                        declarations: [NzDropDownComponent, NzDropDownButtonComponent, NzDropDownDirective, NzDropdownContextComponent],
                        entryComponents: [NzDropdownContextComponent],
                        exports: [NzDropDownComponent, NzDropDownButtonComponent, NzDropDownDirective]
                    },] }
        ];
        return NzDropDownModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * @return {?}
     */
    function matchMediaFunc() {
        if (typeof window === 'undefined') {
            return function () { return null; };
        }
        if (window.matchMedia) {
            return window.matchMedia.bind(window);
        }
        else {
            /** @type {?} */
            var matchMediaPolyfill = function (mediaQuery) {
                return {
                    media: mediaQuery,
                    matches: false,
                    addListener: /**
                     * @return {?}
                     */ function () {
                    },
                    removeListener: /**
                     * @return {?}
                     */ function () {
                    },
                };
            };
            return matchMediaPolyfill;
        }
    }
    /** @type {?} */
    var matchMedia = matchMediaFunc();

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var responsiveMap = {
        xs: '(max-width: 575px)',
        sm: '(min-width: 576px)',
        md: '(min-width: 768px)',
        lg: '(min-width: 992px)',
        xl: '(min-width: 1200px)',
        xxl: '(min-width: 1600px)'
    };
    var NzRowComponent = /** @class */ (function () {
        function NzRowComponent(elementRef, renderer, nzUpdateHostClassService) {
            this.elementRef = elementRef;
            this.renderer = renderer;
            this.nzUpdateHostClassService = nzUpdateHostClassService;
            this._align = 'top';
            this._justify = 'start';
            this.prefixCls = 'ant-row';
            this.el = this.elementRef.nativeElement;
        }
        Object.defineProperty(NzRowComponent.prototype, "nzType", {
            get: /**
             * @return {?}
             */ function () {
                return this._type;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._type = value;
                this.setClassMap();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzRowComponent.prototype, "nzAlign", {
            get: /**
             * @return {?}
             */ function () {
                return this._align;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._align = value;
                this.setClassMap();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzRowComponent.prototype, "nzJustify", {
            get: /**
             * @return {?}
             */ function () {
                return this._justify;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._justify = value;
                this.setClassMap();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzRowComponent.prototype, "nzGutter", {
            get: /**
             * @return {?}
             */ function () {
                return this._gutter;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._gutter = value;
                this.updateGutter();
                this.setStyle();
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzRowComponent.prototype.setStyle = /**
         * @return {?}
         */
            function () {
                this.renderer.setStyle(this.el, 'margin-left', "-" + this.actualGutter / 2 + "px");
                this.renderer.setStyle(this.el, 'margin-right', "-" + this.actualGutter / 2 + "px");
            };
        /**
         * @return {?}
         */
        NzRowComponent.prototype.calculateGutter = /**
         * @return {?}
         */
            function () {
                if (typeof this.nzGutter !== 'object') {
                    return this.nzGutter;
                }
                else if (this.breakPoint && this.nzGutter[this.breakPoint]) {
                    return this.nzGutter[this.breakPoint];
                }
                else {
                    return;
                }
            };
        /**
         * @return {?}
         */
        NzRowComponent.prototype.updateGutter = /**
         * @return {?}
         */
            function () {
                this.actualGutter = this.calculateGutter();
            };
        /**
         * @param {?} e
         * @return {?}
         */
        NzRowComponent.prototype.onWindowResize = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                this.watchMedia();
            };
        /**
         * @return {?}
         */
        NzRowComponent.prototype.watchMedia = /**
         * @return {?}
         */
            function () {
                var _this = this;
                Object.keys(responsiveMap).map(function (screen) {
                    /** @type {?} */
                    var matchBelow = matchMedia(responsiveMap[screen]).matches;
                    if (matchBelow) {
                        _this.breakPoint = screen;
                    }
                });
                this.updateGutter();
                this.setStyle();
            };
        /** temp solution since no method add classMap to host https://github.com/angular/angular/issues/7289*/
        /**
         * temp solution since no method add classMap to host https://github.com/angular/angular/issues/7289
         * @return {?}
         */
        NzRowComponent.prototype.setClassMap = /**
         * temp solution since no method add classMap to host https://github.com/angular/angular/issues/7289
         * @return {?}
         */
            function () {
                var _a;
                /** @type {?} */
                var classMap = (_a = {},
                    _a["" + this.prefixCls] = !this.nzType,
                    _a[this.prefixCls + "-" + this.nzType] = this.nzType,
                    _a[this.prefixCls + "-" + this.nzType + "-" + this.nzAlign] = this.nzType && this.nzAlign,
                    _a[this.prefixCls + "-" + this.nzType + "-" + this.nzJustify] = this.nzType && this.nzJustify,
                    _a);
                this.nzUpdateHostClassService.updateHostClass(this.el, classMap);
            };
        /**
         * @return {?}
         */
        NzRowComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.setClassMap();
                this.watchMedia();
            };
        NzRowComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-row',
                        preserveWhitespaces: false,
                        providers: [NzUpdateHostClassService],
                        template: "<ng-content></ng-content>"
                    }] }
        ];
        /** @nocollapse */
        NzRowComponent.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: i0.Renderer2 },
                { type: NzUpdateHostClassService }
            ];
        };
        NzRowComponent.propDecorators = {
            nzType: [{ type: i0.Input }],
            nzAlign: [{ type: i0.Input }],
            nzJustify: [{ type: i0.Input }],
            nzGutter: [{ type: i0.Input }],
            onWindowResize: [{ type: i0.HostListener, args: ['window:resize', ['$event'],] }]
        };
        return NzRowComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzRowDirective = /** @class */ (function (_super) {
        __extends(NzRowDirective, _super);
        function NzRowDirective() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        NzRowDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: '[nz-row]',
                        providers: [NzUpdateHostClassService]
                    },] }
        ];
        return NzRowDirective;
    }(NzRowComponent));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzColComponent = /** @class */ (function () {
        function NzColComponent(nzUpdateHostClassService, elementRef, nzRowComponent, nzRowDirective, renderer) {
            this.nzUpdateHostClassService = nzUpdateHostClassService;
            this.elementRef = elementRef;
            this.nzRowComponent = nzRowComponent;
            this.nzRowDirective = nzRowDirective;
            this.renderer = renderer;
            this.prefixCls = 'ant-col';
            this.el = this.elementRef.nativeElement;
        }
        Object.defineProperty(NzColComponent.prototype, "paddingLeft", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzRow && this.nzRow.actualGutter / 2;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzColComponent.prototype, "paddingRight", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzRow && this.nzRow.actualGutter / 2;
            },
            enumerable: true,
            configurable: true
        });
        /** temp solution since no method add classMap to host https://github.com/angular/angular/issues/7289*/
        /**
         * temp solution since no method add classMap to host https://github.com/angular/angular/issues/7289
         * @return {?}
         */
        NzColComponent.prototype.setClassMap = /**
         * temp solution since no method add classMap to host https://github.com/angular/angular/issues/7289
         * @return {?}
         */
            function () {
                var _a;
                /** @type {?} */
                var classMap = __assign((_a = {}, _a[this.prefixCls + "-" + this.nzSpan] = isNotNil(this.nzSpan), _a[this.prefixCls + "-order-" + this.nzOrder] = isNotNil(this.nzOrder), _a[this.prefixCls + "-offset-" + this.nzOffset] = isNotNil(this.nzOffset), _a[this.prefixCls + "-pull-" + this.nzPull] = isNotNil(this.nzPull), _a[this.prefixCls + "-push-" + this.nzPush] = isNotNil(this.nzPush), _a), this.generateClass());
                this.nzUpdateHostClassService.updateHostClass(this.el, classMap);
            };
        /**
         * @return {?}
         */
        NzColComponent.prototype.generateClass = /**
         * @return {?}
         */
            function () {
                var _this = this;
                /** @type {?} */
                var listOfSizeInputName = ['nzXs', 'nzSm', 'nzMd', 'nzLg', 'nzXl', 'nzXXl'];
                /** @type {?} */
                var listClassMap = {};
                listOfSizeInputName.forEach(function (name) {
                    /** @type {?} */
                    var sizeName = name.replace('nz', '').toLowerCase();
                    if (isNotNil(_this[name])) {
                        if ((typeof (_this[name]) === 'number') || (typeof (_this[name]) === 'string')) {
                            listClassMap[_this.prefixCls + "-" + sizeName + "-" + _this[name]] = true;
                        }
                        else {
                            listClassMap[_this.prefixCls + "-" + sizeName + "-" + _this[name].span] = _this[name] && isNotNil(_this[name].span);
                            listClassMap[_this.prefixCls + "-" + sizeName + "-pull-" + _this[name].pull] = _this[name] && isNotNil(_this[name].pull);
                            listClassMap[_this.prefixCls + "-" + sizeName + "-push-" + _this[name].push] = _this[name] && isNotNil(_this[name].push);
                            listClassMap[_this.prefixCls + "-" + sizeName + "-offset-" + _this[name].offset] = _this[name] && isNotNil(_this[name].offset);
                            listClassMap[_this.prefixCls + "-" + sizeName + "-order-" + _this[name].order] = _this[name] && isNotNil(_this[name].order);
                        }
                    }
                });
                return listClassMap;
            };
        Object.defineProperty(NzColComponent.prototype, "nzRow", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzRowComponent || this.nzRowDirective;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} changes
         * @return {?}
         */
        NzColComponent.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                this.setClassMap();
            };
        /**
         * @return {?}
         */
        NzColComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.setClassMap();
            };
        NzColComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-col',
                        providers: [NzUpdateHostClassService],
                        preserveWhitespaces: false,
                        template: "<ng-content></ng-content>"
                    }] }
        ];
        /** @nocollapse */
        NzColComponent.ctorParameters = function () {
            return [
                { type: NzUpdateHostClassService },
                { type: i0.ElementRef },
                { type: NzRowComponent, decorators: [{ type: i0.Optional }, { type: i0.Host }] },
                { type: NzRowDirective, decorators: [{ type: i0.Optional }, { type: i0.Host }] },
                { type: i0.Renderer2 }
            ];
        };
        NzColComponent.propDecorators = {
            paddingLeft: [{ type: i0.HostBinding, args: ['style.padding-left.px',] }],
            paddingRight: [{ type: i0.HostBinding, args: ['style.padding-right.px',] }],
            nzSpan: [{ type: i0.Input }],
            nzOrder: [{ type: i0.Input }],
            nzOffset: [{ type: i0.Input }],
            nzPush: [{ type: i0.Input }],
            nzPull: [{ type: i0.Input }],
            nzXs: [{ type: i0.Input }],
            nzSm: [{ type: i0.Input }],
            nzMd: [{ type: i0.Input }],
            nzLg: [{ type: i0.Input }],
            nzXl: [{ type: i0.Input }],
            nzXXl: [{ type: i0.Input }]
        };
        return NzColComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzColDirective = /** @class */ (function (_super) {
        __extends(NzColDirective, _super);
        function NzColDirective() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        NzColDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: '[nz-col]',
                        providers: [NzUpdateHostClassService]
                    },] }
        ];
        return NzColDirective;
    }(NzColComponent));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzGridModule = /** @class */ (function () {
        function NzGridModule() {
        }
        NzGridModule.decorators = [
            { type: i0.NgModule, args: [{
                        declarations: [NzRowComponent, NzColDirective, NzColComponent, NzRowDirective],
                        exports: [NzRowComponent, NzColDirective, NzColComponent, NzRowDirective],
                        imports: [i1.CommonModule]
                    },] }
        ];
        return NzGridModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzFormControlComponent = /** @class */ (function (_super) {
        __extends(NzFormControlComponent, _super);
        function NzFormControlComponent() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this._hasFeedback = false;
            return _this;
        }
        Object.defineProperty(NzFormControlComponent.prototype, "nzHasFeedback", {
            get: /**
             * @return {?}
             */ function () {
                return this._hasFeedback;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._hasFeedback = toBoolean(value);
                this.setControlClassMap();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzFormControlComponent.prototype, "nzValidateStatus", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value instanceof forms.FormControl) {
                    this.validateControl = value;
                    this.validateString = null;
                    this.controlStatus = null;
                    this.setControlClassMap();
                    this.watchControl();
                }
                else {
                    this.validateString = value;
                    this.validateControl = null;
                    this.removeSubscribe();
                    this.setControlClassMap();
                }
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzFormControlComponent.prototype.removeSubscribe = /**
         * @return {?}
         */
            function () {
                if (this.validateChanges) {
                    this.validateChanges.unsubscribe();
                    this.validateChanges = null;
                }
            };
        /**
         * @param {?} status
         * @return {?}
         */
        NzFormControlComponent.prototype.updateValidateStatus = /**
         * @param {?} status
         * @return {?}
         */
            function (status) {
                if (this.validateControl.dirty || this.validateControl.touched) {
                    this.controlStatus = status;
                    this.setControlClassMap();
                }
                else {
                    this.controlStatus = null;
                    this.setControlClassMap();
                }
            };
        /**
         * @return {?}
         */
        NzFormControlComponent.prototype.watchControl = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.removeSubscribe();
                /** miss detect https://github.com/angular/angular/issues/10887 **/
                if (this.validateControl && this.validateControl.statusChanges) {
                    this.validateChanges = this.validateControl.statusChanges.subscribe(function (data) { return _this.updateValidateStatus(data); });
                }
            };
        /**
         * @return {?}
         */
        NzFormControlComponent.prototype.setControlClassMap = /**
         * @return {?}
         */
            function () {
                var _a;
                this.controlClassMap = (_a = {},
                    _a["has-warning"] = this.validateString === 'warning',
                    _a["is-validating"] = this.validateString === 'validating' || this.validateString === 'pending' || this.controlStatus === 'PENDING',
                    _a["has-error"] = this.validateString === 'error' || this.controlStatus === 'INVALID',
                    _a["has-success"] = this.validateString === 'success' || this.controlStatus === 'VALID',
                    _a["has-feedback"] = this.nzHasFeedback,
                    _a);
            };
        /**
         * @return {?}
         */
        NzFormControlComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.setClassMap();
                this.setControlClassMap();
            };
        /**
         * @return {?}
         */
        NzFormControlComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.removeSubscribe();
            };
        /**
         * @return {?}
         */
        NzFormControlComponent.prototype.ngAfterContentInit = /**
         * @return {?}
         */
            function () {
                this.watchControl();
                if (this.validateControl) {
                    this.updateValidateStatus(this.validateControl.status);
                }
            };
        NzFormControlComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-form-control',
                        providers: [NzUpdateHostClassService],
                        preserveWhitespaces: false,
                        template: "<div class=\"ant-form-item-control\" [ngClass]=\"controlClassMap\">\n  <span class=\"ant-form-item-children\">\n    <ng-content></ng-content>\n  </span>\n  <ng-content select=\"nz-form-explain\"></ng-content>\n</div>",
                        host: {
                            '[class.ant-form-item-control-wrapper]': 'true'
                        },
                        styles: [":host {\n    display: block;\n  }"]
                    }] }
        ];
        NzFormControlComponent.propDecorators = {
            validateControl: [{ type: i0.ContentChild, args: [forms.NgControl,] }],
            nzHasFeedback: [{ type: i0.Input }],
            nzValidateStatus: [{ type: i0.Input }]
        };
        return NzFormControlComponent;
    }(NzColComponent));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * should add nz-row directive to host, track https://github.com/angular/angular/issues/8785 *
     */
    var NzFormItemComponent = /** @class */ (function (_super) {
        __extends(NzFormItemComponent, _super);
        function NzFormItemComponent() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this._flex = false;
            _this.withHelp = 0;
            return _this;
        }
        Object.defineProperty(NzFormItemComponent.prototype, "nzFlex", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._flex = toBoolean(value);
                if (this._flex) {
                    this.renderer.setStyle(this.elementRef.nativeElement, 'display', 'flex');
                }
                else {
                    this.renderer.removeStyle(this.elementRef.nativeElement, 'display');
                }
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzFormItemComponent.prototype.enableHelp = /**
         * @return {?}
         */
            function () {
                this.withHelp++;
            };
        /**
         * @return {?}
         */
        NzFormItemComponent.prototype.disableHelp = /**
         * @return {?}
         */
            function () {
                this.withHelp--;
            };
        NzFormItemComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-form-item',
                        preserveWhitespaces: false,
                        providers: [NzUpdateHostClassService],
                        template: "<ng-content></ng-content>",
                        host: {
                            '[class.ant-form-item]': 'true',
                            '[class.ant-form-item-with-help]': 'withHelp>0'
                        },
                        styles: [":host {\n    display: block;\n  }"]
                    }] }
        ];
        NzFormItemComponent.propDecorators = {
            nzFlex: [{ type: i0.Input }]
        };
        return NzFormItemComponent;
    }(NzRowComponent));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzFormExplainComponent = /** @class */ (function () {
        function NzFormExplainComponent(nzFormItemComponent) {
            this.nzFormItemComponent = nzFormItemComponent;
        }
        /**
         * @return {?}
         */
        NzFormExplainComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.nzFormItemComponent.disableHelp();
            };
        /**
         * @return {?}
         */
        NzFormExplainComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.nzFormItemComponent.enableHelp();
            };
        NzFormExplainComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-form-explain',
                        preserveWhitespaces: false,
                        animations: [
                            animations.trigger('formExplainAnimation', [
                                animations.transition('void => *', [
                                    animations.style({
                                        opacity: 0,
                                        transform: 'translateY(-5px)'
                                    }),
                                    animations.animate('0.3s cubic-bezier(0.645, 0.045, 0.355, 1)', animations.style({
                                        opacity: 1,
                                        transform: 'translateY(0)'
                                    }))
                                ]),
                                animations.transition('* => void', [
                                    animations.style({
                                        opacity: 1,
                                        transform: 'translateY(0)'
                                    }),
                                    animations.animate('0.3s cubic-bezier(0.645, 0.045, 0.355, 1)', animations.style({
                                        opacity: 0,
                                        transform: 'translateY(-5px)'
                                    }))
                                ])
                            ])
                        ],
                        template: "<div [@formExplainAnimation]>\n  <ng-content></ng-content>\n</div>",
                        host: {
                            '[class.ant-form-explain]': 'true'
                        },
                        styles: [":host{\n      display:block;\n    }"]
                    }] }
        ];
        /** @nocollapse */
        NzFormExplainComponent.ctorParameters = function () {
            return [
                { type: NzFormItemComponent }
            ];
        };
        return NzFormExplainComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzFormExtraComponent = /** @class */ (function () {
        function NzFormExtraComponent() {
        }
        NzFormExtraComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-form-extra',
                        template: "<ng-content></ng-content>",
                        host: {
                            '[class.ant-form-extra]': 'true'
                        },
                        styles: [":host {\n    display: block;\n  }"]
                    }] }
        ];
        return NzFormExtraComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzFormLabelComponent = /** @class */ (function (_super) {
        __extends(NzFormLabelComponent, _super);
        function NzFormLabelComponent() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this._required = false;
            return _this;
        }
        Object.defineProperty(NzFormLabelComponent.prototype, "nzRequired", {
            get: /**
             * @return {?}
             */ function () {
                return this._required;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._required = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        NzFormLabelComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-form-label',
                        providers: [NzUpdateHostClassService],
                        preserveWhitespaces: false,
                        template: "<label [attr.for]=\"nzFor\" [class.ant-form-item-required]=\"nzRequired\">\n  <ng-content></ng-content>\n</label>",
                        host: {
                            '[class.ant-form-item-label]': 'true'
                        }
                    }] }
        ];
        NzFormLabelComponent.propDecorators = {
            nzFor: [{ type: i0.Input }],
            nzRequired: [{ type: i0.Input }]
        };
        return NzFormLabelComponent;
    }(NzColComponent));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzFormSplitComponent = /** @class */ (function () {
        function NzFormSplitComponent() {
        }
        NzFormSplitComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-form-split',
                        template: "<ng-content></ng-content>",
                        host: {
                            '[class.ant-form-split]': 'true'
                        }
                    }] }
        ];
        return NzFormSplitComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzFormTextComponent = /** @class */ (function () {
        function NzFormTextComponent() {
        }
        NzFormTextComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-form-text',
                        template: "<ng-content></ng-content>",
                        host: {
                            '[class.ant-form-text]': 'true'
                        }
                    }] }
        ];
        return NzFormTextComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzFormDirective = /** @class */ (function () {
        function NzFormDirective(elementRef, renderer, nzUpdateHostClassService) {
            this.elementRef = elementRef;
            this.renderer = renderer;
            this.nzUpdateHostClassService = nzUpdateHostClassService;
            this.prefixCls = 'ant-form';
            this._layout = 'horizontal';
            this.el = this.elementRef.nativeElement;
        }
        Object.defineProperty(NzFormDirective.prototype, "nzLayout", {
            get: /**
             * @return {?}
             */ function () {
                return this._layout;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._layout = value;
                this.setClassMap();
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzFormDirective.prototype.setClassMap = /**
         * @return {?}
         */
            function () {
                var _a;
                /** @type {?} */
                var classMap = (_a = {},
                    _a["" + this.prefixCls] = true,
                    _a[this.prefixCls + "-" + this.nzLayout] = this.nzLayout,
                    _a);
                this.nzUpdateHostClassService.updateHostClass(this.el, classMap);
            };
        /**
         * @return {?}
         */
        NzFormDirective.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.setClassMap();
            };
        NzFormDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: '[nz-form]',
                        providers: [NzUpdateHostClassService]
                    },] }
        ];
        /** @nocollapse */
        NzFormDirective.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: i0.Renderer2 },
                { type: NzUpdateHostClassService }
            ];
        };
        NzFormDirective.propDecorators = {
            nzLayout: [{ type: i0.Input }]
        };
        return NzFormDirective;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzFormModule = /** @class */ (function () {
        function NzFormModule() {
        }
        NzFormModule.decorators = [
            { type: i0.NgModule, args: [{
                        declarations: [NzFormExtraComponent, NzFormLabelComponent, NzFormDirective, NzFormItemComponent, NzFormControlComponent, NzFormExplainComponent, NzFormTextComponent, NzFormSplitComponent],
                        exports: [NzFormExtraComponent, NzFormLabelComponent, NzFormDirective, NzFormItemComponent, NzFormControlComponent, NzFormExplainComponent, NzFormTextComponent, NzFormSplitComponent],
                        imports: [i1.CommonModule, NzGridModule]
                    },] }
        ];
        return NzFormModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzInputNumberComponent = /** @class */ (function () {
        function NzInputNumberComponent(elementRef, renderer) {
            this.elementRef = elementRef;
            this.renderer = renderer;
            this.isInit = false;
            this._disabled = false;
            this._step = 1;
            this._autoFocus = false;
            this._formatter = function (value) { return value; };
            this.isFocused = false;
            this.prefixCls = 'ant-input-number';
            this.disabledUp = false;
            this.disabledDown = false;
            this.onChange = function () { return null; };
            this.onTouched = function () { return null; };
            this.nzSize = 'default';
            this.nzMin = -Infinity;
            this.nzMax = Infinity;
            this.nzParser = function (value) { return value; };
            this.nzPlaceHolder = '';
            this.el = this.elementRef.nativeElement;
        }
        Object.defineProperty(NzInputNumberComponent.prototype, "isLarge", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzSize === 'large';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputNumberComponent.prototype, "isSmall", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzSize === 'small';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputNumberComponent.prototype, "nzAutoFocus", {
            get: /**
             * @return {?}
             */ function () {
                return this._autoFocus;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._autoFocus = toBoolean(value);
                this.updateAutoFocus();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputNumberComponent.prototype, "nzDisabled", {
            get: /**
             * @return {?}
             */ function () {
                return this._disabled;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._disabled = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputNumberComponent.prototype, "nzStep", {
            get: /**
             * @return {?}
             */ function () {
                return this._step;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._step = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzInputNumberComponent.prototype, "nzFormatter", {
            get: /**
             * @return {?}
             */ function () {
                return this._formatter;
            },
            set: /**
             * @param {?} v
             * @return {?}
             */ function (v) {
                this._formatter = v;
                /** @type {?} */
                var value = this.getCurrentValidValue(this.actualValue);
                this.writeValue(value);
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzInputNumberComponent.prototype.updateAutoFocus = /**
         * @return {?}
         */
            function () {
                if (this.nzAutoFocus) {
                    this.renderer.setAttribute(this.inputElement.nativeElement, 'autofocus', 'autofocus');
                }
                else {
                    this.renderer.removeAttribute(this.inputElement.nativeElement, 'autofocus');
                }
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzInputNumberComponent.prototype.onModelChange = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.actualValue = this.nzParser(value.trim().replace(/。/g, '.').replace(/[^\w\.-]+/g, ''));
                this.inputElement.nativeElement.value = this.actualValue;
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzInputNumberComponent.prototype.getCurrentValidValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                /** @type {?} */
                var val = value;
                if (val === '') {
                    val = '';
                }
                else if (!this.isNotCompleteNumber(val)) {
                    val = /** @type {?} */ (this.getValidValue(val));
                }
                else {
                    val = this.value;
                }
                return this.toNumber(val);
            };
        // '1.' '1x' 'xx' '' => are not complete numbers
        /**
         * @param {?} num
         * @return {?}
         */
        NzInputNumberComponent.prototype.isNotCompleteNumber = /**
         * @param {?} num
         * @return {?}
         */
            function (num) {
                return (isNaN(/** @type {?} */ (num)) ||
                    num === '' ||
                    num === null ||
                    (num && num.toString().indexOf('.') === num.toString().length - 1));
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzInputNumberComponent.prototype.getValidValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                /** @type {?} */
                var val = parseFloat(/** @type {?} */ (value));
                // https://github.com/ant-design/ant-design/issues/7358
                if (isNaN(val)) {
                    return value;
                }
                if (val < this.nzMin) {
                    val = this.nzMin;
                }
                if (val > this.nzMax) {
                    val = this.nzMax;
                }
                return val;
            };
        /**
         * @param {?} num
         * @return {?}
         */
        NzInputNumberComponent.prototype.toNumber = /**
         * @param {?} num
         * @return {?}
         */
            function (num) {
                if (this.isNotCompleteNumber(num)) {
                    return /** @type {?} */ (num);
                }
                if (isNotNil(this.nzPrecision)) {
                    return Number(Number(num).toFixed(this.nzPrecision));
                }
                return Number(num);
            };
        /**
         * @param {?} e
         * @return {?}
         */
        NzInputNumberComponent.prototype.onBlur = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                this.onTouched();
                this.isFocused = false;
                /** @type {?} */
                var value = this.getCurrentValidValue(this.actualValue);
                this.setValue(value, "" + this.value !== "" + value);
            };
        /**
         * @param {?} e
         * @return {?}
         */
        NzInputNumberComponent.prototype.onFocus = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                this.isFocused = true;
            };
        /**
         * @param {?} e
         * @return {?}
         */
        NzInputNumberComponent.prototype.getRatio = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                /** @type {?} */
                var ratio = 1;
                if (e.metaKey || e.ctrlKey) {
                    ratio = 0.1;
                }
                else if (e.shiftKey) {
                    ratio = 10;
                }
                return ratio;
            };
        /**
         * @param {?} e
         * @param {?=} ratio
         * @return {?}
         */
        NzInputNumberComponent.prototype.down = /**
         * @param {?} e
         * @param {?=} ratio
         * @return {?}
         */
            function (e, ratio) {
                if (!this.isFocused) {
                    this.focus();
                }
                this.step('down', e, ratio);
            };
        /**
         * @param {?} e
         * @param {?=} ratio
         * @return {?}
         */
        NzInputNumberComponent.prototype.up = /**
         * @param {?} e
         * @param {?=} ratio
         * @return {?}
         */
            function (e, ratio) {
                if (!this.isFocused) {
                    this.focus();
                }
                this.step('up', e, ratio);
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzInputNumberComponent.prototype.getPrecision = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                /** @type {?} */
                var valueString = value.toString();
                if (valueString.indexOf('e-') >= 0) {
                    return parseInt(valueString.slice(valueString.indexOf('e-') + 2), 10);
                }
                /** @type {?} */
                var precision = 0;
                if (valueString.indexOf('.') >= 0) {
                    precision = valueString.length - valueString.indexOf('.') - 1;
                }
                return precision;
            };
        // step={1.0} value={1.51}
        // press +
        // then value should be 2.51, rather than 2.5
        // if this.props.precision is undefined
        // https://github.com/react-component/input-number/issues/39
        /**
         * @param {?} currentValue
         * @param {?} ratio
         * @return {?}
         */
        NzInputNumberComponent.prototype.getMaxPrecision = /**
         * @param {?} currentValue
         * @param {?} ratio
         * @return {?}
         */
            function (currentValue, ratio) {
                if (isNotNil(this.nzPrecision)) {
                    return this.nzPrecision;
                }
                /** @type {?} */
                var ratioPrecision = this.getPrecision(ratio);
                /** @type {?} */
                var stepPrecision = this.getPrecision(this.nzStep);
                /** @type {?} */
                var currentValuePrecision = this.getPrecision(/** @type {?} */ (currentValue));
                if (!currentValue) {
                    return ratioPrecision + stepPrecision;
                }
                return Math.max(currentValuePrecision, ratioPrecision + stepPrecision);
            };
        /**
         * @param {?} currentValue
         * @param {?} ratio
         * @return {?}
         */
        NzInputNumberComponent.prototype.getPrecisionFactor = /**
         * @param {?} currentValue
         * @param {?} ratio
         * @return {?}
         */
            function (currentValue, ratio) {
                /** @type {?} */
                var precision = this.getMaxPrecision(currentValue, ratio);
                return Math.pow(10, precision);
            };
        /**
         * @param {?} val
         * @param {?} rat
         * @return {?}
         */
        NzInputNumberComponent.prototype.upStep = /**
         * @param {?} val
         * @param {?} rat
         * @return {?}
         */
            function (val, rat) {
                /** @type {?} */
                var precisionFactor = this.getPrecisionFactor(val, rat);
                /** @type {?} */
                var precision = Math.abs(this.getMaxPrecision(val, rat));
                /** @type {?} */
                var result;
                if (typeof val === 'number') {
                    result =
                        ((precisionFactor * val + precisionFactor * this.nzStep * rat) /
                            precisionFactor).toFixed(precision);
                }
                else {
                    result = this.nzMin === -Infinity ? this.nzStep : this.nzMin;
                }
                return this.toNumber(result);
            };
        /**
         * @param {?} val
         * @param {?} rat
         * @return {?}
         */
        NzInputNumberComponent.prototype.downStep = /**
         * @param {?} val
         * @param {?} rat
         * @return {?}
         */
            function (val, rat) {
                /** @type {?} */
                var precisionFactor = this.getPrecisionFactor(val, rat);
                /** @type {?} */
                var precision = Math.abs(this.getMaxPrecision(val, rat));
                /** @type {?} */
                var result;
                if (typeof val === 'number') {
                    result =
                        ((precisionFactor * val - precisionFactor * this.nzStep * rat) /
                            precisionFactor).toFixed(precision);
                }
                else {
                    result = this.nzMin === -Infinity ? -this.nzStep : this.nzMin;
                }
                return this.toNumber(result);
            };
        /**
         * @param {?} type
         * @param {?} e
         * @param {?=} ratio
         * @return {?}
         */
        NzInputNumberComponent.prototype.step = /**
         * @param {?} type
         * @param {?} e
         * @param {?=} ratio
         * @return {?}
         */
            function (type, e, ratio) {
                var _this = this;
                if (ratio === void 0) {
                    ratio = 1;
                }
                this.stop();
                e.preventDefault();
                if (this.nzDisabled) {
                    return;
                }
                /** @type {?} */
                var value = this.getCurrentValidValue(this.actualValue) || 0;
                /** @type {?} */
                var val;
                if (type === 'up') {
                    val = this.upStep(value, ratio);
                }
                else if (type === 'down') {
                    val = this.downStep(value, ratio);
                }
                /** @type {?} */
                var outOfRange = val > this.nzMax || val < this.nzMin;
                if (val > this.nzMax) {
                    val = this.nzMax;
                }
                else if (val < this.nzMin) {
                    val = this.nzMin;
                }
                this.setValue(val, true);
                this.isFocused = true;
                if (outOfRange) {
                    return;
                }
                this.autoStepTimer = setTimeout(function () {
                    _this[type](e, ratio, true);
                }, 600);
            };
        /**
         * @return {?}
         */
        NzInputNumberComponent.prototype.stop = /**
         * @return {?}
         */
            function () {
                if (this.autoStepTimer) {
                    clearTimeout(this.autoStepTimer);
                }
            };
        /**
         * @param {?} value
         * @param {?} emit
         * @return {?}
         */
        NzInputNumberComponent.prototype.setValue = /**
         * @param {?} value
         * @param {?} emit
         * @return {?}
         */
            function (value, emit) {
                if (emit && ("" + this.value !== "" + value)) {
                    this.onChange(value);
                }
                this.value = value;
                this.actualValue = value;
                /** @type {?} */
                var displayValue = isNotNil(this.nzFormatter(this.value)) ? this.nzFormatter(this.value) : '';
                this.displayValue = displayValue;
                this.inputElement.nativeElement.value = displayValue;
                this.disabledUp = this.disabledDown = false;
                if (value || value === 0) {
                    /** @type {?} */
                    var val = Number(value);
                    if (val >= this.nzMax) {
                        this.disabledUp = true;
                    }
                    if (val <= this.nzMin) {
                        this.disabledDown = true;
                    }
                }
            };
        /**
         * @param {?} e
         * @return {?}
         */
        NzInputNumberComponent.prototype.onKeyDown = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                if (e.code === 'ArrowUp' || e.keyCode === 38) {
                    /** @type {?} */
                    var ratio = this.getRatio(e);
                    this.up(e, ratio);
                    this.stop();
                }
                else if (e.code === 'ArrowDown' || e.keyCode === 40) {
                    /** @type {?} */
                    var ratio = this.getRatio(e);
                    this.down(e, ratio);
                    this.stop();
                }
            };
        /**
         * @param {?} e
         * @return {?}
         */
        NzInputNumberComponent.prototype.onKeyUp = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                this.stop();
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzInputNumberComponent.prototype.writeValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.setValue(value, false);
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzInputNumberComponent.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onChange = fn;
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzInputNumberComponent.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onTouched = fn;
            };
        /**
         * @param {?} isDisabled
         * @return {?}
         */
        NzInputNumberComponent.prototype.setDisabledState = /**
         * @param {?} isDisabled
         * @return {?}
         */
            function (isDisabled) {
                this.nzDisabled = isDisabled;
            };
        /**
         * @return {?}
         */
        NzInputNumberComponent.prototype.focus = /**
         * @return {?}
         */
            function () {
                this.inputElement.nativeElement.focus();
            };
        /**
         * @return {?}
         */
        NzInputNumberComponent.prototype.blur = /**
         * @return {?}
         */
            function () {
                this.inputElement.nativeElement.blur();
            };
        /**
         * @return {?}
         */
        NzInputNumberComponent.prototype.ngAfterViewInit = /**
         * @return {?}
         */
            function () {
                this.isInit = true;
                if (this._autoFocus) {
                    this.focus();
                }
            };
        NzInputNumberComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-input-number',
                        template: "<div class=\"ant-input-number-handler-wrap\">\n  <a\n    (mousedown)=\"up($event)\"\n    (mouseup)=\"stop()\"\n    (mouseleave)=\"stop()\"\n    class=\"ant-input-number-handler ant-input-number-handler-up\"\n    [class.ant-input-number-handler-up-disabled]=\"disabledUp\">\n    <span class=\"ant-input-number-handler-up-inner\" unselectable=\"unselectable\" (click)=\"$event.preventDefault()\"></span>\n  </a>\n  <a\n    (mousedown)=\"down($event)\"\n    (mouseup)=\"stop()\"\n    (mouseleave)=\"stop()\"\n    class=\"ant-input-number-handler ant-input-number-handler-down\"\n    [class.ant-input-number-handler-down-disabled]=\"disabledDown\">\n    <span class=\"ant-input-number-handler-down-inner\" unselectable=\"unselectable\" (click)=\"$event.preventDefault()\"></span>\n  </a>\n</div>\n<div class=\"ant-input-number-input-wrap\">\n  <input\n    #inputElement\n    class=\"ant-input-number-input\"\n    [disabled]=\"nzDisabled\"\n    [attr.min]=\"nzMin\"\n    [attr.max]=\"nzMax\"\n    [placeholder]=\"nzPlaceHolder\"\n    [attr.step]=\"nzStep\"\n    (keydown)=\"onKeyDown($event)\"\n    (keyup)=\"onKeyUp($event)\"\n    (blur)=\"onBlur($event)\"\n    (focus)=\"onFocus($event)\"\n    [ngModel]=\"displayValue\"\n    (ngModelChange)=\"onModelChange($event)\"\n    autocomplete=\"off\">\n</div>",
                        providers: [
                            {
                                provide: forms.NG_VALUE_ACCESSOR,
                                useExisting: i0.forwardRef(function () { return NzInputNumberComponent; }),
                                multi: true
                            }
                        ],
                        host: {
                            '[class.ant-input-number]': 'true',
                            '[class.ant-input-number-focused]': 'isFocused'
                        }
                    }] }
        ];
        /** @nocollapse */
        NzInputNumberComponent.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: i0.Renderer2 }
            ];
        };
        NzInputNumberComponent.propDecorators = {
            inputElement: [{ type: i0.ViewChild, args: ['inputElement',] }],
            nzSize: [{ type: i0.Input }],
            nzMin: [{ type: i0.Input }],
            nzMax: [{ type: i0.Input }],
            nzParser: [{ type: i0.Input }],
            nzPrecision: [{ type: i0.Input }],
            nzPlaceHolder: [{ type: i0.Input }],
            isLarge: [{ type: i0.HostBinding, args: ['class.ant-input-number-lg',] }],
            isSmall: [{ type: i0.HostBinding, args: ['class.ant-input-number-sm',] }],
            nzAutoFocus: [{ type: i0.Input }],
            nzDisabled: [{ type: i0.Input }, { type: i0.HostBinding, args: ['class.ant-input-number-disabled',] }],
            nzStep: [{ type: i0.Input }],
            nzFormatter: [{ type: i0.Input }]
        };
        return NzInputNumberComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzInputNumberModule = /** @class */ (function () {
        function NzInputNumberModule() {
        }
        NzInputNumberModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [i1.CommonModule, forms.FormsModule],
                        declarations: [NzInputNumberComponent],
                        exports: [NzInputNumberComponent]
                    },] }
        ];
        return NzInputNumberModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzMatchMediaService = /** @class */ (function () {
        function NzMatchMediaService() {
        }
        /**
         * @param {?} mediaQuery
         * @return {?}
         */
        NzMatchMediaService.prototype.matchMedia = /**
         * @param {?} mediaQuery
         * @return {?}
         */
            function (mediaQuery) {
                return matchMedia(mediaQuery);
            };
        NzMatchMediaService.decorators = [
            { type: i0.Injectable }
        ];
        return NzMatchMediaService;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzContentComponent = /** @class */ (function () {
        function NzContentComponent() {
        }
        NzContentComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-content',
                        preserveWhitespaces: false,
                        template: "<ng-content></ng-content>",
                        host: {
                            '[class.ant-layout-content]': 'true'
                        },
                        styles: [":host {\n      display: block;\n    }"]
                    }] }
        ];
        return NzContentComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzFooterComponent = /** @class */ (function () {
        function NzFooterComponent() {
        }
        NzFooterComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-footer',
                        preserveWhitespaces: false,
                        template: "<ng-content></ng-content>",
                        host: {
                            '[class.ant-layout-footer]': 'true'
                        },
                        styles: [":host {\n      display: block;\n    }"]
                    }] }
        ];
        return NzFooterComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzHeaderComponent = /** @class */ (function () {
        function NzHeaderComponent() {
        }
        NzHeaderComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-header',
                        preserveWhitespaces: false,
                        template: "<ng-content></ng-content>",
                        host: {
                            '[class.ant-layout-header]': 'true'
                        },
                        styles: [":host {\n      display: block;\n    }"]
                    }] }
        ];
        return NzHeaderComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzLayoutComponent = /** @class */ (function () {
        function NzLayoutComponent() {
            this.hasSider = false;
        }
        NzLayoutComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-layout',
                        preserveWhitespaces: false,
                        template: "<ng-content></ng-content>",
                        host: {
                            '[class.ant-layout]': 'true',
                            '[class.ant-layout-has-sider]': 'hasSider'
                        }
                    }] }
        ];
        return NzLayoutComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzSiderComponent = /** @class */ (function () {
        function NzSiderComponent(nzLayoutComponent, nzMatchMediaService) {
            this.nzLayoutComponent = nzLayoutComponent;
            this.nzMatchMediaService = nzMatchMediaService;
            this._collapsed = false;
            this._collapsible = false;
            this._reverseArrow = false;
            this.below = false;
            this.isInit = false;
            this.dimensionMap = {
                xs: '480px',
                sm: '576px',
                md: '768px',
                lg: '992px',
                xl: '1200px',
                xxl: '1600px'
            };
            this.nzWidth = 200;
            this.nzCollapsedWidth = 80;
            this.nzCollapsedChange = new i0.EventEmitter();
        }
        Object.defineProperty(NzSiderComponent.prototype, "nzReverseArrow", {
            get: /**
             * @return {?}
             */ function () {
                return this._reverseArrow;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._reverseArrow = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSiderComponent.prototype, "nzTrigger", {
            get: /**
             * @return {?}
             */ function () {
                return this._trigger;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._trigger = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSiderComponent.prototype, "nzCollapsible", {
            get: /**
             * @return {?}
             */ function () {
                return this._collapsible;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._collapsible = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSiderComponent.prototype, "nzCollapsed", {
            get: /**
             * @return {?}
             */ function () {
                return this._collapsed;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._collapsed = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSiderComponent.prototype, "setZeroClass", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzCollapsed && (this.nzCollapsedWidth === 0);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSiderComponent.prototype, "setFlex", {
            get: /**
             * @return {?}
             */ function () {
                if (this.nzCollapsed) {
                    return "0 0 " + this.nzCollapsedWidth + "px";
                }
                else {
                    return "0 0 " + this.nzWidth + "px";
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSiderComponent.prototype, "setWidth", {
            get: /**
             * @return {?}
             */ function () {
                if (this.nzCollapsed) {
                    return this.nzCollapsedWidth;
                }
                else {
                    return this.nzWidth;
                }
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @param {?} e
         * @return {?}
         */
        NzSiderComponent.prototype.onWindowResize = /**
         * @param {?} e
         * @return {?}
         */
            function (e) {
                this.watchMatchMedia();
            };
        /**
         * @return {?}
         */
        NzSiderComponent.prototype.watchMatchMedia = /**
         * @return {?}
         */
            function () {
                if (this.nzBreakpoint) {
                    /** @type {?} */
                    var matchBelow = this.nzMatchMediaService.matchMedia("(max-width: " + this.dimensionMap[this.nzBreakpoint] + ")").matches;
                    this.below = matchBelow;
                    this.nzCollapsed = matchBelow;
                    if (this.isInit) {
                        this.nzCollapsedChange.emit(matchBelow);
                    }
                }
            };
        /**
         * @return {?}
         */
        NzSiderComponent.prototype.toggleCollapse = /**
         * @return {?}
         */
            function () {
                this.nzCollapsed = !this.nzCollapsed;
                this.nzCollapsedChange.emit(this.nzCollapsed);
            };
        Object.defineProperty(NzSiderComponent.prototype, "isZeroTrigger", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzCollapsible && this.nzTrigger && (this.nzCollapsedWidth === 0) && ((this.nzBreakpoint && this.below) || (!this.nzBreakpoint));
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSiderComponent.prototype, "isSiderTrigger", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzCollapsible && this.nzTrigger && (this.nzCollapsedWidth !== 0);
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzSiderComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.watchMatchMedia();
                if (this.nzLayoutComponent) {
                    this.nzLayoutComponent.hasSider = true;
                }
            };
        /**
         * @return {?}
         */
        NzSiderComponent.prototype.ngAfterViewInit = /**
         * @return {?}
         */
            function () {
                this.isInit = true;
            };
        NzSiderComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-sider',
                        preserveWhitespaces: false,
                        template: "<div class=\"ant-layout-sider-children\">\n  <ng-content></ng-content>\n</div>\n<span class=\"ant-layout-sider-zero-width-trigger\" *ngIf=\"isZeroTrigger\" (click)=\"toggleCollapse()\">\n  <i class=\"anticon anticon-bars\"></i>\n</span>\n<div class=\"ant-layout-sider-trigger\" *ngIf=\"isSiderTrigger\" (click)=\"toggleCollapse()\" [style.width.px]=\"nzCollapsed?nzCollapsedWidth:nzWidth\">\n  <ng-template [ngTemplateOutlet]=\"nzTrigger\"></ng-template>\n</div>\n<ng-template #defaultTrigger>\n  <i class=\"anticon\" [class.anticon-left]=\"!nzCollapsed\" [class.anticon-right]=\"nzCollapsed\" *ngIf=\"!nzReverseArrow\"></i>\n  <i class=\"anticon\" [class.anticon-left]=\"nzCollapsed\" [class.anticon-right]=\"!nzCollapsed\" *ngIf=\"nzReverseArrow\"></i>\n</ng-template>",
                        host: {
                            '[class.ant-layout-sider]': 'true'
                        }
                    }] }
        ];
        /** @nocollapse */
        NzSiderComponent.ctorParameters = function () {
            return [
                { type: NzLayoutComponent, decorators: [{ type: i0.Optional }, { type: i0.Host }] },
                { type: NzMatchMediaService }
            ];
        };
        NzSiderComponent.propDecorators = {
            _trigger: [{ type: i0.ViewChild, args: ['defaultTrigger',] }],
            nzWidth: [{ type: i0.Input }],
            nzCollapsedWidth: [{ type: i0.Input }],
            nzBreakpoint: [{ type: i0.Input }],
            nzReverseArrow: [{ type: i0.Input }],
            nzTrigger: [{ type: i0.Input }],
            nzCollapsible: [{ type: i0.Input }],
            nzCollapsed: [{ type: i0.Input }, { type: i0.HostBinding, args: ['class.ant-layout-sider-collapsed',] }],
            nzCollapsedChange: [{ type: i0.Output }],
            setZeroClass: [{ type: i0.HostBinding, args: ['class.ant-layout-sider-zero-width',] }],
            setFlex: [{ type: i0.HostBinding, args: ['style.flex',] }],
            setWidth: [{ type: i0.HostBinding, args: ['style.max-width.px',] }, { type: i0.HostBinding, args: ['style.min-width.px',] }, { type: i0.HostBinding, args: ['style.width.px',] }],
            onWindowResize: [{ type: i0.HostListener, args: ['window:resize', ['$event'],] }]
        };
        return NzSiderComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzLayoutModule = /** @class */ (function () {
        function NzLayoutModule() {
        }
        NzLayoutModule.decorators = [
            { type: i0.NgModule, args: [{
                        declarations: [NzLayoutComponent, NzHeaderComponent, NzContentComponent, NzFooterComponent, NzSiderComponent],
                        exports: [NzLayoutComponent, NzHeaderComponent, NzContentComponent, NzFooterComponent, NzSiderComponent],
                        providers: [NzMatchMediaService],
                        imports: [i1.CommonModule]
                    },] }
        ];
        return NzLayoutModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzSpinComponent = /** @class */ (function () {
        function NzSpinComponent(elementRef, renderer, zone) {
            this.elementRef = elementRef;
            this.renderer = renderer;
            this.zone = zone;
            this._delay = 0;
            this.isNested = false;
            this.baseSpinning$ = new rxjs.BehaviorSubject(true);
            this.resultSpinning$ = this.baseSpinning$.asObservable().pipe(operators.debounceTime(this.nzDelay));
            this.nzSize = 'default';
            this.el = this.elementRef.nativeElement;
        }
        Object.defineProperty(NzSpinComponent.prototype, "nzDelay", {
            get: /**
             * @return {?}
             */ function () {
                return this._delay;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (isNotNil(value)) {
                    this._delay = value;
                    this.resultSpinning$ = this.baseSpinning$.asObservable().pipe(operators.debounceTime(this.nzDelay));
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSpinComponent.prototype, "nzTip", {
            get: /**
             * @return {?}
             */ function () {
                return this._tip;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._tip = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzSpinComponent.prototype, "nzSpinning", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this.baseSpinning$.next(toBoolean(value));
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzSpinComponent.prototype.checkNested = /**
         * @return {?}
         */
            function () {
                /** no way to detect empty https://github.com/angular/angular/issues/12530 **/
                if (!isEmpty(this.containerElement.nativeElement)) {
                    this.isNested = true;
                    this.renderer.setStyle(this.el, 'display', 'block');
                }
                else {
                    this.isNested = false;
                    this.renderer.removeStyle(this.el, 'display');
                }
            };
        /**
         * @return {?}
         */
        NzSpinComponent.prototype.ngAfterViewInit = /**
         * @return {?}
         */
            function () {
                this.checkNested();
            };
        NzSpinComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-spin',
                        preserveWhitespaces: false,
                        changeDetection: i0.ChangeDetectionStrategy.OnPush,
                        template: "<ng-template #defaultIndicatorTemplate>\n  <span\n    class=\"ant-spin-dot\"\n    [class.ant-spin-dot-spin]=\"resultSpinning$|async\">\n    <i></i><i></i><i></i><i></i>\n  </span>\n</ng-template>\n<div [class.ant-spin-nested-loading]=\"isNested\">\n  <div [hidden]=\"!(resultSpinning$|async)\">\n    <div\n      class=\"ant-spin\"\n      [class.ant-spin-spinning]=\"resultSpinning$|async\"\n      [class.ant-spin-lg]=\"nzSize=='large'\"\n      [class.ant-spin-sm]=\"nzSize=='small'\"\n      [class.ant-spin-show-text]=\"nzTip\">\n      <ng-template [ngTemplateOutlet]=\"nzIndicator||defaultIndicatorTemplate\"></ng-template>\n      <div class=\"ant-spin-text\" *ngIf=\"nzTip\">{{ nzTip }}</div>\n    </div>\n  </div>\n  <div\n    #containerElement\n    class=\"ant-spin-container\"\n    [class.ant-spin-blur]=\"resultSpinning$|async\"\n    [hidden]=\"!isNested\"\n    (cdkObserveContent)=\"checkNested()\">\n    <ng-content></ng-content>\n  </div>\n</div>"
                    }] }
        ];
        /** @nocollapse */
        NzSpinComponent.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: i0.Renderer2 },
                { type: i0.NgZone }
            ];
        };
        NzSpinComponent.propDecorators = {
            containerElement: [{ type: i0.ViewChild, args: ['containerElement',] }],
            nzIndicator: [{ type: i0.Input }],
            nzSize: [{ type: i0.Input }],
            nzDelay: [{ type: i0.Input }],
            nzTip: [{ type: i0.Input }],
            nzSpinning: [{ type: i0.Input }]
        };
        return NzSpinComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzSpinModule = /** @class */ (function () {
        function NzSpinModule() {
        }
        NzSpinModule.decorators = [
            { type: i0.NgModule, args: [{
                        exports: [NzSpinComponent],
                        declarations: [NzSpinComponent],
                        imports: [i1.CommonModule, observers.ObserversModule]
                    },] }
        ];
        return NzSpinModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzListItemMetaComponent = /** @class */ (function () {
        function NzListItemMetaComponent() {
            this.isAvatar = false;
            this.avatarStr = '';
            this.isTitle = false;
            this.titleStr = '';
            this.isDesc = false;
            this.descStr = '';
        }
        Object.defineProperty(NzListItemMetaComponent.prototype, "nzAvatar", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value instanceof i0.TemplateRef) {
                    this.avatarStr = null;
                    this.avatarTpl = value;
                }
                else {
                    this.avatarStr = value;
                }
                this.isAvatar = !!value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzListItemMetaComponent.prototype, "nzTitle", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value instanceof i0.TemplateRef) {
                    this.titleStr = null;
                    this.titleTpl = value;
                }
                else {
                    this.titleStr = value;
                }
                this.isTitle = !!value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzListItemMetaComponent.prototype, "nzDescription", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value instanceof i0.TemplateRef) {
                    this.descStr = null;
                    this.descTpl = value;
                }
                else {
                    this.descStr = value;
                }
                this.isDesc = !!value;
            },
            enumerable: true,
            configurable: true
        });
        NzListItemMetaComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-list-item-meta',
                        template: "<div *ngIf=\"isAvatar\" class=\"ant-list-item-meta-avatar\">\n  <ng-container *ngIf=\"avatarStr; else avatarTpl\">\n    <nz-avatar [nzSrc]=\"avatarStr\"></nz-avatar>\n  </ng-container>\n</div>\n<div *ngIf=\"isTitle || isDesc\" class=\"ant-list-item-meta-content\">\n  <h4 *ngIf=\"isTitle\" class=\"ant-list-item-meta-title\">\n    <ng-container *ngIf=\"titleStr; else titleTpl\">{{ titleStr }}</ng-container>\n  </h4>\n  <div *ngIf=\"isDesc\" class=\"ant-list-item-meta-description\">\n    <ng-container *ngIf=\"descStr; else descTpl\">{{ descStr }}</ng-container>\n  </div>\n</div>",
                        preserveWhitespaces: false,
                        host: {
                            '[class.ant-list-item-meta]': 'true'
                        }
                    }] }
        ];
        NzListItemMetaComponent.propDecorators = {
            nzAvatar: [{ type: i0.Input }],
            nzTitle: [{ type: i0.Input }],
            nzDescription: [{ type: i0.Input }]
        };
        return NzListItemMetaComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzListItemComponent = /** @class */ (function () {
        function NzListItemComponent() {
            this.nzActions = [];
            this.isCon = false;
            this.conStr = '';
        }
        Object.defineProperty(NzListItemComponent.prototype, "nzContent", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value instanceof i0.TemplateRef) {
                    this.conStr = null;
                    this.conTpl = value;
                }
                else {
                    this.conStr = value;
                }
                this.isCon = !!value;
            },
            enumerable: true,
            configurable: true
        });
        NzListItemComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-list-item',
                        template: "<ng-template #contentTpl>\n  <div *ngIf=\"isCon\" class=\"ant-list-item-content\" [ngClass]=\"{'ant-list-item-content-single': metas.length < 1}\">\n    <ng-container *ngIf=\"conStr; else conTpl\">{{ conStr }}</ng-container>\n  </div>\n</ng-template>\n<ng-template #actionsTpl>\n  <ul *ngIf=\"nzActions?.length > 0\" class=\"ant-list-item-action\">\n    <li *ngFor=\"let i of nzActions; let idx = index\">\n      <ng-template [ngTemplateOutlet]=\"i\"></ng-template>\n      <em *ngIf=\"idx!==nzActions.length-1\" class=\"ant-list-item-action-split\"></em>\n    </li>\n  </ul>\n</ng-template>\n<ng-template #mainTpl>\n  <ng-content></ng-content>\n  <ng-template [ngTemplateOutlet]=\"contentTpl\"></ng-template>\n  <ng-template [ngTemplateOutlet]=\"actionsTpl\"></ng-template>\n</ng-template>\n<div *ngIf=\"nzExtra; else mainTpl\" class=\"ant-list-item-extra-wrap\">\n  <div class=\"ant-list-item-main\">\n    <ng-template [ngTemplateOutlet]=\"mainTpl\"></ng-template>\n  </div>\n  <div class=\"ant-list-item-extra\">\n    <ng-template [ngTemplateOutlet]=\"nzExtra\"></ng-template>\n  </div>\n</div>",
                        preserveWhitespaces: false,
                        host: {
                            '[class.ant-list-item]': 'true'
                        }
                    }] }
        ];
        NzListItemComponent.propDecorators = {
            nzActions: [{ type: i0.Input }],
            metas: [{ type: i0.ContentChildren, args: [NzListItemMetaComponent,] }],
            nzContent: [{ type: i0.Input }],
            nzExtra: [{ type: i0.Input }]
        };
        return NzListItemComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzListComponent = /** @class */ (function () {
        // endregion
        function NzListComponent(el, cd, updateHostClassService) {
            this.el = el;
            this.cd = cd;
            this.updateHostClassService = updateHostClassService;
            // region: fields
            this.nzDataSource = [];
            this._bordered = false;
            this._isHeader = false;
            this._header = '';
            this._isFooter = false;
            this._footer = '';
            this.nzItemLayout = 'horizontal';
            this._loading = false;
            this.nzSize = 'default';
            this._split = true;
            this.prefixCls = 'ant-list';
        }
        Object.defineProperty(NzListComponent.prototype, "nzBordered", {
            get: /**
             * @return {?}
             */ function () {
                return this._bordered;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._bordered = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzListComponent.prototype, "nzHeader", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value instanceof i0.TemplateRef) {
                    this._header = null;
                    this._headerTpl = value;
                }
                else {
                    this._header = value;
                }
                this._isHeader = !!value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzListComponent.prototype, "nzFooter", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value instanceof i0.TemplateRef) {
                    this._footer = null;
                    this._footerTpl = value;
                }
                else {
                    this._footer = value;
                }
                this._isFooter = !!value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzListComponent.prototype, "nzLoading", {
            get: /**
             * @return {?}
             */ function () {
                return this._loading;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._loading = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzListComponent.prototype, "nzSplit", {
            get: /**
             * @return {?}
             */ function () {
                return this._split;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._split = toBoolean(value);
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzListComponent.prototype._setClassMap = /**
         * @return {?}
         */
            function () {
                var _a;
                /** @type {?} */
                var classMap = (_a = {},
                    _a[this.prefixCls] = true,
                    _a[this.prefixCls + "-vertical"] = this.nzItemLayout === 'vertical',
                    _a[this.prefixCls + "-lg"] = this.nzSize === 'large',
                    _a[this.prefixCls + "-sm"] = this.nzSize === 'small',
                    _a[this.prefixCls + "-split"] = this.nzSplit,
                    _a[this.prefixCls + "-bordered"] = this.nzBordered,
                    _a[this.prefixCls + "-loading"] = this.nzLoading,
                    _a[this.prefixCls + "-grid"] = this.nzGrid,
                    _a[this.prefixCls + "-something-after-last-item"] = !!(this.nzLoadMore || this.nzPagination || this._isFooter),
                    _a);
                this.updateHostClassService.updateHostClass(this.el.nativeElement, classMap);
                this.cd.detectChanges();
            };
        /**
         * @param {?} changes
         * @return {?}
         */
        NzListComponent.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                this._setClassMap();
            };
        NzListComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-list',
                        template: "<ng-template #itemsTpl>\n  <ng-container *ngFor=\"let item of nzDataSource; let index = index\">\n    <ng-template\n      [ngTemplateOutlet]=\"nzRenderItem\"\n      [ngTemplateOutletContext]=\"{ $implicit: item, index: index }\"></ng-template>\n  </ng-container>\n</ng-template>\n<div *ngIf=\"_isHeader\" class=\"ant-list-header\">\n  <ng-container *ngIf=\"_header; else _headerTpl\">{{ _header }}</ng-container>\n</div>\n<nz-spin [nzSpinning]=\"nzLoading\">\n  <div *ngIf=\"nzLoading && nzDataSource.length === 0\" [style.min-height.px]=\"53\"></div>\n  <div *ngIf=\"nzGrid; else itemsTpl\" nz-row [nzGutter]=\"nzGrid.gutter\">\n    <div nz-col [nzSpan]=\"nzGrid.span\" [nzXs]=\"nzGrid.xs\" [nzSm]=\"nzGrid.sm\" [nzMd]=\"nzGrid.md\" [nzLg]=\"nzGrid.lg\" [nzXl]=\"nzGrid.xl\" [nzXXl]=\"nzGrid.xxl\"\n      *ngFor=\"let item of nzDataSource; let index = index\">\n      <ng-template\n        [ngTemplateOutlet]=\"nzRenderItem\"\n        [ngTemplateOutletContext]=\"{ $implicit: item, index: index }\"></ng-template>\n    </div>\n  </div>\n</nz-spin>\n<ng-template [ngTemplateOutlet]=\"nzLoadMore\"></ng-template>\n<ng-content></ng-content>\n<div *ngIf=\"nzPagination\" class=\"ant-list-pagination\">\n  <ng-template [ngTemplateOutlet]=\"nzPagination\"></ng-template>\n</div>\n<div *ngIf=\"_isFooter\" class=\"ant-list-footer\">\n  <ng-container *ngIf=\"_footer; else _footerTpl\">{{ _footer }}</ng-container>\n</div>",
                        providers: [NzUpdateHostClassService],
                        preserveWhitespaces: false,
                        changeDetection: i0.ChangeDetectionStrategy.OnPush,
                        styles: ["\n    :host {\n      display: block;\n    }\n\n    nz-spin {\n      display: block;\n    }\n  "]
                    }] }
        ];
        /** @nocollapse */
        NzListComponent.ctorParameters = function () {
            return [
                { type: i0.ElementRef },
                { type: i0.ChangeDetectorRef },
                { type: NzUpdateHostClassService }
            ];
        };
        NzListComponent.propDecorators = {
            nzDataSource: [{ type: i0.Input }],
            nzBordered: [{ type: i0.Input }],
            nzGrid: [{ type: i0.Input }],
            nzHeader: [{ type: i0.Input }],
            nzFooter: [{ type: i0.Input }],
            nzItemLayout: [{ type: i0.Input }],
            nzRenderItem: [{ type: i0.Input }],
            nzLoading: [{ type: i0.Input }],
            nzLoadMore: [{ type: i0.Input }],
            nzPagination: [{ type: i0.Input }],
            nzSize: [{ type: i0.Input }],
            nzSplit: [{ type: i0.Input }]
        };
        return NzListComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzListModule = /** @class */ (function () {
        function NzListModule() {
        }
        NzListModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [i1.CommonModule, NzSpinModule, NzGridModule, NzAvatarModule],
                        declarations: [NzListComponent, NzListItemComponent, NzListItemMetaComponent],
                        exports: [NzListComponent, NzListItemComponent, NzListItemMetaComponent]
                    },] }
        ];
        return NzListModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzMentionSuggestionDirective = /** @class */ (function () {
        function NzMentionSuggestionDirective() {
        }
        NzMentionSuggestionDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: '[nzMentionSuggestion]'
                    },] }
        ];
        return NzMentionSuggestionDirective;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var NZ_MENTION_TRIGGER_ACCESSOR = {
        provide: forms.NG_VALUE_ACCESSOR,
        useExisting: i0.forwardRef(function () { return NzMentionTriggerDirective; }),
        multi: true
    };
    var NzMentionTriggerDirective = /** @class */ (function () {
        function NzMentionTriggerDirective(el) {
            this.el = el;
            this.onFocusin = new i0.EventEmitter();
            this.onBlur = new i0.EventEmitter();
            this.onInput = new i0.EventEmitter();
            this.onKeydown = new i0.EventEmitter();
            this.onClick = new i0.EventEmitter();
        }
        /**
         * @return {?}
         */
        NzMentionTriggerDirective.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.completeEvents();
            };
        /**
         * @return {?}
         */
        NzMentionTriggerDirective.prototype.completeEvents = /**
         * @return {?}
         */
            function () {
                this.onFocusin.complete();
                this.onBlur.complete();
                this.onInput.complete();
                this.onKeydown.complete();
                this.onClick.complete();
            };
        /**
         * @param {?=} caretPos
         * @return {?}
         */
        NzMentionTriggerDirective.prototype.focus = /**
         * @param {?=} caretPos
         * @return {?}
         */
            function (caretPos) {
                this.el.nativeElement.focus();
                this.el.nativeElement.setSelectionRange(caretPos, caretPos);
            };
        /**
         * @param {?} mention
         * @return {?}
         */
        NzMentionTriggerDirective.prototype.insertMention = /**
         * @param {?} mention
         * @return {?}
         */
            function (mention) {
                /** @type {?} */
                var value = this.el.nativeElement.value;
                /** @type {?} */
                var insertValue = mention.mention.trim() + ' ';
                /** @type {?} */
                var newValue = [
                    value.slice(0, mention.startPos + 1),
                    insertValue,
                    value.slice(mention.endPos, value.length)
                ].join('');
                this.el.nativeElement.value = newValue;
                this.focus(mention.startPos + insertValue.length + 1);
                this.onChange(newValue);
                this.value = newValue;
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzMentionTriggerDirective.prototype.writeValue = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.value = value;
                if (typeof value === 'string') {
                    this.el.nativeElement.value = value;
                }
                else {
                    this.el.nativeElement.value = '';
                }
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzMentionTriggerDirective.prototype.registerOnChange = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onChange = fn;
            };
        /**
         * @param {?} fn
         * @return {?}
         */
        NzMentionTriggerDirective.prototype.registerOnTouched = /**
         * @param {?} fn
         * @return {?}
         */
            function (fn) {
                this.onTouched = fn;
            };
        NzMentionTriggerDirective.decorators = [
            { type: i0.Directive, args: [{
                        selector: 'input[nzMentionTrigger], textarea[nzMentionTrigger]',
                        providers: [NZ_MENTION_TRIGGER_ACCESSOR],
                        host: {
                            'autocomplete': 'off',
                            '(focusin)': 'onFocusin.emit()',
                            '(blur)': 'onBlur.emit()',
                            '(input)': 'onInput.emit($event)',
                            '(keydown)': 'onKeydown.emit($event)',
                            '(click)': 'onClick.emit($event)'
                        }
                    },] }
        ];
        /** @nocollapse */
        NzMentionTriggerDirective.ctorParameters = function () {
            return [
                { type: i0.ElementRef }
            ];
        };
        return NzMentionTriggerDirective;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * @param {?} prefix
     * @return {?}
     */
    function getRegExp(prefix) {
        /** @type {?} */
        var prefixArray = Array.isArray(prefix) ? prefix : [prefix];
        /** @type {?} */
        var prefixToken = prefixArray.join('').replace(/(\$|\^)/g, '\\$1');
        if (prefixArray.length > 1) {
            prefixToken = "[" + prefixToken + "]";
        }
        return new RegExp("(\\s|^)(" + prefixToken + ")[^\\s]*", 'g');
    }
    /**
     * @param {?} value
     * @param {?=} prefix
     * @return {?}
     */
    function getMentions(value, prefix) {
        if (prefix === void 0) {
            prefix = '@';
        }
        if (typeof value !== 'string') {
            return [];
        }
        /** @type {?} */
        var regex = getRegExp(prefix);
        /** @type {?} */
        var mentions = value.match(regex);
        return mentions !== null ? mentions.map(function (e) { return e.trim(); }) : [];
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    // from https://github.com/component/textarea-caret-position
    /** @type {?} */
    var properties = [
        'direction',
        'boxSizing',
        'width',
        'height',
        'overflowX',
        'overflowY',
        'borderTopWidth',
        'borderRightWidth',
        'borderBottomWidth',
        'borderLeftWidth',
        'borderStyle',
        'paddingTop',
        'paddingRight',
        'paddingBottom',
        'paddingLeft',
        'fontStyle',
        'fontVariant',
        'fontWeight',
        'fontStretch',
        'fontSize',
        'fontSizeAdjust',
        'lineHeight',
        'fontFamily',
        'textAlign',
        'textTransform',
        'textIndent',
        'textDecoration',
        'letterSpacing',
        'wordSpacing',
        'tabSize',
        'MozTabSize'
    ];
    /** @type {?} */
    var isBrowser = (typeof window !== 'undefined');
    /** @type {?} */
    var isFirefox = (isBrowser && ( /** @type {?} */(window)).mozInnerScreenX != null);
    /** @type {?} */
    var _parseInt = function (str) { return parseInt(str, 10); };
    /**
     * @param {?} element
     * @param {?} position
     * @param {?=} options
     * @return {?}
     */
    function getCaretCoordinates(element, position, options) {
        if (!isBrowser) {
            throw new Error('textarea-caret-position#getCaretCoordinates should only be called in a browser');
        }
        /** @type {?} */
        var debug = options && options.debug || false;
        if (debug) {
            /** @type {?} */
            var el = document.querySelector('#input-textarea-caret-position-mirror-div');
            if (el) {
                el.parentNode.removeChild(el);
            }
        }
        /** @type {?} */
        var div = document.createElement('div');
        div.id = 'input-textarea-caret-position-mirror-div';
        document.body.appendChild(div);
        /** @type {?} */
        var style = div.style;
        /** @type {?} */
        var computed = window.getComputedStyle ? window.getComputedStyle(element) : ( /** @type {?} */(element)).currentStyle;
        /** @type {?} */
        var isInput = element.nodeName === 'INPUT';
        // Default textarea styles
        style.whiteSpace = 'pre-wrap';
        if (!isInput) {
            style.wordWrap = 'break-word'; // only for textarea-s
        }
        // Position off-screen
        style.position = 'absolute'; // required to return coordinates properly
        if (!debug) {
            style.visibility = 'hidden';
        } // not 'display: none' because we want rendering
        // Transfer the element's properties to the div
        properties.forEach(function (prop) {
            if (isInput && prop === 'lineHeight') {
                // Special case for <input>s because text is rendered centered and line height may be != height
                style.lineHeight = computed.height;
            }
            else {
                style[prop] = computed[prop];
            }
        });
        if (isFirefox) {
            // Firefox lies about the overflow property for textareas: https://bugzilla.mozilla.org/show_bug.cgi?id=984275
            if (element.scrollHeight > _parseInt(computed.height)) {
                style.overflowY = 'scroll';
            }
        }
        else {
            style.overflow = 'hidden'; // for Chrome to not render a scrollbar; IE keeps overflowY = 'scroll'
        }
        div.textContent = element.value.substring(0, position);
        // The second special handling for input type="text" vs textarea:
        // spaces need to be replaced with non-breaking spaces - http://stackoverflow.com/a/13402035/1269037
        if (isInput) {
            div.textContent = div.textContent.replace(/\s/g, '\u00a0');
        }
        /** @type {?} */
        var span = document.createElement('span');
        // Wrapping must be replicated *exactly*, including when a long word gets
        // onto the next line, with whitespace at the end of the line before (#7).
        // The  *only* reliable way to do that is to copy the *entire* rest of the
        // textarea's content into the <span> created at the caret position.
        // For inputs, just '.' would be enough, but no need to bother.
        span.textContent = element.value.substring(position) || '.'; // || because a completely empty faux span doesn't render at all
        div.appendChild(span);
        /** @type {?} */
        var coordinates = {
            top: span.offsetTop + _parseInt(computed.borderTopWidth),
            left: span.offsetLeft + _parseInt(computed.borderLeftWidth),
            height: _parseInt(computed.lineHeight)
        };
        if (debug) {
            span.style.backgroundColor = '#eee';
            createDebugEle(element, coordinates);
        }
        else {
            document.body.removeChild(div);
        }
        return coordinates;
    }
    /**
     * @param {?} element
     * @param {?} coordinates
     * @return {?}
     */
    function createDebugEle(element, coordinates) {
        /** @type {?} */
        var fontSize = getComputedStyle(element).getPropertyValue('font-size');
        /** @type {?} */
        var rect = ( /** @type {?} */(document.querySelector('#DEBUG')))
            || document.createElement('div');
        document.body.appendChild(rect);
        rect.id = 'DEBUG';
        rect.style.position = 'absolute';
        rect.style.backgroundColor = 'red';
        rect.style.height = fontSize;
        rect.style.width = '1px';
        rect.style.top = element.getBoundingClientRect().top - element.scrollTop + window.pageYOffset + coordinates.top + "px";
        rect.style.left = element.getBoundingClientRect().left - element.scrollLeft + window.pageXOffset + coordinates.left + "px";
        console.log(rect.style.top);
        console.log(rect.style.left);
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzMentionComponent = /** @class */ (function () {
        function NzMentionComponent(document, ngZone, overlay, viewContainerRef) {
            this.document = document;
            this.ngZone = ngZone;
            this.overlay = overlay;
            this.viewContainerRef = viewContainerRef;
            this.nzOnSelect = new i0.EventEmitter();
            this.nzOnSearchChange = new i0.EventEmitter();
            this.nzValueWith = function (value) { return value; };
            this.nzPrefix = '@';
            this.nzLoading = false;
            this.nzNotFoundContent = '无匹配结果，轻敲空格完成输入';
            this.isOpen = false;
            this.suggestionTemplate = null;
            this.activeIndex = -1;
            this._placement = 'bottom';
        }
        Object.defineProperty(NzMentionComponent.prototype, "nzSuggestions", {
            get: /**
             * @return {?}
             */ function () {
                return this._suggestions;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._suggestions = value;
                if (this.isOpen) {
                    this.previousValue = null;
                    this.activeIndex = -1;
                    this.resetDropdown(false);
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzMentionComponent.prototype, "nzPlacement", {
            get: /**
             * @return {?}
             */ function () {
                return this._placement;
            },
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                this._placement = value;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzMentionComponent.prototype, "suggestionChild", {
            set: /**
             * @param {?} value
             * @return {?}
             */ function (value) {
                if (value) {
                    this.suggestionTemplate = value;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzMentionComponent.prototype, "triggerNativeElement", {
            get: /**
             * @return {?}
             */ function () {
                return this.trigger.el.nativeElement;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzMentionComponent.prototype.ngAfterContentInit = /**
         * @return {?}
         */
            function () {
                this.bindTriggerEvents();
            };
        /**
         * @return {?}
         */
        NzMentionComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.closeDropdown();
            };
        /**
         * @return {?}
         */
        NzMentionComponent.prototype.closeDropdown = /**
         * @return {?}
         */
            function () {
                if (this.overlayRef && this.overlayRef.hasAttached()) {
                    this.overlayRef.detach();
                    this.overlayBackdropClickSubscription.unsubscribe();
                    this.isOpen = false;
                }
            };
        /**
         * @return {?}
         */
        NzMentionComponent.prototype.openDropdown = /**
         * @return {?}
         */
            function () {
                this.attachOverlay();
                this.isOpen = true;
            };
        /**
         * @return {?}
         */
        NzMentionComponent.prototype.getMentions = /**
         * @return {?}
         */
            function () {
                return getMentions(this.trigger.value, this.nzPrefix);
            };
        /**
         * @param {?} suggestion
         * @return {?}
         */
        NzMentionComponent.prototype.selectSuggestion = /**
         * @param {?} suggestion
         * @return {?}
         */
            function (suggestion) {
                /** @type {?} */
                var value = this.nzValueWith(suggestion);
                this.trigger.insertMention({
                    mention: value,
                    startPos: this.cursorMentionStart,
                    endPos: this.cursorMentionEnd
                });
                this.nzOnSelect.emit(suggestion);
                this.closeDropdown();
                this.activeIndex = -1;
            };
        /**
         * @param {?} event
         * @return {?}
         */
        NzMentionComponent.prototype.handleInput = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                /** @type {?} */
                var target = /** @type {?} */ (event.target);
                this.trigger.onChange(target.value);
                this.trigger.value = target.value;
                this.resetDropdown();
            };
        /**
         * @param {?} event
         * @return {?}
         */
        NzMentionComponent.prototype.handleKeydown = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                /** @type {?} */
                var keyCode = event.keyCode;
                if (this.isOpen && keyCode === keycodes.ENTER && this.activeIndex !== -1 && this.filteredSuggestions.length) {
                    this.selectSuggestion(this.filteredSuggestions[this.activeIndex]);
                    event.preventDefault();
                }
                else if (keyCode === keycodes.LEFT_ARROW || keyCode === keycodes.RIGHT_ARROW) {
                    this.resetDropdown();
                    event.stopPropagation();
                }
                else {
                    if (this.isOpen && (keyCode === keycodes.TAB || keyCode === keycodes.ESCAPE)) {
                        this.closeDropdown();
                        return;
                    }
                    if (this.isOpen && (keyCode === keycodes.UP_ARROW)) {
                        this.setPreviousItemActive();
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    if (this.isOpen && (keyCode === keycodes.DOWN_ARROW)) {
                        this.setNextItemActive();
                        event.preventDefault();
                        event.stopPropagation();
                    }
                }
            };
        /**
         * @return {?}
         */
        NzMentionComponent.prototype.handleClick = /**
         * @return {?}
         */
            function () {
                this.resetDropdown();
            };
        /**
         * @return {?}
         */
        NzMentionComponent.prototype.bindTriggerEvents = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.trigger.onInput.subscribe(function (e) { return _this.handleInput(e); });
                this.trigger.onKeydown.subscribe(function (e) { return _this.handleKeydown(e); });
                this.trigger.onClick.subscribe(function () { return _this.handleClick(); });
            };
        /**
         * @param {?} value
         * @param {?} emit
         * @return {?}
         */
        NzMentionComponent.prototype.suggestionsFilter = /**
         * @param {?} value
         * @param {?} emit
         * @return {?}
         */
            function (value, emit) {
                var _this = this;
                /** @type {?} */
                var suggestions = value.substring(1);
                if (this.previousValue === value) {
                    return;
                }
                this.previousValue = value;
                if (emit) {
                    this.nzOnSearchChange.emit({
                        value: this.cursorMention.substring(1),
                        prefix: this.cursorMention[0]
                    });
                }
                /** @type {?} */
                var searchValue = suggestions.toLowerCase();
                this.filteredSuggestions = this.nzSuggestions
                    .filter(function (suggestion) { return _this.nzValueWith(suggestion).toLowerCase().includes(searchValue); });
            };
        /**
         * @param {?=} emit
         * @return {?}
         */
        NzMentionComponent.prototype.resetDropdown = /**
         * @param {?=} emit
         * @return {?}
         */
            function (emit) {
                if (emit === void 0) {
                    emit = true;
                }
                this.resetCursorMention();
                if (typeof this.cursorMention !== 'string' || !this.canOpen()) {
                    this.closeDropdown();
                    return;
                }
                this.suggestionsFilter(this.cursorMention, emit);
                /** @type {?} */
                var activeIndex = this.filteredSuggestions.indexOf(this.cursorMention.substring(1));
                this.activeIndex = activeIndex >= 0 ? activeIndex : 0;
                this.openDropdown();
            };
        /**
         * @return {?}
         */
        NzMentionComponent.prototype.setNextItemActive = /**
         * @return {?}
         */
            function () {
                this.activeIndex = this.activeIndex + 1 <= this.filteredSuggestions.length - 1
                    ? this.activeIndex + 1
                    : 0;
            };
        /**
         * @return {?}
         */
        NzMentionComponent.prototype.setPreviousItemActive = /**
         * @return {?}
         */
            function () {
                this.activeIndex = this.activeIndex - 1 < 0
                    ? this.filteredSuggestions.length - 1
                    : this.activeIndex - 1;
            };
        /**
         * @return {?}
         */
        NzMentionComponent.prototype.canOpen = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var element = this.triggerNativeElement;
                return !element.readOnly && !element.disabled;
            };
        /**
         * @return {?}
         */
        NzMentionComponent.prototype.resetCursorMention = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var value = this.triggerNativeElement.value.replace(/[\r\n]/g, ' ') || '';
                /** @type {?} */
                var selectionStart = this.triggerNativeElement.selectionStart;
                /** @type {?} */
                var prefix = typeof this.nzPrefix === 'string' ? [this.nzPrefix] : this.nzPrefix;
                /** @type {?} */
                var i = prefix.length;
                while (i >= 0) {
                    /** @type {?} */
                    var startPos = value.lastIndexOf(prefix[i], selectionStart);
                    /** @type {?} */
                    var endPos = value.indexOf(' ', selectionStart) > -1 ? value.indexOf(' ', selectionStart) : value.length;
                    /** @type {?} */
                    var mention = value.substring(startPos, endPos);
                    if ((startPos > 0 && value[startPos - 1] !== ' ')
                        || startPos < 0
                        || mention.includes(prefix[i], 1)
                        || mention.includes(' ')) {
                        this.cursorMention = null;
                        this.cursorMentionStart = -1;
                        this.cursorMentionEnd = -1;
                    }
                    else {
                        this.cursorMention = mention;
                        this.cursorMentionStart = startPos;
                        this.cursorMentionEnd = endPos;
                        return;
                    }
                    i--;
                }
            };
        /**
         * @return {?}
         */
        NzMentionComponent.prototype.updatePositions = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var coordinates = getCaretCoordinates(this.triggerNativeElement, this.cursorMentionStart);
                /** @type {?} */
                var top = coordinates.top
                    - this.triggerNativeElement.getBoundingClientRect().height
                    - this.triggerNativeElement.scrollTop
                    + (this.nzPlacement === 'bottom' ? coordinates.height : 0);
                /** @type {?} */
                var left = coordinates.left - this.triggerNativeElement.scrollLeft;
                this.positionStrategy.withDefaultOffsetX(left).withDefaultOffsetY(top);
                if (this.nzPlacement === 'bottom') {
                    this.positionStrategy.withPositions([DEFAULT_MENTION_POSITIONS[0]]);
                }
                if (this.nzPlacement === 'top') {
                    this.positionStrategy.withPositions([DEFAULT_MENTION_POSITIONS[1]]);
                }
                this.positionStrategy.apply();
            };
        /**
         * @return {?}
         */
        NzMentionComponent.prototype.subscribeOverlayBackdropClick = /**
         * @return {?}
         */
            function () {
                var _this = this;
                return rxjs.merge(rxjs.fromEvent(this.document, 'click'), rxjs.fromEvent(this.document, 'touchend'))
                    .subscribe(function (event) {
                    /** @type {?} */
                    var clickTarget = /** @type {?} */ (event.target);
                    if (clickTarget !== _this.trigger.el.nativeElement && _this.isOpen) {
                        _this.closeDropdown();
                    }
                });
            };
        /**
         * @return {?}
         */
        NzMentionComponent.prototype.attachOverlay = /**
         * @return {?}
         */
            function () {
                if (!this.overlayRef) {
                    this.portal = new portal.TemplatePortal(this.suggestionsTemp, this.viewContainerRef);
                    this.overlayRef = this.overlay.create(this.getOverlayConfig());
                }
                if (this.overlayRef && !this.overlayRef.hasAttached()) {
                    this.overlayRef.attach(this.portal);
                    this.overlayBackdropClickSubscription = this.subscribeOverlayBackdropClick();
                }
                this.updatePositions();
            };
        /**
         * @return {?}
         */
        NzMentionComponent.prototype.getOverlayConfig = /**
         * @return {?}
         */
            function () {
                return new i2.OverlayConfig({
                    positionStrategy: this.getOverlayPosition(),
                    scrollStrategy: this.overlay.scrollStrategies.reposition()
                });
            };
        /**
         * @return {?}
         */
        NzMentionComponent.prototype.getOverlayPosition = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var positions = [
                    new i2.ConnectionPositionPair({ originX: 'start', originY: 'bottom' }, { overlayX: 'start', overlayY: 'top' }),
                    new i2.ConnectionPositionPair({ originX: 'start', originY: 'top' }, { overlayX: 'start', overlayY: 'bottom' })
                ];
                this.positionStrategy = this.overlay.position()
                    .flexibleConnectedTo(this.trigger.el)
                    .withPositions(positions)
                    .withFlexibleDimensions(false)
                    .withPush(false);
                return this.positionStrategy;
            };
        NzMentionComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-mention',
                        template: "<ng-content></ng-content>\n<ng-template #suggestions>\n  <ul class=\"ant-mention-dropdown\">\n    <li class=\"ant-mention-dropdown-item\"\n        *ngFor=\"let suggestion of filteredSuggestions; let i = index\"\n        [class.focus]=\"i === activeIndex\"\n        (click)=\"selectSuggestion(suggestion)\">\n      <ng-container *ngIf=\"suggestionTemplate else defaultSuggestion\">\n        <ng-container *ngTemplateOutlet=\"suggestionTemplate; context: {$implicit: suggestion}\"></ng-container>\n      </ng-container>\n      <ng-template #defaultSuggestion>{{ nzValueWith(suggestion) }}</ng-template>\n    </li>\n    <li class=\"ant-mention-dropdown-notfound ant-mention-dropdown-item\"\n        *ngIf=\"filteredSuggestions.length === 0\">\n      <span *ngIf=\"nzLoading\"><i class=\"anticon anticon-spin anticon-loading\"></i></span>\n      <span *ngIf=\"!nzLoading\">{{ nzNotFoundContent }}</span>\n    </li>\n  </ul>\n</ng-template>\n",
                        preserveWhitespaces: false,
                        styles: ["\n    .ant-mention-dropdown {\n      top: 100%;\n      left: 0;\n      position: relative;\n      width: 100%;\n      margin-top: 4px;\n      margin-bottom: 4px;\n    }\n  "]
                    }] }
        ];
        /** @nocollapse */
        NzMentionComponent.ctorParameters = function () {
            return [
                { type: undefined, decorators: [{ type: i0.Optional }, { type: i0.Inject, args: [i1.DOCUMENT,] }] },
                { type: i0.NgZone },
                { type: i2.Overlay },
                { type: i0.ViewContainerRef }
            ];
        };
        NzMentionComponent.propDecorators = {
            nzOnSelect: [{ type: i0.Output }],
            nzOnSearchChange: [{ type: i0.Output }],
            nzValueWith: [{ type: i0.Input }],
            nzPrefix: [{ type: i0.Input }],
            nzLoading: [{ type: i0.Input }],
            nzNotFoundContent: [{ type: i0.Input }],
            nzSuggestions: [{ type: i0.Input }],
            nzPlacement: [{ type: i0.Input }],
            trigger: [{ type: i0.ContentChild, args: [NzMentionTriggerDirective,] }],
            suggestionsTemp: [{ type: i0.ViewChild, args: [i0.TemplateRef,] }],
            suggestionChild: [{ type: i0.ContentChild, args: [NzMentionSuggestionDirective, { read: i0.TemplateRef },] }]
        };
        return NzMentionComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var COMPONENTS = [NzMentionComponent, NzMentionTriggerDirective, NzMentionSuggestionDirective];
    var NzMentionModule = /** @class */ (function () {
        function NzMentionModule() {
        }
        NzMentionModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [i1.CommonModule, forms.FormsModule, i2.OverlayModule],
                        declarations: __spread(COMPONENTS),
                        exports: __spread(COMPONENTS)
                    },] }
        ];
        return NzMentionModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var NZ_MESSAGE_DEFAULT_CONFIG = new i0.InjectionToken('NZ_MESSAGE_DEFAULT_CONFIG');
    /** @type {?} */
    var NZ_MESSAGE_CONFIG = new i0.InjectionToken('NZ_MESSAGE_CONFIG');
    /** @type {?} */
    var NZ_MESSAGE_DEFAULT_CONFIG_PROVIDER = {
        provide: NZ_MESSAGE_DEFAULT_CONFIG,
        useValue: {
            nzDuration: 3000,
            nzAnimate: true,
            nzPauseOnHover: true,
            nzMaxStack: 7
        }
    };

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzMessageContainerComponent = /** @class */ (function () {
        function NzMessageContainerComponent(defaultConfig, config) {
            this.messages = [];
            this.config = {};
            this.setConfig(__assign({}, defaultConfig, config));
        }
        /**
         * @param {?} config
         * @return {?}
         */
        NzMessageContainerComponent.prototype.setConfig = /**
         * @param {?} config
         * @return {?}
         */
            function (config) {
                this.config = __assign({}, this.config, config);
            };
        // Create a new message
        /**
         * @param {?} message
         * @return {?}
         */
        NzMessageContainerComponent.prototype.createMessage = /**
         * @param {?} message
         * @return {?}
         */
            function (message) {
                if (this.messages.length >= this.config.nzMaxStack) {
                    this.messages.splice(0, 1);
                }
                message.options = this._mergeMessageOptions(message.options);
                this.messages.push(message);
            };
        // Remove a message by messageId
        /**
         * @param {?} messageId
         * @return {?}
         */
        NzMessageContainerComponent.prototype.removeMessage = /**
         * @param {?} messageId
         * @return {?}
         */
            function (messageId) {
                var _this = this;
                this.messages.some(function (message, index) {
                    if (message.messageId === messageId) {
                        _this.messages.splice(index, 1);
                        return true;
                    }
                });
            };
        // Remove all messages
        /**
         * @return {?}
         */
        NzMessageContainerComponent.prototype.removeMessageAll = /**
         * @return {?}
         */
            function () {
                this.messages = [];
            };
        // Merge default options and cutom message options
        /**
         * @param {?} options
         * @return {?}
         */
        NzMessageContainerComponent.prototype._mergeMessageOptions = /**
         * @param {?} options
         * @return {?}
         */
            function (options) {
                /** @type {?} */
                var defaultOptions = {
                    nzDuration: this.config.nzDuration,
                    nzAnimate: this.config.nzAnimate,
                    nzPauseOnHover: this.config.nzPauseOnHover
                };
                return __assign({}, defaultOptions, options);
            };
        NzMessageContainerComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-message-container',
                        preserveWhitespaces: false,
                        template: "<div class=\"ant-message\">\n  <nz-message *ngFor=\"let message of messages; let i = index\" [nzMessage]=\"message\" [nzIndex]=\"i\"></nz-message>\n</div>"
                    }] }
        ];
        /** @nocollapse */
        NzMessageContainerComponent.ctorParameters = function () {
            return [
                { type: undefined, decorators: [{ type: i0.Optional }, { type: i0.Inject, args: [NZ_MESSAGE_DEFAULT_CONFIG,] }] },
                { type: undefined, decorators: [{ type: i0.Optional }, { type: i0.Inject, args: [NZ_MESSAGE_CONFIG,] }] }
            ];
        };
        return NzMessageContainerComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzMessageComponent = /** @class */ (function () {
        function NzMessageComponent(_messageContainer) {
            this._messageContainer = _messageContainer;
            this._eraseTimer = null;
        }
        /**
         * @return {?}
         */
        NzMessageComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this._options = this.nzMessage.options;
                if (this._options.nzAnimate) {
                    this.nzMessage.state = 'enter';
                }
                this._autoErase = this._options.nzDuration > 0;
                if (this._autoErase) {
                    this._initErase();
                    this._startEraseTimeout();
                }
            };
        /**
         * @return {?}
         */
        NzMessageComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                if (this._autoErase) {
                    this._clearEraseTimeout();
                }
            };
        /**
         * @return {?}
         */
        NzMessageComponent.prototype.onEnter = /**
         * @return {?}
         */
            function () {
                if (this._autoErase && this._options.nzPauseOnHover) {
                    this._clearEraseTimeout();
                    this._updateTTL();
                }
            };
        /**
         * @return {?}
         */
        NzMessageComponent.prototype.onLeave = /**
         * @return {?}
         */
            function () {
                if (this._autoErase && this._options.nzPauseOnHover) {
                    this._startEraseTimeout();
                }
            };
        // Remove self
        /**
         * @return {?}
         */
        NzMessageComponent.prototype._destroy = /**
         * @return {?}
         */
            function () {
                var _this = this;
                if (this._options.nzAnimate) {
                    this.nzMessage.state = 'leave';
                    setTimeout(function () { return _this._messageContainer.removeMessage(_this.nzMessage.messageId); }, 200);
                }
                else {
                    this._messageContainer.removeMessage(this.nzMessage.messageId);
                }
            };
        /**
         * @return {?}
         */
        NzMessageComponent.prototype._initErase = /**
         * @return {?}
         */
            function () {
                this._eraseTTL = this._options.nzDuration;
                this._eraseTimingStart = Date.now();
            };
        /**
         * @return {?}
         */
        NzMessageComponent.prototype._updateTTL = /**
         * @return {?}
         */
            function () {
                if (this._autoErase) {
                    this._eraseTTL -= Date.now() - this._eraseTimingStart;
                }
            };
        /**
         * @return {?}
         */
        NzMessageComponent.prototype._startEraseTimeout = /**
         * @return {?}
         */
            function () {
                var _this = this;
                if (this._eraseTTL > 0) {
                    this._clearEraseTimeout(); // To prevent calling _startEraseTimeout() more times to create more timer
                    this._eraseTimer = window.setTimeout(function () { return _this._destroy(); }, this._eraseTTL);
                    this._eraseTimingStart = Date.now();
                }
                else {
                    this._destroy();
                }
            };
        /**
         * @return {?}
         */
        NzMessageComponent.prototype._clearEraseTimeout = /**
         * @return {?}
         */
            function () {
                if (this._eraseTimer !== null) {
                    window.clearTimeout(this._eraseTimer);
                    this._eraseTimer = null;
                }
            };
        NzMessageComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-message',
                        preserveWhitespaces: false,
                        animations: [
                            animations.trigger('enterLeave', [
                                animations.state('enter', animations.style({ opacity: 1, transform: 'translateY(0)' })),
                                animations.transition('* => enter', [
                                    animations.style({ opacity: 0, transform: 'translateY(-50%)' }),
                                    animations.animate('100ms linear')
                                ]),
                                animations.state('leave', animations.style({ opacity: 0, transform: 'translateY(-50%)' })),
                                animations.transition('* => leave', [
                                    animations.style({ opacity: 1, transform: 'translateY(0)' }),
                                    animations.animate('100ms linear')
                                ])
                            ])
                        ],
                        template: "<div class=\"ant-message-notice\"\n  [@enterLeave]=\"nzMessage.state\"\n  (mouseenter)=\"onEnter()\"\n  (mouseleave)=\"onLeave()\">\n  <div class=\"ant-message-notice-content\">\n    <div class=\"ant-message-custom-content\" [ngClass]=\"'ant-message-' + nzMessage.type\">\n      <ng-container [ngSwitch]=\"nzMessage.type\">\n        <i *ngSwitchCase=\"'success'\" class=\"anticon anticon-check-circle\"></i>\n        <i *ngSwitchCase=\"'info'\" class=\"anticon anticon-info-circle\"></i>\n        <i *ngSwitchCase=\"'warning'\" class=\"anticon anticon-exclamation-circle\"></i>\n        <i *ngSwitchCase=\"'error'\" class=\"anticon anticon-cross-circle\"></i>\n        <i *ngSwitchCase=\"'loading'\" class=\"anticon anticon-spin anticon-loading\"></i>\n      </ng-container>\n      <span [innerHTML]=\"nzMessage.content\"></span>\n    </div>\n  </div>\n</div>"
                    }] }
        ];
        /** @nocollapse */
        NzMessageComponent.ctorParameters = function () {
            return [
                { type: NzMessageContainerComponent }
            ];
        };
        NzMessageComponent.propDecorators = {
            nzMessage: [{ type: i0.Input }],
            nzIndex: [{ type: i0.Input }]
        };
        return NzMessageComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var globalCounter = 0;
    // unsupported: template constraints.
    // unsupported: template constraints.
    /**
     * @template ContainerClass, MessageData, MessageConfig
     */
    var  
    // unsupported: template constraints.
    // unsupported: template constraints.
    /**
     * @template ContainerClass, MessageData, MessageConfig
     */
    NzMessageBaseService$$1 = /** @class */ (function () {
        function NzMessageBaseService$$1(overlay, containerClass, injector, cfr, appRef, _idPrefix) {
            if (_idPrefix === void 0) {
                _idPrefix = '';
            }
            this.overlay = overlay;
            this.containerClass = containerClass;
            this.injector = injector;
            this.cfr = cfr;
            this.appRef = appRef;
            this._idPrefix = _idPrefix;
            // this._container = overlay.create().attach(new ComponentPortal(containerClass)).instance;
            this._container = this.createContainer();
        }
        /**
         * @param {?=} messageId
         * @return {?}
         */
        NzMessageBaseService$$1.prototype.remove = /**
         * @param {?=} messageId
         * @return {?}
         */
            function (messageId) {
                if (messageId) {
                    this._container.removeMessage(messageId);
                }
                else {
                    this._container.removeMessageAll();
                }
            };
        /**
         * @param {?} message
         * @param {?=} options
         * @return {?}
         */
        NzMessageBaseService$$1.prototype.createMessage = /**
         * @param {?} message
         * @param {?=} options
         * @return {?}
         */
            function (message, options) {
                /** @type {?} */
                var resultMessage = __assign({}, ( /** @type {?} */(message)), {
                    messageId: this._generateMessageId(),
                    options: options,
                    createdAt: new Date()
                });
                this._container.createMessage(resultMessage);
                return resultMessage;
            };
        /**
         * @param {?} config
         * @return {?}
         */
        NzMessageBaseService$$1.prototype.config = /**
         * @param {?} config
         * @return {?}
         */
            function (config) {
                this._container.setConfig(config);
            };
        /**
         * @return {?}
         */
        NzMessageBaseService$$1.prototype._generateMessageId = /**
         * @return {?}
         */
            function () {
                return this._idPrefix + globalCounter++;
            };
        /**
         * @return {?}
         */
        NzMessageBaseService$$1.prototype.createContainer = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var factory = this.cfr.resolveComponentFactory(this.containerClass);
                /** @type {?} */
                var componentRef = factory.create(this.injector); // Use root injector
                componentRef.changeDetectorRef.detectChanges(); // Immediately change detection to avoid multi-checking error
                this.appRef.attachView(componentRef.hostView);
                /** @type {?} */
                var overlayPane = this.overlay.create().overlayElement;
                overlayPane.style.zIndex = '1010'; // Patching: assign the same zIndex of ant-message to it's parent overlay panel, to the ant-message's zindex work.
                overlayPane.appendChild(/** @type {?} */ (( /** @type {?} */(componentRef.hostView)).rootNodes[0]));
                return componentRef.instance;
            };
        return NzMessageBaseService$$1;
    }());
    var NzMessageService$$1 = /** @class */ (function (_super) {
        __extends(NzMessageService$$1, _super);
        function NzMessageService$$1(overlay, injector, cfr, appRef) {
            return _super.call(this, overlay, NzMessageContainerComponent, injector, cfr, appRef, 'message-') || this;
        }
        // Shortcut methods
        /**
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
        NzMessageService$$1.prototype.success = /**
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
            function (content, options) {
                return this.createMessage({ type: 'success', content: content }, options);
            };
        /**
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
        NzMessageService$$1.prototype.error = /**
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
            function (content, options) {
                return this.createMessage({ type: 'error', content: content }, options);
            };
        /**
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
        NzMessageService$$1.prototype.info = /**
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
            function (content, options) {
                return this.createMessage({ type: 'info', content: content }, options);
            };
        /**
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
        NzMessageService$$1.prototype.warning = /**
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
            function (content, options) {
                return this.createMessage({ type: 'warning', content: content }, options);
            };
        /**
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
        NzMessageService$$1.prototype.loading = /**
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
            function (content, options) {
                return this.createMessage({ type: 'loading', content: content }, options);
            };
        /**
         * @param {?} type
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
        NzMessageService$$1.prototype.create = /**
         * @param {?} type
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
            function (type, content, options) {
                return this.createMessage({ type: type, content: content }, options);
            };
        NzMessageService$$1.decorators = [
            { type: i0.Injectable, args: [{
                        providedIn: 'root'
                    },] }
        ];
        /** @nocollapse */
        NzMessageService$$1.ctorParameters = function () {
            return [
                { type: i2.Overlay },
                { type: i0.Injector },
                { type: i0.ComponentFactoryResolver },
                { type: i0.ApplicationRef }
            ];
        };
        /** @nocollapse */ NzMessageService$$1.ngInjectableDef = i0.defineInjectable({ factory: function NzMessageService_Factory() { return new NzMessageService$$1(i0.inject(i2.Overlay), i0.inject(i0.INJECTOR), i0.inject(i0.ComponentFactoryResolver), i0.inject(i0.ApplicationRef)); }, token: NzMessageService$$1, providedIn: "root" });
        return NzMessageService$$1;
    }(NzMessageBaseService$$1));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzMessageModule = /** @class */ (function () {
        function NzMessageModule() {
        }
        NzMessageModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [i1.CommonModule, i2.OverlayModule],
                        declarations: [NzMessageContainerComponent, NzMessageComponent],
                        providers: [NZ_MESSAGE_DEFAULT_CONFIG_PROVIDER, NzMessageService$$1],
                        entryComponents: [NzMessageContainerComponent]
                    },] }
        ];
        return NzMessageModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var CssUnitPipe = /** @class */ (function () {
        function CssUnitPipe() {
        }
        /**
         * @param {?} value
         * @param {?=} defaultUnit
         * @return {?}
         */
        CssUnitPipe.prototype.transform = /**
         * @param {?} value
         * @param {?=} defaultUnit
         * @return {?}
         */
            function (value, defaultUnit) {
                if (defaultUnit === void 0) {
                    defaultUnit = 'px';
                }
                /** @type {?} */
                var formatted = +value; // force convert
                return isNaN(formatted) ? "" + value : "" + formatted + defaultUnit;
            };
        CssUnitPipe.decorators = [
            { type: i0.Pipe, args: [{
                        name: 'toCssUnit'
                    },] }
        ];
        return CssUnitPipe;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzModalControlService = /** @class */ (function () {
        function NzModalControlService(parentService) {
            this.parentService = parentService;
            this.rootOpenModals = this.parentService ? null : [];
            this.rootAfterAllClose = this.parentService ? null : new rxjs.Subject();
            this.rootRegisteredMetaMap = this.parentService ? null : new Map();
        }
        Object.defineProperty(NzModalControlService.prototype, "afterAllClose", {
            // Track singleton afterAllClose through over the injection tree
            get: /**
             * @return {?}
             */ function () {
                return this.parentService ? this.parentService.afterAllClose : this.rootAfterAllClose;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzModalControlService.prototype, "openModals", {
            // Track singleton openModals array through over the injection tree
            get: /**
             * @return {?}
             */ function () {
                return this.parentService ? this.parentService.openModals : this.rootOpenModals;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzModalControlService.prototype, "registeredMetaMap", {
            get: /**
             * @return {?}
             */ function () {
                // Registered modal for later usage
                return this.parentService ? this.parentService.registeredMetaMap : this.rootRegisteredMetaMap;
            },
            enumerable: true,
            configurable: true
        });
        // Register a modal to listen its open/close
        /**
         * @param {?} modalRef
         * @return {?}
         */
        NzModalControlService.prototype.registerModal = /**
         * @param {?} modalRef
         * @return {?}
         */
            function (modalRef) {
                var _this = this;
                if (!this.hasRegistered(modalRef)) {
                    /** @type {?} */
                    var afterOpenSubscription = modalRef.afterOpen.subscribe(function () { return _this.openModals.push(modalRef); });
                    /** @type {?} */
                    var afterCloseSubscription = modalRef.afterClose.subscribe(function () { return _this.removeOpenModal(modalRef); });
                    this.registeredMetaMap.set(modalRef, { modalRef: modalRef, afterOpenSubscription: afterOpenSubscription, afterCloseSubscription: afterCloseSubscription });
                }
            };
        // deregister modals
        /**
         * @param {?} modalRef
         * @return {?}
         */
        NzModalControlService.prototype.deregisterModal = /**
         * @param {?} modalRef
         * @return {?}
         */
            function (modalRef) {
                /** @type {?} */
                var registeredMeta = this.registeredMetaMap.get(modalRef);
                if (registeredMeta) {
                    // Remove this modal if it is still in the opened modal list (NOTE: it may trigger "afterAllClose")
                    this.removeOpenModal(registeredMeta.modalRef);
                    registeredMeta.afterOpenSubscription.unsubscribe();
                    registeredMeta.afterCloseSubscription.unsubscribe();
                    this.registeredMetaMap.delete(modalRef);
                }
            };
        /**
         * @param {?} modalRef
         * @return {?}
         */
        NzModalControlService.prototype.hasRegistered = /**
         * @param {?} modalRef
         * @return {?}
         */
            function (modalRef) {
                return this.registeredMetaMap.has(modalRef);
            };
        // Close all registered opened modals
        /**
         * @return {?}
         */
        NzModalControlService.prototype.closeAll = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var i = this.openModals.length;
                while (i--) {
                    this.openModals[i].close();
                }
            };
        /**
         * @param {?} modalRef
         * @return {?}
         */
        NzModalControlService.prototype.removeOpenModal = /**
         * @param {?} modalRef
         * @return {?}
         */
            function (modalRef) {
                /** @type {?} */
                var index = this.openModals.indexOf(modalRef);
                if (index > -1) {
                    this.openModals.splice(index, 1);
                    if (!this.openModals.length) {
                        this.afterAllClose.next();
                    }
                }
            };
        NzModalControlService.decorators = [
            { type: i0.Injectable }
        ];
        /** @nocollapse */
        NzModalControlService.ctorParameters = function () {
            return [
                { type: NzModalControlService, decorators: [{ type: i0.Optional }, { type: i0.SkipSelf }] }
            ];
        };
        return NzModalControlService;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var ModalUtil = /** @class */ (function () {
        function ModalUtil(document) {
            this.document = document;
            this.lastPosition = null;
            this.listenDocumentClick();
        }
        /**
         * @return {?}
         */
        ModalUtil.prototype.getLastClickPosition = /**
         * @return {?}
         */
            function () {
                return this.lastPosition;
            };
        /**
         * @return {?}
         */
        ModalUtil.prototype.listenDocumentClick = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.document.addEventListener('click', function (event) {
                    _this.lastPosition = { x: event.clientX, y: event.clientY };
                });
            };
        return ModalUtil;
    }());
    var ModalUtil$1 = new ModalUtil(document);

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var NZ_MODAL_DEFAULT_CONFIG = {
        autoBodyPadding: true
    };
    /** @type {?} */
    var NZ_MODAL_CONFIG = new i0.InjectionToken('NzModalConfig', {
        providedIn: 'root',
        factory: function () { return NZ_MODAL_DEFAULT_CONFIG; } // Default config
        // Default config
    });

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * API class that public to users to handle the modal instance.
     * NzModalRef is aim to avoid accessing to the modal instance directly by users.
     * @abstract
     * @template T, R
     */
    var /**
     * API class that public to users to handle the modal instance.
     * NzModalRef is aim to avoid accessing to the modal instance directly by users.
     * @abstract
     * @template T, R
     */ NzModalRef = /** @class */ (function () {
        function NzModalRef() {
        }
        return NzModalRef;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var MODAL_ANIMATE_DURATION = 200; // Duration when perform animations (ms)
    /**
     * @template T, R
     */
    var NzModalComponent = /** @class */ (function (_super) {
        __extends(NzModalComponent, _super);
        function NzModalComponent(overlay, i18n, renderer, cfr, elementRef, viewContainer, nzMeasureScrollbarService, modalControl, config, document) {
            // tslint:disable-line:no-any
            var _this = _super.call(this) || this;
            _this.overlay = overlay;
            _this.i18n = i18n;
            _this.renderer = renderer;
            _this.cfr = cfr;
            _this.elementRef = elementRef;
            _this.viewContainer = viewContainer;
            _this.nzMeasureScrollbarService = nzMeasureScrollbarService;
            _this.modalControl = modalControl;
            _this.config = config;
            _this.document = document;
            _this.unsubscribe$ = new rxjs.Subject();
            // tslint:disable-next-line:no-any
            _this.locale = {};
            _this.nzModalType = 'default';
            _this.nzGetContainer = function () { return _this.overlay.create(); };
            _this.nzVisible = false;
            _this.nzVisibleChange = new i0.EventEmitter();
            _this.nzZIndex = 1000;
            _this.nzWidth = 520;
            _this.nzIconType = 'question-circle';
            _this.nzClosable = true;
            _this.nzMask = true;
            _this.nzMaskClosable = true;
            _this.nzAfterOpen = new i0.EventEmitter();
            _this.nzAfterClose = new i0.EventEmitter();
            _this.nzOkType = 'primary';
            _this.nzOkLoading = false;
            _this.nzOnOk = new i0.EventEmitter();
            _this.nzCancelLoading = false;
            _this.nzOnCancel = new i0.EventEmitter();
            _this.transformOrigin = '0px 0px 0px';
            _this.config = _this.mergeDefaultConfig(_this.config);
            return _this;
        }
        Object.defineProperty(NzModalComponent.prototype, "afterOpen", {
            get: /**
             * @return {?}
             */ function () {
                // Observable alias for nzAfterOpen
                return this.nzAfterOpen.asObservable();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzModalComponent.prototype, "afterClose", {
            get: /**
             * @return {?}
             */ function () {
                // Observable alias for nzAfterClose
                return this.nzAfterClose.asObservable();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzModalComponent.prototype, "okText", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzOkText || this.locale.okText;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzModalComponent.prototype, "cancelText", {
            get: /**
             * @return {?}
             */ function () {
                return this.nzCancelText || this.locale.cancelText;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzModalComponent.prototype, "hidden", {
            get: /**
             * @return {?}
             */ function () {
                return !this.nzVisible && !this.animationState;
            } // Indicate whether this dialog should hidden
            // Indicate whether this dialog should hidden
            ,
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        NzModalComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                var _this = this;
                this.i18n.localeChange.pipe(operators.takeUntil(this.unsubscribe$)).subscribe(function () { return _this.locale = _this.i18n.getLocaleData('Modal'); });
                if (this.isComponent(this.nzContent)) {
                    this.createDynamicComponent(/** @type {?} */ (this.nzContent)); // Create component along without View
                }
                if (this.isModalButtons(this.nzFooter)) { // Setup default button options
                    // Setup default button options
                    this.nzFooter = this.formatModalButtons(/** @type {?} */ (this.nzFooter));
                }
                // Place the modal dom to elsewhere
                this.container = typeof this.nzGetContainer === 'function' ? this.nzGetContainer() : this.nzGetContainer;
                if (this.container instanceof HTMLElement) {
                    this.container.appendChild(this.elementRef.nativeElement);
                }
                else if (this.container instanceof i2.OverlayRef) { // NOTE: only attach the dom to overlay, the view container is not changed actually
                    // NOTE: only attach the dom to overlay, the view container is not changed actually
                    this.container.overlayElement.appendChild(this.elementRef.nativeElement);
                }
                // Register modal when afterOpen/afterClose is stable
                this.modalControl.registerModal(this);
            };
        // [NOTE] NOT available when using by service!
        // Because ngOnChanges never be called when using by service,
        // here we can't support "nzContent"(Component) etc. as inputs that initialized dynamically.
        // BUT: User also can change "nzContent" dynamically to trigger UI changes (provided you don't use Component that needs initializations)
        /**
         * @param {?} changes
         * @return {?}
         */
        NzModalComponent.prototype.ngOnChanges = /**
         * @param {?} changes
         * @return {?}
         */
            function (changes) {
                if (changes["nzVisible"]) {
                    this.handleVisibleStateChange(this.nzVisible, !changes["nzVisible"].firstChange); // Do not trigger animation while initializing
                }
            };
        /**
         * @return {?}
         */
        NzModalComponent.prototype.ngAfterViewInit = /**
         * @return {?}
         */
            function () {
                // If using Component, it is the time to attach View while bodyContainer is ready
                if (this.contentComponentRef) {
                    this.bodyContainer.insert(this.contentComponentRef.hostView);
                }
                if (this.autoFocusButtonOk) {
                    ( /** @type {?} */(this.autoFocusButtonOk.nativeElement)).focus();
                }
            };
        /**
         * @return {?}
         */
        NzModalComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                var _this = this;
                // Close self before destructing
                this.changeVisibleFromInside(false).then(function () {
                    _this.modalControl.deregisterModal(_this);
                    if (_this.container instanceof i2.OverlayRef) {
                        _this.container.dispose();
                    }
                    _this.unsubscribe$.next();
                    _this.unsubscribe$.complete();
                });
            };
        /**
         * @return {?}
         */
        NzModalComponent.prototype.open = /**
         * @return {?}
         */
            function () {
                this.changeVisibleFromInside(true);
            };
        /**
         * @param {?=} result
         * @return {?}
         */
        NzModalComponent.prototype.close = /**
         * @param {?=} result
         * @return {?}
         */
            function (result) {
                this.changeVisibleFromInside(false, result);
            };
        /**
         * @param {?=} result
         * @return {?}
         */
        NzModalComponent.prototype.destroy = /**
         * @param {?=} result
         * @return {?}
         */
            function (result) {
                // Destroy equals Close
                this.close(result);
            };
        /**
         * @return {?}
         */
        NzModalComponent.prototype.triggerOk = /**
         * @return {?}
         */
            function () {
                this.onClickOkCancel('ok');
            };
        /**
         * @return {?}
         */
        NzModalComponent.prototype.triggerCancel = /**
         * @return {?}
         */
            function () {
                this.onClickOkCancel('cancel');
            };
        /**
         * @return {?}
         */
        NzModalComponent.prototype.getInstance = /**
         * @return {?}
         */
            function () {
                return this;
            };
        /**
         * @return {?}
         */
        NzModalComponent.prototype.getContentComponentRef = /**
         * @return {?}
         */
            function () {
                return this.contentComponentRef;
            };
        /**
         * @return {?}
         */
        NzModalComponent.prototype.getContentComponent = /**
         * @return {?}
         */
            function () {
                return this.contentComponentRef && this.contentComponentRef.instance;
            };
        /**
         * @return {?}
         */
        NzModalComponent.prototype.getElement = /**
         * @return {?}
         */
            function () {
                return this.elementRef && this.elementRef.nativeElement;
            };
        /**
         * @param {?} $event
         * @return {?}
         */
        NzModalComponent.prototype.onClickMask = /**
         * @param {?} $event
         * @return {?}
         */
            function ($event) {
                if (this.nzMask &&
                    this.nzMaskClosable &&
                    ( /** @type {?} */($event.target)).classList.contains('ant-modal-wrap') &&
                    this.nzVisible) {
                    this.onClickOkCancel('cancel');
                }
            };
        /**
         * @param {?} type
         * @return {?}
         */
        NzModalComponent.prototype.isModalType = /**
         * @param {?} type
         * @return {?}
         */
            function (type) {
                return this.nzModalType === type;
            };
        /**
         * @return {?}
         */
        NzModalComponent.prototype.onClickCloseBtn = /**
         * @return {?}
         */
            function () {
                if (this.nzVisible) {
                    this.onClickOkCancel('cancel');
                }
            };
        /**
         * @param {?} type
         * @return {?}
         */
        NzModalComponent.prototype.onClickOkCancel = /**
         * @param {?} type
         * @return {?}
         */
            function (type) {
                var _this = this;
                /** @type {?} */
                var trigger = { 'ok': this.nzOnOk, 'cancel': this.nzOnCancel }[type];
                /** @type {?} */
                var loadingKey = { 'ok': 'nzOkLoading', 'cancel': 'nzCancelLoading' }[type];
                if (trigger instanceof i0.EventEmitter) {
                    trigger.emit(this.getContentComponent());
                }
                else if (typeof trigger === 'function') {
                    /** @type {?} */
                    var result = trigger(this.getContentComponent());
                    /** @type {?} */
                    var caseClose_1 = function (doClose) { return (doClose !== false) && _this.close(/** @type {?} */ (doClose)); }; // Users can return "false" to prevent closing by default
                    if (isPromise(result)) {
                        this[loadingKey] = true;
                        /** @type {?} */
                        var handleThen = function (doClose) {
                            _this[loadingKey] = false;
                            caseClose_1(doClose);
                        };
                        ( /** @type {?} */(result)).then(handleThen).catch(handleThen);
                    }
                    else {
                        caseClose_1(result);
                    }
                }
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzModalComponent.prototype.isNonEmptyString = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                return typeof value === 'string' && value !== '';
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzModalComponent.prototype.isTemplateRef = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                return value instanceof i0.TemplateRef;
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzModalComponent.prototype.isComponent = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                return value instanceof i0.Type;
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzModalComponent.prototype.isModalButtons = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                return Array.isArray(value) && value.length > 0;
            };
        /**
         * @param {?} visible
         * @param {?=} animation
         * @param {?=} closeResult
         * @return {?}
         */
        NzModalComponent.prototype.handleVisibleStateChange = /**
         * @param {?} visible
         * @param {?=} animation
         * @param {?=} closeResult
         * @return {?}
         */
            function (visible, animation, closeResult) {
                var _this = this;
                if (animation === void 0) {
                    animation = true;
                }
                if (visible) { // Hide scrollbar at the first time when shown up
                    // Hide scrollbar at the first time when shown up
                    this.changeBodyOverflow(1);
                }
                return Promise
                    .resolve(animation && this.animateTo(visible))
                    .then(function () {
                    // Emit open/close event after animations over
                    if (visible) {
                        _this.nzAfterOpen.emit();
                    }
                    else {
                        _this.nzAfterClose.emit(closeResult);
                        _this.changeBodyOverflow(); // Show/hide scrollbar when animation is over
                    }
                });
                // .then(() => this.changeBodyOverflow());
            };
        /**
         * @param {?} options
         * @param {?} prop
         * @return {?}
         */
        NzModalComponent.prototype.getButtonCallableProp = /**
         * @param {?} options
         * @param {?} prop
         * @return {?}
         */
            function (options, prop) {
                /** @type {?} */
                var value = options[prop];
                /** @type {?} */
                var args = [];
                if (this.contentComponentRef) {
                    args.push(this.contentComponentRef.instance);
                }
                return typeof value === 'function' ? value.apply(options, args) : value;
            };
        /**
         * @param {?} button
         * @return {?}
         */
        NzModalComponent.prototype.onButtonClick = /**
         * @param {?} button
         * @return {?}
         */
            function (button) {
                /** @type {?} */
                var result = this.getButtonCallableProp(button, 'onClick'); // Call onClick directly
                if (isPromise(result)) {
                    button.loading = true;
                    ( /** @type {?} */(result)).then(function () { return button.loading = false; }).catch(function () { return button.loading = false; });
                }
            };
        /**
         * @param {?} visible
         * @param {?=} closeResult
         * @return {?}
         */
        NzModalComponent.prototype.changeVisibleFromInside = /**
         * @param {?} visible
         * @param {?=} closeResult
         * @return {?}
         */
            function (visible, closeResult) {
                if (this.nzVisible !== visible) {
                    // Change nzVisible value immediately
                    this.nzVisible = visible;
                    this.nzVisibleChange.emit(visible);
                    return this.handleVisibleStateChange(visible, true, closeResult);
                }
                return Promise.resolve();
            };
        /**
         * @param {?} state
         * @return {?}
         */
        NzModalComponent.prototype.changeAnimationState = /**
         * @param {?} state
         * @return {?}
         */
            function (state) {
                var _a, _b;
                this.animationState = state;
                if (state) {
                    this.maskAnimationClassMap = (_a = {},
                        _a["fade-" + state] = true,
                        _a["fade-" + state + "-active"] = true,
                        _a);
                    this.modalAnimationClassMap = (_b = {},
                        _b["zoom-" + state] = true,
                        _b["zoom-" + state + "-active"] = true,
                        _b);
                }
                else {
                    this.maskAnimationClassMap = this.modalAnimationClassMap = null;
                }
            };
        /**
         * @param {?} isVisible
         * @return {?}
         */
        NzModalComponent.prototype.animateTo = /**
         * @param {?} isVisible
         * @return {?}
         */
            function (isVisible) {
                var _this = this;
                if (isVisible) { // Figure out the lastest click position when shows up
                    // Figure out the lastest click position when shows up
                    window.setTimeout(function () { return _this.updateTransformOrigin(); }); // [NOTE] Using timeout due to the document.click event is fired later than visible change, so if not postponed to next event-loop, we can't get the lastest click position
                }
                this.changeAnimationState(isVisible ? 'enter' : 'leave');
                return new Promise(function (resolve) {
                    return window.setTimeout(function () {
                        // Return when animation is over
                        _this.changeAnimationState(null);
                        resolve();
                    }, MODAL_ANIMATE_DURATION);
                });
            };
        /**
         * @param {?} buttons
         * @return {?}
         */
        NzModalComponent.prototype.formatModalButtons = /**
         * @param {?} buttons
         * @return {?}
         */
            function (buttons) {
                return buttons.map(function (button) {
                    /** @type {?} */
                    var mixedButton = __assign({
                        type: 'default',
                        size: 'default',
                        autoLoading: true,
                        show: true,
                        loading: false,
                        disabled: false
                    }, button);
                    // if (mixedButton.autoLoading) { mixedButton.loading = false; } // Force loading to false when autoLoading=true
                    return mixedButton;
                });
            };
        /**
         * Create a component dynamically but not attach to any View (this action will be executed when bodyContainer is ready)
         * @param {?} component Component class
         * @return {?}
         */
        NzModalComponent.prototype.createDynamicComponent = /**
         * Create a component dynamically but not attach to any View (this action will be executed when bodyContainer is ready)
         * @param {?} component Component class
         * @return {?}
         */
            function (component) {
                /** @type {?} */
                var factory = this.cfr.resolveComponentFactory(component);
                /** @type {?} */
                var childInjector = i0.Injector.create({
                    providers: [{ provide: NzModalRef, useValue: this }],
                    parent: this.viewContainer.parentInjector
                });
                this.contentComponentRef = factory.create(childInjector);
                if (this.nzComponentParams) {
                    Object.assign(this.contentComponentRef.instance, this.nzComponentParams);
                }
                // Do the first change detection immediately (or we do detection at ngAfterViewInit, multi-changes error will be thrown)
                this.contentComponentRef.changeDetectorRef.detectChanges();
            };
        /**
         * @return {?}
         */
        NzModalComponent.prototype.updateTransformOrigin = /**
         * @return {?}
         */
            function () {
                /** @type {?} */
                var modalElement = /** @type {?} */ (this.modalContainer.nativeElement);
                /** @type {?} */
                var lastPosition = ModalUtil$1.getLastClickPosition();
                if (lastPosition) {
                    this.transformOrigin = lastPosition.x - modalElement.offsetLeft + "px " + (lastPosition.y - modalElement.offsetTop) + "px 0px";
                }
                // else {
                //   this.transformOrigin = '0px 0px 0px';
                // }
            };
        /**
         * Take care of the body's overflow to decide the existense of scrollbar
         * @param {?=} plusNum The number that the openModals.length will increase soon
         * @return {?}
         */
        NzModalComponent.prototype.changeBodyOverflow = /**
         * Take care of the body's overflow to decide the existense of scrollbar
         * @param {?=} plusNum The number that the openModals.length will increase soon
         * @return {?}
         */
            function (plusNum) {
                if (plusNum === void 0) {
                    plusNum = 0;
                }
                if (this.config.autoBodyPadding) {
                    /** @type {?} */
                    var openModals = this.modalControl.openModals;
                    if (openModals.length + plusNum > 0) {
                        if (this.hasBodyScrollBar()) { // Adding padding-right only when body's scrollbar is able to shown up
                            // Adding padding-right only when body's scrollbar is able to shown up
                            this.renderer.setStyle(this.document.body, 'padding-right', this.nzMeasureScrollbarService.scrollBarWidth + "px");
                            this.renderer.setStyle(this.document.body, 'overflow', 'hidden');
                        }
                    }
                    else { // NOTE: we need to always remove the padding due to the scroll bar may be disappear by window resizing before modal closed
                        // NOTE: we need to always remove the padding due to the scroll bar may be disappear by window resizing before modal closed
                        this.renderer.removeStyle(this.document.body, 'padding-right');
                        this.renderer.removeStyle(this.document.body, 'overflow');
                    }
                }
            };
        /**
         * Check whether the body element is able to has the scroll bar (if the body content height exceeds the window's height)
         * Exceptional Cases: users can show the scroll bar by their own permanently (eg. overflow: scroll)
         * @return {?}
         */
        NzModalComponent.prototype.hasBodyScrollBar = /**
         * Check whether the body element is able to has the scroll bar (if the body content height exceeds the window's height)
         * Exceptional Cases: users can show the scroll bar by their own permanently (eg. overflow: scroll)
         * @return {?}
         */
            function () {
                return this.document.body.scrollHeight > (window.innerHeight || this.document.documentElement.clientHeight);
            };
        /**
         * @param {?} config
         * @return {?}
         */
        NzModalComponent.prototype.mergeDefaultConfig = /**
         * @param {?} config
         * @return {?}
         */
            function (config) {
                return __assign({}, NZ_MODAL_DEFAULT_CONFIG, config);
            };
        NzModalComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-modal',
                        template: "<ng-template #tplOriginContent><ng-content></ng-content></ng-template> <!-- Compatible: the <ng-content> can appear only once -->\n\n<div>\n  <div *ngIf=\"nzMask\"\n    class=\"ant-modal-mask\"\n    [ngClass]=\"maskAnimationClassMap\"\n    [class.ant-modal-mask-hidden]=\"hidden\"\n    [ngStyle]=\"nzMaskStyle\"\n    [style.zIndex]=\"nzZIndex\"\n  ></div>\n  <div\n    (click)=\"onClickMask($event)\"\n    class=\"ant-modal-wrap {{ nzWrapClassName }}\"\n    [style.zIndex]=\"nzZIndex\"\n    [style.display]=\"hidden ? 'none' : ''\"\n    tabindex=\"-1\"\n    role=\"dialog\"\n  >\n    <div #modalContainer\n      class=\"ant-modal {{ nzClassName }}\"\n      [ngClass]=\"modalAnimationClassMap\"\n      [ngStyle]=\"nzStyle\"\n      [style.width]=\"nzWidth | toCssUnit\"\n      [style.transform-origin]=\"transformOrigin\"\n      role=\"document\"\n    >\n      <div class=\"ant-modal-content\">\n        <button *ngIf=\"nzClosable\" (click)=\"onClickCloseBtn()\" class=\"ant-modal-close\" aria-label=\"Close\">\n          <span class=\"ant-modal-close-x\"></span>\n        </button>\n        <ng-container [ngSwitch]=\"true\">\n          <ng-container *ngSwitchCase=\"isModalType('default')\" [ngTemplateOutlet]=\"tplContentDefault\"></ng-container>\n          <ng-container *ngSwitchCase=\"isModalType('confirm')\" [ngTemplateOutlet]=\"tplContentConfirm\"></ng-container>\n        </ng-container>\n      </div>\n    </div>\n    <div tabindex=\"0\" style=\"width: 0px; height: 0px; overflow: hidden;\">sentinel</div>\n  </div>\n</div>\n\n<!-- [Predefined] Default Modal Content -->\n<ng-template #tplContentDefault>\n  <div *ngIf=\"nzTitle\" class=\"ant-modal-header\">\n    <div class=\"ant-modal-title\">\n      <ng-container [ngSwitch]=\"true\">\n        <ng-container *ngSwitchCase=\"isTemplateRef(nzTitle)\" [ngTemplateOutlet]=\"nzTitle\"></ng-container>\n        <ng-container *ngSwitchCase=\"isNonEmptyString(nzTitle)\"><div [innerHTML]=\"nzTitle\"></div></ng-container>\n      </ng-container>\n    </div>\n  </div>\n  <div class=\"ant-modal-body\" [ngStyle]=\"nzBodyStyle\">\n    <ng-container #bodyContainer>\n      <ng-container *ngIf=\"!isComponent(nzContent)\" [ngSwitch]=\"true\">\n        <ng-container *ngSwitchCase=\"isTemplateRef(nzContent)\" [ngTemplateOutlet]=\"nzContent\"></ng-container>\n        <ng-container *ngSwitchCase=\"isNonEmptyString(nzContent)\"><div [innerHTML]=\"nzContent\"></div></ng-container>\n        <ng-container *ngSwitchDefault [ngTemplateOutlet]=\"tplOriginContent\"></ng-container>\n      </ng-container>\n    </ng-container>\n  </div>\n  <div *ngIf=\"nzFooter !== null\" class=\"ant-modal-footer\">\n    <ng-container [ngSwitch]=\"true\">\n      <ng-container *ngSwitchCase=\"isTemplateRef(nzFooter)\" [ngTemplateOutlet]=\"nzFooter\"></ng-container>\n      <ng-container *ngSwitchCase=\"isNonEmptyString(nzFooter)\"><div [innerHTML]=\"nzFooter\"></div></ng-container>\n      <ng-container *ngSwitchCase=\"isModalButtons(nzFooter)\">\n        <button *ngFor=\"let button of nzFooter\" nz-button\n          (click)=\"onButtonClick(button)\"\n          [hidden]=\"!getButtonCallableProp(button, 'show')\"\n          [nzLoading]=\"getButtonCallableProp(button, 'loading')\"\n          [disabled]=\"getButtonCallableProp(button, 'disabled')\"\n          [nzType]=\"button.type\"\n          [nzShape]=\"button.shape\"\n          [nzSize]=\"button.size\"\n          [nzGhost]=\"button.ghost\"\n        >{{ button.label }}</button>\n      </ng-container>\n      <ng-container *ngSwitchDefault>\n        <button *ngIf=\"nzCancelText!==null\" nz-button (click)=\"onClickOkCancel('cancel')\" [nzLoading]=\"nzCancelLoading\">\n          {{ cancelText }}\n        </button>\n        <button *ngIf=\"nzOkText!==null\" nz-button [nzType]=\"nzOkType\" (click)=\"onClickOkCancel('ok')\" [nzLoading]=\"nzOkLoading\">\n          {{ okText }}\n        </button>\n      </ng-container>\n    </ng-container>\n  </div>\n</ng-template>\n<!-- /[Predefined] Default Modal Content -->\n\n<!-- [Predefined] Confirm Modal Content -->\n<ng-template #tplContentConfirm>\n  <div class=\"ant-modal-body\" [ngStyle]=\"nzBodyStyle\">\n    <div class=\"ant-confirm-body-wrapper\">\n      <div class=\"ant-confirm-body\">\n        <i class=\"anticon anticon-{{ nzIconType }}\"></i>\n        <span class=\"ant-confirm-title\">\n          <ng-container [ngSwitch]=\"true\">\n            <ng-container *ngSwitchCase=\"isTemplateRef(nzTitle)\" [ngTemplateOutlet]=\"nzTitle\"></ng-container>\n            <ng-container *ngSwitchCase=\"isNonEmptyString(nzTitle)\"><span [innerHTML]=\"nzTitle\"></span></ng-container>\n          </ng-container>\n        </span>\n        <div class=\"ant-confirm-content\">\n          <ng-container #bodyContainer>\n            <ng-container *ngIf=\"!isComponent(nzContent)\" [ngSwitch]=\"true\">\n              <ng-container *ngSwitchCase=\"isTemplateRef(nzContent)\" [ngTemplateOutlet]=\"nzContent\"></ng-container>\n              <ng-container *ngSwitchCase=\"isNonEmptyString(nzContent)\"><div [innerHTML]=\"nzContent\"></div></ng-container>\n              <ng-container *ngSwitchDefault [ngTemplateOutlet]=\"tplOriginContent\"></ng-container>\n            </ng-container>\n          </ng-container>\n        </div>\n      </div>\n      <div class=\"ant-confirm-btns\">\n        <button nz-button *ngIf=\"nzCancelText!==null\" (click)=\"onClickOkCancel('cancel')\" [nzLoading]=\"nzCancelLoading\">\n          {{ cancelText }}\n        </button>\n        <button *ngIf=\"nzOkText!==null\" #autoFocusButtonOk nz-button [nzType]=\"nzOkType\" (click)=\"onClickOkCancel('ok')\" [nzLoading]=\"nzOkLoading\">\n          {{ okText }}\n        </button>\n      </div>\n    </div> <!-- /.ant-confirm-body-wrapper -->\n  </div>\n</ng-template>\n<!-- /[Predefined] Confirm Modal Content -->\n"
                    }] }
        ];
        /** @nocollapse */
        NzModalComponent.ctorParameters = function () {
            return [
                { type: i2.Overlay },
                { type: NzI18nService },
                { type: i0.Renderer2 },
                { type: i0.ComponentFactoryResolver },
                { type: i0.ElementRef },
                { type: i0.ViewContainerRef },
                { type: NzMeasureScrollbarService },
                { type: NzModalControlService },
                { type: undefined, decorators: [{ type: i0.Inject, args: [NZ_MODAL_CONFIG,] }] },
                { type: undefined, decorators: [{ type: i0.Inject, args: [i1.DOCUMENT,] }] }
            ];
        };
        NzModalComponent.propDecorators = {
            nzModalType: [{ type: i0.Input }],
            nzContent: [{ type: i0.Input }],
            nzComponentParams: [{ type: i0.Input }],
            nzFooter: [{ type: i0.Input }],
            nzGetContainer: [{ type: i0.Input }],
            nzVisible: [{ type: i0.Input }],
            nzVisibleChange: [{ type: i0.Output }],
            nzZIndex: [{ type: i0.Input }],
            nzWidth: [{ type: i0.Input }],
            nzWrapClassName: [{ type: i0.Input }],
            nzClassName: [{ type: i0.Input }],
            nzStyle: [{ type: i0.Input }],
            nzIconType: [{ type: i0.Input }],
            nzTitle: [{ type: i0.Input }],
            nzClosable: [{ type: i0.Input }],
            nzMask: [{ type: i0.Input }],
            nzMaskClosable: [{ type: i0.Input }],
            nzMaskStyle: [{ type: i0.Input }],
            nzBodyStyle: [{ type: i0.Input }],
            nzAfterOpen: [{ type: i0.Output }],
            nzAfterClose: [{ type: i0.Output }],
            nzOkText: [{ type: i0.Input }],
            nzOkType: [{ type: i0.Input }],
            nzOkLoading: [{ type: i0.Input }],
            nzOnOk: [{ type: i0.Input }, { type: i0.Output }],
            autoFocusButtonOk: [{ type: i0.ViewChild, args: ['autoFocusButtonOk', { read: i0.ElementRef },] }],
            nzCancelText: [{ type: i0.Input }],
            nzCancelLoading: [{ type: i0.Input }],
            nzOnCancel: [{ type: i0.Input }, { type: i0.Output }],
            modalContainer: [{ type: i0.ViewChild, args: ['modalContainer',] }],
            bodyContainer: [{ type: i0.ViewChild, args: ['bodyContainer', { read: i0.ViewContainerRef },] }]
        };
        __decorate([
            InputBoolean(),
            __metadata("design:type", Boolean)
        ], NzModalComponent.prototype, "nzVisible", void 0);
        __decorate([
            InputBoolean(),
            __metadata("design:type", Boolean)
        ], NzModalComponent.prototype, "nzClosable", void 0);
        __decorate([
            InputBoolean(),
            __metadata("design:type", Boolean)
        ], NzModalComponent.prototype, "nzMask", void 0);
        __decorate([
            InputBoolean(),
            __metadata("design:type", Boolean)
        ], NzModalComponent.prototype, "nzMaskClosable", void 0);
        __decorate([
            InputBoolean(),
            __metadata("design:type", Boolean)
        ], NzModalComponent.prototype, "nzOkLoading", void 0);
        __decorate([
            InputBoolean(),
            __metadata("design:type", Boolean)
        ], NzModalComponent.prototype, "nzCancelLoading", void 0);
        return NzModalComponent;
    }(NzModalRef));
    /**
     * @param {?} obj
     * @return {?}
     */
    function isPromise(obj) {
        return !!obj && (typeof obj === 'object' || typeof obj === 'function') && typeof ( /** @type {?} */(obj)).then === 'function' && typeof ( /** @type {?} */(obj)).catch === 'function';
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var ModalBuilderForService = /** @class */ (function () {
        function ModalBuilderForService(overlay, options) {
            if (options === void 0) {
                options = {};
            }
            var _this = this;
            this.overlay = overlay;
            this.createModal();
            if (!('nzGetContainer' in options)) { // As we use CDK to create modal in service by force, there is no need to use nzGetContainer
                // As we use CDK to create modal in service by force, there is no need to use nzGetContainer
                options.nzGetContainer = null; // Override nzGetContainer's default value to prevent creating another overlay
            }
            this.changeProps(options);
            this.modalRef.instance.open();
            this.modalRef.instance.nzAfterClose.subscribe(function () { return _this.destroyModal(); }); // [NOTE] By default, close equals destroy when using as Service
        }
        /**
         * @return {?}
         */
        ModalBuilderForService.prototype.getInstance = /**
         * @return {?}
         */
            function () {
                return this.modalRef && this.modalRef.instance;
            };
        /**
         * @return {?}
         */
        ModalBuilderForService.prototype.destroyModal = /**
         * @return {?}
         */
            function () {
                if (this.modalRef) {
                    this.overlayRef.dispose();
                    this.modalRef = null;
                }
            };
        /**
         * @param {?} options
         * @return {?}
         */
        ModalBuilderForService.prototype.changeProps = /**
         * @param {?} options
         * @return {?}
         */
            function (options) {
                if (this.modalRef) {
                    Object.assign(this.modalRef.instance, options); // DANGER: here not limit user's inputs at runtime
                }
            };
        /**
         * @return {?}
         */
        ModalBuilderForService.prototype.createModal = /**
         * @return {?}
         */
            function () {
                this.overlayRef = this.overlay.create();
                this.modalRef = this.overlayRef.attach(new portal.ComponentPortal(NzModalComponent));
            };
        return ModalBuilderForService;
    }());
    var NzModalService = /** @class */ (function () {
        function NzModalService(overlay, logger, modalControl) {
            this.overlay = overlay;
            this.logger = logger;
            this.modalControl = modalControl;
        }
        Object.defineProperty(NzModalService.prototype, "openModals", {
            // Track of the current close modals (we assume invisible is close this time)
            get: /**
             * @return {?}
             */ function () {
                return this.modalControl.openModals;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(NzModalService.prototype, "afterAllClose", {
            get: /**
             * @return {?}
             */ function () {
                return this.modalControl.afterAllClose.asObservable();
            },
            enumerable: true,
            configurable: true
        });
        // Closes all of the currently-open dialogs
        /**
         * @return {?}
         */
        NzModalService.prototype.closeAll = /**
         * @return {?}
         */
            function () {
                this.modalControl.closeAll();
            };
        /**
         * @template T
         * @param {?=} options
         * @return {?}
         */
        NzModalService.prototype.create = /**
         * @template T
         * @param {?=} options
         * @return {?}
         */
            function (options) {
                if (options === void 0) {
                    options = {};
                }
                if (typeof options.nzOnCancel !== 'function') {
                    options.nzOnCancel = function () {
                    }; // Leave a empty function to close this modal by default
                }
                /** @type {?} */
                var modalRef = new ModalBuilderForService(this.overlay, options).getInstance(); // NOTE: use NzModalComponent as the NzModalRef by now, we may need archive the real NzModalRef object in the future
                return modalRef;
            };
        /**
         * @template T
         * @param {?=} options
         * @param {?=} confirmType
         * @return {?}
         */
        NzModalService.prototype.confirm = /**
         * @template T
         * @param {?=} options
         * @param {?=} confirmType
         * @return {?}
         */
            function (options, confirmType) {
                if (options === void 0) {
                    options = {};
                }
                if (confirmType === void 0) {
                    confirmType = 'confirm';
                }
                if ('nzFooter' in options) {
                    this.logger.warn("The Confirm-Modal doesn't support \"nzFooter\", this property will be ignored.");
                }
                if (!('nzWidth' in options)) {
                    options.nzWidth = 416;
                }
                if (typeof options.nzOnOk !== 'function') { // NOTE: only support function currently by calling confirm()
                    // NOTE: only support function currently by calling confirm()
                    options.nzOnOk = function () {
                    }; // Leave a empty function to close this modal by default
                }
                options.nzModalType = 'confirm';
                options.nzClassName = "ant-confirm ant-confirm-" + confirmType + " " + (options.nzClassName || '');
                options.nzMaskClosable = false;
                return this.create(options);
            };
        /**
         * @template T
         * @param {?=} options
         * @return {?}
         */
        NzModalService.prototype.info = /**
         * @template T
         * @param {?=} options
         * @return {?}
         */
            function (options) {
                if (options === void 0) {
                    options = {};
                }
                return this.simpleConfirm(options, 'info');
            };
        /**
         * @template T
         * @param {?=} options
         * @return {?}
         */
        NzModalService.prototype.success = /**
         * @template T
         * @param {?=} options
         * @return {?}
         */
            function (options) {
                if (options === void 0) {
                    options = {};
                }
                return this.simpleConfirm(options, 'success');
            };
        /**
         * @template T
         * @param {?=} options
         * @return {?}
         */
        NzModalService.prototype.error = /**
         * @template T
         * @param {?=} options
         * @return {?}
         */
            function (options) {
                if (options === void 0) {
                    options = {};
                }
                return this.simpleConfirm(options, 'error');
            };
        /**
         * @template T
         * @param {?=} options
         * @return {?}
         */
        NzModalService.prototype.warning = /**
         * @template T
         * @param {?=} options
         * @return {?}
         */
            function (options) {
                if (options === void 0) {
                    options = {};
                }
                return this.simpleConfirm(options, 'warning');
            };
        /**
         * @template T
         * @param {?=} options
         * @param {?=} confirmType
         * @return {?}
         */
        NzModalService.prototype.simpleConfirm = /**
         * @template T
         * @param {?=} options
         * @param {?=} confirmType
         * @return {?}
         */
            function (options, confirmType) {
                if (options === void 0) {
                    options = {};
                }
                if (!('nzIconType' in options)) {
                    options.nzIconType = {
                        'info': 'info-circle',
                        'success': 'check-circle',
                        'error': 'cross-circle',
                        'warning': 'exclamation-circle'
                    }[confirmType];
                }
                if (!('nzCancelText' in options)) { // Remove the Cancel button if the user not specify a Cancel button
                    // Remove the Cancel button if the user not specify a Cancel button
                    options.nzCancelText = null;
                }
                return this.confirm(options, confirmType);
            };
        NzModalService.decorators = [
            { type: i0.Injectable }
        ];
        /** @nocollapse */
        NzModalService.ctorParameters = function () {
            return [
                { type: i2.Overlay },
                { type: LoggerService },
                { type: NzModalControlService }
            ];
        };
        return NzModalService;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzModalModule = /** @class */ (function () {
        function NzModalModule() {
        }
        NzModalModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [i1.CommonModule, i2.OverlayModule, NzI18nModule, NzButtonModule, LoggerModule],
                        exports: [NzModalComponent],
                        declarations: [NzModalComponent, CssUnitPipe],
                        entryComponents: [NzModalComponent],
                        providers: [NzModalControlService, NzModalService]
                    },] }
        ];
        return NzModalModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /** @type {?} */
    var NZ_NOTIFICATION_DEFAULT_CONFIG = new i0.InjectionToken('NZ_NOTIFICATION_DEFAULT_CONFIG');
    /** @type {?} */
    var NZ_NOTIFICATION_CONFIG = new i0.InjectionToken('NZ_NOTIFICATION_CONFIG');
    /** @type {?} */
    var NZ_NOTIFICATION_DEFAULT_CONFIG_PROVIDER = {
        provide: NZ_NOTIFICATION_DEFAULT_CONFIG,
        useValue: {
            nzTop: '24px',
            nzBottom: '24px',
            nzPlacement: 'topRight',
            nzDuration: 4500,
            nzMaxStack: 7,
            nzPauseOnHover: true,
            nzAnimate: true
        }
    };

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzNotificationContainerComponent = /** @class */ (function (_super) {
        __extends(NzNotificationContainerComponent, _super);
        function NzNotificationContainerComponent(defaultConfig, config) {
            return _super.call(this, defaultConfig, config) || this;
        }
        NzNotificationContainerComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-notification-container',
                        preserveWhitespaces: false,
                        template: "<div\n  class=\"ant-notification ant-notification-{{config.nzPlacement}}\"\n  [style.top]=\"(config.nzPlacement==='topLeft'||config.nzPlacement=='topRight')? config.nzTop:null\"\n  [style.bottom]=\"(config.nzPlacement==='bottomLeft'||config.nzPlacement=='bottomRight')? config.nzBottom:null\"\n  [style.right]=\"(config.nzPlacement==='bottomRight'||config.nzPlacement=='topRight')?'0px':null\"\n  [style.left]=\"(config.nzPlacement==='topLeft'||config.nzPlacement=='bottomLeft')?'0px':null\">\n  <nz-notification *ngFor=\"let message of messages; let i = index\" [nzMessage]=\"message\" [nzIndex]=\"i\"></nz-notification>\n</div>"
                    }] }
        ];
        /** @nocollapse */
        NzNotificationContainerComponent.ctorParameters = function () {
            return [
                { type: undefined, decorators: [{ type: i0.Optional }, { type: i0.Inject, args: [NZ_NOTIFICATION_DEFAULT_CONFIG,] }] },
                { type: undefined, decorators: [{ type: i0.Optional }, { type: i0.Inject, args: [NZ_NOTIFICATION_CONFIG,] }] }
            ];
        };
        return NzNotificationContainerComponent;
    }(NzMessageContainerComponent));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzNotificationComponent = /** @class */ (function (_super) {
        __extends(NzNotificationComponent, _super);
        function NzNotificationComponent(container) {
            var _this = _super.call(this, container) || this;
            _this.container = container;
            return _this;
        }
        /**
         * @return {?}
         */
        NzNotificationComponent.prototype.close = /**
         * @return {?}
         */
            function () {
                this._destroy();
            };
        Object.defineProperty(NzNotificationComponent.prototype, "state", {
            get: /**
             * @return {?}
             */ function () {
                if (this.nzMessage.state === 'enter') {
                    if ((this.container.config["nzPlacement"] === 'topLeft') || (this.container.config["nzPlacement"] === 'bottomLeft')) {
                        return 'enterLeft';
                    }
                    else {
                        return 'enterRight';
                    }
                }
                else {
                    return this.nzMessage.state;
                }
            },
            enumerable: true,
            configurable: true
        });
        NzNotificationComponent.decorators = [
            { type: i0.Component, args: [{
                        selector: 'nz-notification',
                        preserveWhitespaces: false,
                        animations: [
                            animations.trigger('enterLeave', [
                                animations.state('enterRight', animations.style({ opacity: 1, transform: 'translateX(0)' })),
                                animations.transition('* => enterRight', [
                                    animations.style({ opacity: 0, transform: 'translateX(5%)' }),
                                    animations.animate('100ms linear')
                                ]),
                                animations.state('enterLeft', animations.style({ opacity: 1, transform: 'translateX(0)' })),
                                animations.transition('* => enterLeft', [
                                    animations.style({ opacity: 0, transform: 'translateX(-5%)' }),
                                    animations.animate('100ms linear')
                                ]),
                                animations.state('leave', animations.style({
                                    opacity: 0,
                                    transform: 'scaleY(0.8)',
                                    transformOrigin: '0% 0%'
                                })),
                                animations.transition('* => leave', [
                                    animations.style({
                                        opacity: 1,
                                        transform: 'scaleY(1)',
                                        transformOrigin: '0% 0%'
                                    }),
                                    animations.animate('100ms linear')
                                ])
                            ])
                        ],
                        template: "<div class=\"ant-notification-notice ant-notification-notice-closable\"\n  [ngStyle]=\"nzMessage.options.nzStyle\"\n  [ngClass]=\"nzMessage.options.nzClass\"\n  [@enterLeave]=\"state\"\n  (mouseenter)=\"onEnter()\"\n  (mouseleave)=\"onLeave()\">\n  <div *ngIf=\"!nzMessage.template\" class=\"ant-notification-notice-content\">\n    <div class=\"ant-notification-notice-content\" [ngClass]=\"{ 'ant-notification-notice-with-icon': nzMessage.type !== 'blank' }\">\n      <div [class.ant-notification-notice-with-icon]=\"nzMessage.type !== 'blank'\">\n        <ng-container [ngSwitch]=\"nzMessage.type\">\n          <i *ngSwitchCase=\"'success'\" class=\"ant-notification-notice-icon ant-notification-notice-icon-success anticon anticon-check-circle-o\"></i>\n          <i *ngSwitchCase=\"'info'\" class=\"ant-notification-notice-icon ant-notification-notice-icon-info anticon anticon-info-circle-o\"></i>\n          <i *ngSwitchCase=\"'warning'\" class=\"ant-notification-notice-icon ant-notification-notice-icon-warning anticon anticon-exclamation-circle-o\"></i>\n          <i *ngSwitchCase=\"'error'\" class=\"ant-notification-notice-icon ant-notification-notice-icon-error anticon anticon-cross-circle-o\"></i>\n        </ng-container>\n        <div class=\"ant-notification-notice-message\" [innerHTML]=\"nzMessage.title\"></div>\n        <div class=\"ant-notification-notice-description\" [innerHTML]=\"nzMessage.content\"></div>\n      </div>\n    </div>\n  </div>\n  <ng-template [ngIf]=\"nzMessage.template\" [ngTemplateOutlet]=\"nzMessage.template\" [ngTemplateOutletContext]=\"{ $implicit: this }\"></ng-template>\n  <a tabindex=\"0\" class=\"ant-notification-notice-close\" (click)=\"close()\">\n    <span class=\"ant-notification-notice-close-x\"></span>\n  </a>\n</div>"
                    }] }
        ];
        /** @nocollapse */
        NzNotificationComponent.ctorParameters = function () {
            return [
                { type: NzNotificationContainerComponent }
            ];
        };
        NzNotificationComponent.propDecorators = {
            nzMessage: [{ type: i0.Input }]
        };
        return NzNotificationComponent;
    }(NzMessageComponent));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzNotificationService$$1 = /** @class */ (function (_super) {
        __extends(NzNotificationService$$1, _super);
        function NzNotificationService$$1(overlay, injector, cfr, appRef) {
            return _super.call(this, overlay, NzNotificationContainerComponent, injector, cfr, appRef, 'notification-') || this;
        }
        // Shortcut methods
        /**
         * @param {?} title
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
        NzNotificationService$$1.prototype.success = /**
         * @param {?} title
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
            function (title, content, options) {
                return /** @type {?} */ (this.createMessage({ type: 'success', title: title, content: content }, options));
            };
        /**
         * @param {?} title
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
        NzNotificationService$$1.prototype.error = /**
         * @param {?} title
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
            function (title, content, options) {
                return /** @type {?} */ (this.createMessage({ type: 'error', title: title, content: content }, options));
            };
        /**
         * @param {?} title
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
        NzNotificationService$$1.prototype.info = /**
         * @param {?} title
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
            function (title, content, options) {
                return /** @type {?} */ (this.createMessage({ type: 'info', title: title, content: content }, options));
            };
        /**
         * @param {?} title
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
        NzNotificationService$$1.prototype.warning = /**
         * @param {?} title
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
            function (title, content, options) {
                return /** @type {?} */ (this.createMessage({ type: 'warning', title: title, content: content }, options));
            };
        /**
         * @param {?} title
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
        NzNotificationService$$1.prototype.blank = /**
         * @param {?} title
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
            function (title, content, options) {
                return /** @type {?} */ (this.createMessage({ type: 'blank', title: title, content: content }, options));
            };
        /**
         * @param {?} type
         * @param {?} title
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
        NzNotificationService$$1.prototype.create = /**
         * @param {?} type
         * @param {?} title
         * @param {?} content
         * @param {?=} options
         * @return {?}
         */
            function (type, title, content, options) {
                return /** @type {?} */ (this.createMessage({ type: type, title: title, content: content }, options));
            };
        // For content with template
        /**
         * @param {?} template
         * @param {?=} options
         * @return {?}
         */
        NzNotificationService$$1.prototype.template = /**
         * @param {?} template
         * @param {?=} options
         * @return {?}
         */
            function (template, options) {
                return /** @type {?} */ (this.createMessage({ template: template }, options));
            };
        NzNotificationService$$1.decorators = [
            { type: i0.Injectable, args: [{
                        providedIn: 'root'
                    },] }
        ];
        /** @nocollapse */
        NzNotificationService$$1.ctorParameters = function () {
            return [
                { type: i2.Overlay },
                { type: i0.Injector },
                { type: i0.ComponentFactoryResolver },
                { type: i0.ApplicationRef }
            ];
        };
        /** @nocollapse */ NzNotificationService$$1.ngInjectableDef = i0.defineInjectable({ factory: function NzNotificationService_Factory() { return new NzNotificationService$$1(i0.inject(i2.Overlay), i0.inject(i0.INJECTOR), i0.inject(i0.ComponentFactoryResolver), i0.inject(i0.ApplicationRef)); }, token: NzNotificationService$$1, providedIn: "root" });
        return NzNotificationService$$1;
    }(NzMessageBaseService$$1));

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzNotificationModule = /** @class */ (function () {
        function NzNotificationModule() {
        }
        NzNotificationModule.decorators = [
            { type: i0.NgModule, args: [{
                        imports: [i1.CommonModule, i2.OverlayModule],
                        declarations: [NzNotificationComponent, NzNotificationContainerComponent],
                        providers: [NZ_NOTIFICATION_DEFAULT_CONFIG_PROVIDER, NzNotificationService$$1],
                        entryComponents: [NzNotificationContainerComponent]
                    },] }
        ];
        return NzNotificationModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * @param {?} node
     * @return {?}
     */
    function isCheckDisabled(node) {
        var isDisabled = node.isDisabled, isDisableCheckbox = node.isDisableCheckbox;
        return !!(isDisabled || isDisableCheckbox);
    }
    /**
     * @param {?} needle
     * @param {?} haystack
     * @return {?}
     */
    function isInArray(needle, haystack) {
        return (haystack.length > 0 && haystack.indexOf(needle) > -1);
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzTreeNode = /** @class */ (function () {
        function NzTreeNode(option, parent) {
            if (parent === void 0) {
                parent = null;
            }
            var _this = this;
            this.level = 0;
            this.title = option.title || '---';
            this.key = option.key || null;
            this.isLeaf = option.isLeaf || false;
            this.origin = option;
            this.children = [];
            this.parentNode = parent;
            // option params
            this.isChecked = option.checked || false;
            this.isSelectable = option.disabled || (option.selectable === false ? false : true);
            this.isDisabled = option.disabled || false;
            this.isDisableCheckbox = option.disableCheckbox || false;
            this.isExpanded = option.isLeaf ? false : (option.expanded || false);
            this.isAllChecked = option.checked || false;
            this.isHalfChecked = false;
            this.isSelected = (!option.disabled && option.selected) || false;
            this.isLoading = false;
            this.isMatched = false;
            /**
                 * parent's checked status will affect children while initializing
                 */
            if (parent) {
                this.level = parent.level + 1;
            }
            else {
                this.level = 0;
            }
            if (typeof (option.children) !== 'undefined' && option.children !== null) {
                option.children.forEach(function (nodeOptions) {
                    if (option.checked && !option.disabled && !nodeOptions.disabled && !nodeOptions.disableCheckbox) {
                        nodeOptions.checked = option.checked;
                    }
                    _this.children.push(new NzTreeNode(nodeOptions, _this));
                });
            }
        }
        /**
         * @param {?=} checked
         * @param {?=} halfChecked
         * @return {?}
         */
        NzTreeNode.prototype.setChecked = /**
         * @param {?=} checked
         * @param {?=} halfChecked
         * @return {?}
         */
            function (checked, halfChecked) {
                if (checked === void 0) {
                    checked = false;
                }
                if (halfChecked === void 0) {
                    halfChecked = false;
                }
                this.origin.checked = checked;
                this.isChecked = checked;
                this.isAllChecked = checked;
                this.isHalfChecked = halfChecked;
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzTreeNode.prototype.setExpanded = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.origin.expanded = value;
                this.isExpanded = value;
            };
        /**
         * @param {?} value
         * @return {?}
         */
        NzTreeNode.prototype.setSelected = /**
         * @param {?} value
         * @return {?}
         */
            function (value) {
                this.origin.selected = value;
                this.isSelected = value;
            };
        /**
         * @return {?}
         */
        NzTreeNode.prototype.getParentNode = /**
         * @return {?}
         */
            function () {
                return this.parentNode;
            };
        /**
         * @return {?}
         */
        NzTreeNode.prototype.getChildren = /**
         * @return {?}
         */
            function () {
                return this.children;
            };
        /**
         * 支持按索引位置插入,叶子节点不可添加
         * @param {?} children
         * @param {?=} childPos
         * @return {?}
         */
        NzTreeNode.prototype.addChildren = /**
         * 支持按索引位置插入,叶子节点不可添加
         * @param {?} children
         * @param {?=} childPos
         * @return {?}
         */
            function (children, childPos) {
                var _this = this;
                if (childPos === void 0) {
                    childPos = -1;
                }
                if (!this.isLeaf) {
                    children.forEach(function (node) {
                        /** @type {?} */
                        var refreshLevel = function (n) {
                            n.getChildren().forEach(function (c) {
                                c.level = c.getParentNode().level + 1;
                                // flush origin
                                c.origin.level = c.level;
                                refreshLevel(c);
                            });
                        };
                        /** @type {?} */
                        var child = node;
                        if (child instanceof NzTreeNode) {
                            child.parentNode = _this;
                        }
                        else {
                            child = new NzTreeNode(node, _this);
                        }
                        child.level = _this.level + 1;
                        child.origin.level = child.level;
                        refreshLevel(child);
                        try {
                            childPos === -1 ? _this.children.push(child) : _this.children.splice(childPos, 0, child);
                            // flush origin
                        }
                        catch (e) {
                        }
                    });
                    this.origin.children = this.getChildren().map(function (v) { return v.origin; });
                    // remove loading state
                    this.isLoading = false;
                }
            };
        /**
         * @return {?}
         */
        NzTreeNode.prototype.clearChildren = /**
         * @return {?}
         */
            function () {
                this.children = [];
            };
        return NzTreeNode;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var NzTreeService = /** @class */ (function () {
        function NzTreeService() {
            this.DRAG_SIDE_RANGE = 0.25;
            this.DRAG_MIN_GAP = 2;
            this.conductOption = {
                isCheckStrictly: false
            };
            this.rootNodes = [];
            this.selectedNodeList = [];
            this.expandedNodeList = [];
            this.checkedNodeList = [];
            this.halfCheckedNodeList = [];
            this.matchedNodeList = [];
        }
        /**
         * reset tree nodes will clear default node list
         */
        /**
         * reset tree nodes will clear default node list
         * @param {?} nzNodes
         * @return {?}
         */
        NzTreeService.prototype.initTree = /**
         * reset tree nodes will clear default node list
         * @param {?} nzNodes
         * @return {?}
         */
            function (nzNodes) {
                var _this = this;
                this.rootNodes = nzNodes;
                this.expandedNodeList = [];
                this.selectedNodeList = [];
                this.halfCheckedNodeList = [];
                this.checkedNodeList = [];
                this.expandedNodeList = [];
                this.matchedNodeList = [];
                setTimeout(function () {
                    _this.refreshCheckState(_t