import { AfterViewInit, ChangeDetectorRef, ElementRef, EventEmitter, Injector, OnChanges, OnDestroy, OnInit, Renderer2, SimpleChanges, TemplateRef, Type, ViewContainerRef } from '@angular/core';
import { FocusTrap, FocusTrapFactory } from '@angular/cdk/a11y';
import { Overlay, OverlayRef } from '@angular/cdk/overlay';
import { CdkPortalOutlet, TemplatePortal } from '@angular/cdk/portal';
import { Observable, Subject } from 'rxjs';
import { NzScrollStrategyOptions } from '../core/overlay/scroll/nz-scroll-strategy-options';
import { NzDrawerOptions, NzDrawerPlacement } from './nz-drawer-options';
import { NzDrawerRef } from './nz-drawer-ref';
export declare const DRAWER_ANIMATE_DURATION = 300;
export declare class NzDrawerComponent<T = any, R = any, D = any> extends NzDrawerRef<R> implements OnInit, OnDestroy, AfterViewInit, OnChanges, NzDrawerOptions {
    private document;
    private renderer;
    private overlay;
    private elementRef;
    private injector;
    private changeDetectorRef;
    private focusTrapFactory;
    private nzScrollStrategyOptions;
    private viewContainerRef;
    previouslyFocusedElement: HTMLElement;
    nzContentParams: D;
    overlayRef: OverlayRef;
    portal: TemplatePortal;
    focusTrap: FocusTrap;
    isOpen: boolean;
    templateContext: {
        $implicit: D;
        drawerRef: NzDrawerRef<R>;
    };
    readonly transform: string;
    readonly width: string;
    readonly height: string;
    readonly isLeftOrRight: boolean;
    drawerTemplate: TemplateRef<{}>;
    contentTemplate: TemplateRef<{}>;
    bodyPortalOutlet: CdkPortalOutlet;
    nzContent: TemplateRef<{
        $implicit: D;
        drawerRef: NzDrawerRef<R>;
    }> | Type<T>;
    nzClosable: boolean;
    nzMaskClosable: boolean;
    nzMask: boolean;
    nzTitle: string | TemplateRef<{}>;
    nzPlacement: NzDrawerPlacement;
    nzMaskStyle: object;
    nzBodyStyle: object;
    nzWrapClassName: string;
    nzWidth: number | string;
    nzHeight: number | string;
    nzZIndex: number;
    nzOffsetX: number;
    nzOffsetY: number;
    nzVisible: boolean;
    nzOnViewInit: EventEmitter<void>;
    nzOnClose: EventEmitter<MouseEvent>;
    nzAfterOpen: Subject<void>;
    nzAfterClose: Subject<R>;
    readonly afterOpen: Observable<void>;
    readonly afterClose: Observable<R>;
    isNonEmptyString(value: {}): boolean;
    isTemplateRef(value: {}): boolean;
    constructor(document: any, renderer: Renderer2, overlay: Overlay, elementRef: ElementRef, injector: Injector, changeDetectorRef: ChangeDetectorRef, focusTrapFactory: FocusTrapFactory, nzScrollStrategyOptions: NzScrollStrategyOptions, viewContainerRef: ViewContainerRef);
    ngOnInit(): void;
    ngAfterViewInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    close(result?: R): void;
    open(): void;
    closeClick(): void;
    maskClick(): void;
    private attachBodyContent;
    private attachOverlay;
    private disposeOverlay;
    private getOverlayConfig;
    private updateOverlayStyle;
    private updateBodyOverflow;
    savePreviouslyFocusedElement(): void;
    private trapFocus;
    private restoreFocus;
}
