import { CdkConnectedOverlay, ConnectedOverlayPositionChange, ConnectionPositionPair } from '@angular/cdk/overlay';
import { AfterViewInit, ChangeDetectorRef, EventEmitter, OnDestroy, OnInit, Renderer2 } from '@angular/core';
import { BehaviorSubject, Observable, Subject } from 'rxjs';
import { NzMenuDirective } from '../menu/nz-menu.directive';
import { NzDropDownDirective } from './nz-dropdown.directive';
export declare type NzPlacement = 'bottomLeft' | 'bottomCenter' | 'bottomRight' | 'topLeft' | 'topCenter' | 'topRight';
export declare class NzDropDownComponent implements OnInit, OnDestroy, AfterViewInit {
    private renderer;
    protected changeDetector: ChangeDetectorRef;
    private _clickHide;
    private _visible;
    private _disabled;
    private unsubscribe$;
    hasFilterButton: boolean;
    triggerWidth: number;
    placement: NzPlacement;
    dropDownPosition: 'top' | 'center' | 'bottom';
    positions: ConnectionPositionPair[];
    $subOpen: BehaviorSubject<boolean>;
    $visibleChange: Subject<boolean>;
    nzOrigin: NzDropDownDirective;
    nzMenu: NzMenuDirective;
    nzTrigger: 'click' | 'hover';
    nzVisibleChange: EventEmitter<boolean>;
    cdkOverlay: CdkConnectedOverlay;
    nzClickHide: boolean;
    nzDisabled: boolean;
    nzVisible: boolean;
    nzPlacement: NzPlacement;
    onClickEvent(): void;
    onMouseEnterEvent(): void;
    onMouseLeaveEvent(): void;
    hide(): void;
    show(): void;
    onPositionChange(position: ConnectedOverlayPositionChange): void;
    setTriggerWidth(): void;
    startSubscribe(observable$: Observable<boolean>): void;
    onVisibleChange: (visible: boolean) => void;
    ngOnInit(): void;
    ngOnDestroy(): void;
    ngAfterViewInit(): void;
    readonly hasBackdrop: boolean;
    constructor(renderer: Renderer2, changeDetector: ChangeDetectorRef);
}
