import { Component, ViewEncapsulation } from '@angular/core';

@Component({
  selector: '<%= selector %>',
  encapsulation: ViewEncapsulation.None,
  <% if(inlineTemplate) { %>template: `
    <div class="example-input">
      <textarea placeholder="input here" nz-input row="4"  [(ngModel)]="inputValue" (input)="onInput($event.target?.value)" [nzAutocomplete]="auto"></textarea>
      <nz-autocomplete #auto>
        <nz-auto-option *ngFor="let option of options" [nzValue]="option">{{option}}</nz-auto-option>
      </nz-autocomplete>
    </div>
`<% } else { %>templateUrl: './<%= dasherize(name) %>.component.html'<% } %>
})
export class <%= classify(name) %>Component {
  inputValue: string;
  options = [];

  onInput(value: string): void {
    this.options = value ? [
      value,
      value + value,
      value + value + value,
    ] : [];
  }
}
