import { Component } from '@angular/core';

@Component({
  selector: '<%= selector %>',
  <% if(inlineTemplate) { %>template: `
    <button
      nz-button
      nzType="primary"
      nz-popover
      nzTitle="Title"
      [(nzVisible)]="visible"
      (nzVisibleChange)="change($event)"
      nzTrigger="click"
      [nzContent]="contentTemplate">
      Click me
    </button>
    <ng-template #contentTemplate>
      <a (click)='clickMe()'>Close</a>
    </ng-template>
  `<% } else { %>templateUrl: './<%= dasherize(name) %>.component.html'<% } %>
})
export class <%= classify(name) %>Component {
  visible: boolean;

  clickMe(): void {
    this.visible = false;
  }

  change(value: boolean): void {
    console.log(value);
  }
}
