import { Component } from '@angular/core';

@Component({
  selector: '<%= selector %>',
  <% if(inlineTemplate) { %>template: `
    <nz-tabset>
      <nz-tab
        *ngFor="let tab of tabs"
        [nzTitle]="tab.name"
        [nzDisabled]="tab.disabled">
        {{ tab.name }}
      </nz-tab>
    </nz-tabset>`<% } else { %>templateUrl: './<%= dasherize(name) %>.component.html'<% } %>
})
export class <%= classify(name) %>Component {
  tabs = [
    {
      name    : 'Tab 1',
      disabled: false
    },
    {
      name    : 'Tab 2',
      disabled: true
    },
    {
      name    : 'Tab 3',
      disabled: false
    }
  ];
}
