import { Component } from '@angular/core';
import { NzMessageService, UploadFile } from 'ng-zorro-antd';

@Component({
  selector: '<%= selector %>',
  <% if(inlineTemplate) { %>template: `
  <div class="clearfix">
    <nz-upload
      nzAction="https://jsonplaceholder.typicode.com/posts/"
      nzListType="picture"
      [(nzFileList)]="fileList1">
      <button nz-button>
        <i class="anticon anticon-upload"></i><span>Upload</span>
      </button>
    </nz-upload>
  </div>
    <br><br>
  <div class="clearfix">
    <nz-upload class="upload-list-inline"
      nzAction="https://jsonplaceholder.typicode.com/posts/"
      nzListType="picture"
      [(nzFileList)]="fileList2">
      <button nz-button>
        <span><i class="anticon anticon-upload"></i> Upload</span>
      </button>
    </nz-upload>
  </div>
  `<% } else { %>templateUrl: './<%= dasherize(name) %>.component.html'<% } %>,
  <% if(inlineStyle) { %>styles: [`
  :host ::ng-deep .upload-list-inline .ant-upload-list-item {
    float: left;
    width: 200px;
    margin-right: 8px;
  }
  `]<% } else { %>styleUrls: ['./<%= dasherize(name) %>.component.<%= styleext %>']<% } %>
})
export class <%= classify(name) %>Component {
  defaultFileList = [
    {
      uid: -1,
      name: 'xxx.png',
      status: 'done',
      url: 'https://zos.alipayobjects.com/rmsportal/jkjgkEfvpUPVyRjUImniVslZfWPnJuuZ.png',
      thumbUrl: 'https://zos.alipayobjects.com/rmsportal/jkjgkEfvpUPVyRjUImniVslZfWPnJuuZ.png'
    },
    {
      uid: -2,
      name: 'yyy.png',
      status: 'done',
      url: 'https://zos.alipayobjects.com/rmsportal/jkjgkEfvpUPVyRjUImniVslZfWPnJuuZ.png',
      thumbUrl: 'https://zos.alipayobjects.com/rmsportal/jkjgkEfvpUPVyRjUImniVslZfWPnJuuZ.png'
    }
  ];

  fileList1 = [...this.defaultFileList];
  fileList2 = [...this.defaultFileList];

  constructor(private msg: NzMessageService) {}
}
