import { ElementRef, EventEmitter, OnChanges, OnDestroy, OnInit, SimpleChanges } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { Observable, Subscription } from 'rxjs';
import { Marks } from './nz-slider-marks.component';
import { NzSliderService } from './nz-slider.service';
export declare type SliderValue = number[] | number;
export declare class SliderHandle {
    offset: number;
    value: number;
    active: boolean;
}
export declare class NzSliderComponent implements ControlValueAccessor, OnInit, OnChanges, OnDestroy {
    private utils;
    nzDebugId: number | string;
    nzDisabled: boolean;
    nzStep: number;
    nzMarks: Marks;
    nzMin: number;
    nzMax: number;
    nzDefaultValue: SliderValue;
    nzTipFormatter: (value: number) => string;
    nzOnAfterChange: EventEmitter<number | number[]>;
    nzVertical: boolean;
    nzRange: boolean;
    nzDots: boolean;
    nzIncluded: boolean;
    private _disabled;
    private _dots;
    private _included;
    private _range;
    private _vertical;
    value: SliderValue;
    slider: ElementRef;
    sliderDOM: HTMLDivElement;
    cacheSliderStart: number;
    cacheSliderLength: number;
    prefixCls: string;
    classMap: object;
    activeValueIndex: number;
    track: {
        offset: any;
        length: any;
    };
    handles: SliderHandle[];
    marksArray: Marks[];
    bounds: {
        lower: any;
        upper: any;
    };
    onValueChange: (value: SliderValue) => void;
    onTouched: () => void;
    isDragging: boolean;
    dragstart$: Observable<number>;
    dragmove$: Observable<number>;
    dragend$: Observable<Event>;
    dragstart_: Subscription;
    dragmove_: Subscription;
    dragend_: Subscription;
    setValue(val: SliderValue, isWriteValue?: boolean): void;
    getValue(cloneAndSort?: boolean): SliderValue;
    getValueToOffset(value?: SliderValue): SliderValue;
    writeValue(val: SliderValue): void;
    registerOnChange(fn: (value: SliderValue) => void): void;
    registerOnTouched(fn: () => void): void;
    setDisabledState(isDisabled: boolean): void;
    constructor(utils: NzSliderService);
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    setClassMap(): void;
    setActiveValueIndex(pointerValue: number): void;
    setActiveValue(pointerValue: number): void;
    updateTrackAndHandles(): void;
    toMarksArray(marks: Marks): Marks[];
    onDragStart(value: number): void;
    onDragMove(value: number): void;
    onDragEnd(): void;
    createDrag(): void;
    subscribeDrag(periods?: string[]): void;
    unsubscribeDrag(periods?: string[]): void;
    toggleDragMoving(movable: boolean): void;
    toggleDragDisabled(disabled: boolean): void;
    findClosestValue(position: number): number;
    valueToOffset(value: number): number;
    getSliderStartPosition(): number;
    getSliderLength(): number;
    cacheSliderProperty(remove?: boolean): void;
    formatValue(value: SliderValue): SliderValue;
    checkValidValue(value: SliderValue): boolean;
    isValueEqual(value: SliderValue, val: SliderValue): boolean;
    log(...messages: any[]): void;
    private _showHandleTooltip;
    private _hideAllHandleTooltip;
    private _generateHandles;
}
