import { CdkOverlayOrigin, ConnectionPositionPair, Overlay, OverlayPositionBuilder } from '@angular/cdk/overlay';
import { AfterViewInit, ElementRef, EventEmitter, OnInit, Renderer2, TemplateRef } from '@angular/core';
import { ControlValueAccessor } from '@angular/forms';
import { NzUpdateHostClassService as UpdateCls } from '../core/services/update-host-class.service';
import { NzI18nService as I18n } from '../i18n/nz-i18n.service';
export declare class NzTimePickerComponent implements ControlValueAccessor, OnInit, AfterViewInit {
    private element;
    private renderer;
    private overlay;
    private positionBuilder;
    private i18n;
    private updateCls;
    private _disabled;
    private _value;
    private _allowEmpty;
    private _autoFocus;
    private _onChange;
    private _onTouched;
    private _hideDisabledOptions;
    isInit: boolean;
    origin: CdkOverlayOrigin;
    overlayPositions: ConnectionPositionPair[];
    inputRef: ElementRef;
    nzSize: string | null;
    nzHourStep: number;
    nzMinuteStep: number;
    nzSecondStep: number;
    nzClearText: string;
    nzPopupClassName: string;
    nzPlaceHolder: string;
    nzAddOn: TemplateRef<void>;
    nzDefaultOpenValue: Date;
    nzDisabledHours: () => number[];
    nzDisabledMinutes: (hour: number) => number[];
    nzDisabledSeconds: (hour: number, minute: number) => number[];
    nzFormat: string;
    nzOpen: boolean;
    nzOpenChange: EventEmitter<boolean>;
    nzHideDisabledOptions: boolean;
    nzAllowEmpty: boolean;
    nzAutoFocus: boolean;
    nzDisabled: boolean | string;
    value: Date | null;
    open(): void;
    close(): void;
    updateAutoFocus(): void;
    private setClassMap;
    focus(): void;
    blur(): void;
    constructor(element: ElementRef, renderer: Renderer2, overlay: Overlay, positionBuilder: OverlayPositionBuilder, i18n: I18n, updateCls: UpdateCls);
    ngOnInit(): void;
    ngAfterViewInit(): void;
    writeValue(time: Date | null): void;
    registerOnChange(fn: (time: Date) => void): void;
    registerOnTouched(fn: () => void): void;
    setDisabledState(isDisabled: boolean): void;
}
