import { ElementRef, EventEmitter, OnChanges, OnDestroy, OnInit, SimpleChanges, TemplateRef } from '@angular/core';
import { Observable } from 'rxjs';
import { NzI18nService } from '../i18n/nz-i18n.service';
import { TransferCanMove, TransferChange, TransferItem, TransferSearchChange, TransferSelectChange } from './interface';
export declare class NzTransferComponent implements OnInit, OnChanges, OnDestroy {
    private i18n;
    private el;
    private unsubscribe$;
    locale: any;
    private _showSearch;
    leftFilter: string;
    rightFilter: string;
    nzDataSource: TransferItem[];
    nzTitles: string[];
    nzOperations: string[];
    nzListStyle: object;
    nzItemUnit: string;
    nzItemsUnit: string;
    nzCanMove: (arg: TransferCanMove) => Observable<TransferItem[]>;
    nzRender: TemplateRef<void>;
    nzFooter: TemplateRef<void>;
    nzShowSearch: boolean;
    nzFilterOption: (inputValue: string, item: TransferItem) => boolean;
    nzSearchPlaceholder: string;
    nzNotFoundContent: string;
    nzChange: EventEmitter<TransferChange>;
    nzSearchChange: EventEmitter<TransferSearchChange>;
    nzSelectChange: EventEmitter<TransferSelectChange>;
    leftDataSource: TransferItem[];
    rightDataSource: TransferItem[];
    private splitDataSource;
    private getCheckedData;
    handleLeftSelectAll: (checked: boolean) => void;
    handleRightSelectAll: (checked: boolean) => void;
    handleLeftSelect: (item: TransferItem) => void;
    handleRightSelect: (item: TransferItem) => void;
    handleSelect(direction: 'left' | 'right', checked: boolean, item?: TransferItem): void;
    handleFilterChange(ret: {
        direction: string;
        value: string;
    }): void;
    leftActive: boolean;
    rightActive: boolean;
    private updateOperationStatus;
    moveToLeft: () => void;
    moveToRight: () => void;
    moveTo(direction: string): void;
    private truthMoveTo;
    constructor(i18n: NzI18nService, el: ElementRef);
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
}
