import { ChangeDetectorRef, EventEmitter, OnChanges, OnDestroy, OnInit, SimpleChange, SimpleChanges } from '@angular/core';
import { Observable, Subscription } from 'rxjs';
import { NzI18nService } from '../i18n/nz-i18n.service';
import { ShowUploadListInterface, UploadChangeParam, UploadFile, UploadFilter, UploadListType, UploadType, ZipButtonOptions } from './interface';
import { NzUploadBtnComponent } from './nz-upload-btn.component';
export declare class NzUploadComponent implements OnInit, OnChanges, OnDestroy {
    private cd;
    private i18n;
    private i18n$;
    locale: any;
    upload: NzUploadBtnComponent;
    nzType: UploadType;
    private _limit;
    nzLimit: number;
    private _size;
    nzSize: number;
    nzFileType: string;
    nzAccept: string | string[];
    nzAction: string;
    nzDirectory: boolean;
    nzBeforeUpload: (file: UploadFile, fileList: UploadFile[]) => boolean | Observable<any>;
    nzCustomRequest: (item: any) => Subscription;
    nzData: {} | ((file: UploadFile) => {});
    nzFilter: UploadFilter[];
    nzFileList: UploadFile[];
    nzFileListChange: EventEmitter<UploadFile[]>;
    private _disabled;
    nzDisabled: boolean;
    nzHeaders: {} | ((file: UploadFile) => {});
    nzListType: UploadListType;
    private _multiple;
    nzMultiple: boolean;
    nzName: string;
    private _showUploadList;
    nzShowUploadList: boolean | ShowUploadListInterface;
    private _showBtn;
    nzShowButton: boolean;
    private _withCredentials;
    nzWithCredentials: boolean;
    nzRemove: (file: UploadFile) => boolean | Observable<boolean>;
    nzPreview: (file: UploadFile) => void;
    nzChange: EventEmitter<UploadChangeParam>;
    _btnOptions: ZipButtonOptions;
    private zipOptions;
    constructor(cd: ChangeDetectorRef, i18n: NzI18nService);
    private fileToObject;
    private getFileItem;
    private removeFileItem;
    private genErr;
    private genThumb;
    private onStart;
    private onProgress;
    private onSuccess;
    private onError;
    private dragState;
    fileDrop(e: DragEvent): void;
    onRemove: (file: UploadFile) => void;
    prefixCls: string;
    classList: string[];
    setClassMap(): void;
    ngOnInit(): void;
    ngOnChanges(changes: {
        [P in keyof this]?: SimpleChange;
    } & SimpleChanges): void;
    ngOnDestroy(): void;
}
