"use strict";
var core_1 = require("@angular/core");
var ng2_auto_complete_component_1 = require("./ng2-auto-complete.component");
var forms_1 = require("@angular/forms");
/**
 * display auto-complete section with input and dropdown list when it is clicked
 */
var Ng2AutoCompleteDirective = (function () {
    function Ng2AutoCompleteDirective(resolver, renderer, viewContainerRef, parentForm) {
        var _this = this;
        this.resolver = resolver;
        this.renderer = renderer;
        this.viewContainerRef = viewContainerRef;
        this.parentForm = parentForm;
        this.loadingText = "Loading";
        this.ngModelChange = new core_1.EventEmitter();
        this.valueChanged = new core_1.EventEmitter();
        //show auto-complete list below the current element
        this.showAutoCompleteDropdown = function (event) {
            var factory = _this.resolver.resolveComponentFactory(ng2_auto_complete_component_1.Ng2AutoCompleteComponent);
            _this.componentRef = _this.viewContainerRef.createComponent(factory);
            var component = _this.componentRef.instance;
            component.showInputTag = false; //Do NOT display autocomplete input tag separately
            component.pathToData = _this.pathToData;
            component.minChars = _this.minChars;
            component.valuePropertyName = _this.valuePropertyName || "id";
            component.displayPropertyName = _this.displayPropertyName || "value";
            component.source = _this.source;
            component.placeholder = _this.autoCompletePlaceholder;
            component.acceptUserInput = _this.acceptUserInput;
            component.maxNumList = parseInt(_this.maxNumList, 10);
            component.loadingText = _this.loadingText;
            component.listFormatter = _this.listFormatter;
            component.blankOptionText = _this.blankOptionText;
            component.noMatchFoundText = _this.noMatchFoundText;
            component.valueSelected.subscribe(_this.selectNewValue);
            component.inputChanged.subscribe(_this.componentInputChanged);
            _this.acDropdownEl = _this.componentRef.location.nativeElement;
            _this.acDropdownEl.style.display = "none";
            // if this element is not an input tag, move dropdown after input tag
            // so that it displays correctly
            if (_this.el.tagName !== "INPUT" && _this.acDropdownEl) {
                _this.inputEl.parentElement.insertBefore(_this.acDropdownEl, _this.inputEl.nextSibling);
            }
            setTimeout(function () {
                component.reloadList(_this.inputEl.value);
                _this.styleAutoCompleteDropdown();
                component.dropdownVisible = true;
            });
        };
        this.hideAutoCompleteDropdown = function (event) {
            if (_this.componentRef) {
                _this.componentRef.destroy();
                _this.componentRef = undefined;
            }
        };
        this.styleAutoCompleteDropdown = function () {
            if (_this.componentRef) {
                var component = _this.componentRef.instance;
                /* setting width/height auto complete */
                var thisElBCR = _this.el.getBoundingClientRect();
                var thisInputElBCR = _this.inputEl.getBoundingClientRect();
                var closeToBottom = thisInputElBCR.bottom + 100 > window.innerHeight;
                _this.acDropdownEl.style.width = thisElBCR.width + "px";
                _this.acDropdownEl.style.position = "absolute";
                _this.acDropdownEl.style.zIndex = "1";
                _this.acDropdownEl.style.left = "0";
                _this.acDropdownEl.style.display = "inline-block";
                if (closeToBottom) {
                    _this.acDropdownEl.style.bottom = thisInputElBCR.height + "px";
                }
                else {
                    _this.acDropdownEl.style.top = thisInputElBCR.height + "px";
                }
            }
        };
        this.componentInputChanged = function (val) {
            if (_this.acceptUserInput !== false) {
                _this.inputEl.value = val;
                if ((_this.parentForm && _this.formControlName) || _this.extFormControl) {
                    _this.formControl.patchValue(val);
                }
                (val !== _this.ngModel) && _this.ngModelChange.emit(val);
                _this.valueChanged.emit(val);
            }
        };
        this.selectNewValue = function (val) {
            if (val !== '') {
                val = _this.addToStringFunction(val);
            }
            if ((_this.parentForm && _this.formControlName) || _this.extFormControl) {
                if (!!val) {
                    _this.formControl.patchValue(val);
                }
            }
            (val !== _this.ngModel) && _this.ngModelChange.emit(val);
            _this.valueChanged.emit(val);
            _this.inputEl && (_this.inputEl.value = '' + val);
            _this.hideAutoCompleteDropdown();
        };
        // private elementIn(el: Node, containerEl: Node): boolean {
        //   while (el = el.parentNode) {
        //     if (el === containerEl) {
        //       return true;
        //     }
        //   }
        //   return false;
        // }
        this.keydownEventHandler = function (evt) {
            if (_this.componentRef) {
                var component = _this.componentRef.instance;
                component.inputElKeyHandler(evt);
            }
        };
        this.inputEventHandler = function (evt) {
            if (_this.componentRef) {
                var component = _this.componentRef.instance;
                component.dropdownVisible = true;
                component.reloadListInDelay(evt);
            }
            else {
                _this.showAutoCompleteDropdown();
            }
        };
        this.el = this.viewContainerRef.element.nativeElement;
    }
    Ng2AutoCompleteDirective.prototype.ngOnInit = function () {
        // wrap this element with <div class="ng2-auto-complete">
        this.wrapperEl = document.createElement("div");
        this.wrapperEl.className = "ng2-auto-complete-wrapper";
        this.wrapperEl.style.position = "relative";
        this.el.parentElement.insertBefore(this.wrapperEl, this.el.nextSibling);
        this.wrapperEl.appendChild(this.el);
        //Check if we were supplied with a [formControlName] and it is inside a [form]
        //else check if we are supplied with a [FormControl] regardless if it is inside a [form] tag
        if (this.parentForm && this.formControlName) {
            if (this.parentForm['form']) {
                this.formControl = this.parentForm['form'].get(this.formControlName);
            }
            else if (this.parentForm instanceof forms_1.FormGroupName) {
                this.formControl = this.parentForm.control.controls[this.formControlName];
            }
        }
        else if (this.extFormControl) {
            this.formControl = this.extFormControl;
        }
        // apply toString() method for the object
        if (!!this.ngModel) {
            this.selectNewValue(this.ngModel);
        }
        else if (!!this.formControl && this.formControl.value) {
            this.selectNewValue(this.formControl.value[this.displayPropertyName]);
        }
        // when somewhere else clicked, hide this autocomplete
        //document.addEventListener("click", this.hideAutoCompleteDropdown);
    };
    Ng2AutoCompleteDirective.prototype.ngAfterViewInit = function () {
        // if this element is not an input tag, move dropdown after input tag
        // so that it displays correctly
        this.inputEl = this.el.tagName === "INPUT" ?
            this.el : this.el.querySelector("input");
        this.inputEl.addEventListener('focus', this.showAutoCompleteDropdown);
        this.inputEl.addEventListener('blur', this.hideAutoCompleteDropdown);
        this.inputEl.addEventListener('keydown', this.keydownEventHandler);
        this.inputEl.addEventListener('input', this.inputEventHandler);
    };
    Ng2AutoCompleteDirective.prototype.ngOnDestroy = function () {
        if (this.componentRef) {
            this.componentRef.instance.valueSelected.unsubscribe();
            this.componentRef.instance.inputChanged.unsubscribe();
        }
        //document.removeEventListener("click", this.hideAutoCompleteDropdown);
    };
    Ng2AutoCompleteDirective.prototype.ngOnChanges = function (changes) {
        if (changes['ngModel']) {
            this.ngModel = this.addToStringFunction(changes['ngModel'].currentValue);
        }
    };
    Ng2AutoCompleteDirective.prototype.addToStringFunction = function (val) {
        if (val && typeof val === "object") {
            var displayVal_1 = val[this.displayPropertyName || "value"];
            val.toString = function () {
                return displayVal_1;
            };
        }
        return val;
    };
    Ng2AutoCompleteDirective.decorators = [
        { type: core_1.Directive, args: [{
                    selector: "[auto-complete], [ng2-auto-complete]"
                },] },
    ];
    /** @nocollapse */
    Ng2AutoCompleteDirective.ctorParameters = function () { return [
        { type: core_1.ComponentFactoryResolver, },
        { type: core_1.Renderer, },
        { type: core_1.ViewContainerRef, },
        { type: forms_1.ControlContainer, decorators: [{ type: core_1.Optional }, { type: core_1.Host }, { type: core_1.SkipSelf },] },
    ]; };
    Ng2AutoCompleteDirective.propDecorators = {
        'autoCompletePlaceholder': [{ type: core_1.Input, args: ["auto-complete-placeholder",] },],
        'source': [{ type: core_1.Input, args: ["source",] },],
        'pathToData': [{ type: core_1.Input, args: ["path-to-data",] },],
        'minChars': [{ type: core_1.Input, args: ["min-chars",] },],
        'valuePropertyName': [{ type: core_1.Input, args: ["value-property-name",] },],
        'displayPropertyName': [{ type: core_1.Input, args: ["display-property-name",] },],
        'acceptUserInput': [{ type: core_1.Input, args: ["accept-user-input",] },],
        'maxNumList': [{ type: core_1.Input, args: ["max-num-list",] },],
        'listFormatter': [{ type: core_1.Input, args: ["list-formatter",] },],
        'loadingText': [{ type: core_1.Input, args: ["loading-text",] },],
        'blankOptionText': [{ type: core_1.Input, args: ["blank-option-text",] },],
        'noMatchFoundText': [{ type: core_1.Input, args: ["no-match-found-text",] },],
        'ngModel': [{ type: core_1.Input },],
        'formControlName': [{ type: core_1.Input, args: ['formControlName',] },],
        'extFormControl': [{ type: core_1.Input, args: ['formControl',] },],
        'ngModelChange': [{ type: core_1.Output },],
        'valueChanged': [{ type: core_1.Output },],
    };
    return Ng2AutoCompleteDirective;
}());
exports.Ng2AutoCompleteDirective = Ng2AutoCompleteDirective;
//# sourceMappingURL=ng2-auto-complete.directive.js.map