import { OnInit, OnDestroy } from 'angular2/core';
export declare enum Direction {
    UNKNOWN = 0,
    NEXT = 1,
    PREV = 2,
}
export declare class Carousel implements OnDestroy {
    private noWrap;
    private noPause;
    private noTransition;
    interval: number;
    private slides;
    private currentInterval;
    private isPlaying;
    private destroyed;
    private currentSlide;
    private _interval;
    ngOnDestroy(): void;
    select(nextSlide: Slide, direction?: Direction): void;
    private goNext(slide, direction);
    private getSlideByIndex(index);
    private getCurrentIndex();
    private next();
    private prev();
    private restartTimer();
    private resetTimer();
    play(): void;
    pause(): void;
    addSlide(slide: Slide): void;
    removeSlide(slide: Slide): void;
}
export declare class Slide implements OnInit, OnDestroy {
    private carousel;
    index: number;
    direction: Direction;
    active: boolean;
    private addClass;
    constructor(carousel: Carousel);
    ngOnInit(): void;
    ngOnDestroy(): void;
}
export declare const CAROUSEL_DIRECTIVES: Array<any>;
export declare const carousel: Array<any>;
