import { EventEmitter, OnInit, ElementRef, Renderer, DynamicComponentLoader } from 'angular2/core';
import { NgModel } from 'angular2/common';
export declare class TypeaheadOptions {
    placement: string;
    animation: boolean;
    constructor(options: TypeaheadOptions);
}
export declare class TypeaheadContainer {
    element: ElementRef;
    parent: Typeahead;
    query: any;
    private _matches;
    private _field;
    private _active;
    private top;
    private left;
    private display;
    private placement;
    constructor(element: ElementRef, options: TypeaheadOptions);
    matches: Array<string>;
    field: string;
    position(hostEl: ElementRef): void;
    selectActiveMatch(): void;
    prevActiveMatch(): void;
    nextActiveMatch(): void;
    private selectActive(value);
    private isActive(value);
    private selectMatch(value, e?);
    private hightlight(item, query);
}
export declare class Typeahead implements OnInit {
    private cd;
    private element;
    private renderer;
    private loader;
    typeaheadLoading: EventEmitter<boolean>;
    typeaheadNoResults: EventEmitter<boolean>;
    typeaheadOnSelect: EventEmitter<{
        item: any;
    }>;
    container: TypeaheadContainer;
    minLength: number;
    waitMs: number;
    optionsLimit: number;
    latinize: boolean;
    singleWords: boolean;
    private appendToBody;
    private editable;
    private focusFirst;
    private inputFormatter;
    private selectOnExact;
    private templateUrl;
    private popupTemplateUrl;
    private selectOnBlur;
    private focusOnSelect;
    private field;
    private async;
    private wordDelimiters;
    private phraseDelimiters;
    private debouncer;
    private source;
    private _matches;
    private placement;
    private popup;
    constructor(cd: NgModel, element: ElementRef, renderer: Renderer, loader: DynamicComponentLoader);
    matches: any[];
    private debounce(func, wait);
    private processMatches();
    private testMatch(match, test);
    private finalizeAsyncCall();
    ngOnInit(): void;
    onChange(e: KeyboardEvent): void;
    changeModel(value: any): void;
    show(matches: Array<any>): void;
    hide(): void;
}
