var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('angular2/core');
var common_1 = require('angular2/common');
// https://github.com/angular/angular/blob/master/modules/angular2/src/core/forms/directives/shared.ts
function setProperty(renderer, elementRef, propName, propValue) {
    renderer.setElementProperty(elementRef, propName, propValue);
}
var core_2 = require('angular2/core');
var ng2_bootstrap_config_1 = require('../ng2-bootstrap-config');
var position_1 = require('../position');
var typeahead_utils_1 = require('./typeahead-utils');
var TEMPLATE = (_a = {},
    _a[ng2_bootstrap_config_1.Ng2BootstrapTheme.BS4] = "\n  <div class=\"dropdown-menu\"\n      [ngStyle]=\"{top: top, left: left, display: display}\"\n      style=\"display: block\">\n      <a href=\"#\"\n         *ngFor=\"#match of matches\"\n         (click)=\"selectMatch(match, $event)\"\n         [ngClass]=\"{active: isActive(match) }\"\n         (mouseenter)=\"selectActive(match)\"\n         class=\"dropdown-item\"\n         [innerHtml]=\"hightlight(match, query)\"></a>\n  </div>\n  ",
    _a[ng2_bootstrap_config_1.Ng2BootstrapTheme.BS3] = "\n  <ul class=\"dropdown-menu\"\n      [ngStyle]=\"{top: top, left: left, display: display}\"\n      style=\"display: block\">\n    <li *ngFor=\"#match of matches\"\n        [ngClass]=\"{active: isActive(match) }\"\n        (mouseenter)=\"selectActive(match)\">\n        <a href=\"#\" (click)=\"selectMatch(match, $event)\" tabindex=\"-1\" [innerHtml]=\"hightlight(match, query)\"></a>\n    </li>\n  </ul>\n  ",
    _a
);
var TypeaheadOptions = (function () {
    function TypeaheadOptions(options) {
        Object.assign(this, options);
    }
    return TypeaheadOptions;
})();
exports.TypeaheadOptions = TypeaheadOptions;
var TypeaheadContainer = (function () {
    function TypeaheadContainer(element, options) {
        this.element = element;
        this._matches = [];
        Object.assign(this, options);
    }
    Object.defineProperty(TypeaheadContainer.prototype, "matches", {
        get: function () {
            return this._matches;
        },
        set: function (value) {
            this._matches = value;
            if (this._matches.length > 0) {
                this._active = this._matches[0];
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TypeaheadContainer.prototype, "field", {
        set: function (value) {
            this._field = value;
        },
        enumerable: true,
        configurable: true
    });
    TypeaheadContainer.prototype.position = function (hostEl) {
        this.display = 'block';
        this.top = '0px';
        this.left = '0px';
        var p = position_1.positionService
            .positionElements(hostEl.nativeElement, this.element.nativeElement.children[0], this.placement, false);
        this.top = p.top + 'px';
        this.left = p.left + 'px';
    };
    TypeaheadContainer.prototype.selectActiveMatch = function () {
        this.selectMatch(this._active);
    };
    TypeaheadContainer.prototype.prevActiveMatch = function () {
        var index = this.matches.indexOf(this._active);
        this._active = this.matches[index - 1 < 0 ? this.matches.length - 1 : index - 1];
    };
    TypeaheadContainer.prototype.nextActiveMatch = function () {
        var index = this.matches.indexOf(this._active);
        this._active = this.matches[index + 1 > this.matches.length - 1 ? 0 : index + 1];
    };
    TypeaheadContainer.prototype.selectActive = function (value) {
        this._active = value;
    };
    TypeaheadContainer.prototype.isActive = function (value) {
        return this._active === value;
    };
    TypeaheadContainer.prototype.selectMatch = function (value, e) {
        if (e === void 0) { e = null; }
        if (e) {
            e.stopPropagation();
            e.preventDefault();
        }
        this.parent.changeModel(value);
        this.parent.typeaheadOnSelect.next({
            item: value
        });
        return false;
    };
    TypeaheadContainer.prototype.hightlight = function (item, query) {
        var itemStr = (typeof item === 'object' && this._field ? item[this._field] : item).toString();
        var itemStrHelper = (this.parent.latinize ? typeahead_utils_1.TypeaheadUtils.latinize(itemStr) : itemStr).toLowerCase();
        var startIdx;
        var tokenLen;
        // Replaces the capture string with the same string inside of a "strong" tag
        if (typeof query === 'object') {
            var queryLen = query.length;
            for (var i = 0; i < queryLen; i += 1) {
                // query[i] is already latinized and lower case
                startIdx = itemStrHelper.indexOf(query[i]);
                tokenLen = query[i].length;
                if (startIdx >= 0 && tokenLen > 0) {
                    itemStr = itemStr.substring(0, startIdx) + '<strong>' + itemStr.substring(startIdx, startIdx + tokenLen) + '</strong>' + itemStr.substring(startIdx + tokenLen);
                    itemStrHelper = itemStrHelper.substring(0, startIdx) + '        ' + ' '.repeat(tokenLen) + '         ' + itemStrHelper.substring(startIdx + tokenLen);
                }
            }
        }
        else if (query) {
            // query is already latinized and lower case
            startIdx = itemStrHelper.indexOf(query);
            tokenLen = query.length;
            if (startIdx >= 0 && tokenLen > 0) {
                itemStr = itemStr.substring(0, startIdx) + '<strong>' + itemStr.substring(startIdx, startIdx + tokenLen) + '</strong>' + itemStr.substring(startIdx + tokenLen);
            }
        }
        return itemStr;
    };
    TypeaheadContainer = __decorate([
        core_1.Component({
            selector: 'typeahead-container',
            directives: [common_1.CORE_DIRECTIVES],
            template: TEMPLATE[ng2_bootstrap_config_1.Ng2BootstrapConfig.theme],
            encapsulation: core_1.ViewEncapsulation.None
        }), 
        __metadata('design:paramtypes', [core_1.ElementRef, TypeaheadOptions])
    ], TypeaheadContainer);
    return TypeaheadContainer;
})();
exports.TypeaheadContainer = TypeaheadContainer;
// todo: options loading by http not yet implemented
var Typeahead = (function () {
    function Typeahead(cd, element, renderer, loader) {
        this.cd = cd;
        this.element = element;
        this.renderer = renderer;
        this.loader = loader;
        this.typeaheadLoading = new core_1.EventEmitter();
        this.typeaheadNoResults = new core_1.EventEmitter();
        this.typeaheadOnSelect = new core_1.EventEmitter();
        this.latinize = true;
        this.singleWords = true;
        this.async = null;
        this.wordDelimiters = ' ';
        this.phraseDelimiters = '\'"';
        this._matches = [];
        this.placement = 'bottom-left';
    }
    Object.defineProperty(Typeahead.prototype, "matches", {
        get: function () {
            return this._matches;
        },
        enumerable: true,
        configurable: true
    });
    Typeahead.prototype.debounce = function (func, wait) {
        var timeout;
        var args;
        var timestamp;
        var waitOriginal = wait;
        return function () {
            // save details of latest call
            args = [].slice.call(arguments, 0);
            timestamp = Date.now();
            // this trick is about implementing of 'typeaheadWaitMs'
            // in this case we have adaptive 'wait' parameter
            // we should use standard 'wait'('waitOriginal') in case of
            // popup is opened, otherwise - 'typeaheadWaitMs' parameter
            wait = this.container ? waitOriginal : this.waitMs;
            // this is where the magic happens
            var later = function () {
                // how long ago was the last call
                var last = Date.now() - timestamp;
                // if the latest call was less that the wait period ago
                // then we reset the timeout to wait for the difference
                if (last < wait) {
                    timeout = setTimeout(later, wait - last);
                }
                else {
                    timeout = null;
                    func.apply(this, args);
                }
            };
            // we only need to set the timer now if one isn't already running
            if (!timeout) {
                timeout = setTimeout(later, wait);
            }
        };
    };
    Typeahead.prototype.processMatches = function () {
        this._matches = [];
        if (this.cd.model.toString().length >= this.minLength) {
            // If singleWords, break model here to not be doing extra work on each iteration
            var normalizedQuery = (this.latinize ? typeahead_utils_1.TypeaheadUtils.latinize(this.cd.model) : this.cd.model).toString().toLowerCase();
            normalizedQuery = this.singleWords ? typeahead_utils_1.TypeaheadUtils.tokenize(normalizedQuery, this.wordDelimiters, this.phraseDelimiters) : normalizedQuery;
            for (var i = 0; i < this.source.length; i++) {
                var match = void 0;
                if (typeof this.source[i] === 'object' &&
                    this.source[i][this.field]) {
                    match = this.latinize ? typeahead_utils_1.TypeaheadUtils.latinize(this.source[i][this.field].toString()) : this.source[i][this.field].toString();
                }
                if (typeof this.source[i] === 'string') {
                    match = this.latinize ? typeahead_utils_1.TypeaheadUtils.latinize(this.source[i].toString()) : this.source[i].toString();
                }
                if (!match) {
                    console.log('Invalid match type', typeof this.source[i], this.field);
                    continue;
                }
                if (this.testMatch(match.toLowerCase(), normalizedQuery)) {
                    this._matches.push(this.source[i]);
                    if (this._matches.length > this.optionsLimit - 1) {
                        break;
                    }
                }
            }
        }
    };
    Typeahead.prototype.testMatch = function (match, test) {
        var spaceLength;
        if (typeof test === 'object') {
            spaceLength = test.length;
            for (var i = 0; i < spaceLength; i += 1) {
                if (test[i].length > 0 && match.indexOf(test[i]) < 0) {
                    return false;
                }
            }
            return true;
        }
        else {
            return match.indexOf(test) >= 0;
        }
    };
    Typeahead.prototype.finalizeAsyncCall = function () {
        this.typeaheadLoading.next(false);
        this.typeaheadNoResults.next(this.cd.model.toString().length >=
            this.minLength && this.matches.length <= 0);
        if (this.cd.model.toString().length <= 0 || this._matches.length <= 0) {
            this.hide();
            return;
        }
        if (this.container && this._matches.length > 0) {
            // This improves the speedas it won't have to be done for each list item
            var normalizedQuery = (this.latinize ? typeahead_utils_1.TypeaheadUtils.latinize(this.cd.model) : this.cd.model).toString().toLowerCase();
            this.container.query = this.singleWords ? typeahead_utils_1.TypeaheadUtils.tokenize(normalizedQuery, this.wordDelimiters, this.phraseDelimiters) : normalizedQuery;
            this.container.matches = this._matches;
        }
        if (!this.container && this._matches.length > 0) {
            this.show(this._matches);
        }
    };
    Typeahead.prototype.ngOnInit = function () {
        var _this = this;
        this.optionsLimit = this.optionsLimit || 20;
        this.minLength = this.minLength || 1;
        this.waitMs = this.waitMs || 0;
        // async should be false in case of array
        if (this.async === null && typeof this.source !== 'function') {
            this.async = false;
        }
        // async should be true for any case of function
        if (typeof this.source === 'function') {
            this.async = true;
        }
        if (this.async === true) {
            this.debouncer = this.debounce(function () {
                if (typeof _this.source === 'function') {
                    _this.source().then(function (matches) {
                        _this._matches = [];
                        if (_this.cd.model.toString().length >= _this.minLength) {
                            for (var i = 0; i < matches.length; i++) {
                                _this._matches.push(matches[i]);
                                if (_this._matches.length > _this.optionsLimit - 1) {
                                    break;
                                }
                            }
                        }
                        _this.finalizeAsyncCall();
                    });
                }
                // source is array
                if (typeof _this.source === 'object' && _this.source.length) {
                    _this.processMatches();
                    _this.finalizeAsyncCall();
                }
            }, 100);
        }
    };
    Typeahead.prototype.onChange = function (e) {
        if (this.container) {
            // esc
            if (e.keyCode === 27) {
                this.hide();
                return;
            }
            // up
            if (e.keyCode === 38) {
                this.container.prevActiveMatch();
                return;
            }
            // down
            if (e.keyCode === 40) {
                this.container.nextActiveMatch();
                return;
            }
            // enter
            if (e.keyCode === 13) {
                this.container.selectActiveMatch();
                return;
            }
        }
        this.typeaheadLoading.next(true);
        if (this.async === true) {
            this.debouncer();
        }
        if (this.async === false) {
            this.processMatches();
            this.finalizeAsyncCall();
        }
    };
    Typeahead.prototype.changeModel = function (value) {
        var valueStr = ((typeof value === 'object' && this.field) ? value[this.field] : value).toString();
        this.cd.viewToModelUpdate(valueStr);
        setProperty(this.renderer, this.element, 'value', valueStr);
        this.hide();
    };
    Typeahead.prototype.show = function (matches) {
        var _this = this;
        var options = new TypeaheadOptions({
            placement: this.placement,
            animation: false
        });
        var binding = core_2.Injector.resolve([
            core_2.bind(TypeaheadOptions).toValue(options)
        ]);
        this.popup = this.loader
            .loadNextToLocation(TypeaheadContainer, this.element, binding)
            .then(function (componentRef) {
            componentRef.instance.position(_this.element);
            _this.container = componentRef.instance;
            _this.container.parent = _this;
            // This improves the speedas it won't have to be done for each list item
            var normalizedQuery = (_this.latinize ? typeahead_utils_1.TypeaheadUtils.latinize(_this.cd.model) : _this.cd.model).toString().toLowerCase();
            _this.container.query = _this.singleWords ? typeahead_utils_1.TypeaheadUtils.tokenize(normalizedQuery, _this.wordDelimiters, _this.phraseDelimiters) : normalizedQuery;
            _this.container.matches = matches;
            _this.container.field = _this.field;
            _this.element.nativeElement.focus();
            return componentRef;
        });
    };
    Typeahead.prototype.hide = function () {
        var _this = this;
        if (this.container) {
            this.popup.then(function (componentRef) {
                componentRef.dispose();
                _this.container = null;
                return componentRef;
            });
        }
    };
    Typeahead = __decorate([
        core_1.Directive({
            selector: 'typeahead, [typeahead]',
            properties: [
                'source:typeahead',
                // todo: not yet implemented
                'appendToBody:typeaheadAppendToBody',
                // todo: not yet implemented
                'editable:typeaheadEditable',
                // todo: not yet implemented
                'focusFirst:typeaheadFocusFirst',
                // todo: not yet implemented
                'inputFormatter:typeaheadInputFormatter',
                'minLength:typeaheadMinLength',
                // todo: not yet implemented
                'selectOnExact:typeaheadSelectOnExact',
                // todo: not yet implemented
                'templateUrl:typeaheadTemplateUrl',
                // todo: not yet implemented
                'popupTemplateUrl:typeaheadPopupTemplateUrl',
                'waitMs:typeaheadWaitMs',
                'optionsLimit:typeaheadOptionsLimit',
                // todo: not yet implemented
                'selectOnBlur:typeaheadSelectOnBlur',
                // todo: not yet implemented
                'focusOnSelect:typeaheadFocusOnSelect',
                'field:typeaheadOptionField',
                'async:typeaheadAsync',
                'latinize:typeaheadLatinize',
                'singleWords:typeaheadSingleWords',
                'wordDelimiters:typeaheadWordDelimiters',
                'phraseDelimiters:typeaheadPhraseDelimiters'
            ],
            events: ['typeaheadLoading', 'typeaheadNoResults', 'typeaheadOnSelect'],
            host: {
                '(keyup)': 'onChange($event)'
            }
        }), 
        __metadata('design:paramtypes', [common_1.NgModel, core_1.ElementRef, core_1.Renderer, core_1.DynamicComponentLoader])
    ], Typeahead);
    return Typeahead;
})();
exports.Typeahead = Typeahead;
var _a;
//# sourceMappingURL=typeahead.js.map