System.register(['angular2/core', './dropdown-service'], function(exports_1) {
    "use strict";
    var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    var __metadata = (this && this.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
    };
    var core_1, dropdown_service_1;
    var Dropdown;
    return {
        setters:[
            function (core_1_1) {
                core_1 = core_1_1;
            },
            function (dropdown_service_1_1) {
                dropdown_service_1 = dropdown_service_1_1;
            }],
        execute: function() {
            Dropdown = (function () {
                function Dropdown(el) {
                    this.el = el;
                    this.onToggle = new core_1.EventEmitter();
                    this.addClass = true;
                }
                Object.defineProperty(Dropdown.prototype, "isOpen", {
                    get: function () {
                        return this._isOpen;
                    },
                    set: function (value) {
                        this._isOpen = !!value;
                        if (this.dropdownAppendToBody && this.menuEl) {
                        }
                        if (this.isOpen) {
                            if (this.dropdownMenuTemplateUrl) {
                            }
                            this.focusToggleElement();
                            dropdown_service_1.dropdownService.open(this);
                        }
                        else {
                            if (this.dropdownMenuTemplateUrl) {
                            }
                            dropdown_service_1.dropdownService.close(this);
                            this.selectedOption = null;
                        }
                        this.onToggle.emit(this.isOpen);
                    },
                    enumerable: true,
                    configurable: true
                });
                Dropdown.prototype.ngOnInit = function () {
                    this.autoClose = this.autoClose || dropdown_service_1.ALWAYS;
                    this.keyboardNav = typeof this.keyboardNav !== 'undefined';
                    this.dropdownAppendToBody = typeof this.dropdownAppendToBody !== 'undefined';
                    if (this.isOpen) {
                    }
                };
                Dropdown.prototype.ngOnDestroy = function () {
                    if (this.dropdownAppendToBody && this.menuEl) {
                        this.menuEl.nativeElement.remove();
                    }
                };
                Object.defineProperty(Dropdown.prototype, "dropDownMenu", {
                    set: function (dropdownMenu) {
                        this.menuEl = dropdownMenu.el;
                        if (dropdownMenu.templateUrl) {
                            this.dropdownMenuTemplateUrl = dropdownMenu.templateUrl;
                        }
                        if (this.dropdownAppendToBody) {
                            window.document.body.appendChild(this.menuEl.nativeElement);
                        }
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(Dropdown.prototype, "dropDownToggle", {
                    set: function (dropdownToggle) {
                        this.toggleEl = dropdownToggle.el;
                    },
                    enumerable: true,
                    configurable: true
                });
                Dropdown.prototype.toggle = function (open) {
                    return this.isOpen = arguments.length ? !!open : !this.isOpen;
                };
                Dropdown.prototype.focusDropdownEntry = function (keyCode) {
                    var hostEl = this.menuEl ?
                        this.menuEl.nativeElement :
                        this.el.nativeElement.getElementsByTagName('ul')[0];
                    if (!hostEl) {
                        return;
                    }
                    var elems = hostEl.getElementsByTagName('a');
                    if (!elems || !elems.length) {
                        return;
                    }
                    switch (keyCode) {
                        case (40):
                            if (typeof this.selectedOption !== 'number') {
                                this.selectedOption = 0;
                                break;
                            }
                            if (this.selectedOption === elems.length - 1) {
                                break;
                            }
                            this.selectedOption++;
                            break;
                        case (38):
                            if (typeof this.selectedOption !== 'number') {
                                return;
                            }
                            if (this.selectedOption === 0) {
                                break;
                            }
                            this.selectedOption--;
                            break;
                    }
                    elems[this.selectedOption].focus();
                };
                Dropdown.prototype.focusToggleElement = function () {
                    if (this.toggleEl) {
                        this.toggleEl.nativeElement.focus();
                    }
                };
                __decorate([
                    core_1.HostBinding('class.open'),
                    core_1.Input(), 
                    __metadata('design:type', Boolean)
                ], Dropdown.prototype, "isOpen", null);
                __decorate([
                    core_1.Input(), 
                    __metadata('design:type', String)
                ], Dropdown.prototype, "autoClose", void 0);
                __decorate([
                    core_1.Input(), 
                    __metadata('design:type', Boolean)
                ], Dropdown.prototype, "keyboardNav", void 0);
                __decorate([
                    core_1.Input(), 
                    __metadata('design:type', Boolean)
                ], Dropdown.prototype, "dropdownAppendToBody", void 0);
                __decorate([
                    core_1.Output(), 
                    __metadata('design:type', (typeof (_a = typeof core_1.EventEmitter !== 'undefined' && core_1.EventEmitter) === 'function' && _a) || Object)
                ], Dropdown.prototype, "onToggle", void 0);
                __decorate([
                    core_1.HostBinding('class.dropdown'), 
                    __metadata('design:type', Object)
                ], Dropdown.prototype, "addClass", void 0);
                Dropdown = __decorate([
                    core_1.Directive({ selector: '[dropdown]' }), 
                    __metadata('design:paramtypes', [(typeof (_b = typeof core_1.ElementRef !== 'undefined' && core_1.ElementRef) === 'function' && _b) || Object])
                ], Dropdown);
                return Dropdown;
                var _a, _b;
            }());
            exports_1("Dropdown", Dropdown);
        }
    }
});
//# sourceMappingURL=dropdown.js.map