exports.ALWAYS = 'always';
exports.DISABLED = 'disabled';
exports.OUTSIDECLICK = 'outsideClick';
var DropdownService = (function () {
    function DropdownService() {
        this.closeDropdownBind = this.closeDropdown.bind(this);
        this.keybindFilterBind = this.keybindFilter.bind(this);
    }
    DropdownService.prototype.open = function (dropdownScope) {
        if (!this.openScope) {
            window.document.addEventListener('click', this.closeDropdownBind);
            window.document.addEventListener('keydown', this.keybindFilterBind);
        }
        if (this.openScope && this.openScope !== this.dropdownScope) {
            this.openScope.isOpen = false;
        }
        this.openScope = dropdownScope;
    };
    DropdownService.prototype.close = function (dropdownScope) {
        if (this.openScope !== dropdownScope) {
            return;
        }
        this.openScope = null;
        window.document.removeEventListener('click', this.closeDropdownBind);
        window.document.removeEventListener('keydown', this.keybindFilterBind);
    };
    DropdownService.prototype.closeDropdown = function (event) {
        if (!this.openScope) {
            return;
        }
        if (event && this.openScope.autoClose === exports.DISABLED) {
            return;
        }
        if (event && this.openScope.toggleEl &&
            this.openScope.toggleEl.nativeElement === event.target) {
            return;
        }
        if (event && this.openScope.autoClose === exports.OUTSIDECLICK &&
            this.openScope.menuEl &&
            this.openScope.menuEl.nativeElement === event.target) {
            return;
        }
        this.openScope.isOpen = false;
    };
    DropdownService.prototype.keybindFilter = function (event) {
        if (event.which === 27) {
            this.openScope.focusToggleElement();
            this.closeDropdown(null);
            return;
        }
        if (this.openScope.keyboardNav && this.openScope.isOpen &&
            (event.which === 38 || event.which === 40)) {
            event.preventDefault();
            event.stopPropagation();
            this.openScope.focusDropdownEntry(event.which);
        }
    };
    return DropdownService;
})();
exports.DropdownService = DropdownService;
exports.dropdownService = new DropdownService();
//# sourceMappingURL=dropdown.service.js.map