System.register(['angular2/core', 'angular2/common', '../position'], function(exports_1) {
    "use strict";
    var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    var __metadata = (this && this.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
    };
    var core_1, common_1, core_2, position_1;
    var TooltipOptions, TooltipContainer, Tooltip, TOOLTIP_DIRECTIVES, tooltip;
    return {
        setters:[
            function (core_1_1) {
                core_1 = core_1_1;
                core_2 = core_1_1;
            },
            function (common_1_1) {
                common_1 = common_1_1;
            },
            function (position_1_1) {
                position_1 = position_1_1;
            }],
        execute: function() {
            TooltipOptions = (function () {
                function TooltipOptions(options) {
                    Object.assign(this, options);
                }
                return TooltipOptions;
            }());
            TooltipContainer = (function () {
                function TooltipContainer(element, options) {
                    this.element = element;
                    Object.assign(this, options);
                    this.classMap = { 'in': false };
                    this.classMap[options.placement] = true;
                }
                TooltipContainer.prototype.position = function (hostEl) {
                    this.display = 'block';
                    this.top = '0px';
                    this.left = '0px';
                    var p = position_1.positionService
                        .positionElements(hostEl.nativeElement, this.element.nativeElement.children[0], this.placement, this.appendToBody);
                    this.top = p.top + 'px';
                    this.left = p.left + 'px';
                    this.classMap['in'] = true;
                };
                TooltipContainer = __decorate([
                    core_1.Component({
                        selector: 'tooltip-container',
                        directives: [common_1.NgClass, common_1.NgStyle],
                        template: "\n    <div class=\"tooltip\" role=\"tooltip\"\n     [ngStyle]=\"{top: top, left: left, display: display}\"\n     [ngClass]=\"classMap\" >\n      <div class=\"tooltip-arrow\"></div>\n      <div class=\"tooltip-inner\">\n        {{content}}\n      </div>\n    </div>"
                    }), 
                    __metadata('design:paramtypes', [(typeof (_a = typeof core_1.ElementRef !== 'undefined' && core_1.ElementRef) === 'function' && _a) || Object, TooltipOptions])
                ], TooltipContainer);
                return TooltipContainer;
                var _a;
            }());
            Tooltip = (function () {
                function Tooltip(element, loader) {
                    this.element = element;
                    this.loader = loader;
                    this.placement = 'top';
                    this.visible = false;
                }
                Tooltip.prototype.ngOnInit = function () {
                };
                Tooltip.prototype.show = function () {
                    var _this = this;
                    if (this.visible) {
                        return;
                    }
                    this.visible = true;
                    var options = new TooltipOptions({
                        content: this.content,
                        placement: this.placement
                    });
                    var binding = core_2.Injector.resolve([
                        core_2.bind(TooltipOptions).toValue(options)
                    ]);
                    this.tooltip = this.loader
                        .loadNextToLocation(TooltipContainer, this.element, binding)
                        .then(function (componentRef) {
                        componentRef.instance.position(_this.element);
                        return componentRef;
                    });
                };
                Tooltip.prototype.hide = function () {
                    if (!this.visible) {
                        return;
                    }
                    this.visible = false;
                    this.tooltip.then(function (componentRef) {
                        componentRef.dispose();
                        return componentRef;
                    });
                };
                __decorate([
                    core_1.Input('tooltip'), 
                    __metadata('design:type', String)
                ], Tooltip.prototype, "content", void 0);
                __decorate([
                    core_1.Input('tooltip-placement'), 
                    __metadata('design:type', String)
                ], Tooltip.prototype, "placement", void 0);
                __decorate([
                    core_1.Input('tooltip-isOpen'), 
                    __metadata('design:type', Boolean)
                ], Tooltip.prototype, "isOpen", void 0);
                __decorate([
                    core_1.Input('tooltip-enable'), 
                    __metadata('design:type', Boolean)
                ], Tooltip.prototype, "enable", void 0);
                __decorate([
                    core_1.Input(), 
                    __metadata('design:type', Boolean)
                ], Tooltip.prototype, "appendToBody", void 0);
                __decorate([
                    core_1.HostListener('focusin', ['$event', '$target']),
                    core_1.HostListener('mouseenter', ['$event', '$target']), 
                    __metadata('design:type', Function), 
                    __metadata('design:paramtypes', []), 
                    __metadata('design:returntype', void 0)
                ], Tooltip.prototype, "show", null);
                __decorate([
                    core_1.HostListener('focusout', ['$event', '$target']),
                    core_1.HostListener('mouseleave', ['$event', '$target']), 
                    __metadata('design:type', Function), 
                    __metadata('design:paramtypes', []), 
                    __metadata('design:returntype', void 0)
                ], Tooltip.prototype, "hide", null);
                Tooltip = __decorate([
                    core_1.Directive({ selector: '[tooltip]' }), 
                    __metadata('design:paramtypes', [(typeof (_a = typeof core_1.ElementRef !== 'undefined' && core_1.ElementRef) === 'function' && _a) || Object, (typeof (_b = typeof core_1.DynamicComponentLoader !== 'undefined' && core_1.DynamicComponentLoader) === 'function' && _b) || Object])
                ], Tooltip);
                return Tooltip;
                var _a, _b;
            }());
            exports_1("Tooltip", Tooltip);
            exports_1("TOOLTIP_DIRECTIVES", TOOLTIP_DIRECTIVES = [Tooltip, TooltipContainer]);
            exports_1("tooltip", tooltip = [Tooltip, TooltipContainer]);
        }
    }
});
//# sourceMappingURL=tooltip.js.map