System.register(['angular2/core', 'angular2/common'], function(exports_1) {
    "use strict";
    var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    var __metadata = (this && this.__metadata) || function (k, v) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
    };
    var core_1, common_1;
    var ALERT_TEMPLATE, Alert;
    return {
        setters:[
            function (core_1_1) {
                core_1 = core_1_1;
            },
            function (common_1_1) {
                common_1 = common_1_1;
            }],
        execute: function() {
            ALERT_TEMPLATE = "\n  <div class=\"alert\" role=\"alert\" [ngClass]=\"classes\" *ngIf=\"!closed\">\n    <button *ngIf=\"dismissible\" type=\"button\" class=\"close\" (click)=\"onClose($event)\">\n      <span aria-hidden=\"true\">&times;</span>\n      <span class=\"sr-only\">Close</span>\n    </button>\n    <ng-content></ng-content>\n  </div>\n  ";
            Alert = (function () {
                function Alert(el) {
                    this.el = el;
                    this.type = 'warning';
                    this.close = new core_1.EventEmitter();
                    this.classes = [];
                    this.dismissible = this.dismissible || el.nativeElement.getAttribute('(close)');
                }
                Alert.prototype.ngOnInit = function () {
                    var _this = this;
                    this.classes[0] = "alert-" + this.type;
                    if (this.dismissible) {
                        this.classes[1] = 'alert-dismissible';
                    }
                    else {
                        this.classes.length = 1;
                    }
                    if (this.dismissOnTimeout) {
                        setTimeout(function () { return _this.onClose(); }, this.dismissOnTimeout);
                    }
                };
                Alert.prototype.onClose = function () {
                    this.close.next(this);
                    this.closed = true;
                };
                __decorate([
                    core_1.Input(), 
                    __metadata('design:type', String)
                ], Alert.prototype, "type", void 0);
                __decorate([
                    core_1.Input(), 
                    __metadata('design:type', Boolean)
                ], Alert.prototype, "dismissible", void 0);
                __decorate([
                    core_1.Input(), 
                    __metadata('design:type', Number)
                ], Alert.prototype, "dismissOnTimeout", void 0);
                __decorate([
                    core_1.Output(), 
                    __metadata('design:type', (typeof (_a = typeof core_1.EventEmitter !== 'undefined' && core_1.EventEmitter) === 'function' && _a) || Object)
                ], Alert.prototype, "close", void 0);
                Alert = __decorate([
                    core_1.Component({
                        selector: 'alert',
                        directives: [common_1.NgIf, common_1.NgClass],
                        template: ALERT_TEMPLATE
                    }), 
                    __metadata('design:paramtypes', [(typeof (_b = typeof core_1.ElementRef !== 'undefined' && core_1.ElementRef) === 'function' && _b) || Object])
                ], Alert);
                return Alert;
                var _a, _b;
            }());
            exports_1("Alert", Alert);
        }
    }
});
//# sourceMappingURL=alert.js.map