"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var core_1 = require('angular2/core');
var common_1 = require('angular2/common');
// todo: implement global configuration via DI
// todo: refactor directive has to many functions! (extract to stateless helper)
// todo: use moment js?
// todo: implement `time` validator
// todo: replace increment/decrement blockers with getters, or extract
// todo: unify work with selected
exports.timepickerConfig = {
    hourStep: 1,
    minuteStep: 1,
    showMeridian: true,
    meridians: null,
    readonlyInput: false,
    mousewheel: true,
    arrowkeys: true,
    showSpinners: true,
    min: void 0,
    max: void 0
};
function isDefined(value) {
    return typeof value !== 'undefined';
}
function def(value, fn, defaultValue) {
    return fn(value) ? value : defaultValue;
}
function addMinutes(date, minutes) {
    var dt = new Date(date.getTime() + minutes * 60000);
    var newDate = new Date(date);
    newDate.setHours(dt.getHours(), dt.getMinutes());
    return newDate;
}
// TODO: templateUrl
var Timepicker = (function () {
    function Timepicker(cd) {
        this.cd = cd;
        this.meridians = ['AM', 'PM']; // ??
        // result value
        this._selected = new Date();
        this.onChange = function (_) {
        };
        this.onTouched = function () {
        };
        cd.valueAccessor = this;
    }
    Object.defineProperty(Timepicker.prototype, "showMeridian", {
        get: function () {
            return this._showMeridian;
        },
        set: function (value) {
            this._showMeridian = value;
            // || !this.$error.time
            //if (true) {
            this.updateTemplate();
            return;
            //}
            // Evaluate from template
            /*let hours = this.getHoursFromTemplate();
            let minutes = this.getMinutesFromTemplate();
            if (isDefined(hours) && isDefined(minutes)) {
              this.selected.setHours(hours);
              this.refresh();
            }*/
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Timepicker.prototype, "selected", {
        get: function () {
            return this._selected;
        },
        set: function (v) {
            if (v) {
                this._selected = v;
                this.updateTemplate();
                this.cd.viewToModelUpdate(this.selected);
            }
        },
        enumerable: true,
        configurable: true
    });
    // todo: add formatter value to Date object
    Timepicker.prototype.ngOnInit = function () {
        // todo: take in account $locale.DATETIME_FORMATS.AMPMS;
        this.meridians = def(this.meridians, isDefined, exports.timepickerConfig.meridians) || ['AM', 'PM'];
        this.mousewheel = def(this.mousewheel, isDefined, exports.timepickerConfig.mousewheel);
        if (this.mousewheel) {
            this.setupMousewheelEvents();
        }
        this.arrowkeys = def(this.arrowkeys, isDefined, exports.timepickerConfig.arrowkeys);
        if (this.arrowkeys) {
            this.setupArrowkeyEvents();
        }
        this.readonlyInput = def(this.readonlyInput, isDefined, exports.timepickerConfig.readonlyInput);
        this.setupInputEvents();
        this.hourStep = def(this.hourStep, isDefined, exports.timepickerConfig.hourStep);
        this.minuteStep = def(this.minuteStep, isDefined, exports.timepickerConfig.minuteStep);
        this.min = def(this.min, isDefined, exports.timepickerConfig.min);
        this.max = def(this.max, isDefined, exports.timepickerConfig.max);
        // 12H / 24H mode
        this.showMeridian = def(this.showMeridian, isDefined, exports.timepickerConfig.showMeridian);
        this.showSpinners = def(this.showSpinners, isDefined, exports.timepickerConfig.showSpinners);
    };
    Timepicker.prototype.writeValue = function (v) {
        if (v === this.selected) {
            return;
        }
        if (v && v instanceof Date) {
            this.selected = v;
            return;
        }
        this.selected = v ? new Date(v) : null;
    };
    Timepicker.prototype.refresh = function (type) {
        // this.makeValid();
        this.updateTemplate();
        this.cd.viewToModelUpdate(this.selected);
    };
    Timepicker.prototype.updateTemplate = function (keyboardChange) {
        var hours = this.selected.getHours();
        var minutes = this.selected.getMinutes();
        if (this.showMeridian) {
            // Convert 24 to 12 hour system
            hours = (hours === 0 || hours === 12) ? 12 : hours % 12;
        }
        // this.hours = keyboardChange === 'h' ? hours : this.pad(hours);
        // if (keyboardChange !== 'm') {
        //  this.minutes = this.pad(minutes);
        // }
        this.hours = this.pad(hours);
        this.minutes = this.pad(minutes);
        this.meridian = this.selected.getHours() < 12 ? this.meridians[0] : this.meridians[1];
    };
    Timepicker.prototype.getHoursFromTemplate = function () {
        var hours = parseInt(this.hours, 10);
        var valid = this.showMeridian ? (hours > 0 && hours < 13) : (hours >= 0 && hours < 24);
        if (!valid) {
            return undefined;
        }
        if (this.showMeridian) {
            if (hours === 12) {
                hours = 0;
            }
            if (this.meridian === this.meridians[1]) {
                hours = hours + 12;
            }
        }
        return hours;
    };
    Timepicker.prototype.getMinutesFromTemplate = function () {
        var minutes = parseInt(this.minutes, 10);
        return (minutes >= 0 && minutes < 60) ? minutes : undefined;
    };
    Timepicker.prototype.pad = function (value) {
        return (isDefined(value) && value.toString().length < 2) ? '0' + value : value.toString();
    };
    Timepicker.prototype.setupMousewheelEvents = function () {
    };
    Timepicker.prototype.setupArrowkeyEvents = function () {
    };
    Timepicker.prototype.setupInputEvents = function () {
    };
    Timepicker.prototype.updateHours = function () {
        if (this.readonlyInput) {
            return;
        }
        var hours = this.getHoursFromTemplate();
        var minutes = this.getMinutesFromTemplate();
        if (!isDefined(hours) || !isDefined(minutes)) {
        }
        this.selected.setHours(hours);
        if (this.selected < this.min || this.selected > this.max) {
        }
        else {
            this.refresh('h');
        }
    };
    Timepicker.prototype.hoursOnBlur = function (event) {
        if (this.readonlyInput) {
            return;
        }
        // todo: binded with validation
        if (!this.invalidHours && parseInt(this.hours, 10) < 10) {
            this.hours = this.pad(this.hours);
        }
    };
    Timepicker.prototype.updateMinutes = function () {
        if (this.readonlyInput) {
            return;
        }
        var minutes = this.getMinutesFromTemplate();
        var hours = this.getHoursFromTemplate();
        if (!isDefined(minutes) || !isDefined(hours)) {
        }
        this.selected.setMinutes(minutes);
        if (this.selected < this.min || this.selected > this.max) {
        }
        else {
            this.refresh('m');
        }
    };
    Timepicker.prototype.minutesOnBlur = function (event) {
        if (this.readonlyInput) {
            return;
        }
        if (!this.invalidMinutes && parseInt(this.minutes, 10) < 10) {
            this.minutes = this.pad(this.minutes);
        }
    };
    Timepicker.prototype.noIncrementHours = function () {
        var incrementedSelected = addMinutes(this.selected, this.hourStep * 60);
        return incrementedSelected > this.max ||
            (incrementedSelected < this.selected && incrementedSelected < this.min);
    };
    Timepicker.prototype.noDecrementHours = function () {
        var decrementedSelected = addMinutes(this.selected, -this.hourStep * 60);
        return decrementedSelected < this.min ||
            (decrementedSelected > this.selected && decrementedSelected > this.max);
    };
    Timepicker.prototype.noIncrementMinutes = function () {
        var incrementedSelected = addMinutes(this.selected, this.minuteStep);
        return incrementedSelected > this.max ||
            (incrementedSelected < this.selected && incrementedSelected < this.min);
    };
    Timepicker.prototype.noDecrementMinutes = function () {
        var decrementedSelected = addMinutes(this.selected, -this.minuteStep);
        return decrementedSelected < this.min ||
            (decrementedSelected > this.selected && decrementedSelected > this.max);
    };
    Timepicker.prototype.addMinutesToSelected = function (minutes) {
        this.selected = addMinutes(this.selected, minutes);
        this.refresh();
    };
    Timepicker.prototype.noToggleMeridian = function () {
        if (this.selected.getHours() < 13) {
            return addMinutes(this.selected, 12 * 60) > this.max;
        }
        else {
            return addMinutes(this.selected, -12 * 60) < this.min;
        }
    };
    Timepicker.prototype.incrementHours = function () {
        if (!this.noIncrementHours()) {
            this.addMinutesToSelected(this.hourStep * 60);
        }
    };
    Timepicker.prototype.decrementHours = function () {
        if (!this.noDecrementHours()) {
            this.addMinutesToSelected(-this.hourStep * 60);
        }
    };
    Timepicker.prototype.incrementMinutes = function () {
        if (!this.noIncrementMinutes()) {
            this.addMinutesToSelected(this.minuteStep);
        }
    };
    Timepicker.prototype.decrementMinutes = function () {
        if (!this.noDecrementMinutes()) {
            this.addMinutesToSelected(-this.minuteStep);
        }
    };
    Timepicker.prototype.toggleMeridian = function () {
        if (!this.noToggleMeridian()) {
            var sign = this.selected.getHours() < 12 ? 1 : -1;
            this.addMinutesToSelected(12 * 60 * sign);
        }
    };
    Timepicker.prototype.registerOnChange = function (fn) {
        this.onChange = fn;
    };
    Timepicker.prototype.registerOnTouched = function (fn) {
        this.onTouched = fn;
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Number)
    ], Timepicker.prototype, "hourStep", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Number)
    ], Timepicker.prototype, "minuteStep", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], Timepicker.prototype, "readonlyInput", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], Timepicker.prototype, "mousewheel", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], Timepicker.prototype, "arrowkeys", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], Timepicker.prototype, "showSpinners", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Date)
    ], Timepicker.prototype, "min", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Date)
    ], Timepicker.prototype, "max", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Array)
    ], Timepicker.prototype, "meridians", void 0);
    __decorate([
        // ??
        core_1.Input(), 
        __metadata('design:type', Object)
    ], Timepicker.prototype, "showMeridian", null);
    Timepicker = __decorate([
        core_1.Component({
            selector: 'timepicker[ngModel]',
            directives: [common_1.NgClass],
            template: "\n    <table>\n      <tbody>\n        <tr class=\"text-center\" [ngClass]=\"{hidden: !showSpinners}\">\n          <td><a (click)=\"incrementHours()\" [ngClass]=\"{disabled: noIncrementHours()}\" class=\"btn btn-link\"><span class=\"glyphicon glyphicon-chevron-up\"></span></a></td>\n          <td>&nbsp;</td>\n          <td><a (click)=\"incrementMinutes()\" [ngClass]=\"{disabled: noIncrementMinutes()}\" class=\"btn btn-link\"><span class=\"glyphicon glyphicon-chevron-up\"></span></a></td>\n          <td [ngClass]=\"{hidden: !showMeridian}\" [hidden]=\"!showMeridian\"></td>\n        </tr>\n        <tr>\n          <td class=\"form-group\" [ngClass]=\"{'has-error': invalidHours}\">\n            <input style=\"width:50px;\" type=\"text\" [(ngModel)]=\"hours\" (change)=\"updateHours()\" class=\"form-control text-center\" [readonly]=\"readonlyInput\" (blur)=\"hoursOnBlur($event)\" maxlength=\"2\">\n          </td>\n          <td>:</td>\n          <td class=\"form-group\" [ngClass]=\"{'has-error': invalidMinutes}\">\n            <input style=\"width:50px;\" type=\"text\" [(ngModel)]=\"minutes\" (change)=\"updateMinutes()\" class=\"form-control text-center\" [readonly]=\"readonlyInput\" (blur)=\"minutesOnBlur($event)\" maxlength=\"2\">\n          </td>\n          <td [ngClass]=\"{hidden: !showMeridian}\" [hidden]=\"!showMeridian\"><button type=\"button\" [ngClass]=\"{disabled: noToggleMeridian()}\" class=\"btn btn-default text-center\" (click)=\"toggleMeridian()\">{{meridian}}</button></td>\n        </tr>\n        <tr class=\"text-center\" [ngClass]=\"{hidden: !showSpinners}\">\n          <td><a (click)=\"decrementHours()\" [ngClass]=\"{disabled: noDecrementHours()}\" class=\"btn btn-link\"><span class=\"glyphicon glyphicon-chevron-down\"></span></a></td>\n          <td>&nbsp;</td>\n          <td><a (click)=\"decrementMinutes()\" [ngClass]=\"{disabled: noDecrementMinutes()}\" class=\"btn btn-link\"><span class=\"glyphicon glyphicon-chevron-down\"></span></a></td>\n          <td [ngClass]=\"{hidden: !showMeridian}\" [hidden]=\"!showMeridian\"></td>\n        </tr>\n      </tbody>\n    </table>\n  "
        }),
        __param(0, core_1.Self()), 
        __metadata('design:paramtypes', [common_1.NgModel])
    ], Timepicker);
    return Timepicker;
}());
exports.Timepicker = Timepicker;
//# sourceMappingURL=timepicker.component.js.map