"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('angular2/core');
var common_1 = require('angular2/common');
var ALERT_TEMPLATE = "\n  <div class=\"alert\" role=\"alert\" [ngClass]=\"classes\" *ngIf=\"!closed\">\n    <button *ngIf=\"dismissible\" type=\"button\" class=\"close\" (click)=\"onClose()\" (touch)=\"onClose()\">\n      <span aria-hidden=\"true\">&times;</span>\n      <span class=\"sr-only\">Close</span>\n    </button>\n    <ng-content></ng-content>\n  </div>\n  ";
// TODO: templateUrl
var Alert = (function () {
    function Alert() {
        this.type = 'warning';
        this.close = new core_1.EventEmitter();
        this.classes = [];
    }
    Alert.prototype.ngOnInit = function () {
        var _this = this;
        this.classes[0] = "alert-" + this.type;
        if (this.dismissible) {
            this.classes[1] = 'alert-dismissible';
        }
        else {
            this.classes.length = 1;
        }
        if (this.dismissOnTimeout) {
            setTimeout(function () { return _this.onClose(); }, this.dismissOnTimeout);
        }
    };
    // todo: mouse event + touch + pointer
    Alert.prototype.onClose = function () {
        this.closed = true;
        this.close.emit(this);
    };
    __decorate([
        core_1.Input(), 
        __metadata('design:type', String)
    ], Alert.prototype, "type", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Boolean)
    ], Alert.prototype, "dismissible", void 0);
    __decorate([
        core_1.Input(), 
        __metadata('design:type', Number)
    ], Alert.prototype, "dismissOnTimeout", void 0);
    __decorate([
        core_1.Output(), 
        __metadata('design:type', core_1.EventEmitter)
    ], Alert.prototype, "close", void 0);
    Alert = __decorate([
        core_1.Component({
            selector: 'alert',
            directives: [common_1.NgIf, common_1.NgClass],
            template: ALERT_TEMPLATE
        }), 
        __metadata('design:paramtypes', [])
    ], Alert);
    return Alert;
}());
exports.Alert = Alert;
//# sourceMappingURL=alert.component.js.map