import { OnInit } from 'angular2/core';
import { NgModel, ControlValueAccessor } from 'angular2/common';
export interface ITimepickerConfig {
    hourStep: number;
    minuteStep: number;
    showMeridian: boolean;
    meridians?: any[];
    readonlyInput: boolean;
    mousewheel: boolean;
    arrowkeys: boolean;
    showSpinners: boolean;
    min?: number;
    max?: number;
}
export declare const timepickerConfig: ITimepickerConfig;
export declare class Timepicker implements ControlValueAccessor, OnInit {
    cd: NgModel;
    private hourStep;
    private minuteStep;
    private readonlyInput;
    private mousewheel;
    private arrowkeys;
    private showSpinners;
    private min;
    private max;
    private meridians;
    private showMeridian;
    private _selected;
    private _showMeridian;
    private meridian;
    private hours;
    private minutes;
    private selected;
    private invalidHours;
    private invalidMinutes;
    constructor(cd: NgModel);
    ngOnInit(): void;
    writeValue(v: any): void;
    private refresh(type?);
    private updateTemplate(keyboardChange?);
    private getHoursFromTemplate();
    private getMinutesFromTemplate();
    private pad(value);
    private setupMousewheelEvents();
    private setupArrowkeyEvents();
    private setupInputEvents();
    private updateHours();
    private hoursOnBlur(event);
    private updateMinutes();
    private minutesOnBlur(event);
    private noIncrementHours();
    private noDecrementHours();
    private noIncrementMinutes();
    private noDecrementMinutes();
    private addMinutesToSelected(minutes);
    noToggleMeridian(): boolean;
    private incrementHours();
    private decrementHours();
    private incrementMinutes();
    private decrementMinutes();
    private toggleMeridian();
    onChange: (_: any) => void;
    onTouched: () => void;
    registerOnChange(fn: (_: any) => {}): void;
    registerOnTouched(fn: () => {}): void;
}
