import { ElementRef, EventEmitter, OnInit, Renderer, TemplateRef, ViewContainerRef } from '@angular/core';
import { NgControl } from '@angular/forms';
import { TypeaheadContainerComponent } from './typeahead-container.component';
import 'rxjs/add/observable/from';
import 'rxjs/add/operator/debounceTime';
import 'rxjs/add/operator/filter';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/mergeMap';
import 'rxjs/add/operator/toArray';
import { ComponentsHelper } from '../utils/components-helper.service';
import { TypeaheadMatch } from './typeahead-match.class';
export declare class TypeaheadDirective implements OnInit {
    typeaheadLoading: EventEmitter<boolean>;
    typeaheadNoResults: EventEmitter<boolean>;
    typeaheadOnSelect: EventEmitter<{
        item: any;
    }>;
    typeahead: any;
    typeaheadMinLength: number;
    typeaheadWaitMs: number;
    typeaheadOptionsLimit: number;
    typeaheadOptionField: string;
    typeaheadGroupField: string;
    typeaheadAsync: boolean;
    typeaheadLatinize: boolean;
    typeaheadSingleWords: boolean;
    typeaheadWordDelimiters: string;
    typeaheadPhraseDelimiters: string;
    typeaheadItemTemplate: TemplateRef<any>;
    container: TypeaheadContainerComponent;
    isTypeaheadOptionsListActive: boolean;
    private keyUpEventEmitter;
    private _matches;
    private placement;
    private popup;
    private ngControl;
    private viewContainerRef;
    private element;
    private renderer;
    private componentsHelper;
    onChange(e: any): void;
    onFocus(): void;
    onBlur(): void;
    onKeydown(e: KeyboardEvent): void;
    constructor(control: NgControl, viewContainerRef: ViewContainerRef, element: ElementRef, renderer: Renderer, componentsHelper: ComponentsHelper);
    ngOnInit(): void;
    changeModel(match: TypeaheadMatch): void;
    readonly matches: Array<any>;
    show(): void;
    hide(): void;
    private asyncActions();
    private syncActions();
    private normalizeOption(option);
    private normalizeQuery(value);
    private testMatch(match, test);
    private finalizeAsyncCall(matches);
    private prepareMatches(options);
    private hasMatches();
}
