"use strict";
var core_1 = require('@angular/core');
var accordion_config_1 = require('./accordion.config');
var AccordionComponent = (function () {
    function AccordionComponent(config) {
        /* tslint:disable:no-unused-variable */
        this.addClass = true;
        /* tslint:enable:no-unused-variable */
        this.groups = [];
        Object.assign(this, config);
    }
    AccordionComponent.prototype.closeOtherPanels = function (openGroup) {
        if (!this.closeOthers) {
            return;
        }
        this.groups.forEach(function (group) {
            if (group !== openGroup) {
                group.isOpen = false;
            }
        });
    };
    AccordionComponent.prototype.addGroup = function (group) {
        this.groups.push(group);
    };
    AccordionComponent.prototype.removeGroup = function (group) {
        var index = this.groups.indexOf(group);
        if (index !== -1) {
            this.groups.splice(index, 1);
        }
    };
    AccordionComponent.decorators = [
        { type: core_1.Component, args: [{
                    selector: 'accordion',
                    template: "<ng-content></ng-content>"
                },] },
    ];
    /** @nocollapse */
    AccordionComponent.ctorParameters = [
        { type: accordion_config_1.AccordionConfig, },
    ];
    AccordionComponent.propDecorators = {
        'closeOthers': [{ type: core_1.Input },],
        'addClass': [{ type: core_1.HostBinding, args: ['class.panel-group',] },],
    };
    return AccordionComponent;
}());
exports.AccordionComponent = AccordionComponent;
